/*

/////////////////////////////////////////////////////////////////////////
//                                                                     //
//                                                                     //
//                  Global Public Licence (GPL)                        //
//                                                                     //
//                                                                     //
// This license described in this file overrides all other licenses    //
// that might be specified in other files for this library.            //
//                                                                     //
// This library is free software; you can redistribute it and/or       //
// modify it under the terms of the GNU Lesser General Public          //
// License as published by the Free Software Foundation; either        //
// version 2.1 of the License, or (at your option) any later version.  //
//                                                                     //
// This library is distributed in the hope that it will be useful,     //
// but WITHOUT ANY WARRANTY; without even the implied warranty of      //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU   //
// Library General Public License for more details.                    //
//                                                                     //
// You should have received a copy of the GNU Lesser General Public    //
// License along with this library (see COPYING.LIB); if not, write to //
// the Free Software Foundation :                                      //
//                      Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  //
//                                                                     //
/////////////////////////////////////////////////////////////////////////

*************************************************************************
*                                                                       *
*                 Auto Extractable Code Program.                        *
*                                                                       *
*                  Version V1.0 of 31-JAN-2005                          *
*                                                                       *
*                                                                       *
*           by                                                          *
*                                                                       *
*               Charles Wolfers                                         *
*                   e-mail: ch.wolfers@laposte.net                      *
*                                                                       *
*           and                                                         *
*                                                                       *
*               Pierre Wolfers                                          *
*                   CNRS - Laboratoire de Cristallographie,             *
*                   B.P 166, 25 Avenue des martyrs,                     *
*                   F 38042 GRENOBLE CEDEX 9, FRANCE.                   *
*                   e-mail: pierre.wolfers@grenoble.cnrs.fr             *
*                                                                       *
*                                                                       *
*                                                                       *
*************************************************************************

*/

/** For Windows WIN32 API Adaptation for file mode open **/
#ifndef O_BINARY
# define O_BINARY 0
#endif

#ifdef _WIN32
/* For Windows mkdir has One parameter */
# define MKDIR_PROT
# define PATHSEP ';'
/* For Windows for a Console Program we must use a spawnvp API to call the next program */
# define SPAWN_FLG
#else
/* For Unix and VMS mkdir has two parameter (second one is the protection) */
# define MKDIR_PROT , 0755
# define PATHSEP ':'
#endif


#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>

#include <zlib.h>               /* To uncompress any compressed file */


#define BUFF_SIZE   4096        /* Size of the read/write Buffer */
#define PATH_SIZE    128        /* Size of string for the Path */

typedef struct {                /* Data File descriptor Record definition */
                 char fd_name[60];      /* File Name (maximum of 59 characters length) */
                 int      fd_size;      /* Size of file in bytes */
               } fdescr;

typedef char *      vptr;       /* Define the pointer of character */


int                  fex,       /* Executable file descriptor */
                     out,       /* Output file descriptor */
                    tord,       /* Numebr of byte to read for the current file */
                    pend,       /* Command record seek number in the Executable file */
                    pcur,       /* Position in Executable file */
                    lenb,       /* Read length */
                    flen,       /* Current File to extract length */
                    cflg,       /* Compression file flag */
                    pcnt,       /* Parameter count */
                    ierr;       /* Error code return */

char      buf[BUFF_SIZE],       /* Data Buffer */
          ddf[PATH_SIZE],       /* String to keep the path of directory where put the files */
          rep[PATH_SIZE];       /* String as type-in by the installer user */

fdescr           fldescr,       /* Current Data File Descriptor */
                 cmdrecd;       /* Command to execute */

char       *   partb[16];       /* Execv Command parameter table */



int main( int argc, char * argv[], char * env[] )
{
  char cstr[] = " compressed ";
  char spac[] = " ";
  vptr sc, scv;
  char ** pce;
  char ch;
  char dflg;

  struct stat pbf;
  int  ie, ii, ij, verb;

  verb   = 0;
  ddf[0] = 0;
  dflg   = 0;
  for (ii=1;ii<argc;ii++) {
    sc = argv[ii];
    if (sc) {
      if ((sc[0] == '-')&&(sc[1] == 'v')) verb = 1;
      else {
        ij = 0;
        do {
          ddf[ij] = sc[ij];
          ij++;
        } while (sc[ij] > ' ');
        ddf[ij] = 0;
        dflg = 1;
      } 
    }
  }

  fex = open( argv[0], O_RDONLY|O_BINARY );
  if (fex < 0) {
    printf( " %%%%%%Auto-Extract Cannot open its Executable file <%s>.\n", argv[0] );
    exit( 2 );
  }

  ierr = fstat( fex, &pbf );    /* Should not generate error */

  if (verb) printf( " *  Exec file size = %d\n", (int)pbf.st_size );

  /* Go to at the End-Of-File to read the Data Begin Seek Number */
  pend = pbf.st_size - sizeof( fdescr ) - PATH_SIZE;
  ierr = lseek( fex, (off_t) pend, SEEK_SET );
  if (ierr <= 0) {
    printf( " *  Auto-Extract Cannot Go to Data Part of Executable file.\n" );
    exit( 2 );
  }

  ierr = read( fex, ddf, PATH_SIZE );           /* Get the  Default directory of Data Files */
  if (ierr != PATH_SIZE) goto ET_IOERR1;

ET_GETDIR:
  if (!dflg) {
    printf( "\n *  >>> Please specify your prefered temporary directory [%s]\n", ddf );
    printf( " *  >>> Your choice (a single enter implied the default) " );
    fgets( rep,  PATH_SIZE, stdin );
    if (rep[0] > ' ') {
      ii = 0;
      ij = 0;
      do {
        ch = rep[ij++];
        if (ch >= ' ') ddf[ii++] = ch;
      } while (ch >= ' ');
      ddf[ii] = '\0';
    }
  } else printf( "\n The target directory argument was <%s> \n", ddf );
  
  ierr = stat( ddf, &pbf );                             /* Check for directory exist */
  if (ierr) { /* Stat error, we assume directory does not exist */
    if (!dflg) {
      printf( " -  >>> The directory <%s> seems to be not existing, do you want to create it (y/n)[default:y]? ", ddf );
      fgets( rep, PATH_SIZE, stdin );
      if ((rep[0] == 'n')||(rep[0] == 'N')) goto ET_GETDIR;
    } else printf( "  -  >>> The directory <%s> seems to be not existing, we try to create it\n", ddf );
    ierr = mkdir( ddf MKDIR_PROT );
  } else { /* Something exist with this name */
    if (!S_ISDIR( pbf.st_mode)) {
      if (!dflg) printf( " -  >>> The object <%s> is not a directory, please give an other choice.\n", ddf );
      else {
        printf( " %%%%%%Auto-Extract Cannot create the command specified directory <%s>/n", ddf );
        exit( 2 );
      }
      goto ET_GETDIR;
    }
  }
  ierr = chdir( ddf );
  if (ierr) {
    printf( " -  >>> The directory <%s> cannot be opened, sorry.\n", ddf );
    goto ET_GETDIR;
  }
  
  ierr = read( fex, &cmdrecd, sizeof( fdescr ) );       /* Get the origin of Data Seek Number */
  if (ierr != sizeof( fdescr )) goto ET_IOERR1;

  if (verb) {
    printf( " *  The Extracted File will be written in <%s>\n\n" , ddf );
    printf( " *  Data Begin Seek Number = %d\n", (int)cmdrecd.fd_size );
    printf( " *  End Command to execute = <%s>.\n", cmdrecd.fd_name );
  }

  pcur = cmdrecd.fd_size;
  ierr = lseek( fex, (off_t) pcur, SEEK_SET );          /* Go to the begin of Data */
  if (ierr <= 0) {
    printf( " %%%%%%Auto-Extract Cannot Seek to Begin of Data Part.\n" );
    exit( 2 );
  }

  if (verb) printf( " *  Read the Data from %d.\n", ierr );  

  /* Loop on all Files */
  while (pcur < pend) {
    lenb = read( fex, &fldescr, sizeof( fdescr ) );
    if (lenb < sizeof( fdescr )) {  ie = 1; break; }
    pcur += lenb;

    /* Open the Output File */
    flen = fldescr.fd_size;
    if (flen < 0) { flen = - flen; cflg = 1; sc = cstr; }
             else { cflg = 0; sc = spac; }

    if (verb) printf( " *  Extract%sthe file <%s> of %d bytes length.\n", sc, fldescr.fd_name, flen );

    out = open( fldescr.fd_name, O_WRONLY|O_CREAT|O_TRUNC|O_BINARY, 0755 );

    /* cflg == 1 => The file is compressed -- The compressed mode is not presently implemented */

    /* Copy the data to the output specified file */
    while (flen > 0) {
      tord = (flen > BUFF_SIZE)?BUFF_SIZE:flen;
      lenb = read( fex, buf, tord );
      if (lenb <= 0) break;
      if ((ierr = write( out, buf, lenb )) < lenb) {  ie = 2; break; }
      flen -= lenb;
      pcur += lenb;
    }
    close( out );
  }

  if ((flen > 0)||(pcur < pend)) {
    printf( " %%%%%%Auto-Extract Stop the File Extraction code (%d) on an I/O ERROR or EOF.\n", ie );
    exit( 2 );
  }

  if (verb) printf( " End of Auto-Extract.\n" );

  /* Insert in first the local directory in the current PATH */
  sc = (char *) getenv( "PATH" );
  if ((sc[0]!='.')||(sc[1] != PATHSEP)) {
    scv = sc - 5;           /* To get the address of "PATH=..." */
    pce = env;
    while ((*pce != NULL)&&(*pce != scv)) pce++; /* Locate the PATH Variable */
    *pce = buf;             /* Do export the new PATH by change of address */
    /* We must insert the local directory at the haed of PATH */
    buf[0] = 'P'; buf[1] = 'A'; buf[2] = 'T'; buf[3] = 'H';
    buf[4] = '='; buf[5] = '.'; buf[6] = PATHSEP;
    ii = 7; ij = 0;
    while ((buf[ii++] = sc[ij++])) ;
    /* putenv( rep ); */
  }

  /* Prepare the argument list from the command string */
  if (cmdrecd.fd_name[0]) {
    if (verb) printf( " *  Start the process command <%s>\n", cmdrecd.fd_name );
    pcnt = 0;
    ie   = 1;
    ij   = 0;
    while ((ch = cmdrecd.fd_name[ij]) != 0) {
      if (ch > ' ') {
        if (ie) { ie = 0; partb[pcnt++] = cmdrecd.fd_name+ij; }
      } else {
        ie = 1; cmdrecd.fd_name[ij] = 0;
      }
      ij++;
    }
    for (ij = pcnt; ij < 16; ij++) partb[ij] = NULL;

    /* Execute the command without using a shell */
#ifdef _WIN32

# ifdef SPAWN_FLG

    /* To use for Console Program with Window. */
    ie = spawnvpe( P_WAIT, partb[0], (const char * const *) partb, (const char * const *) env );
    if (ie == 0) exit ( 0 );

# else

    ie = execvpe( partb[0], (const char * const *) partb, (const char * const *) env );

# endif
#else

    ie = execvpe( partb[0], partb, env );

#endif

    printf( " %%%%%%Auto-Extract Cannot execute the specified command.\n" );
    exit( 2 );
  }

  printf( " %%%%%% Auto-Extract Normal End.\n" );
  exit( 0 );

ET_IOERR1:
  if (ierr != sizeof( fdescr )) {
    printf( " %%%%%%Auto-Extract Cannot Read the Default Dir. or the Data begin Seek Number.\n" );
    exit( 2 );
  }
  return 0;
}
