(*

/////////////////////////////////////////////////////////////////////////
//                                                                     //
//                                                                     //
//                  Global Public Licence (GPL)                        //
//                                                                     //
//                                                                     //
// This license described in this file overrides all other licenses    //
// that might be specified in other files for this library.            //
//                                                                     //
// This library is free software; you can redistribute it and/or       //
// modify it under the terms of the GNU Lesser General Public          //
// License as published by the Free Software Foundation; either        //
// version 2.1 of the License, or (at your option) any later version.  //
//                                                                     //
// This library is distributed in the hope that it will be useful,     //
// but WITHOUT ANY WARRANTY; without even the implied warranty of      //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU   //
// Library General Public License for more details.                    //
//                                                                     //
// You should have received a copy of the GNU Lesser General Public    //
// License along with this library (see COPYING.LIB); if not, write to //
// the Free Software Foundation :                                      //
//                      Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  //
//                                                                     //
/////////////////////////////////////////////////////////////////////////

*************************************************************************
*                                                                       *
*                 Auto Extractable Code Program.                        *
*                                                                       *
*                  Version V1.0 of 31-JAN-2005                          *
*                                                                       *
*                                                                       *
*           by                                                          *
*                                                                       *
*               Charles Wolfers                                         *
*                   e-mail: ch.wolfers@laposte.net                      *
*                                                                       *
*           and                                                         *
*                                                                       *
*               Pierre Wolfers                                          *
*                   CNRS - Laboratoire de Cristallographie,             *
*                   B.P 166, 25 Avenue des martyrs,                     *
*                   F 38042 GRENOBLE CEDEX 9, FRANCE.                   *
*                   e-mail: pierre.wolfers@grenoble.cnrs.fr             *
*                                                                       *
*                                                                       *
*                                                                       *
*************************************************************************

*)

program CREATE_SELF_EXTRACT( input, output );

(*
  #include <zlib.h>                          { To uncompress any compressed file }
*)


%include 'PASENV:cpas_d__sdir_env';          { To Get the directory scan rotine definitions }


const
  PATH_SIZE =  128;                          { Path size of default data extractor directory }
  max_nfile =   32;                          { Maximum of file to insert from the command line }
  max_naml  =   59;                          { Usable size of a file name }
  descr_sz  = cc__int"size + max_naml + 1;   { Size of fdescr record type in bytes }

  merr_head = ' %%% SLFC_ERROR : '; { Head of Error Message }


type
  fdescr = record case boolean of            { * Data File descriptor Record definition }
             false:( fd_tab: array[1..descr_sz] of char);  { Table for writing each bytes of descriptor }
             true:(  fd_name: array[0..max_naml] of char;  { File Name (maximum of 59 characters length) }
                     fd_size: cc__int)                     { Size of file in bytes }
           end;

  flbin  = file of char;                     { Type of file to get as data file }


var
  fldescr,                                   { Current file descriptor }
  cmdrecd:   fdescr;                         { Commande and Data begin Seek Number }

  fsize,                                     { Size of Self extractor file }
  nfile,                                     { Number of File specification to insert }
  ierr:      integer := 0;                   { Error Code }

  outo,                                      { Flag for out file opened }
  verb,                                      { flag for verbose mode }
  cflg:      boolean;                        { Flag for file compression }

  ddf:       string( PATH_SIZE );            { Default Directory to extract data files }

  list_fspc,                                 { Indirect text file specif. for list of data file specif. }
  extractor,                                 { File extractor file specification }
  self_extr,                                 { Self extractor file specification to create }
  curr_file: string := '';                   { Current File specification to insert } 

  filetb:    array[1..32] of ^string;        { Table of file to insert in option list }

  listf:     text;                           { List of file specification to insert }

  i, j:      integer;                        { integer for small jobs }

  currf,                                     { Current file to insert }
  extrf,                                     { Empty Extractor Executable File }
  outfl:     flbin;                          { Self Extractor Executable file to create }






function FILE_ERROR_HANDLER( nerr: cc__int ): cc__int;
{ To Trap any Error and leave a clean state before to go toPascal Standard action }
begin
  if (nerr >= 200) and (nerr < 300) then
    WRITELN( merr_head, 'I/O Error Trap with Pascal code ', nerr:0, '.' );
  if outo then
  begin
    CLOSE( outfl );                              { Close and delete the output file }
    FILE_REMOVE( self_extr, [case_ena_file] );   { Remove the partial created file }
    outo := false;
    WRITELN( ' %%% SLF_TRAP on Error => Self Extracted Executable file was removed.' )
  end;
  FILE_ERROR_HANDLER := -1                       { Continue to Pascal Standard Action }
end FILE_ERROR_HANDLER;



procedure SLF_EXIT;
{ To delete the self-extracted file and stop the program  }
begin
  if outo then
  begin
    CLOSE( outfl );                              { Close and delete the output file }
    FILE_REMOVE( self_extr, [case_ena_file] );   { Remove the partial created file }
    WRITELN( ' ===> Self Extracted Executable file was removed.' )
  end;
  PASCAL_EXIT( 2 )                               { Program exit }
end SLF_EXIT;



procedure SETPARAMS;
var
  ii, id, ierr: integer;
  sopt, sparm: string;

begin
  { Try to get the Empty Extractor Executable from the Standard Environment variable } 
  if GET_LOGICAL( extractor, 'KIT_EXTRACTOR' ) <> 0 then extractor.length := 0;
  cmdrecd.fd_name[0] := CHR( 0 );
  cmdrecd.fd_size    :=        0;
  verb               :=    false;
  outo               :=    false;

  { The default extract directory is set for each kind of operating system where we are running }
  case sys_system of
    systyp_mosx,
    systyp_cygw,
    systyp_unix: ddf :=   'tmp/';
    systyp_wind: ddf :=   'tmp\';
  otherwise
    ddf :=   'tmp/';
  end;

  ii := 1;
  nfile := 0;
  while ii < argc do
  begin
    sparm := argv[ii]^;
    ii := ii + 1;
    if sparm[1] = '-' then
    begin
      id := INDEX( sparm, '=' );
      if id <= 2 then id := INDEX( sparm, ':' );
      if id > 2 then begin  sopt := SUBSTR( sparm,  2, id - 2 ); sparm := SUBSTR( sparm, id + 1 )  end
                else begin  sopt := SUBSTR( sparm, 2 ); sparm := ''  end;
      case sopt[1] of
        'e', 'E':
          { -e=<extractor_exec> to specify the extractor executable to use }
          if sparm.length > 0 then extractor := sparm;

        'o', 'O', 'f', 'F':
          { -f=<self_extractor_exec> to specify the self extractor executable to create }
          if sparm.length > 0 then self_extr := sparm;

        'c', 'C':
          { -c=<exec_command_string> to specify the EXEVP command to execute at end of extractor run }
          if sparm.length > 0 then 
          begin
            if sparm.length > max_naml then
            begin
              WRITELN( merr_head, 'Too long command "', sparm, '".' );
              SLF_EXIT
            end;
            WRITELN( ' *** The Install Command "', sparm, '" will be registred in the Auto Extract file.' ); 
            id := 0;
            while id < sparm.length do
            begin
              cmdrecd.fd_name[id] := sparm[id+1];
              id := id + 1
            end;
            cmdrecd.fd_name[id] := CHR( 0 )
          end;

        'd', 'D':
          { -d=<default_directory_path> to specify the default directory to use to put the data files }
          if sparm.length > 0 then
            if sparm.length >= PATH_SIZE then
            begin
              WRITELN( merr_head, 'Too long command Default Extract Path "', sparm, '".' );
              SLF_EXIT
            end
            else
            begin
              ddf := sparm;
              for ii := sparm.length + 1 to PATH_SIZE do ddf.body[ii] := CHR( 0 )
            end;

        'i', 'I':
           { -i=<list_data_file_file_spc> to give a list of files in a file }
          if sparm.length > 0 then
          begin
            list_fspc := sparm;
            if not FILE_ACCESS_CHECK( list_fspc ) then
            begin
              WRITELN( merr_head, 'Indirect File "', list_fspc, '" undefined.' );
              SLF_EXIT
            end
          end;

        'v', 'V':
           { Set the verbose mode }
           verb := true;

        'h', 'H':
           { help informations }
          begin
            WRITELN;
            WRITELN( ' Help of Create_Self_Extractable Executable V1.0' );
            WRITELN;
            WRITELN( ' Form of command : "create_selfextract <option_list> <file_spc> <file_spc> ... "' );
            WRITELN( ' *  <option_list> ::= <option> <option> <option>;;' );
            WRITELN( ' *  <file_spc> is a file or directory specification or a wild file specification.' );
            WRITELN( ' *  *  - When a directory is specified all the regular file in the directory will' );
            WRITELN( ' *  *  be put in the self extraction executable file,  but the included directory' );
            WRITELN( ' *  *  will be ignored.' );
            WRITELN;
            WRITELN( ' Then different options can be :' );
            WRITELN( '   -h or -H         without parameters to get this text.' );
            WRITELN;
            WRITELN( '   -e or -E         form : "-e=<empty_extr_exec_file>" .' );
            WRITELN( '      <empty_extr_exec_file> is the empty extractor executable to use' );
            WRITELN( '      to create the self extractable executable file. A default empty' );
            WRITELN( '      extractor executable file  can be  specified by the environment' );
            WRITELN( '      variable KIT_EXTRACTOR.' );
            WRITELN( '          Example: "export KIT_EXTRACTOR=extractor"' );
            WRITELN( '      if the environment variable is not defined, this option must be' );
            WRITELN( '      used.' );
            WRITELN;
            WRITELN( '   -o, -O, -f or -F form : "-o=<self_extractor_file>" .' );
            WRITELN( '      <self_extractor_file> is the self extractor file to create.' );
            WRITELN( '      You must  specify  this  output file.  When  this option is not' );
            WRITELN( '      specified before the first <file_spc>,  the first <file_spc> is' );
            WRITELN( '      used as self extractor file specification.' );
            WRITELN;
            WRITELN( '   -c, -C,          form : "-c=<execvp_command_fstring>" .' );
            WRITELN( '      <execvp_command_fstring> is the command to use (via execvp API)' );
            WRITELN( '      to start the installation processus from the extracted package.' ); 
            WRITELN;
            WRITELN( '   -d, -D,          form : "-d=<default_dir_path>" .' );
            WRITELN( '      <default_dir_path> is the default path for extracted files.' );
            WRITELN( '      when this option is not used,  the default is tmp directory in' );
            WRITELN( '      the current directory (a not recommanded use).' );
            WRITELN;
            WRITELN( '   -i, -I,          form : "-i=<indirect_file_spc>" .' );
            WRITELN( '      <indirect_file_spc> is  the specification  of an indirect file' );
            WRITELN( '      that is a list of file specification (one by line)  where  all' );
            WRITELN( '      line begining by one of "#", ";" or "!" character is ignored.' );
            WRITELN;
            WRITELN( '   -v, -V,          without parameters to set the verbose mode.' );
            WRITELN;
            PASCAL_EXIT( 0 )
          end;

      otherwise
        WRITELN( merr_head, 'Unknown Option "', sopt, '".' );
        SLF_EXIT
      end
    end
    else
    begin
      if self_extr.length = 0 then self_extr := sparm
      else
        if nfile < max_nfile then
        begin
          nfile := nfile + 1;
          filetb[nfile] := argv[ii-1]
        end
        else
        begin
          WRITELN( merr_head, 'File Specification Table Overflow.' );
          SLF_EXIT
        end
    end
  end;
  if extractor.length = 0 then
  begin
    WRITELN( merr_head, 'Extractor File unspecified.' );
    SLF_EXIT
  end
  else
    if not FILE_ACCESS_CHECK( extractor ) then
    begin
      WRITELN( merr_head, 'Extractor Code File "', extractor, '" undefined.' );
      SLF_EXIT
    end;

  if self_extr.length = 0 then
  begin
    WRITELN( merr_head, 'Self Extractor File name unspecified.' );
    SLF_EXIT
  end;

  { Create the self extractable file }
  OPEN( outfl, self_extr, [write_file,case_ena_file] );
  outo := true
end SETPARAMS;



procedure COPY_EXTRACTOR;
begin
  fsize := 0;
  { Open the Empty Extractor executable file }
  OPEN( extrf, extractor, [read_file,case_ena_file] );
  while not EOF( extrf ) do
  begin  outfl^ := extrf^; GET( extrf ); PUT( outfl ); fsize := fsize + 1  end;
  CLOSE( extrf );
  cmdrecd.fd_size := fsize;             { Keep the SEEK position of DATA begining }
  if verb then WRITELN( ' - The SEEK Number of Data begining is ', fsize:0 )
end COPY_EXTRACTOR;



procedure COPY_FILE( in_var fname: string; idir: integer );
var
  i1, i2: integer;
  namf:   string( max_naml );
  tbi:    array[1..4] of cc__int;

begin
  { Extract the filename of the file specification of form ...<ch><filename> }
  { with <ch> is ":" for device, or ("/" or "\" or "]") for directory.       }
  i1 := INDEX( fname, '/', -1 );
  i2 := INDEX( fname, '\', -1 );
  if i2 > i1 then i1 := i2;
  i2 := INDEX( fname, ']', -1 );
  if i2 > i1 then i1 := i2;
  if i1 = 0 then i1 := INDEX( fname, ':', -1 );
  if i1 = 0 then namf := fname
            else namf := SUBSTR( fname, i1+1 );
  if namf.length > max_naml then
  begin
    WRITELN( merr_head, 'Too long file specification "', fname, '".' );
    SLF_EXIT
  end;
  { Put the filename in the file descriptor }
  i1 := 0;
  while i1 < namf.length do
  begin
    fldescr.fd_name[i1] := namf[i1 + 1];
    i1 := i1 + 1
  end;
  fldescr.fd_name[i1] := CHR( 0 );

  { Check for access }
  if not FILE_ACCESS_CHECK( fname ) then
  begin
    WRITELN( merr_head, 'Inserted File "', fname, '" undefined.' );
    SLF_EXIT
  end;

  { Get the Size and the kind of the File to read }
  i2 := GET_FILE_INFO( fname, tbi, true, true, [case_ena_file] );
  i1 := GET_FILE_KIND( tbi[1] ); { Get the file kind }
  case i1 of
    1: { Regular file }
      begin
        fldescr.fd_size := tbi[2];  { Put the length in the descriptor }

        { Copy the File }
        OPEN( currf, fname, [read_file,case_ena_file] );
        if verb then
          WRITELN( ' ':idir, '--> Put "', namf, '" File Descr. at ', fsize:0, ' with file size of ', tbi[2]:0 );
        for i := 1 to descr_sz do
        begin  outfl^ := fldescr.fd_tab[i]; PUT( outfl ); fsize := fsize + 1  end;
        while not EOF( currf ) do
        begin  outfl^ := currf^; GET( currf ); PUT( outfl ); fsize := fsize + 1  end;
        CLOSE( currf )
      end;

  otherwise
    { Nothing to do entry ignored }
    if verb then WRITELN( ' %%% SLFC_WARNING: File Entry "', fname, '" Ignored (not a regular file).' ) 
  end
end COPY_FILE;



procedure COPY_WILD_FILE( in_var wfspc: string; idir: integer );
var
  filtr: efb_ptr;   { Complet Filtre pointer definition }
  path,             { the Complete Path to use }
  fname: string;    { Current fdirectory file entry }
  inat:  integer;   { Code for nature of entry }
  bok:   boolean;   { Flag for not empty/incorrect request }

begin
  bok := false;
  filtr := FSPC_OPEN( wfspc, [case_ena_file] );
  if filtr <> nil then
  begin
    loop
      FSPC_SCAN( filtr, fname, inat );
    exit if inat < 0;
      case inat of
        0: { Directory }
          if idir = 1 then
          begin
            if verb then WRITELN( ' --- Begin of Scan Directory "', fname, '"' );
            fname := fname||'/*'; COPY_WILD_FILE( fname, idir + 2 );
            if verb then WRITELN( ' --- End of Scan Directory.' );
            bok := true
          end;

        1: { Regular file }
          begin
            COPY_FILE( fname, idir );
            bok := true
          end;

      otherwise
      end
    end;
    FSPC_CLOSE( filtr );
    if not bok or (inat <> -1) then
    begin
      WRITELN( merr_head, 'File path "', wfspc, '" undefined.' );
      SLF_EXIT
    end
  end
end COPY_WILD_FILE;



begin { Main }
  { Install the error Handler }
  ESTABLISH( FILE_ERROR_HANDLER );

  { Get all Task Parameter/options }
  SETPARAMS;

  { Copy the Extractor code in first }
  COPY_EXTRACTOR;

  { Copy all command file specification }
  for iii := 1 to nfile do COPY_WILD_FILE( filetb[iii]^, 1 );

  { Copy all specified file in an indirect file }
  if list_fspc.length > 0 then
  begin
    { Open the Empty Extractor executable file }
    OPEN( listf, list_fspc, [read_file,case_ena_file] );
    while not EOF( listf ) do
    begin
      READLN( listf, curr_file );
      if curr_file.length > 0 then
      begin
        if INDEX( '!;#', curr_file[1] ) = 0 then
        with curr_file do
        begin
          { No comment }
          { Loop to eliminate the front space }
          if body[1] <= ' ' then
          begin
            i := 0; j := 1;
            while j <= length do
            begin
              if (i > 0) or (body[j] > ' ') then
              begin  i := i + 1; body[i] := body[j] end;
              j := j + 1
            end;
            length := i
          end;
          { Elliminate also the training space }
          i := length;
          while (i > 0) and (body[i] <= ' ') do i := i - 1;
          length := i;
          if i > 0 then COPY_WILD_FILE( curr_file, 1 )
        end
      end
    end;
    CLOSE( listf )
  end;

  { Write the Final Descriptor }
  if verb then WRITELN( ' - Put Default Extract Directory "', ddf, '" at ', fsize:0 );
  for i := 1 to PATH_SIZE do
  begin  outfl^ := ddf.body[i]; PUT( outfl ); fsize := fsize + 1  end;

  if verb then WRITELN( ' - Put Command String and Start Seek Number at ', fsize:0 );
  for i := 1 to descr_sz do
  begin  outfl^ := cmdrecd.fd_tab[i]; PUT( outfl ); fsize := fsize + 1  end;
  CLOSE( outfl );
  if verb then WRITELN( ' - The Total Self extractable file size is ', fsize:0 );

  WRITELN( ' %%% SLFC_EXIT : Normal End of Create_Self_Extract "', self_extr, '".' )
end CREATE_SELF_EXTRACT.
