program SORT( input, output );
{ PROGRAM TO SORT OUTPUT REFLEXIONS FROM COLL5 }
const
  maxcol = 20;                    { Maximum number of column }
  deuxpi = 6.2831854;             { 2*pi }
  inrd   = 0.0174532931;          { pi/180 }

type

  tline = string( 255 );          { Input line type }

  str   = string(  64 );          { File name format }

  ptr = ^triplet;

  triplet = record
    lp, rp:  ptr;                 { Right and left link pointers }
    h, k, l: integer;             { Reflexion indexes }
    f2, sg:  real;                { Observation and sigma }
    valtab:  array[1..7] of real; { Related values }
    stsl:    real                 { Module de h }
  end;

var
  par:       array[1..6] of real; { To get unit cell parameters }
  endstr:    str;                 { End work string }

  i, j, ip, iq, il,               { Index in input line }
  idh, idk, idl,                  { Position index of h, k, l in coltb }
  ith,                            { Position of theta in coltb }
  ide, ids,                       { Position index of obs and sigma }
  icol,                           { Number of column in input file }
  icol1,                          { Number of user output column }
  icmp,                           { 0 => =, 1 => >, -1 => < }
  nref,                           { Sorted reflexion count }
  nsequ,                          { Sequence reflexion number }
  eis,                            { Experimental flag }
  hc, kc, lc: integer;            { Current HKL Indexes }

  lambda,                         { Wave length }
  sal, sbe, sga, vol,             { Temporaries for Metric Tensor computing }
  ra, rb, rc, ral, rbe, rga,      { Reciprocal Unit Cell parameters }
  dc,                             { Current d = 1/n* }
  ef2, esg,                       { F square and sigma }
  eomega,                         { Euler angle Omega }
  echi,                           { Euler angle Chi }
  a, b, c, al, be, ga: real;      { Direct Unit Cell parameters }

  p,                              { Current HKL pointer }
  p1, p2,                         { Micellious pointeurs }
  g: ptr;                         { Root of HKL tree }
 
  inpline: tline;                 { Current Input Line }

  colpos,                         { Column Position and Column indexes }
  colnb: array[1..maxcol] of integer;

  coltb: array[1..maxcol] of real;{ Value for Each Column }

  inname, outname: str;	          { Input and Output file names }

  inp,                            { Input Text file }
  out: text;                      { Output Text file - Sorted }




function STR_GET_CHAR( var st: string; var ip: integer ): char;
begin
  if ip < st.length then
  begin
    ip := ip + 1; STR_GET_CHAR := st[ip]
  end else STR_GET_CHAR := ';'
end { STR_GET_CHAR };


function STR_GET_REAL( var st: string; var ip: integer ): real;
const
  tab = CHR( 9 );

var
  val, fac, ffd: real;
  i:             integer;
  ch:            char;
  bneg:          boolean;

begin
  val := 0.0;
  bneg := false;
  ch := ' ';
  while (ch = ' ') or (ch = tab) do ch := STR_GET_CHAR( st, ip );
  if ch = '+' then
    ch := STR_GET_CHAR( st, ip )
  else
    if ch = '-' then
    begin
      bneg := true;
      ch := STR_GET_CHAR( st, ip )
    end;
  while ( ch >= '0' ) and ( ch <= '9' ) do
  begin
    val := val*10.0 + (ORD( ch ) - ORD( '0' ));
    ch := STR_GET_CHAR( st, ip )
  end;
  if ch = '.' then
  begin
    fac := 0.1;
    ch := STR_GET_CHAR( st, ip );
    while ( ch >= '0' ) and ( ch <= '9' ) do
    begin
      val := val + fac*(ORD( ch ) - ORD( '0' ));
      fac := fac*0.1;
      ch := STR_GET_CHAR( st, ip )
    end
  end;
  if (ch = 'e') or (ch = 'E') then
  begin
    ch := STR_GET_CHAR( st, ip );
    fac := 1.0;
    ffd := 10.0;
    i := 0;
    if ch = '+' then ch := STR_GET_CHAR( st, ip )
    else
      if ch = '-' then
      begin
        ffd := 0.1; ch := STR_GET_CHAR( st, ip )
      end;
    while ( ch >= '0' ) and ( ch <= '9' ) do
    begin
      i := i*10 + (ORD( ch ) - ORD( '0' ));
      ch := STR_GET_CHAR( st, ip )
    end;
    while i > 0 do
      if ODD( i ) then
      begin
        i := i - 1; fac := fac*ffd
      end
      else
      begin
        ffd := SQR( ffd ); i := i div 2
      end;
    val := val * fac
  end;
  if bneg then val := -val;
  STR_GET_REAL := val
end { STR_GET_REAL };


function DIST( h, k, l: integer ): real;
begin
  dist :=  0.5*SQRT(SQR(ra*h) + SQR(rb*k) + SQR(rc*l) +
	      2.0*(ral*rb*rc*k*l + rbe*rc*ra*l*h + rga*ra*rb*h*k))
end { DIST };


function GETNUMBER: real;
{ inpline is the input line, iq is the character index }
var
  i, ip0:  integer;
  bl: boolean;
  s1: tline;
  v:  real;


begin
  if iq = 0 then                  { Line begin }
  begin
    inpline := inpline || ' ';    { Add a trailing space }
    il := LENGTH( inpline );      { Size the line }
    if il <= 1 then iq := -1      { End of line reached } else
    begin
      bl := false; iq := 0;
      for i := 1 to il do
      begin
	if bl and (inpline[i] <= ' ') then
	begin
	  bl := false;
	  if iq < 12 then
          begin
	    iq := iq + 1;
            colnb[iq] := i-1
	  end
	end
	else
	  if not bl and (inpline[i] > ' ') then bl := true
      end;
      il := iq; iq := 1;
    end
  end;

  if iq <= 0 then v := 0 { end of line reached }
  else
  begin
    if iq = 1 then ip0 := 1
              else ip0 := colnb[iq-1]+1;
    v := STR_GET_REAL( inpline, ip0 );
    iq := iq + 1;
    if iq > il then iq := -1;
  end;
  GETNUMBER := v
end { GETNUMBER };


procedure OUTTRIPLET( pt: ptr );
var
  i: integer;

begin
  with pt^ do { avec le triplet courant faire }
  begin
    if lp <> nil then OUTTRIPLET( lp );
    if ith <= 0 then
    begin
      stsl := stsl*lambda;
      if stsl >= 0.9999 then stsl := 99.0
                        else stsl := ARCTAN( stsl/SQRT( 1.0-SQR( stsl ) ) )/inrd
    end;
    WRITE( out, ' ', h:4, k:4, l:4, ' ', f2:12, ' ', sg:12, stsl:8:3 );
    for i := 1 to icol1 do
      WRITE( out, valtab[i]:12:4); WRITELN( out );
    if rp <> nil then OUTTRIPLET( rp )
  end
end { OUTTRIPLET };

begin { MAIN }
  endstr := 'end';
  g      := nil; { initialise le graphe de tri a nil }
  WRITELN;
  WRITE( ' number of column for each line ' );  READLN( icol );
  WRITELN;
  if icol > maxcol then begin
    writeln(' columns above ', maxcol, '''th will be ignored.');
    icol := maxcol
  end;
  WRITE( ' Column number for h, k, l, obs, sigma are ? ');
  READLN( idh, idk, idl, ide, ids );
  WRITELN;
  WRITE( ' Theta column number in the input data(0 if not present) =' );
  READLN( ith );
  for i := 1 to icol do colpos[i] := -1;
  colpos[idh] := 0;
  colpos[idk] := 0;
  colpos[idl] := 0;
  colpos[ide] := 0;
  colpos[ids] := 0;
  if ith > 0 then colpos[ith] := 0;
  j := 1;

  { For all unused column allocate a column in the output line }
  for i := 1 to icol do
    if colpos[i] < 0 then
    begin
      colpos[i] := j;
      j := j + 1                  { Count of additional column }
    end;

  icol1 := j - 1;

  if ith <= 0 then
  begin
    WRITELN;
    WRITE( ' Wave length(in angstroem) = '); READLN( lambda ); 
    WRITELN( ' give the unit cell(angstroem and degrees or cosinus)' );
    READLN( a, b, c, al, be, ga );
    { When the angles are in degrees, we take the cosinus }
    if al > 1.0 then al := COS( inrd * al );
    if be > 1.0 then be := COS( inrd * be );
    if ga > 1.0 then ga := COS( inrd * ga );
    { compute the unit cell volume }
    sal := SQR( al ); sbe := SQR( be ); sga := SQR( ga );
    vol := a*b*c*SQRT( 1.0 + 2.0*al*be*ga-sal-sbe-sga );
    { compute the metric tensor }
    sal := SQRT( 1.0 - sal );
    sbe := SQRT( 1.0 - sbe );
    sga := SQRT( 1.0 - sga );
    ral := (be*ga - al)/(sbe*sga);
    rbe := (ga*al - be)/(sga*sal);
    rga := (al*be - ga)/(sal*sbe);
    ra := b*c*sal/vol; rb := c*a*sbe/vol; rc := a*b*sga/vol
  end;

  WRITELN;
  WRITE( ' Input file name = ' ); READLN( inname );

  nref := 0;
  WRITE( ' Output file name = ' ); READLN( outname );
  RESET( inp, inname );
  REWRITE( out, outname );
  while not EOF( inp ) do
  begin
    echi := 0.0; nsequ := 0;
    READLN( inp, inpline );       { read the input line }
    iq := 0; ip := 1;
    while ip <= icol do
    begin
      coltb[ip] := GETNUMBER;
      ip := ip + 1
    end;
    hc  := ROUND( coltb[idh] );
    kc  := ROUND( coltb[idk] );
    lc  := ROUND( coltb[idl] );
    ef2 := coltb[ide];
    esg := coltb[ids];
    if ith > 0 then
      dc := coltb[ith]            { get original theta }
    else
      dc := DIST( hc, kc, lc );   { calcul le 1/2d == module de h  }

    { now compact the line in the table number }
    for ip := 1 to icol do
      if colpos[ip] > 0 then coltb[colpos[ip]] := coltb[ip];
    nref := nref + 1;
    NEW( p );                     { allocate a new triplet }
    with p^ do                    { set the new triplet }
    begin
      lp   := nil;
      rp   := nil;                { init the graphe pointer }
      h    := hc;
      k    := kc;
      l    := lc;                 { set H K L indexes }
      stsl := dc;                 { Set 1/2d }
      f2   := ef2;
      sg   := esg;
      if stsl < 0.0 then stsl := -stsl;
      for i := 1 to icol1 do valtab[i] := coltb[i]
    end;
    { Build the triplet graph }
    p1 := g;                      { start the the tree root }
    p2 := nil;
    while p1 <> nil do
    begin
      icmp := ORD( dc <> p1^.stsl );
      p2   := p1;
      if icmp <> 0 then
        if dc < p1^.stsl then icmp := -1;
        if icmp < 0 then p1 := p1^.lp
                    else p1 := p1^.rp
    end { while };
    if p2 = nil then g := p
                else
                  if icmp < 0 then p2^.lp := p
                              else p2^.rp := p
  end { while not EOF( inp ) };
  if g <> nil then
    OUTTRIPLET( g ); { Print all triplet ins the increasing 1/2d order }
  CLOSE( inp );
  CLOSE( out );
  WRITELN;
  WRITELN( ' There are ', nref, ' sorted reflexions.' );
  WRITELN
end.
