{
  *************************************************************************
  *                                                                       *
  *                                                                       *
  *                                                                       *
  *                      MMM    MMM   XXX      XXX  DDDDDDDD              *
  *                      MMMM  MMMM    XXX    XXX   DDDDDDDDDD            *
  *                      MM MMMM MM     XXX  XXX    DD      DDD           *
  *                      MM  MM  MM      XXXXXX     DD       DD           *
  *                      MM      MM       XXXX      DD       DD           *
  *        T  H  E       MM      MM       XXXX      DD       DD           *
  *                      MM      MM      XXXXXX     DD       DD           *
  *                      MM      MM     XXX  XXX    DD      DDD           *
  *                      MM      MM    XXX    XXX   DDDDDDDDDD            *
  *                     MMMM    MMMM  XXX      XXX  DDDDDDDD              *
  *                                                                       *
  *                                                                       *
  *                                                                       *
  *              SSSSS Y     Y  SSSSS TTTTTTT EEEEEE M     M              *
  *             S       Y   Y  S         T    E      MM   MM              *
  *             S        Y Y   S         T    E      M M M M              *
  *              SSSS     Y     SSSS     T    EEEEE  M  M  M              *
  *                  S    Y         S    T    E      M     M              *
  *                  S    Y         S    T    E      M     M  ..          *
  *             SSSSS     Y    SSSSS     T    EEEEEE M     M  ..          *
  *                                                                       *
  *                                                                       *
  *                                                                       *
  *                                                                       *
  *                        P. WOLFERS Software                            *
  *                                                                       *
  *                  Laboratoire de Cristallographie                      *
  *                                                                       *
  *                         B.P. 166 C.N.R.S.                             *
  *                                                                       *
  *                      25 Avenue des Martyrs                            *
  *                                                                       *
  *                      F 38042 GRENOBLE CEDEX 9                         *
  *                                                                       *
  *                                                                       *
  *************************************************************************
}
program NONEQ( input, output );
{


                                N O N E Q


                              P R O G R A M



         To manage the Equivalent Reflections in Crystal Data Sets

       and generate :

                         - The Twin/Domains Expansion,

                         - and th Lambda/2 Harmonic hkl.


                  * * * * * * * * * * * * * * * * * * * * * *




}

{***********************************************}
{*    NONEQ constants and Types Definitions    *}
{***********************************************}

const

  { ***  NONEQ Constants Definitions  *** }

  def_szmax = 500;              { Default Number of Created HKL Record }


type

  { ***  NONEQ State Register Definitions  *** }

  fmod_flg = (                  { * Noneq Mode Type definitions }
               equave_md,       { Mode to Perform the equivalent reflection average }
               equexp_md,       { Mode to Perform the equivalent reflection expansion }
               equfri_md,       { Mode for Friedel pair suppressed }
               equhw2_md,       { Mode for Double Harmonic expansion }
               equwrt_md,       { Mode for Output file Setup }
               avesig_md,       { Flag to force sigma average to output file }
               hklout_md,       { Reflection Output on Listing File }
               hklful_md        { Full Reflection Output (use with hklout_md) }
             );

  fmod_typ = set of fmod_flg;   { NONEQ State mode }


  { ***  Operator, HKL, Group and HKL_table Definitions  *** }

  gope_typ  = array[1..3, 1..3] of integer; { Punctual Groupe operator Type }
  hkl_typ   = array[1..3] of integer;       { Reciprocal vector HKL Type }

  grptb_typ = array[1..48] of gope_typ;     { Groupe Element Table Type }
  equtb_typ = array[1..48] of hkl_typ;      { Equivalent HKL Table Type }


  { ***  HKL Record Types Definitions  *** }

  hklrec_ptr = ^hklrec_typ;     { HKL Record Pointer }

  hklrec_typ = record           { * HKL Triplet Record Definition }
    next: hklrec_ptr;           { Link to next one }
    hkl: hkl_typ;               { Reflection indicies h, k, l }
    ref,                        { Reflection Intensity/Squared_Structure_factor/Structure_factor ... }
    sig,                        { ... and related Sigma }
    th: real;                   { Bragg angle }
    tabvl: array[1..7] of real; { Additional values array }
  end;

  record_pt = record
    case boolean of
      true: (pt: hklrec_ptr);
      false: (int: integer);
  end;


{****************************************}
{*    NONEQ  Variables  Definitions     *}
{****************************************}

var
  nq_mode:    fmod_typ;             { NONEQ Function mode Flags Register }

  cbuf:       hklrec_typ;           { Record to read a reflection }

  line:       string( 255 );        { Input line Buffer }

  input_ref:  hklrec_typ;           { Input Record Definitions }


  { ***  Global Statistic Definitions  *** }

  thtol,                            { Theta Tolerance }
  sgmin,                            { Minimum Sigma }

  nchi2,                            { Squared Goodness of Group Validity }
  nrfac,                            { Group validity R-Factor }
  nnchi2,                           { Numerator of Chi2 and R-Factor }
  ndchi2,                           { Denomiator of Chi2 }
  ndrfac:     real;                 { Denominator of R-Factor }

  szmax:      integer;              { Number of HKL Record to Create }


  { ***  Original Parameters definitions  *** }

  icenter,                          { 0/1   => No/Yes to Friedel Pair remove }
     iout,                          { 0/1/2 => No/Normal/Full listing }
    iexpe,                          { 0/1   => No/Yes to Twin Expansion }
    inmoy,                          { 0/1   => Check(no out)/Average Eq. HKL }
    icoln,                          { Colomn number by input line }
     imsg,                          { 0/1   => No/Yes to force sigma Average }
     ils2:    integer;              { 0/1   => For Lambda/2 expansion }


  { ***  Other Variables  *** }

  write_ref,                        { Total number of written reflections }
  keep_ref,                         { Total Number of Keep Reflections }
  read_ref:   integer;              { Total Number of Readden Reflections }

  i, j:       integer;              { Micellious Counters }
  

  grp_exp,                          { Array of Expansion Group Element }
  grp_tab:    grptb_typ;            { Array of the Punctual Group matrix elements }

  exp_order,                        { Number of matrix in Expansion Group }
  grp_order:  integer;              { Number of matrix (or Punctual Group order) }

  pfree,                            { Head list of Free HKL Record }
  pred,                             { Last Assigned HKL Record }
  pcur,                             { Current HKL Record to Assign }
  pfirst,                           { Head list of Assigned HKL Record }
  plast:      hklrec_ptr;           { Last Assigned HKL Record Pointer }


  { ***  File definitions  *** }

  param,                            { Parameter Data file }
  list,                             { Listing Data File }
  inp,                              { Input Data File }
  out:        text;                 { Output Data file }

  param_name,                       { Parameter File Name }
  input_name,                       { Input File Name }
  output_name: string( 64 );        { Output File Name }



{************************************************************}
{*      Operation on Group operators and HKL vectors        *}
{************************************************************}

function * ( in_var m1, m2: gope_typ ): gope_typ;
{ Define the operator product }
var
  r: integer;
  mr: gope_typ;

begin
  for i := 1 to 3 do
    for j := 1 to 3 do
    begin
      r := 0;
      for k := 1 to 3 do  r := r + m1[i,k]*m2[k,j];
      mr[i,j] := r
    end;
  return mr
end { * } ;


function * ( in_var m: gope_typ; in_var v: hkl_typ ): hkl_typ;
{ Define the action of an operator on a HKL Vector }
{ Warning: The HKL Vector is in Reciprocal space and Matrix in direct space
  As the HKL order as no signification for us, we can use m<transpose> in place
  of m**-1<transpose> }
var
  r: integer;
  vr: hkl_typ;

begin
  for i := 1 to 3 do
  begin
    r := 0;
    for j := 1 to 3 do  r := r + m[j,i]*v[j];
    vr[i] := r
  end;
  return vr
end { * } ;


function * ( f: integer; in_var m: gope_typ ): gope_typ;
{ Define the product <number>*<operator> }
var
  mr: gope_typ;

begin
  for i := 1 to 3 do
    for j := 1 to 3 do
      mr[i,j] := f*m[i,j];
  return mr
end { * } ;


function - ( in_var m: gope_typ ): gope_typ;
{ Define the negate operator on an group operator }
var
  mr: gope_typ;

begin
  for i := 1 to 3 do
    for j := 1 to 3 do
      mr[i,j] := - m[i,j];
  return mr
end { - } ;


function * ( f: integer; in_var v: hkl_typ ): hkl_typ;
{ Define the product <number>*<HKL_Vector> }
var
  vr: hkl_typ;

begin
  for i := 1 to 3 do  vr[i] := f*v[i];
  return vr
end { * } ;


function - ( in_var v: hkl_typ ): hkl_typ;
{ Define the negate operator on a HKL Vector }
var
  vr: hkl_typ;

begin
  for i := 1 to 3 do  vr[i] := - v[i];
  return vr
end { - } ;



{******************************************************************}
    procedure WRITE_POINTER( in_var ici: string;
                              id: integer;
                             pcur: hklrec_ptr );
    var
      curpt, curptnext: record_pt;

    begin
      curpt.pt := pcur;
      curptnext.pt := pcur^.next;
      if (pcur <> nil) then
        WRITELN( ici, id:3, ' /PT==>', curpt.int, ' /PT^.NEXT==>', curptnext.int)
      else
        WRITELN(ici, ' IS NIL');
    end WRITE_POINTER;




procedure SKIP_LINE( nlg: integer );
begin
  for i := 1 to nlg do WRITELN( list )
end SKIP_LINE;




procedure BLTGR( var ngrp: integer; var grp_tab: grptb_typ );
{ Routine to build all Punctual group elements }
var
  cen:                         string( 8 );
  i, j, k, ig, ip, ngr, itcen: integer;
  op:                          gope_typ;


  procedure GROUP_OVERFLOW;
  begin
    WRITELN;
    WRITELN( ' *** Noneq Error: Group Overflow => Noneq Exit.' );
    WRITELN( list );
    WRITELN( list, ' *** Noneq Error: Group Overflow => Noneq Exit.' );
    PASCAL_EXIT( 2 ) { STop Program with Error Code }
  end GROUP_OVERFLOW;


  function READ_OPE: gope_typ;
  var
    m: gope_typ;

  begin
    for i := 1 to 3 do
      for j := 1 to 3 do
        READ( param, m[i,j] );
    READLN( param );
    READ_OPE := m
  end;


  procedure WRITE_OPE( id: integer );
  begin
    for i := 1 to 3 do
    begin
      WRITE( list, '  |' );
      for j := 1 to 3 do WRITE( list, grp_tab[id][i,j]:3 );
      WRITELN( list, ' |' )
    end;
    SKIP_LINE( 2 )
  end WRITE_OPE;


  procedure WRITE_OPE_PRODUCT( dim: integer;  in_var m1, m2, m3: gope_typ );
  begin
    WRITELN( list );
    for i := 1 to dim do
    begin
      WRITE( list, ' |');
      for j := 1 to dim do  WRITE( list, m1[i,j]:3 );
      if (i <> 2) then WRITE( list, ' |     |' )
                  else WRITE( list, ' |  *  |' );
      for j := 1 to dim do  WRITE( list, m2[i,j]:3 );
      if (i <> 2) then WRITE( list, ' |     |' )
                  else WRITE( list, ' |  =  |' );
      for j := 1 to dim do  WRITE( list, m3[i,j]:3 );
      WRITELN( list, ' |' )
    end;
    WRITELN( list )
  end WRITE_OPE_PRODUCT;


begin { BLTGR }
  READLN( param, ngr, itcen );
  if (itcen > 0) then itcen := 1;
  if (itcen < 1) then itcen := 0;
  if (itcen = 1) then cen := 'CENTERED';
  if (itcen = 0) then cen := '        ';
  WRITELN( list, ' ':2, 'You Give : ', ngr:5,
                 ' for Ponctuel Group which is ', cen );
  SKIP_LINE( 2 );
  WRITELN( list, ' ':2, 'Ponctuel Group matrix :' );
  SKIP_LINE( 3 );

  { *** Create the Identity operator *** }
  ngr := ngr + 1;
  for i := 1 to 3 do
    for j := 1 to 3 do
      grp_tab[1][i,j] := ORD( i = j );

  if ngr > 48 then GROUP_OVERFLOW;

  { *** Read each given operators from parameter file *** }
  WRITELN( list, '  Element #   1 is Identity.' );
  WRITE_OPE( 1 );
  ig := 2;
  while ig <= ngr do
  begin
    grp_tab[ig] := READ_OPE;
    WRITELN( list );
{*** TESTER le caractere UNIQUE de chaque MATRICE ***}
    if grp_tab[ig] = grp_tab[1] then
      WRITELN( list, '  Identity Element Ignored.' )
    else
    begin
      WRITELN( list, '  Element #', ig:3, '  Given.' );
      WRITE_OPE( ig );
      ig := ig + 1
    end
  end;
  ngr := ig - 1; { Set to really new operator }

  { *** Extend for operator by the symmetry centre when required *** }

  if (itcen >= 1) then
  begin
    if ngr > 24 then GROUP_OVERFLOW;
    for i := 1 to ngr do
    begin
      ngr := ngr + 1;
      grp_tab[ngr] := - grp_tab[i]
    end
  end;

  { *** Multiply the operator to find all group elements *** }
  i := 1;
  while i < ngr do
  begin { Loop on left operator - We skip the identity }
    i := i + 1;
    j := 1;
    while j < ngr do
    begin { Loop on right operator - We skip the identity }
      j := j + 1;
      op := grp_tab[i]*grp_tab[j];
      k := 1;
      repeat { Loop for the same operator already present }
      exit if op = grp_tab[k];
        k := k + 1
      until k > ngr;
      { Any new operator is append to the operator list }
      if k > ngr then
        if ngr >= 48 then GROUP_OVERFLOW
        else
        begin
          ngr := ngr + 1;
          grp_tab[ngr] := op;
          { *** Output on Noneq Listing the new operator *** }
          WRITELN( list );
          WRITELN( list,  '  Product : ', i:3, ' by :', j:3,
                          ' Element number :', ngr:4 );
          WRITE_OPE_PRODUCT( 3, grp_tab[i], grp_tab[j], op )
        end
    end
  end;
  { Set the Punctual Group Order }
  ngrp := ngr
end BLTGR;



function BLTEQU( in_var ihkl:      hkl_typ;     { HKL to Expand }
                    var tab_hkl:   equtb_typ;   { Resulting list of HKL }
                 in_var grp_tab:   grptb_typ;   { Elem. Group table }
                        grp_order: integer;     { Group Order }
                        rdflg:     boolean      { Flag for no duplication }
               ): integer;                      { Return Number of gener. HKL }
var
  nbeq, i, j, ig: integer;
  it:             hkl_typ;

begin
  nbeq := 0;
  for ig := 1 to grp_order do
  begin { Build an Equivalent hkl }
    it := grp_tab[ig]*ihkl;
    { When no expansion required, we check for new hkl }
    if rdflg  then
    begin
      i := nbeq;
      while i > 0 do
      begin
        j := 3;
        while j > 0 do
          if (tab_hkl[i][j] = it[j]) then j := j - 1
                                     else exit; { not = hkl }
      exit if j = 0;          { When j = 0 this hkl was already present }
          i := i - 1;
      end
    end
    else i := 0;
    { Append the new HKL vector to the equvalent Table }
    if i = 0 then
    begin
      nbeq := nbeq + 1;
      tab_hkl[nbeq] := it
    end
  end;
  BLTEQU := nbeq
end BLTEQU;




procedure WORK;
{  Perform the NONEQ Work (specified in nq_mod) for the pfirst^ reflection :
     
}
var
  prev,                         { Pointer to previous HKL Record }
  pcur,                         { Pointer to current HKL Record }
  ptmp: hklrec_ptr;             { temporary HKL Record Pointer }

  { ref is The Intensity, F2 or SF of the HKL Record }
  { sig is the related sigma (~ It is the measured sigma }

  issgm, sgm2,                  { Temp. var. to store ref/sig and 1/sig**2 }
  ave_theta,                    { Theta summation and Average }
  ave_int,                      { Intensity/F2/SF Average }
  eff_sig,                      { ... and related effective sigma }
  ave_sig,                      { ... and related sigma average }
  rep_sig,                      { ... and related sigma (by distrib.) }
  nsigr,                        { Numerator of repartition sigma (ave_sig) }
  accuracy,                     { Relative accuracy (rep_sig/ave_int) }

  ps_int,                       { Partial Summ of ref }
  ps_int2,                      { Partial Summ of ref**2 }
  ps_sigm,                      { Partial Summ of measured sigma }
  ps_ints,                      { Partial Summ of ref/sig }
  ps_ints2,                     { Partial Summ of (ref/sig)**2 }
  ps_int1s2,                    { Partial Summ of ref/sig**2 }
  ps_1ssgm2:     real;          { Partial Summ of 1/sig**2 }

  nexp,                         { Number of HKL To Expand }
  nbeq,                         { Number of Equivalent HKL (With the Group) }
  ncp:           integer;       { Number of equivalent reflection Found }

  exp_tab,                      { Array of HKL for Twin/Domains Expansion }
  hkl_tab:       equtb_typ;     { Array of Equivalent HKL }

  nweq,                         { Number of write HKL for the keep ref. }
  imacl,                        { Twin_Partner/Domain number }
  isent:         integer;       { Output File sentinel }

  i, j:          integer;       { Micellious Integer }



  procedure WRITE_HKL( pfirst:               hklrec_ptr;
                        nmacl, isent:        integer;
                          ref,   sig, theta: real
                     );
  { To output an HKL to the Output Data File }
  begin
    with pfirst^ do
    begin
      WRITE( out, nmacl:4, hkl[1]:4, hkl[2]:4, hkl[3]:4 );
      for i := 1 to icoln do  WRITE( out, tabvl[i]:12:4 );
      WRITELN( out, isent:4, ref:12:5, sig:12:5, theta:10:3 )
    end;
    nweq := nweq + 1            { Update the Partial Write Reflection count }
  end WRITE_HKL;



  procedure WRITE_ENV_TBVAL( pcur: hklrec_ptr );
  var
    dec: integer;

  begin
    with pcur^ do
    begin
      if (icoln > 0) then dec := 3
                     else dec := 4;
      WRITE( list, ' ':6, hkl[1]:4, hkl[2]:4, hkl[3]:4,
                          ref:10:dec, sig:10:dec, th:10:dec );
      for i := 1 to icoln do WRITE( list, tabvl[i]:10:dec );
      WRITELN( list, ' ***' )
    end
  end WRITE_ENV_TBVAL;


begin { <<< WORK >>> }
  nweq := 0;                    { Initialize the write reflection count }
  prev := pfirst;               { Prev -> The Master HKL Record }
  with pfirst^ do
  begin
    pcur  := next;              { Get the first possible equivalent reflection }

    if equave_md in nq_mode then
    begin { *** We perform the average of all Equivalent reflections *** }
      {  Build the List of Equivalent HKL }
      nbeq  := BLTEQU( hkl, hkl_tab, grp_tab,
                       grp_order, equave_md in nq_mode );

      { ***  Initialize the Reflection summation  *** }

      issgm     := ref/sig;
      sgm2      := 1.0/SQR( sig );

      { *** Initialize all Partial Summ *** }
      ps_int    :=          ref;
      ps_int2   :=   SQR( ref );
      ps_sigm   :=          sig;
      ps_ints   :=        issgm;
      ps_ints2  := SQR( issgm );
      ps_int1s2 :=     ref*sgm2;
      ps_1ssgm2 :=         sgm2;
      ave_theta :=           th;

      ncp       :=        1;    { Initialize the Equivalent count }

      { Output the Master HKL contribution when full listing required }
      if (hklful_md in nq_mode) and
         (pfirst <> nil) then WRITE_ENV_TBVAL( pfirst );

      { Loop to look for equivalent in the hkl_tab }
      pcur := pfirst^.next;
      while (pcur <> nil) do
      begin
        i := 1;
        while i <= nbeq do
        begin
        exit if pcur^.hkl = hkl_tab[i];
          i := i + 1
        end;
        { When i > nbeq, the hkl do not match }
        if i <= nbeq then
        begin { The reflection is found in the equivalent table }
          { Output the partial contribution when full listing required }
          if hklful_md in nq_mode then WRITE_ENV_TBVAL( pcur );
          with pcur^ do
          begin
            issgm     := ref/sig;
            sgm2      := 1.0/SQR( sig );

            { Update the Partial Summation }

            ps_int    := ps_int    +          ref;
            ps_int2   := ps_int2   +   SQR( ref );
            ps_sigm   := ps_sigm   +          sig;
            ps_ints   := ps_ints   +        issgm;
            ps_ints2  := ps_ints2  + SQR( issgm );
            ps_int1s2 := ps_int1s2 +     ref*sgm2;
            ps_1ssgm2 := ps_1ssgm2 +         sgm2;
            ave_theta := ave_theta +           th;

            ncp := ncp + 1      { Increment the Equivalent Reflection Count }
          end;
          { Free the equivalent hkl }
          ptmp := pcur;         { Keep the pcur pointer }
          pcur := pcur^.next;   { Remove pcur^ HKL Record from Assigned List }
          prev^.next := pcur;
          ptmp^.next := pfree;  { Link pcur^ HKL Rec. in the Free Rec. List }
          pfree := ptmp
        end
        else
        begin { Not Equivalent Reflection }
          prev := pcur;         { Skip to next HKL Record in the Assigned List }
          pcur := pcur^.next
        end
      end;

      { We complete the pfirst^ Management }

      ave_int := ps_int/ncp;    { Get the INT/F2/SF average }
      ave_sig := ps_sigm/ncp;   { Get the related meas. sigma average }
      nsigr   := ps_int2 - SQR( ps_int )/ncp;   { Built r-Sigma Numerator }
      if (ncp > 1) and (nsigr > 0.0) then
        rep_sig := SQRT( nsigr/(ncp - 1) )      { ... and the INT... r-sigma }
      else
        rep_sig := 0.0;
      if ave_int > 1.0E-6 then
        accuracy := rep_sig/ave_int { get the repartition accuracy }
      else
        accuracy := 0.0;            { Flag <= Zero value Intensity }

      ave_theta := ave_theta/ncp;   { Get the Theta average }


      { We Update the global summ }
      nnchi2 := nnchi2 +            { Update Numerator for chi2 and R-Factor }
                ps_ints2 + ave_int*(ave_int*ps_1ssgm2 - 2.0*ps_int1s2);
      ndchi2 := ndchi2 + ncp - 1;   { Update Denominator for chi2 }
      ndrfac := ndrfac + ps_ints2   { Update Denominator for R-Factor }
    end;

    if equexp_md in nq_mode then
    begin
      { We perform the Twin/Domains ref. expansion to a Punctual Group }

    end
    else
      { The output on out File is to be generated when Required }
      if equwrt_md in nq_mode then 
      begin { Write to Output file When Required }

        isent := TRUNC( ave_int/1000.0 ) + 1;
        if avesig_md in nq_mode then
          eff_sig := ave_sig
        else
          if rep_sig > ave_sig then eff_sig := rep_sig
                               else eff_sig := ave_sig;
        WRITE_HKL( pfirst, 1, isent, ave_int, eff_sig, ave_theta )
      end;


    if hklout_md in nq_mode then
      WRITELN( list, ' MULT: ', nbeq:3, ', NBR-REF: ', ncp:3,
                     ', NBR-WRT: ', nweq:3, ', HKL : ',
                     hkl[1]:4, hkl[2]:4, hkl[3]:4,
                     ave_int:10:2, ave_sig:10:2, ave_theta:8:2,
                     rep_sig:8:2, accuracy:8:2 );

    { ***  Remove the Master reflection of the HKL Record List  *** }

    pcur   := pfirst;
    pfirst := next;   { Old with pfirst^ is always active }
    { ... and insert it in the free HKL Record List }
    next   := pfree;
    pfree  := pcur
  end;
  write_ref := write_ref + nweq  { Update the global Written ref. count }
end WORK;



procedure CREATE_RECORDS;
var
  p: hklrec_ptr;

begin
  pfree  := nil;
  for i := 1 to szmax do
  begin
    NEW( p );
    p^.next := pfree;
    pfree := p
  end 
end CREATE_RECORDS;



function FILL_A_RECORD: boolean;
{ Fill the Buffer HKL record from the INPUT line }
{ If the line was empty, the returned value is false and else  true.}
var
  ip: integer;                                      { ip is the READV index }

begin
  if line.length > 0 then
  begin
    with cbuf do
    begin
      next := nil;
      ip   := 1;
      READV( line:ip, hkl[1], hkl[2], hkl[3], ref, sig, th );
      if sig < sgmin then sig := sgmin;
      for iv := 1 to icoln do  READV( line:ip, tabvl[iv] );
      FILL_A_RECORD := true
    end
  end
  else FILL_A_RECORD := false
end FILL_A_RECORD;



procedure OUT_SUMMARY( var f: text );
begin
  WRITELN( f );
  WRITELN( f );
  WRITELN( f );
  WRITELN( f, '              NONEQ Normal End' );
  WRITELN( f, '              ----- ------ ---' );
  WRITELN( f );
  WRITELN( f );
  WRITELN( f, '  There are : ', keep_ref:8,
              '  Reflection Keep in : ', read_ref:8 );
  WRITELN( f, '  and : ', write_ref:8, ' Written Reflections.' );
  WRITELN( f );
  WRITELN( f );
  WRITELN( f );
  WRITELN( f, ' Group Squared Goodness of Fit Factor = ', nchi2:8:2 );
  WRITELN( f );
  WRITELN( f, ' Reliability Factor                   = ', nrfac:8:3 );
  WRITELN( f );
  WRITELN( f );
  if icoln > 0 then WRITELN( f, '  ****   4I4,', icoln:0,'F12.4, 1I4, 3F10.2 ****' )
               else WRITELN( f, '  ****   4I4, 1I4, 3F10.2 ****' );
  WRITELN( f, '  ****  With  NTWIN, IH, IK, IL, <ADD_COLUMN>,''ISMXD, RF2, RSG, RTH ****' );
  WRITELN( f )
end OUT_SUMMARY;


{******************************************************************}

begin { <<< Main >>> }
  { ***  Get the Basic Parameters  *** }

  WRITE( ' Parameters File = ' );  READLN( param_name );
  WRITE( ' Input File = ' );       READLN( input_name );
  WRITE( ' Output File = ' );      READLN( output_name );
  WRITELN;

  { *** Open all Files  *** }

  RESET(   param, param_name );
  REWRITE( list,  'sy:noneq.lis' );

  { ***  Initialization  *** }

  nnchi2 := 0.0;                    { Numerator of Chi2 and R-Factor }
  ndchi2 := 0.0;                    { Denomiator of Chi2 }
  ndrfac := 0.0;                    { Denominator of R-Factor }

  szmax  := def_szmax;              { set the Default number HKL rec. }


  { ***  Read the Parameter File and set NONEQ flags Register  *** }

  READLN( param, thtol, sgmin, icenter, iout,
                 iexpe, inmoy, icoln, imsg, ils2 );
  icoln := icoln - 6;
  if (icoln < 0) then
  begin
    WRITELN( ' *** Icoln must be in the range 6..13 ***' );
    PASCAL_EXIT( 2 )
  end;

  if (icoln > 7) then icoln := 7;

  { ***  Set the NONEQ mode register flag  *** }
  if iexpe > 0   then nq_mode := [equexp_md,equwrt_md]
                 else begin
                        nq_mode := [equave_md];
                        if inmoy > 0 then nq_mode := nq_mode + [equwrt_md];
                        if ils2 > 0 then nq_mode := nq_mode + [equhw2_md]
                      end;
  if icenter > 0 then nq_mode := nq_mode + [equfri_md];

  if imsg > 0 then nq_mode := nq_mode + [avesig_md];

  if iout > 0 then
  begin
    nq_mode := nq_mode + [hklout_md];
    if iout > 1 then nq_mode := nq_mode + [hklful_md]
  end;

  BLTGR( grp_order, grp_tab );      { Read and Build the Punctual Group }

  CLOSE( param );                   { Close the Prameter file }


  { ***  Begin of Process  *** }

  WRITELN( list, ' OUTPUT FILE = "', output_name, '".' );
  WRITELN( list, '  INPUT FILE = "', input_name, '".' );
  WRITELN( list, ' PARAM. FILE = "', param_name, '".' );
  WRITELN( list );
  WRITELN( list, ' Icenter =', icenter:2, ', Iout  =', iout:2,
                 ', Iexpe =', iexpe:2, '.' );
  WRITELN( list, ' Inmoy   =',   inmoy:2, ', Icoln =', icoln:3,
                 ', Imsg =', imsg:2, ', Ils2 =', ils2:2, '.' );
  WRITELN( list );
  WRITELN( list, '  Sigma Mini : ', sgmin:10:3 );
  WRITELN( list );
  WRITELN( list );
  WRITELN( list, ' ':49, 'h   k   l     A-F2       A-Sg   Theta  Sg(F2)  Sg(F2)/F2' );
  WRITELN( list );



  read_ref  := 0;                   { Initialize the input reflection count }
  keep_ref  := 0;                   { ... and the keep reflection count }
  write_ref := 0;                   { ... and the written reflection count }

  CREATE_RECORDS;                   { Allocate all hkl-record as free records }
  pfirst := nil;                    { Set the hkl-record buffer list to empty state }

  RESET( inp, input_name );         { Open the Input File }

  if equwrt_md in nq_mode then
    REWRITE( out, output_name );    { Open the Output File if required }


  { *** Main Procees LOOP *** }

  loop
    if not EOF( inp ) then          { Prevent to read after EOF }
    repeat
      READLN( inp, line );          { Read an Input Line }
    exit if EOF( inp );             { if EOF is reached, continue to the end of process }
      if FILL_A_RECORD then         { Fill the buffer HKL record }
      begin                         { On Success (no empty line) ... }
        pcur   := pfree;            { Get a record from the free record list }
        pfree  := pcur^.next;
        if pfirst = nil then pfirst := pcur { ... and append it to the Used Record List }
                        else plast^.next := pcur;
        plast  := pcur;
        pcur^  := cbuf;             { Copy the buffer HKL record in the new Assigned one }

        { Update the reflections counts }         
        read_ref := read_ref + 1    { Increment the Count readden reflections }
      end
    until pfree = nil;              { Stop the Read Loop on EOF or when all memory record are used }
  exit if pfirst = nil;             { Noneq process is in terminal phase }
    { ***  Now, the Used Record List is full, or contain all not handled reflection(s)  *** }
    WORK;                           { Handle the reflection in the first Assigned HKL Record }
    keep_ref := keep_ref + 1        { Increment the Count of Keep reflections }
  end;                              { Main Process Loop End }

  if ndchi2 > 0.0 then              { Do not divide by 0.0 }
    nchi2 := nnchi2/ndchi2          { Compute the Squared Goodness of Fit }
  else
    nchi2 := -1.0;                  { Flag Chi2 for no defined }

  if ndrfac > 0.0 then              { Do not divide by 0.0 }
    nrfac := SQRT( nnchi2/ndrfac )  { Compute the Normalized R-Factor }
  else
    nrfac := -1.0;                  { Flag R-Factor for no defined }

  OUT_SUMMARY( list );              { Output Diagonostic Summary on Listing file }
  OUT_SUMMARY( output );            { Output Diagonostic Summary on output file }
  WRITELN
end.
