%pragma trace 1;
{		*  M  X  D  *  S Y S T E M  *

        ***   R U N   T I M E    L I B R A R Y   ***


	BY :
	    P. WOLFERS
		C.N.R.S.
		LABORATOIRE DE CRISTALLOGRAPHIE
		B.P.  166 X   38042  GRENOBLE CEDEX
					FRANCE.

}
{  VERSION 3.9-L3    OF  M-X-D  SYSTEM   }
{**********   CPAS    VERSION  **********}

(* [environment('MXDRTL')] *)
module MXDRTL( input, output );

const
  max_intdig  =  12;                    { Maximum of digit for integer (maxi 32 bits) }
  str_ln10    = 2.30258512E+00;         { Ln(10) for number conversions }
  str_log9o5  = 9.997E-01;              { Value to set a new scale change in conversion }

  inrd = 0.0174532931;                  { pi /180 }
  pagesize    =  55;                    { Size of a page listing in line }
  maxerrline  =  80;                    { Size of one error message line }
  maxshortsz  =  32;                    { Maximum size of an internal file specification }
  maxoptv     =   8;                    { We can have until 8 value for an option statement }
  maxlinesz   = 132;                    { Maximum size for a data line }
  maxidsize   =  16;                    { Maximum size of an identifier }
  maxffrm     =  15;                    { Maximum number - 1 of form facteur }
  maxsel      =  31;                    { Maximum value of nbsel for select function }
  ofilespcpos =  9;                     { Output fourier file spc. position modification }

  colmnsize   =  32;                    { ??? }

  maxiline    = CHR( maxlinesz );       { Maxlinesz as a character }


type

  timety  = packed array[1..11] of char;                { Use for date and time procedure }

  errline = packed array[1..maxerrline] of char;        { Error line type }

  shortstring = packed array[1..maxshortsz] of char;    { For file specif. }

  strline = packed array[1..maxlinesz] of char;         { String-line definition }

  filespc = string( maxlinesz );        { File reference type }


  { strings definitions }
  stp = ^mxd_string;

  mxd_string = record
    n: stp;                             { Link to next record }
    s: strline;                         { String line }
    l: char                             { Used length of the string }
  end;


  { module name definition ( for error message proceding ) }
  mdnam = packed array[1..4] of char;


  { identifier name string definition }
  identifier = packed array[1..maxidsize] of char;

  nameid = record
    l: char;                            { Used length of the identifier }
    s: identifier                       { Identifier string }
  end;


  { data file record definition }

  datrec = record
    h, k, l, m, nq, mlq, is,            { Reciprocal cell diff vector }
    ipl,  refcat: integer;              { Reflexion data type }
    he,   ke,   le, stsl,               { Reciprocal diffusion vector }
    dobs, pds,  sig: real;              { Intensity, weight and sigma }
    tbdif: array[0..maxffrm] of real    { Scattering table }
  end;

  bdt_file = file of datrec;            { Binary Data File type }



  { data information definition }

  datadef = record
    filenbr,                            { Data file sequence number }
    optref,                             { Observation type (0/1/2 for sf/f2/ray) }
    ncp, ncpv,                          { Number of hkl and intensities }
    hm,  hn,   km,
    kn,  lm,   ln: integer;             { Mini-maxi of h k l }
    swobs2,    swobs,                   { Weighted obs. summations }
    sobs2,     sobs: real               { Unweighted obs. summations }
  end;


  { ddi table record structure }

  ddirec = record
    nam: nameid;                        { Name of the data collection }
    inf: datadef                        { Related informations }
  end;

  ddi_file = file of ddirec;            { DDI file type }



  { fourier output file record definition }
  outblk = record
    refskip: integer;		        { Skip reflexion count }
    csca, cfn2, cfm2,		        { Scale and extinction coefficients }
    crf,  cif,  cmag, delssg: real      { Fourier and reject information }
  end;

  bcf_file = file of outblk;            { BCR file type }


var

  linewrt,                              { Line number to write in lst }
  pagenb,                               { Page number }
  errcnt:       [global] integer;       { Error count }

  errmsgspecif: [global] filespc;       { File specification for the error message }

  majorfmode,                           { Flag for major case file specification enabled }
  fatalerror:   [global] boolean;       { Boolean to signal fatal error stop }

  lst:          [global] text;          { Output listing file }

  strempty:     [global] stp := nil;    { List of unused string }

{
  ****************************************************
  *                                                  *
  *         Not  PASCAL  Standard  functions         *
  *                                                  *
  ****************************************************
}


procedure PAS__ERROR( nerr: integer ); external 'PAS__ERROR';


procedure PAS__ERROR_GETMSG(          n:            integer;
                             var msgstr:            string;
                             var msgfil: [readonly] string );
external 'PAS__ERROR_GETMSG';



[global]
function FBJN( var dbjn: real; x: real; n: integer ): real;
{ Computing of bessel function and derivate for modulated position }
  const
    fact = 0.79788456;
    pis2 = 1.57079633;
    pis4 = 0.78539816;

  var
    r, rpn, i: integer;
    b1: real;
    cf, b, bp, pw0, pw1, ob: real;

begin { FBJN }
  if x < 15.0 then
  begin
    x  := x / 2.0;
    cf := 1.0;
    for i := 2 to n do cf := cf / i ;
    b := cf; cf := cf / (n + 1); bp := 0.0;
    r := 1; rpn := n + 1;
    repeat
      ob := b;
      cf := - cf * x; bp := bp + r*cf; cf := cf * x;
      b  := b + cf; rpn := rpn + 1;
      cf := cf / rpn;
      r  := r + 1; cf := cf / r
    until ob = b;
    if n = 0 then
    begin
      pw0 := 0.0; pw1 := 1.0;
    end else
    begin
      pw0 := x**(n-1); pw1 := pw0 * x;
    end;
    FBJN := pw1 * b;
    dbjn := n * pw0 * b * 0.5 + pw1 * bp
  end
  else
  begin
    b1 := x - pis4 - n * pis2; bp := fact / SQRT( x );
    ob := COS( b1 ) * bp; FBJN := ob;
    dbjn := - (ob / (2.0*x) + bp * SIN( b1 ))
  end
end FBJN;


[global]
function BESSEL_J( n: integer; x: real ): real;
var
  der: real;

begin
  BESSEL_J := FBJN( der, x, n );
end BESSEL_J;



{
  ****************************************************
  *                                                  *
  *     String composition PASCAL  Routines          *
  *                                                  *
  ****************************************************
}

{ *** Routines derived from the BASIC$STR library *** }


[global]
function ST_CREATE: stp;
{ Create a new mxd string }
var
  p: stp;

begin
  if strempty = nil then NEW( p )
  else
  begin
    p := strempty; strempty := p^.n
  end;
  with p^ do
  begin
    n := nil;
    l := CHR( 0 )
  end;
  ST_CREATE := p
end ST_CREATE;


[global]
procedure ST_FREE( var p: stp );
{ Set to unused a text record }
begin
  p^.n := strempty; strempty := p;
  p := nil
end ST_FREE;




[global]
procedure ST_PUT_CHAR( var st: mxd_string; ch: char );
begin
  with st do
    if l < maxiline then
    begin
      l := SUCC( l );
      s[ORD( l )] := ch
    end
    else s[maxlinesz] := '*'
end ST_PUT_CHAR;



[global]
procedure ST_PUT_MCHAR( var st: mxd_string; ch: char; m: integer );
begin
  if m >= 0 then
    while m > 0 do
    begin
      ST_PUT_CHAR( st, ch ); m := m - 1
    end
  else
    with st do
    begin
      m :=  -m - 1;
      if m >= maxlinesz then m := 0;
      if ORD( l ) >= m  then
        l := CHR( m )
      else
      repeat
        l := SUCC( l );
        s[ORD( l )] := ch
      until ORD( l ) = m
    end
end ST_PUT_MCHAR;



[global]
procedure ST_PUT_PASTR( var trg: mxd_string; var src: [readonly] string );
var
  i, j: integer;

begin { ST_PUT_PASTR }
  i := LENGTH( src );
  if i > 0 then
  with trg do
  begin
    j := 0;
    repeat
      if l < maxiline then
      begin
        l := SUCC( l );
        j := j + 1;
        s[ORD( l )] := src[j]
      end
      else
      begin
        s[maxlinesz] := '*';
        j := i
      end
    until j >= i
  end
end ST_PUT_PASTR;


[global]
procedure ST_PUT_STRING( var trg, src: mxd_string );
var
  i, j: integer;

begin { ST_PUT_STRING }
  i := ORD( src.l );
  if i > 0 then
  with trg do
  begin
    j := 0;
    repeat
      if l < maxiline then
      begin
        l := SUCC( l );
        j := j + 1;
        s[ORD( l )] := src.s[j]
      end
      else
      begin
        s[maxlinesz] := '*';
        j := i
      end
    until j >= i
  end
end ST_PUT_STRING;


[global]
procedure ST_PUT_IDENT( var trg: mxd_string;
                        var src: [readonly] nameid;
                            fld: integer );
var
  i, lsrc, ltrg, n1, n2: integer;

begin { ST_PUT_IDENT }
  lsrc := ORD( src.l );
  ltrg := ORD( trg.l );
  if fld > (maxlinesz - ltrg) then fld := maxlinesz - ltrg;
  with src do
    if fld >= lsrc then
    begin { Some space characters are required }
      { Put the left space(s) if required }
      n1 := fld - lsrc;
      if n1 > 0 then
      begin
        n2 := n1 div 2;
        ST_PUT_MCHAR( trg, ' ', n2 );
        n1 := n1 - n2
      end;
      for i := 1 to lsrc do ST_PUT_CHAR( trg, s[i] );
      if n1 > 0 then ST_PUT_MCHAR( trg, ' ', n1 )
    end
    else
    begin { too long identifier }
      for i := 1 to fld - 4 do     ST_PUT_CHAR( trg, s[i] );
      for i := lsrc - 4 to lsrc do ST_PUT_CHAR( trg, CHR( ORD( s[i] ) + 32 ) )
    end
end ST_PUT_IDENT;



[global]
procedure ST_WRT_FLOAT(     dv: real; ndig, pent: integer;
                        var st: mxd_string );
{ dv is a positive normalized number in the range [0.1,1.0[. or 0.0 }
{ ndig is the number of digit to write }
{ pent is the number of digit for the integer part }
var
  dig:  integer;
  fdig: boolean;

begin
  fdig := (pent > 1);                   { Set integer part to write flag }
  { Prepare the round of for last figure }
  dv := dv + 0.5*10.0**(-ndig);
  while ndig > 0 do
  { loop on all digits }
  begin
    dv := dv * 10.0;                    { Get a digit }
    dig := TRUNC( dv );
    if fdig and (dig = 0) then          { Output space for the first left digits }
      ST_PUT_CHAR( st, ' ' )
    else                                { ... and the digit character otherwise }
      ST_PUT_CHAR( st, CHR( dig + ORD( '0' ) ) );
    dv := dv - dig;                     { Take off the digit value }
    ndig := ndig - 1;
    pent := pent - 1;
    fdig := false;
    { Insert the period between the integer and decimal parts }
    if (pent = 0) and (ndig > 0) then ST_PUT_CHAR( st, '.' )
  end
end ST_WRT_FLOAT;



[global]
procedure ST_PUT_B_INT(  var st: mxd_string; iv, ndig, base: integer );
var
  ditb:      array [1..64] of char;
  fch:       char;
  dig, i, j: integer;
  bneg:      boolean;

begin  { ST_PUT_B_INT }
  fch := ' ';
  if iv = 0 then
  begin { For zero integer number }
    bneg := false;
    ditb[1] := '0'; j := 1
  end
  else
  begin { <> 0 number }
    if iv < 0 then
    begin { Set number to be positive }
      bneg := true;
      iv := -iv
    end else bneg := false;

    j := 0;
    while iv > 0 do
    begin
      j := j + 1;
      dig := iv mod base;
      if dig > 9 then
        ditb[j] := CHR( dig + ORD( 'A' ) - 10 )
      else
        ditb[j] := CHR( dig + ORD( '0' ) );
      iv := iv div base
    end
  end;
  if ndig = 0 then                      { We set the field in agreement of the number }
    ndig := j + ORD( bneg )
  else
  if ndig < 0 then
  begin                                 { We set the field as positive with "0' at left }
    fch := '0'; ndig := - ndig
  end;
  i :=  ndig - j;                       { Get the number of digit at left }
  if bneg then i := i - 1;
  if i >= 0 then                        { If the write is possible }
  begin
    if bneg and (fch = '0') then ST_PUT_CHAR( st, '-' );
    ST_PUT_MCHAR( st, fch, i );
    if bneg and (fch = ' ') then ST_PUT_CHAR( st, '-' );
    while j > 0 do
    begin
      ST_PUT_CHAR( st, ditb[j] ); j := j - 1
    end
  end
  else                                  { Too small field }
    ST_PUT_MCHAR( st, '*', ndig )
end ST_PUT_B_INT;



[global]
procedure ST_PUT_INT(  var st: mxd_string; iv, ndig: integer );
begin  { ST_PUT_INT }
  ST_PUT_B_INT( st, iv, ndig, 10 )
end ST_PUT_INT;




[global]
function ST_SIZE_REAL( var iexp: integer; var dv: real ): boolean;
var
  rlog: real;

begin
  if dv < 0.0 then
  begin
    dv := -dv;
    ST_SIZE_REAL := true
  end
  else ST_SIZE_REAL := false;
  if dv > 0.0 then
  begin
    rlog := LN( dv ) / str_ln10;
    iexp := ROUND( rlog - 0.5 );
    if rlog - iexp >= str_log9o5 then iexp := iexp + 1
  end
  else iexp := 0
end ST_SIZE_REAL;



[global]
procedure ST_PUT_FLOAT( var st: mxd_string;
                            dv: real; fs, intsz, dcsz, es: integer );
var
  iexp, ses, i, j: integer;
  bneg, eneg:      boolean;
  chexp, chsgn:    char;

begin { ST_PUT_FLOAT }
  es := ABS( es );
  { Check for correct parameter values }
  if dcsz = 0 then dcsz := 7 else dcsz := ABS( dcsz );
  if dcsz > 20 then dcsz := 20;
  if fs < 0 then fs := ABS( fs );
  if intsz < 1 then intsz := 1;
  { Size the number to write and set it as positive number }
  bneg := ST_SIZE_REAL( iexp, dv );
  { iexp is the power of 10 to write on the form 0.d...E... }
  { We normalize the number }
  if dv <> 0.0 then
    dv := dv / 10.0**(iexp + 1); { dv in range [0.1 1.0] } 
  { Modify the exponant by the size of integer part }
  iexp := iexp - intsz + 1;
  { Select the sign character for the mantiss }
  if  bneg then chsgn := '-' else chsgn := ' ';
  { Select the sign character for the exponant }
  if iexp >= 0 then chexp := '+'
  else
  begin
    iexp := - iexp; chexp := '-'
  end;
  { Determine the necessary exponant field size }
  if iexp < 10 then ses := 1 else
    if iexp < 100 then ses := 2 else ses := 3;
  { ... and set it when the user specifier is too small }
  if ses > es then es := ses;
  { Compute the size of unused space where 4 for (" "/"-") "." "E" ("+"/"-") }
  i := fs - dcsz - es - intsz - 4;
  if dcsz = 0 then i := i + 1;          { If no decimal then no decimal point }
  if i < 0 then                         { Not enouph room in the field }
  begin { Try to supress some exponent figures }
    while (es > ses) and (i < 0) do
    begin
      es := es - 1; i := i + 1
    end;
    { If is not enough, try to supress exponent sign }
    if (i < 0) and (chexp = '+') then
    begin
      i := i + 1; chexp := ' '; es := es - 1
    end;
    { If is not enough, try to suppress the sign of mantiss }
    if (i < 0) and not bneg then
    begin
      chsgn := '+'; i := i + 1
    end;
    { If is not enough, try to supress some decimal figures }
    if (i < 0) and (dcsz > 0) then      { We can try to suppress some decimal digits }
    begin
      j := i + dcsz;                    { Get the number of figure to suppress }
      if j > 0 then                     { If some decimal are keep ... }
      begin
        dcsz := j; i := 0               { Set the new number of decimal }
      end
      else                              { When we have not enough space, but ... }
        if (j = -1) and (dcsz > 0) then { ... the lack of just one character }
        begin
          dcsz := 0; i := 0             { We have just the good space without "." }
        end
    end
  end;
  if i < 0 then                         { It is impossible to write the number }
    ST_PUT_MCHAR( st, '*', fs )
  else
  begin                                 { Write the number }
    ST_PUT_MCHAR( st, ' ', i );         { Output the left space }
    { Write sign of number when required }
    if chsgn <> '+' then ST_PUT_CHAR( st, chsgn );
    { Write the number (integer and fractional part) }
    ST_WRT_FLOAT( dv, dcsz + intsz, intsz, st );
    { Write the exponant character }
    ST_PUT_CHAR( st, 'E' );
    { Write exponent sign when required }
    if chexp <> ' ' then ST_PUT_CHAR( st, chexp );
    { Write the exponent with "0" left character }
    ST_PUT_INT( st, iexp, -es )
  end
end ST_PUT_FLOAT;




[global]
procedure ST_PUT_FIXED( var st: mxd_string;
                            dv: real; fs, dcsz, dcmin: integer );
var
  bneg: boolean;
  chsgn: char;
  dc, i, j, indig, iexp: integer;
  dv1: real;

begin
  { Check for correct parameter values }
  if dcsz = 0 then dcsz := 7
              else dcsz := ABS( dcsz );
  if dcsz > 20 then dcsz := 20;
  if fs < 0 then fs := ABS( fs );
  if dcmin < 1 then dcmin := 1;
  { Size the number to write and set it as positive number }
  dv1 := dv;                            { Copy the number to write }
  bneg := ST_SIZE_REAL( iexp, dv1 );
  { Select the number sign }
  if bneg then chsgn := '-'
          else chsgn := ' ';
  { Determine the number of digits for the integer part }
  if iexp > 0 then indig := iexp + 1
              else indig := 1;
  { Get the unused space in the allocated character field as required }
  i := fs - 2 - dcsz - indig;           { 2 for (" "/"-") and "." }
  { Compute the number of significative digits }
  j  := dcsz + iexp + 1;
  dc := dcsz;
  if (iexp < 0) and (j < dcmin) then
  begin                                 { For the too small number with too many lost significative digits }
    dc := -iexp + dcmin - 1;            { ... adjust the decimal part size }
    i := fs - 3 - dc;                   { Left characters with 3 for  }
    if i < 0 then                       { Cannot write in fixed }
      if not bneg and (i = -1) then
      begin                             { When we must win just one digit and the number is positive }
        i := 0; chsgn := '+'            { ... We can suppress it, }
      end
      else                              { ... otherwise it is impossible to write the number in F format }
        ST_PUT_FLOAT( st, dv, fs, 1, dcsz, 0 )  { WE try in E format }
  end
  else
  begin                                 { For not too small number, it can be too large }
    if i < 0 then                       { When we have not enough room in the field }
      if not bneg then                  { When the number is positive ... }
      begin
        chsgn := '+';                   { ... we can supress the sign }
        i := i + 1
      end;
    if i < 0 then                       { When it is not enough }
    begin
      j := i + dc;                      { we try to suppress some decimal digits }
      if j >= 0 then                    { when it is possible to keep some fraction part }
      begin
        dc := j;                        { ... we set the new number of decimal }
        if dc > 0 then i := 0           { ... and supress the period when ... }
                  else i := 1           { ... the fractional part is suppressed. }
      end
      else                              { Else ... }
      if j = -1 then                    { ... when we have a lack of just one character }
      begin
        dc := 0; i := 0                 { ... the fraction part and "." are suppressed. }
      end;
      { If we have always a lack of room in the field we try the E format }
      if i < 0 then ST_PUT_FLOAT( st, dv, fs, 1, dcsz, 0 )
    end
  end;
  if i >= 0 then                        { OK for fixed }
  begin
    { Write the space of the unused field part }
    ST_PUT_MCHAR( st, ' ', i );
    { Write the number sign when required }
    if chsgn <> '+' then ST_PUT_CHAR( st, chsgn );
    { Normalize the number to output }
    if dv1 <> 0.0 then
      dv1 := dv1 / 10.0**indig; { dv in range [0.1 1.0] } 
    { ... and now write it }
    ST_WRT_FLOAT( dv1, indig + dc, indig, st )
  end
end ST_PUT_FIXED;








{
  ****************************************************
  *                                                  *
  *   Interface routines with the operating system   *
  *                                                  *
  ****************************************************
}

[global]
procedure OUT_PAGE( var f: text );
begin
  PAGE( f )
end OUT_PAGE;



[global]
procedure GET_DATE( var st: timety );
begin
  DATE( st )
end GET_DATE;



[global]
procedure GET_TIME( var st: timety );
begin
  TIME( st )
end GET_TIME;



[global]
procedure PUT_NEWLINELST( var title: [readonly] string );
var
  timev, datev: timety;

begin
  OUT_PAGE( lst );                      { Put a page eject }
  linewrt := 0;
  pagenb  := pagenb + 1;
  GET_DATE( datev ); GET_TIME( timev );
  WRITELN( lst,' ', title:60, ' run the ', datev,
                              ' at ',      timev, ' ':5,
                              'page ',     pagenb:3 );
end PUT_NEWLINELST;


[global]
procedure OUTERRMSGLINE( n: integer );
{ to display an information line related to an error }
var
  msgstr: string( maxerrline );

begin { OUTERRMSGLINE }
  PAS__ERROR_GETMSG( n, msgstr, errmsgspecif );
  if msgstr.length > 0 then
  begin
    WRITELN( lst, ' *+*+*+*+*  ', msgstr );
    linewrt := linewrt + 1
  end
end OUTERRMSGLINE;



[global]
procedure OPEN_LISTING( var     f: text;
                        var fname: [readonly]
                                   packed array[$sz: integer] of char;
                            mdflg: integer );
var
  fn:     string;
  fm: flags_file;

begin (** CPAS **)
  fn := fname;
  fm := [write_file,case_dis_file,error_file];
  if mdflg = 2 then fm := fm + [append_file];
  OPEN( f, fn, fm );
  if iostatus <> 0 then
  begin
    WRITELN( err, ' MXD_CMP cannot open (in read mode) the file "', fn, '"' );
    PAS__ERROR( iostatus )
  end
end OPEN_LISTING;



[global]
procedure OPENW_TXTFILE( var f: text; fname: stp; mdflg: integer );
var
  i, j:    integer;
  fspc:    filespc;
  fm:   flags_file;

begin
  if fname <> nil then
  with fname^ do
  begin
    fspc.length := ORD( l );
    for i := 1 to ORD( l ) do fspc[i] := s[i];
  end;
  fm := [write_file,case_dis_file,error_file];
  if mdflg = 2 then fm := fm + [append_file];
  OPEN( f, fspc, fm );
  if iostatus <> 0 then
  begin
    WRITELN( err, ' MXD_CMP cannot open (in write mode) the file "', fspc, '"' );
    PAS__ERROR( iostatus )
  end
end OPENW_TXTFILE;



[global]
procedure CLOSE_TXTFILE( var f: text );
{ Close if already open for chaine statement }
begin
  CLOSE( f )
end CLOSE_TXTFILE;



{ Open an input text file }
[global]
procedure OPEN_INPUT_TXTFILE( var f: text; fname: stp;
                              var bok, bprt: boolean; var ierr: integer );
{ Try to open a text file f with the name specified by stp
  on output if bok is false: the file is not open,
  not existing file is not an error, but other problem
  generate an error code as 2000 + OPEN-VMS/RMS error code }

var
  i, j:    integer;
  fspc:    filespc;
  fm:   flags_file;

begin
  if fname <> nil then
  with fname^ do
  begin
    bprt := false;                      { Assume not a terminal until shown otherwise }
    fm := [read_file,error_file];
    if not majorfmode then fm := fm + [case_dis_file];
    fspc.length := ORD( l );
    for i := 1 to ORD( l ) do  fspc[i] := s[i];
    OPEN( f, fspc, fm );
    ierr := iostatus;
    if ierr = 0 then
    begin
      bprt := TTY_FILE( f );  (** CPAS **)
      bok  := true            (** CPAS **)
    end
    else
    begin
      bok  := false;
      if (ierr = 202) or (ierr = 204) then ierr := -1
                                      else ierr := ierr + 2000
    end
  end
end OPEN_INPUT_TXTFILE;


[global]
function CPU_CLOCK: integer;
begin
  CPU_CLOCK := CLOCK;
end CPU_CLOCK;


[global]
function OPEN_DDIFILE( var   f: ddi_file;
                       var spc: [readonly] string;
                           wrt: boolean   ): boolean;
var
  bok:  boolean;

begin
  if wrt then
    REWRITE( f, spc )
  else
    OPEN( f, spc, [error_file,read_file] ); (** CPAS **)
  bok := (iostatus = 0);
  OPEN_DDIFILE := bok
end OPEN_DDIFILE;


[global]
procedure CLOSE_DDIFILE( var f: ddi_file );
begin
  CLOSE( f )
end CLOSE_DDIFILE;



[global]
procedure OPEN_BDTFILE( var f: bdt_file; spc: stp );
var
  fs: string;

begin
  fs := spc^.s;
  REWRITE( f, fs )
end OPEN_BDTFILE;


[global]
function OPENR_BDTFILE( var f: bdt_file; spc: stp ): boolean;
var
  fs: string;

begin
  fs := spc^.s;
  OPEN( f, fs, [error_file,read_file] );  (** CPAS **)
  OPENR_BDTFILE := (iostatus = 0)
end OPENR_BDTFILE;


[global]
procedure CLOSE_BDTFILE( var f: bdt_file );
begin
  CLOSE( F )
end CLOSE_BDTFILE;


[global]
procedure OPEN_BCFFILE( var f: bcf_file; spc: stp );
var
  fs: string;

begin
  fs := spc^.s;
  REWRITE( f, fs );
end OPEN_BCFFILE;


[global]
procedure CLOSE_BCFFILE( var f: bcf_file );
begin
  CLOSE( F )
end CLOSE_BCFFILE;


end MXDRTL.
