{
                        S Y S T E M E * M X D *

        M X D   L E A S T - S Q U A R E S   E N V I R O N M E N T

                               F O R

        A P P L I C A T I O N   P R O G R A M   G E N E R A T I O N



           BY :
                P. WOLFERS
                C.N.R.S.
                LABORATOIRE DE CRISTALLOGRAPHIE
                B.P.  166 X   38042  GRENOBLE CEDEX
                                        FRANCE.

}

{***  VERSION 3.9 - B  OF  M-X-D  SYSTEM  ***}

{
     OPEN-VMS PASCAL ADAPTATION  FLAGGED BY  THE COMMENT
}
                   (** OPEN-VMS **)
{

        OPERATING SYSTEM AND COMPUTER SENSIBLE POINTS :


                     -- NOTHING --



}

%include 'mxdsrc:mxd_rtl_env';

type

  threechar = packed array[1..3] of char;

  namcte    = packed array[1..8] of char;

  ptder = ^deriv;           { pointer of privat derivation result }

  ptr = ^node;

  {  defintion of derivate block  }
  deriv = record
    next: ptder;            { link to next derivation }
    idvar: ptr;             { pointer of corresponding variable }
    derval: real            { value of the derivate }
  end;

  {  definition of node's types  }
  nodetype = (
    addop,  subop,  mulop,     divop,    powop,
    negop,  sqrto,  logop,     expop,    sinop,
    cosop,  tanop,  asino,     acoso,    atano,
    thop,   ipwop,  phaseop,   absop,    intop,      modop,
    bess1op,
    summop, indxrf, functcall, formalrf, formalcall,
    eqop,   neop,   ltop,      leop,     geop,       gtop,
    konst,  tabrf,  intrf,     selnd,    islnd,      sumhkl,
    parrf,  varrf,  contrf,    otheritem
  );

  {  equivalence between sequence number and additional pointer  }
  sqty = record case boolean of
        true: (sequ:  integer);
        false:(lnkpt: ptr)
  end;

  itemtype = (
    param,   varbl,   contrdf, indxdf, formaldf,
    usfunct, atome,   wave,    npola,  moment,
    mdsdsp,  datacol, lsqblk,  symtri
  );

  { limit block definition }

  limitblk = record
    inflim, suplim: real    { limit of variable excursion }
  end;

  { transformation matrix definition }

  matrix = array[1..3,1..3] of real;

  { additional cartesian transformation matrix definition }

  matrixpt = ^matrix;

  limblkptr = ^limitblk ;


  {  node and item definition  }


  seltyp = ( sz2, sz4, sz8, sz16, sz32 );


  nam_ptr = ^nameid;


  node = record
    case nodety: nodetype of
      eqop,  neop,  ltop,  leop,   geop,   gtop,
      addop, subop, modop:
        ( bin1,  bin2:  ptr);        { all bin. operators }
      mulop, divop, powop, phaseop:
        (       { spc. bin. ope. for derivation }
          bina1, bina2: ptr;         { the two operands }
          valb1, valb2: real         { the two last related value }
        );
      negop, intop: (una1: ptr);     { negate unary operators }
      sqrto, logop, expop, sinop, cosop, absop,
      tanop, asino, acoso, atano, thop:(  { all other unary operator }
          unaa1: ptr;                { the parameter }
          valu: real                 { the last related value }
        );
      bess1op:(                      { First Kind Bessel Function }
          bess1_n,                   { Bessel function Order }
          bess1_x: ptr;              { abcisse value expression }
          bess1_d: real              { Last abscisse value }
        );
      ipwop:(                        { integer power operator }
          rpw: ptr;                  { the parameter }
          valwpa: real;              { the last related value }
          ipw: integer               { the exponant value }
        );
      konst:( val: real);            { constante reference }
      summop:(                       { summation operator }
          loopbe, loopen, loopst,    { loop begin, end and step value }
          loopidx,                   { loop control index }
          loopexp: ptr               { loop expression object }
        );
      sumhkl:(                       { hkl sum operator }
          sumhval: real;             { sommation value }
          sumhnxt,                   { link to next sommation operator }
          exphdef: ptr               { expression definition }
        );
      tabrf, intrf:( idx: integer);  { table or internal ref. }
      selnd,islnd,formalcall,functcall:(
          { sel. of refer. table for various size }
          lstsel,                    { the last selected index }
          selsize: integer;          { used select size }
          case seltyp of
            sz2:    (seltb2:   array[0..1]   of ptr);
            sz4:    (seltb4:   array[0..3]   of ptr);
            sz8:    (seltb8:   array[0..7]   of ptr);
            sz16:   (seltb16:  array[0..15]  of ptr);
            sz32:   (seltb:    array[0..31]  of ptr)
        );
      varrf, parrf, contrf, indxrf, formalrf,
      otheritem:(    { all real item,parameters and variables }
        next: ptr;                   { link to next item in the same type }
        name: nam_ptr;               { item name }
        sq: sqty;                    { item sequence number }
        case itemtype of
          indxdf:(                   { index loop }
              indval: real           { index value }
            );
          formaldf:(                 { user function formal }
              nextfo,                { link to next formal }
              actuallink: ptr        { pointer to actual definition }
            );
          usfunct:(                  { user function }
              formallst,             { list of formal }
              exprvalue: ptr         { expression definition }
            );
          param:(                    { parameter item type }
             definition: ptr;        { parameter definition expression }
             lstder: ptder;          { list of derivate block }
             actval: real;           { actual value - computed by parmderval }
             spclnk: ptr             { link to next parm in the same cat. }
            );
          varbl:(                    { variable item type }
              varsequ:  integer;     { original variable sequence number }
              matind:   integer;     { index in lsq matrix }
              limptr:   limblkptr;   { limit block pointer (nil if no limits) }
              curval, cursig: real   { current value and sigma }
            );
          contrdf:(                  { partial $calc }
              contrib,
              contrib1,              { additional for flipping ratio }
              cnr, cni,              { partial nuclear structur factor }
              cxr, cyr, czr,         { partial magnetic structur factor }
              cxi, cyi, czi: real
            );
          atome:(
              lstmom, lstdsp,        { link to associated moments and/or disp.}
              pcntr: ptr;            { link to contribution }
              atmpar: array[1..12] of ptr;  { atom spec. }
              bcart, banis: boolean  { flags of cartesian coord. & b anis. }
            );
          wave:(
              qx, qy, qz,
              vx, vy, vz: real;      { wave vector components in cell, work }
              relflg: boolean        { rational flag }
            );
          npola:(
              { magnetic field components, efficiencies, pol.extinction }
              field:  array[1..6] of ptr
            );
          moment:(
              mwave,                 { associated wave vector if not nil }
              nxtmom: ptr;     { link to next moment with the same atome }
              mompar: array[1..7] of ptr;  { moment specif. }
            );
          mdsdsp:(
              dwave: ptr;            { associated  wave vector }
              nxtdsp: ptr;           { link to next dsp for the same atom }
              mdspar: array[1..8] of ptr
            );
          datacol:(
              datfile: stp;          { data file specification }
              dywecoef,              { dynamic weight coefficient }
              fn2corr, fm2corr,      { correction specification }
              scale: ptr;            { scale specification }
              datcat: integer;       { category of data sf/0,f2/1,ra/2 }
              ncp, ncpv: integer     { number of reflexion }
            );
          lsqblk:(
              vardim: integer;       { size of block }
              dyndmp,                { dynamic damping factor pointer }
              dynmrq,                { dynamic marquward factor pointer }
              lstvar: ptr            { pointer of the last variable of block }
            );
          symtri:(
              xx, xy, xz,  tx,
              yx, yy, yz,  ty,
              zx, zy, zz,  tz: integer; { natural sym. op.}
              mpt: matrixpt    { additional matrix for hexa. cart. atom }
            )
      )
  end;




var

  program_name: [external] packed array[1..6] of char;

  elpstim,                     { total elapsed time }
  topcpu:  [external] integer; { total cpu time }

  pageheadpt1,                 { pointer to page head string part 1 }
  pageheadpt2,                 { pointer to page head string part 2 }
  sbttlpt: [external] stp;     { pointer of current sub-title }

  sumhhde,                     { list of all hkl sum op. }
  gvarhde,                     { list of all variables }
  varhde,                      { list of free variables }
  contrhde,                    { list of all contribution }
  parhde,                      { list of parameters }
  usfuncthde,                  { list of user function }
  formalhde,                   { list of formal }
  loopidxhde,                  { list of loop index }

  atomhde,                     { list of atoms }
  atmshde,                     { list of atoms without symtry }
  wavhde,                      { list of wave vectors }
  polhde,                      { list of polarisation direction }
  momhde,                      { list of magnetic moments }
  dsphde,                      { list of modulated displacments }
  freeblk,                     { list of unused lsq block }
  blkhde,                      { list of diagonal blocks }
  symhde,                      { list of symetri matrix }
  datahde: [external] ptr;     { list of data collection }

  pardhde: [external] array[0..6] of ptr; { lists of dep. param in six levels }

  hh, kk, ll,
  hc, kc, lc,
  hr, kr, lr,                  { current h,k,l,he,ke,le and vh + nq * vw }
  h1, k1, l1, h2,  k2,  l2,    { intermediate h k l }
  da, db, dc, dal, dbe, dga,
  ra, rb, rc, ral, rbe, rga,
  dvol, rvol: [external] real; { unit cell }
  tmd, tmr: [external] matrix; { cell matrix transformation }

  refcatsv,                    { neutron polarized index copy }
  nbfixed,                     { count of fixed variables }
  latticenb,                   { lattice identifier }
  nbcoll,                      { total number of collect }
  ncpobs: [external] integer;  { total number of data observations }

  bfmagnetic,                  { flag founded magnetic statement }
  bflimited,                   { flag existing variable limits }
  buiso,                       { indicator of u isotropic mode }
  bcentric: [external] boolean;{ indicator of centric mode }


  pttl,                        { title pointer }
  psav:     [external] stp;    { save variable filename pointer }


  rgf,  igf,                   { geometrical factor }
  fnr,  fni,                   { nuclear struc. factor }
  fxr,  fyr,  fzr,             { projected magnetic structure factor }
  fxi,  fyi,  fzi,
  rp1,  ip1,                   { modulated occupency factor }
  fmxr, fmyr, fmzr,            { no projected magn. structure factor save }
  fmxi, fmyi, fmzi,

  fnucl2,                      { squared nuclear structure factor }
  fmag2,                       { squared magnetic structure factor }
  fcalc2s,                     { total saved squared part for pol. neu. }
  fcalc2,                      { total squared structure factor }
  fstr,                        { computed none scaled data }
  delta,                       { difference with observation }
  curint: [external] real;     { current structur factor }

  cvariable,                   { Current variable for derivation }
  cformula,                    { Current formula node pointer }
  cparam,                      { Current variable parameter pointer }
  ccontr,                      { current contribution pointer }
  catome,                      { current atome pointer }
  csymtry,                     { current symtry matrix pointer }
  cmoment,                     { current moment pointer }
  cmdsdsp,                     { current mdsdsp pointer }
  cwave,                       { current wave vector pointer }
  cnpola,                      { current polarization dir. pointer }
  cdata:  [external] ptr;      { current data block pointer }

  cselect: [external] 0..maxsel;       { current nature selector }

  iqwave,                      { last number of wave vector ident }
  mxcateg,                     { maximum reflexion family }
  ccateg:  [external] integer; { current reflexion family }

  bstop,                       { indicate stop on error }

  b132,                        { option of listing form }
  bshortlst: [external] boolean;       { option of short output list }


  varnb: [external] integer;   { total number of variable }


  magsel: [external] array[0..maxsel] of boolean; { selection of magnetic mode }

  namtab: [external] array[0..42] of nam_ptr;     { names of item field table }

  { extinction correction variable definitions }

  { virtual variable table for $CALC, $FN2, $FM2, $F2POL }
  virtvtab: [external] array[1..4] of ptr;


  cdrec: [external] datrec;    { current bdt record }
  crrec: [external] outblk;    { current binary computed F record }

  { input files }

  intf:  [external] text;      { reverse polish instructions input }
  idat:  [external] bdt_file;  { cristal data input }



{*************   General services routines  ***************}


{ initialize procedure to set at empty state all the tree structure }
function INIGE( in_var mxdnam: string ): boolean; external;


{ procedure newline with management of page size and page heading }
procedure NEWLINELST; external;


{ error send message procedure with setting of stop flag }
procedure ERROR( n: integer ); external;


{ open listing file with filespecif in a mxd_string }
procedure OPEN_ST_LISTING( var  f: text; ps: stp; mdflg: integer );
external;


procedure CREATSBTTL( var str: [readonly] string ); external;
{ to create (if bini = true) or extend the subtiltle string
  by the characters in str. }

{ underline routine }
procedure UNDERLINE( i, n: integer ); external;


{ skipline is used to skip n lines on the listing }
procedure SKIPLINE( n: integer ); external;


{ procedure to optimize the page skip use }
procedure NEWPARAGRAPHE( n: integer ); external;


{ to write a cpu time in milli-seconde }
{ can be system dependante }
procedure WRITECPU( ti: integer ); external;



{*************  Build Logical Tree routines  **************}



{ builsymbol is used to cretae an identifier of a specified name }
function BUILDSYMBOL( in_var symb: string ): nam_ptr; external;


{ initab is used to create a name table to internal created parameters }
procedure INITAB; external;


{ schitem is used by buildtree, but can be used by setoption }
{ schitem search an item in specified list ( header pointer is h )
  and return the associated pointer to find item }
function SCHITEM( h: ptr; bl: boolean ): ptr; external;


{ buildtree built all logical list and trees of the structure to fit }
{ and also set the various users options as specified }
procedure BUILDTREE; external;


{*************  Small mathematical routines  **************}


function PHASEARG( ip, rp: real ): real; external;


function TANH( v: real ): real; external 'MXD_TANH';


