#!/bin/sh
#
# File to install the paslib and mxd.
#
#
DIR_NAM="mxd"     # The target directory is common for the whole of CPAS kits.
#
# Set all related directories for installation.
#
. logicals.sh
#
# Set the current operating system name.
#
. system.sh
#
echo " PAS_DIR = $PAS_DIR"
MXD_DIR=$KIT_DIR
export MXD_DIR
echo " MXD_DIR = $MXD_DIR"
#
#----------------------------------------------------------------------
# Install paslib library kit if required.
#----------------------------------------------------------------------
#
if ! test -e $LIB_DIR/libcpas.a
then
  WDIR=$PWD
  cd ..
  if test -e cpaslib.tar.gz
    then
      gunzip cpaslib.tar.gz
  fi
#
  if test -e cpaslib.tar
    then
      tar -xvf cpaslib.tar
      cd cpaslib
#
      INSTALL="slave"
      . cpaslib_install.sh
#
    else
      echo " Cannot find the ../cpaslib.tar file."
      exit 2
  fi
  cd $WDIR
fi
#
#----------------------------------------------------------------------
# Install MXD tasks
#----------------------------------------------------------------------
#
make -f mxd.make
#
cp *.for $MXD_DIR
#
cp *.frm ivp.mxd ivp.dat ivp.sav *.std  $MXD_DIR
cp absorb.mxd *.mxl mxd.opt noneq*      $MXD_DIR          
#
# Create typical environment setup files (for sh/bAsh and csh).
#
# SH/BASH Version :
#
echo "#" > mxd_setup.sh
echo "# Setup file for MXD on $SYS_NAME Operating system." >> mxd_setup.sh
echo "#" >> mxd_setup.sh
echo "export NL=/dev/null # define NL: device." >> mxd_setup.sh
echo "export TT=/dev/tty  # define TT: device." >> mxd_setup.sh
echo "#" >> mxd_setup.sh
echo "export PASENV=$PAS_DIR/  # define the paslib library." >> mxd_setup.sh
echo "export MXDLIB=$MXD_DIR/  # define the mxdlib library." >> mxd_setup.sh
echo "#" >> mxd_setup.sh
echo "#" >> mxd_setup.sh
echo "# Alias for MXD Definitions." >> mxd_setup.sh
echo "#" >> mxd_setup.sh
echo alias mxd=\"$MXD_DIR/mxd_cmp mxd\"          >> mxd_setup.sh
echo alias mls=\"$MXD_DIR/mxd_cmp lsq\"          >> mxd_setup.sh
echo alias mlsc=\"$MXD_DIR/mxd_cmp dialog lsq\"  >> mxd_setup.sh
echo alias sort=\"$MXD_DIR/sort\"                >> mxd_setup.sh
echo alias genhkl=\"$MXD_DIR/genhkl\"            >> mxd_setup.sh
echo "#" >> mxd_setup.sh
#
# CSH Version :
#
echo "#" > mxd_setup.csh
echo "# Setup file for MXD on $SYS_NAME Operating system." >> mxd_setup.csh
echo "#" >> mxd_setup.csh
echo "setenv NL /dev/null # define NL: device." >> mxd_setup.csh
echo "setenv TT /dev/tty  # define TT: device." >> mxd_setup.csh
echo "#" >> mxd_setup.csh
echo "setenv PASENV $PAS_DIR/  # Define the paslib library." >> mxd_setup.csh
echo "setenv MXDLIB $MXD_DIR/  # Define the mxdlib library." >> mxd_setup.csh
echo "#" >> mxd_setup.csh
echo "#" >> mxd_setup.csh
echo "# Alias for MXD Definitions." >> mxd_setup.csh
echo "#" >> mxd_setup.csh
echo "alias mxd    '$MXD_DIR/mxd_cmp mxd \!*'"         >> mxd_setup.csh
echo "alias mls    '$MXD_DIR/mxd_cmp lsq \!*'"         >> mxd_setup.csh
echo "alias mlsc   '$MXD_DIR/mxd_cmp dialog lsq \!*'"  >> mxd_setup.csh
echo "alias sort   '$MXD_DIR/sort'"                    >> mxd_setup.csh
echo "alias genhkl '$MXD_DIR/genhkl'"                  >> mxd_setup.csh
echo "#" >> mxd_setup.csh
#

cp mxd_setup*                           $MXD_DIR
#
$PAS_DIR/gen_msgfile mxdcmperr.dat $MXD_DIR/mxd_cmp.err # Build the error mxd msg file.
$PAS_DIR/gen_msgfile mxdlsqerr.dat $MXD_DIR/mxd_lsq.err # Build the error lsq msg file.
#
if test $LOCAL_DIR != "/usr/local"
then
  echo " "
  echo " *** Warning, You ust edit the setup files to ***"
  echo " *** replace the /usr/local path by $LOCAL_DIR directory path  ***"  
  echo " "
fi
#
