%pragma list_on;
{
 *************************************************************************
 *                                                                       *
 *                                                                       *
 *                                                                       *
 *                      MMM    MMM   XXX      XXX  DDDDDDDD              *
 *                      MMMM  MMMM    XXX    XXX   DDDDDDDDDD            *
 *                      MM MMMM MM     XXX  XXX    DD      DDD           *
 *                      MM  MM  MM      XXXXXX     DD       DD           *
 *                      MM      MM       XXXX      DD       DD           *
 *        T  H  E       MM      MM       XXXX      DD       DD           *
 *                      MM      MM      XXXXXX     DD       DD           *
 *                      MM      MM     XXX  XXX    DD      DDD           *
 *                      MM      MM    XXX    XXX   DDDDDDDDDD            *
 *                     MMMM    MMMM  XXX      XXX  DDDDDDDD              *
 *                                                                       *
 *                                                                       *
 *                                                                       *
 *              SSSSS Y     Y  SSSSS TTTTTTT EEEEEE M     M              *
 *             S       Y   Y  S         T    E      MM   MM              *
 *             S        Y Y   S         T    E      M M M M              *
 *              SSSS     Y     SSSS     T    EEEEE  M  M  M              *
 *                  S    Y         S    T    E      M     M              *
 *                  S    Y         S    T    E      M     M  ..          *
 *             SSSSS     Y    SSSSS     T    EEEEEE M     M  ..          *
 *                                                                       *
 *                                                                       *
 *                                                                       *
 *                                                                       *
 *                        P. WOLFERS Software                            *
 *                                                                       *
 *                  Laboratoire de Cristallographie                      *
 *                                                                       *
 *                         B.P. 166 C.N.R.S.                             *
 *                                                                       *
 *                      25 Avenue des Martyrs                            *
 *                                                                       *
 *                      F 38042 GRENOBLE CEDEX 9                         *
 *                                                                       *
 *                                                                       *
 *************************************************************************

 /////////////////////////////////////////////////////////////////////////
 //                                                                     //
 //                    General Public License                           //
 //                                                                     //
 // This file is part of the V C++ GUI Framework, and is covered        //
 // under the terms of the GNU Library General Public License,          //
 // Version 2. This program has NO WARRANTY. See the source file        //
 // vapp.cxx for more complete information about license terms.         //
 //                                                                     //
 // This license described in this file overrides all other licenses    //
 // that might be specified in other files for this library.            //
 //                                                                     //
 // This program is free software; you can redistribute it and/or       //
 // modify it under the terms of the GNU Lesser General Public          //
 // License as published by the Free Software Foundation; either        //
 // version 2.1 of the License, or (at your option) any later version.  //
 //                                                                     //
 // This software is distributed in the hope that it will be useful,    //
 // but WITHOUT ANY WARRANTY; without even the implied warranty of      //
 // MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU   //
 // Library General Public License for more details.                    //
 //                                                                     //
 // You should have received a copy of the GNU Lesser General Public    //
 // License along with this library (see COPYING.LIB); if not, write to //
 // the Free Software Foundation :                                      //
 //                      Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  //
 //                                                                     //
 /////////////////////////////////////////////////////////////////////////
}

{
  ***********************************************************
  *                                                         *
  *                                                         *
  *            G E N   S P A C E   G R O U P                *
  *                                                         *
  *                                                         *
  *                   P R O G R A M                         *
  *                                                         *
  *                                                         *
  *      S P A C E    G R O U P    G E N E R A T O R        *
  *                                                         *
  *                                                         *
  *            Version 1.1-D -  20-OCT-2010                 *
  *                                                         *
  *                                                         *
  *   To generate the space group matrix from the name      *
  *             or number of space group.                   *
  *                                                         *
  *                                                         *
  *                                                         *
  ***********************************************************
}

const
  max_ope    =    48;                   { Maximum number of operator }
  max_ips    =   200;                   { Maximum number of individual position to handle }
  max_ipo    =    30;                   { Maximum number of position to describe }
  max_qvec   =     4;                   { Maximum number of wave vectors }
  sgrp_idlmx =    13;                   { Maximum length of a  Group Name }

  hkl_tbisz  =   512;                   { Increment for HKL Table allocation }

  EPS        = 0.00001;                 { Epsilon quantity for real equality test }

  { ***  String Formats for Symbolic Position Output (standard and data mode)  *** }

  symb_getit = ' General position of group "%g" (#%#) of order %n :%l';
  symb_datit = ' Position in Group "%g" (#%#) with order %n and multiplicity of 1/%r :%l';
  symb_dafrm = '%1c %3#/ %8s, %8s, %8s;';
  symb_dbtit = ' %3n %10.6f';
  symb_dbfrm = '%1o%1c %8s  %8s  %8s';



  { ***  String Formats for Numeric Position Output (standard and data mode)   *** }

  pos_datit  = ' Position in Group "%g" (#%#) with order %n and multiplicity of 1/%r :%l';
  pos_dafrm  = ' %3#/ %8.5v, %8.5v, %8.5v;';
  pos_dbtit  = ' %3n %10.6f';
  pos_dbfrm  = ' %9.6v  %9.6v  %9.6v';

  daucf = ' Direct Unit Cell :%2l  A  = %10.5f, B  = %10.5f, C  = %10.5f, Alpha  = %10.5f, Beta  = %10.5f, Gamma  = %10.5f;';
  raucf = '%3l Reciprocal Unit Cell :%2l  A* = %10.5f, B* = %10.5f, C* = %10.5f, Alpha* = %10.5f, Beta* = %10.5f, Gamma* = %10.5f;';
  aucef = ' %6( %10.5f%)';

  rmatlf = ' The %s :%l%3(    || %12.6f, %12.6f, %12.6f ||%1l%)';
  rmatdf = ' %9( %12.6f%)';

  operdf = ' %5#  %2i%12( %3i%)';



type

  oper_code  = ( ope_unit,                      { Define the Basic code for identity }
                 ope_inv,                       { Center of symmetry }
                 ope_2x,   ope_2y,   ope_2z,    { 2x, 2y, 2z for monoclinic, orthorombic, tetragonal and cubic }
                 ope_2u,   ope_2v,              { 2u, 2v for monoclinic, orthorombic, tetragonal and cubic }
                 ope_mx,   ope_my,   ope_mz,    { mx, my, mz for monoclinic, orthorombic, tetragonal and cubic }
                 ope_mu,   ope_mv,              { mu, mv for monoclinic, orthorombic, tetragonal and cubic }
                 ope_2x_h, ope_2y_h,            { 2x, 2y for hexagonal referencial }
                 ope_2u_h, ope_2v_h,            { 2u, 2v for hexagonal referencial }
                 ope_mx_h, ope_my_h,            { mx, my for hexagonal referencial }
                 ope_mu_h, ope_mv_h,            { mu, mv for hexagonal referencial }
                 ope_3r,   ope_3br,             { 3(111) axis and -3(111) axis for rhomboedric and cubic }
                 ope_3z_h, ope_3bz_h,           { 3z axis and -3z axis (always for hexagonal referencial) }
                 ope_4z,   ope_4bz,             { 4z axis and -4z axis }
                 ope_6z_h, ope_6bz_h            { 6z axis and -6z axis (always for hexagonal referencial) }
               );

  pgrp_dsc   = set of oper_code;                { Used for ponctual group } 

  axis_dir   = ( axis_x, axis_y, axis_z,        { Define axis operator direction }
                 axis_u, axis_v, axis_r         { x=100, y=010, z=001, u=110,v=1-10, r=111 }
               ); 

  lat_type   = ( lat_None,                      { When no lattice defined }
                 lat_P, lat_A, lat_B,           { The types of bravais lattices: P, A, B, C, I, F, H }
                 lat_C, lat_F, lat_I,
                 lat_R, lat_H
                );

  lat_kind   = ( l_und, l_tri, l_mon,           { Kind of Possible Unit Cell }
                 l_ort, l_qua, l_trg,
                 l_hex, l_rho, l_cub );

  lat_orie   = ( l_xyz, l_yzx, l_zxy,           { Lattice orientation (for monoclinic and orthorhombic) }
                 l_xzy, l_yxz, l_zyx );

  dvector    = array[1..3] of      real;        { Define a General Vector }
  operator   = array[1..3,1..4] of sbyte;       { Define a General Symmetry Operator }
  lvector    = array[1..3] of    sbyte;         { Define a Lattice Vector in /24th. }
  ivector    = array[1..3] of  integer;         { Define a full integer 3D Vector }
  matrix     = array[1..3,1..3] of real;        { Matrix tensor }
  lmatrix    = array[1..3,1..3] of sbyte;       { 3*3 Matrix }
  mattab     = array[oper_code] of lmatrix;     { Definition of Basic operator Table }
  ortbt      = array[l_yzx..l_zyx] of operator; { Change orientation operator table }

  int_tab( size: integer ) = array[1..size] of integer; { Define a variable size integer table }

  int_tbp    = ^int_tab;                        { Define the integer table pointer type }

  xyz_value  = array[1..4] of    sbyte;         { Symbolic Value for a coordinate value }
  xyz_coord  = array[1..3] of xyz_value;        { Symbolic Coordinates of a Position }

  xyz_table  = array[1..max_ope] of dvector;    { Table of position }

  sgrp_ide   = record                           { * Space Group name Definition * }
                 len: byte;
                 str: array[1..sgrp_idlmx] of char
               end;

  ipo_rec    = record                           { * Define a position record }
                 ipo_next,                      { Index of next position or 0 }
                 ipo_size,                      { Number of equivalent site in the position }
                 ipo_idx:         byte;         { Index of the first site in ips_tab }
                 ipo_prior:   unsigned;         { Display Priority of position }
                 ipo_ope:        sbyte;         { Operator code }
                 ipo_xyzpos,                    { Operator position (in 1/24 unit) }
                 ipo_xyzdir:   lvector;         { Operator Direction (in 1/24 unit) }
                 ipo_group:   pgrp_dsc          { Related ponctual group descriptor }
               end;

  hkln_tab   =    array[1..5] of sbyte;         { * Define the HKL-NQ index table (for one reflection) }

  hkl_rec    = record                           { * Define the HKL record }
                 hkl_hkl:     hkln_tab;         { IH, IK, IL, NQ reference }
                 hkl_mul:         byte;         { Related multiplicity }
                 hkl_id:       integer;         { HKL-NQ map index }
                 hkl_us2d:        real          { 1/2d (= sin(theta)/lambda ) }
               end;

  sgrp_idtb   = array[1..3] of sgrp_ide;        { Define a table of id for <x>, <y> and <z> }


  trtbty = array[lat_P..lat_H,1..3] of lvector;

  hkl_tabty( size: integer ) = array[1..size] of hkl_rec;

  hkl_tbp = ^hkl_tabty;                         { Define the HKL Flag Map pointer }



const

  ide_x       = sgrp_ide[ 1, 'x'];              { Current symbols for Position Listing }
  ide_y       = sgrp_ide[ 1, 'y'];
  ide_z       = sgrp_ide[ 1, 'z'];
  ide_null    = sgrp_ide[ 0, ' '];


  { Lattice Translation in real form }
  a_vec   = dvector[ 0.0, 0.5, 0.5 ];           { Standard Translation for A, B, C ... }
  b_vec   = dvector[ 0.5, 0.0, 0.5 ];
  c_vec   = dvector[ 0.5, 0.5, 0.0 ];
  i_vec   = dvector[ 0.5, 0.5, 0.5 ];           { ... and I and H Lattices }
  h_vec1  = dvector[ 2/3, 1/3, 1/3 ];
  h_vec2  = dvector[ 1/3, 2/3, 2/3 ];

  { Lattice Translation in 1/24 unit form }
  a_lvec  = lvector[  0, 12, 12 ];              { Standard Translation for A, B, C ... }
  b_lvec  = lvector[ 12,  0, 12 ];
  c_lvec  = lvector[ 12, 12,  0 ];
  i_lvec  = lvector[ 12, 12, 12 ];              { ... and I and H Lattices }
  h_lvec1 = lvector[ 16,  8,  8 ];
  h_lvec2 = lvector[  8, 16, 16 ];

  z_lvec  = lvector[  0,  0,  0 ];              { Null vector for initialization }


  { Basic lattice vector (in1/24 unit) for each lattice type }
  tralatb = trtbty[ [ [ 24,  0,  0], [  0, 24,  0], [  0,  0, 24] ], { lat_P }
                    [ [ 24,  0,  0], [  0, 12, 12], [  0, 12,-12] ], { lat_A }
                    [ [ 12,  0, 12], [  0, 24,  0], [ 12,  0,-12] ], { lat_B }
                    [ [ 12, 12,  0], [ 12,-12,  0], [  0,  0, 24] ], { lat_C }
                    [ [ 12, 12,  0], [ 12,  0, 12], [  0, 12, 12] ], { lat_F }
                    [ [-12, 12, 12], [ 12,-12, 12], [ 12, 12,-12] ], { lat_I }
                    [ [ 24,  0,  0], [  0, 24,  0], [  0,  0, 24] ], { lat_R }
                    [ [ 16,  8,  8], [ -8,  8,  8], [ -8,-16,  8] ]  { lat_H }
                  ];

  identity_xyz = xyz_coord[ [ 1, 0, 0, 0],      { For (1*x + 0*y + 0*z + 0, }
                            [ 0, 1, 0, 0],      { ...  0*x + 1*y + 0*z + 0, }
                            [ 0, 0, 1, 0] ];    { ...  0*x + 0*y + 1*z + 0) = (x,y,z); }


  identity_ope = operator[ [ 1, 0, 0, 0],       { Define the identity operator }
                           [ 0, 1, 0, 0],
                           [ 0, 0, 1, 0] ];

  center_ope   = operator[ [-1, 0, 0, 0],       { Define the symetry center operator }
                           [ 0,-1, 0, 0],
                           [ 0, 0,-1, 0] ];

  ope_tab = mattab[
      [ [ 1, 0, 0], [ 0, 1, 0], [ 0, 0, 1] ],   { ope_identity : Identity operator }
      [ [-1, 0, 0], [ 0,-1, 0], [ 0, 0,-1] ],   { ope_center : Symmetry Center }

      [ [ 1, 0, 0], [ 0,-1, 0], [ 0, 0,-1] ],   { ope_2x  : 2x axis in orthogonal referential }
      [ [-1, 0, 0], [ 0, 1, 0], [ 0, 0,-1] ],   { ope_2y  : 2y axis in orthogonal referential }
      [ [-1, 0, 0], [ 0,-1, 0], [ 0, 0, 1] ],   { ope_2z  : 2z axis for monoclinic and orthogonal }
      [ [ 0, 1, 0], [ 1, 0, 0], [ 0, 0,-1] ],   { ope_2u  : 2u axis in orthogonal referential }
      [ [ 0,-1, 0], [-1, 0, 0], [ 0, 0,-1] ],   { ope_2v  : 2v axis in orthogonal referential }

      [ [-1, 0, 0], [ 0, 1, 0], [ 0, 0, 1] ],   { ope_mx  : mx mirror in orthogonal referential }
      [ [ 1, 0, 0], [ 0,-1, 0], [ 0, 0, 1] ],   { ope_my  : my mirror in orthogonal referential }
      [ [ 1, 0, 0], [ 0, 1, 0], [ 0, 0,-1] ],   { ope_mz  : mz mirror in orthogonal referential }
      [ [ 0,-1, 0], [-1, 0, 0], [ 0, 0, 1] ],   { ope_mu  : mu mirror in orthogonal referential }
      [ [ 0, 1, 0], [ 1, 0, 0], [ 0, 0, 1] ],   { ope_mv  : mv mirror in orthogonal referential }

      [ [ 1,-1, 0], [ 0,-1, 0], [ 0, 0,-1] ],   { ope_2x_h  : 2x axis in hexagonal }
      [ [-1, 0, 0], [-1, 1, 0], [ 0, 0,-1] ],   { ope_2y_h  : 2y axis in hexagonal }
      [ [ 1, 0, 0], [ 1,-1, 0], [ 0, 0,-1] ],   { ope_2u_h  : 2u axis in hexagonal }
      [ [-1, 1, 0], [ 0, 1, 0], [ 0, 0,-1] ],   { ope_2v_h  : 2v axis in hexagonal }

      [ [-1, 1, 0], [ 0, 1, 0], [ 0, 0, 1] ],   { ope_mx_h  : mx mirror in hexagonal }
      [ [ 1, 0, 0], [ 1,-1, 0], [ 0, 0, 1] ],   { ope_my_h  : my mirror in hexagonal }
      [ [-1, 0, 0], [-1, 1, 0], [ 0, 0, 1] ],   { ope_mu_h  : mu mirror in hexagonal }
      [ [ 1,-1, 0], [ 0,-1, 0], [ 0, 0, 1] ],   { ope_mv_h  : mv mirror in hexagonal }

      [ [ 0, 0, 1], [ 1, 0, 0], [ 0, 1, 0] ],   { ope_3r    : 3z axis in hexagonal }
      [ [ 0, 0,-1], [-1, 0, 0], [ 0,-1, 0] ],   { ope_3br   : -3z axis in hexagonal }

      [ [ 0,-1, 0], [ 1,-1, 0], [ 0, 0, 1] ],   { ope_3z_h  : 3z axis in hexagonal }
      [ [ 0, 1, 0], [-1, 1, 0], [ 0, 0,-1] ],   { ope_3bz_h : -3z axis in hexagonal }

      [ [ 0,-1, 0], [ 1, 0, 0], [ 0, 0, 1] ],   { ope_4 : 4z axis in tetragonal and cubic }
      [ [ 0, 1, 0], [-1, 0, 0], [ 0, 0,-1] ],   { ope_4bz : -4z axis in tetragonal and cubic }

      [ [ 1,-1, 0], [ 1, 0, 0], [ 0, 0, 1] ],   { ope_6z_h : 6z axis in hexagonal }
      [ [-1, 1, 0], [-1, 0, 0], [ 0, 0,-1] ]    { ope_6bz_h : -6z axis in hexagonal }
    ];


  oroptb = ortbt[ [ [ 0, 1, 0, 0 ], [ 0, 0, 1, 0 ], [ 1, 0, 0, 0 ] ], { l_yzx }
                  [ [ 0, 0, 1, 0 ], [ 1, 0, 0, 0 ], [ 0, 1, 0, 0 ] ], { l_zxy }
                  [ [ 1, 0, 0, 0 ], [ 0, 0, 1, 0 ], [ 0, 1, 0, 0 ] ], { l_xzy }
                  [ [ 0, 1, 0, 0 ], [ 1, 0, 0, 0 ], [ 0, 0, 1, 0 ] ], { l_yxz }
                  [ [ 0, 0, 1, 0 ], [ 0, 1, 0, 0 ], [ 1, 0, 0, 0 ] ]  { l_zyx }
                ];


type

  sgrp_entry =  record                          { * Space Group Table Entry Definition * }
                  sgrp_name:   sgrp_ide;        { Space Group Identifier (or name) }
                  sgrp_inid,                    { Space group Number }
                  sgrp_subg:    integer;        { Sub Group number (or 0) }
                  sgrp_oper:  oper_code;        { Operator code to insert }
                  sgrp_tran,                    { Operator related translation }
                  sgrp_shift:   lvector;        { Shift of subgroup }
                  sgrp_orien:  lat_orie;        { Flag for orientation change }
                  sgrp_nsys:   lat_kind         { Related lattice }
                end;

  sgrp_cvent  = record
                  sgrp_cname:  sgrp_ide;        { Space Group Identifier (or name) }
                  sgrp_corien: lat_orie;        { Orientation change to apply }
                  sgrp_cinid:  integer          { Related Space group Reference }
                end;

  qwvect      = record                          { * Define the Wave vector record }
                  qw_vect:     dvector;         { Wave vector componante }
                  qw_nqmi,                      { NQ Minimum and Maximum }
                  qw_nqma,
                  qw_nf,                        { The smallest nf number > with nf*Wave_vector = reciprocal lattice vector }
                  qw_msup:     integer;         { Attached Lattice translation in HKL-NQ map shift }
                  qw_gkt: array[1..48] of lvector; { G-K Group translation table }
                  qw_nfqv:     lvector;         { Vector nf*qw }
                  qw_rflg:     boolean          { Flag when rational wave vector (in nq range detection) }
                end;


  hkl_iqtbt( n, m: integer ) = array[1..n,1..m] of integer; { Define the (iq,nq) sets HKL-NQ map offset table type }

  hkl_qnset = record                            { * Define the (iq,nq) set type }
                iqv, nqv: sbyte
              end;

  hkl_idtbt( n: integer ) = array[1..n] of hkl_qnset; { Define the HKL-NQ map (iq,nq) sets table type }

  sgrp_tbty( sgrp_tblen: integer )  = array[1..sgrp_tblen] of sgrp_entry;

  sgrp_tbct( sgrp_cvlen: integer )  = array[1..sgrp_cvlen] of sgrp_cvent;

  %include 'MXDSRC:mxd_group_data.pas';


var
  grp_iponb,                                    { Total number site in the grp_ipstb table }
  grp_ipofrs,                                   { First position index }
  grp_ipsnb,                                    { Total number site in the grp_ipstb table }
  grp_nope,                                     { Number of operator in the group }
  grp_invope,                                   { Index of Inversion operator when it is present in the group }
  grp_number:   integer :=           0;         { International Table Space Group Number }
  grp_sys:      lat_kind    :=   l_und;         { Type of lattice system to use }
  grp_orient:   lat_orie    :=   l_xyz;         { Selected orientation }

  d_aa, d_bb, d_cc, d_al, d_be, d_ga,           { Direct Unit Cell parameter }
  r_aa, r_bb, r_cc, r_al, r_be, r_ga,           { Reciprocal Unit Cell parameter }
  d_vol, r_vol: real    :=        -2.0;         { Direct and Reciprocal Unit cell Volume }

  grp_us2dm:    real    :=         1.0;         { 1/2d maximum for the HKL generator }
  grp_qvect:  array[1..max_qvec] of qwvect;     { Table of Wave vectors }
  grp_hklmax:  ivector := [31, 31, 31];         { HKL Generator Indices Limits }
  grp_qvnbr:    integer :=           0;         { Number of used Wave vector }

  hkl_wavel,                                    { Wave Length when required }
  hkl_thmin,                                    { Minimum and maximum for theta }
  hkl_thmax,
  hkl_d2min,                                    { Minimum value for (1/d)**2 }
  hkl_d2m:      real    :=         0.0;         {  Requested maximum of SQR( 1/d ) }

  hkl_h0,  hkl_k0,  hkl_l0,                     { HKL-NQ Map indecies }
  hkl_elh, hkl_elk, hkl_ell,                    { Values to compute HKL Map index from H,K,L }
  hkl_nh,  hkl_nk, hkl_nl, hkl_nhk,             { Values to compute HKL Map index from H,K,L }
  hkl_mdim,                                     { HKL-NQ map size (in integer) }
  hkl_morg,                                     { HKL-NQ map origine (position of (0,0,0,0) }
  hkl_nqorg,                                    { HKL-NQ translation table iqtb origine }
  hkl_nhkl:     integer :=           0;         { Total number of hkl record }

  hkl_htab:     hkl_tbp :=         nil;         { Pointer to the current HKL record table }
  hkl_itab,                                     { Pointer of Hkl Table index }
  hkl_hmap:     int_tbp :=         nil;         { Map of HKL Use (for non equivalent management) }

  hkl_etb:     array[1..48] of integer;         { * Define an HKL-NQ Equivalent references table }
  hkl_neq:                     integer;         { Number of equivalent reflections }

  hkl_iqtb:     ^hkl_iqtbt     :=  nil;         { (iq,nq) sets HKL-NQ map offset table pointer }
  hkl_idtb:     ^hkl_idtbt     :=  nil;         { HKL-NQ map (iq,nq) sets table pointer }

  hkl_gkftb,                                    { Table of Wave-vector K Space Group flags }
  hkl_wvftb:    array[1..max_qvec,1..max_ope] of boolean;       { Table of Wave-vector invariance sub-groupe flags }

  grp_tmd,                                      { Matrix for Direct Cell to Work space } 
  grp_tmr,                                      { Matrix for Reciprocal Cell to Work space } 
  grp_dmt,                                      { Direct Metric Tensor }
  grp_rmt:                      matrix;         { Reciprocal Metric Tensor }

  grp_name:     grp_str :=          '';         { Define the Space Group name }
  grp_lattice:  lat_type :=      lat_P;         { The Lattice Type }

  grp_oper:     array[1..max_ope] of operator;  { Table of Space Group operator }
  grp_opef:     array[1..max_ope] of boolean;   { Table of Use Flag for S.G. operator }
  grp_ipstb:    array[1..max_ips] of xyz_coord; { Table to store all individual position }
  grp_ipotb:    array[1..max_ipo] of ipo_rec;   { Table to store all position of group }

  grp_utrans:                  lvector;         { User Translation if specified }

  grp_wrequ:    integer         :=   3;         { Flags Word for Equiv HKL suppress process :
                                                  (0 nothing, 1 => no -h-k,-l, 2 => no Equiv (except center) }

  grp_dataf,                                    { Flag for data format (without comment) }
  grp_normf,                                    { Flag for Normalized output }
  grp_org,                                      { Flag to force a new origine }
  grp_nsort,                                    { Flag to do not sort (with 1/2d) an HKL list }
  grp_cell:     boolean :=       false;         { Flag set when a Unit Cell management is actived }




{********************************************************************}
{*     GEN_SPACE_GROUP Operator and Vector Management Routines      *}
{********************************************************************}


procedure ANORM_VECT( var dr: array[sz:integer] of sbyte );
{ To normalize any lvector or symbolic part of xyz_value (index 1..3) }
var
  mi, ma, mv, me: integer;

begin
  mi := 0;
  for i := 1 to 3 do
  begin
    mv := ABS( dr[i] );
    if mv <> 0 then
      if mi = 0 then mi := mv
                else if mv < mi then mi := mv
  end;
  mv := mi; ma := 1;
  if mi > 1 then me := mv div 2
            else me := 1;

  while (mv > 1) and 
        ((dr[1] mod mv <> 0) or (dr[2] mod mv <> 0) or (dr[3] mod mv <> 0)) do
  begin
    repeat
      ma := ma + 1
    until (mi rem ma = 0) or (ma > me);
    mv := mi div ma
  end;
  if (mv > 1) then
    for i := 1 to 3 do  dr[i] := dr[i] div mv
end ANORM_VECT;



procedure FRACTION_SIMPLIFY( var n, d: integer; v: integer );
{ Simplify the 24th fraction for output }
begin
(*
  if v > 12 then n := v - 24
            else n := v;
*)
  n := v;
  if n = 0 then d := 0
  else
  if n rem 12 = 0 then begin  n := n div 12; d := 2  end
  else
  if n rem  8 = 0 then begin  n := n div 8; d :=  3  end
  else
  if n rem  6 = 0 then begin  n := n div 6; d :=  4  end
  else
  if n rem  4 = 0 then begin  n := n div 4; d :=  6  end
  else
  if n rem  3 = 0 then begin  n := n div 3; d :=  8  end
  else
  if n rem  2 = 0 then begin  n := n div 2; d := 12  end
  else d := 24
end FRACTION_SIMPLIFY;



procedure DISPLAY_OPERATOR( var f: text; in_var name: string; in_var oper: operator );
forward;



procedure SIMPLIFY_VECTOR( var v:  dvector );
{ Simplify the translation by Lattice translation application }

  procedure ADD_VEC( var v: dvector; in_var c: dvector );
  begin
    for i := 1 to 3 do
      v[i] := v[i] + c[i]
  end ADD_VEC;

  procedure SUB_VEC( var v: dvector; in_var c: dvector );
  begin
    for i := 1 to 3 do
      v[i] := v[i] - c[i]
  end SUB_VEC;


begin
  { Simplify the translation of the operator when possible }
  case grp_lattice of
    lat_A: if (v[2] > 0.5) and (v[3] > 0.5) then SUB_VEC( v, a_vec )
           else
             if (v[2] <= -0.5) and (v[3] <= -0.5) then ADD_VEC( v, a_vec );

    lat_B: if (v[3] >= 0.5) and (v[1] >= 0.5) then SUB_VEC( v, b_vec )
           else
             if (v[3] <= -0.5) and (v[1] <= -0.5) then ADD_VEC( v, b_vec );

    lat_C: if (v[1] >= 0.5) and (v[2] >= 0.5) then SUB_VEC( v, c_vec )
           else
             if (v[1] <= -0.5) and (v[2] <= -0.5) then ADD_VEC( v, c_vec );

    lat_F: begin
             if v[1] >= 0.5 then SUB_VEC( v, b_vec )
             else
               if v[1] <= -0.5 then ADD_VEC( v, b_vec );
             if (v[2] >= 0.5) and (v[3] >= 0.5) then SUB_VEC( v, a_vec )
             else
               if (v[2] <= -0.5) and (v[3] <= -0.5) then ADD_VEC( v, a_vec )
           end;

    lat_I: if v[1] >= 0.5 then SUB_VEC( v, i_vec )
           else
             if v[1] <= -0.5 then ADD_VEC( v, i_vec );

    lat_H: if v[3] >= 2/3 then SUB_VEC( v, h_vec2 )
           else
             if v[3] <= -2/3 then ADD_VEC( v, h_vec2 )
             else
               if v[3] >= 1/3 then SUB_VEC( v, h_vec1 )
               else
                 if v[3] <= -1/3 then ADD_VEC( v, h_vec1 )

  otherwise
  end
end SIMPLIFY_VECTOR;



procedure REDUCE_LVECTOR( var v: lvector );
{ Reduce to unique form the v vector (in 1/24 unit) by lattice translation when possible }

  procedure SUB_LVECT( var v: lvector; i, j, q: integer );
  begin
    v[i] := (v[i] - q) mod 24;
    v[j] := (v[j] - q) mod 24
  end SUB_LVECT;


begin { REDUCE_LVECTOR }
  case grp_lattice of
    lat_A: if v[2] >= 12 then SUB_LVECT( v, 2, 3, 12 );
    lat_B: if v[1] >= 12 then SUB_LVECT( v, 1, 3, 12 );
    lat_C: if v[1] >= 12 then SUB_LVECT( v, 1, 2, 12 );
    lat_F: begin
             if v[1] >= 12 then SUB_LVECT( v, 1, 2, 12 );
             if v[2] >= 12 then SUB_LVECT( v, 2, 3, 12 )
           end;
    lat_I: if v[1] >= 12 then
           begin  SUB_LVECT( v, 1, 2, 12 ); v[3] := (v[3] - 12) mod 24  end;

    lat_H: case v[3] of
             4: begin  SUB_LVECT( v, 2, 3, -8 ); v[1] := (v[1] + 16) mod 24  end;
             8: begin  SUB_LVECT( v, 2, 3,  8 ); v[1] := (v[1] - 16) mod 24  end;
            16: begin  SUB_LVECT( v, 2, 3, 16 ); v[1] := (v[1] -  8) mod 24  end;
            20: begin  SUB_LVECT( v, 2, 3,  8 ); v[1] := (v[1] - 16) mod 24  end;
           otherwise
           end;
  otherwise
  end
end REDUCE_LVECTOR;



procedure VECTOR_RANGE( var v: dvector );
{ To set the vector fractional coordinates in the range ]-0.5,0.5] }
begin
  for i := 1 to 3 do
  begin
    v[i] := v[i] - TRUNC( v[i] );
    if v[i] <= -0.5 then  v[i] := v[i] + 1.0
    else
      if v[i] > 0.5 then  v[i] := v[i] - 1.0;
  end;
  SIMPLIFY_VECTOR( v )
end VECTOR_RANGE;



function * ( in_var o: operator; in_var v: dvector ): dvector;
{ Applied an operator to a vector }
var
  r: dvector;

begin
  r[1] :=  o[1,1]*v[1] + o[1,2]*v[2] + o[1,3]*v[3] + o[1,4]/24.0;
  r[2] :=  o[2,1]*v[1] + o[2,2]*v[2] + o[2,3]*v[3] + o[2,4]/24.0;
  r[3] :=  o[3,1]*v[1] + o[3,2]*v[2] + o[3,3]*v[3] + o[3,4]/24.0;
  VECTOR_RANGE( r );
  return r
end { * };


function + ( in_var v1, v2: dvector ): dvector;
{ Perform addition of two vectors }
var
  r: dvector;

begin
  r[1] :=  v1[1] + v2[1]; r[2] :=  v1[2] + v2[2]; r[3] :=  v1[3] + v2[3];
  VECTOR_RANGE( r );
  return r
end { + };



function - ( in_var v1, v2: dvector ): dvector;
{ Perform substraction of two vectors }
var
  r: dvector;

begin
  r[1] :=  v1[1] - v2[1]; r[2] :=  v1[2] - v2[2]; r[3] :=  v1[3] - v2[3];
  VECTOR_RANGE( r );
  return r
end { - };



function - ( v: dvector ): dvector;
{ Perform minus operator on a vector }
begin
  v[1] :=  - v[1]; v[2] :=  v[2]; v[3] :=  - v[3];
  VECTOR_RANGE( v );
  return v
end { - };



function * ( in_var v1, v2: dvector ): real;
{ Compute the Squared size of a vector by using the metric tensor }
var
  r: real;

begin
  r := v1[1]*grp_dmt[1,1]*v2[1] + 2.0*v1[1]*grp_dmt[1,2]*v2[2] + 2.0*v1[1]*grp_dmt[1,3]*v2[3] +
                                      v1[2]*grp_dmt[1,1]*v2[2] + 2.0*v1[2]*grp_dmt[1,2]*v2[3] +
                                                                     v1[3]*grp_dmt[1,1]*v2[3];
  return r
end { * };



function = ( in_var v1, v2: dvector ): boolean;
{ Perform substraction of two vectors }
begin
  for i := 1 to 3 do
    if ABS( v2[i] - v1[i] ) > 1.0E-5 then return false;
  return true
end { = };



function <> ( in_var v1, v2: dvector ): boolean;
{ Perform NEQ operator of two vectors }
var
  d: dvector;

  function VECTOR_NEQ( in_var v1, v2: dvector ): boolean;
  { Basic NEQ operator of two vectors }
  begin
    for i := 1 to 3 do
      if ABS( v1[i] - v2[i] ) > 1.0E-5 then return true;
    return false
  end VECTOR_NEQ;


begin { <> }
  if VECTOR_NEQ( v1, v2 ) then
  begin
    d := v1 - v2;
    case grp_lattice of
      lat_A: return VECTOR_NEQ( d, a_vec ) and VECTOR_NEQ( d, -a_vec );

      lat_B: return VECTOR_NEQ( d, b_vec ) and VECTOR_NEQ( d, -b_vec );

      lat_C: return VECTOR_NEQ( d, c_vec ) and VECTOR_NEQ( d, -c_vec );

      lat_F: return VECTOR_NEQ( d, a_vec ) and VECTOR_NEQ( d, -a_vec ) and
                    VECTOR_NEQ( d, b_vec ) and VECTOR_NEQ( d, -b_vec ) and
                    VECTOR_NEQ( d, c_vec ) and VECTOR_NEQ( d, -c_vec );

      lat_I: return VECTOR_NEQ( d, i_vec ) and VECTOR_NEQ( d, -i_vec );

      lat_H: return VECTOR_NEQ( d, h_vec1 ) and VECTOR_NEQ( d, h_vec2 ) and
                    VECTOR_NEQ( d,-h_vec1 ) and VECTOR_NEQ( d,-h_vec2 ); 

    otherwise
      return true
    end
  end;
  return false
end { <> };



function R_LATTICE_VECTOR( h: dvector ): boolean;
var
  ih, ik, il: integer;
  re:         boolean;

begin
  ih := ROUND( h[1] ); ik := ROUND( h[2] ); il := ROUND( h[3] );
  if (ABS( h[1] - ih ) > EPS) or (ABS( h[2] - ik ) > EPS) or (ABS( h[3] - il ) > EPS) then re := false
  else
    case grp_lattice of
      lat_A: re := (ik + il) mod 2 = 0;
      lat_B: re := (il + ih) mod 2 = 0;
      lat_C: re := (ih + ik) mod 2 = 0;
      lat_F: re := ((ih + ik) mod 2 = 0) and ((il + ih) mod 2 = 0);
      lat_I: re := (ih + ik + il) mod 2 = 0;
      lat_H: re := (-ih + ik + il) mod 3 = 0;
    otherwise
      re := true
    end;
(*
WRITELN( ' (', h[1]:7:4, h[2]:7:4, h[3]:7:4, ') -> (', ih:4, ik:4, il:4, ') is reciprocal lattice vector = ', re );
*)
  R_LATTICE_VECTOR := re
end R_LATTICE_VECTOR;



function * ( in_var o1, o2: operator ): operator;
{ Compute the product of two operator }
var
  re: operator;

begin
  re[1,1] :=  o1[1,1]*o2[1,1] + o1[1,2]*o2[2,1] + o1[1,3]*o2[3,1];
  re[1,2] :=  o1[1,1]*o2[1,2] + o1[1,2]*o2[2,2] + o1[1,3]*o2[3,2];
  re[1,3] :=  o1[1,1]*o2[1,3] + o1[1,2]*o2[2,3] + o1[1,3]*o2[3,3];
  re[1,4] := (o1[1,1]*o2[1,4] + o1[1,2]*o2[2,4] + o1[1,3]*o2[3,4] + o1[1,4]) mod 24;
  re[2,1] :=  o1[2,1]*o2[1,1] + o1[2,2]*o2[2,1] + o1[2,3]*o2[3,1];
  re[2,2] :=  o1[2,1]*o2[1,2] + o1[2,2]*o2[2,2] + o1[2,3]*o2[3,2];
  re[2,3] :=  o1[2,1]*o2[1,3] + o1[2,2]*o2[2,3] + o1[2,3]*o2[3,3];
  re[2,4] := (o1[2,1]*o2[1,4] + o1[2,2]*o2[2,4] + o1[2,3]*o2[3,4] + o1[2,4]) mod 24;
  re[3,1] :=  o1[3,1]*o2[1,1] + o1[3,2]*o2[2,1] + o1[3,3]*o2[3,1];
  re[3,2] :=  o1[3,1]*o2[1,2] + o1[3,2]*o2[2,2] + o1[3,3]*o2[3,2];
  re[3,3] :=  o1[3,1]*o2[1,3] + o1[3,2]*o2[2,3] + o1[3,3]*o2[3,3];
  re[3,4] := (o1[3,1]*o2[1,4] + o1[3,2]*o2[2,4] + o1[3,3]*o2[3,4] + o1[3,4]) mod 24;
  return re
end { * };



function INV_MATRIX( in_var m: matrix ): matrix;
{ Compute the inverse matrix m**-1 of m }
var
  de: real;
  ik, ir, jk, jr: integer;

begin
  de := 0.0;
  { Compute the determinant de }
  for i:= 1 to 3 do
  begin ik := i mod 3 + 1; ir := ik mod 3 + 1;
    de := de + m[i,1] * (m[ik,2]*m[ir,3] - m[ik,3]*m[ir,2])
  end;
  { Now inverse the matrix }
  for i := 1 to 3 do for j := 1 to 3 do
  begin
    ik := i mod 3 + 1; ir := ik mod 3 + 1;
    jk := j mod 3 + 1; jr := jk mod 3 + 1;
    INV_MATRIX[j,i] := (m[ik,jk]*m[ir,jr] - m[ir,jk]*m[ik,jr])/de
  end
end INV_MATRIX;



function DET_OPERATOR( in_var op: operator ): real;
var
  d: real;

begin
  DET_OPERATOR := op[1,1]*(op[2,2]*op[3,3] - op[2,3]*op[3,2]) +
                  op[1,2]*(op[2,3]*op[3,1] - op[2,1]*op[3,3]) +
                  op[1,3]*(op[2,1]*op[3,2] - op[2,2]*op[3,1])
end DET_OPERATOR;



function INV_OPERATOR( in_var op: operator ): operator;
{ Compute the inverse operator op**-1 of op }
var
  de, ik, ir, jk, jr: integer;
  re: operator;

begin
  { Compute the determinant de }
  de := op[1,1]*(op[2,2]*op[3,3] - op[2,3]*op[3,2]) +
        op[1,2]*(op[2,3]*op[3,1] - op[2,1]*op[3,3]) +
        op[1,3]*(op[2,1]*op[3,2] - op[2,2]*op[3,1]);
  if de = 0 then de := 1000;
  { Now inverse the matrix }
  for i := 1 to 3 do
    for j := 1 to 3 do
    begin
      ik := i mod 3 + 1; ir := ik mod 3 + 1;
      jk := j mod 3 + 1; jr := jk mod 3 + 1;
      re[j,i] := (op[ik,jk]*op[ir,jr] - op[ir,jk]*op[ik,jr]) div de
    end;

  { Now add the translation Trans( op**-1 ) = - (op**-1)*Trans( op ) }
  for i := 1 to 3 do
    re[i,4] := ( - re[i,1]*op[1,4] - re[i,2]*op[2,4] - re[i,3]*op[3,4]) mod 24;
  INV_OPERATOR := re
end INV_OPERATOR;


function CANONIC_TRANS( in_var tr, op: operator ): operator;
{ Compute the product tr*op*tr**-1 }
var
  r: operator;

begin
  CANONIC_TRANS := tr*op*INV_OPERATOR( tr )
end CANONIC_TRANS;



procedure TRANSLATE_OPERATOR( var op: operator; in_var lsh: lvector );
begin
  for i := 1 to 3 do
    op[i,4] := (op[i,4] + lsh[i] -
                 (op[i,1]*lsh[1] + op[i,2]*lsh[2] + op[i,3]*lsh[3])) mod 24
end TRANSLATE_OPERATOR;




{********************************************************************}
{*    GEN_SPACE_GROUP Position Coordinates Management Procedures    *)
{********************************************************************}


function LVEC_EQU( in_var v1, v2: lvector ): boolean;
{ Basic NEQ operator of two vectors }
begin
  for i := 1 to 3 do
    if ( v1[i] - v2[i] ) mod 24 <> 0 then return false;
  return true
end LVEC_EQU;



function = ( in_var v1, v2: lvector ): boolean;
{ Perform EQUAL operator of two vectors in 1/24 unit }
var
  df: lvector;

begin { = }
  if not LVEC_EQU( v1, v2 ) then
  begin
    for i := 1 to 3 do df[i] := (v1[i] - v2[i]) mod 24;
    case grp_lattice of
      lat_A: return LVEC_EQU( df, a_lvec );
      lat_B: return LVEC_EQU( df, b_lvec );
      lat_C: return LVEC_EQU( df, c_lvec );
      lat_F: return LVEC_EQU( df, a_lvec ) or LVEC_EQU( df, b_lvec ) or LVEC_EQU( df, c_lvec );
      lat_I: return LVEC_EQU( df, i_lvec );
      lat_H: return LVEC_EQU( df, h_lvec1 ) or LVEC_EQU( df, h_lvec2 );
    otherwise
      return false
    end
  end;
  return true
end { = };



procedure FIT_XYZ( var xyz:  xyz_coord; i, j, v: integer );
begin
  xyz[i,4] := (xyz[i,4] - v) mod 24;
  xyz[j,4] := (xyz[j,4] - v) mod 24
end FIT_XYZ;



procedure SIMPLIFY_XYZ( var xyz:  xyz_coord );
{ Simplify the translation by Lattice translation application }
begin
  for i := 1 to 3 do xyz[i,4] := xyz[i,4] mod 24;
  { Simplify the translation of the operator when possible }
  case grp_lattice of
    lat_A: if xyz[2,4] >= 12 then FIT_XYZ( xyz, 2, 3, 12 );
    lat_B: if xyz[3,4] >= 12 then FIT_XYZ( xyz, 3, 1, 12 );
    lat_C: if xyz[1,4] >= 12 then FIT_XYZ( xyz, 1, 2, 12 );
    lat_F: begin
             if xyz[3,4] >= 12 then FIT_XYZ( xyz, 2, 3, 12 );
             if xyz[2,4] >= 12 then FIT_XYZ( xyz, 1, 2, 12 )
           end;
    lat_I: if xyz[3,4] >= 12 then 
           begin
             FIT_XYZ( xyz, 1, 2, 12 ); xyz[3,4] := (xyz[3,4] - 12) mod 24
           end;
    lat_H: if xyz[3,4] >= 16 then
           begin
             FIT_XYZ( xyz, 2, 3, 16 ); xyz[1,4] := (xyz[1,4] -  8) mod 24
           end
           else
             if xyz[3,4] >=  8 then
             begin  FIT_XYZ( xyz, 2, 3,  8 ); xyz[1,4] := (xyz[1,4] - 16) mod 24  end;

  otherwise
  end
end SIMPLIFY_XYZ;



function TEST_EQU_XYZ( in_var v1, v2: xyz_coord ): boolean;
{ Perform NEQ operator of two symbolic positions }
var
  nb: integer := 0;
  df: lvector;

begin { TEST_EQU_XYZ }
  { Compare the variable part (it must be equal) }
  for i := 1 to 3 do
  begin
    for j := 1 to 3 do
      if v1[i,j] <> v2[i,j] then return false;
    if (v1[i,4] - v2[i,4]) mod 24 = 0 then nb := nb + 1
  end;
  if nb = 3 then return true;
  begin
    for i := 1 to 3 do df[i] := (v1[i,4] - v2[i,4]) mod 24;
    case grp_lattice of
      lat_A: return LVEC_EQU( df, a_lvec );
      lat_B: return LVEC_EQU( df, b_lvec );
      lat_C: return LVEC_EQU( df, c_lvec );
      lat_F: return LVEC_EQU( df, a_lvec ) or LVEC_EQU( df, b_lvec ) or LVEC_EQU( df, c_lvec );
      lat_I: return LVEC_EQU( df, i_lvec );
      lat_H: return LVEC_EQU( df, h_lvec1 ) or LVEC_EQU( df, h_lvec2 );
    otherwise
      return false
    end
  end;
  return false
end TEST_EQU_XYZ;



procedure SIMPLIFY_XYZEQU( var xyz: xyz_coord );
var
  icat: integer;


  function XYZ_VARIABLE( in_var c: xyz_value ): boolean;
  { Check for symbolic/Variable part in a coordinate }
  begin
    XYZ_VARIABLE := (c[1] <> 0) or (c[2] <> 0) or (c[3] <> 0)
  end XYZ_VARIABLE;


  function XYZ_VPROP( in_var c1, c2: xyz_value ): real;
  { Evaluate the symbolic ratio c2/c1 when the two coordinates
    are proportional, return 0.0 when the coordinate are not proportional }
  var
    i, j, k: integer;

  begin
    i := 1;
    repeat
      j := i mod 3 + 1; k := j mod 3 + 1;
    exit if (c1[j]*c2[k] - c1[k]*c2[j]) <> 0;
      i := i + 1
    until i > 3;
    if i <= 3 then
      XYZ_VPROP := 0.0
    else
      { Form (u.v)/(u.u) == v/u }
      XYZ_VPROP := (c1[1]*c2[1] + c1[2]*c2[2] + c1[3]*c2[3])/
                   (SQR( c1[1] ) + SQR( c1[2] ) + SQR( c1[3] ))
  end XYZ_VPROP;


  procedure SET_FREE_VXYZ( var xyz: xyz_value; i: integer; fc: integer := 1 );
  { Set as a free variable/symbol (i=1/2/3 for x/y/z) in the given coordinate.
    Any translation part is automaticaly cleared as without signifiance.
  }
  begin
    for j := 1 to 4 do
      if i = j then xyz[j] := 1
               else xyz[j] := 0
  end SET_FREE_VXYZ;


  procedure SET_DEP_1VXYZ( var xyz: xyz_value; i: integer; fc: real := 1.0 );
  begin
    for j := 1 to 3 do
      if i = j then xyz[j] := ROUND( fc )
               else xyz[j] := 0;
    xyz[4] := xyz[4] mod 24
(*  xyz[4] := (ROUND( fc )*xyz[4]) mod 24 /// *)
  end SET_DEP_1VXYZ;


  procedure SET_DEP_2VXYZ( var xyz: xyz_coord; i, j: integer );
  var
    fc: real;

  begin
    fc := XYZ_VPROP( xyz[i], xyz[j] );
    if fc = 0.0 then { the two componantes are independante }
    begin
      SET_FREE_VXYZ( xyz[i], i ); SET_FREE_VXYZ( xyz[j], j )
    end
    else
      if ABS( fc ) >= 1.0 then
      begin
        xyz[j,4] := (xyz[j,4] - ROUND( fc*xyz[i,4] )) mod 24;
        SET_FREE_VXYZ( xyz[i], i ); SET_DEP_1VXYZ( xyz[j], i, fc )
      end
      else
      begin
        xyz[i,4] := (xyz[i,4] - ROUND( (1.0/fc)*xyz[j,4] )) mod 24;
        SET_FREE_VXYZ( xyz[j], j ); SET_DEP_1VXYZ( xyz[i], j, 1.0/fc )
      end
  end SET_DEP_2VXYZ;


  procedure SET_DEP_3VXYZ( var xyz: xyz_coord );
  var
    fxy, fyz, fzx: real;

  begin
    fxy := XYZ_VPROP( xyz[1], xyz[2] );
    fyz := XYZ_VPROP( xyz[2], xyz[3] );
    fzx := XYZ_VPROP( xyz[3], xyz[1] );
    if fxy*fyz*fzx = 0.0 then
      if (fxy = 0.0) and (fzx = 0.0) then
      begin { X is independant, perhaps Y and Z also }
        SET_FREE_VXYZ( xyz[1], 1 );
        if fyz = 0.0 then { The three componantes are independante }
        begin
          SET_FREE_VXYZ( xyz[2], 2 ); SET_FREE_VXYZ( xyz[3], 3 )
        end
        else
          if ABS( fyz ) >= 1.0 then
          begin
            xyz[3,4] := (xyz[3,4] - ROUND( fyz*xyz[2,4] )) mod 24;
            SET_FREE_VXYZ( xyz[2], 2 ); SET_DEP_1VXYZ( xyz[3], 2, fyz )
          end
          else
          begin
            xyz[2,4] := (xyz[2,4] - ROUND( (1.0/fyz)*xyz[3,4] )) mod 24;
            SET_FREE_VXYZ( xyz[3], 3 ); SET_DEP_1VXYZ( xyz[2], 3, 1.0/fyz )
          end
      end
      else
      if (fyz = 0.0) and (fxy = 0.0) then
      begin { Y is independant, Z and X coupled }
        SET_FREE_VXYZ( xyz[2], 2 );
        if ABS( fzx ) > 1.0 then
        begin
          xyz[1,4] := (xyz[1,4] - ROUND( fzx*xyz[3,4] )) mod 24;
          SET_FREE_VXYZ( xyz[3], 3 ); SET_DEP_1VXYZ( xyz[1], 3, fzx )
        end
        else
        begin
          xyz[3,4] := (xyz[3,4] - ROUND( (1.0/fzx)*xyz[1,4] )) mod 24;
          SET_FREE_VXYZ( xyz[1], 1 ); SET_DEP_1VXYZ( xyz[3], 1, 1.0/fzx )
        end
      end
      else
      begin { Z is independant, X and Y coupled }
        SET_FREE_VXYZ( xyz[3], 3 );
        if ABS( fxy ) >= 1.0 then
        begin
          xyz[2,4] := (xyz[2,4] - ROUND( fxy*xyz[1,4] )) mod 24;
          SET_FREE_VXYZ( xyz[1], 1 ); SET_DEP_1VXYZ( xyz[2], 1, fxy )
        end
        else
        begin
          xyz[1,4] := (xyz[1,4] - ROUND( (1.0/fxy)*xyz[2,4] )) mod 24;
          SET_FREE_VXYZ( xyz[2], 2 ); SET_DEP_1VXYZ( xyz[1], 2, 1.0/fxy )
        end
      end
    else { X, Y and Z are coupled }
      if (ABS( fxy ) >= 1.0) and (ABS( fzx ) <= 1.0) then
      begin { |yf| >= |xf| & |zf| >= |xf| => X as main variable }
        xyz[2,4] := (xyz[2,4] - ROUND( fxy*xyz[1,4] )) mod 24;
        xyz[3,4] := (xyz[3,4] - ROUND( (1.0/fzx)*xyz[1,4] )) mod 24;
        SET_FREE_VXYZ( xyz[1], 1 );
        SET_DEP_1VXYZ( xyz[2], 1, fxy ); SET_DEP_1VXYZ( xyz[3], 1, 1.0/fzx )
      end
      else
      if (ABS( fyz ) >= 1.0) and (ABS( fxy ) <= 1.0) then
      begin { |zf| >= |yf| & |xf| >= |yf| => Y as main variable }
        xyz[3,4] := (xyz[3,4] - ROUND( fyz*xyz[2,4] )) mod 24;
        xyz[1,4] := (xyz[1,4] - ROUND( (1.0/fxy)*xyz[2,4] )) mod 24;
        SET_FREE_VXYZ( xyz[2], 2 );
        SET_DEP_1VXYZ( xyz[3], 2, fyz ); SET_DEP_1VXYZ( xyz[1], 2, 1.0/fxy )
      end
      else
      begin { |yf| >= |xf| & |zf| >= |xf| => Z as main variable }
        xyz[1,4] := (xyz[1,4] - ROUND( fzx*xyz[3,4] )) mod 24;
        xyz[2,4] := (xyz[2,4] - ROUND( (1.0/fyz)*xyz[3,4] )) mod 24;
        SET_FREE_VXYZ( xyz[3], 3 );
        SET_DEP_1VXYZ( xyz[1], 3, fzx ); SET_DEP_1VXYZ( xyz[2], 3, 1.0/fyz )
      end
  end SET_DEP_3VXYZ;


begin { SIMPLIFY_XYZEQU }
  icat := 0;
  for i := 3 downto 1 do
  begin
    icat := icat*2;
    if XYZ_VARIABLE( xyz[i] ) then icat := icat + 1
  end;
  case icat of
    0: { No variable part }   ;
    1: { X only variable }    SET_FREE_VXYZ( xyz[1], 1 );
    2: { Y only variable }    SET_FREE_VXYZ( xyz[2], 2 );
    4: { Z only variable }    SET_FREE_VXYZ( xyz[3], 3 );
    3: { X and Y variable }   SET_DEP_2VXYZ( xyz, 1, 2 );
    5: { X and Z variable }   SET_DEP_2VXYZ( xyz, 1, 3 );
    6: { Y and Z variable }   SET_DEP_2VXYZ( xyz, 2, 3 );
    7: { X,Y and Z variable } SET_DEP_3VXYZ( xyz );
  end;
(*
for i := 1 to 3 do
  WRITELN( ' 99 (', xyz[i,1], ',', xyz[i,2], ',', xyz[i,3], ',', xyz[i,4],  '/24)' );
*)
end SIMPLIFY_XYZEQU;




function XYZ_EQUIVALENCE( xyz1, xyz2: xyz_coord ): boolean;
var
  beq: boolean;

  procedure TRANS_XYZ( var v: xyz_coord; i, j, iv: integer );
  begin
    v[i,4] := (v[i,4] + iv) mod 24;
    v[j,4] := (v[j,4] + iv) mod 24 
  end TRANS_XYZ;

begin
  SIMPLIFY_XYZEQU( xyz1 );
  SIMPLIFY_XYZEQU( xyz2 );
  beq := TEST_EQU_XYZ( xyz1, xyz2 );
  if not beq then
  case grp_lattice of
    lat_A: begin
             TRANS_XYZ( xyz2, 2, 3, 12 ); SIMPLIFY_XYZEQU( xyz2 );
             return TEST_EQU_XYZ( xyz1, xyz2 )
           end;
    lat_B: begin
             TRANS_XYZ( xyz2, 3, 1, 12 ); SIMPLIFY_XYZEQU( xyz2 );
             return TEST_EQU_XYZ( xyz1, xyz2 )
           end;
    lat_C: begin
             TRANS_XYZ( xyz2, 1, 2, 12 ); SIMPLIFY_XYZEQU( xyz2 );
             return TEST_EQU_XYZ( xyz1, xyz2 )
           end;
    lat_F: begin
             TRANS_XYZ( xyz2, 1, 2, 12 ); SIMPLIFY_XYZEQU( xyz2 );
             if TEST_EQU_XYZ( xyz1, xyz2 ) then return true;
             TRANS_XYZ( xyz2, 2, 3, 12 ); SIMPLIFY_XYZEQU( xyz2 );
             if TEST_EQU_XYZ( xyz1, xyz2 ) then return true;
             TRANS_XYZ( xyz2, 1, 2, 12 ); SIMPLIFY_XYZEQU( xyz2 );
             return TEST_EQU_XYZ( xyz1, xyz2 )
           end;
    lat_I: begin
             TRANS_XYZ( xyz2, 1, 2, 12 ); xyz2[3,4] := (xyz2[3,4] + 12) mod 24;
             SIMPLIFY_XYZEQU( xyz2 );
             return TEST_EQU_XYZ( xyz1, xyz2 )
           end;
    lat_H: begin
             TRANS_XYZ( xyz2, 2, 3, 8 ); xyz2[1,4] := (xyz2[1,4] + 16) mod 24;
             SIMPLIFY_XYZEQU( xyz2 ); if TEST_EQU_XYZ( xyz1, xyz2 ) then return true;
             TRANS_XYZ( xyz2, 2, 3, 8 ); xyz2[1,4] := (xyz2[1,4] + 16) mod 24;
             SIMPLIFY_XYZEQU( xyz2 );
             return TEST_EQU_XYZ( xyz1, xyz2 )
           end;
  otherwise
  end;
  return beq
end XYZ_EQUIVALENCE;



function * ( in_var op: operator; in_var xyz: xyz_coord ): xyz_coord;
{ Define the operator action on a position }
var
  re: xyz_coord;

begin
  for i := 1 to 3 do
  begin
    re[i,4] := (op[i,1]*xyz[1,4] + op[i,2]*xyz[2,4] + op[i,3]*xyz[3,4] + op[i,4]) mod 24;
    for j := 1 to 3 do
      re[i,j] := op[i,1]*xyz[1,j] + op[i,2]*xyz[2,j] + op[i,3]*xyz[3,j]
  end;
  SIMPLIFY_XYZ( re ); 
  return re
end { * };




function + ( in_var xyz1, xyz2: xyz_coord ): xyz_coord;
{ Define the operator action on a position }
var
  re: xyz_coord;

begin
  for i := 1 to 3 do
  begin
    for j := 1 to 3 do
      re[i,j] := xyz1[i,j] + xyz2[i,j];
    re[i,4] := (xyz1[i,4] + xyz2[i,4]) mod 24
  end;
  SIMPLIFY_XYZ( re ); 
  return re
end { + };




function / ( in_var xyz: xyz_coord; idv: integer ): xyz_coord;
{ Define the operator action on a position }
var
  re: xyz_coord;

begin
  for i := 1 to 3 do
  begin
    re[i,4] := (xyz[1,4] div idv) mod 24;
    for j := 1 to 3 do
      re[i,j] := xyz[i,j] div idv
  end;
  SIMPLIFY_XYZ( re ); 
  return re
end { / };




procedure COORD_IN_STR( in_var xyz: xyz_value;
                        in_var sx, sy, sz: string;
                           var st: string;
                               fld: integer := 0;
                               bop, bcb: boolean := false );
{ Output of a coordinate of position }
{ xyz is the value,
  sx, sy and sz are the <x>, <y> and <z> symbols name,
  fld is the field to use in character (augmented when not enough),
  bop is set to true to generate the * operator character and
  bcb is set to true to write the cte part in front 5to false otherwise }

var
  cnt, d, n: integer;
  bf: [static] string( 128 );
  sq: array[1..3] of byte := [ 1, 2, 3];

  procedure WRITE_ELEMENT( iv: sbyte; in_var symb: string );
  begin
    case iv of
       0: ;
      -1: WRITEV( bf:false, '-', symb );
       1: if cnt > 0 then WRITEV( bf:false, '+', symb )
                     else WRITEV( bf:false, symb );
    otherwise
      if (cnt > 0) and (iv > 0) then WRITEV( bf:false, '+' );
      WRITEV( bf:false, iv:0 );
      if bop then WRITEV( bf:false, '*' );
      WRITEV( bf:false, symb );
    end;
    if iv <> 0 then cnt := cnt + 1
  end WRITE_ELEMENT;



  procedure WRITE_CTE( iv: sbyte );
  var
    n, d: integer;

  begin
    FRACTION_SIMPLIFY( n, d, xyz[4] );
    if d > 0 then
    begin
      if (cnt > 0) and (n > 0) then WRITEV( bf:false, '+' );
      WRITEV( bf:false, n:0,'/',d:0 );
      cnt := cnt + 1
    end
  end WRITE_CTE;


begin { COORD_IN_STR }
  cnt := 0;
  bf.length := 0;
  if bcb then WRITE_CTE( xyz[4] );

  { Try to avoid a begin with a negative sign by permuttation }
  if (not bcb or (xyz[4] = 0)) and (xyz[1] < 0) then
    if xyz[2] > 0 then begin  sq[1] := 2; sq[2] := 1  end
    else
      if xyz[3] > 0 then begin  sq[1] := 3; sq[3] := 1  end;
  { Output the symbol(s) in sq specified order }
  for i := 1 to 3 do
    case sq[i] of
      1: WRITE_ELEMENT( xyz[1], sx );
      2: WRITE_ELEMENT( xyz[2], sy );
      3: WRITE_ELEMENT( xyz[3], sz );
    end;
 
  if not bcb then WRITE_CTE( xyz[4] );
  if (xyz[4] = 0) and (cnt = 0) then WRITEV( bf:false, '0' );
  if bf.length < fld then WRITEV( st:false, ' ':fld-bf.length  );
  WRITEV( st:false, bf )
end COORD_IN_STR;



procedure POSITION_IN_STR( in_var xyz: xyz_coord;
                           in_var sx, sy, sz, frm: string;
                              var st: string;
                                  fmu: real; nst, nb: integer );
{ Write the site position specified by xyz and the strings sx, sy, sz
  in the string st with the format specified by the string frm as this :

    Any character as copied on the output except the character "%" that is
  the format specification character.
   The acceptable format statements are:
     %%        - to print the single character "%",
     %<b>c     - to validate(b>0)/invalidate(b<=0) the cte part front place (1/2+x)/(x+1/2),
     %<b>o     - to validate(b>0)/invalidate(b<=0) the * operator (2*x/2x), 
     %<f>s     - to insert in place a coordinate where <f> is the field specification,
     %<f>n     - to insert the number of equivalent site(s) (%6n == I6 fortran),
     %<f>#     - to insert the site number in the position (%6# == I6 fortran),
     %<f>.<d>f - to insert the site multiplicity as a real number (%8.3f == F8.3 fortran),
     %<f>r     - to insert the inverse of site multiplicity as an integer.

  The formal parameters fmu, nst and nb are respectively the site multiplicity,
  and the number of equivalent sites in the positions, and the sequential
  integer site number. 
}
var
  ii, ij, iv, jv: integer;
  bn, bop, bcb: boolean;
  ch: char;

begin
  bop := true; bcb := false;
  st.length := 0;
  ii := 1;
  ij := 1;
  repeat
    ch := frm[ii]; ii := ii + 1;
    if (ch = '%') and (ii <= frm.length) then
    begin { We have find the special character }
      FORMAT_VALUE( frm, ii, iv, jv, ch );
      if (ch >= 'A') and (ch <= 'Z') then
        ch := CHR( ORD( ch ) + (ORD( 'a' ) - ORD( 'A' )));
      case ch of
        '%': { write the character "%" }
             WRITEV( st:false, '%' );

        's': begin { Write one coordinate }
               COORD_IN_STR( xyz[ij], sx, sy, sz, st, iv, bop, bcb );
               ij := ij + 1;
               if ij > 3 then ij := ij - 3
             end;

        'n': { Write the number of equivalent sites }
             WRITEV( st:false, nst:iv );

        '#': { Write the site number }
             WRITEV( st:false, nb:iv );

        'r': { Write the Site multiplicity as a rational fraction }
             WRITEV( st:false, ROUND( 1.0/fmu ):iv );

        'f': { Write the multiplicity as a single real value }
             WRITEV( st:false, fmu:iv:jv );

        'c': { Validate the Left (>0) or right (<=0) Cte Mode }
             bcb := iv > 0;

        'o': { Validate (>0) or invalidate (<=0) the print '*' operator Mode }
             bop := iv > 0;

      otherwise
      end;

    end
    else
      WRITEV( st:false, ch )
  until ii > frm.length
end POSITION_IN_STR;




procedure TITLE_IN_STR( var f: text; in_var atxt: string; fmu: real; nst: integer );
{ Write the text atxt in the file f as specified by the inserted
  format specification as defined here :

    Any character as copied on the output except the character "%" that is
  the format specification character.
   The acceptable format statements are:
     %%        - to print the single character "%",
     %<f>l     - to print (or skip) <f> line (default is 1).
     %<f>.<p>g - to insert in place the Space Group Name,
     %<f>#     - to insert in place the Space Group Number,
     %<f>n     - to insert the number of equivalent site(s) (%6n == I6 fortran),
     %<f>.<d>f - to insert the site multiplicity as a real number (%8.3f == F8.3 fortran),
     %<f>r     - to insert the inverse of site multiplicity as an integer.

  The formal parameters fmu, nst and nb are respectively the site multiplicity,
  and the number of equivalent sites in the positions, and the sequential
  integer site number. 
}
var
  ii, ij, iv, jv: integer;
  ch: char;
  bn: boolean;

begin
  ii := 1;
  ij := 1;
  repeat
    ch := atxt[ii]; ii := ii + 1;
    if (ch = '%') and (ii <= atxt.length) then
    begin { We have find the special character }
      FORMAT_VALUE( atxt, ii, iv, jv, ch );
      if (ch >= 'A') and (ch <= 'Z') then
        ch := CHR( ORD( ch ) + (ORD( 'a' ) - ORD( 'A' )));
      case ch of
        '%': { write the character "%" }
             WRITE( f, '%' );

        'g': { Insert the space group name }
             WRITE( f, grp_name:iv:jv );

        '#': { Insert the space group number }
             WRITE( f, grp_number:iv );

        'l': { Print or skip <iv> line }
             repeat  WRITELN( f ); iv := iv - 1  until iv <= 0; 

        'n': { Write the number of equivalent sites }
             WRITE( f, nst:iv );

        'r': { Write the Site multiplicity as a rational fraction }
             WRITE( f, ROUND( 1.0/fmu ):iv );

        'f': { Write the multiplicity as a single real value }
             WRITE( f, fmu:iv:jv );

      otherwise
      end;

    end
    else
      WRITE( f, ch )
  until ii > atxt.length;
  WRITELN( f )
end TITLE_IN_STR;




procedure WRITE_SYMB_POSITIONS(    var f: text;
                                in_var xyz: xyz_coord;
                                in_var stx, sty, stz, format, title: string
                              );
var
  fmu: real;
  nps, jj, cnt: integer;
  cxyz: xyz_coord;
  ptb: array[1..48] of xyz_coord;
  buf: string( 255 );

begin { WRITE_SYMB_POSITIONS }
  nps := 0;
  { Evaluate the different equivalent sites }
  for ii := 1 to grp_nope do
  begin
    cxyz := grp_oper[ii]*xyz;
    jj := 1;
    while (jj <= nps) and (ptb[jj] <> cxyz) do jj := jj + 1;
    if jj > nps then
    begin
      nps := nps + 1;
      ptb[nps] := cxyz
    end
  end;
  { Build the site multiplicity }
  fmu := nps/grp_nope;
  { Print the Head list if required }
  if title.length > 0 then TITLE_IN_STR( f, title, fmu, nps );
  { Print all equivalent positions }
  for ii := 1 to nps do
  begin
    POSITION_IN_STR( ptb[ii], stx, sty, stz, format, buf, fmu, nps, ii );
    WRITELN( f, ' ', buf )
  end;
  WRITELN( f )
end WRITE_SYMB_POSITIONS;



procedure WRITE_GEN_POSITIONS(     var f:      text;
                                in_var format: string;
                                       nsp:    integer );
var
  fmu: real;
  nps, jj, cnt: integer;
  cxyz: xyz_coord;
  ptb: array[1..48] of xyz_coord;
  buf: string( 255 );

begin { WRITE_GEN_POSITIONS }
  nps := 0;
  { Evaluate the different equivalent sites }
  for ii := 1 to grp_nope do
  begin
    cxyz := grp_oper[ii]*identity_xyz;
    jj := 1;
    while (jj <= nps) and (ptb[jj] <> cxyz) do jj := jj + 1;
    if jj > nps then
    begin
      nps := nps + 1;
      ptb[nps] := cxyz
    end
  end;
  { Build the site multiplicity }
  fmu := nps/grp_nope;
  { Print all equivalent positions }
  for ii := 1 to nps do
  begin
    POSITION_IN_STR( ptb[ii], 'x', 'y', 'z', format, buf, fmu, nps, ii );
    if (ii > 1) and (nsp > 0) then WRITE( f, ' ':nsp );
    WRITELN( f, buf )
  end;
  WRITELN( f )
end WRITE_GEN_POSITIONS;



procedure SOURCE_TO_XYZ( var xyz: xyz_coord;
                         var sx, sy, sz, frm, titl: string );
const
  mdnam = 'SXYZ';

var
  rf, ct: real;

  procedure IN_FRAC( fc, ct: real; var ifc, ict: sbyte );
  const
    mdnam = 'RXYZ';

  var
    rv: real;
    iv: integer;

  begin
    rv := ct*24.0; iv := ROUND( rv );
    if (ABS( rv - iv ) > 1.0E-5) or (ABS( iv ) > 24) then
      ERROR( mdnam, 'Bad Numeric constant' );
    ict := iv mod 24;
    iv := ROUND( fc );
    if (ABS( fc - iv ) > 1.0E-5) or (ABS( iv ) > 24) then
      ERROR( mdnam, 'Bad Numeric factor' );
    ifc := iv
  end IN_FRAC;


begin { SOURCE_TO_XYZ }
  xyz := xyz_coord[[0, 0, 0, 0],[0, 0, 0, 0],[0, 0, 0, 0]];
  sx.length   := 0;
  sy.length   := 0;
  sz.length   := 0;
  frm.length  := 0;
  titl.length := 0;

  INP_EXPRESSION( rf, ct, sx );
  IN_FRAC( rf, ct, xyz[1,1], xyz[1,4] );
  if (inp_symb <> sy_comma) and (inp_symb <> sy_colon) then
    WARNING( mdnam, 'Unexpected separator ignored (expected was : or ,)' );
  INSYMBOL;
  INP_EXPRESSION( rf, ct, sy );
  IN_FRAC( rf, ct, xyz[2,2], xyz[2,4] );
  if (sx.length > 0) and (sy.length > 0) and (sx = sy) then
  { When the x and y expressions refere to same unique symbol }
  begin  xyz[2,1] := xyz[2,2]; xyz[2,2] := 0  end;
  if (inp_symb <> sy_comma) and (inp_symb <> sy_colon) then
    WARNING( mdnam, 'Unexpected separator ignored (expected was : or ,)' );
  INSYMBOL;
  INP_EXPRESSION( rf, ct, sz );
  IN_FRAC( rf, ct, xyz[3,3], xyz[3,4] );
  if (sx.length > 0) and (sz.length > 0) and (sx = sz) then
  { When the x and z expressions refere to same unique symbol }
  begin  xyz[3,1] := xyz[3,3]; xyz[3,3] := 0  end
  else
    if (sy.length > 0) and (sz.length > 0) and (sy = sz) then
    { When the y and z expressions refere to same unique symbol }
    begin  xyz[3,2] := xyz[3,3]; xyz[3,3] := 0  end;

  if INP_SEPAR( sy_colon ) then
  begin
    if inp_symb = sy_str then begin  frm := inp_str; INSYMBOL  end;
    if INP_SEPAR( sy_comma ) then
      if inp_symb = sy_str then begin  titl := inp_str; INSYMBOL  end
  end;
  INP_LOOKSEMICOLON
end SOURCE_TO_XYZ;




procedure WRITE_NUMPOS(    var   f: text;
                        in_var xyz: dvector;
                        in_var frm: string;
                               fmu: real; nst, nb: integer );
{ Write the site position (numeric only) specified by xyz and the strings sx, sy, sz
  in the string st with the format specified by the string frm as this :

    Any character as copied on the output except the character "%" that is
  the format specification character.
   The acceptable format statements are:
     %%        - to print the single character "%",
     %<f>.<d>v - to insert in place a coordinate where <f> is the field specification,
     %<f>n     - to insert the number of equivalent site(s) (%6n == I6 fortran),
     %<f>#     - to insert the site number in the position (%6# == I6 fortran),
     %<f>.<d>f - to insert the site multiplicity as a real number (%8.3f == F8.3 fortran),
     %<f>r     - to insert the inverse of site multiplicity as an integer.

  The formal parameters fmu, nst and nb are respectively the site multiplicity,
  and the number of equivalent sites in the positions, and the sequential
  integer site number. 
}
var
  ii, ij, iv, jv: integer;
  bn: boolean;
  ch: char;

begin
  ii := 1;
  ij := 1;
  repeat
    ch := frm[ii]; ii := ii + 1;
    if (ch = '%') and (ii <= frm.length) then
    begin { We have find the special character }
      FORMAT_VALUE( frm, ii, iv, jv, ch );
      if (ch >= 'A') and (ch <= 'Z') then
        ch := CHR( ORD( ch ) + (ORD( 'a' ) - ORD( 'A' )));
      case ch of
        '%': { write the character "%" }
             WRITE( f, '%' );

        'v': begin { Write one coordinate }
               WRITE( f, xyz[ij]:iv:jv );
               ij := ij + 1;
               if ij > 3 then ij := ij - 3
             end;

        '#': { Write the site number }
             WRITE( f, nb:iv );

        'n': { Write the number of equivalent sites }
             WRITE( f, ROUND( 1.0/fmu ):iv );

        'f': { Write the multiplicity as a single real value }
             WRITE( f, fmu:iv:jv );

      otherwise
      end;

    end
    else
      WRITE( f, ch )
  until ii > frm.length;
  WRITELN( f )
end WRITE_NUMPOS;




procedure WRITE_NUM_POSITIONS(    var      f: text;
                               in_var    xyz: dvector;
                               in_var format, title: string );
{ Generate the numerical coordinates of all equivalent atoms }
var
  fmu: real;
  cxyz: dvector;
  jj: integer;
  grp_nqtb: array[1..48] of dvector;            { Non Equivalent Position Table in Cell Fraction. }
  grp_nqnb: integer;                            { Number of Non Equivalent Position }

begin
  grp_nqnb := 0;
  for ii := 1 to grp_nope do
  begin
    cxyz := grp_oper[ii]*xyz;                   { Compute a position }
    jj := 1;
    while (jj <= grp_nqnb) and (grp_nqtb[jj] <> cxyz) do jj := jj + 1;
    if jj > grp_nqnb then
    begin
      grp_nqnb := grp_nqnb + 1;
      grp_nqtb[grp_nqnb] := cxyz
    end
  end;

  { Build the site multiplicity }
  fmu := grp_nqnb/grp_nope;
  { Print the Head list if required }
  if title.length > 0 then TITLE_IN_STR( f, title, fmu, grp_nqnb );
  { Print all equivalent positions }
  for ii:= 1 to grp_nqnb do
    { grp_normf = true should be imply Normalized reference }
    if grp_normf then
    begin { We transform the coordinates by the matrix grp_tmd }
      for i := 1 to 3 do
      begin
        cxyz[i] := 0.0;
        for j := 1 to 3 do
          cxyz[i] := cxyz[i] + grp_tmd[i,j]*grp_nqtb[ii,j]
      end;
      WRITE_NUMPOS( f, cxyz, format, fmu, grp_nqnb, ii )
    end
    else WRITE_NUMPOS( f, grp_nqtb[ii], format, fmu, grp_nqnb, ii );
  WRITELN( f )
end WRITE_NUM_POSITIONS;




{********************************************************************}
{*         GEN_SPACE_GROUP Generate Space Group Procedures          *)
{********************************************************************}



function OPER_NEQ( op1, op2: operator ): boolean;
begin
  for i := 1 to 3 do
    for j := 1 to 3 do
      if op1[i,j] <> op2[i,j] then return true;
  return false
end OPER_NEQ;



function TEST_OPEQ( in_var o1, o2: operator ): boolean;
{ Compare to operator and return true if the rotation part are sames }
begin
  for i := 1 to 3 do
    for j := 1 to 3 do
      if o1[i,j] <> o2[i,j] then return false;
  return true
end TEST_OPEQ;



procedure OPER_IDENTIFY( in_var op: operator;
                            var opcd: sbyte; var ps, dr, tr: lvector; var br: boolean );
const
  nltr = lvector[ 0, 0, 0];

var
  v: array[1..3,1..3] of integer;
  o: operator;
  d, n, m, r, s: integer;
  nr, pos: array[1..3] of integer;
  iv: 1..3;
  bi: boolean;


  function MUL_OPE( in_var o1, o2: operator ): operator;
  var
    re: operator;

  begin
    re[1,1] :=  o1[1,1]*o2[1,1] + o1[1,2]*o2[2,1] + o1[1,3]*o2[3,1];
    re[1,2] :=  o1[1,1]*o2[1,2] + o1[1,2]*o2[2,2] + o1[1,3]*o2[3,2];
    re[1,3] :=  o1[1,1]*o2[1,3] + o1[1,2]*o2[2,3] + o1[1,3]*o2[3,3];
    re[1,4] :=  o1[1,1]*o2[1,4] + o1[1,2]*o2[2,4] + o1[1,3]*o2[3,4] + o1[1,4];
    re[2,1] :=  o1[2,1]*o2[1,1] + o1[2,2]*o2[2,1] + o1[2,3]*o2[3,1];
    re[2,2] :=  o1[2,1]*o2[1,2] + o1[2,2]*o2[2,2] + o1[2,3]*o2[3,2];
    re[2,3] :=  o1[2,1]*o2[1,3] + o1[2,2]*o2[2,3] + o1[2,3]*o2[3,3];
    re[2,4] :=  o1[2,1]*o2[1,4] + o1[2,2]*o2[2,4] + o1[2,3]*o2[3,4] + o1[2,4];
    re[3,1] :=  o1[3,1]*o2[1,1] + o1[3,2]*o2[2,1] + o1[3,3]*o2[3,1];
    re[3,2] :=  o1[3,1]*o2[1,2] + o1[3,2]*o2[2,2] + o1[3,3]*o2[3,2];
    re[3,3] :=  o1[3,1]*o2[1,3] + o1[3,2]*o2[2,3] + o1[3,3]*o2[3,3];
    re[3,4] :=  o1[3,1]*o2[1,4] + o1[3,2]*o2[2,4] + o1[3,3]*o2[3,4] + o1[3,4];
    return re
  end MUL_OPE;


begin { OPER_IDENTIFY }
  tr :=  nltr; { We assume no translation until shown otherwise }
  ps :=  nltr;
  dr :=  nltr;
  br := false;
  { Test for simple translation and identity }
  if TEST_OPEQ( op, identity_ope ) then
  begin
    n :=  1;
    for i := 1 to 3 do  tr[i] := op[i,4] mod 24
  end
  else
  { Test for symetry center }
  if TEST_OPEQ( op, center_ope ) then
  begin
    n := -1;
    for i := 1 to 3 do  ps[i] := (op[i,4] div 2) mod 24
  end
  else
  begin
    o := op;
    { Test of impropre operator by a negative determinant }
    d := o[1,1]*(o[2,2]*o[3,3] - o[3,2]*o[2,3]) +
         o[2,1]*(o[3,2]*o[1,3] - o[1,2]*o[3,3]) +
         o[3,1]*(o[1,2]*o[2,3] - o[2,2]*o[1,3]);
    bi := (d < 0); { bi = true => impropre operator }

    { Loop to find the order of element }
    { -3 is a special case because (-3)^3 is -1 }

    for i := 1 to 3 do
    begin
      pos[i] := o[i,4]; { Initialize po (ps in 32 bits) to get the summ of operator translation }
      { With the propre version of operator form the summ for projection operator
        with the identity representation of group limited to O with vector a, b and c }
      { This initial v summation takes in account the identity and the operator }
      if bi then for j := 1 to 3 do v[j,i] := ORD( i = j ) - o[j,i]
            else for j := 1 to 3 do v[j,i] := ORD( i = j ) + o[j,i]
    end;

    n := 2;
    loop
      o := MUL_OPE( o, op ); { Compute op^n }
      { Stop when the retation is the identity (or center for impropre operator) }
    exit if TEST_OPEQ( o, identity_ope ) or (TEST_OPEQ( o, center_ope ) and  bi);
      for i := 1 to 3 do
      begin
        pos[i] := pos[i] + o[i,4]; { Add the contribution of o^n to the position }
        { With the proper version of operator, continue the summ of projection of a, b and c }
        if bi and ODD( n ) then for j := 1 to 3 do v[j,i] := v[j,i] - o[j,i]
                           else for j := 1 to 3 do v[j,i] := v[j,i] + o[j,i]
      end;
      n := n + 1
    end;

    { Find the operator direction }
    r := 0; iv := 1;
    { Find the largest projection iv in the projections set (proj of a,b or c) }
    { This vector is must be parallel to the axis direction }
    for i := 1 to 3 do
    begin
      nr[i] := SQR( v[1,i] ) + SQR( v[2,i] ) + SQR( v[3,i] );
      if r < nr[i] then begin  r := nr[i]; iv := i  end
    end;
    { Force to keep any axis as changed by propre operator (not center or mirror) }
    if v[1,iv]*v[2,iv]*v[3,iv] < 0 then
      for i := 1 to 3 do  dr[i] := -v[i,iv]
    else 
      for i := 1 to 3 do  dr[i] :=  v[i,iv];
    ANORM_VECT( dr ); { Normalize to a reduce (division by PGCD) }

    if n > 2 then
    begin { To distinguish 3^2 from 3, 4^3 from 4 or 6^5 from 6 }
      iv := iv mod 3 + 1; { Take a not // vector index }
      d := 0;
      { Form the mixte product ([iv],op*[iv],dr] with op as a proper operator }
      for i := 1 to 3 do
      begin
        r := i mod 3 + 1; s := r mod 3 + 1;
        d := d + (ORD( r = iv )*op[s,iv] - ORD( s = iv )*op[r,iv])*dr[i];
(*
        if bi then d := - d
*)
      end;
      if bi then d := -d;
      br := d < 0
    end;

    { Find the operator translation and position }
    if bi and (n = 3) then
    { For the -3 operator, the (-3)^3 is -1 at the same place }
    begin
      for i := 1 to 3 do  ps[i] := o[i,4] div 2;
      n := -3
    end
    else
    begin { o is the identity operator with n*<the_operator_translation> }
      m := n*(n - 1) div 2;
      for i := 1 to 3 do
      begin
        s := o[i,4] div n;
        tr[i] := s mod 24;
        ps[i] := ((pos[i] - m*s) div n) mod 24
      end;
      o := op;
      { Now simplify the position vector when it is possible }
      if (not bi) or (n = 2) then
      begin
        { Compute the scalar product dr.dr and ps.dr }
        if grp_sys = l_hex then
        begin { Use the special hexagonal metric tensor }
          r := dr[1]*ps[1] + dr[2]*ps[2] + dr[3]*ps[3] - (ps[1]*dr[2] + ps[2]*dr[1]) div 2;
          s := SQR( dr[1] ) + SQR( dr[2] ) + SQR( dr[3] ) - dr[1]*dr[2]  
        end
        else
        begin { All Normal reference } 
          r := dr[1]*ps[1] + dr[2]*ps[2] + dr[3]*ps[3];    { Form the scalar dr.ps }
          s := SQR( dr[1] ) + SQR( dr[2] ) + SQR( dr[3] )  { Form the scalar dr.dr }
        end;
        for i := 1 to 3 do
          if (dr[i]*r) mod s <> 0 then goto ET_LATSIMPLE;
        if bi then { for mirror }
          for i := 1 to 3 do
            ps[i] := ((dr[i]*r) div s) mod 24
        else { For proper axis }
          for i := 1 to 3 do
            ps[i] := (ps[i] - (dr[i]*r) div s) mod 24
      end;
      if bi then n := -n  { -2 is a mirror }
    end
  end;

ET_LATSIMPLE:

  { Reduce to a unique form when possible }
  REDUCE_LVECTOR( ps );
  opcd := n
end OPER_IDENTIFY;




procedure ENCODE_XYZ( opcd: sbyte; ps, dr: lvector; var xyz: xyz_coord );
{ Create a normalized symbolic coordinate attached to this operator }
var
  nc, nz, na, nb: integer;

begin
  for i := 1 to 3 do  for j := 1 to 4 do  xyz[i,j] := 0;
  case opcd of
     1: { Identity } ;
    -1, -3, -4, -6: { Symetry center and non mirror impropre axis }
        for i := 1 to 3 do  xyz[i,4] := ps[i];
    -2: { Mirror }
        begin
          { For an hexagonal reference we must not forget that the normal is in
            the reciprocal space reference }
          if grp_sys = l_hex then
          begin { For the hexagonal reference, we take the metric tensor in account }
            na := 2*dr[1] - dr[2]; dr[2] := -dr[1] + 2*dr[2]; dr[1] := na; dr[3] := 2*dr[3];
            ANORM_VECT( dr ); { Normalize to a reduce (division by PGCD) }
          end;
          nz := 0; nc := 0;
          for i := 1 to 3 do
          begin
            xyz[i,4] := ps[i]; { Copy the position of the axis in the cte. part }
            { ... and attribute a symbol name (x, y or z) to the coordinate }
            if dr[i] = 0 then { A null normal componante => a symbol must be atributed }
            begin  xyz[i,i] := 1; nz := nz + 1; nc := i  end
          end;
          case nz of
            0: begin { Should be extremely rare ? normal of mirror is [a,b,c] (no Crist S.G.) }
                 xyz[1,1] :=   dr[3]; xyz[2,2] :=   dr[3];
                 xyz[3,1] := - dr[1]; xyz[3,2] := - dr[2]
               end;
            1: case nc of { [0,b,c], [a,0,c], or [a,b,0] }
                 1: begin  xyz[2,2] := dr[3]; xyz[3,2] := - dr[2]  end;
                 2: begin  xyz[1,1] := dr[3]; xyz[3,1] := - dr[1]  end;
                 3: begin  xyz[1,1] := dr[2]; xyz[2,1] := - dr[1]  end;
               end;
          otherwise
            { Normal of mirror is [a,0,0] or [0,b,0] or [0,0,c] }
          end;
          { Now we fit the position in the simplest form }

        end;
  otherwise { For the axis 2, 3, 4 and 6 }
    nz := 0; nc := 0;
    for i := 1 to 3 do
    begin { For each coordinate }
      xyz[i,4] := ps[i];  { Copy the position of the axis in the cte. part }
      if dr[i] <> 0 then  { For each not vanish direction }
      begin { ... attribute a symbol name (x, y or z) to the coordinate }
        if nc = 0 then nc := i;
        xyz[i,nc] := dr[i]
      end 
    end
  end
end ENCODE_XYZ;



procedure IPS_INSERT( in_var xyz: xyz_coord );
{ Allocate a new Individual Position Site }
begin
  if grp_ipsnb < max_ips then
  begin
    grp_ipsnb := grp_ipsnb + 1;
    with grp_ipotb[grp_iponb] do
    begin
      if ipo_size = 0 then ipo_idx := grp_ipsnb;
      ipo_size := ipo_size + 1
    end;
    grp_ipstb[grp_ipsnb] := xyz
  end
  else ERROR( 'NIPS', 'Position site Overflow.' )
end IPS_INSERT;



procedure CODE_PGROUP( var grp: pgrp_dsc; ope: sbyte; in_var dr: lvector );
const
  max_tvb = 15;

type
  tb_vty = array[1..max_tvb] of lvector;

const
  tbv = tb_vty[ [ 1, 0, 0], [ 0, 1, 0], [ 0, 0, 1],
                [ 1, 1, 0], [ 1,-1, 0], [ 0, 1, 1], [ 0, 1,-1],
                [ 1, 0, 1], [ 1, 0,-1], [ 1, 1, 1], [ 1,-1,-1],
                [-1, 1,-1], [-1,-1, 1], [ 2, 1, 0], [ 1, 2, 0] ];

var
  nd: integer;

  function TEST_PARALLEL( in_var dr, dir: lvector ): boolean;
  var
    j, k: integer;

  begin
    for i := 1 to 3 do
    begin
      j := i mod 3 + 1; k := j mod 3 + 1;
      if dr[j]*dir[k] - dr[k]*dir[j] <> 0 then return false
    end;
    return true
  end TEST_PARALLEL;


begin
  if ABS( ope ) > 1 then
  { Search the operator direction when required }
  begin
    nd := 1;
    while nd <= max_tvb do
      if not TEST_PARALLEL( dr, tbv[nd] ) then nd := nd + 1
                                          else exit;
    if nd > max_tvb then nd := 0
  end
  else nd := 0;
  { Encode the operator in the grp set for ponctual group }
  case ope of
    -1: grp := grp + [ope_inv];
     2: case grp_sys of
          l_mon: grp := grp + [ope_2z];
          l_trg, l_hex:
                 case nd of
                   1, 2, 4: grp := grp + [ope_2x];
                   3:       grp := grp + [ope_2z];
                   5,14,15: grp := grp + [ope_2u];
                 otherwise
                 end;
          l_ort, l_qua, l_rho, l_cub:
                 case nd of
                   1: grp := grp + [ope_2x];
                   2: grp := grp + [ope_2y];
                   3: grp := grp + [ope_2z];
                   4, 6, 8: grp := grp + [ope_2u];
                   5, 7, 9: grp := grp + [ope_2v];
                 otherwise
                 end;
        otherwise
        end;
    -2: case grp_sys of
          l_mon: grp := grp + [ope_mz];
          l_trg, l_hex:
                 case nd of
                   1, 2, 4: grp := grp + [ope_mx];
                   3:       grp := grp + [ope_mz];
                   5,14,15: grp := grp + [ope_mu];
                 otherwise
                 end;
          l_ort, l_qua, l_rho, l_cub:
                 case nd of
                   1: grp := grp + [ope_mx];
                   2: grp := grp + [ope_my];
                   3: grp := grp + [ope_mz];
                   4, 6, 8: grp := grp + [ope_mu];
                   5, 7, 9: grp := grp + [ope_mv];
                 otherwise
                 end;
        otherwise
        end;
    -3, 3:
        case grp_sys of
          l_trg,
          l_hex: if ope > 0 then grp := grp + [ope_3z_h]
                            else grp := grp + [ope_3bz_h];
          l_rho,
          l_cub: if ope > 0 then grp := grp + [ope_3r]
                            else grp := grp + [ope_3br];
        otherwise
        end;
    -4, 4: if ope > 0 then grp := grp + [ope_4z]
                      else grp := grp + [ope_4bz];
    -6, 6: if ope > 0 then grp := grp + [ope_6z_h]
                      else grp := grp + [ope_6bz_h];
  otherwise
  end
end CODE_PGROUP;



procedure IPO_INSERT( opcd: sbyte; in_var ps, dr: lvector );
{ Allocate a new Position Descriptor }
begin
  if grp_iponb < max_ipo then
  begin
    grp_iponb := grp_iponb + 1;
    with grp_ipotb[grp_iponb] do
    begin
      ipo_next   :=    0;                       { Init the next link of reordering }
      ipo_size   :=    0;                       { ... and the position size }
      ipo_prior  :=    0;                       { Display priority }
      ipo_idx    :=    0;                       { Init to vanish the index of first ips }
      ipo_ope    := opcd;                       { Put the single operator, }
      ipo_xyzpos :=   ps;                       { ... its position and }
      ipo_xyzdir :=   dr;                       { ... direction. }
      ipo_group  :=   [];                       { Initialize the Group space }
      CODE_PGROUP( ipo_group, opcd, dr )        { ... and deposite the first operator }
    end
  end
  else ERROR( 'NIPO', 'Position Overflow.' )
end IPO_INSERT;



procedure GEN_POSITION( in_var xyz: xyz_coord; opcd: sbyte; in_var ps, dr: lvector );
var
  stpos, ig, ip0, ip1: integer;
  cprior:              unsigned;
  opcd1:               sbyte;
  cxyz:                xyz_coord;
  dr1, ps1, tr1:       lvector;
  br1:                 boolean;


  function GEN_POS_PRIOR( in_var xyz: xyz_coord ): integer;
  var
    t: array[1..3] of byte := [ 0, 0, 0];
    n: integer;

  begin
    n := 0;
    for i := 1 to 3 do
    begin
      for j := 1 to 3 do
        if xyz[i,j] <> 0 then t[i] := t[i] + 1;
    end;
    for i := 1 to 3 do
      if t[i] <> 0 then n := n + 10;
    GEN_POS_PRIOR := n
  end GEN_POS_PRIOR;


begin { GEN_POSITION }
  { We must insert the current site if it is a new one }
  ig := 1;
  { Loop to Look for this position is already in the site table }
  while ig <= grp_ipsnb do
    if XYZ_EQUIVALENCE( xyz, grp_ipstb[ig] ) then exit
                                             else ig := ig + 1;
  if ig > grp_ipsnb then
  begin { This position was not known }
    IPO_INSERT( opcd, ps, dr );
    IPS_INSERT( xyz );
    cprior := GEN_POS_PRIOR( xyz );
    stpos := grp_ipsnb;
    { Loop on equivalent operators/special_sites }
    for ii := 2 to grp_nope do
    begin
      cxyz := grp_oper[ii]*xyz;
      ig := stpos;
      while ig <= grp_ipsnb do
        if TEST_EQU_XYZ( grp_ipstb[ig], cxyz ) then exit
                                               else ig := ig + 1;

      { When we have find a new sites (operator) position and direction }
      if ig > grp_ipsnb then IPS_INSERT( cxyz )

      else { With this operator, the current site is invariant }
        if ig = stpos then { The first site stay invariant }
        begin { Find the nature of this operator }
          OPER_IDENTIFY( grp_oper[ii], opcd1, ps1, dr1, tr1, br1 );
          if (opcd1 < 0) and (opcd = -1) then
          begin  opcd := opcd1; grp_ipotb[grp_iponb].ipo_ope := opcd  end;
          if (opcd1 <> opcd) or (dr1 <> dr) then
            CODE_PGROUP( grp_ipotb[grp_iponb].ipo_group, opcd1, dr1 )
        end
    end;
    { Close the position }
    cprior := cprior + grp_ipotb[grp_iponb].ipo_size*100;
    grp_ipotb[grp_iponb].ipo_prior := cprior;
    ip0 := 0; ip1 := grp_ipofrs;
    while (ip1 <> 0) and (grp_ipotb[ip1].ipo_prior > cprior) do
    begin
      ip0 := ip1; ip1 := grp_ipotb[ip1].ipo_next
    end;
    grp_ipotb[grp_iponb].ipo_next := ip1;
    if ip0 = 0 then grp_ipofrs := grp_iponb
               else grp_ipotb[ip0].ipo_next := grp_iponb
  end
end GEN_POSITION;



procedure GEN_OPEQUV( opid: integer );
{ From the Operator grp_oper[opid], deduce all equivalent operator.
    The results is the new position index or 0.
}
const
  posl_frm = '(%2#) %8s, %8s, %8s;';

var
  mem_ps:      array[0..7] of lvector;        { Memory for operator positions }
  mem_top:     integer;                       { Memory use top }
  opcd, opcd1: sbyte;
  ps, tr, dr, ps1, tr1, dr1: lvector;
  xyz, cxyz:   xyz_coord;
  op1, op2:    operator;
  br, br1:     boolean;
  sgn:         string( 3 ) := '';
  ig, stpos, ip0, ip1: integer;

  st: string( 128 );


begin { GEN_OPEQUV }
  if grp_opef[opid] then return;
  grp_opef[opid] := true;
  { Elliminate all equivalent operators (in same class) to optimize search }
  op1 := grp_oper[opid];
  for ii := 2 to grp_nope do
    if ii <> opid then
    begin
      op2 := CANONIC_TRANS( grp_oper[ii], op1 );
      ig := opid + 1;
      while ig <= grp_nope do
        if OPER_NEQ( op2, grp_oper[ig] ) then ig := ig + 1
                                         else begin  grp_opef[ig] := true; exit  end
    end;

  for itr := 0 to 7 do
  begin { For each nodes of basic unit cell }
    op1 := grp_oper[opid];
    { Add the required translation when required }
    case itr of
      1, 2, 3: for i := 1 to 3 do
                 op1[i,4]   := op1[i,4] + tralatb[grp_lattice,itr,i];
      4, 5, 6: for i := 1 to 3 do
                 for j := 0 to 1 do
                   op1[i,4] := op1[i,4] + tralatb[grp_lattice,((itr-4)+j) mod 3 + 1,i];
      7:       for i := 1 to 3 do
                 for j := 1 to 3 do
                   op1[i,4] := op1[i,4] + tralatb[grp_lattice,j,i];
    otherwise
      mem_top := -1
    end;


    { Identify the operator }
    OPER_IDENTIFY( op1, opcd, ps, dr, tr, br );
(*
    DISPLAY_OPERATOR( output, ' Gen position on ', op1 );
    if br then sgn := '^-1' else sgn := '   ';
    WRITELN( ' Operator[', opid:2,'] = ', opcd:2, sgn, ' with T = (',
             tr[1]:2, ',', tr[2]:2, ',', tr[3]:2, ') at (',
             ps[1]:2, ',', ps[2]:2, ',', ps[3]:2, ') along (',
             dr[1]:2, ',', dr[2]:2, ',', dr[3]:2, ').' );
*)
    ig := 0;
    loop
    exit if ig > mem_top;
    exit if ps = mem_ps[ig];
      ig := ig + 1
    end;

    { Elliminate any operator(s) with translation }
    if (ig > mem_top) and (tr[1] = 0) and (tr[2] = 0) and (tr[3] = 0) then
    begin
      mem_top := mem_top + 1; mem_ps[mem_top] := ps;
      { Create the equivalent xyz_coord record }
      ENCODE_XYZ( opcd, ps, dr, xyz );
      SIMPLIFY_XYZEQU( xyz );
(*
      POSITION_IN_STR( xyz, 'x', 'y', 'z', posl_frm, st, 1.0, 1, 1 );
      WRITELN( ' POS ORG : ', st );               { Write the position site }
*)

      GEN_POSITION( xyz, opcd, ps, dr )
    end
  end
end GEN_OPEQUV;




procedure GEN_INTERPOS;
{ Generate all the special positions that can be deduced from the single ones }
const
    posl_frm = '(%2#) %8s, %8s, %8s;';

var
  ope1: sbyte;
  dr1, ps1, dr2, ps2, psm: lvector;
  
  ip1, ip2, is1, is2, ij, itr, mem_top: integer;
  vp1, vpp: xyz_coord;


  procedure GET_DR_PS( var dr, ps: lvector; in_var xyz: xyz_coord );
  { Get the direction and position equivalent to a xyz_coord }
  const
    h11 = 1.0;
    h12 = 0.5;
    h22 = SQRT( 3.0 )/2.0;

  var
    n, j, k: integer;
    da, db: dvector := [0.0,0.0,0.0];
    bm: boolean;

    st: string( 128 );

  begin
    for i := 1 to 3 do
    begin
      ps[i] := xyz[i,4]; { extract the position as the constant part }
      { Put in da[] (init at 0), a count of symbolic contribution,
        result: da[i] <> 0 => the ith symbol is used in one or more
                X,Y,Z coordinates  (i=1/2/3 for x/y/z symbol) }
      for j := 1 to 3 do
        if xyz[j,i] <> 0 then da[i] := da[i] + 1
    end;
(*
POSITION_IN_STR( xyz, 'x', 'y', 'z', posl_frm, st, 1.0, 1, 1 );
WRITELN( ' Posit: ', st, ' at (', ps[1]:3, ',', ps[2]:3, ',', ps[3]:3, ')' );
*)
    bm := false;
    { Forms a configuration number of not null symbolic par as:
      1 for x contribution }
    n := 0;
    for i := 3 downto 1 do
    begin  n := n*2; if ABS( da[i] ) > 1.0E-5 then n := n + 1  end;
    case n of
      1: { x symbol is used } for i := 1 to 3 do  dr[i] := xyz[i,1];
      2: { y symbol is used } for i := 1 to 3 do  dr[i] := xyz[i,2];
      4: { z symbol is used } for i := 1 to 3 do  dr[i] := xyz[i,3];
      3: begin { x and y are used => it is a mirror }
           for i := 1 to 3 do  da[i] := xyz[i,1];
           for i := 1 to 3 do  db[i] := xyz[i,2];
           bm := true
         end;
      5: begin { x and z are used => it is a mirror }
           for i := 1 to 3 do  da[i] := xyz[i,1];
           for i := 1 to 3 do  db[i] := xyz[i,3];
           bm := true
         end;
      6: begin { y and z are used => it is a mirror }
           for i := 1 to 3 do  da[i] := xyz[i,2];
           for i := 1 to 3 do  db[i] := xyz[i,3];
           bm := true
         end;
    otherwise
      { should never be because 0 => the single site was a single point,
                            and 7 => the single site is the general position. }
    end;
    if bm then
      { For the mirror da and db are in the plane.
        The product da^db (true vectorial product only in cubic system) gives
        the plane equation with the position vector ps.
      }
      for i := 1 to 3 do
      begin
        j := i mod 3 + 1; k := j mod 3 + 1;
        dr[i] := ROUND( da[j]*db[k] - da[k]*db[j] )
      end;
    ANORM_VECT( dr )
  end GET_DR_PS;


  procedure GEN_AX_INTERSECTION( in_var dr1, ps1, dr2, ps2: lvector );
  { We analyse the intersection of two straight line axis }
  var
    i1, i2, ma, n, s: integer;
    del, prd: lvector;
    xyz: xyz_coord; 

  begin
(*
WRITELN( '    With ', grp_ipotb[ip2].ipo_ope, ' (', dr2[1]:3, ',', dr2[2]:3, ',', dr2[3]:3, ') at (',
                                                    ps2[1]:3, ',', ps2[2]:3, ',', ps2[3]:3, ')' );
WRITELN( '     and ', grp_ipotb[ip1].ipo_ope, ' (', dr1[1]:3, ',', dr1[2]:3, ',', dr1[3]:3, ') at (',
                                                    ps1[1]:3, ',', ps1[2]:3, ',', ps1[3]:3, ')' );
*)
    ma := 0;
    for i := 1 to 3 do
    begin
      i1 := i mod 3 + 1; i2 := i1 mod 3 + 1;
      del[i] := ps2[i] - ps1[i];
      prd[i] := dr1[i1]*dr2[i2] - dr1[i2]*dr2[i1];
      s := SQR( prd[i] );
      if i = 1 then begin  ma := s; n := 1  end
               else if s > ma then begin  ma := s; n := i  end
    end;
(*
WRITELN( prd[1],  prd[2],  prd[3], ma );
*)
    if ma > 0 then
    begin { Not parallel straight line => there is an intersection }
      ma := prd[1]*del[1] + prd[2]*del[2] + prd[3]*del[3];
      if ma mod 24 = 0 then
      begin { The intersection is existing because the two line are in the same plane }
        i1 := n mod 3 + 1; i2 := i1 mod 3 + 1;
        if ma <> 0 then
          if prd[i1] <> 0 then
            del[i1] := del[i1] + ma div prd[i1]  { Translate the second operator of period }
          else
          if prd[i2] <> 0 then
            del[i2] := del[i2] + ma div prd[i2]; { ... along a not // dr2 direction }

        { Eliminate the equation corresponding to prd[n] (use the maximum determinant) }
        ma := dr2[i2]*del[i1] - dr2[i1]*del[i2];
(*
WRITELN( ' with ma = ', ma, ', n = ', n:2, ', prd[n] = ', prd[n]:5 );
*)
        if ma rem prd[n] = 0 then ma := ma div prd[n]
                             else ERROR( 'NDIN', 'No Rational Straight Line Intersection.' );
        for i := 1 to 3 do
        begin
          for j := 1 to 3 do  xyz[i,j] := 0;
          del[i] := (dr1[i]*ma + ps1[i]) mod 24;
          xyz[i,4] := del[i]
        end;
(*
WRITELN( ' ---> (', del[1]:3, ',', del[2]:3, ',', del[3]:3, ')' );
*)
        { Now Create the new position }
        GEN_POSITION( xyz, 1, del, dr1 );
      end
    end
  end GEN_AX_INTERSECTION;


begin { GEN_INTERPOS }
  ip1 := 1;
  while ip1 < grp_iponb do
  begin
    ope1 := grp_ipotb[ip1].ipo_ope;
    if ope1 > 1 then
    begin { Only possible for mirror and proper symetry axis }
      with grp_ipotb[ip1] do
      begin
        dr1 := ipo_xyzdir;
        ps1 := ipo_xyzpos;
        is1 := ipo_idx
      end;
      vp1 := grp_ipstb[is1];
(*
WRITELN( ' Look for Intersection for ', ope1, dr1[1]:3, dr1[2]:3, dr1[3]:3, '|',
                                              ps1[1]:3, ps1[2]:3, ps1[3]:3 );
*)
      ip2 := ip1 + 1;
      while ip2 <= grp_iponb do
      with grp_ipotb[ip2] do
      begin
        if ipo_ope > 1 then
        begin { Only possible for mirror and proper symetry axis }
          { The intersections between two mirror are ignored
            because the intersection is 2 axis already known as
            a simple position }
          is2 := ipo_idx;
          ij := 1;
          while ij <= grp_ipotb[ip2].ipo_size do
          begin
            { We must look for the possible intersections }
            { We can have two axis or one axis and one mirror }
            GET_DR_PS( dr2, psm, grp_ipstb[is2] );  { Get the site position and direction }

            for itr := 0 to 7 do
            begin { For each nodes of basic unit cell }
              { Add the required translation when required }
              case itr of
                1, 2, 3: for i := 1 to 3 do
                           ps2[i] := psm[i] + tralatb[grp_lattice,itr,i];
                4, 5, 6: for i := 1 to 3 do
                           for j := 0 to 1 do
                             ps2[i] := psm[i] + tralatb[grp_lattice,((itr-4)+j) mod 3 + 1,i];
                7:       for i := 1 to 3 do
                           for j := 1 to 3 do
                             ps2[i] := psm[i] + tralatb[grp_lattice,j,i];
              otherwise
                ps2 := psm
              end;
              GEN_AX_INTERSECTION( dr1, ps1, dr2, ps2 )
            end;
            is2 := is2 + 1;
            ij := ij + 1
          end
        end;
        ip2 := ip2 + 1
      end
    end;
    ip1 := ip1 + 1
  end
end GEN_INTERPOS;



procedure LOCAL_GROUP_NAME( var nam: string; grp: pgrp_dsc; order: integer := 1 );
{ To write the ponctual group name in the string st from the
  operator list in the set grp.
}
  type
    postbty = array[l_mon..l_cub,ope_2x..ope_mv] of sbyte;

  const
    { Table of positions to insert binary axis and mirrors characters in model string }
                        { 2x, 2y, 2z, 2u, 2v, mx, my, mz, mu, mv }
    ptb_sys  = postbty[ [  1,  1,  1,  1,  1, -1, -1, -1, -1, -1 ], { l_mon }
                        [  1,  6, 11,  0,  0, -1, -6,-11,  0,  0 ], { l_ort }
                        [  6,  7,  1, 11, 12, -6, -7, -1,-11,-12 ], { l_qua }
                        [  6,  7,  1, 11, 12, -6, -7, -1,-11,-12 ], { l_trg }
                        [  6,  7,  1, 11, 12, -6, -7, -1,-11,-12 ], { l_hex }
                        [  6,  6,  1,  6,  6, -2, -2, -1, -6, -6 ], { l_rho }
                        [  1,  2,  3, 11, 12, -1, -2, -3,-11,-12 ]  { l_cub }
                      ];

    model_st = '.    .    .    ';
               {.2345.2345.2345}

  var
    st: string( 15 );
    bf: boolean;


  procedure GROUP_COMPRESS;
  { Suppress all spaces in a ponctual group name }
  var
    i: integer;

  begin
    i := 0;
    for j := 1 to st.length do
      if (st[j] > ' ') and (i < nam.capacity) then
      begin  i := i + 1; nam[i] := st[j]  end;
    nam.length := i
  end GROUP_COMPRESS;



  procedure SET_MONOCLINIC;
  { Generate a Monoclinic Ponctual Group Name for a special position
    of the grp_sys system. The Dot are inserted in agreement with
    the Hermann Maugin notation of the Space Group system. }
  var
    o: oper_code;
    i: sbyte;

  begin
    if grp = [ope_inv] then st := '-1'         { Eliminate the single center case }
    else
    begin { For monoclinic symetry, we can have 2/m, 2 or m only
            because now 1 and -1 are excluded }
      o := ope_2x;
      while (o <= ope_mv) and not (o in grp) do o := SUCC( o );
      if o <= ope_mv then
      begin
        if grp_sys >= l_mon then i := ptb_sys[grp_sys,o]
                            else i := 0;
        if i <> 0 then
          if ope_inv in grp then begin  st[i] := '2'; st[i+1] := '/'; st[i+2] := 'm'  end
                            else if i > 0 then st[ i] := '2'
                                          else st[-i] := 'm'
      end;

      for j := 0 to 2 do
      begin
        i := j*5 + 1;
        if (st[i] = '.') and ((st[i+1] <> ' ') or (st[i+2] <> ' ')) then st[i] := ' '
      end;
      if (grp_sys = l_rho) and (st[11] = '.') then st[11] := ' '
    end
  end SET_MONOCLINIC;


  procedure SET_ORTHORHOMBIC;
  { Generate a Orthorhombic Ponctual Group Name for a special position
    of the grp_sys system. The Dot are inserted in agreement with
    the Hermann Maugin notation of the Space Group system. }
  var
    o: oper_code;
    i: sbyte;

  begin
    { Eliminate the triclinic and monoclinic cases }
    if (grp_sys <= l_mon) or (order <= 2) or ((order <= 4) and (ope_inv in grp)) then
      SET_MONOCLINIC
    else
    begin { We have an orthorhombic symetry }
      { Loop on all possible operators }
      o := ope_2x;
      while o <= ope_mv do
      begin
        if o in grp then
        begin
          i := ptb_sys[grp_sys,o]; { Get the operator place code }
          if i <> 0 then if i > 0 then st[ i] := '2'
                                  else st[-i] := 'm'
        end;
        o := SUCC( o )
      end;
      for j := 0 to 2 do
      begin
        i := j*5 + 1;
        if (st[i] = '.') and ((st[i+1] <> ' ') or (st[i+2] <> ' ')) then st[i] := ' '
      end
    end
  end SET_ORTHORHOMBIC;


  procedure SET_QUADRATIC;
  begin
    if ope_inv in grp then
    begin
      st := '4/m';
      if grp*[ope_2x,ope_2y,ope_2u,ope_2v] <> [] then
        if grp_sys = l_cub then st := st||'m.m'
                           else st := st||'mm'
    end
    else
    begin
      if ope_4bz in grp then
      begin
        st := '-4';
        if grp*[ope_2x,ope_2y] <> [] then
          if grp_sys = l_cub then st := st||'2.m'
                             else st := st||'2m'
        else
          if grp*[ope_mx,ope_my] <> [] then
            if grp_sys = l_cub then st := st||'m.2'
                               else st := st||'m2'
          else
            st := st||'..'

      end
      else
      begin
        st := '4';
        if grp*[ope_2x,ope_2y,ope_2u,ope_2v] <> [] then
          if grp_sys = l_cub then st := st||'2.2'
                             else st := st||'22'
        else
          if grp*[ope_mx,ope_my,ope_mu,ope_mv] <> [] then
            if grp_sys = l_cub then st := st||'m.m'
                               else st := st||'mm'
          else
            st := st||'..'
      end
    end
  end SET_QUADRATIC;


  procedure SET_TRIGONAL;
  begin
    if grp_sys = l_rho then { Rhomboedral }
      if ope_inv in grp then
        if grp*[ope_mx,ope_my,ope_mu,ope_mv] <> [] then st := '-3m'
                                                   else st := '-3.'
      else
        if grp*[ope_mx,ope_my,ope_mu,ope_mv] <> [] then st := '3m'
        else
          if grp*[ope_2x,ope_2y,ope_2u,ope_2v] <> [] then st := '32'
                                                     else st := '3.'
    else { Trigonal }
      if ope_inv in grp then
        if grp*[ope_mx,ope_my] <> [] then st := '-3m.'
        else
          if grp*[ope_mu,ope_mv] <> [] then st := '-3.m'
                                       else st := '-3..'
      else
        if grp*[ope_mx,ope_my] <> [] then st := '3m.'
        else
          if grp*[ope_mu,ope_mv] <> [] then st := '3.m'
          else
            if grp*[ope_2x,ope_2y] <> [] then st := '32.'
        else
          if grp*[ope_2u,ope_2v] <> [] then st := '3.2'
                                       else st := '3..'
  end SET_TRIGONAL;


  procedure SET_HEXAGONAL;
  begin
    if ope_inv in grp then
      if grp*[ope_mx,ope_my,ope_mu,ope_mv] <> [] then st := '6/mmm'
                                                 else st := '6/m..'
    else
      if ope_6bz_h in grp then
        if grp*[ope_mx,ope_my] <> [] then st := '-6m2'
        else
          if grp*[ope_mu,ope_mv] <> [] then st := '-62m'
                                       else st := '-6..'
      else
        if grp*[ope_mx,ope_my,ope_mu,ope_mv] <> [] then st := '6mm'
        else
          if grp*[ope_2x,ope_2y,ope_2u,ope_2v] <> [] then st := '622'
                                                     else st := '6..'
  end SET_HEXAGONAL;


begin { LOCAL_GROUP_NAME }
(*
    bf := true;
    WRITE( output, ' Group = [' );
    for op := ope_inv to ope_6bz_h do
      if op in grp then
      begin
        if bf then bf := false
              else WRITE( output, ',' );
        WRITE( output, op )
      end;
    WRITELN( output, ']' );
*)
  st := model_st;
  case grp_sys of
    l_tri: if ope_inv in grp then st := '-1';

    l_mon: SET_MONOCLINIC;

    l_ort: SET_ORTHORHOMBIC;

    l_qua: if grp*[ope_4z,ope_4bz] <> [] then SET_QUADRATIC
                                         else SET_ORTHORHOMBIC;

    l_trg: if grp*[ope_3z_h,ope_3bz_h] <> [] then SET_TRIGONAL
                                             else SET_ORTHORHOMBIC;

    l_hex: if grp*[ope_6z_h,ope_6bz_h] <> [] then SET_HEXAGONAL
           else
             if grp*[ope_3z_h,ope_3bz_h] <> [] then SET_TRIGONAL
                                               else SET_ORTHORHOMBIC;

    l_rho: if grp*[ope_3r,ope_3br,ope_3z_h,ope_3bz_h] <> [] then SET_TRIGONAL
                                                            else SET_MONOCLINIC;

    l_cub: if grp*[ope_3r,ope_3br] <> [] then
             if ope_mx in grp then
               if ope_4z in grp then st := 'm-3m'
                                else st := 'm-3.'
             else
               if ope_2x in grp then
                 if ope_4z in grp then st := '432'
                 else
                   if ope_4bz in grp then st := '-43m'
                                     else st := '23.'
               else
               begin
                 if ope_3br in grp then st := '.-3'
                                   else st := '.3';
                 if [ope_mu,ope_mv]*grp <> [] then st := st||'m'
                 else
                   if [ope_2u,ope_2v]*grp <> [] then st := st||'2'
                                                else st := st||'.'
               end
           else
             if grp*[ope_4z,ope_4bz] <> [] then SET_QUADRATIC
                                           else SET_ORTHORHOMBIC;

  otherwise
  end;
  GROUP_COMPRESS
end LOCAL_GROUP_NAME;




procedure WRITE_POSITIONS_LIST( var f: text );
const
  posl_frm = '(%2#) %8s, %8s, %8s;';

var
  ifc, ip, ips, nc, np, nz: integer;

  st, sgn: string( 255 );
  stgrp: string( 6 );
  opcd: sbyte;
  ps, tr, dr: lvector;
  br: boolean;
  cp: char;

begin
  { Initialize the position tables }
  grp_ipsnb  := 0;
  grp_iponb  := 0;
  grp_ipofrs := 0;
  np := 0; { Initialize the number of special position }
  { Initialize the Use Operator Flag table }
  for ii := 1 to grp_nope do grp_opef[ii] := false;

  { Create the single position structures }
  for ii := 2 to grp_nope do GEN_OPEQUV( ii );   
  { Create the intersection special positions }
  GEN_INTERPOS;

  { Set the standard name for each position }
  cp := CHR( grp_iponb + ORD( 'A' ) );

  { Assume no position multiply by lattice }
  ifc := 1;

  { Output the General position }
  if grp_dataf then
  begin
    WRITELN( f, ' ', grp_iponb+1:3 );
    WRITE_GEN_POSITIONS( f, posl_frm, 0 )
  end
  else
  begin
    WRITELN( f );
    WRITELN( f, ' Positions List (1..', grp_iponb+1:0, ').' );
    WRITELN( f );
    WRITELN( f, ' Multiplicity,' );
    WRITELN( f, ' our site letter,               Coordinates' );
    WRITELN( f, ' and symmetry' );
    { Generate the lattice translation information }
    case grp_lattice of
      lat_A: begin
               ifc := 2;
               WRITELN( f, ' ':8, '( 0, 0, 0)+, ( 0, 1/2, 1/2)+':60:0 )
             end;
      lat_B: begin
               ifc := 2;
               WRITELN( f, ' ':8, '( 0, 0, 0)+, (1/2, 0, 1/2)+':60:0 )
             end;
      lat_C: begin
               ifc := 2;
               WRITELN( f, ' ':8, '( 0, 0, 0)+, (1/2, 1/2, 0)+':60:0 )
             end;
      lat_I: begin
               ifc := 2;
               WRITELN( f, ' ':8, '( 0, 0, 0)+, (1/2, 1/2, 1/2)+':60:0 )
             end;
      lat_F: begin
               ifc := 4;
               WRITELN( f, ' ':8,
                           '( 0, 0, 0)+, ( 0, 1/2, 1/2)+, (1/2, 0, 1/2)+, (1/2, 1/2, 0)+' )
             end;
      lat_H: begin
               ifc := 3;
               WRITELN( f, ' ':8, '( 0, 0, 0)+, (2/3, 1/3, 1/3)+, (1/3, 2/3, 2/3)+':60:0 )
             end;
    otherwise
    end;
    if grp_lattice > lat_P then WRITELN( f );
    WRITELN( f );
    WRITE( f, ' ', grp_nope*ifc:3, ' ':2, cp:4, '1':10 );
    WRITE_GEN_POSITIONS( f, posl_frm, 20 );
    WRITELN( f )
  end;

  { Output each computed special position }
  ip := grp_ipofrs;
  while ip > 0 do
  with grp_ipotb[ip] do
  begin { Loop on each position }
    ips := ipo_idx;
    cp := PRED( cp );                        { Decrement the position letter }

    LOCAL_GROUP_NAME( stgrp, ipo_group, grp_nope div ipo_size );

    { Write the position header }
    if grp_dataf then WRITELN( f, ' ', ipo_size:3 )
                 else WRITE( f, ' ', ipo_size*ifc:3, ' ':2, cp, '*':3, stgrp:6, ' ':4 );

    for ii := 1 to ipo_size do
    begin
      POSITION_IN_STR( grp_ipstb[ii+ips-1], 'x', 'y', 'z',
                       posl_frm, st, ipo_size/grp_nope, ii, ii );
      if ii > 1 then WRITE( f, ' ':20 );
      WRITELN( f, st )                       { Write the position site }
    end;
    if not grp_dataf then WRITELN( f );
    ip := ipo_next
  end;
  if not grp_dataf then
  begin
    WRITELN( f, ' Warning: The specified letters are not the Wyckoff letters (and can be different).' );
    WRITELN( f )
  end
end WRITE_POSITIONS_LIST;




{********************************************************************}
{*         GEN_SPACE_GROUP Generate Space Group Procedures          *)
{********************************************************************}



procedure DISPLAY_LVECTOR( var f: text; in_var trans: lvector );
var
  n, d: integer;

begin
  WRITE( f, ' (' );
  for i := 1 to 3 do
  begin
    FRACTION_SIMPLIFY( n, d, trans[i] );
    if d >= 10 then WRITE( f, n:3,'/',d:2 )
               else if d > 0 then WRITE( f, n:2,'/',d:1 )
                             else WRITE( f, '   0' );
    if i < 3 then WRITE( f, ', ' )
  end;
  WRITELN( f, ')' )
end DISPLAY_LVECTOR;



procedure DISPLAY_OPERATOR { ( var f: text; in_var name: string; in_var oper: operator ) };
{ Was forward }
var
  n, d:         integer;

begin
  if grp_dataf then
  begin
    for i := 1 to 3 do
      for j := 1 to 4 do
        WRITE( f, ' ', oper[i,1]:4 );
    WRITELN( f )
  end
  else
  begin
    WRITELN( f, ' Operator ', name, ' is :' );
    for i := 1 to 3 do
    begin
      WRITE( f, ' ':6, '||', oper[i,1]:3, ',', oper[i,2]:3, ',', oper[i,3]:3, ',' );
      FRACTION_SIMPLIFY( n, d, oper[i,4] );
      if d >= 10 then WRITE( f, n:4,'/',d:2 )
                 else if d > 0 then WRITE( f, n:5,'/',d:1 )
                               else WRITE( f, '      0' );
      WRITELN( f, ' ||' )
    end;
    WRITELN( f )
  end 
end DISPLAY_OPERATOR;




function GEN_OPERATOR( opcd: oper_code; trans: lvector ): operator;
{ Generate an operator from the operator code opcd
  and the related translation trans in 1/24 fractional units }
var
  iv: integer;

begin
(*
WRITELN( ' new op = (', opcd, '|', trans[1]:3, ',', trans[2]:3, ',', trans[3]:3, ').' );
*)
  for i := 1 to 3 do
  begin
    for j := 1 to 3 do GEN_OPERATOR[i,j] := ope_tab[opcd,i,j];
    iv := trans[i] mod 24;
    if iv > 12 then iv := iv - 24
               else if iv <= -12 then iv := iv + 24;
    GEN_OPERATOR[i,4] := iv
  end
end GEN_OPERATOR;



procedure FIT_TO_LATTICE;
  { Simplify the translation of all operators when possible }

  procedure FIT_TRANS( var op: operator; i, j, v: integer );
  begin
    op[i,4] := (op[i,4] - v) mod 24;
    op[j,4] := (op[j,4] - v) mod 24
  end FIT_TRANS;


  procedure FIT_OPE( var op: operator );
  begin
    { Simplify the translation of the operator when possible }
    case grp_lattice of
      lat_A: if (op[2,4] >= 12) and (op[3,4] >= 12) then FIT_TRANS( op, 2, 3, 12 );

      lat_B: if (op[1,4] >= 12) and (op[3,4] >= 12) then FIT_TRANS( op, 3, 1, 12 );

      lat_C: if (op[1,4] >= 12) and (op[2,4] >= 12) then FIT_TRANS( op, 1, 2, 12 );

      lat_F: if (op[2,4] >= 12) and (op[3,4] >= 12) then FIT_TRANS( op, 2, 3, 12 )
             else
             if (op[3,4] >= 12) and (op[1,4] >= 12) then FIT_TRANS( op, 3, 1, 12 )
             else
             if (op[1,4] >= 12) and (op[2,4] >= 12) then FIT_TRANS( op, 1, 2, 12 );

      lat_I: if op[1,4] = 12 then
             begin
               FIT_TRANS( op, 2, 3, 12 );
               op[1,4] := (op[1,4] - 12) mod 24  
             end
             else
               if op[1,4] + op[2,4] + op[3,4] >= 24 then
               begin
                 FIT_TRANS( op, 1, 2, 12 );
                 op[3,4] := (op[3,4] - 12) mod 24  
              end;
    otherwise
    end
  end FIT_OPE;

begin
  for i := 1 to grp_nope do FIT_OPE( grp_oper[i] )
end FIT_TO_LATTICE;


procedure ADD_OPERATOR( op: operator );
{ Add the operator op to the operator list grp_oper }
const
  mdnam = 'ADOP';

var
  ig, ii, jj:  integer;
  ok, binv:    boolean;

begin
  ig := 1;
  while (ig <= grp_nope) and OPER_NEQ( op, grp_oper[ig] ) do ig := ig + 1;
  if ig > grp_nope then
    if grp_nope < max_ope then
    begin
      grp_nope := grp_nope + 1;
      grp_oper[grp_nope] := op;
      for i := 1 to 3 do
        for j := 1 to 3 do
          if i = j then begin  if op[i,j] <> -1 then goto NO_CENTER  end
                   else if op[i,j] <> 0 then goto NO_CENTER;
      grp_invope := grp_nope;
NO_CENTER:
    end
    else
    begin
      ERROR( mdnam, 'Too many operator, Impossible crystallographic group.' );
      PASCAL_EXIT( 2 )
    end
end ADD_OPERATOR;



procedure GROUP_COMPLETE( nst: integer := 1 );
var
  i1, i2: integer;
  op: operator;

begin
  i1 := nst;
  repeat
    i2 := 1;
    repeat
      ADD_OPERATOR( grp_oper[i1] * grp_oper[i2] );
      i2 := i2 + 1
    until i2 > grp_nope;
    i1 := i1 + 1
  until i1 > grp_nope
end GROUP_COMPLETE;




procedure BUILD_GEN_LIST( ind: integer );
var
  op: operator;
  ig: integer;

begin
  with sgrp_tabl[ABS( ind )] do
  begin
    if sgrp_subg < 0 then
    begin
      ADD_OPERATOR( GEN_OPERATOR( sgrp_oper, sgrp_tran ) );
      GROUP_COMPLETE( grp_nope )                { Complete the group. }
    end;
    if sgrp_subg <> 0 then
    begin
      ig := grp_nope + 1;
      BUILD_GEN_LIST( sgrp_subg );
      for ii := ig to grp_nope do
      begin
        if sgrp_orien <> l_xyz then
          grp_oper[ii] := CANONIC_TRANS( oroptb[sgrp_orien], grp_oper[ii] );
        TRANSLATE_OPERATOR( grp_oper[ii], sgrp_shift );
        if sgrp_subg < 0 then GROUP_COMPLETE( grp_nope ) { Complete the group. }
      end
    end;
    if sgrp_subg >= 0 then
    begin
      op := GEN_OPERATOR( sgrp_oper, sgrp_tran );
      ADD_OPERATOR( GEN_OPERATOR( sgrp_oper, sgrp_tran ) )
    end;
    GROUP_COMPLETE( grp_nope )                  { Complete the group. }
  end
end BUILD_GEN_LIST;



procedure GEN_K_GROUP;
{ Set the K vector group flags for each defined wave vector }
var
  qq, dv:              dvector;
  ih, ik, il:          integer;

begin
  for iq := 1 to grp_qvnbr do
  with grp_qvect[iq] do
  begin
    qq := qw_vect;
    for ig := 1 to grp_nope do
    begin
      dv[1] := qq[1]*grp_oper[ig,1,1] + qq[2]*grp_oper[ig,2,1] + qq[3]*grp_oper[ig,3,1] - qq[1];
      dv[2] := qq[1]*grp_oper[ig,1,2] + qq[2]*grp_oper[ig,2,2] + qq[3]*grp_oper[ig,3,2] - qq[2];
      dv[3] := qq[1]*grp_oper[ig,1,3] + qq[2]*grp_oper[ig,2,3] + qq[3]*grp_oper[ig,3,3] - qq[3];
      { Set the Group Operator Invariance flag for this Wave vector }
      hkl_wvftb[iq,ig] := (ABS( dv[1] ) <= EPS) and (ABS( dv[2] ) <= EPS) and (ABS( dv[3] ) <= EPS);
      { Now set the K vector group element flag for this wave vector }
      hkl_gkftb[iq,ig] := R_LATTICE_VECTOR( dv );
      if hkl_gkftb[iq,ig] then for i := 1 to 3 do  qw_gkt[ig,i] := ROUND( dv[i] )
(*
; WRITELN( ' Q # ', iq:1, ' Oper # ', ig:2, ' IK : ', hkl_wvftb[iq,ig], ' GK : ', hkl_gkftb[iq,ig] )
*)
    end
  end
end GEN_K_GROUP;



Procedure GEN_SPACE_GROUP;
const
  mdnam = 'GSPG';

var
  nam: sgrp_ide;
  trans: lvector;
  i, isg, isc: integer;
  s: string( 32 );
  sxyz: string( 128 );
  b_tprm: boolean := false;


  function MATCH( in_var n1, n2: sgrp_ide ): boolean;
  var
    ii: integer;
    re: boolean;

  begin
    if n1.len <> n2.len then return false
    else
    begin
      ii := 1;
      while ii <= n1.len do
        if n1.str[ii] = n2.str[ii] then ii := ii + 1
                                   else return false;
      return true
    end
  end MATCH;


begin { GEN_SPACE_GROUP }

  if grp_number <= 0 then
  begin
    { * * Set the format of Space Group Name * * }
    CHANGE_CASE( grp_name, true, 1, 1 );        { Force The Lattice Letter to be in major case }
    CHANGE_CASE( grp_name, false, 2 );          { ... and the remainder of name in minor case }
    if grp_name.length > sgrp_idlmx then nam.len := sgrp_idlmx
                                    else nam.len := grp_name.length;
    for ii := 1 to nam.len do nam.str[ii] := grp_name[ii];

    if (INDEX( 'abcdmn', nam.str[2] ) > 0) and (nam.str[3] = '3') then
    begin { Accept the centered cubic space group name without the '-' character }
      nam.len := nam.len + 1;
      for i := nam.len downto 4 do  nam.str[i] := nam.str[i-1];
      nam.str[3] := '-' { Insert the minus sign }
    end;

    { * * Look for the Specified Group in the table * * }
    isg := 1;
    while (isg <= sgrp_tabl.sgrp_tblen) and
          (not MATCH( sgrp_tabl[isg].sgrp_name, nam )) do
      isg := isg + 1;
  end
  else if grp_number <= 0 then isg := -1
                          else isg := grp_number;

  if grp_orient = l_xyz then
    { Not handled when a user orientation is specified }
    if isg > sgrp_tabl.sgrp_tblen then
    begin
      isc := 1;
      while (isc <= sgrp_cvtb.sgrp_cvlen) and
            (not MATCH( sgrp_cvtb[isc].sgrp_cname, nam )) do
        isc := isc + 1;
      if isc <= sgrp_cvtb.sgrp_cvlen then
      with sgrp_cvtb[isc] do
      begin
        i := INDEX( 'PABCFIRH', sgrp_cname.str[1] );
        grp_name.length := sgrp_cname.len;
        for l := 1 to grp_name.length do
          grp_name[l] := sgrp_cname.str[l];
        b_tprm := true;
        isg := sgrp_cinid;
        grp_orient := sgrp_corien
      end
    end;

  if (isg < 1) or (isg > sgrp_tabl.sgrp_tblen) then
  begin
    ERROR( mdnam, 'Unknown Space Group', grp_name );
    PASCAL_EXIT( 2 )
  end;

  with sgrp_tabl[isg] do
  begin { With the Found Space group }
    if not b_tprm then
    begin
      i := INDEX( 'PABCFIRH', sgrp_name.str[1] );
      grp_name.length := sgrp_name.len;
      for l := 1 to grp_name.length do
        grp_name[l] := sgrp_name.str[l]
    end;
    grp_lattice := lat_type( i );               { Set the Lattice kind }
    grp_number  := sgrp_inid;                   { Set the Space Group Number }
    grp_sys     := sgrp_nsys;                   { ... and the Lattice System Kind }
    ADD_OPERATOR( identity_ope );               { Always Put the Identity in first, }
    BUILD_GEN_LIST( isg );                      { ... add the generator operator, }
    if sgrp_subg < 0 then GROUP_COMPLETE( grp_nope ); { Complete the group. }
    FIT_TO_LATTICE;                             { Adapt the translation to the lattice }

    if grp_orient <> l_xyz then
      for ii := 1 to grp_nope do
        grp_oper[ii] := CANONIC_TRANS( oroptb[grp_orient], grp_oper[ii] )
  end;

  { Now perform the user origine change when required }
  if grp_org then
  begin
    for ii := 1 to 3 do trans[ii] := 24 - grp_utrans[ii];
    for ii := 1 to grp_nope do
      TRANSLATE_OPERATOR( grp_oper[ii], grp_utrans )
  end;
  if grp_qvnbr > 0 then GEN_K_GROUP
end GEN_SPACE_GROUP;



procedure CELL_COMPUTE;
const
  mdnam = 'CELL';

  inrd = ARCTAN( 1.0 )/45.0;

var
  ccos, sal, sbe, sga: real;
  ndef: integer;
  badcell, undcell: boolean;


  procedure SET_CELL_PARM( var pa: real; cv: real; bz: boolean := false );
  begin
    if bz and (ABS( pa ) < 1.0E-5) then pa := cv
                                   else if ABS( pa - cv ) < 1.0E-5 then pa := cv
  end SET_CELL_PARM;


  procedure SET_ANGLE( var v: real );
  begin
    if v < -1.0 then v := 0.0
                else if v > 1.0 then v := COS( inrd*v );
    if ABS( v ) < 1E-5 then v := 0.0
  end SET_ANGLE;


begin { CELL_COMPUTE }
  { Set the default Unit Cell Parameter in agreement with the Space Group }
  SET_ANGLE( d_al );
  SET_ANGLE( d_be );
  SET_ANGLE( d_ga );
  case grp_sys of
    l_cub: begin
             SET_CELL_PARM( d_al,  0.0 );
             SET_CELL_PARM( d_be,  0.0 );
             SET_CELL_PARM( d_ga,  0.0 );
             SET_CELL_PARM( d_bb, d_aa, true );
             SET_CELL_PARM( d_cc, d_aa, true );
             badcell := (d_al <>  0.0) or (d_be <>  0.0) or (d_ga <>  0.0) or
                        (d_cc <> d_aa) or (d_bb <> d_aa) or (d_aa <=  0.0)
           end;

    l_rho: begin
             SET_CELL_PARM( d_be, d_al, true );
             SET_CELL_PARM( d_ga, d_al, true );
             SET_CELL_PARM( d_bb, d_aa, true );
             SET_CELL_PARM( d_cc, d_aa, true);
             badcell := (d_al <> d_be) or (d_al <> d_ga) or
                        (d_cc <> d_aa) or (d_bb <> d_aa) or (d_aa <=  0.0)
           end;

    l_qua: begin
             SET_CELL_PARM( d_al,  0.0 );
             SET_CELL_PARM( d_be,  0.0 );
             SET_CELL_PARM( d_ga,  0.0 );
             SET_CELL_PARM( d_bb, d_aa, true );
             badcell := (d_al <>  0.0) or (d_be <>  0.0) or (d_ga <>  0.0) or
                        (d_bb <> d_aa) or (d_aa <=  0.0) or (d_cc <=  0.0)
           end;

    l_trg,
    l_hex: begin
             SET_CELL_PARM( d_al,  0.0 );
             SET_CELL_PARM( d_be,  0.0 );
             SET_CELL_PARM( d_ga, -0.5 );
             SET_CELL_PARM( d_bb, d_aa, true );
             badcell := (d_al <>  0.0) or (d_be <> 0.0) or (d_ga <> -0.5) or
                        (d_bb <> d_aa) or (d_aa <= 0.0) or (d_cc <=  0.0)
           end;

    l_ort: begin
             SET_CELL_PARM( d_al,  0.0 );
             SET_CELL_PARM( d_be,  0.0 );
             SET_CELL_PARM( d_ga,  0.0 );
             badcell := (d_al <>  0.0) or (d_be <>  0.0) or (d_ga <>  0.0) or
                        (d_aa <=  0.0) or (d_bb <=  0.0) or (d_cc <=  0.0)
           end;

    l_mon: begin
             SET_CELL_PARM( d_al,  0.0 );
             SET_CELL_PARM( d_be,  0.0 );
             SET_CELL_PARM( d_ga,  0.0 );
             ndef := 0;
             if d_al <> 0.0 then ndef := ndef + 1;
             if d_be <> 0.0 then ndef := ndef + 2;
             if d_ga <> 0.0 then ndef := ndef + 4;
             case ndef of
               4: badcell := (grp_orient <> l_xyz) and (grp_orient <> l_yxz);
               2: badcell := (grp_orient <> l_yzx) and (grp_orient <> l_xzy);
               1: badcell := (grp_orient <> l_zxy) and (grp_orient <> l_zyx);
               0: badcell := false;
             otherwise
               badcell := true
             end
           end;

    l_tri: badcell := false;

    l_und: badcell := true
  end;
  if badcell then
    ERROR( mdnam, 'Illegal Unit Cell or incompatible Unit Cell with', grp_name );

  { Compute the direct and reciprocal unit cell parameters }
  sal := SQR( d_al ); sbe := SQR( d_be ); sga := SQR( d_ga );
  d_vol := d_aa*d_bb*d_cc*SQRT( 1.0 + 2.0*d_al*d_be*d_ga - sal - sbe - sga );
  if d_vol <= 1.0 then ERROR( mdnam, 'Bad Unit Cell ( Volume < 1A**3 ).' );
  r_vol := 1.0/d_vol;
  sal := SQRT( 1.0 - sal ); sbe := SQRT( 1.0 - sbe ); sga := SQRT( 1.0 - sga );
  r_al := (d_be*d_ga - d_al )/(sbe*sga);
  r_be := (d_ga*d_al - d_be )/(sga*sal);
  r_ga := (d_al*d_be - d_ga )/(sal*sbe);
  r_aa := d_bb*d_cc*sal/d_vol;
  r_bb := d_cc*d_aa*sbe/d_vol;
  r_cc := d_aa*d_bb*sga/d_vol;

  { Build the metric tensors }
  grp_dmt[1,1] :=    SQR( d_aa ); grp_rmt[1,1] :=    SQR( r_aa );
  grp_dmt[2,2] :=    SQR( d_bb ); grp_rmt[2,2] :=    SQR( r_bb );
  grp_dmt[3,3] :=    SQR( d_cc ); grp_rmt[3,3] :=    SQR( r_cc );
  grp_dmt[1,2] := d_aa*d_bb*d_ga; grp_rmt[1,2] := r_aa*r_bb*r_ga;
  grp_dmt[2,3] := d_bb*d_cc*d_al; grp_rmt[2,3] := r_bb*r_cc*r_al;
  grp_dmt[3,1] := d_aa*d_cc*d_be; grp_rmt[3,1] := r_aa*r_cc*r_be;
  grp_dmt[2,1] :=   grp_dmt[1,2]; grp_rmt[2,1] :=   grp_rmt[1,2];
  grp_dmt[3,2] :=   grp_dmt[2,3]; grp_rmt[3,2] :=   grp_rmt[2,3];
  grp_dmt[1,3] :=   grp_dmt[3,1]; grp_rmt[1,3] :=   grp_rmt[3,1];

  { Build the Work reference translation Matrix }
  if grp_sys = l_rho then
  begin { Work Reference for Rhomboedral Unit Cell }
    sal := (2.0/3.0)*SQRT( 1.0 - d_al ) + SQRT( 1.0 + 2.0*d_al )/3.0;
    sbe := d_aa*sal; sga := d_aa*SQRT( 1.0 - SQR( sal ) )/SQRT( 2.0 );
    if d_al < 0.0 then sga := - sga;
    for i := 1 to 3 do
      for j := 1 to 3 do
        if i = j then grp_tmd[i,j] := sbe
                 else grp_tmd[i,j] := sga
  end
  else
  begin { Standard Work Reference Unit Cell }
    sga := SQRT( 1.0 -SQR( d_ga ) );
    sal := (d_al - d_be*d_ga)/sga;
    grp_tmd[1,1] :=  d_aa; grp_tmd[1,2] := d_bb*d_ga; grp_tmd[1,3] := d_cc*d_be;
    grp_tmd[2,1] :=   0.0; grp_tmd[2,2] :=  d_bb*sga; grp_tmd[2,3] :=  d_cc*sal;
    grp_tmd[3,1] :=   0.0; grp_tmd[3,2] :=       0.0;
    grp_tmd[3,3] := d_cc*SQRT( 1.0 - SQR( sal ) - SQR( d_be ) )
  end;
  { ... and we deduce the reciprocal transformation }
  grp_tmr := INV_MATRIX( grp_tmd );
  ccos := grp_tmr[1,2]; grp_tmr[1,2] := grp_tmr[2,1]; grp_tmr[2,1] := ccos;
  ccos := grp_tmr[2,3]; grp_tmr[2,3] := grp_tmr[3,2]; grp_tmr[3,2] := ccos;
  ccos := grp_tmr[3,1]; grp_tmr[3,1] := grp_tmr[1,3]; grp_tmr[1,3] := ccos
end CELL_COMPUTE;





{  *****************************************************  }
{  ***                                               ***  }
{  ***  HKL Generator for the specified Space Group  ***  }
{  ***                                               ***  }
{  *****************************************************  }


procedure HKL_NQ_LIMIT;
{ Limit the NQ variation range for each Rational Wave-Vector }
var
  qv:                  dvector;
  nf, nb, nv, nm:      integer;
  br:                  boolean;

begin
  nb  := 1;                                             { Init the (IQ,NQ) map count where (IQ,NQ) = (0,0) is take in account here }
  nm  := 0;                                             { Init the global maximum value of the NQ }
  for iq := 1 to grp_qvnbr do                           { Loop on all defined Wave vector(s) }
  with grp_qvect[iq] do                                 { For one Wave vector (qw) }
  begin
    br := false;                                        { Assume not rational by default }
    nf := 1;                                            { Loop on the qw factor nf from 1 to the user specified range size }
    repeat
      for ii := 1 to 3 do qv[ii] := nf*qw_vect[ii];     { Compute nf*qw }
      br := R_LATTICE_VECTOR( qv );                     { Test when nf*qw is a Lattice vector }
      nf := nf + 1;                                     { Increment nf for the next test }
    until (nf > qw_nqma - qw_nqmi) or  br;              { Stop the loop if the test was positif }
    if br then                                          { When we have found an nf*qw that was a Lattice vector ... }
    begin                                               { ... the Wave vector (qw) must be set as rational }
      nf      :=    nf - 1;                             { Restore this nf value }
      qw_nqma :=  nf div 2;                             { Set the new value of the maximum of nq (nqma) }
      qw_nqmi := - qw_nqma;                             { The minimum value (nqmi) must be symetric except when nf is even ... }
      if not ODD( nf ) then qw_nqmi := qw_nqmi + 1;     { ... to avoid h = H - nqmi*qw = H + nqma*qw - nf*qw (H a lattice vector) }
      for ij := 1 to 3 do qw_nfqv[ij] := ROUND( qv[ij] );
      qw_nf   :=        nf                              { Save the nf value }
    end;
    qw_rflg  := br;                                     { Set the rational/irrational wave Vector flag }
    nv := qw_nqma - qw_nqmi;                            { Get the number of NQ value with 0 exclude }
(*
WRITELN( ' Q # ', iq:1, ', min..max = ', qw_nqmi:0, '..', qw_nqma:0 );
*)
    nb := nb + nv;                                      { Count of value for all (iq,nq) sets [(0,0) was already counted] }
    if nm < qw_nqma then nm := qw_nqma                  { Get the maximum value of nq }
  end;
  if not ODD( nb ) then nb := nb + 1;                   { Make size as ODD to get a symmetry map }
  hkl_mdim := nb;                                       { Allocate the map space for all (iq,nq) set values }
  hkl_morg := (nb + 1) div 2;                           { Set the map origine at middle }
  nb := nm + 1;                                         { Now nb is the index shift for nq = 0 in the HKL-NQ map offset table }
(*
WRITELN( ' (nq,id) Map size = ', hkl_mdim:0 );
WRITELN( ' (nq,id) Map (0,0) Origine index = ', hkl_morg:0 );
WRITELN( ' Tranlation array hkl_iqtb[1..', grp_qvnbr:0, ',1..', 2*nm + 1:0, '] where id = IQTB[<iq>,<nq>]' );
WRITELN( ' Tranlation array hkl_idtb[1..', hkl_mdim:0, '] where record(nq,iq) = IDTB[<id>]' );
*)
  NEW( hkl_iqtb, grp_qvnbr, 2*nm + 1 );                 { Allocate memory for the (iq,nq) sets HKL-NQ map offset table }
  NEW( hkl_idtb, hkl_mdim );                            { Allocate memory for the HKL-NQ map (iq,nq) sets table }
(*
WRITELN( ' Read hkl_iqtb sizes : (', hkl_iqtb^.n:0, ',', hkl_iqtb^.m:0, ')' );
WRITELN( ' Read hkl_idtb sizes : (', hkl_idtb^.n:0, ')' );
*)
  nf := 0;                                              { Init the previuos Wave Vector shift }
  for iq := 1 to grp_qvnbr do                           { Loop on all Wave vectors to fill the translation table }
    with grp_qvect[iq] do
    begin
(*
WRITELN( ' Init hkl_iqtb^[',iq:0, ',', nb:0, '] := ', hkl_morg:0, ';' );
*)
      hkl_nqorg := nb;                                  { Keep the NQ = 0 location in the translation table }
      hkl_iqtb^[iq,nb] := 0;                            { Put the HKL-NQ map offset of (iq,0) }
      nv := + nf;
      for nq := 1 to nm do                              { Loop on all positive nq values }
      begin
        if nq <= qw_nqma then nv := nv + 1
                         else nv := maxint;
        hkl_iqtb^[iq,nb+nq] := nv
      end;
      nv := - nf;
      for nq := -1 downto -nm do                        { Loop on all negative nq values }
      begin
        if nq >= qw_nqmi then nv := nv - 1
                         else nv := maxint;
        hkl_iqtb^[iq,nb+nq] := nv
      end;
      nf := nf + qw_nqma
    end;

  hkl_idtb^[hkl_morg] := hkl_qnset[ 0, 0];
  nv := 1;
  for iq :=  1 to grp_qvnbr do
    with grp_qvect[iq] do
    begin
      nf := 1;
      for nq := 1 to qw_nqma do
      begin
        with hkl_idtb^[hkl_morg+nv] do
        begin  iqv := iq; nqv :=   nq  end;
        with hkl_idtb^[hkl_morg-nv] do
        begin  iqv := iq; nqv := - nq  end;
        nv := nv + 1
      end
    end
(*
;
WRITELN;
WRITELN( ' iqtb table' );
WRITE( ' Nq values ':12 );
for j := -nm to nm do WRITE( j:13 );
WRITELN;
for i := 1 to hkl_iqtb^.n do
begin
  WRITE( '  iq = ', i:2, ' : ' );
  for j := 1 to hkl_iqtb^.m do
    WRITE( ' ', hkl_iqtb^[i,j]:12 );
  WRITELN
end;
WRITELN;
WRITELN( ' idtb table' );
for i := 1 to hkl_idtb^.n do with hkl_idtb^[i] do WRITE( ' (', iqv:0, ',', nqv:0, ')' );
WRITELN;
WRITELN;
*)
end HKL_NQ_LIMIT;



function  HKL_INDEX( in_var hkl: hkln_tab ): integer;
{ Compute the HKL-NQ map index from the hkl reflection indicies.
  When a rational wave vector is specified, nq can be equal to qw_nqmi -1.
  In this case nq is augmented by qw_nf and the HKL are diminued by the
  lattice vector nf*Wave_vector.
}
var
  id, iq, nq: integer;

begin
(*
WRITE( ' HKL_INDEX [', hkl[1]:5, ',', hkl[2]:4, ',', hkl[3]:4, ',', hkl[4]:5, ',', hkl[5]:3, '] -> ' );
*)
  id := hkl[1]*hkl_elh + hkl[2]*hkl_elk + hkl[3]*hkl_ell + hkl_morg;
  if hkl[4] <> 0 then
  begin
    nq := hkl[4] + hkl_nqorg; iq := hkl[5]; { Warning nq value are shifted by hkl_nqorg to start from 1 }
(*
with grp_qvect[iq] do
WRITE( ' with id0 = ', id:12, ', nf = ', qw_nf:4, ' and cmb = ' );
with grp_qvect[iq] do
if nq >= qw_nqmi then WRITE( hkl_iqtb^[iq,nq]:12, ' --> ' )
                 else WRITE( hkl_iqtb^[iq,nq+qw_nf]:12, ' and shf = ', qw_msup:12, ' --> ' );
*)
    with grp_qvect[iq] do
      if nq < qw_nqmi then id := id + hkl_iqtb^[iq,nq+qw_nf] - qw_msup
                      else id := id + hkl_iqtb^[iq,nq]
  end;
(*
WRITELN( id:12 );
*)
  HKL_INDEX := id
end HKL_INDEX;



procedure HKL_GET_HKL( hklid: integer; var hkl: hkln_tab );
{ Get the hkl-nq equivalent of the hklid HKL-NQ map index }
begin
(*
WRITE( ' GET HKL ', hklid:12 );
*)
  hklid := hklid - 1;
  hkl[3] := hklid div hkl_ell - grp_hklmax[3]; hklid := hklid mod hkl_ell;
  hkl[2] := hklid div hkl_elk - grp_hklmax[2]; hklid := hklid mod hkl_elk;
  hkl[1] := hklid div hkl_elh - grp_hklmax[1];

  if grp_qvnbr > 0 then
  begin
    hklid := hklid mod hkl_elh;
(*
WRITELN( ' NQ/IQ code = ', hklid:6 );
*)
    with hkl_idtb^[hklid+1] do
    begin
      hkl[5] := iqv; hkl[4] := nqv
    end
  end
  else
  begin
    hkl[5] := 0; hkl[4] := 0
  end
(*
;WRITELN( ' -> [', hkl[1]:5, ',', hkl[2]:4, ',', hkl[3]:4, ',', hkl[4]:5, ',', hkl[5]:3, ']' )
*)
end HKL_GET_HKL;



function  HKL_FRIEDEL( hklid: integer ): integer;
{ Get the Fridel partner HKL-NQ map index of the given HKL-NQ map index }
var
  hkl:        hkln_tab;
  idq, iq, nq: integer;

begin
  if hkl_elh = 1 then
    HKL_FRIEDEL := 2*hkl_morg - hklid
  else
  begin
    idq := (hklid - 1) mod hkl_elh;
    with hkl_idtb^[idq+1] do
    begin  nq := -nqv; iq := iqv  end;
    if nq >= 0 then
      HKL_FRIEDEL := 2*hkl_morg - hklid
    else
      with grp_qvect[iq] do
        if nq >= qw_nqmi then
          HKL_FRIEDEL := 2*hkl_morg - hklid
        else
          HKL_FRIEDEL := 2*hkl_morg - hklid + qw_nf - qw_msup
  end
(* Other possible coding (more slowly) :
  HKL_GET_HKL( hklid, hkl );
  for ii := 1 to 4 do hkl[ii] := - hkl[ii];
  HKL_FRIEDEL := HKL_INDEX( hkl )
*)
end HKL_FRIEDEL;



procedure HKL_US2D_SORT;
const
  lm_sort = 8;

var
  i1, j1: integer;


  function  HKL_SORT_TEST( ii, nh: integer; cv: real ): boolean;
  var
    it: integer;

  begin
    it := hkl_itab^[ii];
    with hkl_htab^[it] do
(*
    with hkl_htab^[hkl_itab^[ii]] do
*)
      if hkl_us2d < cv then HKL_SORT_TEST := true
                       else if (hkl_us2d = cv) and (hkl_id > nh) then HKL_SORT_TEST := true
                                                                 else HKL_SORT_TEST := false
  end HKL_SORT_TEST;


  procedure HKL_S_SORT( ib, it: integer );
  { Substitution Sort procedure }
  var
    id, jj, nh:        integer;
    cv:                   real;

  begin
    for ii := ib + 1 to it do
    begin
      id := hkl_itab^[ii];
      cv := hkl_htab^[id].hkl_us2d;
      nh := hkl_htab^[id].hkl_id;               { Get the i-hkl number for equ sorting }
      jj := ii - 1;
{     while (jj > 0) and (hkl_htab^[hkl_itab^[jj]].hkl_usd > cv) do }
      while (jj > 0) and not HKL_SORT_TEST( jj, nh, cv ) do
      begin
        hkl_itab^[jj+1] := hkl_itab^[jj];
        jj := jj - 1
      end;
      hkl_itab^[jj+1] := id
    end;
  end HKL_S_SORT;



  procedure HKL_Q_SORT( ib, it: integer );
  { Quick Sort procedure }
  var
    ic, ip, nh, tm:     integer;
    cv:                    real;

  begin
    if it > ib then
    begin
      ip := (ib + it) div 2;                    { Get the middle hkl itab index as pivot }
      tm := hkl_itab^[ip];                      { Get the related hkl index }
      cv := hkl_htab^[tm].hkl_us2d;             { Get the middle hkl sorting value (usd = 1/2d) }
      nh := hkl_htab^[tm].hkl_id;               { Get the i-hkl number for equ sorting }
      hkl_itab^[ip] := hkl_itab^[ib];           { Put the middle hkl itab index at the begin of area }
      hkl_itab^[ib] := tm;

      ic := ib;                                 { Start with the initial middle hkl }
      for ii := ib + 1 to it do                 { Loop on all partition elements }
        if HKL_SORT_TEST( ii, nh, cv ) then     { When we found an usd(hkl) < usd(pivot hkl) ... }
        begin
          ic := ic + 1;                         { ... we update the future position of the pivot }
          if ii <> ic then
          begin                                 { When the ii and ic array locations are differents exchange it ... }
            tm := hkl_itab^[ii];                { ... to put all pivot lower ellement at left of future pivot location. }
            hkl_itab^[ii] := hkl_itab^[ic];
            hkl_itab^[ic] := tm
          end
        end;

      tm := hkl_itab^[ic];                      { Put the middle value hkl to the right place }
      hkl_itab^[ic] := hkl_itab^[ib];
      hkl_itab^[ib] := tm;

      { For the small partition, the substitution sort is used }
      { Recursive call for the lower partition }
      if ic - ib < lm_sort then HKL_S_SORT( ib, ic - 1 )
                           else HKL_Q_SORT( ib, ic - 1 );
      { Recursive call for the upper partition }
      if it - ic > lm_sort then HKL_S_SORT( ic + 1, it )
                           else HKL_Q_SORT( ic + 1, it )
    end
  end HKL_Q_SORT;



begin { HKL_US2D_SORT }
  if (hkl_htab <> nil) and (hkl_nhkl > 1) then

    if hkl_nhkl <= lm_sort then HKL_S_SORT( 1, hkl_nhkl )
                           else HKL_Q_SORT( 1, hkl_nhkl )
(*
  HKL_S_SORT( 1, hkl_nhkl )
*)
end HKL_US2D_SORT;



procedure HKL_LIST_OUTPUT( var f: text );
const
          {12341234}
  nqstr = '   0   0';   { String to output when no Wave Vector used }
  enstr =  '  1    ';   { String for end of equivalent group }

var
  id, hklid, ih, ik, il, mlt, ndv:     integer;
  hkl:                                hkln_tab;
  bskp:                                boolean;

  procedure OUT_FULL_HKL( var hkl: hkl_rec; mlt, ifl: integer );
  begin
    with hkl do
    begin
      WRITE( f, hkl_hkl[1]:5, hkl_hkl[2]:4, hkl_hkl[3]:4 );
      if grp_qvnbr = 0 then WRITE( f, nqstr )
                       else WRITE( f, hkl_hkl[4]:4, hkl_hkl[5]:4 );
      WRITE( f, mlt:5, ifl:3 );
      if ifl > 0 then
      begin
        WRITE( f, ' ':3, ABS( hkl_mul ):4, ' ':2, hkl_us2d:10:6 );
        if hkl_wavel > 0.0 then WRITE( f, ' ', (2.0/inrd)*ARCSIN( hkl_us2d*hkl_wavel ):9:4 )
      end;
      WRITELN( f )
    end
  end OUT_FULL_HKL;


begin { HKL_LIST_OUTPUT }

  if grp_dataf then WRITE( f, hkl_nhkl:9 );
  WRITELN( f );

  if (hkl_htab = nil) or (hkl_nhkl <=0) then return;

  {            1234512341234123412341234123xxxx1234yy123.567890 }
  WRITE( f, '{  IH  IK  IL  NQ  IQ  MUL IS   NHKL     1/2d    ' );
  if hkl_wavel > 0.0 then WRITE( f, '2*theta':12:0 );   { Second parm as values -1/0/1 for left/centered/right }
  WRITELN( f, '(', hkl_nhkl:0, ' independante reflections are written) }' );

  ndv := grp_wrequ + 1;

  if (grp_wrequ = 0) and grp_nsort then
    for ii := 1 to hkl_nhkl do
      OUT_FULL_HKL( hkl_htab^[ii], 1, 1 )
  else
(*
  if (grp_qvnbr = 0) and ((grp_wrequ <> 0) or not grp_nsort) then
*)
    for ii := 1 to hkl_nhkl do
    begin
      id := hkl_itab^[ii];
      with hkl_htab^[id] do
      begin
        case grp_wrequ of
          0, { The equivalent reflections are grouped (with mul = 1) }
          1: { The equivalent reflections are grouped and the Friedel Pairs are removed (with mul = 2) }
            begin
              if ODD( grp_wrequ ) then mlt := 2
                                  else mlt := 1;
              if grp_dataf then WRITELN( f, ABS( hkl_mul ) (* div ndv *):6 )
                           else OUT_FULL_HKL( hkl_htab^[id], mlt, 1 );
              hklid := hkl_hmap^[hkl_id];
              while hklid > 0 do
              begin
                HKL_GET_HKL( hklid, hkl );
                WRITELN( f, hkl[1]:5, hkl[2]:4, hkl[3]:4, hkl[4]:4, hkl[5]:4, mlt:5, 0:3 );
                hklid := hkl_hmap^[hklid]
              end;
              if grp_dataf then OUT_FULL_HKL( hkl_htab^[id], mlt, 1 );
              WRITELN( f )
            end;

          2, { The equivalent reflections are removed }
          3: { The equivalent reflections and the Friedel Pairs are removed }
            begin
              if ODD( grp_wrequ ) then
                                    if hkl_mul < 0 then mlt := - hkl_mul
                                                   else mlt := 2*hkl_mul
                                  else mlt := hkl_mul;
              hkl_mul := 1;
              OUT_FULL_HKL( hkl_htab^[id], mlt, 1 )
            end;

        otherwise
        end
      end
    end;
  WRITELN( f )
end HKL_LIST_OUTPUT;



procedure NEW_HKL( hkl: hkl_rec );

var
  tmp: hkl_tbp;

begin
  hkl_nhkl := hkl_nhkl + 1;
  { Reallocate the HKL table when its current size is too small }
  if hkl_nhkl > hkl_htab^.size then
  begin
    NEW( tmp, hkl_htab^.size + hkl_tbisz );
    for i := 1 to hkl_htab^.size do  tmp^[i] := hkl_htab^[i];
    DISPOSE( hkl_htab );
    hkl_htab := tmp
  end;
  hkl_htab^[hkl_nhkl] := hkl
end NEW_HKL;



procedure HKL_BUILD_HMAP( hkln: hkl_rec );
var
  binfr:       boolean;
  id, jd, nn:  integer;
  tmp:        hkln_tab;

begin
  with hkln do                                  { When this reflection is a new one }
  if hkl_hmap^[hkl_id] = 0 then
  begin { Sorting in the equivalent table in id decreasing order }
    for ii := 1 to hkl_mul-1 do
      for jj := ii + 1 to hkl_mul do
        if hkl_etb[ii] < hkl_etb[jj] then
        begin { To sort, Exchange ofHKL-NQ map indicies }
          id := hkl_etb[ii]; hkl_etb[ii] := hkl_etb[jj]; hkl_etb[jj] := id
        end;

    hkl_id := hkl_etb[1];                       { Put at Equiv.head list the HKL if HKL-NQ index maximum }
    HKL_GET_HKL( hkl_id, hkl_hkl );
(*
WRITELN( ' For [', hkl_hkl[1]:4, ',', hkl_hkl[2]:4, ',', hkl_hkl[3]:4, ',', hkl_hkl[4]:5, ',',hkl_hkl[4]:3, ']  mul = ', hkl_mul:4 ); 
*)
    if ODD( grp_wrequ ) then                    { When the Friedel partner suppression is required }
    begin
      binfr := false;                           { No Friedel partner until shown otherwise }
      if (hkl_mul > 1) and (hkl_etb[1] > hkl_morg) then{ When it is possible to find Friedel Partner in the equiv. list }
      begin
        id := HKL_FRIEDEL( hkl_etb[1] );        { <id> is the Friedel partner map_id of the base reflection }
        nn := 2;
        while (nn <= hkl_mul) and (hkl_etb[nn] <> id) do nn := nn + 1;  { Loop to search it }
        if nn <= hkl_mul then binfr := true     { When found then flag it }
      end;

      nn := 0;
      for ii := 1 to hkl_mul do                 { Loop on all equivalent }
      begin
        id := hkl_etb[ii];                      { Get the map index }
        if binfr then                           { When the Friedel partners are in the equivalent list }
        begin
          if id < hkl_morg then                 { when the map indext is negative }
          begin
            if nn = 0 then nn := ii - 1;        { if it is the first negative map index, set the number of selected equivalent }
            hkl_hmap^[id] := -1                 { Set the map element to be -1 to ignore this HKL }
          end
        end
        else
          hkl_hmap^[HKL_FRIEDEL( id )] := -1    { When the Friedel partner was not found, set Friedel parterns to ignored }
      end;
      if binfr then hkl_mul := nn               { When the Friedel partner was found, reset the number of equivalent lines }
(*
;WRITELN( ' Number of HKL_NQ = ', hkl_mul:4 );
*)
    end
(*
else WRITELN
*)
;

    { Create the hmap links }
    id := hkl_id;
    jd := id;
    binfr := false;                             { Assume no friedel pair included (in the HKL set) until shown otherwise }
    for ii := 1 to hkl_mul do
    begin
(*
WRITELN( ' hklid : map[', id:0, '] = ', jd:0 );
*)
      jd := hkl_etb[ii]; hkl_hmap^[ABS( id )] := jd; id := jd;  { Make the equivalent list with negative value for the removed HKL }
      if ODD( grp_wrequ ) and not binfr then                    { For remove Fridel mode and not included in eqv list ...}
        hkl_hmap^[HKL_FRIEDEL( ABS( hkl_etb[ii] ) )] := -hkl_id { ... Flag it to remove from output }
    end;
    hkl_hmap^[ABS( jd )] := -1;                 { Put the End of List Link }

    NEW_HKL( hkln )
  end
end HKL_BUILD_HMAP;



function  Z_EQU_GEOF( var hkl: hkln_tab; hh, kk, ll: double ): boolean;
{ This function establish the equivalent hkl-nq table in the
  space-group G (when <gkf> = false, all nq are 0) or sub-space wave-vector
  space group G-K (when <gkf> = true, the reflection is a satellite).
  The <hkl_neq> Equivalent HKL-NQ map indicies are put in the array <hkl_etb>.
  When the reflection is not a satellite, this fonction check
  the for space group (G) exctinction and return FALSE when
  the reflection must be vanish.
  In all other case TRUE is returned (satellite or not vanish
  reflection).
}
const
  XTV = 1.0/SQRT( 2 );
  YTV = 1.0/SQRT( 3 );
  ZTV = 1.0/SQRT( 5 );
  DEPI = 2.0*pi;

var
  g_r, g_i, ph: double;
  thkl:       hkln_tab;
  idt:         integer;


  procedure ADD_EQUIV( hkl: hkln_tab );
  var
    ii, id: integer;

  begin
    id := HKL_INDEX( hkl );
    ii := 1;
    while (ii <= hkl_neq) and (id <> hkl_etb[ii]) do ii := ii + 1;
    if ii > hkl_neq then
    begin
      hkl_neq := hkl_neq + 1;
      hkl_etb[hkl_neq] := id
    end
  end ADD_EQUIV;



  procedure APPLY_OPE( op: operator; var hd, hr: hkln_tab; var ph: double; ig: integer );
  begin
    for i := 1 to 3 do                                  { Get The HKL-NQ Transformation by the Symmetry operator }
    begin
      hr[i] := hd[1]*op[1,i] +  hd[2]*op[2,i] +  hd[3]*op[3,i];
      if hd[4] <> 0 then hr[i] := hr[i] + grp_qvect[hd[5]].qw_gkt[ig,i];
    end;

    if hd[4] = 0 then                                   { When not satellite, compute the geometric term of the site }
      ph := depi*(hr[1]*XTV + hr[2]*YTV + hr[3]*ZTV + (hr[1]*op[1,4] + hr[2]*op[2,4] + hr[3]*op[3,4])/24.0);

    hr[4] := hd[4]; hr[5] := hd[5]                      { Set the resulting (nq,iq) reflection set }
  end APPLY_OPE;


begin { Z_EQU_GEOF }
  hkl_neq := 0;
  g_r := 0.0; g_i := 0.0;

  for ig := 1 to grp_nope do
    if (hkl[4] = 0) or hkl_gkftb[hkl[5],ig] then        { For satellite use only the G-K Group operators }
    begin
      APPLY_OPE( grp_oper[ig], hkl, thkl, ph, ig );     { Perform the HKL Transformation by the operator }
      ADD_EQUIV( thkl );                                { Add to the equivalence table when it is a new HKL }
      g_r := g_r + COS( ph ); g_i := g_i + SIN( ph )    { Summ the Geometri terms conribution of the structure factor }
    end;

  if hkl[4] = 0 then                                    { Compute a geometrical term (of the structure factor) ... }
  begin                                                 { ... only for a not satellite reflections ... }
                                                        { ... using irrational atom coordinates }
    Z_EQU_GEOF := (ABS( g_r ) <= EPS) and (ABS( g_i ) <= EPS)
  end
  else Z_EQU_GEOF := false
end Z_EQU_GEOF;



procedure HKL_PROCESS( ih, ik, il, iq, nq: integer );
var
  d2, hh, kk, ll:   double;
  hklnq:           hkl_rec;
  inz, hklid:      integer;

begin
  with hklnq do
  begin
    hh := ih; kk := ik; ll := il;               { Init the HKL Real values }
    if nq <> 0 then                             { When some Wave-vector (WV) are defined ... }
    with grp_qvect[iq] do
    begin
      hh := hh + nq*qw_vect[1];
      kk := kk + nq*qw_vect[2];
      ll := ll + nq*qw_vect[3]
    end;

    { We must ignore the null diffusion vector }
    if (iq = 0) and (ih = 0) and (ik = 0) and (il = 0) then return;

    { Check for sin(theta)/lambda (=1/2D) limit }
    d2 :=       grp_rmt[1,1]*SQR( hh ) + grp_rmt[2,2]*SQR( kk ) + grp_rmt[3,3]*SQR( ll ) +
          2.0*( grp_rmt[2,3]*kk*ll +     grp_rmt[3,1]*ll*hh +     grp_rmt[1,2]*hh*kk);
    if (d2 > hkl_d2m) or (d2 < hkl_d2min) then return; { Elliminate any reflection with (1/d)**2 out of range }

    if nq = 0 then                              { When the reflection is not a satellite }
      { Check for Systematic extinction }
      case grp_lattice of
        lat_A: if (ik + il) mod 2 <> 0 then return;
        lat_B: if (il + ih) mod 2 <> 0 then return;
        lat_C: if (ih + ik) mod 2 <> 0 then return;
        lat_F: if ((ih + ik) mod 2 <> 0) or ((il + ih) mod 2 <> 0) then return;
        lat_I: if (ih + ik + il) mod 2 <> 0 then return;
        lat_H: if (-ih + ik + il) mod 3 <> 0 then return;
      otherwise
      end;

    hkl_hkl[1] := ih;                           { Fill the HKL-NQ record table with ih, ik, il, nq and iq }
    hkl_hkl[2] := ik;
    hkl_hkl[3] := il;
    hkl_hkl[4] := nq;
    hkl_hkl[5] := iq;

(*
;WRITELN( ' To Process HKL ', hkl_hkl[1]:5, hkl_hkl[2]:4, hkl_hkl[3]:4, hkl_hkl[4]:6, hkl_hkl[5]:3, hkl_mul:6, hkl_us2d:12:6 );
*)

    if Z_EQU_GEOF( hkl_hkl, hh, kk, ll ) then return;   { Eliminate all Null reflection (Group Exctinction) }

(*
    HKL_GET_HKL( hkl_etb[1], hkl_hkl );         { Get the prefered First HKL indicies }
*)
    hkl_mul    :=  hkl_neq;                     { Set the default value for multiplicity }
    hkl_id     :=  hkl_etb[1];                  { Set the HKL-NQ map identifier }
    hkl_us2d   := 0.5*SQRT( d2 )                { Put the 1/2d (= sin(theta)/lambda) value in the HKL record }

(*
;WRITELN( ' Process id = ', hkl_id:12, ' -> HKL ', hkl_hkl[1]:5, hkl_hkl[2]:4, hkl_hkl[3]:4, hkl_hkl[4]:6, hkl_hkl[5]:3, hkl_mul:6, hkl_us2d:12:6 );
*)

  end;

  if (grp_wrequ <> 0) or not grp_nsort then HKL_BUILD_HMAP( hklnq )
                                       else NEW_HKL( hklnq )

end HKL_PROCESS;



procedure GENERATE_HKL_LIST( var f: text );
{ Procedure to generate a list of HKL.
}
var
  hinc, hma, hmi, kinc, ih, ik, il,
  kma, kmi, lma, lmi:                  integer;
  qnz, nqnz:                           boolean;

begin { GENERATE_HKL_LIST }
  if grp_cell then
  begin { A unit cell must be defined }
    hkl_morg   :=    1;                         { Set the initial HKl-NQ map index offset }
    hkl_mdim   :=    1;                         { Set the initial HKl-NQ map element size (in integer size) }

    if grp_qvnbr > 0 then HKL_NQ_LIMIT;         { Set minimum and maximum for NQ of each defined Wave Vector }

    hma := grp_hklmax[1]; hmi := - hma;         { Set the minimum and maximum for each HKL index }
    kma := grp_hklmax[2]; kmi := - kma;
    lma := grp_hklmax[3]; lmi := - lma;

    { Compute the HKL-NQ MAP sizes }

    hkl_nh := 2*hma + 1;                        { Set the minimum and maximum for H, K, L. }
    hkl_nk := 2*kma + 1;
    hkl_nl := 2*lma + 1;

    hkl_elh  := hkl_mdim;                       { Set the map element size for the H index }
    hkl_morg := hkl_morg - hmi*hkl_mdim;        { Update the hkl_org and hkl_nhkl values for the H index }
    hkl_mdim := hkl_nh*hkl_mdim;

    hkl_elk  := hkl_mdim;                       { Set the map element size for the K index }
    hkl_morg := hkl_morg - kmi*hkl_mdim;        { Update the hkl_org and hkl_nhkl values for the K index }
    hkl_mdim := hkl_nk*hkl_mdim;

    hkl_ell  := hkl_mdim;                       { Set the map element size for the L index }
    hkl_morg := hkl_morg - lmi*hkl_mdim;        { Update the hkl_org and hkl_nhkl values for the L index }
    hkl_mdim := hkl_nl*hkl_mdim;

(*
WRITELN;
WRITELN( ' Map Size = ', hkl_mdim:0 );
WRITELN( ' Map Org  = ', hkl_morg:0 );
WRITELN( ' Map elh  = ',  hkl_elh:0 );
WRITELN( ' Map elk  = ',  hkl_elk:0 );
WRITELN( ' Map ell  = ',  hkl_ell:0 );
WRITELN;
*)

    hkl_nhkl   :=    0;                         { Initialize the total number of HKL-NQ reflections }

    for iq := 1 to grp_qvnbr do                 { Loop to compute the index shift for Fridel partner when qw is rational }
      with grp_qvect[iq] do                     { This shift is used to avoid to have H-nq*qw and H+(nf-nq)*qw ... }
        if qw_rflg then                         { ... the same reflection }
          qw_msup := qw_nfqv[1]*hkl_elh + qw_nfqv[2]*hkl_elk + qw_nfqv[3]*hkl_ell;

    if (grp_wrequ <> 0) or not grp_nsort then   { Allocate the HKL-NQ map execpt when no sorting and no EQUV managment }
    begin
      NEW( hkl_hmap, hkl_mdim );
      for ii := 1 to hkl_mdim do hkl_hmap^[ii] := 0
    end;

    if hkl_wavel > 0.0 then                     { When a wave length is specified }
    begin
      if hkl_thmax > 0 then                     { If a 2*theta max is specified ... }
        grp_us2dm := SIN( (0.5*inrd)*hkl_thmax )/hkl_wavel     { ... we deduce the (1/2)**2 limit from the specified angle ... }
      else
        if grp_us2dm*hkl_wavel > 1.0 then       { ... else, when the 1/2d limit is too high we apply  ... }
          grp_us2dm := 1.0/hkl_wavel;           { ... the limit deduced from the condition sin( theta ) < 1.0. }
      if hkl_thmin > 0.0 then                   { For a low theta limit, we compute the equiv. low limit of (1/d)**2 }
        hkl_d2min := SQR( 2.0*SIN( (0.5*inrd)*hkl_thmin )/hkl_wavel )
    end;

    hkl_d2m := SQR( 2.0*grp_us2dm );            { Get the required maximum of (1/d)**2 for rejection optimization }

    NEW( hkl_htab, hkl_tbisz );                 { Allocate and Initialize the HKL Working Space for equivalent management}

    if not grp_dataf then
    begin
      WRITELN( f );
      WRITE( f, ' HKL List generation with 1/2d max = ', grp_us2dm:8:4, ', ' );
      if grp_nsort then WRITE( f, 'Output will not be sorted, ' );
      WRITE( f, 'The EQUV Code is ', grp_wrequ:0, ' => ' );
      case grp_wrequ of
        0: WRITE( f, 'Group equivalent reflection lines' );
        1: WRITE( f, 'Group equivalent reflection lines and suppress the Friedel Pairs' );
        2: WRITE( f, 'Suppress equivalent reflection lines' );
        4: WRITE( f, 'Suppress equivalent reflection lines and suppress the Friedel Pairs' );
      otherwise
      end;
      WRITELN( f, '.' );

      if grp_qvnbr > 0 then
      begin
        WRITE( f, ' The following wave vector' );
        if grp_qvnbr > 1 then WRITE( f, 's are' )
                         else WRITE( f, ' is' );
        WRITE( f, ' used : ' );
        for ii := 1 to grp_qvnbr do
          with grp_qvect[ii] do
          begin
            WRITE( f, '( ', qw_vect[1]:6:4, ', ', qw_vect[2]:6:4, ', ', qw_vect[3]:6:4, ')' );
            if ii < grp_qvnbr then WRITE( f, ',' )
          end;
        WRITELN( f, '.' )
      end
      else WRITELN( ' No wave vectors was specified.' );
      WRITELN( f );

      if hkl_wavel > 0.0 then
        WRITELN( f, ' The 2*theta angles are computed with a wave length of ', hkl_wavel:8:5, ' Angstroem.' );

      OUT_VALUE( d_aa ); OUT_VALUE( d_bb ); OUT_VALUE( d_cc );
      OUT_VALUE( d_al ); OUT_VALUE( d_be ); OUT_VALUE( d_ga );
      FORMATTED_OUTPUT( f, daucf );
      OUT_VALUE( r_aa ); OUT_VALUE( r_bb ); OUT_VALUE( r_cc );
      OUT_VALUE( r_al ); OUT_VALUE( r_be ); OUT_VALUE( r_ga );
      FORMATTED_OUTPUT( f, raucf );
      WRITELN( f )
    end
    else
    begin
      OUT_VALUE( d_aa ); OUT_VALUE( d_bb ); OUT_VALUE( d_cc ); { Output Direct unit cell parameters }
      OUT_VALUE( d_al ); OUT_VALUE( d_be ); OUT_VALUE( d_ga );
      FORMATTED_OUTPUT( f, aucef );
      OUT_VALUE( r_aa ); OUT_VALUE( r_bb ); OUT_VALUE( r_cc ); { Output Reciprocal unit cell parameters }
      OUT_VALUE( r_al ); OUT_VALUE( r_be ); OUT_VALUE( r_ga );
      FORMATTED_OUTPUT( f, aucef );            { Output Direct xyz to work space transformation Matrix }
      for i := 1 to 3 do
        for j := 1 to 3 do
          OUT_VALUE( grp_tmd[i,j] );
      FORMATTED_OUTPUT( f, rmatdf );           { Output Reciprocal xyz to work space transformation Matrix }
      for i := 1 to 3 do
        for j := 1 to 3 do
          OUT_VALUE( grp_tmr[i,j] );
      FORMATTED_OUTPUT( f, rmatdf );
      for i := 1 to 3 do                       { Output Direct Metric tensor }
        for j := i to 3 do
          OUT_VALUE( grp_dmt[i,j] );
      FORMATTED_OUTPUT( f, aucef );
      for i := 1 to 3 do                       { Output Reciprocal Metric tensor }
        for j := i to 3 do
          OUT_VALUE( grp_rmt[i,j] );
      FORMATTED_OUTPUT( f, aucef )
    end;

    { Generate the Base HKL List }
    il := lma; ik := kma; ih := hma;            { Initialize the H,K,L indicies at there maximums ... }
    kinc := -1; hinc := -1;                     { ... and the H and K increments at -1 }
    for il := lma downto lmi do                 { * L loop in decreasing order to force ... }
    begin                                       { ... the first HKl of each equivalent list to be with L Max }
      repeat                                    { * K loop in ZigZag mode }
        repeat                                  { * H Loop in ZigZag mode }
          if grp_qvnbr > 0 then                 { When some Wave vector(s) are defined }
          begin
            qnz := true;                        { Set no zero NQ processed flag }
            for iq := 1 to grp_qvnbr do         { Loop on all defined wave vector }
              with grp_qvect[iq] do
                for nq := qw_nqmi to qw_nqma do { Loop on NQ }
                  if nq <> 0 then
                    HKL_PROCESS( ih, ik, il, iq, nq )
                  else
                    if qnz then
                    begin { Do not repeat nq = 0 with each wave vector }
                      HKL_PROCESS(  ih, ik, il, 0, 0  );
                      qnz := false
                    end
          end
          else HKL_PROCESS( ih, ik, il, 0, 0 ); { Process the current HKL }
          ih := ih + hinc                       { Pass to the next H index }
        until (ih > hma) or (ih < hmi);         { Loop on H values - stop when H reach the H range limits }
        hinc := - hinc;                         { Reverse the H change }
        ih := ih + hinc;                        { Pass to the H of the next K index }
        ik := ik + kinc;                        { Pass to the next K index }
      until (ik > kma) or (ik < kmi);           { Loop on K values - stop when K reach the K range limits }
      kinc := - kinc;                           { Reverse the K change }
      ik := ik + kinc                           { Pass to the next K  of the next L index }
    end;

    NEW( hkl_itab, hkl_nhkl );                  { Allocate and init the HKL record Index Table }
    for ii := 1 to hkl_nhkl do hkl_itab^[ii] := ii;

    { When a sorting is required do it }
    if not grp_nsort then  HKL_US2D_SORT;       { When the HKL sort is required do it }

    HKL_LIST_OUTPUT( f );                       { Output the resulting HKL list }

    hkl_nhkl := 0;                              { Free all heap memory allocations }
    hkl_mdim := 0;
    DISPOSE( hkl_iqtb );
    DISPOSE( hkl_idtb );
    DISPOSE( hkl_itab ); hkl_itab := nil;
    DISPOSE( hkl_htab ); hkl_htab := nil;
    if hkl_hmap <> nil then
    begin  DISPOSE( hkl_hmap ); hkl_hmap := nil  end
  end
end GENERATE_HKL_LIST;
