%pragma trace 1;
{
                *  M  X  D  *  S Y S T E M

        D A T A   C O M P I L E R   P R O G R A M


	BY :
	    P. WOLFERS
		C.N.R.S.
		LABORATOIRE DE CRISTALLOGRAPHIE
		B.P.  166 X   38042  GRENOBLE CEDEX
					FRANCE.

}
{  VERSION 3.9-F     OF  M-X-D  SYSTEM  }
{*********  CPAS VERSION **********}


{

PW3_001-	The CENTER and DEBYE_MD statement can be take the new form :

			CENTER <logical>; or DEBYE_MD <logical>;

		A logical value true (number >= 0.5) give is equivalent to
		the simplified form :

			CENTER; or DEBYE_MD;

		A logical value false (number < 0.5) negate a previous
		CENTER or DEBYE_MD statement.

PW3_002/PW3_003/PW3_004
		Give the full support of dynamic weight (new disposition
		of the MXD V3.1 version).

	
PW3_002-	New form of the external data statement :

		DATA(<data-name>) = <scale>,[<$fn2_c>],[<$fm2_c>],[<dwec>];

		This form use the data informations stored in the
		Data DIrectory file (DDI) created on the exit time of MXDCMP.
		<scale> is the data collection scale factor,
		<$fn2_c> is the $fn2 nuclear extinction coefficient,
		<$fm2_c> is the $fm2 magnetic extinction coefficient,
		and
		<dwec> is the dynamic weight coefficient expression.


PW3_003-	A new form of the data definition statement is allowed :

		DATA(<data_name>,
			(<scale>[,<$fn2_c>[,<$fm2_c>[,<dwec>]]]),...) ... ;

		where $fn2_c and $fm2_c are the correction coefficient
		expressions for $FN2 and $FM2 respectively and dwec is the
		dynamic weight coefficient.


PW3_004-	The new statements CONTRIBUTION is defined :

		CONTRIBUTION(<identifier>) = <atome1>,<atome2>,...;

		The use of this statement allows the user to define
		the specified Cidentifier as a part of the predefined
		identifier $CALC (but without any derivate).
		<identifier> is the part of $calc due to the atoms
		in the list. More one CONTRIBUTION instruction can be
		used with the same identifier to complet the atome list.
		This new statement used with the <dwec> data parameter
		enable the user to work with the dynamic weight
		coefficient scheme.
		

PW3_005-	The new statement CLRDATA; can be used to clear any
		previously existing data collection definition in the
		data directory file. This statement must be used before
		any DATA statement.


PW3_006-	The statement OPTION can transmit 8 real values to the
		application program as with :

		OPTION(<option_number>) = <v1>[,<v2> ... <v8>];


PW3_007-	The old option P is changed to D (as DATA OUTPUT)
		in the statements PRAGMA, INCLUDE and CHAINE.
		The new option P is used to select the parameter
		expanssion output for aid in macro debugging.

PW3_008-	Now the used CPU time is given at the and of the run.


PW3_009-	The FFASSIGN statement has a new form :

		FFASSIGN <ffident1>[:n1] [,<ffident2>[:n2] ...] ;

		Where :
			<ffident1> .. <ffidentn> are array parameter ident.,
			n1 .. nn are integer expressions to specify an
			allocated address in referenced array parameter table.
			If n is positive, the allocated address is n with
			 1 <= n <= NMAX (12 for VAX/VMS MXD).
			If n is negative, the allocated address is
			 NMAX + 1 + n with -NMAX <= n <= -1.
			This negative value enables the users to specify an
			address in the top table area without knowing the real
			value of NMAX (convenient for any MXD implementation).
			If n = 0 or if n is not specified the dynamic
			allocation takes place: n takes the minimum first free
			value.

PW3_010-	The new special functions DEFINED(<obj>) and PARAMREF(<vpar>)
		are now implemented.

		DEFINED gives the following results :

			-1 if <obj> is an existing macro formal identifier
				    without actual definition.

			0  if <obj> is undefined.

			1  if <obj> is a declared identifier.

			2  if <obj> is a numerical constant.

			3  if <obj> is a string constant.

			4  if <obj> is a legal operator.

		PARAMREF gives the internal sequence number of a previously
		declared variable parameter or 0 in all other cases.
		  PARAMREF enables the users to specify a variable parameter
		reference to an application program :

		example :

			PARAM E$Y = <expression with reference of $SITHSL>;

			OPTION(LSTPAR) = PARAMREF(E$Y);

			Invokes the listing parameter option of MXDLSQ to write
		the value of E$Y in a column of the LISTREF output.


PW3_011-	The PARAM and VARIABLE statements are modified to enable the
		users to define global symbol in local block(BEGIN ... END).

		The new syntaxes are as below :

		PARAM  [l1] <ide1> = <expr1> [, [l2] <ide2> = <expr2> ... ] ;

		where <ide#> = <expr#> is a legal definition of the normal
		PARAM statement and l# is the lex-level specification

			l#=0	=>	global scope = more outer block.

			l#>0	=>      block scope is current - l#.


PW3_012-	The DATA statement is upgraded to support the external
		additive information (as absorbtion prog. by example).
		For this purpose the statement FFASSIGN is extend to
		support an undeclared identifier in the lex-level.
		  In this case FFASSIGN creats this identifier as a FIELD
		identifier before to allocate an form factor index.

		  After this declaration, the data statement can be use
		the existing FIELD identifier as a normal pre-defined
		identifier.

PW3_013-	The old standard functions ATOMPAR, MOMEPAR and DISPPAR
		are now undefined and are replaced by the new function
		ITEMPAR used with the parameters :

			ITEMPAR(<intspc_c>,<item_name>)

		where :

			<intspc_c> denots an integer constante with the
			allowed values  n * 100 + m as this:

		n give the type of item
			0 = ATOM, 1 = MOMENT, 2 = MDSDSP, 3 = NPOLADIR,
			4 = DATA, 5 = WAVEVECT and 6 = LSKBLOCK.

		m give the item parameter index.


PW3_014-	A new form of ATAN function is now implemented
		to get the phase of a complex number :

			PHASE := ATAN(IPART,RPART);

		The phase is in degrees.

PW3_015-	The new ASSIGNATION operator := is now defined to use
		in place of equal operator.


PW3_016-	The select function can be used with 32 parameters.


PW3_017-	User Defined function support (3.2 version) is
		implemented as this :

		FUNCTION <name> [(<idp1> [,<idp2>] [ ... ])] = <expression> ;

		Where the <idpi> are a formal parameter definitions :
			<idpi> is the identifier name of a scalar expression,
		or	<idpi> as the next form (for formal function):
			FUNCTION <fname> [ (<jdp1> [,<jdp2>] [ ... ])]
			The <jdpi> are the formal parameter of the
			formal function parameter.
			<fname> is the name of formal user function.
		<name> is the name of the new user function.


PW3_018-	The new standart function SUMM is now defined as :

		SUMM(<index>,<begin>,<end>[,<step>],<expr>)

		The result is given by :

			SUMM := 0; <index> := <begin>;
			while ((<step> > 0) and (<index> <= <end>))
			or    ((<step> < 0) and (<index> >= <end>)) do
			begin
				SUMM := SUMM + <expr>;
				<index> := <index> + <step> 
			end


		The <index> identifier denots an real value and its scope
		is reduced to the <expr> expression.
		The default <step> value is 1, the given expression value
		of <begin>, <end>, and <step> are rounded to
		the nearest integer value.


PW3_019-	The statement LIMITS has an alternate form as:

		LIMITS [<inf>], [<sup>], <v0> [,<v1>] [,<v2>] ... ;

		This new form of the LIMITS statement  set the
		specified limits <inf> and <sup> for all given
		variables <v0>, <v1>, etc...


PW3_020-	The full 3.2 extension are also add :
		The standart statement can be have a non constant parameter :

		ABS(<y>) The derivate is :	y = 0 =>  0
						y > 0 =>  y'
						y < 0 => -y'.

		The next compare operator can be applied to no constant
		parameters :

		=,  <,  >, <=, >=, <>.

PW3_021-	Add the support of space group generation with
		the new statement GENSPACE  used as this :

			GENSPACE ;

		Tell to MXDCMP to generate the entire space group from
		given generator SYMTRY operator.


PW3_022-	Add the rational wave vector support.


PW3_023-	The predefined variable parameters $SH, $SK, $SL are now
		defined as equivalent of $HH, $KK, $LL but, with
		symtry dependance.

PW3_024-	The $CHI2, $LCHI2, $FMAX, $LFMAX Chi squared and
		maximal agreement factor for the current and last
		cycle are now defined.

PW3_025-	The macrolib statement is now modified manage a dynamic
		heap of the macrolibrary filename.
		the new statement for as
			MACROLIB ;
		suppress the last library from the heap.
		the MACROCALL statement look for asked macro in all
		libraries. the first macro libary used is the last given.

PW3_026-	The new predefined symbol $NPOLA give a macro access to
		the current polarization state.

PW3_027-	The statement NPOLADIR has 2 new optional parameters
		that are the polarization efficient coefficient for
		the + and - state. this two coefficients are used by
		MXDLSQ in the flipping ratio computing ("+/-").

PW3_028-	The new symbols $FNR, $FNI, $FMXR, $FMYR, $FMZR,
		$FMXI, $FMYI, $FMZI are add to enable the user to get
		the value of the real and imaginary part of the structures
		factors. These symbols are not virtual variables and can't
		give any derivate term in the parameter that use it.


PW3_029-	Change the user file support by:
		Change REPLAY statement to REPLY and extend it to many
		parameters (separated by comma);
		Suppress all the openfile and true MXD least-squares
		statement restrictions.
		Add the support for read operation and test of open/read
		success by the $STATUS identifier.
		The new PRAGMA N+ (default to N-) enable the Not exist
		file error (For OPENFILE, CHAINE and INCLUDE).
		if N- is set, then $STATUS <> 0 flags an openfile error.
                $STATUS = -1 flag an end of file reached on a read
                operation.

		The new statement forms are :

		OPENFILE  [ :<lun> ] filespc [ , <mode> ] ;
		CLOSEFILE [ : <lun> ];
		WRITE     [: <lun> ]  ... ; /* write without end of line */
		WRITELN   [: <lun> ]  ... ; /* finish the write by a end of
						line */
		READ      [: <lun> ]  ... ;

		<lun> must be in the range 1..4, the default value is 1.
		<lun> is the channel number.

		<mode> is used to specify the use as below :

			'Read'   to open a file in readonly mode.
			'Write'  to open a file for write on a NEW
                                                    or existing file.
			'New'    to create and open a new file for write.
			'Append' to append at an existing file,
				   if it is not existing it is created.

		The default value is 'Write' to emulate the old functionality.


PW3_030-	Change source by use of module MXDRTL for portability.



PW3_031-        Marquard/Landquark/Levenberg factor implementation.


PW3_033-        From version 3.8 the symbol limit length is 16 characters.


PW3_034-        From version 3.9, to complete fit with UNIX system the
                new symbols $P00, $P01, ... $P16 are now defined as the
                strings of system parameters.
                In addition :

                     A the new function SYS_GETENV has been added as this :
                  SYS_GETENV( <logid_str> ) give the translation of the
                    logical symbol named logid_str (the result is a string).

                     The new statement LISTING [ <filespecification_str> ]
                  is implemented to set a new listing file specification.

                     The new statement RUN_MXD_APPL <exec_file_spc_str> can
                  be used to call the specified MXD APPLICATION PROGRAM.

PW3_035-        From version 3.9, the TITLE and SAVE statement are removed
                and replaced by the nes statement SOPTION as this :

                  SOPTION( <id#> ) = <string>;

                with the rule: # 0 is the old TITLE statement equivalence,
                               # 1 is used for the save specification,
                               #-1 is used for the listing specification,
                               #-2 can used for a run linking specification
                                   if implemented.


PW3_036-        From version 3.9,
                The new folloowing functions are now defined :

                  BESSEL_J( n, x ) -> Return the first kind Bessel function Jn.


PW3_037-        From version 3.9,2
                The inexact work space definition for Rhomoedral reference choice
                was bad. This problem is now solved.

}

{ [inherit('MXDRTL')] (** OPEN-VMS **) }
program MXD_CMP( input, output ); { input and output for user terminal }


%include 'mxdsrc:mxd_rtl_env';   { Include the MXD environment definitions }



  {**************************************************}
  {*******          Const Declarations         ******}
  {**************************************************}


label MXD_STOP; { For fatal error }


const

  { listing page heading and promt message string }
  title = ' M X D C M P  - P.Wolfers Software: MXD V3.9-E of 01-JUL-98 ';
  prompt = ' MXD>';


  { system dependant strings }

  {  file specification and its length }

  terminal   = 'TT:';                   { user terminal }
  defcmd     = 'MXDLIB:mxd_env.std';    { initial command file }
  defmlib    = 'MXDLIB:mxdlib.mxl';     { default macro library }
  errspcfile = 'MXDLIB:mxd_cmp.err';    { error message spc. file }
  ddispcfile = 'mxdddi.bdd.1';          { data dir. specification file }

  { constant parameters }

  maxstksymbsize = 32;  { maximum size of symbol stack }
  maxerrcnt      = 32;  { maximum allowed error count }

  diftabln       = 50;  { maximum length of a form table }



  {**************************************************}
  {*******          Type Declarations          ******}
  {**************************************************}



type

  { character attribute definitions }
  chcat = (
         alpha,     digit,    period,     comma,   semicol,     colon,
          addo,      subo,      mulo,      divo,      powo,      quot,
          lpar,      rpar,      equo,       oth,      eofo,     eolno,
       spacech,      clto,      cgto,      ando,      ioro,      lbra,
          rbra
  );

  { item attribute definitions }
  symbol = (
         ident,     ctstr,     ctint,    ctreal, separator,
      operator,    eolnsy,     eofsy,   nothing
  );

  { identifier attribute type definitions }
  idtype = (
      undefine, undefine1, parmacref,  macroref,   keyword,    operty,
       bltfunc,   stdfunc,    stdpar,   uscontr,   paramty,     varty,
      arrctety, dtfieldty,   contrty,  formalty,functionty,   indexty,
       bltfmac
  );

  { expression attribute definitions }
  expattr = (    nullattr,  strkonst,  numkonst, varblattr,  exprattr );

  { pointer of identifier record definition }
  ptr = ^ide;		{ pointer of an identifier definition }

  { standart operator definitions }

  { this order define the polish code for the supported mxdlsq prg. }
  { take care to modify }

  ndtyp = (
    { reference node definitions }
         refer,   ctarray,     param,     varbl, { 00..03 }
       contrrf,    indxrf,   functrf,  formalrf, { 04..07 }
       arrayrf,      no09,      no10,      no11, { 08..11 }
          no12,      no13,      no14,      no15, { 12..15 }

    { operator and scalar constante node definitions }
         konst,     addop,     subop,     mulop, { 16..19 }
         divop,     negop,     powop,     ipwop, { 20..23 }
         sinop,     cosop,     tanop,    asinop, { 24..27 }
        acosop,    atanop,     expop,     logop, { 28..31 }
         sqrto,     tanho,   phaseop,     absop, { 32..35 }
       bess1op,      no37,      no38,      no39, { 36..39 }
	summop,  selectop,  intselop,  sumhklop, { 40..43 }
          no44,      no45,      no46,      no47, { 44..47 }
         modop,     intop,     equop,     neqop, { 48..51 }
         cltop,     cleop,     cgeop,     cgtop, { 52..55 }

    { special operators }
    formalcall, functcall,      no58,      no59, { 56..59 }
          no60,      no61,      no62, connectop, { 60..63 }

    { all other p code statements are below }
        cellsy,   catomsy,    atomsy,  momentsy, { 64..67 }
      mdsdspsy,   wavevsy,npoladirsy,  symtrysy, { 68..71 }
     optionssy, soptionsy,    nullsy,            { 72..74 }
       varbldf,    parmdf,                       { 75..76 }
        datasy,      no78,lsqblocksy,centeronsy, { 77..80 }
   assignvarsy,    bisomd,   fixedsy, unfixedsy, { 81..84 }
     latticesy,  limitssy,magneticsy,            { 85..87 }
     uctrdefsy,  formaldf, usfunctdf,    indxdf, { 88..91 }
          no92,   arraydf,      no94,      no95, { 92..95 }
          no96,      no97,      no98,      no99, { 96..99 }

    { pseudo instructions follow }
     includesy,   chainsy,    eofsym,  pragmasy,
       rcellsy,ffassignsy, clrdatasy,macrolibsy,
       mcallsy,genspacesy,  repeatsy,      ifsy,
       macrosy,   beginsy,    thensy,   untilsy,
       endifsy,  endmacsy,     endsy,    elsesy,
       purgesy, illegalsy,   errorsy,  wrtmsgsy,
     displaysy,   replysy,    opensy,   closesy,
       writesy, writelnsy,    readsy,

    { Run control statements }
     runapplsy, listingsy,   spawnsy,

    { constant operators }
      assignop,     andop,     iorop,     notop,
        concop,  interpop,  substrop,  lengthop,   indexop,  nindexop,
      stringop,  numberop, definedop,paramrefop,  getenvop,

    { separator definitions }
       colonsy,   commasy,    lparsy,    rparsy,     brasy,     ketsy,
       smcolsy,

    { parameter definitions }
          parh,      park,      parl,     parrh,     parrk,     parrl,
       parstsl,
         parhx,     parhy,     parhz,     parqx,     parqy,     parqz,
         parhh,     parkk,     parll,
        parobs,    parsig,   parweig,   parcalc,
        parfn2,    parfm2,  paripola,   parpola,
         parsh,     parsk,     parsl,
      parlchi2,  parcchi2,  parlmaxf,  parcmaxf,
        parfnr,    parfni,
        parfxr,    parfyr,    parfzr,    parfxi,    parfyi,    parfzi,

    { last definition }
	ndtend
  );

  { item record definition }

  item = record
    ndtwd : ndtyp; { associated operator if known }
    case sy:symbol of { type of item }
      ident:
        ( namid: nameid;
          ptid:  ptr
        );
      ctstr:( valst: stp);
      ctint, ctreal:
        (ival, rval: real);
      separator:
        (separ: chcat);
      operator:
        (opera: chcat)
  end;



              { general decoding definition }

  { array parameter table pointer definition }
  ditbpt = ^diftab;

  { identifier record definition }
  ide = record
    lexlev: integer;            { lexlevel definition }
    sequnb: integer;            { sequence number }
    name: nameid;               { identifier name }
    leftp, rightp: ptr;         { right and left link of identifier tree }
    case idtyp: idtype of       { ident selector }
      functionty: (
          forlst,               { function formal list header }
          nxtfor: ptr           { next formal if formal function }
        );
      macroref: (
          parlst: ptr;          { macro parameter list header }
          macpt: stp            { macro text pointer }
		);
      formalty, parmacref, undefine, undefine1: (
          actual: stp;          { pointer of actual symbol }
          nxtpar: ptr           { link to next parameter }
        );
      operty, keyword, bltfunc, stdfunc, stdpar: (
          nodty: ndtyp
        );
      arrctety, dtfieldty: (
          idex: -1..diftabln;   { form factor table index }
          usedflag: boolean;    { flag for array used in p code }
          case boolean of
	    true: ( pttab: ditbpt);{ -> form factor table }
	    false:(pvalue: ptr   ) { -> data column }
          );
      paramty: (
          case parattr: expattr of
            strkonst:                (  stpt: stp);
            numkonst:                ( value: real)
        );
      contrty, varty, indexty: (
          iii: integer
        );
  end;

	{ expression parsing item }

  { expression item cluster definition }
  itemobj = record
    prior, spcl: char;          { priority of ietm for expression }
    ndt: ndtyp;                 { nature of item }
    case eattr: expattr of      { attribut of item, use as selector }
      strkonst:( pstr: stp);    { pointer for string constante }
      numkonst:( ivl,rvl: real);{ value integer/real for numeric constante }
      varblattr:(pvb: ptr)      { variable pointer }
  end;

  { variation mode for input macro procedure - inmacro }

  inmacmode = ( untilmd, endifmd, elsemd, endmacmd, endblkmd );


  { source file managment definitions }

  cmdmode = ( f_close, f_ior, f_iow, f_data, f_macr, f_mcparm, f_maclib );

  filecntx = record
    fil_prt,                    { Related prompt text file, fil_tty is true }
    fil_ptr:   text;            { The text file }
    fil_mod:   cmdmode;         { Mod of text file use }
    fil_tty:   boolean          { Flag for user terminal }
  end;


  context = record
    macptr: ptr;                { to keep a pointer of active macro }
    spclvl,                     { top of l+ validation }
    stklvl: integer;            { integer level of stack }
    filespecif,                 { system file specification }
    cmdline: stp;               { cmd. line }
    linenbr,                    { internal line number }
    frspos, lstpos,             { first and last used position in input stream }
    lsteff,                     { last effective char order }
    cmdptr: integer;            { current read pos. in it. cmd. line }
    chv,                        { to store a virtual character }
    chs, cmajs: char;           { to save the current character ch }
    categs: chcat;              { to save the current char. attribute }
    binsert,                    { to indicate a validation of chv }
    bouterr, beof,    beoln,    { option flags }
    blist,   bmaclst, bparlst,
    becho,   bphys: boolean
  end;


  cntx_ptr = ^cntx_rec;         { Pointer of file context }

  cntx_rec = record
    prvcntx: cntx_ptr;          { pointer to the previous context }
    ccnt:    context;           { Current context }
    fcnt:    filecntx           { File context }
  end;


  { physical item associated data }
  diftab = record
    next: ditbpt;               { link to next table }
    org, stp: real;             { origine and step of the table }
    lentab: 0..diftabln;        { length of the table }
    tabl: array[0..diftabln-1] of real  { table allocation }
  end;


  { wave vector definitions }
  wavedef = record
    qx, qy, qz,                 { componantes in reciprocal unit cell }
    vx, vy, vz: real;           { componantes in the working space }
  end;

  { symtry operator matrix }
  opmatrix = array[1..3,1..4] of integer;

  { crystallographic <-> working space passage matrix definition }
  trmatrix = array[1..3,1..3] of real;

  { physical item type definitions }
  physitmty = (
       wavespc,   atomspc,   momespc,   dispspc,
      npolaspc,   dataspc,    symspc,    blkspc
  );

  physptr = ^physitm;

  { physical item record definition }
  physitm = record
    next: physptr;              { link to next physical item of the same type }
    name: nameid;               { name of the physical item }
    sequ: integer;              { sequence number }
      case physitmty of
        atomspc,  momespc,
        dispspc, npolaspc: ( iii:boolean ); {unused}
        symspc: (
            matope: opmatrix;   { matrix rotation }
          );
        blkspc: (dumpf: real);
	dataspc:(
            dtf: datadef;
            used: boolean       { data item information }
          );
        wavespc:( wav: wavedef) { wave vector information }
  end;

  { state for read/write file }

  io_usety = (io_free, io_read, io_write);


{*************************************************}
{***            Variable Declarations          ***}
{*************************************************}


var

  { statistic of cpu time variable }

  initcpu: integer;     { initial c.p.u. time }


  { character attribute array }

  attchr: array[' '..'_'] of chcat := (
     spacech,     ioro,    alpha,    alpha,  { ' ', '!', '"', '#' } 
       alpha,    alpha,     ando,     quot,  { '$', '%', '&', ''''}
        lpar,     rpar,     mulo,     addo,  { '(', ')', '*', '+' }
       comma,     subo,   period,     divo,  { ',', '-', '.', '/' }
       digit,    digit,    digit,    digit,  { '0', '1', '2', '3' }
       digit,    digit,    digit,    digit,  { '4', '5', '6', '7' }
       digit,    digit,    colon,  semicol,  { '8', '9', ':', ';' }
        clto,     equo,     cgto,      oth,  { '<', '=', '>', '?' }
       alpha,    alpha,    alpha,    alpha,  { '@', 'A', 'B', 'C' }
       alpha,    alpha,    alpha,    alpha,  { 'D', 'E', 'F', 'G' }
       alpha,    alpha,    alpha,    alpha,  { 'H', 'I', 'J', 'K' }
       alpha,    alpha,    alpha,    alpha,  { 'L', 'M', 'N', 'O' }
       alpha,    alpha,    alpha,    alpha,  { 'P', 'Q', 'R', 'S' }
       alpha,    alpha,    alpha,    alpha,  { 'T', 'U', 'V', 'W' }
       alpha,    alpha,    alpha,     lbra,  { 'X', 'Y', 'Z', '[' }
         oth,     rbra,     powo,    alpha   { '\', ']', '^', '_' }
  );

  { input stream managment definitions }

  bnewdata,             { set to true if some new data are defined or modified }
  bolddata,             { false to flag the clear ddi file }
  bgenspace,            { flag the group space generation }
  bcentric,             { flag the centered mode for genspace }
  binstring,            { flag an instring mode to invalidate comment flags }
  bnostrg,              { set the none create constant string if true }
  bdefpar,              { set by insymbol to flag an undefined macro par. }
  bincerr,              { set if include/chaine not exist file enable }
  boutmac,              { create a macro text flag }
  blstmcall,            { listing flag for MCALL }
  bspace,               { macro/param space put flag }
  bline,                { indicate a line by line read process }
  bexit: boolean := false;       { indicate an exit instruction }

  ch, cmaj, clst: char; { current and last input character }

  categ: chcat;         { current character attribut }

  maclstpt: integer;    { macro expanssion character count }

  maclstln: stp;        { macro expanssion listing line pointer }

  curstatp: ptr;        { current statement keyword pointer }

  statnbr,              { current statement number }
  lststatnbr: integer;  { last statement number }
  pmlib,                { file name pointer for macro library file }
  ptitle: stp;          { current user title pointer }
  sym: item;            { current item specification }
  lststate: ndtyp;      { last statement seen by statelist }

  paramhde: ptr;        { empty macro parameter list header }


                  { symbol tree definition }

  idtr:    array[0..maxstksymbsize] of ptr;

  cntx_heap: cntx_ptr := nil;   { stack pointer for source context }

  dtflnbr,              { data file number }
  idntseqnb,            { identifier sequence number }
  stkl,                 { stack of variable level }
  stkp: integer;        { stack of cmd file level indicator }
  emptyide: ptr;        { to collect the unused ide record }

                  { variable handled by insymbol }

  ptmacr: stp;          { current pointer to keep macro text }



                  { variable handled by expression }

  primobj: itemobj;     { current expression specification }

                  { general usage variable }

  { unit cell definition }

  dvol, rvol,
    da,   db,   dc,   ra,   rb,   rc,
   dal,  dbe,  dga,  ral,  rbe,  rga: real;

  tmd,  tmr: trmatrix;

                  { structure description element variable }

 { assignation table for array table as diffusion factor }
  ffrmptab: array[0..maxffrm] of ptr;

  indffcp: integer;     { count of index table in current data }
  phystabhde: array[physitmty] of physptr; { header for each phys. item }
  sequphtab:  array[physitmty] of integer; { sequence number table }
  diftbempty: ditbpt;   { list of unused form table }


  { text file data and result }

  curr_ptr,             { save internaly defined cte pointer }
  io_status: ptr;       { io_status symbol pointer }

  appnam: filespc := '';{ The Application Name String }
 
  mlbf: text;           { library file }


  { intermediary files }

  int: text;            { instruction file }
  ddi: ddi_file;        { data directory file }
  bdt: bdt_file;        { data file }


  { *** file manged by MXD *** }

  mlbfl: filecntx;      { macro library file context }
  ioftb: array[0..9] of filecntx; { user io file contexts }



	{******************************}
	{ Procedures/Function and Main }
	{******************************}



procedure NEWLINELST;
{ to open a new line on the output listing
   with page management }
begin
  linewrt := linewrt + 1;
  if linewrt >= pagesize then
  begin
    PUT_NEWLINELST( title );
    if ptitle <> nil then with ptitle^ do
      WRITELN( lst, ' *** ', s:ORD( l ), ' ***' )
    else WRITELN( lst );
    with cntx_heap^, ccnt, fcnt do
      if (fil_mod = f_data) or (fil_mod = f_maclib) then
        with filespecif^ do
	  WRITE( lst, ' Current source input file : ', s:ORD( l ) );
    WRITELN( lst );
    WRITELN( lst )
  end
end NEWLINELST;



procedure OUTSRCLIST;
{ output a source line on the listing with all appropriate index }
var
  pst: stp;

begin
  NEWLINELST;
  with cntx_heap^, ccnt, fcnt do
  begin
    if (fil_mod = f_macr) or (fil_mod = f_mcparm) then pst := maclstln
                                                  else pst := cmdline;
    with pst^ do
    begin
      if lststatnbr >= statnbr then WRITE( lst, ' ':6 )
                               else WRITE( lst, ' ', statnbr:5 );
      lststatnbr := statnbr;
      if (fil_mod = f_macr) or (fil_mod = f_mcparm) then
	if (fil_mod = f_macr) or bmaclst then
	  WRITE( lst, ' ', stkp:3, '    M+' )
	else
	  WRITE( lst, ' ', stkp:3, '    P+' )
      else
        WRITE( lst, ' ', stkp:3, ' ', linenbr:5 );
      if ORD( l ) < 1 then WRITELN( lst )
                      else WRITELN( lst, ' ':4, s:ORD( l ))
    end;
    bouterr := false
  end
end OUTSRCLIST;



procedure ERROR( errmdnam: mdnam; n: integer );
{ output the error messages }
{ the line of source is output (by calling of outsrclist) if
   1 - the source listing is off.
   2 - the out-of-contexte indicator is on(boolean bouterr).
}
var
  bo: boolean;
  ip: integer;

begin
  with cntx_heap^, ccnt, fcnt do
  begin
    if abs(n) < 1000 then
    begin
      bo := not blist or bouterr;
      if bo then OUTSRCLIST;
      if (fil_mod = f_macr) or (fil_mod = f_mcparm) then ip := maclstpt
                                                    else ip := cmdptr;
      WRITELN( lst, ' ':ip+18, '^' )
    end;
    if n < 0 then begin
      fatalerror := true;
      bexit := true;
      n := ABS( n ); WRITE( lst, ' FATAL' )
    end;
    errcnt := errcnt + 1;
    WRITE( lst, ' ERROR ', errmdnam:4, ' #', n:4, ' at ' );
    if curstatp <> nil then with curstatp^ do
      WRITE( lst, '"', name.s:ORD( name.l ), '" ' );
    WRITELN( lst, 'statement #', statnbr:3 );
    OUTERRMSGLINE( n ); { output the error information }
    linewrt := linewrt + 3;
    if (fil_mod = f_data) or (fil_mod = f_maclib) then
      if ABS( n ) < 1000 then
      begin
        with filespecif^ do
          WRITELN( lst, '   in the file : ', s:ORD( l ) );
        WRITELN( lst, ' at the line #', linenbr:5 );
        linewrt := linewrt + 2
      end;
    WRITELN( lst );
    bouterr := true
  end;
  if fatalerror then
  begin
    ch := ' '; clst := ' '; stkp := 0;  categ := eofo;
    cntx_heap^.ccnt.beoln := true
  end;
  { if max error count reached }
  if errcnt = maxerrcnt then ERROR( 'MAXE', -1000 )
end ERROR;




procedure RESETTXTFILE( var f: text; fname: stp; var bok, bprt: boolean );
{  Try to open a text file f with the name specified by stp
   on output if bok is false: the file is not open,
   not existing file is not an error, but other problem
   generate an error message as 2000 + system error code }
const
  mdnam = 'OPEN';

var
  i:   integer;

begin
  OPEN_INPUT_TXTFILE( f, fname, bok, bprt, i );
  io_status^.value := i;
  if i = 0 then
    bok := true
  else
  begin
    bok := false;
    if i <> -1 then ERROR( mdnam, i )
  end
end RESETTXTFILE;



procedure LSTFILESPC;
{ To write on the listing the current source specification }
begin
  with cntx_heap^, ccnt do
    if blist and (spclvl >= stklvl) then
    begin
      NEWLINELST; WRITELN( lst, ' ':9, '*':11,
                                'The input source file is now :' );
      NEWLINELST;
      with filespecif^ do
	WRITELN( lst, ' ':9, '*':11, '"', s:ORD( l ), '"' )
    end
end LSTFILESPC;



procedure RD_LINE( var f: text );
{ Read one line in the source text file given as parameter }
{ an echo line is output on terminal if pragma e+ is on }
{ an source line listing is output if pragma l+ is on with approriate level }
{ f is the source file }
const
  mdn = 'GLIN';

var
  ll: integer;

begin
  with cntx_heap^, ccnt, fcnt do
  begin
    if fil_tty then { with a terminal }
    begin (** CPAS **) { prompt managment can be modified }
      WRITELN( fil_prt ); WRITE( fil_prt, prompt )
    end;
    ll := 1;
    while not EOF( f ) and not EOLN( f ) do
    with cmdline^ do
    begin
      READ( f, ch );
      if ch = CHR( 9 ) then
      begin
        ch := CHR( 0 );
        repeat
          s[ll] := ' ';
          if ll < maxlinesz then ll := SUCC( ll )
                            else ERROR( mdn, 1 )
        until (ll >= maxlinesz) or (ll mod 8 = 1)
      end
      else
        if ch >= ' ' then
          if ll <= maxlinesz then
          begin
            s[ll] := ch; ll := SUCC( ll )
          end
          else ERROR( mdn, 1 )
    end;
    ll := PRED( ll );
    cmdline^.l := CHR( ll );
    if EOF( f ) then beof := true
                else (* if not fil_tty then *) READLN( f );

    linenbr := linenbr + 1;
    cmdptr  := frspos;
    beoln   := (frspos > ll);
    if becho and not fil_tty then
    begin
      WRITELN( output ); WRITE( output, prompt );
      with cmdline^ do
        if ll > 0 then WRITE( output, s:ll );
      WRITELN( output )
    end;
    if ll > lstpos then lsteff := lstpos
                   else lsteff := ll;
    if blist and (spclvl >= stklvl) then
      if (ll > 0) or not beof then OUTSRCLIST
  end
end RD_LINE;



procedure GET_LINE;
{ Get a line of source from current source file }
{ or macro/parameter string }
begin
  with cntx_heap^, ccnt, fcnt do
  if not beof then
  case fil_mod of
    f_data: RD_LINE( fil_ptr );
    f_macr, f_mcparm:
            if cmdline^.n <> nil then
            begin
              cmdline := cmdline^.n;
              lsteff := ORD( cmdline^.l );
              cmdptr := 1;
            end
            else beof := true;
    f_maclib: RD_LINE( mlbf )
  otherwise
  end
end GET_LINE;



function MATCH( s1, s2: nameid ): integer;
{ To compare two identifier names }
{ the result value is :
   0 if s1 and s2 match,
   1 if s1 > s2 and -1 if s1 < s2 }
var
  i, j: integer;
  bl:   boolean;

begin { MATCH }
  i := ORD( s1.l );
  j := ORD( s2.l );
  if j > i then j := i;
  i  := 1;
  bl := true;
  while (i <= j) and bl do
  begin
    bl := (s1.s[i] = s2.s[i]); if bl then i := i + 1
  end;
  if bl then
    if s1.l = s2.l then
      MATCH := 0
    else
      if s1.l > s2.l then MATCH := 1
                     else MATCH := -1
  else 
    if s1.s[i] > s2.s[i] then MATCH := 1
                         else MATCH := -1
end MATCH;



function NEWIDE: ptr;
{ Used to create a new identifier record or give an old unused one }
var
  p: ptr;

begin
  if emptyide <> nil then
  begin  p := emptyide; emptyide := p^.leftp end
  else NEW( p );
  if p = nil then ERROR( 'NEWI', -2 );
  newide := p
end NEWIDE;



procedure SEARCHID( s: nameid; var p: ptr; create: boolean );
{ To search or creat an identifier }
{ search also for created activate macro parameter }
var
  p1, p2, sp2: ptr;
  icmp, lvl, lvmin: integer;

begin { SEARCHID }
  p1  := nil;
  sp2 := nil;
  icmp := -1;
  if not create then
  begin
    p1 := paramhde;
    while (p1 <> nil) and (icmp <> 0) do
    begin
      icmp := MATCH( s, p1^.name );
      { we must not seen the active parameters of macro }
      if p1^.idtyp = undefine1 then icmp := -1;
      if icmp <> 0 then p1 := p1^.leftp
    end
  end;
  if icmp <> 0 then
  begin
    if create then lvmin := stkl - 1 else lvmin := -1;
    lvl := stkl;
    while (lvl > lvmin) and (icmp <> 0) do
    begin
      p1 := idtr[lvl]; p2 := nil;
      while (p1 <> nil) and  (icmp <> 0) do
      begin
	icmp := MATCH( s, p1^.name );
	p2 := p1;
	if icmp <> 0 then
          if icmp > 0 then p1 := p1^.rightp else p1 := p1^.leftp
      end;
      if icmp <> 0 then
      begin
        if lvl = stkl then  sp2 := p2;
        lvl := PRED( lvl )
      end
    end;
    if (icmp <> 0) and create then
    begin
      p1 := NEWIDE; { Allocate a new identifier block }
      if sp2 = nil then idtr[stkl] := p1
      else
        if icmp > 0 then sp2^.rightp := p1 else sp2^.leftp := p1;
      with p1^ do
      begin
        sequnb := idntseqnb; idntseqnb := idntseqnb + 1;
        leftp := nil; rightp := nil; lexlev := stkl; name := s
      end
    end
  end;
  p := p1
end SEARCHID;



function NEWDFTB: ditbpt;
{ Used to create a new array record or give an old unused one }
var
  pt: ditbpt;

begin
  if diftbempty = nil then NEW( pt )
  else
  begin
    pt := diftbempty; diftbempty := pt^.next
  end;
  if pt = nil then ERROR( 'NEWT', -2 )
              else pt^.next := nil;
  newdftb := pt
end NEWDFTB;



procedure FREDFTB( p: ditbpt );
{ To set as unused a array parameter }
var
  p1, p2: ditbpt;

begin
  p1 := diftbempty; p2 := nil;
  while p1 <> nil do
  begin  p2 := p1; p1 := p1^.next  end;
  if p2 = nil then diftbempty := p else p2^.next := p
end FREDFTB;



function SETNEWFFRM( p: ptr ): integer;
{ To assign an index for a diffusion array parameter in ffrmptab }
var
  i: integer;

begin
  i := 0;
  while (ffrmptab[i] <> nil) and (i < maxffrm) do i := i + 1;
  if i = maxffrm then
    if ffrmptab[maxffrm] <> nil then i := -1;
  if i <> -1 then ffrmptab[i] := p;
  SETNEWFFRM := i
end SETNEWFFRM;




procedure FREETEXT( var p: stp );
{ Set as disponible the text of a macro or macro-parameter }
var
  p1, p2: stp;

begin
  p1 := p;
  while p1 <> nil do
  begin
    p2 := p1^.n;
    ST_FREE( p1 );
    p1 := p2
  end;
  p := nil
end FREETEXT;



procedure FREEIDE( p: ptr );
{ Put in the free list all deleted identifier record }
var
  p1: ptr;

begin
  if p <> nil then
  begin
    with p^ do
    begin
      if leftp  <> nil then FREEIDE( leftp );
      if rightp <> nil then FREEIDE( rightp );
      case idtyp of
        keyword, stdfunc, stdpar, varty,
        contrty, dtfieldty, indexty: { nothing to do };
        arrctety:
          begin
            FREDFTB( pttab );
            if idex >= 0 then ffrmptab[idex] := nil
          end;
        paramty: if parattr = strkonst then ST_FREE( stpt );
        functionty: { user function }
          begin { we must free all formal also }
            p1 := forlst;
            while p1 <> nil do
            begin
              p^.leftp := emptyide; emptyide := p1;
              if p1^.idtyp = formalty then p1 := p1^.nxtpar
                                      else p1 := p1^.nxtfor
            end
          end;
        undefine,undefine1: { do not anything };
        parmacref: FREETEXT( actual );
        macroref:
          begin
            if idtyp = macroref then FREETEXT( macpt );
            while parlst <> nil do
            begin
              parlst^.leftp := emptyide; emptyide := parlst;
              parlst := parlst^.nxtpar
            end
          end
      end
    end;
    p^.leftp := emptyide; emptyide := p
  end
end FREEIDE;



procedure SAVECNTX;
{ create a new context for input stream }
var
  pcnt: cntx_ptr;

begin
  with cntx_heap^, ccnt do
  begin
    chs := ch; cmajs := cmaj; categs := categ
  end;

  NEW( pcnt );
  if pcnt = nil then ERROR( 'SAVC', -3 );

  if not fatalerror then
  with pcnt^, ccnt, fcnt do
  begin
    ccnt := cntx_heap^.ccnt;

    fil_mod    := cntx_heap^.fcnt.fil_mod;
    fil_tty    := cntx_heap^.fcnt.fil_tty;

    stklvl     := stklvl + 1;
    cmdline    :=   nil;
    filespecif :=   nil;
    bouterr    := false;
    linenbr    :=     0;
    binsert    := false;
    beoln      :=  true;
    cmdptr     := maxlinesz + 1;

    prvcntx    := cntx_heap;
    cntx_heap  := pcnt;

    stkp  := stklvl;
    ch    :=   ' ';
    cmaj  :=   ' ';
    categ := eolno
  end
end SAVECNTX;



procedure RESETCNTX( lvl: integer );
{ Restore the specified lvl context for input source stream }
var
  pc: cntx_ptr;

begin
  while stkp > lvl do
  begin
    with cntx_heap^, fcnt do
    begin
      pc := prvcntx;
      if ((fil_mod = f_macr) or (fil_mod = f_mcparm)) and
          ((pc^.fcnt.fil_mod = f_maclib) or
           (pc^.fcnt.fil_mod = f_data)) then
      begin
        if ccnt.blist then OUTSRCLIST;
        maclstln^.l := chr(0);
        maclstpt    := 0
      end
    end;

    DISPOSE( cntx_heap );
    cntx_heap := pc;

    with cntx_heap^.ccnt do
    begin
      bouterr := true;
      stkp    := stklvl;
      if binsert then
      begin
        ch := chv; cmaj := ch; categ := attchr[cmaj]
      end
      else
      begin
        ch := chs; cmaj := cmajs; categ := categs
      end
    end
  end
end RESETCNTX;



procedure NEWSCOPE( var bok: boolean );
{ Set allocation tree for a new scope contexte }
{ if bok is false we have an allocation overflow }
begin
  bok := false;
  if stkl < maxstksymbsize then
  begin
    stkl := SUCC( stkl );
    idtr[stkl] := nil;
    bok := true
  end
  else  ERROR( 'SCOP', -8 )
end NEWSCOPE;



procedure RELSCOPE;
{ To release the last scope context }
begin
  if idtr[stkl] <> nil then FREEIDE( idtr[stkl] );
  stkl := PRED( stkl )
end RELSCOPE;



procedure GETCHAR;
{ To get one character in the current line
   and set these characteristics }
begin
  with cntx_heap^.ccnt do
  begin
    if binsert then
    begin
      binsert := false; ch    := chs;
      cmaj    := cmajs; categ := categs
    end
    else
    begin
      ch := cmdline^.s[cmdptr]; cmdptr := cmdptr + 1
    end
  end;
  if ch < ' ' then ch := ' '; cmaj := ch;
  if cmaj > '_' then cmaj := CHR( ORD( cmaj ) - 32 );
  categ := attchr[cmaj]
end GETCHAR;



procedure INCHA;
{ get a character }
begin { INCHA }
  with cntx_heap^, ccnt, fcnt do
  begin
    if cmdptr > lsteff then
      if (fil_mod = f_macr) or (fil_mod = f_mcparm) then
      begin
        GET_LINE;
        if beof then
        begin
	  { we must re-enable the calling of a macro/parameter }
          if macptr <> nil then
            if fil_mod = f_macr then macptr^.idtyp := macroref
                                else macptr^.idtyp := parmacref;
            RESETCNTX( stklvl -1 )
	end else GETCHAR
      end else { file }
	if beof then
	begin  categ := eofo; ch := ' '  end
	else
	  if beoln then
	    if bline then
	    begin
              ch := ' '; categ := eolno  end
	    else
	    begin
	      repeat
	        GET_LINE
	      until beof or not beoln;
	      if beof then
	      begin  categ := eofo; ch := ' '  end
	      else GETCHAR
	    end else
	    begin  beoln := true; categ := eolno; ch := ' '  end
    else { cmdptr <= lsteff }  GETCHAR
  end
end INCHA;



procedure COMMENT( cs: char );
{ Read a comment to proceed in input stream }
var
  ct: boolean;

begin
  INCHA;
  ct := true;
  while ct do
  begin
    while (ch <> cs) and (categ <> eofo) do INCHA;
    ct := false;
    if (cs = '*') and (categ <> eofo) then
    begin
      INCHA; ct := (')' <> ch)
    end
  end;
  cmaj := ' '; categ := spacech;
  ch := ' ' { set the space state }
end COMMENT;




procedure INCHAR;
{ Get a character from the input stream }
{ with comment elimination }
begin { INCHAR }
  with cntx_heap^, ccnt, fcnt do
  begin
    if (fil_mod = f_macr) or (fil_mod = f_mcparm) then
    with maclstln^ do
      if maclstpt > (maxlinesz-20) then
        maclstpt := maclstpt + 1
      else
      begin
        maclstpt := ORD( l );
        maclstpt := maclstpt + 1;
        s[maclstpt] := ch; l := CHR( maclstpt )
      end;
    clst := ch;
    INCHA;
    if not binstring then
    if ch = '{' then COMMENT( '}' )
    else
    if (ch = '(') and (cmdptr <= lsteff) then
      if cmdline^.s[cmdptr] = '*' then
      begin  cmdptr := cmdptr + 1; COMMENT( '*' )  end
  end
end INCHAR;



procedure PUTCHAR;
{ Put in new macro/param text a character }
begin
  if ptmacr^.l >= CHR( maxlinesz ) then
  begin  ptmacr^.n := ST_CREATE; ptmacr := ptmacr^.n  end;
  with ptmacr^ do
  begin
    l := SUCC( l ); s[ord(l)] := ch
  end
end PUTCHAR;



procedure SKIPSPACE;
{ To skip unsignificative space and comment }
begin
  if boutmac and bspace then
  begin
    PUTCHAR; bspace := false
  end;
  repeat
    INCHAR
  until (bline and (categ = eolno)) or (categ = eofo) or (ch <> ' ')
end SKIPSPACE;



procedure ACTIVEMACPAR( pm: ptr; p: stp; modf: cmdmode ); forward;



procedure NEXTCH;
begin
  if boutmac then PUTCHAR;
  INCHAR
end NEXTCH;



procedure INSYMBOL;
{ get a symbol in the source input stream and decode it }
const
  mdnam = 'INSY';
  ten   =   10.0;
  one   =    1.0;

var
  bint, bstrnm: boolean;
  rdig, rexp, rfac, rval: real;
  debmacpt, ivl, i1: integer;
  pstp: stp;
  spch, pch : char;

begin { INSYMBOL }
  pstp := nil;
  pch  := CHR( 0 );
  if (ch = ' ') and (not bline or (categ <> eolno)) and (categ <> eofo)
  then SKIPSPACE;
  sym.ndtwd := nullsy; bspace := false; sym.ptid := nil; bdefpar := true;
  case categ of
    digit,period: { number }
      begin
        sym.ndtwd := konst;
        { assuming integer until shown other }
        rval := 0.0;
        rexp := ten;
        rfac := one;
        sym.sy := ctint;
        while categ = digit do
        begin
          rdig := ORD( ch ) - ORD( '0' );
          NEXTCH;
          rval := rval * ten + rdig
        end;
        if categ = period then
        begin
          NEXTCH;
          sym.sy := ctreal;
          while categ = digit do
          begin
            rdig := ORD( ch ) - ORD( '0' );
            NEXTCH;
            rfac := rfac / ten;
            rval := rval + rfac * rdig
          end
        end;
        if cmaj = 'E' then
        begin
          sym.sy := ctreal;
          NEXTCH;
          if (ch = '+') or (ch = '-') then
          begin
            if ch = '-' then  rexp := one/rexp;
            NEXTCH;
          end;
          ivl := 0;
          while categ = digit do
          begin
            ivl := ivl * 10 + ( ORD( ch ) - ORD( '0' ));
            NEXTCH;
          end;
          if (ivl > 38) then ERROR( mdnam, 11 );
          rfac := one;
          while ivl <> 0 do
            if ODD( ivl ) then
            begin  ivl := ivl - 1; rfac := rfac * rexp  end
            else
            begin  ivl := ivl div 2; rexp := SQR( rexp )  end;
            rval := rval * rfac
        end;
        if (sym.sy = ctint) and (rval <= 32767.0) and (rval >= -32768.0)
        then begin  sym.ival := TRUNC( rval ); sym.rval := sym.ival  end
        else begin  sym.ival := 0; sym.sy := ctreal  end;
        sym.rval := rval;
        bspace   := true
      end;

    alpha: { identifier or keyword or operator }
      with sym do
      begin
        { save the identifier position for macro expanssion list }
        debmacpt := maclstpt;
        if boutmac then
        begin  pstp := ptmacr; pch := ptmacr^.l  end;
        ivl := 0; namid.s := '        ';
        bstrnm := not bnostrg and (ch = '"');
        if bstrnm then NEXTCH;
        while (categ = alpha) or (categ = digit) or (categ = period) do
        begin
          ivl := ivl + 1;
          if ivl <= maxidsize then namid.s[ivl] := cmaj;
          NEXTCH;
        end;
        if ivl > maxidsize then ivl := maxidsize;
        namid.l := CHR( ivl );
        { search this identifier }
        SEARCHID( namid, ptid, false );
        sy := ident;
        if bstrnm then { identifier is in a string param }
          if ptid = nil then ERROR( mdnam, 51 )
          else
          with ptid^ do
            if idtyp <> paramty then ERROR( mdnam, 52 )
            else
            if parattr <> strkonst then ERROR( mdnam, 52 )
            else
            begin
              sym.namid.s := '        ';
              i1 := ORD( stpt^.l);
              if i1 > 8 then i1 := 8;
              for ivl := 1 to i1 do
              begin
                spch := stpt^.s[ivl]; { must be in capital letters }
                if spch > '_' then spch := CHR( ORD( spch ) - 32 );
                sym.namid.s[ivl] := spch
              end;
              sym.namid.l := CHR( i1 );
              SEARCHID( sym.namid, sym.ptid, false )
            end;
        if ptid <> nil then
        with ptid^ do
        case idtyp of
          operty:
            begin  sym.ndtwd := nodty; sy := operator  end;
          keyword,stdfunc,stdpar,bltfunc,bltfmac:
            sym.ndtwd := nodty;
          paramty:
            sym.ndtwd := param;
          arrctety,dtfieldty:
            sym.ndtwd := ctarray;
          varty:
            sym.ndtwd := varbl;
          contrty:
            sym.ndtwd := contrrf;
          functionty:
            { a true function is flagged by nxtfor = ptid }
            if nxtfor <> ptid then sym.ndtwd := formalcall
            else sym.ndtwd := functcall;
          formalty:
            sym.ndtwd := formalrf;
          indexty:
            sym.ndtwd :=indxrf;
          parmacref:
            begin
              if boutmac then
              { we delete the parameter name from the new macro text }
              begin
                if pstp <> ptmacr then
                begin  FREETEXT( ptmacr ); ptmacr := pstp  end;
                ptmacr^.l := pch
              end;
              { we delete the parameter name from the macro listing }
              if (cntx_heap^.fcnt.fil_mod = f_macr) or
                 (cntx_heap^.fcnt.fil_mod = f_mcparm) then
              begin
                maclstpt := debmacpt;
                with maclstln^ do
                begin
                  ivl := ORD( l );
                  if ivl > maclstpt then l := CHR( maclstpt )
                end
              end;
              { we disable the param for possible recursive call }
              if ptid^.actual <> nil then
              begin
                { we disable all possible recursive reference }
                ptid^.idtyp := undefine1;
                ACTIVEMACPAR( ptid, ptid^.actual, f_mcparm )
              end
              else
              begin  bdefpar := false; sym.ndtwd := nullsy  end
            end;
        otherwise
        end;
        bspace := true
      end;

    lpar, rpar, comma, semicol, colon, lbra, rbra: { separator }
      with sym do
      begin
        sy := separator; separ := categ; NEXTCH;
        case separ of
          colon: { := is the assignation operator equ. to single = }
            if categ <> equo then ndtwd := colonsy else
            begin
              sy := operator; opera := equo;
              ndtwd := assignop; nextch
            end;
          comma:
            ndtwd := commasy;
          lpar:
            ndtwd := lparsy;
          rpar:
            ndtwd := rparsy;
          semicol:
            ndtwd := smcolsy;
          lbra:
            ndtwd := brasy;
          rbra:
            ndtwd := ketsy
        end
      end;

    equo, clto, cgto, ioro, ando,
    addo, subo, mulo, divo, powo: { operator }
      with sym do
      begin
        sy := operator; opera := categ; NEXTCH;
        case opera of
          addo: ndtwd := addop;
          subo: ndtwd := subop;
          mulo: if categ <> mulo then ndtwd := mulop
                                 else begin  NEXTCH; ndtwd := powop  end;
          divo: ndtwd := divop;
          ioro: if categ <> ioro then ndtwd := iorop
                                 else begin  NEXTCH; ndtwd := concop  end;
          ando: ndtwd := andop;
          equo: ndtwd := equop;
          powo: ndtwd := powop;
          clto: if categ = cgto then begin  ndtwd := neqop; NEXTCH  end
                                else
                                if categ = equo then
                                begin  ndtwd := cleop; NEXTCH  end
                                else ndtwd := cltop;
          cgto: if categ = equo then begin  ndtwd := cgeop; NEXTCH  end
                                else ndtwd := cgtop
        end
      end;

    quot: {const string }
      begin
        if  not bnostrg then sym.valst := ST_CREATE;
        with sym do
        begin
          bint := true; ivl := 1; binstring := true;
          while bint do
          begin
            NEXTCH;
            if categ = eolno then INCHAR; { to skip the end of line }
	    if categ = eofo then bint := false;
	    if ch = '''' then
            begin
              NEXTCH;
              if ch = '''' then
              begin  if not bnostrg then valst^.s[ivl] := ch  end
              else bint := false
            end
            else
              if not bnostrg then valst^.s[ivl] := ch;
            if bint and (ivl < maxlinesz) then ivl := ivl + 1
            else
              if bint then begin  ERROR( mdnam, 12 ); bint := false  end
          end;
          binstring := false;
          if not bnostrg then valst^.l := CHR( ivl - 1 );
          sym.sy :=ctstr; sym.ndtwd := konst
        end
      end;

    oth:
      begin
        if ch <> ' ' then ERROR( mdnam, 13 );
        INCHAR
      end;

    eolno: begin  sym.sy := eolnsy; NEXTCH  end;

    eofo:  begin  sym.sy := eofsy; sym.ndtwd := eofsym  end
  end { case categ of };

  { break the output line in macro listing }
  with cntx_heap^, ccnt, fcnt do
  if (fil_mod = f_macr) or (fil_mod = f_mcparm) then
    if (maclstpt >= 80) or (sym.ndtwd = smcolsy) then
    begin
      if blist then OUTSRCLIST;
      maclstln^.l := CHR( 0 );
      maclstpt := 1
    end;

  { to display the insymbol work } {
  with sym do
  begin
    WRITELN( ORD( ndtwd ):4, ORD( sy ):4);
    case sy of
      ident:        WRITELN( namid.s:9 );
      ctstr:        WRITELN( valst^.s:ORD( valst^.l ) );
      ctint,ctreal: WRITELN( ival:16, ' ', rval:16 );
      separator:    WRITELN( ORD( separ ):5 );
      operator:     WRITELN( ORD( opera ):4 )
    end
  end }

end INSYMBOL;



procedure INPARAM( var ppar: stp; bpar: boolean );
{ To get the text of a macro parameter ended by ",",";" or ")" }
{ At begin we are on the first character and ptmacr = nil }
{ If bpar is true the parameter expression is rounded by "(..)" }
var
  k: integer;
  bs: boolean;
  chs,ip: char;
  pli: stp;


begin
  pli     := nil;
  bnostrg := true;
  k       := 0;
  ptmacr  := ST_CREATE;
  boutmac := true;
  bspace  := false;
  if bpar then
  begin
    chs := ch; ch := '('; PUTCHAR; ch := chs
  end;
  ppar := nil;
  if sym.ndtwd <> smcolsy then INSYMBOL; { get the first syntaxe unit }
  with sym do
  if (ndtwd <> commasy) and (ndtwd <> smcolsy) and (ndtwd <> rparsy)
  and (sy <> eofsy) then
  begin
    ppar := ptmacr;
    repeat
      bs := false;
      if sy = separator then
      begin
	if separ = lpar then k := k + 1
        else
	  if k > 0 then
	  begin
	    if separ = rpar then k := k - 1 else
	      bs := (separ = semicol)
	  end else { k = 0 }
	    bs := (separ = semicol) or (separ = comma) or (separ = rpar);
      end;
      if not bs then
      begin  pli := ptmacr; ip := pli^.l; INSYMBOL  end
    until bs or (sy = eofsy);
    { we must delete the unwanted string delimiter }
    pli^.l := ip;
    if pli <> ptmacr then FREETEXT( ptmacr );
    clst := ch; ch := ' ';
    if bpar then
    begin  chs := ch; ch := ')'; PUTCHAR; ch := chs  end;
    PUTCHAR; { put a space for end of parameter }
    ch := clst;
  end else begin  FREETEXT( ppar ); ppar := nil  end;
  boutmac := false; bnostrg := false
end INPARAM;



procedure INMACTXT( nd: ndtyp );
var
  fnd: boolean;
  nd1: ndtyp;

begin
  fnd := false;
  with sym do
  while not fnd and (sy <> eofsy) do
  begin
    if sy = ident then
    begin
      if (ndtwd >= repeatsy) and (ndtwd <= beginsy) then
      begin
        nd1 := ndtwd; INSYMBOL;
        case nd1 of
          repeatsy: INMACTXT( untilsy );
          IFSY:     INMACTXT( endifsy );
          MACROSY:  INMACTXT( endmacsy );
          BEGINSY:  INMACTXT( endsy )
        end;
        INSYMBOL { to search the next end }
      end
      else
      if (ndtwd = nd) or ((ndtwd = endifsy) and (nd = elsesy)) then
        fnd := true
      else INSYMBOL
    end else INSYMBOL
  end;
  if sym.sy = eofsy then ERROR( 'INMA', -77 )
end INMACTXT;



procedure INMACRO( var ptxt: stp; bout: boolean; macmd: inmacmode );
{ To get and load a macro/repeat/if.seq text }
{ If bout is false then inmacro is a keyword driven skip procedure }
{ Macmd flag the termination in level 0 on else or until keyword }
var
  ch1: char;

begin { INMACRO }
  boutmac := bout; bnostrg := true; bspace := false;
  if boutmac then ptmacr := ST_CREATE
             else ptmacr := nil;
  ptxt := ptmacr;
  with sym do
  if sy <> eofsy then
  begin
    case macmd of
      endblkmd: INMACTXT( endsy );
      endifmd:  INMACTXT( endifsy );
      endmacmd: INMACTXT( endmacsy );
      elsemd:   INMACTXT( elsesy );
      untilmd:  begin
                  INSYMBOL; { to get first repeat block syntax unit }
                  INMACTXT( untilsy );
                  while (sy <> eofsy) and (ndtwd <> smcolsy) do
                  INSYMBOL
                end
    end;
    if bout then
    begin
      ch1 := ch; ch := ';';
      if boutmac then PUTCHAR; ch := ch1
    end
  end { if sy <> eofsy };
  boutmac := false; bnostrg := false
end INMACRO;



procedure ACTIVEMACPAR{ (pm: ptr; p: stp; modf: cmdmode); was forward };
{ To activate a declared macro/parameter for processing }
begin
  if p <> nil then
  begin
    SAVECNTX;
    with cntx_heap^, ccnt, fcnt do
    begin
      macptr := pm; { set to can be re-enable calling ref. by incha }
      beoln  := false;
      lsteff := ORD( p^.l );
      if not blist or (fil_mod <> f_macr) then
      { the calling sequence is not a macro with m+ enable }
        if modf = f_macr then blist := bmaclst
                         else blist := bparlst;
      frspos  :=    1;
      cmdptr  :=    1;
      fil_mod := modf;
      cmdline :=    p
    end;
    categ := spacech;
    INSYMBOL
  end
end ACTIVEMACPAR;



procedure SKIP( nd: ndtyp; bps: boolean );
{ We skip the syntax item if : bps = true, the reached item is nd }
{ skip all stream item until next end-of-file or semicolon or specified }
begin
  with sym do
  while (sy <> eofsy) and (ndtwd <> nd) and (ndtwd <> smcolsy) do
  INSYMBOL;
  if bps then
    if (sym.sy <> eofsy) and (nd = sym.ndtwd) then INSYMBOL
end SKIP;



procedure LOOKSYMBOL( nd: ndtyp; ier: integer; bps: boolean );
{ Verify the ndtype syntax item and by pass it if bps }
begin
  with sym do
    if ndtwd <> nd then ERROR( 'LOOK', ier )
                   else if bps then INSYMBOL
end LOOKSYMBOL;



procedure INDATA( var rv: real; var bs: boolean );
{ To read the data fields in the data reduction process }
const
  mdnam = 'INDA';
var
  bneg, bread, bsng: boolean;

begin { INDATA }
  bsng := false; bneg := false; bread := false;
  with sym do
  begin
    bline := true;
    if sy = operator then
    begin
      bread := true;
      bneg := (opera = subo);
      if (opera <> subo) and (opera <> addo) then ERROR( mdnam, 14 )
                                             else bsng := true;
      INSYMBOL
    end;
    case sy of
      ctint, ctreal:
	begin
          bread := true;
	  bsng := false;
	  rv := rval; if bneg then rv := -rv
	end;
      separator:
	if (separ = comma) or (separ = semicol) then
	begin
	  if bsng then ival := ORD( bneg )+1
	end
        else ERROR( mdnam, 15 );
      operator:
        begin
          bread := true;
          if bsng then
            if (opera <> addo) and (opera <> subo) then ERROR( mdnam, 16 )
	    else rv := ORD( bneg ) + 2 * ORD( opera = subo )+4
        end;
      ident: ;
      ctstr, nothing: ERROR( mdnam, 17 );
      eofsy, eolnsy:;
    end { case sy of };
    if bread then INSYMBOL; { Skip to next syntax unit after a read }
    { Skip trailing comma }
    if (sy = separator) and (separ = comma) then INSYMBOL;
    bline := false;
  end { with sym do } ;
  bs := bsng
end INDATA;
	


procedure SETKWORD( var name: [readonly] string; kty:  idtype; ty: ndtyp    );
var
  i, ll: integer;
  p: ptr;
  st: nameid;

begin
  ll := name.length;
  with st do
  begin
    l := CHR( ll );
    for i := 1 to ll do s[i] := name[i];
    for i := ll + 1 to maxidsize do s[i] := ' '
  end;
  SEARCHID( st, p, true );
  with p^ do
  begin  idtyp := kty; nodty := ty  end
end SETKWORD;



procedure INITABLE;
{ Define all standard symbol }
begin { INITABLE }
  { define the standard functions }
  SETKWORD( 'LOG'         , bltfunc, logop );
  SETKWORD( 'EXP'         , bltfunc, expop );
  SETKWORD( 'SIN'         , bltfunc, sinop );
  SETKWORD( 'COS'         , bltfunc, cosop );
  SETKWORD( 'SQRT'        , bltfunc, sqrto );
  SETKWORD( 'TAN'         , bltfunc, tanop );
  SETKWORD( 'ATAN'        , bltfunc, atanop );
  SETKWORD( 'ASIN'        , bltfunc, asinop );
  SETKWORD( 'ACOS'        , bltfunc, acosop );
  SETKWORD( 'TANH'        , bltfunc, tanho );
  SETKWORD( 'BESSEL_J'    , bltfunc, bess1op );
  SETKWORD( 'SELECT'      , stdfunc, selectop );
  SETKWORD( 'INTSEL'      , stdfunc, intselop );
  SETKWORD( 'ITEMPAR'     , stdfunc, connectop );
  SETKWORD( 'SUBSTR'      , stdfunc, substrop );
  SETKWORD( 'SUMM'        , stdfunc, summop );
  SETKWORD( 'SUMHKL'      , stdfunc, sumhklop );
  SETKWORD( 'STRING'      , bltfunc, stringop );
  SETKWORD( 'LENGTH'      , bltfunc, lengthop );
  SETKWORD( 'INDEX'       , bltfunc, indexop );
  SETKWORD( 'NINDEX'      , bltfunc, nindexop );
  SETKWORD( 'NUMBER'      , bltfunc, numberop );
  SETKWORD( 'ABS'         , bltfunc, absop );
  SETKWORD( 'ROUND'       , bltfunc, intop );
  SETKWORD( 'MODULO'      , bltfunc, modop );

  SETKWORD( 'SYS_GETENV'  , bltfunc, getenvop );

  SETKWORD( 'DEFINED'     , bltfmac, definedop );
  SETKWORD( 'PARAMREF'    , bltfmac, paramrefop );

  { set the keywords }
  SETKWORD( 'PRAGMA'      , keyword, pragmasy );
  SETKWORD( 'REPEAT'      , keyword, repeatsy );
  SETKWORD( 'UNTIL'       , keyword, untilsy );
  SETKWORD( 'MACRO'       , keyword, macrosy );
  SETKWORD( 'PURGE'       , keyword, purgesy );
  SETKWORD( 'IF'          , keyword, ifsy );
  SETKWORD( 'THEN'        , keyword, thensy );
  SETKWORD( 'ELSE'        , keyword, elsesy );
  SETKWORD( 'END'         , keyword, endsy );
  SETKWORD( 'ENDIF'       , keyword, endifsy );
  SETKWORD( 'ENDMACRO'    , keyword, endmacsy );
  SETKWORD( 'BEGIN'       , keyword, beginsy );
  SETKWORD( 'INCLUDE'     , keyword, includesy );
  SETKWORD( 'CHAINE'      , keyword, chainsy );
  SETKWORD( 'MACROLIB'    , keyword, macrolibsy );
  SETKWORD( 'MACROCALL'   , keyword, mcallsy );
  SETKWORD( 'FUNCTION'    , keyword, usfunctdf );
  SETKWORD( 'CELL'        , keyword, cellsy );
  SETKWORD( 'RCELL'       , keyword, rcellsy );
  SETKWORD( 'SYMTRY'      , keyword, symtrysy );
  SETKWORD( 'CENTER'      , keyword, centeronsy );
  SETKWORD( 'DEBYE_MD'    , keyword, bisomd );
  SETKWORD( 'DATA'        , keyword, datasy );
  SETKWORD( 'PARAM'       , keyword, param );
  SETKWORD( 'VARIABLE'    , keyword, varbl );
  SETKWORD( 'FIXED'       , keyword, fixedsy );
  SETKWORD( 'UNFIXED'     , keyword, unfixedsy );
  SETKWORD( 'LATTICE'     , keyword, latticesy );
  SETKWORD( 'LIMITS'      , keyword, limitssy );
  SETKWORD( 'ATOM'        , keyword, atomsy );
  SETKWORD( 'CATOM'       , keyword, catomsy );
  SETKWORD( 'MOMENT'      , keyword, momentsy );
  SETKWORD( 'MDSDSP'      , keyword, mdsdspsy );
  SETKWORD( 'CONTRIBUTION', keyword, uctrdefsy );
  SETKWORD( 'CLRDATA'     , keyword, clrdatasy );
  SETKWORD( 'LSQBLOCK'    , keyword, lsqblocksy );
  SETKWORD( 'FFASSIGN'    , keyword, ffassignsy );
  SETKWORD( 'OPTION'      , keyword, optionssy );
  SETKWORD( 'WAVEVECT'    , keyword, wavevsy );
  SETKWORD( 'NPOLADIR'    , keyword, npoladirsy );
  SETKWORD( 'MAGNETIC'    , keyword, magneticsy );
  SETKWORD( 'SOPTION'     , keyword, soptionsy );
  SETKWORD( 'ENDFILE'     , keyword, eofsym );
  SETKWORD( 'GENSPACE'    , keyword, genspacesy );
  SETKWORD( 'ERROR'       , keyword, errorsy );
  SETKWORD( 'WRITEMSG'    , keyword, wrtmsgsy );
  SETKWORD( 'DISPLAY'     , keyword, displaysy );
  SETKWORD( 'REPLY'       , keyword, replysy );
  SETKWORD( 'OPENFILE'    , keyword, opensy );
  SETKWORD( 'WRITE'       , keyword, writesy );
  SETKWORD( 'WRITELN'     , keyword, writelnsy );
  SETKWORD( 'READ'        , keyword, readsy );
  SETKWORD( 'CLOSEFILE'   , keyword, closesy );
  SETKWORD( 'LISTING'     , keyword, listingsy );
  SETKWORD( 'RUN_MXD_APPL', keyword, runapplsy );
  SETKWORD( 'SYS_SPAWN'   , keyword, spawnsy );

  { define standard operators }
  SETKWORD( 'AND'         , operty, andop );
  SETKWORD( 'OR'          , operty, iorop );
  SETKWORD( 'NOT'         , operty, notop );

  { define the predefined symbols }
  SETKWORD( '$H'          , stdpar, parh );
  SETKWORD( '$K'          , stdpar, park );
  SETKWORD( '$L'          , stdpar, parl );
  SETKWORD( '$RH'         , stdpar, parrh );
  SETKWORD( '$RK'         , stdpar, parrk );
  SETKWORD( '$RL'         , stdpar, parrl );
  SETKWORD( '$SITHSL'     , stdpar, parstsl );
  SETKWORD( '$HX'         , stdpar, parhx );
  SETKWORD( '$HY'         , stdpar, parhy );
  SETKWORD( '$HZ'         , stdpar, parhz );
  SETKWORD( '$QX'         , stdpar, parqx );
  SETKWORD( '$QY'         , stdpar, parqy );
  SETKWORD( '$QZ'         , stdpar, parqz );
  SETKWORD( '$HH'         , stdpar, parhh );
  SETKWORD( '$KK'         , stdpar, parkk );
  SETKWORD( '$LL'         , stdpar, parll );
  SETKWORD( '$SH'         , stdpar, parsh );
  SETKWORD( '$SK'         , stdpar, parsk );
  SETKWORD( '$SL'         , stdpar, parsl );
  SETKWORD( '$OBS'        , stdpar, parobs );
  SETKWORD( '$SIG'        , stdpar, parsig );
  SETKWORD( '$WEIGHT'     , stdpar, parweig );
  SETKWORD( '$CALC'       , stdpar, parcalc );
  SETKWORD( '$FN2'        , stdpar, parfn2 );
  SETKWORD( '$FM2'        , stdpar, parfm2 );
  SETKWORD( '$F2POLA'     , stdpar, paripola );
  SETKWORD( '$NPOLA'      , stdpar, parpola );
  SETKWORD( '$LCHI2'      , stdpar, parlchi2 );
  SETKWORD( '$CCHI2'      , stdpar, parcchi2 );
  SETKWORD( '$LMAXF'      , stdpar, parlmaxf );
  SETKWORD( '$CMAXF'      , stdpar, parcmaxf );
  SETKWORD( '$FNR'        , stdpar, parfnr );
  SETKWORD( '$FNI'        , stdpar, parfni );
  SETKWORD( '$FMXR'       , stdpar, parfxr );
  SETKWORD( '$FMYR'       , stdpar, parfyr );
  SETKWORD( '$FMZR'       , stdpar, parfzr );
  SETKWORD( '$FMXI'       , stdpar, parfxi );
  SETKWORD( '$FMYI'       , stdpar, parfyi );
  SETKWORD( '$FMZI'       , stdpar, parfzi );
end INITABLE;



function DEFSTRCONST( var st: [readonly] string ): stp;
{ built a string constante, st is the short string form,
  nc the length in char, and the result is the pointer of
  the new allocated string }
var
  p:  stp;
  nc: integer;

begin
  p := ST_CREATE;
  with p^ do
  begin
    nc := st.length;
    l  := CHR( nc );
    while nc > 0 do
    begin  s[nc] := st[nc]; nc := PRED( nc )   end
  end;
  DEFSTRCONST := p
end DEFSTRCONST;



procedure DEFNWCTE( var nam: [readonly] string; vl: real );
{ Create a numeric constante parameter with the value vl,
   and the name nam with len characters }
var
  ivsp, len, i: integer;
  name: nameid;
  pc: ptr;

begin
  ivsp := stkl;
  len  := nam.length;
  for i := 1 to len do name.s[i] := nam[i];
  for i := len+1 to maxidsize do name.s[i] := nam[i];
  name.l := CHR( len );
  SEARCHID( name, pc, true );
  stkl := ivsp;
  with pc^ do
  begin
    idtyp := paramty; parattr := numkonst;
    value := vl
  end;
  curr_ptr := pc { save this identifier pointer }
end DEFNWCTE;



procedure GENSYSPARM;
{ Create a string constante parameter with the argv[idx] value }
var
  i, idx, ivsp, j: integer;
  name: nameid;
  pc: ptr;

begin
  for idx := 0 to 16 do
  begin
    ivsp := stkl;
    name.l := CHR( 4 );
    name.s[1] := '$'; name.s[2] := 'P';
    i := idx div 10; j := idx - 10*i;
    name.s[3] := CHR( i + ORD( '0' ) );
    name.s[4] := CHR( j + ORD( '0' ) );
    SEARCHID( name, pc, true );
    stkl := ivsp;
    with pc^ do
    begin
      idtyp   := paramty;
      parattr := strkonst;
      stpt    := ST_CREATE;
      with stpt^ do
      begin
        l := CHR( 0 );
        if (idx < argc) and (argv[i] <> nil) then (** CPAS **)
        with argv[idx]^ do
        begin
          l := CHR( length );
          for i := 1 to length do  s[i] := body[i]
        end
      end
    end
  end
end GENSYSPARM;



procedure INIT;
{ Generale initialisation procedure to enable the initial context }
var
  it:         physitmty;
  i, j, ierr: integer;
  ic:         char;
  bok:        boolean;

begin
  initcpu   := CPU_CLOCK;               { Get initial cpu time }
  errmsgspecif := errspcfile;           { Set the error message file specification }
  curstatp  := nil;
  paramhde  := nil;
  bincerr   := false;                   { Disable the not exit file error }
  bgenspace := false; bcentric := false;
  strempty  := nil;   bnewdata := false; bolddata := true;
  { Initial clear of ident. and file seq.# }
  idntseqnb := 0;     dtflnbr := 0;
  stkp      := 0;     stkl    := 0;      binstring := false;
  boutmac   := false; bnostrg := false;  bspace    := false;
  ch        := ' ';   clst    := ' ';    categ     := eolno;

  { Set a default listing to NL: (VMS => NL:, UNIX => /dev/null) }
  OPEN_LISTING( lst, 'nl:', 1 );
  OPEN_LISTING( int, 'mxdint.tmp.1', 0 );

  NEW( cntx_heap );
  with cntx_heap^, ccnt, fcnt do
  begin { Init the stack of source files }
    prvcntx    := nil;                  { Set the initial previous context pointer }
    spclvl     := 1;
    stklvl     := 0;
    filespecif := DEFSTRCONST( defcmd );
    cmdline    := ST_CREATE;
    linenbr    :=     0;
    frspos     :=     1;
    lstpos     :=   120;
    lsteff     :=     0;
    cmdptr     :=     1;
    chv        :=   ' ';
    chs        :=   ' ';
    cmajs      :=   ' ';
    categs     := spacech;
    binsert    := false;
    bouterr    := false;
    beof       := false;
    beoln      :=  true;
    blist      := false;
    bmaclst    := false;
    bparlst    := false;
    becho      := false;
    bphys      := false;

    fil_mod    := f_data;               { Set source data mode }
    { Try to open the "mxd_env.std" file }
    OPEN_INPUT_TXTFILE( fil_ptr, filespecif, bok, fil_tty, ierr );
    if not bok then                     { Test open not successful }
    begin                               { Set MXD CMP to Interractive Mode (eof => no default file) }
      WRITELN( ' MXD cannot open "', current_filename,
               ' => MXD not initialized => STOP MXD.' );
      goto MXD_STOP
    end
    else
      if fil_tty then
        { Open a related Prompt file }
        OPENW_TXTFILE( fil_prt, filespecif, 1 )
  end;
  pmlib    := DEFSTRCONST( defmlib ); pmlib^.n := nil;
  maclstln := ST_CREATE;                { Allocate a line for the macro exp[anssion list }
  maclstpt := 1;                        { ... and set to empty this line }
  errcnt   := 0;        bline      := false;
  bexit    := false;
  statnbr  := 0;        lststatnbr := -1;    pagenb := 0;
  linewrt  := pagesize;
  idtr[0]  := nil;      idtr[1]    := nil;
  emptyide := nil;
  INITABLE;                             { Define all keywords and standard identifiers }
  stkl := 1;
  for i:= 0 to maxffrm do ffrmptab[i] := nil;
  for it := wavespc to blkspc do sequphtab[it] := 0;
  for it := wavespc to blkspc do phystabhde[it] := nil;
  indffcp  := -1;       diftbempty := nil;
  majorfmode := false;                  { The default is to use only minor case file specification }
  fatalerror := false;
  GENSYSPARM;                           { Set the $P0 .. $P16 system string parameters }
  DEFNWCTE( '$STATUS', 0.0);            { Define the io status symbol }
  io_status := curr_ptr;                { ... and set the internal access pointer }
  for i := 0 to 9 do ioftb[i].fil_mod := f_close
end INIT;



procedure PUTREFITM( var itm: itemobj; bk: boolean );
{ Output an item reference on the polish code file }
begin
  with itm do
  if ndt <> nullsy then
  if eattr <> exprattr then
  begin
    if bk or (ndt <> konst) then
    WRITE( int, ' ', ORD( ndt ):4, ' ' );
    case ndt of
      konst: if bk then WRITELN( int, rvl:12 );
      indxrf, formalrf, varbl, param, contrrf:
             WRITELN( int, pvb^.sequnb:6 );
      refer: WRITELN( int, ORD( spcl ):4 );
      ctarray: with pvb^ do
        begin
          if idex = -1 then
          begin
            idex := SETNEWFFRM( pvb );
            if idex = -1 then ERROR( 'PUTR', 4 )
          end;
          WRITELN( int, idex:4 )
        end
    end;
    if bk or (ndt <> konst) then eattr := exprattr
  end
end PUTREFITM;



function CONCATSTR( ps1, ps2: stp ): stp;
{ Result is the pointer of the concatened strings pointed by ps1 and ps2 }
var
  i1, i2, i3: integer;
  psr: stp;

begin { CONCATSTR }
  psr := ST_CREATE;
  psr^.s := ps1^.s; psr^.l := ps1^.l;
  i1 := ORD( psr^.l ); i2 := ORD( ps2^.l );  i2 := i2 + i1;
  if i2 > maxlinesz then
  begin  ERROR( 'CSTR', 22 ); i2 := maxlinesz  end;
  i3 := 0;
  while i1 < i2 do
  begin
    i1 := SUCC( i1 ); i3 := SUCC( i3 );
    psr^.s[i1] := ps2^.s[i3]
  end;
  psr^.l := CHR( i2 );
  CONCATSTR := psr
end CONCATSTR;



procedure EXTEND( pp: stp; i: char );
begin
  with pp^ do
    while l < i do
    begin  l := SUCC( l ); s[ord(l)] := ' '  end
end EXTEND;



function CMPSTR( var ps1, ps2: stp ): integer;
{ Compare two strings pointed by ps1 and ps2,
  the result is :
  0 = the string are same,
  1  if ps1^ > ps2^ and -1 if ps1^ < ps2^.
}
var
  i, j: integer;
  beq:  boolean;


begin { CMPSTR }
  i := ORD( ps1^.l ); j := ORD( ps2^.l );
  if i <> j then
    if i > j then EXTEND( ps2, ps1^.l )
             else begin  EXTEND( ps1, ps2^.l ); i := j  end;
  j := 1; beq := true;
  while (j <= i) and beq do
  begin  beq := (ps1^.s[j] = ps2^.s[j]); if beq then j := j + 1  end;
  if beq then CMPSTR := 0
  else
    if ps1^.s[j] > ps2^.s[j] then CMPSTR := 1
                             else CMPSTR := -1;
  ST_FREE( ps1 ); ST_FREE( ps2 )
end CMPSTR;



procedure COPYSTR( var psr: stp; pss: stp; bl: boolean );
{ Makes a copy of the string pointed by pss, the copy is pointed by psr,
   if bl is true, the old string is flushed }
begin
  if psr = nil then psr := ST_CREATE;
  psr^ := pss^; 
  if bl then ST_FREE( pss )
end COPYSTR;



procedure SUBSTR( p: stp; i, j: integer );
{ Get the sub-string begining at the i'th char. and ending at the j'th char.
  in the string pointed by p, the result string replace the initial string }
var
  ll, k: integer;

begin
  with p^ do
  begin
    ll := ORD( l );
    if i < 1 then i := 1;
    if i <= ll then
    begin
      if j <= 0 then j := ll
                else if j > ll then j := ll;
      k := 0;
      while i <= j do
      begin
        k := k + 1;
        s[k] := s[i];
        i := i + 1
      end;
      l := CHR( k );
    end
    else l := CHR( 0 )
  end
end SUBSTR;



function INDEX( s1, s2: stp ): integer;
{ Result is the first order character of the first occurence of the string s2^
   in the string s1^, and 0 if no found }
var
  l1, l2, i, j, k: integer;
  c: char;
  fnd: boolean;

begin
  l1 := ORD( s1^.l ); l2 := ORD( s2^.l ); fnd := false; i := 0;
  if (l2 > 0) and (l1 >= l2) then
  begin
    c := s2^.s[1];
    with s1^ do
    while (i <= (l1-l2)) and not fnd do
    begin
      i := SUCC( i );
      if c = s[i] then
      begin
	j := i + 1; k := 2;
	while (k <= l2) and (s[j] = s2^.s[k]) do
	begin  k := k + 1; j := j + 1  end;
	fnd := (k > l2)
      end
    end
  end;
  if fnd then INDEX := i
         else INDEX := 0
end INDEX;



function NINDEX( s1, s2: stp; nb: integer ): integer;
{ Result is the first order character of the nb occurence of the string s2^
   in the string s1^, and 0 if no found, if nb <= 0 => the last occurance }
var
  l1, l2, i, isv, j, k: integer;
  c: char;
  fnd: boolean;

begin
  isv := 0;
  l1 := ORD( s1^.l );
  l2 := ORD( s2^.l );
  if (l2 > 0) and (l1 >= l2) then
  begin
    c  := s2^.s[1]; { get the first f2 character }
    i  := 0;        { Begin to the first s1 character }
    if nb <= 0 then nb := l1; { set to maximum possible number }
    with s1^ do
    repeat
      fnd := false;
      while (i <= (l1-l2)) and not fnd do
      begin { Search for the first s2 character }
        i := SUCC( i );
        if c = s[i] then { if first character found }
        begin { Compare the other s1 and s2 characters }
          j := i + 1; k := 2;
          while (k <= l2) and (s[j] = s2^.s[k]) do
          begin  k := k + 1; j := j + 1  end;
          fnd := (k > l2)
        end
      end;
      if fnd then
      begin
        isv := i;    { keep the found recurence position }
        nb := nb - 1 { count down of founded recurence }
      end
    until (nb = 0) or not fnd
  end;
  NINDEX := isv
end NINDEX;


function INSTRING( iv, ifl: integer ): stp;
{ To convert iv to a character string given as result^ }
{ if ifl is not 0, then the format of the string is with abs(ifl) character
   with the character "0" at left or space if ifl < 0 }
var
  p:     stp;
  ip, i: integer;
  ch:    char;
  tbch: array[0..15] of char;

begin
  p := ST_CREATE;
  with p^ do
  begin
    i := ABS( iv );
    if ifl > 0 then ch := '0' else ch := ' ';
    ip := 0;
    if i = 0 then
    begin  tbch[0] := ch; ip := ip + 1;  end
    else
    while i > 0 do
    begin
      tbch[ip] := CHR( (i mod 10) + ORD( '0' ) );
      i := i div 10; ip := ip + 1
    end;
    if iv < 0 then
    begin  tbch[ip] := '-'; ip := ip + 1  end;
    { ip is the length of the string }
    if ifl < ip then ifl := ip else
      if ifl > ip then
      begin
        if ifl > 16 then ifl := 16;
	if tbch[ip-1] = '-' then
        tbch[ifl-1] := tbch[ip-1];
        for i := ip to ifl-1 do  tbch[i] := '0'
      end;
    for i := 1 to ifl do  s[i] := tbch[ifl-i];
    l := CHR( ifl )
  end;
  INSTRING := p
end INSTRING;



function INNUMBER( var p: stp ): integer;
{ to convert a string p^ in integer value
   the original string p^ is flushed.
}
var
  fnd,bng: boolean;
  i,j,len: integer;
  r: real;
  c: char;

begin
  with p^ do
  begin
    len := ORD( l );
    i := 1; j := 0; fnd := false; bng := false; r := 0.0;
    while (i <= len) and not fnd do
    begin
      c := s[i]; i := i + 1;
      if (c >= '0') and (c <='9') then
      begin
	j := 2; r := r * 10.0 + ORD( c ) - ORD( '0' )
      end else
	if (j < 2) and ((c = '+') or (c = '-')) then
	begin
	  j := 1; if c = '-' then bng := not bng
	end else
	  if j = 2 then fnd := true else
	    if c <> ' ' then ERROR( 'INCV', 21 )
    end
  end;
  ST_FREE( p );
  innumber := ROUND( r )
end INNUMBER;




function ARCSIN( v: real ): real;
{ Arc sinus function }
var
  v1: real;

begin
  if ABS( v ) > 1.0 then ERROR( 'ASIN', 23 )
  else
  begin
    if ABS( V ) > 0.99999 then
      if v > 0.0 then v1 := 90.0 else v1 := -90
    else
      v1 := ARCTAN( v/SQRT( 1.0 - SQR( v ) ) )/inrd
  end;
  ARCSIN := v1
end ARCSIN;



function PHASEARG( ip, rp: real ): real;
var
  md: real;

begin
  md := SQRT( SQR( ip ) + SQR( rp ) );
  if md = 0.0 then PHASEARG := 0.0 else
  begin
    md := ip/md;
    if rp < 0.0 then PHASEARG := 180.0 - ARCSIN( md )
                else PHASEARG := ARCSIN( md )
  end
end PHASEARG;



procedure NXTPOINT( var x, y: real; var p: ditbpt; var i: integer );
{ To give the next point of an arrctety parameter }
{
   on input :
	x is the start absciss value in the table for interpolation.

   if found then
   on output :
	x,y are the coordinates of founded point in the table,
	p is the pointer of the current table, and i the index of the
	founded point.
   else p is set to nil.

}
begin
  if p <> nil then
  begin
    i := i + 1;
    if i >= p^.lentab then
    begin
      p := p^.next; if p = nil then i := -1 else i := 0
    end
  end;
  if p <> nil then
  with p^ do
  begin x := org + i*stp; y := tabl[i] end
end NXTPOINT;



function INTERPOL( par: ptr; var vx: real ): real;
{ Interpolation with 4 points around the vx value of par^ arrctety param. }

const
  mdnam = 'INTE';

var
  c0,   c1,  c2,  c3,  r1,  r2, vxx, vyy,
  vp1, vp2, vp3, vp4,  v1,  v2,  v3,  v4: real;
  p: ditbpt;
  i: integer;

begin { INTERPOL }
  if par^.idtyp <> arrctety then ERROR( mdnam, -24 )
  else
    if par^.pttab = nil then ERROR( mdnam, 25 )
    else
      if par^.pttab^.lentab < 1 then ERROR( mdnam, 25 )
      else { we must have one point }
      begin { collection of 4 points }
        p := par^.pttab; { get the first point of table }
        with p^ do
        begin
          vp1 := org; v1 := tabl[0]; i := 0
        end;
        vp2 := vp1 + p^.stp; v2 := v1;     { default is 4* the same point }
        vp3 := vp2 + p^.stp; v3 := v1;
        vp4 := vp3 + p^.stp; v4 := v3;
        NXTPOINT( vp2, v2, p, i );         { get the second point }
        if i <> -1 then { if it is existing }
        begin
          vp3 := vp2 + p^.stp; v3 := v2;   { default is the first point and }
          vp4 := vp3 + p^.stp; v4 := v3;   { 3* the same second point }
          NXTPOINT( vp3, v3, p, i );       { GET THE THIRD POINT }
          if i <> -1 then { if it is existing }
          begin
            vp4 := vp3 + p^.stp; v4 := v3; { default is the first and second }
            { and twice time the third point }
            NXTPOINT( vp4, v4, p, i )      { get the four'th point }
          end
        end;
        if i = -1 then
          { there is a arrctety parameter with a length less than 4}
          ERROR( mdnam, 26 );
        { get the wanted points around the vx value as possible }
        while (i <> -1) and (vp3 < vx) do
        begin
          NXTPOINT( vxx, vyy, p, i );
          if i <> -1 then
          begin
            vp1 := vp2; v1 := v2; vp2 := vp3; v2 := v3;
            vp3 := vp4; v3 := v4; vp4 := vxx; v4 := vyy
          end
        end;
        { interpolation }
        r1 := (v1 - v2)/(vp1 - vp2);
        r2 := (r1 - (v1 - v3)/(vp1 - vp3))/(vp2 - vp3);
        c3 := (r2 - (r1 - (v1 - v4)/(vp1 - vp4))/(vp2 - vp4))/(vp3 - vp4);
        c2 := r2 - (vp1 + vp2 + vp3)* c3;
        c1 := r1 - (vp1 + vp2)* c2 - (sqr(vp1)+ vp1 * vp2 + sqr(vp2)) * c3;
        c0 := v1 - vp1 *(c1 + vp1*(c2 + vp1 * c3));
        c0 := c0 + vx * (c1 + vx * (c2 + vx * c3));
        INTERPOL := c0
      end
end INTERPOL;



{ To convert string in integer number
   with update of expression attribute
}
procedure CONVINT(VAR ITM: ITEMOBJ);
begin
  with itm do
  begin
    ivl := INNUMBER( pstr ); eattr := numkonst; rvl := ivl
  end
end CONVINT;



procedure CONVSTR( var itm: itemobj; i: integer );
{ To convert integer i in string
   with update of expression attribute
}
var
  nb: integer;

begin
  with itm do
  begin
    nb := ROUND( rvl ); ivl := nb;
    eattr := strkonst;
    pstr := INSTRING( nb, i )
  end
end CONVSTR;


procedure GETENVSYMB( slog: stp );
var
  stlg, sttr: filespc;
  i, ie: integer;

begin
  with slog^ do
  begin
    for i := 1 to ORD( l ) do  stlg[i] := s[i];
    stlg.length := ORD( l );
    ie := GET_LOGICAL( sttr, stlg );
    if ie = 0 then
    begin
      for i := 1 to sttr.length do s[i] := sttr[i];
      l := CHR( sttr.length )
    end else l := CHR( 0 )
  end
end GETENVSYMB;


{ To manage the not executable functions }
procedure CALLFUNC( var nd: itemobj ); forward;

procedure USERCALL( var nd: itemobj ); forward;



{ Expression parsing and compilation }
procedure EXPRESSION;
const
  mdnam = 'EXPR';
  spmax = 32;

type
  spvl = 0..spmax;

var
  sp, spv: spvl;
  stk: array[spvl] of itemobj;
  stkv: array[spvl] of itemobj;


  { To push an itemobj on the operational stak stkv }
  procedure PUSH;
  begin
    if spv = spmax then ERROR( mdnam, -5 )
                   else spv := SUCC( spv )
  end PUSH;



  { To handle the simple expression - without "(" and ")" }
  procedure SUBEXPRESSION;
  var
    gtitm: itemobj;
    bstp, bunit: boolean;
    sps: spvl;

  { To execute the executable operation - with constant avl. or,
     output the compiled polish notation }
  {
    Putitem get in operator stack all the objects (given by subexpression)
     and :
       push operand in operational stack,
       execute all directly executable operators in operational stack,
       and for none executable operators, output it in the
       polish code output file.
  }


    procedure PUTITEM( var oper: itemobj );
    type
      bpar = (numbexp, numbcte, strcte, undefcte, undefined);

    var
      bcomp, bstring: boolean;
      ipw, jpw:       integer;
      cobj:           itemobj;
      crv:            real;
      is:             spvl;

    { Debugging procedure to display the operational stack }
    {***
      procedure OUTSTK;
    var
      i: integer;

    begin
      i := -1;
      with primobj do
      begin
        WRITELN( 'STK ', i:3, ':', ORD( ndt ):2, ORD( eattr ):4 );
        if ndt = konst then WRITELN( ' ':20, rvl:12:3, ivl:12:3 );
      end;
      for i := spv downto 0 do
      with stkv[i] do
      begin
        WRITELN( 'STK ', i:3, ':', ORD( ndt ):2, ORD( eattr ):4 );
	if ndt = konst then WRITELN( ' ':20, rvl:12:3, ivl:12:3 );
      end
    end OUTSTK; *}

    { To extract an itemobj from the operational stack }
    procedure POP;
    begin
      cobj := stkv[spv]; if spv > 0 then spv := PRED( spv )
                                    else ERROR( mdnam, -6 )
    end POP;

    { To set the integer part of a numeric constant value }
    procedure ININT( var obj: itemobj );
    begin
      with obj do
      begin
        ivl := 0.0;
        if (rvl >= -327677.5) and (rvl <= 32766.5) then
        begin
          if rvl >= 0.0 then ivl := TRUNC( rvl + 0.5 )
                        else ivl := TRUNC( rvl - 0.5 );
          if ivl <> 0.0 then
            if ABS( (rvl-ivl)/ivl ) < 1.0e-6 then rvl := ivl
        end
      end
    end ININT;

    { To test the binary operator and output it if not executable }
    procedure TESTBIN( bp: bpar );
    begin
      POP;
      with cobj do
      begin
        if bp <= numbcte then { numeric }
        begin
          if eattr = strkonst then CONVINT( cobj );
          if primobj.eattr = strkonst then CONVINT( primobj )
        end
        else
         if bp = strcte then
         begin
           if eattr = numkonst then CONVSTR( cobj, 0 );
           if primobj.eattr = numkonst then CONVSTR( primobj, 0 )
         end
         else { undefcte or undefined }
           if eattr <> primobj.eattr then
           begin
             if (eattr = numkonst) and (primobj.eattr = strkonst) then
               CONVSTR( cobj, 0 )
             else
               if (eattr = strkonst) and (primobj.eattr = numkonst) then
                 CONVSTR( primobj, 0 )
               else
                 if bp = undefined then
                 begin { if variable allowed => numeric is preferable }
                   if (eattr >= varblattr) and (primobj.eattr = strkonst) then
                     CONVINT( primobj )
                   else
                     if (eattr = strkonst) and (primobj.eattr >= varblattr) then
	               CONVINT( cobj )
                 end
           end;
        if eattr = numkonst then ININT( cobj );
        bstring := (primobj.eattr = strkonst) and (eattr = strkonst);
        bcomp := (primobj.eattr = numkonst) and (eattr = numkonst);
        if (primobj.eattr <> eattr) and ((primobj.eattr = strkonst) or
           (eattr = strkonst)) then ERROR( mdnam, -53 );
        if (bstring and ((bp <> strcte) and (bp < undefcte)))
        or (bcomp and (bp = strcte))
        then ERROR( mdnam, -53 );
        if primobj.eattr = numkonst then
        with primobj do
        begin
          ININT( primobj );
          if (ivl = rvl) and (oper.ndt = powop) then
          begin  oper.ndt := ipwop; ipw := TRUNC( rvl ) end
        end;
        if (bp <> numbexp) and (bp <> undefined)
        and not (bcomp or bstring) then ERROR( mdnam, -54 );
        if (not bcomp) and (not bstring) then
        begin
          PUTREFITM( cobj, true );
          if oper.ndt <> ipwop then PUTREFITM( primobj, true )
                               else primobj.eattr := exprattr;
          WRITE( int, ' ', ORD( oper.ndt ):4 );
          if oper.ndt = ipwop then WRITELN( int, ' ', ipw:8 )
                              else WRITELN( int )
        end
      end
    end TESTBIN;

    { To test the unary operator and output it if not executable }
    procedure TESTUNA( bp: bpar );
    begin
      with primobj do
      begin
        if bp <= numbcte then
          if eattr = strkonst then CONVINT( primobj )
          else
            if bp = strcte then
              if eattr = numkonst then CONVSTR( primobj, 0 );
        bstring := (eattr = strkonst);
        bcomp := (eattr = numkonst);
        if (bstring and (bp <> strcte))
        or (bcomp and (bp = strcte)) then ERROR( mdnam, -55 )
      end;
      if bcomp then ININT( primobj );
      if not (bcomp or bstring) then
        if bp <> numbexp  then ERROR( mdnam, -56 ) else
        begin
          PUTREFITM( primobj, true );
          WRITELN( int, ' ', ORD( oper.ndt ):4 )
        end
    end TESTUNA;

  begin { PUTITEM }
    bcomp := false;
    bstring := false;
    with primobj do
    begin
      case oper.ndt of
        nullsy: { no-op } ;
        refer,param,varbl,contrrf,ctarray,konst,indxrf,formalrf:
          { reference handling }
          begin { push directly all operand reference }
            if primobj.ndt <> nullsy then
            begin
              PUSH;
              stkv[spv] := primobj
            end;
            primobj := oper;
            if ndt <> konst then { and output all none constante ref. }
              for is := 1 to spv do  PUTREFITM( stkv[is], true )
          end;
        addop:
          begin  TESTBIN( numbexp ); if bcomp then rvl := cobj.rvl + rvl  end;
        subop:
          begin  TESTBIN( numbexp ); if bcomp then rvl := cobj.rvl - rvl  end;
        mulop:
          begin  TESTBIN( numbexp ); if bcomp then rvl := cobj.rvl * rvl  end;
        divop:
          begin  TESTBIN( numbexp );
            if bcomp then
              if ABS( rvl ) < 1.0e-30 then ERROR( mdnam, 27 )
                                      else rvl := cobj.rvl / rvl
          end;

        powop,ipwop:
          begin  TESTBIN( numbexp );
            if bcomp then
              if oper.ndt=ipwop then rvl := cobj.rvl**ipw
              else
                if cobj.rvl < 0.0 then ERROR( mdnam, 28 )
                else
		begin  crv := cobj.rvl; rvl := EXP( LN( crv )*rvl )  end
          end;

        concop:
          begin
            TESTBIN( strcte );
            if bstring then
            begin  COPYSTR( pstr, CONCATSTR( cobj.pstr, pstr ), true );
              if cobj.pstr <> pstr then	ST_FREE( cobj.pstr );
              cobj.pstr := nil
            end
          end;

        numberop:
          begin
	    TESTUNA( strcte );
            if bstring then CONVINT( primobj )
          end;

        stringop:
          begin
            TESTBIN( numbcte );
            if bcomp then
            begin
              ipw := TRUNC( ivl+0.5 ); primobj := cobj; CONVSTR( primobj, ipw )
            end
          end;

        substrop:
          begin  TESTBIN( numbcte );
            if bcomp then
            begin
              ipw := ROUND( cobj.ivl ); jpw := ROUND( ivl );
              SUBSTR( oper.pstr, ipw, jpw );
              primobj := oper; ndt := konst
            end
          end;

        absop:
          begin  TESTUNA( numbexp ); if bcomp then rvl := ABS( rvl )  end;

        arrayrf:
          begin  TESTUNA( numbexp ); { test if constant index }
            { search the rvl-th term of oper.rvl }
            { /// no implemented /// }
          end;

        interpop:
          begin
            TESTUNA( numbcte ); if bcomp then rvl := INTERPOL( oper.pvb, rvl )
          end;

        negop:
          begin  TESTUNA( numbexp ); if bcomp then rvl := - rvl  end;
        sinop:
          begin  TESTUNA( numbexp ); if bcomp then rvl := SIN( rvl*inrd )  end;
        cosop:
          begin  TESTUNA( numbexp ); if bcomp then rvl := COS( rvl*inrd )  end;
        tanop:
          begin  TESTUNA( numbexp );
            if bcomp then
            begin  rvl := rvl*inrd; rvl := SIN( rvl )/COS( rvl )  end
	  end;
        expop:
          begin  TESTUNA( numbexp ); if bcomp then rvl := EXP( rvl )  end;
        logop:
          begin  TESTUNA( numbexp );
            if bcomp then
            begin  if rvl <= 0.0 then ERROR( mdnam, 29 )
                                 else rvl := LN( rvl )
            end
          end;
        tanho:
          begin TESTUNA( numbexp );
            if bcomp then
            begin
              crv := EXP( -2.0*ABS( rvl ) );
              crv := (1.0 - crv)/(1.0 + crv);
              if rvl > 0.0 then rvl := crv else rvl := -crv
            end
          end;
        atanop:
          begin
            TESTUNA( numbexp ); if bcomp then rvl := ARCTAN( rvl )/inrd
          end;

        asinop, acosop:
          begin TESTUNA( numbexp );
            if bcomp then
            begin
              rvl := ARCSIN( rvl );
              if oper.ndt = acosop then rvl := 90.0 - rvl
            end
          end;
        phaseop:
          begin  TESTBIN( numbexp );
            if bcomp then rvl := PHASEARG( cobj.rvl, rvl )
          end;
        bess1op:
          begin TESTBIN( numbexp );
            if bcomp then rvl := BESSEL_J( ROUND( cobj.rvl ), rvl )
          end;
        sqrto:
          begin  TESTUNA( numbexp );
            if bcomp then
              if rvl < 0.0 then ERROR( mdnam, 30 ) else rvl := SQRT( rvl )
          end;
        equop, neqop, cltop, cleop, cgeop, cgtop:
          begin
            TESTBIN( undefined );
            if bcomp or bstring then
            begin
              eattr := numkonst;
              if bstring then ipw := CMPSTR( cobj.pstr, pstr )
              else
              begin
                rvl := cobj.rvl - rvl;
                if rvl = 0.0 then ipw := 0 else
                  if rvl > 0.0 then ipw := 1 else ipw := -1
              end;
              case oper.ndt of
		equop: bcomp := (ipw = 0);
		neqop: bcomp := (ipw <> 0);
		cltop: bcomp := (ipw < 0);
		cleop: bcomp := (ipw <= 0);
		cgeop: bcomp := (ipw >= 0);
		cgtop: bcomp := (ipw > 0)
              end;
              ipw := ORD( bcomp ); rvl := ipw;
              ivl := rvl
            end
          end;
        modop:
          begin
            TESTBIN( numbexp );
            if bcomp then
              rvl := TRUNC( cobj.ivl ) mod TRUNC( ivl )
          end;
        intop:
          begin  TESTUNA( numbexp ); if bcomp then rvl := ivl  end;
        andop:
          begin
            TESTBIN( numbcte );
            if bcomp then
            begin
              if (cobj.ivl <> 0.0) and (rvl <> 0.0) then rvl := 1.0
                                                    else rvl := 0.0;
              ivl := rvl
            end
          end;
        iorop:
          begin
            TESTBIN( numbcte );
            if bcomp then
            begin
              if (cobj.ivl <> 0.0) or (ivl <> 0.0) then rvl := 1.0
                                                   else rvl := 0.0;
              ivl := rvl
            end
          end;
        notop:
          begin
            TESTUNA( numbcte );
            if bcomp then
              if ivl <> 0.0 then rvl := 0.0 else rvl := 1.0;
              ivl := rvl
          end;
        lengthop:
          begin
            TESTUNA( strcte );
            if bstring then
            begin
              ipw := ORD( pstr^.l ); ST_FREE( pstr );
              eattr := numkonst; ivl := ipw; rvl := ivl
            end
          end;
        indexop:
          begin
            TESTBIN( strcte );
            if bstring then
            begin
              ipw := INDEX( cobj.pstr, pstr );
              ST_FREE( pstr ); ST_FREE( cobj.pstr );
              eattr := numkonst; ivl := ipw; rvl := ivl;
            end
          end { indexop };
        nindexop:
          begin
            TESTUNA( numbcte ); { number in primobj }
            if bcomp then
            begin
              ipw := ivl;
              POP;
              primobj := cobj; { get s2 }
              TESTBIN( strcte );
              if bstring then
              begin
                ipw := NINDEX( cobj.pstr, pstr, ipw );
                ST_FREE( pstr ); ST_FREE( cobj.pstr );
                eattr := numkonst; ivl := ipw; rvl := ivl;
              end
            end
          end { nindexop };
        getenvop:
          begin
            TESTUNA( strcte );
            if bstring then GETENVSYMB( primobj.pstr )
          end { getenvop }
      end { case ndt of }
    end
  end PUTITEM;


  procedure PUSHZERO;
  { Push a null numeric constante in the operator stack }
  var
    itm: itemobj;

  begin
    with itm do
    begin
      ndt := konst; eattr := numkonst; ivl := 0.0; rvl := 0.0; prior := '9'
    end;
    PUTITEM( itm )
  end PUSHZERO;



  procedure GETITEM;
  { To compile any expression :
     push all item in operator stack.
    Allocate the priority as this :
	"(", all functions, operands :	'9',
	^ or ** exponential operator :  '7', *** ^ and unary work from ***
	+, - unary and not operator :	'7', ***     left to right.    ***
	* and /  :			'6',
	+ and -  :			'5',
	=, <>, <, <=, >=, > :		'4',
	and or & :			'2',
	or  or ! :			'1',
	all separator except "("        ' '.
  }
  var
    blc: boolean;
    is: spvl;


    procedure SETSUBSTR;
    { Substr function parameter handling }
    begin
      INSYMBOL; blc := true;
      with sym do
      begin
        if ndtwd = brasy then
        with gtitm do
        begin
          ndt := substrop;
          blc := false; INSYMBOL; SUBEXPRESSION;
          if ndtwd = colonsy then
          begin  INSYMBOL; SUBEXPRESSION  end
          else PUSHZERO;
          if ndtwd <> ketsy then ERROR( mdnam, 83 )
        end
      end
    end SETSUBSTR;


    procedure STOPEXPR;
    { To stop subexpression parsing }
    begin
      bstp := true; gtitm.prior := ' '
    end STOPEXPR;


  begin { GETITEM }
    bstp := false; blc := false;
    with sym, gtitm do
    begin
      prior := '9';
      ndt := ndtwd;
      case sy of
        ident:
          if bunit then
            if ptid <> nil then
            with ptid^ do
            begin
              bunit :=  false;
              case idtyp of
                stdpar:
                  begin
                    eattr := varblattr; ndt := refer; pvb := nil;
                    spcl := CHR( ORD( ndtwd ) - ORD( parh ) )
                  end;

                arrctety:
                  begin
                    pvb := ptid; eattr := varblattr;
                    INSYMBOL; blc := true;
                    if (ndtwd = brasy) or (ndtwd = lparsy) then
                    begin
                      eattr := numkonst;
                      if ndtwd = brasy then ndt := arrayrf
                                       else ndt := interpop;
                      blc := false; INSYMBOL;
                      SUBEXPRESSION; { Take the array parameter }
                      if (ndt = interpop) and (ndtwd <> rparsy) then
                        ERROR( mdnam, 81 )
                      else
                        if (ndt = arrayrf) and (ndtwd <> ketsy) then
                          ERROR( mdnam, 83 )
                    end
                  end;

                paramty:
                  case parattr of 
                    strkonst:
                      begin
                        eattr := strkonst; ndt := konst;
                        pstr := nil; COPYSTR( pstr, stpt, false );
                        SETSUBSTR { To handle the substr parameter }
                      end;
                    numkonst:
                      begin
                        eattr := numkonst; ndt := konst; rvl := value
                      end;
                    varblattr, exprattr:
                      begin  eattr := varblattr; pvb := ptid  end;
                    nullattr: ERROR( mdnam, -88 )
                  end;

                varty, contrty, dtfieldty, formalty, indexty:
                  begin
                    eattr := varblattr; pvb := ptid
                  end;

                bltfmac:
                  begin
                    INSYMBOL;
                    LOOKSYMBOL( lparsy, 82, true );
                    case ndt of
                      definedop:
                        begin
                          if bdefpar then
                          case sym.sy of
                            ident:
                              if ptid <> nil then rvl := 1.0
                                             else rvl := 0.0;
                            ctstr:                rvl := 3.0;
                            ctint, ctreal:        rvl := 2.0;
                            operator:             rvl := 4.0;
                          otherwise
                            ERROR( mdnam, 55 );
                          end { case sym.sy of }
                          else rvl := -1
                        end;
                      paramrefop:
                        begin
                          rvl := 0.0; { assume false value }
                          if ptid <> nil then
                          with ptid^ do
                            { variable parameter reference function }
                            if idtyp = paramty then
                              if parattr = exprattr then rvl := sequnb
                        end;
                    otherwise
                    end;
                    INSYMBOL;
                    LOOKSYMBOL( rparsy, -81, false );
                    ndt := konst; eattr := numkonst
                  end;

                bltfunc:
                  begin
                    INSYMBOL;
                    LOOKSYMBOL( lparsy, 82, true );
                    SUBEXPRESSION;
                    case ndt of
                      atanop: { One or two parameters switch atan <-> phase }
                        if ndtwd = commasy then begin
                                                  ndt := phaseop;
                                                  INSYMBOL; SUBEXPRESSION
                                                end;

                      stringop: { one or two parameters }
                        if ndtwd = commasy then begin
                                                  INSYMBOL; SUBEXPRESSION
                                                end
                                           else PUSHZERO;

                      bess1op,
                      modop, indexop: { Two parameters functions }
                        begin
                          LOOKSYMBOL( commasy, 85, true );
                          SUBEXPRESSION
                        end;

                      nindexop: { Three parameters function }
                        begin
                          LOOKSYMBOL( commasy, 85, true );
                          SUBEXPRESSION;
                          { third parameter can be ommitted }
                          if ndtwd = commasy then
                          begin
                            INSYMBOL; SUBEXPRESSION
                          end
                          else PUSHZERO
                        end;

                    otherwise
                    end;
                    blc := false;
                    LOOKSYMBOL( rparsy, -81, false )
                  end;

                functionty, stdfunc:
                  begin
                    if (ndt <> substrop) and (primobj.ndt <> nullsy) then
                    begin { we must output all residual references in primobj }
                      PUSH;
                      stkv[spv] := primobj;
                      for is := 1 to spv do  PUTREFITM( stkv[is], true );
                      { to disable new value output by putrefitm }
                      primobj.ndt := nullsy
                    end;
                    if idtyp = functionty then USERCALL( gtitm )
                                          else CALLFUNC( gtitm )
                  end;

                parmacref { macro parameter handling }:
                  { Cannot occur / already handled by INSYMBOL }
                  ;

                keyword, macroref: begin  bstp := true; prior := ' '  end;

                undefine: ERROR( mdnam, -88 )
              end { case idtyp of };
            end
            else ERROR( mdnam, 51 )
          else stopexpr;

        ctstr:
          if bunit then
          begin
            bunit := false; eattr := strkonst; pstr := valst; setsubstr
          end
          else STOPEXPR;

        ctint, ctreal:
          if bunit then
          begin
            bunit := false; eattr := numkonst; rvl := rval; ivl := ival
          end
          else STOPEXPR;

        operator:
          begin
            if bunit and (ndtwd <> addop) and (ndtwd <> subop)
                     and (ndtwd <> notop) then
            begin
              ERROR( mdnam, 68 );
              bstp := true; prior := ' '
            end
            else
            case ndtwd of
              concop: prior := '5';
              addop, subop:
                begin
                  if bunit then
                  begin
                    prior := '7'; if ndtwd = subop then ndt := negop
                                                   else ndt := nullsy
                  end
                  else prior := '5'
                end;
              mulop, divop: prior := '6';
              equop, neqop, cltop, cleop, cgeop, cgtop: prior := '4';
              andop: prior := '2';
              iorop: prior := '1';
              powop: prior := '7';
              notop: if not bunit then ERROR( mdnam, 67 )
                                  else prior := '7'
            end;
            bunit := true;
          end;

        separator:
          begin
            prior := ' ';
            if ndtwd = lparsy then
              if bunit then
              begin
                INSYMBOL; SUBEXPRESSION;
                LOOKSYMBOL( rparsy, 81, false );
                bunit := false;
                prior := '9'; ndt := nullsy
              end
              else ERROR( mdnam, 67 )
            else bstp := true
          end;

        eolnsy: ;
        eofsy: bstp := true
      end { case }
    end;
    if not (bstp or blc) then INSYMBOL
  end GETITEM;


begin { SUBEXPRESSION }
  sps := sp; bunit := true;
  bstp := false;
  GETITEM;
  while ((sp <> sps) or not bstp) and not fatalerror do
    if (sp <> sps) and ((gtitm.prior < stk[sp].prior) or
	((gtitm.prior = stk[sp].prior) and (gtitm.prior <> '7')))
	    { to assume left to rigth order for unary and ^ }
	    { and right to left for other operator }
    then
    begin
      PUTITEM( stk[sp] );
      sp := sp - 1
    end
    else
    begin
      if sp = spmax then ERROR( mdnam, -7 ) else sp := SUCC( sp );
      stk[sp] := gtitm; GETITEM
    end
end SUBEXPRESSION;


begin { EXPRESSION }
  sp := 0; spv := 0;
  stk[0].prior := ' ';
  stkv[0].eattr := nullattr;
  primobj.eattr := nullattr;
  primobj.ndt := nullsy;
  SUBEXPRESSION
end EXPRESSION;




procedure INPUTLETTER( var ic: char );
{ To get a letter symbol for pragma, lattice ... }
begin
  with sym do
    if sy = ident then ic := namid.s[1] else
      if sy = ctstr then
      with valst^ do
	if l > CHR( 0 ) then ic := s[1] else ic := ' ';
  { set in capital letter }
  if (ic >= 'a') and (ic <= 'z') then ic := CHR( ORD( ic ) - 32 )
end INPUTLETTER;



procedure GETPHYSPARAM;
{ Get a physical parameter and output it in polish code file }
begin
  EXPRESSION;
  with primobj do
  begin
    if eattr = strkonst then CONVINT( primobj );
    if ndt = nullsy then WRITELN( int, ' ', ORD( nullsy ):4 { nil })
                    else PUTREFITM( primobj, true );
  end;
  if sym.ndtwd = commasy then INSYMBOL
end GETPHYSPARAM;



procedure VALUEEXPRESSION;
{ Get an expression value and set it as defined by the expression
   attribut : exprattr,varblattr => polish code file,
	      constante => value in primobj.
}
begin
  EXPRESSION;
  if primobj.eattr = varblattr then { putrefitm set eattr at exprattr }
  begin  PUTREFITM( primobj, false ); primobj.eattr := varblattr  end
end VALUEEXPRESSION;



procedure GETICTE( var i: integer );
{ Get an integer constante value }
begin
  EXPRESSION;
  with primobj do
  begin
    if (ndt <> nullsy) then
    begin
      if eattr = strkonst then CONVINT( primobj );
      if eattr <> numkonst then ERROR( 'GINT', 58 ) else
      begin
	i := ROUND( rvl )
      end
    end
  end;
  if sym.ndtwd = commasy then INSYMBOL
end GETICTE;



procedure GETNCTE( var v: real );
{ Get a numeric constante value }
begin
  EXPRESSION;
  with primobj do
  begin
    if (ndt <> nullsy) then
    begin
      if eattr = strkonst then CONVINT( primobj );
      if (eattr <> numkonst) then ERROR( 'GNCT', 58 ) else v := rvl;
    end
  end;
  if sym.ndtwd = commasy then INSYMBOL
end GETNCTE;



procedure GETVARBL;
{ Get a variable reference => output to polish code file }
begin
  EXPRESSION;
  if primobj.eattr <> varblattr then ERROR( 'GVAR', 59 );
  if sym.ndtwd = commasy then INSYMBOL
end GETVARBL;



procedure GETSCTE( var ps: stp );
{ Get a constante string value (set it in ps^ ) }
begin
  ps := nil;
  EXPRESSION;
  with primobj do
  begin
    if eattr = numkonst then CONVSTR( primobj, 0 );
    if eattr <> strkonst then ERROR( 'GSTR', 60 ) else ps := pstr
  end
end GETSCTE;



procedure LOOKSEMICOL( bl: boolean );
{ Check for semicolon ins input stream
   if bl then the semicolon is skipped.
}
begin
  with sym do
  if ndtwd <> smcolsy then
  begin
    ERROR( 'LSEM', 86 ); SKIP( smcolsy, bl )
  end
  else if bl then INSYMBOL
end LOOKSEMICOL;



procedure TRANSVECT( var mt: trmatrix; var r1, r2, r3, d1, d2, d3: real );
{ Form the product : (r1,r2,r3) = ((trmatrix))*(d1,d2,d3) }
begin
  r1 := mt[1,1]*d1+mt[1,2]*d2+mt[1,3]*d3;
  r2 := mt[2,1]*d1+mt[2,2]*d2+mt[2,3]*d3;
  r3 := mt[3,1]*d1+mt[3,2]*d2+mt[3,3]*d3
end TRANSVECT;



{ To create or locate (an existing) item :
  badef is false to locate and true to creat .
  sep   is THE PREFIX SEPARATOR }
function NEWPHYSITM(       itp: physitmty;
                     var badef: boolean;   sep: ndtyp ): physptr;
var
  ps:            stp;
  pt0, pt1, pt2: physptr;
  names:         nameid;
  i1, i2:        integer;
  bfnd:          boolean;

begin { NEWPHYSITM }
  if sep <> nullsy then
  with sym do
    if ndtwd <> sep then ERROR( 'GITM', 82+3*ORD( sep = commasy ) )
                    else INSYMBOL;
  GETSCTE( ps );
  names.l := chr(0);
  if ps <> nil then
    with ps^ do
    begin
      i2 := ORD( l ); if i2 > maxidsize then i2 := maxidsize;
      for i1 := 1 to i2 do
      names.s[i1] := s[i1];
      names.l     := CHR( i2 );
      ST_FREE( ps )
    end;
  pt1  := phystabhde[itp];
  pt2  := nil;
  bfnd := false;
  while not bfnd and (pt1 <> nil) do
  begin
    if ORD( pt1^.name.l) <> i2 then bfnd := false
    else
    begin
      i1   := 0;
      bfnd := true;
      while bfnd and (i1 < i2) do
      begin
        i1 := i1 + 1;
        bfnd := (pt1^.name.s[i1] = names.s[i1]) 
      end
    end;
    pt2  := pt1;
    if not bfnd then pt1 := pt1^.next;
  end;
  badef := bfnd;
  if not bfnd then
  begin
    case itp of
	wavespc:  NEW( pt0, wavespc  );
	atomspc:  NEW( pt0, atomspc  );
	momespc:  NEW( pt0, momespc  );
	npolaspc: NEW( pt0, npolaspc );
	dispspc:  NEW( pt0, dispspc  );
	symspc:   NEW( pt0, symspc   );
	dataspc:  NEW( pt0, dataspc  );
	blkspc:   NEW( pt0, blkspc   )
    end;
    with pt0^ do
    begin
      sequ := sequphtab[itp];
      sequphtab[itp] := sequphtab[itp] + 1;
      name := names;
      next := nil
    end;
    if pt2 = nil then phystabhde[itp] := pt0
                 else pt2^.next := pt0;
    pt1 := pt0
  end;
  NEWPHYSITM := pt1
end NEWPHYSITM;



{ Procedure to create a new special identifier in the parameter list }
{ for macros, macro parameters or user function formals }
{ on output: if br is true the new identifier cannot be created }
{ bm is true for macro allocation, and false for sequenced allocation }
procedure DECLARESPECIAL( bm: boolean; var br: boolean );
const
  mdn = 'DCLS';

begin
  br := true; { assume bad }
  with sym do
  begin
    if sy <> ident then ERROR( mdn, 61 ) else
    begin
      br := (ptid <> nil);
      if br then
	with ptid^ do
	  if idtyp <= operty then ERROR( mdn, 62 ) else
	    if lexlev = -1 then ERROR( mdn, 63 ) else br := false
    end;
    if not br then
    begin
      ptid := NEWIDE; { create the identifier }
      with ptid^ do
      begin
	lexlev := -1; name := namid; rightp := nil;
	if bm then sequnb := -1 else
	begin
	  sequnb := idntseqnb; idntseqnb := idntseqnb + 1
	end
      end
    end
  end
end DECLARESPECIAL;



{ Procedure to create a new identifier if no scope conflict }
{ On Output: if br is true the new identifier cannot be created }
procedure DECLARENEWIDENT( var br: boolean );
const
  mdnam = 'DCLI';

var
  b: boolean;
  stkcur, nb: integer;

begin
  stkcur := stkl; { save current scope }
  if sym.sy = ctint then
  with sym do
  begin
    nb := ROUND( ival ); { get reverse scope excursion }
    if nb = 0 then nb := 1 else nb := stkl - nb;
    if nb < 1 then nb := 1
              else if nb > stkl then nb := stkl;
    INSYMBOL; { Locate the new expected identifier }
    stkl := nb; { Set the wanted scope level }
    SEARCHID( namid, ptid, false )
  end;
  br := true;
  with sym do
  if (sy <> ident)  then ERROR( mdnam, 61 ) else
  begin
    b := (ptid = nil);
    if not b then
    with ptid^ do
      if idtyp < operty then ERROR( mdnam, 62 ) else
	if lexlev = stkl then ERROR( mdnam, 63 ) else
	  begin  b := true; ptid := nil  end;
    if b then
    begin
      SEARCHID( namid, ptid, true ); br := false
    end
  end;
  stkl := stkcur { restore the current scope }
end DECLARENEWIDENT;



procedure USERCALL { (var nd: itemobj) } ; { was forward }
{ Generate a calling sequence for a user defined function
   which are always executed in the computing execution phase }
const
  mdn = 'UCAL';

var
  saveobj:     itemobj;
  pfu, p0, p1: ptr;
  npa:         integer;

  function FORFUNMATCH( pfa, pfb: ptr ): boolean;
  var
    pa, pb: ptr;
    bok:    boolean;

  begin
    pa  := pfa^.forlst;
    pb  := pfb^.forlst;
    bok := true;
    while bok and (pa <> nil) and (pb <> nil) do
    begin
      bok := (pa^.idtyp = pb^.idtyp);
      if pa^.idtyp = formalty then pa := pa^.nxtpar else pa := pa^.nxtfor;
      if pb^.idtyp = formalty then pb := pb^.nxtpar else pb := pb^.nxtfor
    end;
    if bok then bok := (pa = nil) and (pb = nil);
    FORFUNMATCH := bok
  end FORFUNMATCH;

begin { USERCALL }
  nd.eattr := exprattr; nd.ndt := sym.ndtwd;
  pfu := sym.ptid; { save the called function definition pointer }
  saveobj := primobj; { save the actual primobj }
  npa := 0; { assume no parameters }
  INSYMBOL; { search for "(" }
  LOOKSYMBOL( lparsy, 82, true ); { "(" tested and by pass }
  with sym,pfu^ do
  begin
    p0 := forlst; { get parameter list head }
    { for all parameters }
    while p0 <> nil do
    begin
      if p0^.idtyp = formalty then { scalar formal }
      { output the scalar parameter expression }
      begin  GETPHYSPARAM; p1 := p0^.nxtpar  end
      else
      begin { formal function }
	{ we must compare the formal function model and the given parameter }
	if sy =ident then
	  if ptid <> nil then
	    if ptid^.idtyp = functionty then
	      if FORFUNMATCH( p0, ptid ) then
	        { output the given formal function reference }
	        WRITELN( int, ' ', ORD( functrf ):4,
                              ' ', ptid^.sequnb:6 )
	      else ERROR( mdn, -442 ) { parameters do not match }
	    else ERROR( mdn, -441 )   { if not a function }
	  else ERROR( mdn, -51 )      { undeclared identifier }
	else ERROR( mdn, -61 );       { identifier was expected }
	INSYMBOL;
        if ndtwd = commasy then INSYMBOL;
	p1 := p0^.nxtfor
      end;
      npa := npa + 1;
      p0 := p1
    end;
    WRITELN( int, ' ', ORD( nd.ndt ):4,
                  ' ', npa:4, ' ', pfu^.sequnb:6 )
  end;
  primobj := saveobj;
  nd.ndt  := varbl
end USERCALL;



procedure CALLFUNC { (var nd: itemobj) } ; { was forward }
{ generate a calling sequence for external function
  which cannot be realized in mxd phasis or execute complex function }
const
  mdnam = 'CALL';

var
  saveobj: itemobj;
  i, j, k: integer;
  spc: physitmty;
  bdf: boolean;
  pit: physptr;

BEGIN
  k := 0;
  saveobj := primobj;                   { Save the actual primobj }
  INSYMBOL;                             { Search for "(" }
  LOOKSYMBOL( lparsy, 82, true );
  with sym, nd do
  begin
    case ndt of
      substrop:                         { Must be executed in mxd phase }
        begin
          GETSCTE( primobj.pstr );
          nd := primobj;
          if ndtwd = commasy then INSYMBOL;
          i := 1; if sym.sy <> separator then GETICTE( i );
          j := 132; if sym.sy <> separator then GETICTE( j );
          j := i + j - 1;
          SUBSTR( pstr, i, j )
        end;
      selectop, intselop:               { Never executed in mxd phase }
        begin
          i := 0;
          repeat
            GETPHYSPARAM;
            i := i + 1
          until (i >= maxsel) or (sym.ndtwd = rparsy);
          WRITELN( int, ' ', ORD( ndt ):4, ' ', i:4 );
          eattr := exprattr;
          ndt   := varbl
        end;
      sumhklop:                         { To comput the sum of parameter on all run hkl }
        begin
          GETPHYSPARAM; eattr := exprattr;
          WRITELN( int, ' ', ORD( ndt ):4); ndt := varbl
        end;
      connectop:                        { Never executed in mxd phase }
        begin
          GETICTE( j ); nd:= primobj;   { Get item/field specifier }
          i := j mod 100; j := j div 100;
          if (j >= 0) and (j <= 6) then { Legal parameter }
          begin
            case j of
              0: begin spc := atomspc;  k := 12 end;
              1: begin spc := momespc;  k := 7  end;
              2: begin spc := dispspc;  k := 8  end;
              3: begin spc := npolaspc; k := 3  end;
              4: begin spc := dataspc;  k := 4  end;
              5: begin spc := blkspc;   k := 2  end;
              6: begin spc := wavespc;  k := 3  end     { Cte values only }
            end;
            pit := NEWPHYSITM( spc, bdf, nullsy );
            if not bdf then ERROR( mdnam, 101 );
            if (i < 1) or (i > k) then
            begin
              i := 1; ERROR( mdnam, 31 )
            end;
            if j < 6 then               { Variable expr case }
            begin
              eattr := exprattr;
              if bdf then
              with pit^ do
                WRITELN( int, ' ', ORD( ndt ):4, ' ', j:2,
                              ' ', pit^.sequ:6, ' ', i:5 );
              ndt := varbl
            end
            else
            begin                       { Constant case }
              eattr := numkonst;
              if j = 5 then             { Wavevect }
              case i of
                1: rvl := pit^.wav.qx;
                2: rvl := pit^.wav.qy;
                3: rvl := pit^.wav.qz;
              end;
              ivl := 0.0; ndt := konst
            end
          end else ERROR( mdnam, 101 )
        end;
      summop:                           { Summation operator - never executed in mxd phase }
        begin
          NEWSCOPE( bdf );
          if bdf then
          begin
            DECLARENEWIDENT( bdf );
            bdf := not bdf
          end;
          if bdf then
          begin
            with ptid^ do
            begin
              WRITELN( int, ' ', ORD( indxdf ):4,
                            ' ', name.s:ORD( name.l ), ' ', sequnb:6 );
              ptid^.idtyp := indexty    { Set index type }
            end;
            INSYMBOL;
            LOOKSYMBOL( commasy, 85, true );
            { get begin, end and step }
            GETPHYSPARAM; GETPHYSPARAM; GETPHYSPARAM;
            GETPHYSPARAM;               { Get expression to sum }
            WRITELN( int, ' ', ORD( summop ):4 );
	    RELSCOPE
          end else ERROR( mdnam, -444 );
          eattr := exprattr; ndt := varbl
        end
      end                               { Case ndt of };
      LOOKSYMBOL( rparsy, 81, false )
    end;
    primobj := saveobj                  { Restore the original primobj }
end CALLFUNC;



function VAL( p: ptr ): real;
{ To evaluate a data formula }
const
  mdnam = 'VALU';

var
  r:    real;
  syms: item;

begin
  with p^ do
  begin
    r := 0.0;
    if (idtyp = undefine) or (idtyp = paramty) then r := value
    else
      if idtyp = parmacref then
      begin { mini-macro }
        with cntx_heap^.ccnt do
	begin
	  binsert := true; chv := ';'   { To restore the out context mode }
	end;
	p^.idtyp := undefine1;
	syms := sym;
        ACTIVEMACPAR( p, p^.actual, f_mcparm );
        EXPRESSION;
	with primobj do
	begin
	  if (ndt <> nullsy) then
	  begin
	    if eattr = strkonst then CONVINT( primobj );
	    if eattr <> numkonst then ERROR( mdnam, 58 ) else r := rvl
	  end
	end;
	sym := syms
      end
      else ERROR( mdnam, -88 );
  end;
  val := r
end VAL;



procedure GETNUMBER( var i: integer );
{ Get an integer number i from input stream if the colon ":" is present }
begin
  with sym do
    if ndtwd = colonsy then
    begin
      INSYMBOL;
      EXPRESSION;
      with primobj do
      begin
	if ndt <> nullsy then
	begin
	  if eattr = strkonst then CONVINT( primobj );
	  if eattr <> numkonst then ERROR( 'GNBR', 58 )
                               else i := ROUND( rvl )
	end
      end
    end
end GETNUMBER;



procedure PRAGMASTATE( bincl: boolean );
{ To set or reset all option in mxd }
const
  mdnam = 'PRGM';

var
  pc: cntx_ptr;
  ps: stp;
  i:  integer;
  ic: char;
  bpar, bsg, bsp: boolean;

begin { PRAGMASTATE }
  with sym do
  begin
    { Select the required mode }
    if (sy = separator) and (separ = lpar) then
    begin
      bpar := true; INSYMBOL;
    end
    else bpar := false;
    repeat                              { Loop one all options }
      bsp := false;                     { Assume no flag until shown otherwise }
      bsg := true;                      { Assume true until shown otherwise }
      ic  := ' ';                       { Assume illegal option }
      if bpar then
      begin { *** Mode with expression parameters *** }
        ps := nil;
        GETSCTE( ps );
        if ps <> nil then
          with ps^ do
            if l > CHR( 0 ) then ic := s[1];
        if (ic >= 'a') and (ic <= 'z') then ic := CHR( ORD( ic ) - 32 );
        if ndtwd = colonsy then
        begin 
          i := -1;                      { Get a logical expression }
          GETNUMBER( i );
          bsp := (i >= 0);              { Flags the presence of flag }
          bsg := ( i > 0 )              { Can be used as an integer or a number }
        end
      end
      else { *** Mode with cte form of option flag *** }
        if (sy = ident) or (sy = ctstr) then
        begin
          INPUTLETTER( ic );            { Get option letter name }
          INSYMBOL;                     { Get the parameter }
          if (ndtwd = addop) or (ndtwd = subop) then
          begin
            bsp := true;
            bsg := (ndtwd = addop);
            INSYMBOL
          end
        end;

      with cntx_heap^.ccnt do
      case ic of
        'M': bmaclst   := bsg;          { To enable/disable macro expanssion list }

        'P': bparlst   := bsg;          { To enable/disable macro param. exp. list }

        'C': blstmcall := bsg;          { To enable/disable macrocall source }

        'E': becho     := bsg;          { To enable/disable input echo }

        'D': bphys     := bsg;          { To enable/disable Data Listing }

        'N': bincerr   := bsg;          { To enable/disable not exist file error }

        'U': majorfmode := bsg;         { To enable or disable the Unix file specification mode }

        'F': begin { To set an input format specification }
               frspos := 1; lstpos := 120;
               GETNUMBER( frspos );
               GETNUMBER( lstpos );
               if frspos < 1 then frspos := 1;
               if lstpos > 132 then lstpos := 120;
               if (lstpos - frspos) < 20 then
               begin  frspos := 1; lstpos := 120  end
             end;

        'L': begin { To enable/disable source listing generation }
               i := -1;
               GETNUMBER( i );
               if i >= 0 then
               begin { A level is specified }
                 spclvl := i;
                 if bsp then blist := bsg
               end
               else {No level specified }
               begin
                 if bsp then blist := bsg               { Set the flag as specified }
                        else blist := true;             { ... or default to set. }
                 if blist then                          { For + flag set current level }
                   if bincl then spclvl := stkp + 1     { For include }
                            else spclvl := stkp         { For chaine }
               end
             end;

             { To set a special identificator number. Is a Reserved Pragma. }
        'S': if (i > idntseqnb) or (i < 0) then idntseqnb := i;

      otherwise
        ERROR( mdnam, 99 )
      end;
      if ndtwd = commasy then INSYMBOL
    until (sy <> ident) and (sy <> ctstr);
    if bpar then LOOKSYMBOL( rparsy, 81, true )
  end;
  LOOKSEMICOL( false )
end PRAGMASTATE;



procedure PUTRANSOPE( var mt: opmatrix );
var
  i, j, k: integer;
  rv:      real;
  mt1:     trmatrix;

begin
  WRITELN( int, ' 1' );
  for i := 1 to 3 do  for j := 1 to 3 do
  begin
    mt1[i,j] := 0.0;
    for k := 1 to 3 do  mt1[i,j] := mt1[i,j] + mt[i,k] * tmr[j,k]
  end;
  for i := 1 to 3 do  for j := 1 to 3 do
  begin
    rv := 0.0;
    for k := 1 to 3 do  rv := rv + tmd[i,k] * mt1[k,j];
    WRITE( int, ' ', rv:12 )
  end;
  WRITELN( int )
end PUTRANSOPE;



procedure STATELIST( stopper: ndtyp );
{ to execute a list of statement ended by the syntax unit given as stopper }
var
  cursy: ndtyp;


  procedure STATEMENT;
  { execute the current statement }
  const
    mdnam = 'STAT';

  var
    pf: ptr;
    stname: identifier;



    procedure OUTNWLINE;
    { output a data out line on the listing }
    begin
      NEWLINELST; WRITE( lst, ' ':12, stname:10 )
    end OUTNWLINE;



procedure FUNCTIONSTATE;
var
  p: ptr;

  procedure FUNCTIONDEF( var pfu: ptr; bl: boolean );
  const
    mdn = 'FUNC';

  var
    bok:  boolean;
    npa:  integer;
    phde: ptr;

    PROCEDURE FORMALDEF( pfu: ptr );
    { Create the formal parameter list for a function definition }
    { pfu is the function block definition }
    var
      p1, p2: ptr;
      bfunct: boolean;

    begin
      p2 := nil;
      sym.ndtwd := commasy; { simule a pre comma }
      npa := 0; pfu^.forlst := nil;
      with sym do
      while ndtwd = commasy do
      begin
        INSYMBOL; { get the parameter name }
        if ndtwd = usfunctdf then
        begin
          INSYMBOL; { Get function identifier name }
          bfunct := true
        end else bfunct := false;
        DECLARESPECIAL( false, bok ); { creates the formal if possible }
        bok := not bok; { bok = true => success }
        if bok then
        begin
          p1 := ptid; { get the new identifier }
          with p1^ do
          begin { set has existing formal }
            if bfunct then idtyp := functionty else idtyp := formalty;
            { with all appropriate links }
            if pfu^.forlst = nil then
            begin
              { allocate behind all previous parameters }
              if phde = nil then paramhde := p1 else phde^.leftp := p1;
              pfu^.forlst := p1
            end
            else
            begin
              p2^.leftp := p1;
              if p2^.idtyp = functionty then p2^.nxtfor := p1
                                        else p2^.nxtpar := p1
            end;
            leftp := nil; p2 := p1;
            if bfunct then nxtfor := nil else nxtpar := nil;
            if bfunct then { particular case of formal function definition }
              FUNCTIONDEF( p1, true )
            else
              { normal formal definition }
              if not bl then
                WRITELN( int, ' ', ORD( formaldf ):4,
                              ' ', name.s:ORD( name.l ), ' ', sequnb:6 )
          end { with p1^ do }
        end { if bok then };
        npa := npa + 1;
        INSYMBOL { Get the separator }
      end { while ndtwd = commasy };
      LOOKSYMBOL( rparsy, 81, not bl ) { by pass the ")" or error }
    end FORMALDEF;


  begin { FUNCTIONDEF }
    npa := 0;
    phde := paramhde;{ get the end of parameter list in phde }
    if phde <> nil then
      while phde^.leftp <> nil do phde := phde^.leftp;
    if not bl then { new user function }
    begin
      DECLARENEWIDENT( bok ); { Create the function identifier }
      bok := not bok;
      if bok then pfu := sym.ptid
    end
    else bok := true;
    if bok then
    with sym do
    begin
      with pfu^ do
      begin
        idtyp := functionty;
        INSYMBOL;
        if ndtwd = lparsy then FORMALDEF( pfu )
                          else parlst := nil;
        if bl then { formal function }
          WRITELN( int, ' ', ORD( formaldf ):4,
                        ' ', name.s:ORD( name.l ), ' ', sequnb:6 )
        else { real user (not formal) function definition }
        begin
          nxtfor := pfu; { set nxtfor -> function self pointer => no formal }
          LOOKSYMBOL( equop, 65, true );
          GETPHYSPARAM; { Function expression }
          idtyp := functionty; { call now allowed }
          { write the function definition }
          WRITELN( int, ' ', ORD( usfunctdf ):4,
                        ' ', name.s:ORD( name.l ), ' ', sequnb:6, ' ', npa:3 )
        end;
        { now we suppress the formal definitions }
        if phde = nil then paramhde := nil else phde^.leftp := nil;
      end
    end
  end FUNCTIONDEF;


begin { FUNCTIONSTATE }
  FUNCTIONDEF( p, false );
  LOOKSEMICOL( true )
END FUNCTIONSTATE;



procedure REPEATSTATE;
{ To perform a repeat sequence }
const
  mdnam = 'RPTE';

var
  pr:     stp;
  r:      real;
  rptlvl: integer;

begin
  INMACRO( pr, true, untilmd ); { store the repeat sequence }
  if (sym.sy = eofsy) then ERROR( mdnam, -72 ) else
  begin
    repeat
      ACTIVEMACPAR( nil, pr, f_macr );
      rptlvl := stkp;
      STATELIST( untilsy );
      GETNCTE( r );
      { now we return to down level }
      if stkp >= rptlvl then RESETCNTX( rptlvl - 1 )
    until ABS( r ) >= 0.5;
    INSYMBOL
  end;
  FREETEXT( pr ); { free all macro text }
end REPEATSTATE;



procedure MACROSTATE;
{ Procedure to built the macro definition }
const
  mdnam = 'MACR';

var
  pp, ppnd, pmc: ptr;
  p0: stp;
  id: integer;
  bsee: boolean;

begin
  { to get the macro name };
  DECLARESPECIAL( true, bsee );
  if bsee then
  begin
    ERROR( mdnam, -98 );
    INMACRO( p0, false, endmacmd ); { to skip the macro text }
    INSYMBOL
  end else
  with sym do
  begin
    pmc := ptid { take the new macro identifier };
    with pmc^ do
    begin
      idtyp := macroref;
      leftp := paramhde; paramhde := nil;
      { elliminate for the moment all external macro definition }
      id := 0; ppnd := nil; { set to empty the parameter list }
      INSYMBOL; { skip in parameter list }
      with sym do
      while sy = ident do
      begin
        bsee := false;
        if ptid <> nil then bsee := (ptid^.lexlev = -1);
        if bsee then ERROR( mdnam, -97 );
        pp := newide { create and link the new parameter item };
        if ppnd = nil then paramhde := pp
        else
        begin
          ppnd^.leftp  := pp; { Set the SEARCHID link to check for twice }
          ppnd^.nxtpar := pp  { Set the formal link }
        end;
        ppnd := pp;           { Keep the last formal address }
        with pp^ do
        begin { Set each formal field }
          name   := namid;
          lexlev := -1;  nxtpar := nil;
          leftp  := nil; rightp := nil;
          sequnb := id;  id := id + 1;
          idtyp  := undefine; { With replacement disable }
          actual := nil       { and no effective value }
        end;
	INSYMBOL; { skip to separator }
	if ndtwd = commasy then INSYMBOL
      end;
      LOOKSEMICOL( false );
      pp := paramhde;
      { Now turn on all formals as macro parameters }
      { And turn off the SEARCHID link }
      while pp <> nil do
      begin
	pp^.idtyp := parmacref;
        pp := pp^.nxtpar
      end;
      pmc^.parlst := paramhde;    { to attach parameter list to macro item }
      paramhde := pmc { insert new macro in the definition macro list }
      { the parameters are not defined for searchid now }
    end;
    { now we get the macro text }
    INMACRO( pmc^.macpt, true, endmacmd );
    INSYMBOL;
    LOOKSEMICOL( true )
  end
end MACROSTATE;



procedure PURGESTATE;
{ To delete a defined macro }
const
  mdnam = 'PRGM';

var
  p0, p1: ptr;

begin
  with sym do
  while sy = ident do
  begin
    { the identifier must be a macro name }
    if ptid = nil then ERROR( mdnam, 96 ) else
    with ptid^ do
    if (lexlev <> -1) or (idtyp <> macroref) then
      ERROR( mdnam, 95 )
    else
    begin
      { we must take out of ref.list this macro }
      p0 := paramhde; p1 := nil;
      while (p0 <> ptid) and (p0 <> nil) do
      begin
	p1 := p0;
	p0 := p0^.nxtpar
      end;
      { now we take out the macro ident from the SEARCHID list }
      if p1 = nil then paramhde := leftp else p1^.leftp := leftp;
      { now we free all allocated item for this macro }
      leftp := nil; rightp := nil;
      FREEIDE( ptid )
    end;
    INSYMBOL;
    if ndtwd = commasy then INSYMBOL
  end;
  LOOKSEMICOL( true )
end PURGESTATE;



{ procedure to invok a macro }
procedure CALLMACRO;
var
  pmc, pcr, pnd, prv: ptr;
  caller: integer;

begin
  pmc := sym.ptid;    { Keep the macro identifier address }
  pcr := pmc^.parlst; { Get the first macro formal address }
  pnd := nil;
  caller := stkp;     { Keep the call context }
  while pcr <> nil do { Loop on all macro formals }
  with sym do
  with pcr^ do
  begin
    actual := nil;            { Initialize the formal value }
    INPARAM( actual, false ); { Get the effective value of macro formal }
    pnd := pcr;               { Keep the last formal id. address }
    pcr := pcr^.nxtpar        { Skip to next formal }
  end;
  { ignore all macro unused parameters }
  if sym.ndtwd <> smcolsy then SKIP( smcolsy, false );
  if pnd <> nil then  { if some macro formal are existing }
  begin               { we set all macro formal in the SEARCHID list }
    pnd^.leftp := paramhde;
    paramhde   := pmc^.parlst
  end;
  with cntx_heap^, ccnt, fcnt do
    { if macro call an other macro }
    if (fil_mod = f_macr) or (fil_mod = f_mcparm) then
    with maclstln^ do       { out the present expanssion line }
    begin
      if blist then OUTSRCLIST;
      maclstpt := 1;
      l := CHR( 0 )
    end;
  { we run the macro now }
  ACTIVEMACPAR( pmc, pmc^.macpt, f_macr );  { start insymbol on the macro text }
  STATELIST( endmacsy );      { execute all the macro text }
  RESETCNTX( caller );        { return to caller level if end of text not seen }
  { now we deallocate and reset parameter definition }
  if pnd <> nil then
  begin
    pcr := paramhde;  { Look for our macro formal identifier(s) }
    prv := nil;       { Set as no new definitions }
    while (pcr <> nil) and (pcr <> pmc^.parlst) do
    begin
      prv := pcr;     { Get the last previous definition address }
      pcr := pcr^.leftp
    end;
    { Now pcr is the address of the first formal or nil (then ERROR) }
    { Suppress all macro formal from the SEARCHID list }
    if prv = nil then paramhde   := pnd^.leftp  { No new defintion(s) }
                 else prv^.leftp := pnd^.leftp; { With new definitions }
    pnd^.leftp := nil;{ Cancel all formal link to SEARCHID list }
    while pcr <> nil do
    begin
      FREETEXT( pcr^.actual );
      pcr := pcr^.nxtpar
    end
  end;
  LOOKSEMICOL( true )
end CALLMACRO;



procedure IFSTATE;
{ To perform a conditional compilation }
const
  mdnam = 'IFST';

var
  p0:   stp;
  r:    real;
  bexe: boolean;

begin
  GETNCTE( r );
  bexe := (ABS( r ) >= 0.5);
  LOOKSYMBOL( thensy, -71, true );
  if not fatalerror then
  if bexe then
  begin
    STATELIST( elsesy );
    if lststate = elsesy then
    begin
      INMACRO( p0, false, endifmd );
      INSYMBOL { to get ";" }
    end
  end
  else
  begin
    INMACRO( p0, false, elsemd ); { to search "else" or "end" }
    if sym.ndtwd = elsesy then
    begin
      INSYMBOL; { by pass "else" }
      STATELIST( endifsy )
    end else
      INSYMBOL
  end
end IFSTATE;



procedure BEGINSTATE;
{ To create a dynamic block for lacal identifier declaration }
var
  bok: boolean;

begin
  NEWSCOPE( bok );
  STATELIST( endsy );
  if bok then RELSCOPE
end BEGINSTATE;



procedure INCLUDESTATE( nd: ndtyp );
{ To perform the include and chaine statement }
const
  mdnam = 'INCL';

var
  if1, il: integer;
  be, bm, bl, bd, bp, bgo, bnsf, bsave, btt: boolean;
  lvl: integer;
  pfn: stp;

begin
  bgo   := true;
  bsave := not (nd = chainsy);
  pfn   := nil;
  if nd <> mcallsy then GETSCTE( pfn )
                   else COPYSTR( pfn, pmlib, false );
  bgo   := (pfn <> nil);
  with cntx_heap^.ccnt do
  begin { Save the current pragma setup }
    bl  :=  blist; bm := bmaclst; bp   := bparlst;
    be  :=  becho; bd :=   bphys; bnsf := bincerr;
    if1 := frspos; il :=  lstpos; lvl  :=  spclvl
  end;
  if nd <> mcallsy then
    if sym.ndtwd = commasy then begin  INSYMBOL; PRAGMASTATE( bsave )  end
                           else LOOKSEMICOL( false );

  if not bgo then ERROR( mdnam, -18 );

  with cntx_heap^.fcnt do
    if (fil_mod = f_macr) or (fil_mod = f_mcparm) then
      { for Macro or Macro Parameter modes ... }
      if nd <> mcallsy then { ... only the mcall is allowed }
      begin { Include and Chaine or nor allowed in a macro. }
        ERROR( mdnam, -94 );
        bgo := false
      end;

  if bgo and bsave then
  begin
    SAVECNTX;
    with cntx_heap^.ccnt do
    begin
      cmdline := ST_CREATE; { Allocate the new current source line }
      if nd = mcallsy then blist := blstmcall
    end
  end;

  if fatalerror then bgo := false;

  if bgo then
  with sym, cntx_heap^, ccnt, fcnt do
  begin
    if not bsave then
    begin
      ST_FREE( filespecif ); linenbr := 0;
      ch := ' '; cmaj := ' '; categ := eolno
    end;
    filespecif := pfn;
    if bsave then
    begin
      fil_tty := false;
    end;

    fil_mod := f_close;
    if nd = mcallsy then
    begin
      RESETTXTFILE( mlbf, pfn, bgo, btt );
      if bgo then fil_mod := f_maclib
    end
    else
    begin
      if not bsave then
      begin
        if fil_tty then CLOSE( fil_prt );
        CLOSE( fil_ptr )
      end;
      RESETTXTFILE( fil_ptr, pfn, bgo, fil_tty );
      if fil_tty then OPENW_TXTFILE( fil_prt, pfn, 1 );
      if bgo then fil_mod := f_data
    end;


    { none exist or empty file or error  if bgo is false  }
    cntx_heap^.ccnt.beof := not bgo;

    if becho then
      with pfn^ do
        WRITELN( output, ' *** Read Now on "', s:ORD( l ), '".' );

    if bgo then
    begin
      io_status^.value :=  0.0;
      LSTFILESPC;
      INSYMBOL { Read the first word in new opened file }
    end
    else
      if bincerr then ERROR( mdnam, 210 )
  end;
  if bsave then
  with cntx_heap^.prvcntx^.ccnt do
  begin { Restore the call pragma setup for include statement }
    bmaclst :=   bm; bparlst :=  bp;
    becho   :=   be; bphys   :=  bd;
    bincerr := bnsf; frspos  := if1;
    blist   :=   bl;
    lstpos  :=   il;
    io_status^.value :=  1.0;
    if nd = mcallsy then spclvl := stklvl { mcall statement }
                    else spclvl := lvl    { include statement }
  end
end INCLUDESTATE;



procedure MACRLIBSTATE;
{ To set a name as the current macro library file }
var
  ip: integer;
  p1: stp;

begin
  p1 := pmlib;
  if sym.sy = separator then
  begin
    pmlib := p1^.n; ST_FREE( p1 )
  end
  else
  begin
    GETSCTE( pmlib ); pmlib^.n := p1
  end;
  LOOKSEMICOL( true )
end MACRLIBSTATE;



procedure EOFSTATE;
{ To perform the real endfile statement or implicite end-of-file }
var
  bml: boolean;

begin
  with cntx_heap^, ccnt, fcnt do
  if (fil_mod = f_data) or (fil_mod = f_maclib) or (fil_mod = f_close) then
  begin
    bml := (fil_mod = f_maclib);
    case fil_mod of
      f_maclib: CLOSE_TXTFILE( mlbf );
      f_data:   if not fil_tty then CLOSE_TXTFILE( fil_ptr );
    otherwise
    end;
    fil_mod := f_close;

    if becho then
      WRITELN( output, ' *** [EOF] ***' );

    if stkp > 0 then
    begin
      ST_FREE( cmdline );
      ST_FREE( filespecif );
      filespecif := cntx_heap^.ccnt.filespecif;
      RESETCNTX( stkp - 1 );
      if not bml then LSTFILESPC;
      if not bml then INSYMBOL
    end
    else bexit := true;
    io_status^.value :=  0.0
  end else
  begin
    ERROR( 'ENDF', -93 );
    SKIP( smcolsy, true )
  end
end EOFSTATE;



procedure MCALLSTATE;
{ Get a list of macro from the current macro lirary }
{ 64 macro names maximum for one call }
const
  mdnam = 'MCAL';

var
  p0, p1:  stp;
  i, j, k: integer;
  lstname: array[1..64] of nameid;
  fnd:     boolean;

begin
  i := 0;
  while sym.sy = ident do { we store all the name of the list }
  begin
    fnd := false;
    with sym do
      if ptid <> nil then
        fnd := (ptid^.idtyp = macroref);
    if fnd then ERROR( mdnam, 63 )
    else
      if i >= 64 then ERROR( mdnam, -111 )
      else
      begin
        i := i + 1;
        lstname[i] := sym.namid;
        INSYMBOL
      end;
    if sym.ndtwd = commasy then INSYMBOL
  end;
  LOOKSEMICOL( false ); { check for semicolon }
  j := 0; p1 := pmlib;
  while (j < i) and (pmlib <> nil) do
  begin
    { we open the library file }
    INCLUDESTATE( mcallsy );
    while (j < i) and (sym.sy <> eofsy) do
    begin
      { search a macro statement }
      bnostrg := true; { no make the constant string }
      while (sym.ndtwd <> macrosy) and (sym.sy <> eofsy) do
      INSYMBOL;
      if sym.sy <> eofsy then
      with sym do
      begin { we have find a macro, see if wanted }
	INSYMBOL; { Get the macro name in sym.namid }
	k := 0; fnd := false;
	while not fnd and (k < i) do
	begin  k := k + 1;
	  if MATCH( lstname[k], namid ) = 0 then fnd := true
	end;
	if not fnd then
	begin
	  INMACRO( p0, false, endmacmd ); { we skip unwanted macro }
	end else { get the macro }
	begin lstname[k].s[1] := ' '; { reset the name from list }
	  statnbr := statnbr + 1; { to set the statement count }
	  j := j + 1; { indicate the wanted macro }
	  MACROSTATE { and get the macro }
	end
      end { if sy <> eofsy }
    end { one libary while loop };
    EOFSTATE; { Return to normal level  in eof state }
    pmlib := pmlib^.n { skip to next library }
  end;
  pmlib := p1; { restore original pmlib }
  if j < i then
  begin
    ERROR( mdnam, -112 );
    for k := 1 to i do
      with lstname[k] do
      if s[1] <> ' ' then
      begin
        NEWLINELST;
        WRITELN( lst, ' *** Cannot Find "', S:ORD( l ), '".' )
      end
  end;
  INSYMBOL { Release eof state for next statement }
end MCALLSTATE;



procedure INIDATA;
{ To get all pre-existing(to run) data file informations }
var
  bok:      boolean;
  pt0, pt1: physptr;
  rec:      ddirec;

begin
  if bolddata then
  begin
    dtflnbr := -1;
    pt0 := nil; { set list to empty }
    bok := OPEN_DDIFILE( ddi, ddispcfile, false );
    if bok then
    begin
      while not EOF( ddi ) do
      begin
        NEW( pt1, dataspc ); { allocate a new data item }
        if pt0 = nil then phystabhde[dataspc] := pt1
        else pt0^.next := pt1;
        with pt1^ do
        begin
          READ( ddi, rec );
	  sequ := sequphtab[dataspc];
          sequphtab[dataspc] := sequphtab[dataspc] + 1;
          next := nil; used := false;
          name := rec.nam;
          dtf  := rec.inf; { get actual information }
          { set dtflnbr as maximum file number }
          if dtflnbr < dtf.filenbr then dtflnbr := dtf.filenbr
        end;
        pt0 := pt1 { get next data info in ddi file }
      end;
      CLOSE_DDIFILE( ddi )
    end;
    dtflnbr := dtflnbr + 1 { set to first undefined file number }
  end;
  bolddata := false { show that old data was read }
end INIDATA;



procedure DATASTATE;
{ To perform the data reduction statement }
const
  mdnam  = 'DATA';
  maxval = 31;

var
  filstp: stp;
  pfd:    physptr;
  bdf:    boolean;



  procedure SETDATAFILE;
  { prepare the data filname }
  var
    i: integer;

  begin
    { Set the file number as a string }
    filstp := INSTRING( pfd^.dtf.filenbr, 3 );
    with filstp^ do
    begin
      s[4]  := s[1]; s[5]  := s[2]; s[6]  := s[3]; { set the number in place }
      s[1]  :=  'm'; s[2]  :=  'x'; s[3]  :=  'd'; { SET THE "MXD" CHAR }
      s[7]  :=  '.'; s[8]  :=  'b'; s[9]  :=  'd'; { SET FILE EXTENSION }
      s[10] :=  'a'; s[11] :=  '.'; s[12] :=  '1';
      for i := 13 to maxlinesz do  s[i] := ' ';
      l := CHR( 12 )	{ and string length }
    end
  end SETDATAFILE;



  procedure SCRIPTDATA;
  { To write on int file all data associated information }
  var
    ip: integer;

  begin
    with pfd^ do
    begin
      WRITELN( int, ' ', ORD( datasy ):4,
                    ' ', name.s:ORD( name.l ), ' ', sequ:6 );
      with dtf do
      begin
        ip := ORD( filstp^.l );
        WRITELN( int, ' ', ip:3 );
        WRITELN( int, filstp^.s:ip );
        WRITELN( int, ' ', optref:3, ' ', ncp:6, ' ', ncpv:6 );
        WRITELN( int, ' ', hn:6, ' ', hm:6,
                      ' ', kn:6, ' ', km:6,
                      ' ', ln:6, ' ', lm:6 );
        WRITELN( int, ' ', swobs2:16, swobs:16, sobs2:16, sobs:16 )
      end
    end
  end SCRIPTDATA;



  procedure NEWDATASTA;
  { To create a new data structure and file }
  var
    pr, ps, pw, ph, pk, pl, pi, pm, pn, pp, psl, pnpt, p0: ptr;
    nblk, i, j, l, ibase, idpol: integer;
    jh, jk, jl, vl, vs, va, vb, vc: real;
    bdw, bpol: boolean;
    pwv, ppo:  physptr;
    tabval: array[0..maxval] of ptr;
    tabvdf: array[0..maxval] of real;



    procedure DEFSYMBOL( var snam: [readonly] packed array[$l..$u:integer] of char;
                         invl: real; var p: ptr );
    { to create the predefined identifiers }
    var
      i, sz:   integer;
      nam:     nameid;

    begin
      sz := $u - $l + 1;
      nam.l := CHR( sz );
      for i := 1 to sz do nam.s[i] := snam[i];
      for i := sz+1 to maxidsize do nam.s[i] := ' ';
      SEARCHID( nam, p, true );
      with p^ do
      begin
        value   := invl;
        parattr := numkonst;
        idtyp   := undefine
      end
    end DEFSYMBOL;



    procedure DATAPROLOGUE;
    { To get all data organization from the data  statement }
    var
      proot: ptr;

    begin
      NEWSCOPE( bdw );
      ibase := idntseqnb;
      DEFSYMBOL( 'SF'    , 0.0, p0   ); DEFSYMBOL( 'F2'    , 0.0, p0 );
      DEFSYMBOL( 'RAY'   , 0.0, p0   ); DEFSYMBOL( 'SG'    , 0.0, ps );
      DEFSYMBOL( 'WE'    , 1.0, pw   ); DEFSYMBOL( 'IH'    , 0.0, ph );
      DEFSYMBOL( 'IK'    , 0.0, pk   ); DEFSYMBOL( 'IL'    , 0.0, pl );
      DEFSYMBOL( 'IS'    , 1.0, pi   ); DEFSYMBOL( 'MUL'   , 1.0, pm );
      DEFSYMBOL( 'NQ'    , 0.0, pn   ); DEFSYMBOL( 'NPOLA' , 0.0, pp );
      DEFSYMBOL( 'SELNB' , 0.0, psl  );
      DEFSYMBOL( '$NPT'  , 1.0, pnpt );
      with pnpt^ do
      begin
        idtyp := paramty; parattr := numkonst
      end;
      pfd^.dtf.optref := -1;
      with sym do
      begin
        if ndtwd = rparsy then ERROR( mdnam, 151 ) else
        if ndtwd <> commasy then ERROR( mdnam, 85 )
                            else INSYMBOL;
        if ndtwd = lparsy then
        begin
          INSYMBOL; GETPHYSPARAM; { scale expr }
          if primobj.ndt = nullsy then ERROR( mdnam, 152 );
          GETPHYSPARAM; { $fn2 correction }
          GETPHYSPARAM; { $fm2 correction }
          GETPHYSPARAM; { dynamic weight coef. }
          if ndtwd = rparsy then INSYMBOL
                            else ERROR( mdnam, 81 );
          if ndtwd = commasy then INSYMBOL
        end else
        begin
          GETPHYSPARAM; { get the attached scale definition }
          for i := 1 to 3 do
            writeln( int, ' ', ORD( nullsy ):4 { nil })
        end
      end;
      proot := nil;
      with sym do { Get formula specifications }
      if sy <> separator then
      repeat
        p0 := ptid;
        if sy <> ident then
        begin  ERROR( mdnam, 61 ); INSYMBOL  end
        else
        if p0 = nil then
        begin  ERROR( mdnam, 153); INSYMBOL  end
        else
        begin
          with ptid^ do { for data field duplicate in pre-defined }
            if (idtyp = dtfieldty) and (lexlev <> stkl) then
            begin
              DEFSYMBOL( name.s, 0.0, p0 );
              pvalue := p0
            end;
          if p0^.idtyp <> undefine then
          begin  ERROR( mdnam, 153 ); INSYMBOL  end
          else
          with p0^ do
          begin
            idtyp := undefine1;{ as formula def. but not actual parameter }
            i := sequnb - ibase;
            if i < 3 then
            with pfd^.dtf do
            begin
              pr := p0;
              if optref = -1 then optref := i else ERROR( mdnam, 154 )
            end;
            nxtpar := proot; proot := p0;
            INSYMBOL;
            if ndtwd <> equop then ERROR( mdnam, 90 )
                              else INPARAM( actual, true )
          end
        end;
        if ndtwd = commasy then INSYMBOL
      until sy = separator;
      if sym.ndtwd <> rparsy then ERROR( mdnam, -81 );
      while proot <> nil do
      with proot^ do
      begin
        idtyp := parmacref; proot := nxtpar
      end;
      INSYMBOL; { Skip to list of reflexion format }
      { Get parameter order }
      l := 0;
      with sym do
      if sy <> ident then ERROR( mdnam, -61 ) else
      repeat
        p0 := ptid;
        if ptid <> nil then
          if ptid^.lexlev <> stkl then ptid := nil;
        if ptid = nil then
        begin { Undefined or dtfield identifier }
          SEARCHID( namid, ptid, true );
          tabval[l] := ptid;
          if p0 <> nil then if p0^.idtyp = dtfieldty then p0^.pvalue := ptid;
          with ptid^ do
          begin
            idtyp := paramty; parattr := numkonst; value := 0.0
          end;
          tabvdf[l] := 0.0
        end else { pre-defined identifier }
        if ptid^.idtyp <> undefine then ERROR( mdnam, -155 )
        else
        begin
          if (ptid = pm) or (ptid = pw) or
             (ptid = pi) then tabvdf[l] := 1.0
                         else tabvdf[l] := 0.0;
          ptid^.idtyp := paramty;
          i := ptid^.sequnb - ibase; tabval[l] := ptid;
          with ptid^ do
            if i < 3 then
            with pfd^.dtf do
            begin
              pr := ptid;
              if optref = -1 then optref := i else ERROR( mdnam, 154 )
            end
        end;
        p0 := ptid;
        INSYMBOL;
        if (ndtwd = equop) or (ndtwd = assignop) then
        begin
          INSYMBOL; GETNCTE( tabvdf[l] )
        end
        else
          if (sy <> separator) then ERROR( mdnam, 91 )
          else
            if ndtwd = commasy then INSYMBOL;
        l := l + 1
      until (l > maxval) or (sy <> ident) ;
      if l > maxval then ERROR( mdnam, -19 );
      LOOKSEMICOL( true )
    end DATAPROLOGUE;



    procedure DATAMNG;
    { Read the data, execute the data directives,
      and performs the data reduction }
    const
      maxffrmsh = 6;

    var
      rec: datrec;

    begin
      { initial clear of reflexion/hkl counts ans summations }
      with pfd^.dtf do
      begin
        swobs := 0.0; sobs := 0.0; swobs2 := 0.0; sobs2 := 0.0;
        hm := -1000; km := hm; lm := hm;
        hn :=  1000; kn := hn; ln := hn;
        ncp := 0; ncpv := 0
      end;
      l := l - 1; nblk := 0;
      j := -1; { select the no-modulated mod }
      idpol := -1; { select the non-polarized mode }
      if cntx_heap^.ccnt.bphys then
      begin
        OUTNWLINE; WRITELN( lst );
        OUTNWLINE; WRITE( lst, ' REF#   H  K  L  M  N ' );
        WRITELN( lst,
           '  OBS   SIGMA   WEIGHT    1/2*D     INTERPOLATED ARRAY VALUES' );
        OUTNWLINE; WRITELN( lst )
      end;
      { read the reflexions }
      while  (sym.sy <> eofsy) and not bexit and
             ((nblk > 0) or (sym.ndtwd <> endsy)) do
      with sym do
      begin
        if sy = ident then
        begin
          if ndtwd = includesy then
          begin
            INSYMBOL;
            INCLUDESTATE( includesy );
            nblk := SUCC( nblk )
          end else
          if ndtwd = wavevsy then
          begin
            INSYMBOL;
            pwv := NEWPHYSITM( wavespc, bdw, lparsy );
            if not bdw then ERROR( mdnam, -101 );
            LOOKSYMBOL( rparsy, 81, true );
            LOOKSEMICOL( true );
            with pwv^.wav do
            begin  va := qx; vb := qy; vc := qz end;
            if cntx_heap^.ccnt.bphys then
            begin
              OUTNWLINE;
              with pwv^ do
                WRITELN( lst, ' ':10, '"', name.s:ORD( name.l ),
                              '" IS SET AS CURRENT WAVE VECTOR.' )
            end;
            j := pwv^.sequ
          end else
          if ndtwd = npoladirsy then
          begin
            INSYMBOL;
            ppo := NEWPHYSITM( npolaspc, bpol, lparsy );
            if not bpol then ERROR( mdnam, -101 );
            if cntx_heap^.ccnt.bphys then
            begin
              OUTNWLINE;
              with ppo^ do
                WRITELN( lst, ' ':10, '"', name.s:ORD( name.l ),
                              '" IS SET AS CURRENT POLARIZATION DIR.' )
            end;
	    idpol := ppo^.sequ;
            LOOKSYMBOL( rparsy, 81, true );
            LOOKSEMICOL( true )
          end else
          if ndtwd = endsy then
          begin
            if nblk > 0 then
            begin
              nblk := PRED( nblk );
              EOFSTATE
            end
          end else ERROR( mdnam, -156 );
        end
        else
        begin { read a reflexion }
          for i := 0 to l do
          begin
              vl := tabvdf[i];    { get the default value }
              INDATA( vl, bpol ); { read a value if found }
              with tabval[i]^ do
                value := vl;
              if (i < l) and (sy = ident) then ERROR( mdnam, -157 );
              if bpol and (tabval[l] <> pp) then ERROR( mdnam, -158 );
          end;
          { skip all data until eoln }
          if (sy <> eofsy) and (sy <> eolnsy) then
          begin
              while (categ <> eolno) and (categ <> eofo) do INCHAR;
              bline := true; insymbol; bline := false
          end;
          { now we built the data record }
          with rec do
          begin
            h  := ROUND( VAL( ph ) );
            k  := ROUND( VAL( pk ) );
            l  := ROUND( VAL( pl ) );
            m  := ROUND( VAL( pm ) );
            if m <= 0 then ERROR( mdnam, 159 );
            nq := ROUND( VAL( pn ) );
            mlq := j { set the correct wave vector number };
            is := ROUND( VAL( pi ) );
            if is <> 0 then
            with pfd^.dtf do
            begin
              if h > hm then hm := h; if h < hn then hn := h;
              if k > km then km := k; if k < kn then kn := k;
              if l > lm then lm := l; if l < ln then ln := l;
              i := (ABS( ROUND( VAL( psl ) ) ) mod (maxsel + 1)) * 64;
              if is > 0 then is := is mod 64 + i
                        else is := -((-is) mod 64 + i);
              ipl := idpol;
              refcat := ROUND( VAL( pp ) );
              if is > 0 then
              begin
                ncpv := ncpv + 1;
                dobs := VAL( pr ); sig := VAL( ps ); pds := VAL( pw );
                sobs := sobs + dobs; swobs := swobs + pds * dobs;
                sobs2 := sobs2 + sqr( dobs ); swobs2 := swobs2 + sqr( pds*dobs )
              end else
              begin
                dobs := 0.0; sig := 0.0; pds := 0.0
              end;
              he := tmr[1,1]*h+tmr[1,2]*k+tmr[1,3]*l;
              ke := tmr[2,1]*h+tmr[2,2]*k+tmr[2,3]*l;
              le := tmr[3,1]*h+tmr[3,2]*k+tmr[3,3]*l;
              if j > -1 then
              begin
                jh := he + nq * va;
                jk := ke + nq * vb;
                jl := le + nq * vc
              end else begin jh := he; jk := ke; jl := le end;
              vl := SQRT( SQR( jh ) + SQR( jk ) + SQR( jl ) )/2.0;
              stsl := vl;
              for i := 0 to maxffrm do
              if ffrmptab[i] <> nil then
              begin
                with ffrmptab[i]^ do
                if idtyp = dtfieldty then vs := VAL( pvalue )
                                     else vs:= INTERPOL( ffrmptab[i], vl );
                tbdif[i] := vs
              end
              else tbdif[i] := 0.0;
              { output the report form listing }
              if cntx_heap^.ccnt.bphys then
              begin
                OUTNWLINE;
                WRITE( lst, ncp+1:5, '/', h:3, k:3, l:3, m:3, nq:3 );
                if is >= 0 then                                        
                  WRITE( lst, '!', dobs:7:2, sig:7:2, pds:10, '!', is:2 )
                else
                  WRITE( lst, ' ':28 );
                WRITE( lst, stsl:7:4 );
                for i := 0 to maxffrmsh do  WRITE( lst, tbdif[i]:6:2 );
                WRITELN( lst );
              end;
              i := is
            end { if is <> 0 then } else i := 0
          end { with rec do };
          if i <> 0 then
          begin
            WRITE( bdt, rec );
            with pfd^.dtf do
            begin  ncp := ncp + 1; pnpt^.value := ncp  end;
          end { if i <> 0 then };
          if sy = eolnsy then INSYMBOL
        end;
        if (sy = ident) and (ndtwd = eofsym) then sy := eofsy;
        if (sy = eofsy) and (nblk > 0) then
        begin sy := ident; ndtwd := endsy end
      end
    end DATAMNG;



  begin { NEWDATASTA }
    bnewdata := true;     { set to save ddi information at the mxdcmp exit time }
    DATAPROLOGUE;         { Get data input specification }
    SETDATAFILE;          { Creates the data filename }
    OPEN_BDTFILE( bdt, filstp );
    DATAMNG;              { Proceeds to the data reduction }
    CLOSE_BDTFILE( bdt );	{ close data file }
    INSYMBOL;             { To skip end }
    RELSCOPE              { Return to the original scope }
  end NEWDATASTA;



  procedure EXTDATASTA;
  { create a pre-existing data reference }
  begin
    with sym do
    begin
      LOOKSYMBOL( rparsy, 81, true );
      LOOKSYMBOL( equop,  90, true )
    end;
    GETPHYSPARAM;
    if primobj.ndt = nullsy then ERROR( mdnam, 103 );
    GETPHYSPARAM; GETPHYSPARAM; { Get $fn2 and $fm2 correction factors }
    GETPHYSPARAM;               { Get the dynamic weight correction coefficien }
    SETDATAFILE                 { Build the data filename }
  end EXTDATASTA;



begin { DATASTATE }
  INIDATA;  { If ddi not cleared then get old ddi info. }
  pfd := NEWPHYSITM( dataspc, bdf, lparsy ); { Locates or creates data item }
  if bdf then { if data collection already defined }
  begin
    if pfd^.used then { if already used then error }
    begin
      ERROR( mdnam, -102 );
      SKIP( smcolsy, false )
    end else
      if sym.ndtwd = commasy then { supersed old data } NEWDATASTA
                             else { call old data col. } EXTDATASTA
  end
  else { new data col. to creat }
  begin
    with pfd^ do
    begin
      dtf.filenbr := dtflnbr; { allocate a file number }
      used := true { flag to used data col. }
    end;
    dtflnbr := dtflnbr + 1; { update future file number }
    NEWDATASTA { process new data }
  end;
  SCRIPTDATA; { Write all data information on int file }
  LOOKSEMICOL( true )
end DATASTATE;



procedure CLRDATASTATE;
{ Flush all previously( to run) data structure }
begin
  if bolddata then bolddata := false
              else ERROR( 'CLRD', -171 );
  LOOKSEMICOL( true )
end CLRDATASTATE;



procedure CONTRIBSTATE;
{ Define a contribution identifier }
const
  mdnam = 'CNTR';

var
  pid:         ptr;
  pit:         physptr;
  bdf, bl, bn: boolean;

begin
  with sym do
  if (sy <> ident) then
  begin
    ERROR( mdnam, 61 ); SKIP( smcolsy, true )
  end
  else
  begin
    bl := (ptid = nil); bn := false;
    if bl then
    begin
      DECLARENEWIDENT( bl ); { create the new identifier }
      ptid^.idtyp := contrty;
      bn := true { flag the creation symbol mode }
    end
    else
      if ptid^.idtyp <> contrty then ERROR( mdnam, 111 );
    pid := ptid; { save pvc pointer }
    INSYMBOL;
    repeat
      pit := NEWPHYSITM( atomspc, bdf, nullsy );
      IF NOT BDF THEN ERROR(MDNAM,101) ELSE
      WRITE( int, ' ', ORD( uctrdefsy ):4, ' ', ORD( bn ):2, ' ' );
      with pid^ do
      begin
	if bn then WRITE( int, name.s:ORD( name.l ), ' ');
	WRITELN( int, sequnb:6, ' ', pit^.sequ:6 )
      end;
      bn := false; { now the identifier is defined }
      if ndtwd = commasy then INSYMBOL
                         else  if ndtwd <> smcolsy then ERROR( mdnam, 87 )
    until (ndtwd = smcolsy) or (ndtwd = eofsym);
    INSYMBOL { TO SKIP SEMICOLON }
  end
end CONTRIBSTATE;



procedure VARIABLESTATE;
{ Variable declaration statement }
var
  pvr:        ptr;
  bl:         boolean;
  vval, vsig: real;

begin
  with sym do
  repeat
    DECLARENEWIDENT( bl ); { Create the new identifier structure }
    if bl then { declare variable error }
      SKIP( commasy, true )
    else
    begin { if it-is ok }
      pvr := ptid;
      pvr^.idtyp := varty; vval := 0.0; vsig := 0.0;
      INSYMBOL; { get separator or = }
      if (ndtwd = equop) or (ndtwd = assignop) then
      begin
        INSYMBOL; GETNCTE( vval );
        if ndtwd = colonsy then { sigma is specified }
        begin  INSYMBOL; GETNCTE( vsig )  end
      end
      else
	if ndtwd = commasy then INSYMBOL;
      with pvr^ do
        WRITELN( int, ' ', ORD( varbldf ):4, ' ', name.s:ORD(name.l),
                      ' ', pvr^.sequnb:6, ' ', vval:12, ' ', vsig:12 )
    end;
  until (sy <> ident) and (sy <> ctint);
  LOOKSEMICOL( true )
end VARIABLESTATE;



procedure ASSIGNPARSTATE( blst: boolean );
{ Parameter statement statement }
const
  mdnam = 'ASSP';

var
  pvr: ptr; pst:             stp;
  storg, stst, xc, yc, lstp: real;
  ips:                       integer;
  p0, p1:                    ditbpt;

  procedure LOCATETAB( var x, y, lstp: real;
                       var ips:        integer;
                       var lsp, crp:   ditbpt);
  { To locate an arrctety ellement:
     if not found ips is set to zero else :
       ips is the table subcript,
       the table segment is pointed by crp,
       x and y are the point coordinates, and
     in all case lsp is the last or current step }
  var
    bfn: boolean;
    ip:  integer;
    xc:  real;

  begin { LOCATETAB }
    ip := 0;
    bfn := false; lsp := nil;
    while not bfn and (crp <> nil) do
    begin
      with crp^ do
      begin
	xc := org; ip := 0;
	lstp := stp;
	while (x > xc) and (ip < lentab) do
	begin  ip := SUCC( ip ); xc := xc + stp end;
	bfn := (x <= xc)
      end;
      if not bfn then
      begin
	lsp := crp; crp := lsp^.next
      end
    end;
    if bfn then
    begin
      ips := ip; x := xc; y := crp^.tabl[ip]
    end
    else ips := -1
  end LOCATETAB;


  procedure INITFRM( var pt: ditbpt; var o, st: real );
  begin
    pt := newdftb;
    with pt^ do
    begin
      next := nil; org := o; stp := st; lentab := 0
    end
  end INITFRM;


begin { ASSIGNPARSTATE }
  p1 := nil;
  xc := 0.0;
  with sym do
  begin
    pvr := ptid; { keep the identifier pointer }
    INSYMBOL; { Get "=" or "(" }
    if ndtwd = lparsy then { arrctety case }
    begin
      INSYMBOL;
      storg := -1.0; stst := 1.0; yc := 1.0;
      GETNCTE( storg ); GETNCTE( stst ); stst := ABS( stst );
      if ndtwd <> rparsy then ERROR( mdnam, -81 ) else INSYMBOL;
      if (ndtwd <> equop) and (ndtwd <> assignop) then ERROR( mdnam, 90 );
      INSYMBOL;
      with pvr^ do
      begin
	if idtyp = paramty then { new table }
	if parattr <> nullattr then ERROR( mdnam, -64 ) else
	begin
	  idtyp := arrctety;
	  idex := -1; { set to none allocated form factor index }
	  INITFRM( pttab, storg, stst);
          p0 := nil; p1 := pttab
	end
	else { modified existing table }
	begin
	  p0 := nil; p1 := pttab; xc := storg;
	  LOCATETAB( xc, yc, lstp, ips, p0, p1 );
	  if (ips = 0) and (p0 = nil) then { complet table superseded }
	  begin
	    p1^.org := storg; p1^.stp := stst; xc := storg; lstp := stst
	  end;
	  if ips >= 0 then { found point }
	  begin
	    p1^.lentab := ips; { truncate table }
	    if p1^.next <> nil then fredftb(p1^.next);
	    if (ABS( storg-xc ) >= 1.0e-5) or (ABS( lstp-stst ) >= 1.0e-5)
	      then ips := -1; { we must creat a new segment }
	    p1^.next := nil; p0 := p1
	  end;
	  if ips < 0 then
	  begin
	    INITFRM( p1, storg, stst );
	    p0^.next := p1
	  end
	end
      end;
      xc := storg;
      if ndtwd <> lparsy then ERROR( mdnam, 82 )
                         else INSYMBOL;
      repeat
	GETNCTE( yc ); { get a value from list }
	if p1^.lentab >= diftabln then
	begin INITFRM( p0, xc, stst ); p1^.next := p0; p1 := p0  end;
	xc := xc + stst;
	with p1^ do
	begin  tabl[lentab] := yc; lentab := lentab + 1 end
      until (sy = separator) or (sy = eofsy);
      if ndtwd <> rparsy then ERROR( mdnam, 81 ) else INSYMBOL
    end  { if "(" seen after the identifier name }
    else { other assignation forms }
    if pvr^.idtyp = arrctety then ERROR( mdnam, -64 ) else
    begin { all none array parameter case }
      if (ndtwd = equop) or (ndtwd = assignop) then
      begin
	INSYMBOL;
	with pvr^ do
	case parattr of
	  nullattr: { declaration parameter }
	    begin
	      VALUEEXPRESSION;
              parattr := primobj.eattr;
	      case primobj.eattr of
		nullattr: ERROR( mdnam, 78 );
		strkonst: stpt := primobj.pstr;
		numkonst: value := primobj.rvl;
		varblattr,exprattr:
		begin
		  WRITELN( int, ' ', ORD( parmdf ):4,
                                ' ', name.s:ORD( name.l ), ' ', sequnb:6 );
		  parattr := exprattr
		end
	      end
	    end;
	  strkonst:
	    begin
	      GETSCTE( pst );
              ST_FREE( stpt );
              stpt := pst
	    end;
	  numkonst: GETNCTE( value );
	  varblattr,exprattr: begin
				ERROR( mdnam, 79 ) { illegal case };
				SKIP( commasy, false )
			      end
	end
      end
      else ERROR( mdnam, 65 )
    end;
    if blst then
    begin
      if ndtwd = commasy then INSYMBOL
    end
    else LOOKSEMICOL( true )
  end { with sym do }
end ASSIGNPARSTATE;



procedure PARAMSTATE;
{ Parameter declaration statement }
var
  pvr: ptr; bl: boolean;

begin
  with sym do
  repeat
    DECLARENEWIDENT( bl ); { create the new identifier structure }
    if not bl then
    begin { if it-is ok }
      pvr := ptid;
      with pvr^ do
      begin  idtyp := paramty; parattr := nullattr  end;
      ASSIGNPARSTATE( true ) { complet the definition in list mode }
    end else SKIP( commasy, true )
  until (sy <> ident) and (sy <> ctint);
  LOOKSEMICOL( true )
end PARAMSTATE;



procedure ASSIGNFFSTATE;
{ To assign an index to each form factor table }
const
  mdnam = 'FFAS';

var
  ida: integer;
  pff: ptr;
  bl:  boolean;

begin
  with sym do
  while (sy = ident) or (sy = ctint) do
  begin
    if sy = ctint then pff := nil else pff := ptid;
    if sy = ident then
      if pff <> nil then
        with pff^ do
	if lexlev <> stkp then
	  if (idtyp <> arrctety) and (idtyp <> dtfieldty) then pff := nil;
    if pff = nil then
    begin
      DECLARENEWIDENT( bl );
      if not bl then
	with ptid^ do
	begin  idtyp := dtfieldty; pvalue := nil; idex := -1  end
    end;
    pff := ptid;
    INSYMBOL;
    ida := 0; { set to automatic default mode }
    GETNUMBER( ida ); { get an index value if given }
    if pff = nil then ERROR( mdnam, 51 ) else
    with pff^ do
      if (idtyp <> arrctety) and (idtyp <> dtfieldty) then
	ERROR( mdnam, 69 )
      else
      begin
	if idex = -1 then { none assigned case }
	if ida <> 0 then
	begin
	  if ida < 0 then ida := maxffrm + 1 + ida else ida := ida - 1;
	  if ida <= maxffrm then
	    if ffrmptab[ida] = nil then
	    begin  ffrmptab[ida] := pff; idex := ida
	    end else ERROR( mdnam, 4 ) { already allocated index }
	  else ERROR( mdnam, 4 ) { out of range given index }
	end
	else
	begin
	  idex := SETNEWFFRM( pff );
	  if idex = -1 then ERROR( mdnam, 4 ) { index table overflow }
	end else ERROR( mdnam, 159 )
      end;
    if ndtwd = commasy then INSYMBOL
  end { while };
  LOOKSEMICOL( true )
end ASSIGNFFSTATE;



procedure FIXEDSTATE( ndsy: ndtyp );
{ To fix or unfix variable statement }
const
  mdnam = 'FIXD';

begin
  with sym do
  while sy = ident do
  begin
    if (ptid = nil) then ERROR( mdnam, 51 ) else
    with ptid^ do
    if idtyp <> varty then ERROR( mdnam, 75 ) else
    begin
      WRITELN( int, ' ', ORD( ndsy ):2, ' ', sequnb:6 )
    end;
    INSYMBOL;
    if ndtwd = commasy then INSYMBOL
  end;
  LOOKSEMICOL( true )
end FIXEDSTATE;



procedure LIMITSTATE;
{ To set some variable limits }
const
  mdnam = 'LMTS';

var
  p0: ptr; v1,v2: real;

begin
  v2 := 1.0E+10;
  v1 := - v2;
  with sym do
  if ndtwd <> varbl then
  begin
    GETNCTE( v1 ); GETNCTE( v2 ); { get limits range specifications }
    while sy = ident do
    begin
      if ndtwd <> varbl then ERROR( mdnam,75 ) else
	WRITELN(INT,ORD(LIMITSSY):4,' ',PTID^.SEQUNB:6,' ',V1:14,' ',V2:14);
      INSYMBOL;
      if ndtwd = commasy then INSYMBOL
    end
  end else
  begin
    p0 := ptid; INSYMBOL;
    if ndtwd <> commasy then ERROR( mdnam, 85 )
                        else INSYMBOL;
    GETNCTE( v1 );
    GETNCTE( v2 );
    WRITELN( int, ' ', ORD( limitssy ):4, ' ', p0^.sequnb:6,
                  ' ', v1:14, ' ', v2:14 )
  end;
  LOOKSEMICOL( true )
end LIMITSTATE;



procedure ASSIGNVARSTATE;
{ Variable assignation statement }
const
  mdnam = 'ASSV';

var
  p0: ptr; vl, vs: real;

begin
  with sym do
  begin
    p0 := ptid;
    INSYMBOL;
    if (ndtwd <> equop) and (ndtwd <> assignop) then ERROR( mdnam, 90 )
                                                else INSYMBOL;
    GETNCTE( vl );
    if ndtwd = colonsy then
    begin  INSYMBOL; GETNCTE( vs )  end else vs := 0.0;
    LOOKSEMICOL( true )
  end;
  with p0^ do
    WRITELN( int, ' ', ORD( assignvarsy ):4, ' ',
                  sequnb:6, ' ', vl:14, ' ', vs:14 )
end ASSIGNVARSTATE;



procedure ATOMESTATE( bct: boolean );
{ Atom declaration statement }
const
  mdnam = 'ATOM';

var
  pfa: physptr;
  bdf: boolean;
  icp: integer;

begin
  pfa := NEWPHYSITM( atomspc, bdf, lparsy );
  if bdf then ERROR( mdnam, 102 );
  LOOKSYMBOL( rparsy, 81, true );
  LOOKSYMBOL( equop, 90, true );
  bdf := false;
  for icp := 1 to 12 do
  begin
    GETPHYSPARAM;
    bdf := bdf or (primobj.ndt <> nullsy)
  end;
  if not bdf then ERROR( mdnam, 103 );
  with pfa^ do
    WRITELN( int, ' ', ORD( atomsy )-ORD( bct ):4,
                  ' ', name.s:ORD( name.l ), ' ', sequ:6 );
  LOOKSEMICOL( true )
end ATOMESTATE;



procedure MOMENTSTATE;
{ Magnetic moment declaration statement }
const
  mdnam = 'MOME';

var
  pfm, pfa, pfw: physptr;
  bdf, bdw:      boolean;
  icp:           integer;

begin
  pfw := nil;
  bdw := false;
  pfm := NEWPHYSITM( momespc, bdf, lparsy );
  if bdf then ERROR( mdnam, 102 );
  pfa := NEWPHYSITM( atomspc, bdf, commasy );
  if not bdf then ERROR( mdnam, 101 );
  if sym.ndtwd = commasy then
  begin
    pfw := NEWPHYSITM( wavespc, bdw, commasy );
    if not bdw then ERROR( mdnam, 101 )
  end;
  LOOKSYMBOL( rparsy, 81, true );
  looksymbol( equop, 90, true );
  bdf := false;
  for icp := 1 to 7 do
  begin
    GETPHYSPARAM;
    bdf := bdf or (primobj.ndt <> nullsy)
  end;
  if not bdf then ERROR( mdnam, 103 );
  with pfm^ do
    WRITE( int, ' ', ORD( momentsy ):4, ' ',
                name.s:ORD( name.l), ' ', sequ:6, ' ', pfa^.sequ:6 );
  if bdw then WRITELN( int, ' ', pfw^.sequ:6 )
         else WRITELN( int,'     -1' );
  LOOKSEMICOL( true )
end MOMENTSTATE;



procedure LATTICESTATE;
{ Statement to define general lattice extinction condition }
const
  mdnam   = 'LATT';
  lattice = 'PABCIHF ';

var
  i:      integer;
  ic:     char;
  latide: identifier;

begin
  latide := lattice;
  INPUTLETTER( ic );
  if (ic = 'R') or (ic = 'r') or (ic = 'h') then ic := 'H';
  i := 1;
  while (i < 8) and (latide[i] <> ic) do i := i + 1;
  if i < 8 then WRITELN( int, ' ', ORD( latticesy ):4, i:4 )
           else ERROR( mdnam, -107 );
  INSYMBOL;
  LOOKSEMICOL( true )
end LATTICESTATE;



{ Build direct and reciprocal unit cell, cartesian transformation matrixs }
procedure CELLSTATE( brh: boolean );
const
  mdnam = 'CELL';

var
  sal, sbe, sga: real;
  i, j:          integer;

  procedure INVMAT;
  { to do (3*3) matrix inversion }
  var
    i, j, ik, jk, ir, jr: integer;
    det: real;

  begin
    {  computs tmr = transposed of invers of tmd matrix }
    det := 0.0;
    for i:= 1 to 3 do
    begin ik := i mod 3 + 1; ir := ik mod 3 + 1;
      det := det + tmd[i,1] * (tmd[ik,2]*tmd[ir,3] - tmd[ik,3]*tmd[ir,2])
    end;
    for i := 1 to 3 do for j := 1 to 3 do
    begin
      ik := i mod 3 + 1; ir := ik mod 3 + 1;
      jk := j mod 3 + 1; jr := jk mod 3 + 1;
      tmr[i,j] := (tmd[ik,jk]*tmd[ir,jr]-tmd[ir,jk]*tmd[ik,jr])/det
    end;
  end INVMAT;

  procedure PERMUT( var r1, r2: real );
  var
    t: real;

  begin
    t := r2; r2 := r1; r1 := t
  end { PERMUT };

begin { CELLSTATE }
  { Read unit cell parameter }
  da := 0.0;
  GETNCTE( da ); if da = 0.0 then ERROR( mdnam, 104 );
  db := da; dc := da; dal := 0.0;
  GETNCTE( db ); GETNCTE( dc ); GETNCTE( dal );
  dbe := dal; dga := dal;
  GETNCTE( dbe ); GETNCTE( dga );
  { now we comput the direct and reciprocal parameter }
  if dal > 1.0 then dal := COS( inrd * dal );
  if dbe > 1.0 then dbe := COS( inrd * dbe );
  if dga > 1.0 then dga := COS( inrd * dga );
  sal := SQR( dal ); sbe := SQR( dbe ); sga := SQR( dga );
  dvol := da*db*dc*SQRT( 1.0 + 2.0*dal*dbe*dga - sal - sbe - sga );
  if dvol <= 0.0 then ERROR( mdnam, -105 );
  rvol := 1.0 / dvol ;
  sal := SQRT( 1.0 - sal );
  sbe := SQRT( 1.0 - sbe );
  sga := SQRT( 1.0 - sga );
  ral := (dbe*dga - dal)/(sbe*sga);
  rbe := (dga*dal - dbe)/(sga*sal);
  rga := (dal*dbe - dga)/(sal*sbe);
  ra := db*dc*sal/dvol;
  rb := dc*da*sbe/dvol;
  rc := da*db*sga/dvol;
  { select the exchange direct and reciprocal unit cell }
  if rvol > 1.0 then
  begin
    PERMUT(  da,  ra ); PERMUT(  db,  rb ); PERMUT(  dc,  rc );
    PERMUT( dal, ral ); PERMUT( dbe, rbe ); PERMUT( dga, rga );
    PERMUT( dvol, rvol )
  end;
  { comput the tmr and tmd matrix }
  if brh and (dal <> dbe) and (dal <> dga) and (da <> db) and
    (da <> dc) then begin  ERROR( mdnam, -106 ); brh := false  end;
  if brh then
  begin
    sga := SQRT( 1.0 - dal ); sbe := SQRT( 1.0 + 2.0*dal );
    sal := da*(sbe + 2.0*sga)/3.0; sbe := da*(sbe - sga)/3.0;
    for i := 1 to 3 do  for j := 1 to 3 do
      if i = j then tmd[i,j] := sal
               else tmd[i,j] := sbe
  end
  else
  begin
    tmd[1,1] := da; tmd[2,1] := 0.0; tmd[3,2] := 0.0;
    tmd[3,1] := 0.0;
    tmd[1,2] := db * dga; tmd[1,3] := dc * dbe;
    sga := SQRT( 1.0 - dga*dga ); tmd[2,2] := db * sga;
    sal := (dal - dbe * dga) / sga;
    tmd[2,3] := dc * sal;
    tmd[3,3] := dc * SQRT( 1.0 - sal*sal - dbe*dbe )
  end;
  INVMAT; { Build the tmr matrix: tmr = transpos(tmd^-1) }
  { define the constante cell }
  DEFNWCTE( '$A'       , da       ); DEFNWCTE( '$A#'      , ra       );
  DEFNWCTE( '$B'       , db       ); DEFNWCTE( '$B#'      , rb       );
  DEFNWCTE( '$C'       , dc       ); DEFNWCTE( '$C#'      , rc       );
  DEFNWCTE( '$ALPHA'   , dal      ); DEFNWCTE( '$ALPHA#'  , ral      );
  DEFNWCTE( '$BETA'    , dbe      ); DEFNWCTE( '$BETA#'   , rbe      );
  DEFNWCTE( '$GAMMA'   , dga      ); DEFNWCTE( '$GAMMA#'  , rga      );
  DEFNWCTE( '$VOLUME'  , dvol     ); DEFNWCTE( '$VOLUME#' , rvol     );
  DEFNWCTE( '$TMDXX'   , tmd[1,1] ); DEFNWCTE( '$TMRXX'   , tmr[1,1] );
  DEFNWCTE( '$TMDXY'   , tmd[1,2] ); DEFNWCTE( '$TMRXY'   , tmr[1,2] );
  DEFNWCTE( '$TMDXZ'   , tmd[1,3] ); DEFNWCTE( '$TMRXZ'   , tmr[1,3] );
  DEFNWCTE( '$TMDYX'   , tmd[2,1] ); DEFNWCTE( '$TMRYX'   , tmr[2,1] );
  DEFNWCTE( '$TMDYY'   , tmd[2,2] ); DEFNWCTE( '$TMRYY'   , tmr[2,2] );
  DEFNWCTE( '$TMDYZ'   , tmd[2,3] ); DEFNWCTE( '$TMRYZ'   , tmr[2,3] );
  DEFNWCTE( '$TMDZX'   , tmd[3,1] ); DEFNWCTE( '$TMRZX'   , tmr[3,1] );
  DEFNWCTE( '$TMDZY'   , tmd[3,2] ); DEFNWCTE( '$TMRZY'   , tmr[3,2] );
  DEFNWCTE( '$TMDZZ'   , tmd[3,3] ); DEFNWCTE( '$TMRZZ'   , tmr[3,3] );
  { Write cell order in int file }
  WRITELN( int, ' ', ORD( cellsy ):4,
                ' ',  da:14, ' ',  db:14, ' ',  dc:14,
                ' ', dal:14, ' ', dbe:14, ' ', dga:14 );
  WRITELN( int, ' ',  ra:14, ' ',  rb:14, ' ',  rc:14,
                ' ', ral:14, ' ', rbe:14, ' ', rga:14 );
  WRITELN( int, ' ', dvol:14, rvol:14 );
  for i := 1 to 3 do for j := 1 to 3 do
    WRITELN( int, ' ', tmd[i,j]:14, ' ', tmr[i,j]:14 );
  { skip the terminator }
  LOOKSEMICOL( true )
end CELLSTATE;



procedure WAVESTATE;
{ Wave vector declaration statement }
const
  mdnam = 'WAVE';

var
  pfw: physptr;
  bdf: boolean;
  ch:  char;

begin
  ch := ' '; { assume no rational }
  pfw := NEWPHYSITM( wavespc, bdf, lparsy );
  if bdf then ERROR( mdnam, 102 );
  LOOKSYMBOL( rparsy, 81, true );
  LOOKSYMBOL( equop, 90, true );
  with pfw^.wav do
  begin
    vx := 0.0; vy := 0.0; vz := 0.0;
    GETNCTE( vx ); GETNCTE( vy ); GETNCTE( vz );
    if (sym.sy = ident) or (sym.sy = ctstr) then
    begin  INPUTLETTER( ch ); INSYMBOL end;
    TRANSVECT( tmr, qx, qy, qz, vx, vy, vz )
  end;
  begin
    WRITE( int, ' ', ORD( wavevsy ):4 );
    with pfw^ do
    with wav do
      WRITELN( int, ' ', name.s:ORD( name.l ),
                    ' ', sequ:6,
                    ' ', qx:14, ' ', qy:14, ' ', qz:14,
                    ' ', vx:14, ' ', vy:14, ' ', vz:14,
                    ' ', ORD( ch = 'R' ):2 )
  end;
  LOOKSEMICOL( true )
end WAVESTATE;



procedure NPOLASTATE;
{ Polarization neutron direction declaration statement }
const
  mdnam = 'NPOL';

var
  pfp: physptr;
  bdf: boolean;
  i:   integer;

begin
  pfp := NEWPHYSITM( npolaspc, bdf, lparsy );
  if bdf then ERROR( mdnam, 102 );
  LOOKSYMBOL( rparsy, 81, true );
  LOOKSYMBOL( equop, 90, true );
  with pfp^ do
  begin
    for i := 1 to 6 do GETPHYSPARAM;
    WRITELN( int, ' ', ORD( npoladirsy ):4,
                  ' ', name.s:ORD( name.l ), ' ', sequ:6 )
  end;
  LOOKSEMICOL( true )
end NPOLASTATE;




{ get a matrix symtry operator and for hexagonal cell build the
   cartesian equivalent matrix by use of :
      t(cart) = tmd * t(cell) * transpos( tmr ) }
procedure SYMTRYSTATE;
const
  mdnam = 'SYMT';

var
  pfs:      physptr;
  i, j, iv: integer;
  rv:       real;
  bdf:      boolean;

begin
  pfs := NEWPHYSITM( symspc, bdf, lparsy );
  if bdf then ERROR( mdnam, 102 );
  LOOKSYMBOL( rparsy, 81, true );
  LOOKSYMBOL( equop, 90, true );
  with pfs^ do
  begin
    WRITE( int, ' ', ORD( symtrysy ):4,
                ' ', name.s:ORD( name.l ), ' ', sequ:6 );
    for i := 1 to 3 do
    begin
      for j := 1 to 4 do
      begin rv := 0.0; GETNCTE( rv );
	if j = 4 then
	begin  iv := ROUND( rv*12.0 ); matope[i,j] := iv  end
	else
	begin
          iv := ROUND( rv ); matope[i,j] := iv;
	end;
	WRITE( int, ' ', iv:3 )
      end
    end;
    PUTRANSOPE( matope )
  end;
  LOOKSEMICOL( true )
enD SYMTRYSTATE;



procedure MDSDSPSTATE;
{ Modulated displacment declaration statement }
const
  mdnam = 'MDSP';

var
  pfd, pfa, pfw: physptr;
  bdf:           boolean;
  icp:           integer;

begin
  pfd := NEWPHYSITM( dispspc, bdf, lparsy );
  if bdf then ERROR( mdnam, 102 );
  pfa := NEWPHYSITM( atomspc, bdf, commasy );
  if not bdf then ERROR( mdnam, 101 );
  pfw := NEWPHYSITM( wavespc, bdf, commasy );
  if not bdf then ERROR( mdnam, 101 );
  LOOKSYMBOL( rparsy, 81, true );
  LOOKSYMBOL( equop, 90, true );
  bdf := false;
  for icp := 1 to 8 do
  begin
    GETPHYSPARAM;
    bdf := bdf or (primobj.ndt <> nullsy)
  end;
  if not bdf then ERROR( mdnam, 103 );
  begin
    with pfd^ do
      WRITE( int, ' ', ORD( mdsdspsy ):4,
                  ' ', name.s:ORD( name.l ), ' ', sequ:6,' ', pfa^.sequ:6 );
    WRITELN( int, ' ', pfw^.sequ:6 )
  end;
  LOOKSEMICOL( true )
end MDSDSPSTATE;



procedure LSQBLKSTATE;
{ least square declaration statement }
const
  mdnam = 'LSQB';

var
  pfs: physptr;
  rv:  real;
  bdf: boolean;

begin
  pfs := NEWPHYSITM( blkspc, bdf, lparsy );
  if bdf then ERROR( mdnam, 102 );
  LOOKSYMBOL( rparsy, 81, true );
  LOOKSYMBOL( equop,  90, true );
  GETPHYSPARAM; { get possible damping factor }
  GETPHYSPARAM; { get possible Marquward/Landquark factor }
  with pfs^ do
    WRITELN( int, ' ', ORD( lsqblocksy ):4,
                  ' ', name.s:ORD( name.l ), ' ', sequ:6 );
  LOOKSEMICOL( true )
end LSQBLKSTATE;



procedure MAGNETICSTATE;
{ to define magnetic and not magnetic selector value }
var
  i, iv: integer;

begin
  WRITE( int, ' ', ORD( magneticsy ):4 );
  for i := 0 to maxsel do
  begin
    iv := 1; GETICTE( iv );
    WRITE( int, ' ', ORD( iv <> 0 ):1 )
  end;
  WRITELN( int )
end MAGNETICSTATE;



procedure OPTIONSTATE;
{ To transmit option to an application program }
const
  mdnam = 'OPTI';

var
  iv, i, j: integer;
  trv: array[1..maxoptv] of real;

begin
  with sym do
  begin
    LOOKSYMBOL( lparsy, 82, true );
    iv := 0; GETICTE( iv );
    LOOKSYMBOL( rparsy, 81, true );
    LOOKSYMBOL( equop, 90, true )
  end;
  i := 0;
  repeat
    i := i + 1; trv[i] := 0.0; GETNCTE( trv[i] )
  until (i >= maxoptv) or (sym.ndtwd = smcolsy);
  WRITE( int, ' ', ORD( optionssy ):4, ' ', iv:4, ' ', i:2 );
  for j := 1 to i do  WRITE( int, ' ', trv[j]:12 );
  WRITELN( int );
  LOOKSEMICOL( true )
end OPTIONSTATE;



procedure SOPTIONSTATE;
{ To execute all string transmition statements }
const
  mdnam  = 'STRG';

var
  ps:    stp;
  iv: integer;

begin
  with sym do
  begin
    LOOKSYMBOL( lparsy, 82, true );
    iv := 0; GETICTE( iv );
    LOOKSYMBOL( rparsy, 81, true );
    LOOKSYMBOL( equop, 90, true )
  end;
  GETSCTE( ps );
  if ps <> nil then
  with ps^ do
  begin
    WRITELN( int, ORD( soptionsy ):4, ' ', iv:4, ' ', ORD( l ):4 );
    WRITE( int, s:ORD( l ) );
  end;
  if ps <> nil then
    { soption # 0 => additional local title setting }
    if iv = 0 then COPYSTR( ptitle, ps, false );
  ST_FREE( ps );
  WRITELN( int );
  LOOKSEMICOL( true )
end SOPTIONSTATE;



procedure CLOSE_OPEN( var f: filecntx; ps: stp; ch: char );
var
  bok, bprt: boolean;

begin
  with f do
  begin
    if fil_mod <> f_close then
    begin
      CLOSE_TXTFILE( fil_ptr );
      if fil_tty then CLOSE( fil_prt )
    end;
    fil_mod := f_close;
    if ps <> nil then
    case ch of
      'N': begin OPEN_LISTING( fil_ptr, ps^.s, 1 ); fil_mod := f_iow  end;
      'W': begin OPEN_LISTING( fil_ptr, ps^.s, 0 ); fil_mod := f_iow  end;
      'A': begin OPEN_LISTING( fil_ptr, ps^.s, 2 ); fil_mod := f_iow  end;
      'R': begin
             RESETTXTFILE( fil_ptr, ps, bok, fil_tty );
             if bok and (io_status^.value = 0.0) then
             begin
               if fil_tty then OPENW_TXTFILE( fil_prt, ps, 1 );
               fil_mod := f_ior
             end
           end
    otherwise
    end
  end
end CLOSE_OPEN;



procedure OPENFILESTATE;
{ To open a text read/write file }
const
  mdnam = 'OPEN';

var
  pfn:   stp;
  bgo:   boolean;
  i,lun: integer;
  ch:    char;

begin
  lun := 1; ch := 'W'; { set to default lun 1, write mode }
  GETNUMBER( lun );
  GETSCTE( pfn );
  if sym.ndtwd = commasy then
  begin
    INSYMBOL;
    if (sym.sy = ident) or (sym.sy = ctstr) then
    begin  INPUTLETTER( ch ); INSYMBOL  end
    else ERROR( mdnam, -203 )
  end;
  case ch of
    'R','r','I','i'{ read }: ch := 'R';
    'N', 'n'{ write new version }: ch := 'N';
    'W','w','O','o'{ write }: ch := 'W';
    'A','a'{ append }: ch := 'A'
  otherwise
    ERROR( mdnam, -202 )
  end;
  bgo := false;
  if pfn <> nil then
  with pfn^ do
    if l <> CHR( 0 ) then
    begin
      i := 1;
      while i <= ORD( l ) do
      begin  if s[i] > '_' then s[i]:= CHR( ORD( s[i]) - 32 );
	i := SUCC( i )
      end;
      while i <= maxlinesz do
      begin  s[i] := ' '; i := SUCC( i )  end;
      bgo := true
    end;

  if fatalerror then io_status^.value := -2.0
                else io_status^.value := 0.0;
  if bgo and not fatalerror then
    if (lun >= 0) and (lun <= 9) then
      CLOSE_OPEN( ioftb[lun], pfn, ch )
    else
      ERROR( mdnam, -201 );
  if pfn <> nil then ST_FREE( pfn )
end OPENFILESTATE;



procedure CLOSEFILESTATE;
{ to close a text read/write file }
var
  lun: integer;

begin
  lun := 1;
  GETNUMBER( lun );
  if (lun >= 0) and (lun <= 9) then
    CLOSE_OPEN( ioftb[lun], nil, ' ' )
  else
    ERROR( 'CLOS', 201 );
  io_status^.value := 0.0;
  looksemicol( true )
end CLOSEFILESTATE;



procedure BOOLSTATE( bool: ndtyp );
{ Transmit all boolean statement to application program }
const
  mdnam = 'BOOL';

var
  i: integer;

begin
  i := 1; GETICTE( i );
  LOOKSEMICOL( true );
  if bool = centeronsy then bcentric := (i > 0);
  if bool = genspacesy then bgenspace := (i > 0)
  else
  begin
    WRITE( int, ' ', ORD( bool ):4, ' ' );
    WRITELN( int, ORD( i > 0 ):2 )
  end
end BOOLSTATE;



procedure REPLYSTATE( nd: ndtyp );
{ To get a variable from terminal or input file : string or number(s) }
const
  mdnam = 'RPLY';

var 
  lun, ip: integer;
  ch:      char;
  bstop:   boolean;

  procedure SKPRDS( var f: text );
  begin
    with sym, ptid^ do
      if parattr = strkonst then
      with stpt^ do
      begin
        ip := 1; (** CPAS **) { INPUT TERMINAL CAN BE MODIFIED }
        if EOLN( f ) and not EOF( f ) then READLN( f );
        ch := ' ';
        while (ch =' ') and not EOLN( f ) and not EOF( f ) do  READ( f, ch );
        while not EOF( f ) and not EOLN( f ) do
        begin
          s[ip] := ch; ip := ip + 1; READ( f, ch )
        end;
        s[ip] := ch;
        l := CHR( ip )
      end
      else
      if parattr = numkonst then
      begin
        if EOLN( f ) then READLN( f );
        if not EOF( f ) and not EOLN( f ) then READ( f, value )
      end else ERROR( mdnam, 73 );
    if EOF( f ) then io_status^.value := -1.0
                else io_status^.value := 0.0
  end SKPRDS;


begin { REPLYSTATE }
  lun := 1;
  if nd = readsy then
  begin
    GETNUMBER( lun );
    if (lun < 0) or (lun > 9) then ERROR( mdnam, -201 )
    else
      if ioftb[lun].fil_mod <> f_ior then ERROR( mdnam, -204 )
  end;
  bstop := false;
  if not fatalerror then
  with sym do
  repeat
    if sy <> ident then ERROR( mdnam, 61 ) else
      if ptid = nil then ERROR( mdnam, 51 ) else
	with ptid^ do
	  if idtyp <> paramty then ERROR( mdnam, 73 ) else
            if nd = readsy then
              with ioftb[lun] do
                if fil_tty then SKPRDS( input )
                           else SKPRDS( fil_ptr )
            else
	      SKPRDS( input );
    INSYMBOL;
    if ndtwd = commasy then INSYMBOL else bstop := true
  until bstop;
  LOOKSEMICOL( true )
end REPLYSTATE;



procedure DISPLAYSTATE( nd: ndtyp );
{ output statement:
   nd =
	displaysy => output on terminal,
	wrtmsgsy  => output on listing,
	writesy,
        writelnsy => output on text file opened by openfile statement.
}
const
  mdnam = 'DSPL';

var
  lun, n1, n2, n3: integer;
  r1:          real;
  st: stp;

  procedure OUT_ON_FILE( nd: ndtyp; s: stp );
  { Perform the output }
  begin
    with s^ do
    case nd of
      displaysy: WRITE( output, s:ORD( l ) );
      wrtmsgsy:  WRITE(    lst, s:ORD( l ) );
      writelnsy,
      writesy: with ioftb[lun] do
                 if fil_tty then WRITE( output,  s:ORD( l ) )
                            else WRITE( fil_ptr, s:ORD( l ) )
    end;
  end OUT_ON_FILE;


begin  { DISPLAYSTATE }
  lun := 0;
  if nd = wrtmsgsy then NEWLINELST else
    if nd = displaysy then WRITELN( output )
      else { write }
      begin
        lun := 1;
        GETNUMBER( lun ); { get logical unit number }
        if (lun < 1) or (lun > 9) then ERROR( mdnam, -201 )
        else
          if ioftb[lun].fil_mod <> f_iow then ERROR( mdnam, -205 )
      end;

  if not fatalerror then
  with sym do
  repeat
    if ndtwd = commasy then INSYMBOL;
    EXPRESSION;
    with primobj do
    case eattr of
      numkonst:
        begin
          r1 := rvl; n3 := 0; n2 := 0; n1 := 0;
          GETNUMBER( n1 ); GETNUMBER( n2 ); GETNUMBER( n3 );
          st := ST_CREATE;
          { n1 = field width }
          { |n2| = number of decimal figures, n2 < 0 => floatting mode }
          if n1 = 0 then
            if n2 = 0 then ST_PUT_FIXED( st^, r1, 16, 7, n3 )
                      else ST_PUT_FLOAT( st^, r1, 16, 1, 7, 2 )
          else
            if n2 = 0 then ST_PUT_INT( st^, ROUND( r1 ), n1 )
                      else ST_PUT_FIXED( st^, r1, n1, n2, n3 );
          OUT_ON_FILE( nd, st );
          ST_FREE( st )
        end;

      strkonst:
        begin
          if pstr <> nil then
          begin
            if pstr^.l <> CHR( 0 ) then OUT_ON_FILE( nd, pstr );
            ST_FREE( pstr )
          end
        end;
    otherwise
      ERROR( mdnam, 74 )
    end
  until ndtwd <> commasy;

  if nd = displaysy then
  begin
    if sym.ndtwd = replysy then
    begin { break(output); } (** CPAS **)
      INSYMBOL; REPLYSTATE( replysy )
    end
    else
    begin
      WRITELN( output );
      LOOKSEMICOL( true )
    end
  end else
  begin
    if nd = wrtmsgsy then WRITELN( lst )
    else
      if nd = writelnsy then
      with ioftb[lun] do
        if fil_tty then WRITELN( output )
                   else WRITELN( fil_ptr );
    if fatalerror then io_status^.value :=  0.0
                  else io_status^.value := -2.0;
    LOOKSEMICOL( true )
  end
end DISPLAYSTATE;



procedure SETRUNAPPL;
var
  ps: stp;

begin
  GETSCTE( ps );
  if ps <> nil then
  with ps^ do
  begin
    appnam.length := ORD( l );
    for i := 1 to appnam.length do appnam[i] := s[i]
  end;
  ST_FREE( ps );
  LOOKSEMICOL( true )
end SETRUNAPPL;



procedure SETLISTING;
{ To set a new listing file }
var
  ps:  stp;
  spc: filespc;
  i:   integer;

begin
  GETSCTE( ps );
  if ps <> nil then
  begin
    with ps^ do
    begin
      for i := 1 to ORD( l ) do  spc[i] := s[i];
      spc.length := ORD( l )
    end;
    ST_FREE( ps );               { Free the temporary string }
    CLOSE( lst );                { Close previous listing file }
    OPEN_LISTING( lst, spc, 1 ); { and open the new one }
    linewrt := pagesize;         { Force a first top of form }
    pagenb  := 0                 { Set the new page number }
  end;
  LOOKSEMICOL( true )
end SETLISTING;



procedure SPAWN_TASK;
{ To execute a schell/DCL command as an offspring task }
var
  ps:  stp;
  cmd: filespc;
  b:   boolean;

begin
  GETSCTE( ps );
  if ps <> nil then
  begin
    with ps^ do
    begin
      for i := 1 to ORD( l ) do  cmd[i] := s[i];
      cmd.length := ORD( l )
    end;
    ST_FREE( ps );               { Free the temporary string }
    b := SYS_SPAWN( cmd )
  end;
  LOOKSEMICOL( true )
end SPAWN_TASK;



procedure ERRORSTATE;
{ User error statement }
const
  mdnam = 'uerr';

begin
  bexit := true; { Stop all process };
  ERROR( mdnam, -999 )
end ERRORSTATE;


  begin { STATEMENT }
    statnbr := statnbr + 1;
    with sym do
    if sy = eofsy then
    begin
      EOFSTATE;
      cursy := ndtwd
    end else
    if sy = ident then
    begin
      if ptid <> nil then
      begin
        stname   := namid.s;
        curstatp := ptid;
        pf := ptid;
        with pf^ do
        if idtyp = keyword then
        { by pass keyword statement except for repeat to keep first
          syntax unit after the repeat word }
        begin
          if nodty <> repeatsy then INSYMBOL;
          case nodty of
            endsy, endifsy, endmacsy, elsesy, untilsy, thensy:
	      begin  ERROR( mdnam, 68 ); INSYMBOL  end;
            pragmasy:
              PRAGMASTATE( false );
            includesy, chainsy:
              INCLUDESTATE( nodty );
            beginsy:         BEGINSTATE;
            datasy:          DATASTATE;
            clrdatasy:       CLRDATASTATE;
            uctrdefsy:       CONTRIBSTATE;
	    varbl:           VARIABLESTATE;
            param:           PARAMSTATE;
            limitssy:        LIMITSTATE;
            latticesy:       LATTICESTATE;
            atomsy, catomsy: ATOMESTATE( nodty = catomsy );
            momentsy:        MOMENTSTATE;
            cellsy, rcellsy: CELLSTATE( nodty = rcellsy );
            wavevsy:         WAVESTATE;
            npoladirsy:      NPOLASTATE;
            symtrysy:        SYMTRYSTATE;
            mdsdspsy:        MDSDSPSTATE;
            lsqblocksy:      LSQBLKSTATE;
            centeronsy,
            bisomd,
            genspacesy:      BOOLSTATE( nodty );
            magneticsy:      MAGNETICSTATE;
            eofsym:          EOFSTATE;
            fixedsy,
            unfixedsy:       FIXEDSTATE( nodty );
            ffassignsy:      ASSIGNFFSTATE;
            optionssy:       OPTIONSTATE;
            soptionsy:       SOPTIONSTATE;
            usfunctdf:       FUNCTIONSTATE;
            repeatsy:        REPEATSTATE;
            macrosy:         MACROSTATE;
            macrolibsy:      MACRLIBSTATE;
            mcallsy:         MCALLSTATE;
            purgesy:         PURGESTATE;
            ifsy:            IFSTATE;
            opensy:          OPENFILESTATE;
            closesy:         CLOSEFILESTATE;
            wrtmsgsy,
            displaysy,
            writesy,
            writelnsy:       DISPLAYSTATE( nodty );
            replysy, readsy: REPLYSTATE( nodty );
            runapplsy:       SETRUNAPPL;
            listingsy:       SETLISTING;
            spawnsy:         SPAWN_TASK;
            errorsy:         ERRORSTATE
          end { case nodty of };
          if fatalerror then SKIP( smcolsy, false )
        end
        else
      	if (idtyp = paramty) or (idtyp = arrctety) then
	  ASSIGNPARSTATE( false )
	else
          if (idtyp = varty) then ASSIGNVARSTATE
          else
            if idtyp = macroref then CALLMACRO
            else
            begin  ERROR( mdnam, 66 ); SKIP( smcolsy, true )  END;
        cursy := ndtwd
      end { if ptid <> nil then ... else ... }
      else
      begin  ERROR( mdnam, 66 ); SKIP( smcolsy, true )  end
    end
    else { if sy = ident then ... else }
    begin
      LOOKSEMICOL( true );
      cursy := sym.ndtwd
    end
  end STATEMENT;



begin { STATELIST }
  cursy := sym.ndtwd;
  while (cursy <> stopper) and not bexit
        and ((cursy <> endifsy) or (stopper <> elsesy)) do
    STATEMENT;
  lststate := cursy;
  INSYMBOL { skip the stopper }
end STATELIST;




procedure WRITECPU( ti: integer );
{ write cpu time information }{ can be system dependent }
const
  scom =', ';

var
  i, j, k, l: integer;
  r:          real;

begin
  i := ti mod 1000; ti := ti div 1000; { get millisec. and ti in seconds. }
  j := ti mod 60;   ti := ti div 60;   { get seconds and ti in minuts. }
  k := ti mod 60;   ti := ti div 60;   { get minuts and ti in hours }
  l := ti mod 24;   ti := ti div 24;   { get hours and ti in days }
  if ti > 0 then
  begin
    WRITE( lst, ti:2, ' day' );
    if ti >=2 then WRITE( lst, 's' );
    WRITE( lst, scom );
  end;
  if l > 0 then
  begin
    WRITE( lst, l:2, ' hour' );
    if l >=2 then WRITE( lst, 's' );
    WRITE( lst, scom )
  end;
  if k > 0 then
  begin
    WRITE( lst, k:2, ' minute' );
    if k >=2 then WRITE( lst, 's' );
    WRITE( lst, scom )
  end;
  r := j+i/1000.0;
  WRITE( lst, r:7:3, ' second' );
  if r >=2.0 then WRITE( lst, 's' );
  WRITELN( lst, '.' )
end WRITECPU;



procedure GENSPACE;
var
  p0, p1, p2, p3: physptr;
  mat: opmatrix;
  i, j, k, ia: integer;
  found, center, identity: boolean;

begin
  p3 := nil;
  p0 := phystabhde[symspc];
  while p0 <> nil do
  begin
    p1 := p0;
    with p0^ do
    while p1 <> nil do
    begin
      ia := 0;
      { build the rotation matrix }
      for i := 1 to 3 do  for j := 1 to 3 do
      begin
	mat[i,j] := 0;
	for k := 1 to 3 do
          mat[i,j] := mat[i,j] + matope[i,k]*p1^.matope[k,j];
        if mat[i,j] <> 0 then ia := SUCC( ia )
      end;
      center := false; identity := false;
      if ia = 3 then
        if ABS( mat[1,1] ) = 1 then
	  if mat[1,1] = mat[2,2] then
	    if mat[1,1] = mat[3,3] then
	      if mat[1,1] > 0 then identity := true
	      else center := true;
      found := (bcentric and center);
      p2 := phystabhde[symspc]; { loop to search the element }
      while (p2 <> nil) and not found do
      begin
        with p2^ do
	begin
	  { compare the rotation matrix }
	  i := 0; j := 1;
	  repeat
	    i := i + 1;
	    if i > 3 then
	    begin  i := 1; j := j + 1  end
	  until (j > 3) or (mat[i,j] <> matope[i,j]);
	  if (j < 4) and bcentric then { if not found, if center yes then }
	  begin { compare with - matope rotation matrix }
	    i := 0; j := 1;
	    repeat
	      i := i + 1;
	      if i > 3 then
	      begin  i := 1; j := j + 1  end
	    until (j > 3) or (mat[i,j] <> (- matope[i,j]))
	  end
	end;
	if j = 4 then found := true else
	begin
	  p3 := p2;
	  p2 := p2^.next
	end
      end;
      if not found then
      begin { we must add this new operator }
	NEW( p2, symspc ); { create the new symtry operator }
	with p2^ do
	begin
	  if identity then { the identity is always at the head of list }
	  begin
	    next := phystabhde[symspc]; phystabhde[symspc] := p2;
	    sequ := -1; name.s := '.e......'; name.l := chr( 8 )
	  end
	  else
	  begin
	    p3^.next := p2; next := nil; sequ := sequphtab[symspc];
	    sequphtab[symspc] := sequphtab[symspc] + 1;
	    if center then name.s := '.center.' else name.s := '.genspc.';
	    name.l := chr( 8 )
	  end;
	  if sequ >= 48 then
	  begin
	    ERROR( 'GSPA', -181 );
            p1^.next := nil; p0^.next:= nil
	  end; { stop }
	  matope := mat;
	  WRITE( int, ' ', ORD( symtrysy ):4,
                      ' ', name.s:ORD( name.l ), ' ', sequ:6 );
	  for i := 1 to 3 do
	  begin
	    for j := 1 to 3 do  WRITE( int, ' ', matope[i,j]:3 );
	    matope[i,4] := p0^.matope[i,4];
	    for k := 1 to 3 do
	      matope[i,4] := matope[i,4] + p0^.matope[i,k]*p1^.matope[k,4];
	    matope[i,4] := matope[i,4] mod 12;
	    WRITE( int, ' ', matope[i,4]:3 )
	  end;
	  PUTRANSOPE( mat )
	end
      end;
      p1 := p1^.next
    end;
    p0 := p0^.next
  end
end GENSPACE;




procedure SUMMARY;
{ to display the error number message and output the ddi file }
var
  p: physptr;
  r: ddirec;

begin
  if bgenspace then GENSPACE;
  if errcnt > 0 then
  begin
    WRITELN;
    WRITELN( ' Summary Error Count = ', ERRCNT );
    if fatalerror then
    begin
      WRITELN( int, ' -2' ); { set not runable on int file }
      WRITELN( output, 'with some FATAL.' )
    end
    else WRITELN( int, ' -1' ) { set suspicious data indicator }
  end;
  CLOSE( int );                { Close the instruction file }
  if bnewdata and not fatalerror then
  begin
    OPEN_DDIFILE( ddi, ddispcfile, true );
    p := phystabhde[dataspc] ;
    while p <> nil do
    begin
      r.inf := p^.dtf;
      r.nam := p^.name;
      WRITE( ddi, r );
      p := p^.next
    end;
    CLOSE_DDIFILE( ddi )
  end;
  if cntx_heap^.ccnt.blist then
  begin
    NEWLINELST; WRITELN( lst );
    NEWLINELST; WRITELN( lst );
    NEWLINELST; WRITELN( lst );
    NEWLINELST; WRITE( lst, ' Error Count = ', ERRCNT:4 );
    if fatalerror then WRITE( lst, ' with some FATAL' );	
    WRITELN( lst, ' .' );
    NEWLINELST; WRITELN( lst );
    NEWLINELST; WRITELN( lst, ' MXD Compiler CPU time used is :' );
    WRITECPU( CPU_CLOCK - initcpu );
    WRITELN( lst )
  end
  else
  WRITELN( lst )
end SUMMARY;

begin { MAIN BODY }
  INIT;                      { general initialization }
  INSYMBOL;                  { get the first syntaxe unit }
  STATELIST( endsy );        { data processing }
  SUMMARY;                   { execution end summary }
  if LENGTH( appnam ) > 0 then
  begin
    WRITELN( ' *** Now MXD start "', appnam, '" application.' );
    RUN_PROCESS( '', appnam );  { Run the application }
    WRITELN( '*** Cannot run the specified application program ***' );
    WRITELN( ' "', appnam, '".' )
  end;
MXD_STOP:
end MXD_CMP.
