{%pragma cp_list_on;}
PROGRAM GENHKL(INPUT,OUTPUT);
(* PROGRAM TO SORT OUTPUT REFLEXIONS FROM COLL5 *)
CONST
  DIST_TOL = 1.0E-5;  (* TOLERANCE IN 1/D *)
  DEUXPI = 6.2831854; (* 2*PI *)
  INRD = 0.0174532931; (* PI/180 *)

const uuu = dist_tol;
TYPE

  MSYMOP = ARRAY[1..3,1..3] OF INTEGER; (* SYMTRY MATRIX *)

  PSYMOP = ^SYMOP;	(* SYMTRY POINTER *)

  SYMOP = RECORD
    NEXT: PSYMOP;	(* LINK TO NEXT OPERATOR *)
    OPER: MSYMOP	(* OPERATOR MATRIX *)
  END;

  str = string(16);     (* FILE NAME FORMAT *)
  (* STR = PACKED ARRAY[1..16] OF CHAR; (* FILE NAME FORMAT *)

  PTR = ^TRIPLET;

  SPTR = ^STRIPLET;

  STRIPLET = RECORD
    LNK: SPTR;          (* LINK TO SINGLE EQUIVALENT TRIPLET *)
    SH, SK, SL: REAL    (* INDEX OF TRIPLET *)
  END;

  TRIPLET = RECORD
    EQHDE: SPTR;        (* EQUIVALENT LIST HEAD *)
    LP,RP: PTR;		(* POINTEURS DE CHAINAGE DROIT ET GAUCHE *)
    H,K,L,NQC,MULT: INTEGER;	(* INDICES *)
    DIST: REAL		(* MODULE DE H *)
  END;


VAR
  SYMHDE: PSYMOP;	(* GROUPE ELEMENT LIST *)
  lattab: string(7);
  (* LATTAB: PACKED ARRAY[1..7] OF CHAR; *)

  BNQZ,			(* TO FLAG THE NQ=0 VALUE *)
  BELIM,		(* FLAG FOR DUPLICATED REFLEXION *)
  BCENTER,              (* FLAG FOR CENTERED GROUP *)
  BOK: BOOLEAN;

  LATTICE: CHAR;	(* USED LATTICE *)
  PAR: ARRAY[1..6] OF REAL; (* TO GET UNIT CELL PARAMETERS *)
  ENDSTR: STR;		(* END WORK STRING *)
  ILAT,			(* LATTICE INDEX *)
  ICMP,			(* 0 => EGAL, 1 => PLUS GRAND, -1 => PLUS PETIT *)
  NREF,			(* SORTTED REFLEXION COUNT *)
  NSEQU,		(* SEQUENCE REFLEXION NUMBER *)
  NQ,			(* CURRENT NQ *)
  NQM,NQN,		(* NQ MAX, NQ MIN *)
  HM,KM,LM,		(* INDICES MAXIMUMS *)
  HC,KC,LC: INTEGER;	(* INDICES COURANTS *)
  HH, KK, LL,           (* REAL CURRENT REFLEXION INDEX *)
  QX,QY,QZ,		(* WAVE VECTOR COMPONANTS *)
  DISTMIN,		(* MINIMUM FOR 1/2D *)
  DISTMAX,		(* MAXIMUM FOR 1/2D *)
  SAL,SBE,SGA,VOL,	(* NOMBRE POUR LE CALCUL DU TENSEUR METRIC *)
  RA,RB,RC,RAL,RBE,RGA,	(* PARAMETRES DE MAILLE RECIPROQUE *)
  DC,			(* DISTANCE COURANTE *)
  LAMBDA,               (* LONGUEUR D'ONDE *)
  A,B,C,AL,BE,GA: REAL;	(* PARAMETRES DE MAILLE DIRECT *)
  P,			(* POINTEUR DU TRIPLET COURANT *)
  P1,P2,		(* POINTEURS ANNEXES *)
  G: PTR;		(* SOMMET DU GRAPHE *)
  PE1, PE2: SPTR;       (* EQUIVALENT MICELLIOUS POINTERS *) 
  OUTNAME: STR;		(* OUTPUT FILE NAME *)

  OUT: TEXT;		(* FICHIER GROUPE PUIS FICHIER RESULTAT - TRIE *)


PROCEDURE SETSYMLST;
VAR
  I,J: INTEGER;
  P1,P2: PSYMOP;

BEGIN
  DISTMIN := DIST_TOL;
  BCENTER := FALSE;
  P1 := NIL;
  RESET( OUT, OUTNAME );
  WHILE NOT EOF(OUT) DO
  BEGIN
    IF SYMHDE = NIL THEN
    BEGIN
      WRITELN; WRITELN(' LIST OF SYMTRY OPERATORS :'); WRITELN
    END;
    NEW(P2); (* CREAT THE SYMTRY ITEM *)
    IF P1 = NIL THEN SYMHDE := P2 (* BUILD THE LIST OF ELEMENTS *)
      ELSE P1^.NEXT := P2;
    P1 := P2;
    WITH P2^ DO
    BEGIN
      NEXT := NIL; (* ASSUME AS END OF LIST *)
      FOR I := 1 TO 3 DO
      BEGIN
        FOR J := 1 TO 3 DO
        READ(OUT,OPER[J,I]);
	WRITELN('              ',OPER[1,I]:4,OPER[2,I]:4,OPER[3,I]:4)
      END;
      WRITELN;
      READLN(OUT)
    END
  END;
  CLOSE(OUT)
END (* SETSYMLST *);

PROCEDURE MULSYM(P1,P2,P3: PSYMOP); (* TO DO P2^ := P1^*P2^ *)
VAR I,J,K: INTEGER;
BEGIN
  WITH P1^ DO
  FOR I := 1 TO 3 DO
  BEGIN
    FOR J := 1 TO 3 DO
    OPER[I,J] := P2^.OPER[I,1]*P3^.OPER[1,J] +
                 P2^.OPER[I,2]*P3^.OPER[2,J] +
                 P2^.OPER[I,3]*P3^.OPER[3,J]
  END
END (* MULSYM *);

PROCEDURE GENSPACE;
VAR
  P1,P2,P3,P4,P5: PSYMOP;
  BFOUND: BOOLEAN;
  G,J1,J2: INTEGER;

BEGIN
  G := 0;
  NEW(P4);
  P1 := SYMHDE;
  WHILE P1 <> NIL DO
  BEGIN
    G := G + 1;
    P2 := P1;
    WHILE P2 <> NIL DO
    BEGIN
      MULSYM(P4,P1,P2);
      P3 := SYMHDE; BFOUND := FALSE;
      WHILE (P3 <> NIL) AND NOT BFOUND DO
      BEGIN
	BFOUND := TRUE; J1 := 1;
	WHILE (J1 < 4) AND BFOUND DO
	BEGIN
	  J2 := 1;
	  WHILE (J2 < 4) AND BFOUND DO
	  BEGIN
	    BFOUND := (P4^.OPER[J1,J2] = P3^.OPER[J1,J2]);
	    J2 := J2 + 1
	  END;
	  J1 := J1 + 1
	END;
	P5 := P3;
	P3 := P3^.NEXT
      END;
      IF NOT BFOUND THEN
      BEGIN
	NEW(P5^.NEXT); P3 := P5^.NEXT; P3^.NEXT := NIL;
	WITH P4^ DO
	BEGIN
	  WRITELN(' NEW OPERATOR ',OPER[1,1]:4,OPER[2,1]:4,OPER[3,1]:4);
	  WRITELN('              ',OPER[1,2]:4,OPER[2,2]:4,OPER[3,2]:4);
	  WRITELN('              ',OPER[1,3]:4,OPER[2,3]:4,OPER[3,3]:4)
	END;
	WRITELN;
	P3^.OPER := P4^.OPER
      END;
      P2 := P2^.NEXT
    END;
    P1 := P1^.NEXT
  END  ;
  BCENTER := FALSE;
  P1 := SYMHDE;
  WHILE (P1 <> NIL) AND NOT BCENTER DO
  BEGIN
    WITH P1^ DO
      BCENTER := (OPER[1,1] = -1) AND (OPER[2,2] = -1) AND (OPER[3,3] = -1)
             AND (OPER[1,2] = 0) AND (OPER[1,3] = 0) AND (OPER[2,1] = 0)
             AND (OPER[2,3] = 0) AND (OPER[3,1] = 0) AND (OPER[3,2] = 0);
    P1 := P1^.NEXT
  END;
  IF BCENTER THEN WRITELN(' THE PONCTUAL GROUP IS CENTERED.');
  WRITELN(' THE PONCTUAL GROUP ORDER HAS ',G:3,' OPERATORS.'); WRITELN
END (* GENSPACE *);

FUNCTION RMAX(V1,V2,V3: REAL): REAL;
BEGIN
  IF V1 > V2 THEN
    IF V1 > V3 THEN RMAX := V1 ELSE RMAX := V3
  ELSE
    IF V2 > V3 THEN RMAX := V2 ELSE RMAX := V3
END (* RMAX *);

FUNCTION RMIN(V1,V2,V3: REAL): REAL;
BEGIN
  IF V1 < V2 THEN
    IF V1 < V3 THEN RMIN := V1 ELSE RMIN := V3
  ELSE
    IF V2 < V3 THEN RMIN := V2 ELSE RMIN := V3
END (* RMIN *);

PROCEDURE CELLSIZE(VAR IA,IB,IC: INTEGER; MAXDIST,PA,PB,PC,PAL,PBE,PGA: REAL);
(* TO FIND THE ADAPTED VALUES OF IA,IB,IC FOR THE GIVEN UNIT CELL
   IN RELATION WITH MAXDIST2 *)
CONST
  PRECIS = 0.0001;

TYPE
  MATRIX = ARRAY[1..3,1..3] OF REAL;

VAR
  I,J: INTEGER;
  MAT,HV: MATRIX;

PROCEDURE EIGENVALUE(VAR MAT,HV: MATRIX; N: INTEGER);
VAR
  I,J,K,L,M,IND: INTEGER;
  ANORME,PRECISNORME,PRES,ECHANG: REAL;

FUNCTION LIMIT(VAR INDI: INTEGER; LIM: INTEGER): BOOLEAN;
BEGIN
  LIMIT := (INDI = LIM);
  IF INDI <> LIM THEN INDI := SUCC(INDI)
END (* LIMIT *);

FUNCTION FLAG: BOOLEAN;
BEGIN
  FLAG := (IND <> 1);
  IF IND = 1 THEN IND := 0
END (* FLAG *);

PROCEDURE SORT;
BEGIN
  FOR I := 1 TO N DO
  FOR J := 1 TO N DO
  BEGIN
    IF I > J THEN MAT[I,J] := 0.0;
    IF MAT[I,I] > MAT[J,J] THEN
    BEGIN
      ECHANG := MAT[I,I]; MAT[I,I] := MAT[J,J]; MAT[J,J] := ECHANG;
      FOR K := 1 TO N DO
      BEGIN
	ECHANG := HV[K,I]; HV[K,I] := HV[K,J]; HV[K,J] := ECHANG
      END
    END
  END
END (* SORT *);

PROCEDURE COMPUTE;
VAR
  X,Y,SINX,COSX,SINX2,COSX2,SINOS: REAL;
  IM1,IM2,IL1,IL2: INTEGER;

BEGIN
  IND := 1; X := 0.5*(MAT[L,L] - MAT[M,M]);
  Y := - MAT[L,M]/SQRT(SQR(MAT[L,M] + SQR(X)));
  IF X < 0.0 THEN Y := - Y;
  SINX := Y/SQRT(2.0*(1.0 + SQRT(ABS(1.0 - SQR(Y)))));
  SINX2 := SQR(SINX); COSX2 := 1.0 - SINX2; COSX := SQRT(COSX2);
  SINOS := SINX*COSX;
  FOR I := 1 TO N DO
  BEGIN
    IF (I <> L) AND (I <> M) THEN
    BEGIN
      IF I > M THEN
      BEGIN  IM1 := I; IM2 := M  END
      ELSE
      BEGIN  IM1 := M; IM2 := I  END;
      IF I < L THEN
      BEGIN  IL1 := I; IL2 := L  END
      ELSE
      BEGIN  IL1 := L; IL2 := I  END;
      X := MAT[IL1,IL2]*COSX - MAT[IM1,IM2]*SINX;
      MAT[IM1,IM2] := MAT[IL1,IL2]*SINX + MAT[IM1,IM2]*COSX;
      MAT[IL1,IL2] := X
    END;
    X := HV[I,L]*COSX - HV[I,M]*SINX;
    HV[I,M] := HV[I,L]*SINX + HV[I,M]*COSX;
    HV[I,L] := X
  END;
  X := 2.0*MAT[L,M]*SINOS;
  Y := MAT[L,L]*COSX2 + MAT[M,M]*SINX2 - X;
  X := MAT[L,L]*SINX2 + MAT[M,M]*COSX2 + X;
  MAT[L,M] := (MAT[L,L] - MAT[M,M])*SINOS + MAT[L,M]*(COSX2 - SINX2);
  MAT[L,L] := Y; MAT[M,M] := X
END (* COMPUTE *);

BEGIN (* EIGENVALUE *)
  ANORME := 0;
  FOR I := 1 TO N DO
  FOR J := 1 TO N DO
  IF I = J THEN HV[I,J] := 1.0 ELSE
  BEGIN
    HV[I,J] := 0.0; ANORME := ANORME + SQR(MAT[I,J])
  END;
  IF ANORME > 0 THEN
  BEGIN
    ANORME := SQRT(ABS(2.0*ANORME));
    PRECISNORME := ANORME*PRECIS/3; (* N = 3 *)
    IND := 0; PRES := ANORME;
    REPEAT
      PRES := PRES / N;
      REPEAT
	L := 1;
	REPEAT
	  M := L + 1;
	  REPEAT
	    IF ABS(MAT[L,M]) >= PRES THEN COMPUTE
	  UNTIL LIMIT(M,N);
	UNTIL LIMIT(L,N - 1);
      UNTIL FLAG;
    UNTIL PRES <= PRECISNORME;
  END;
  SORT
END (* EIGENVALUE *);

BEGIN (* CELLSIZE *)
  (* BUILT THE ADAPTED METRIX TENSOR *)
  MAT[1,1] := SQR(PA); MAT[2,2] := SQR(PB); MAT[3,3] := SQR(PC);
  MAT[2,3] := PB*PC*PAL; MAT[3,2] := MAT[2,3];
  MAT[1,3] := PC*PA*PBE; MAT[3,1] := MAT[1,3];
  MAT[1,2] := PA*PB*PGA; MAT[2,1] := MAT[1,2];
  EIGENVALUE(MAT,HV,3); (* COMPUT THE EIGEN VECTOR AND VALUE IN HV AND MAT *)
  (* GET THE APPROPRIATE LIMITS *)
  FOR I := 1 TO 3 DO  FOR J := 1 TO 3 DO
    HV[J,I] := HV[J,I]*MAXDIST/SQRT(MAT[I,I]);
  IA := ROUND(RMAX(ABS(HV[1,1]),ABS(HV[1,2]),ABS(HV[1,3])) + 0.5);
  IB := ROUND(RMAX(ABS(HV[2,1]),ABS(HV[2,2]),ABS(HV[2,3])) + 0.5);
  IC := ROUND(RMAX(ABS(HV[3,1]),ABS(HV[3,2]),ABS(HV[3,3])) + 0.5)
END (* CELLSIZE *);

FUNCTION MULTIPLICITY( IH, IK, IL, NQ: INTEGER; VAR EQHKL: SPTR ): INTEGER;
VAR
  EP: SPTR;
  P: PSYMOP;
  BFOUND: BOOLEAN;
  H,K,L,H1,K1,L1: REAL;
  JH,JK,JL,JN,JJH,JJK,JJL,JJN,I,J: INTEGER;
  HT,KT,LT: ARRAY[1..48] OF REAL;

BEGIN
  H := IH + NQ*QX; K := IK + NQ*QY; L := IL + NQ*QZ;
  JH := IH; JK := IK; JL := IL; JN := NQ;
  P := SYMHDE;
  EQHKL := NIL;
  IF P = NIL THEN MULTIPLICITY := 1 ELSE
  BEGIN
    I := 0;
    REPEAT
      WITH P^ DO
      BEGIN
	H1 := H*OPER[1,1] + K*OPER[1,2] + L*OPER[1,3];
	K1 := H*OPER[2,1] + K*OPER[2,2] + L*OPER[2,3];
	L1 := H*OPER[3,1] + K*OPER[3,2] + L*OPER[3,3]
      END;
      J := 1; BFOUND := FALSE;
      WHILE (J <= I) AND NOT BFOUND DO
      BEGIN
        BFOUND := ((ABS(HT[J] - H1) + ABS(KT[J] - K1) + ABS(LT[J] - L1))
		  < 1.0E-5);
        J := J + 1
      END;
      IF NOT BFOUND THEN
      BEGIN
	I := I + 1; HT[I] := H1; KT[I] := K1; LT[I] := L1;
        NEW( EP );
        WITH EP^ DO
        BEGIN
          SH := H1; SK := K1; SL := L1;
          LNK := EQHKL; EQHKL := EP
        END
      END;
      P := P^.NEXT
    UNTIL P=NIL;
    MULTIPLICITY := I
  END
END (* MULTIPLICITY *);

FUNCTION DIST( H, K, L, NQ: INTEGER): REAL;
BEGIN
  HH := H + NQ*QX; KK := K + NQ*QY; LL := L + NQ*QZ;
  DIST :=  SQRT(SQR(RA*HH) + SQR(RB*KK) + SQR(RC*LL) +
	        2.0*(RAL*RB*RC*KK*LL + RBE*RC*RA*LL*HH + RGA*RA*RB*HH*KK))
END (* DIST *);

PROCEDURE OUTTRIPLET(PT: PTR);
CONST INRD = 180/3.14159265;
VAR R: REAL;
BEGIN
  WITH PT^ DO (* AVEC LE TRIPLET COURANT FAIRE *)
  BEGIN
    IF LP <> NIL THEN OUTTRIPLET(LP);
    WRITE( OUT, ' ', H:4, K:4, L:4, NQC:4, MULT:4, DIST:12:4 );
    IF LAMBDA <> 0.0 THEN
    BEGIN
      R := LAMBDA*DIST*0.5;
      IF ABS( R ) > 0.999 THEN WRITELN( OUT, '**********')
      ELSE
      BEGIN
        R := R/SQRT( 1.0 - SQR(R) ); WRITELN( OUT, INRD*ARCTAN( R ):10:3 )
      END
    END ELSE WRITELN( OUT );
    IF RP <> NIL THEN OUTTRIPLET(RP)
  END
END (* OUTTRIPLET *);

BEGIN (* MAIN *)
  LATTAB := 'PABCIRF'; (* LATTICE NAME *)
  WRITELN;
  WRITELN;
  WRITE(' SYMTRY FILE NAME = '); READLN(OUTNAME);
  SETSYMLST;
  GENSPACE;
  WRITE(' OUTPUT FILE NAME = '); READLN(OUTNAME);
  REWRITE( OUT, OUTNAME );
  WRITELN;
  WRITELN(' GIVE THE UNIT CELL(ANGSTROEM AND DEGREES OR COSINUS)');
  READLN(A,B,C,AL,BE,GA);
  BOK := FALSE;
  REPEAT
    WRITELN;
    WRITELN(' GIVE THE LATTICE NAME (P,A,B,C,I,R,F) '); READLN(LATTICE);
    ILAT := 1;
    WHILE NOT BOK AND (ILAT < 8) DO
    BEGIN  BOK := (LATTAB.BODY[ILAT] = LATTICE); ILAT := ILAT + 1  END;
    IF ILAT > 8 THEN WRITELN(' UNDEFINED LATTICE.');
    ILAT := ILAT - 1
  UNTIL BOK;
  WRITELN;
  WRITELN(' GIVE THE WAVE VECTOR COMPONENTS : '); READLN(QX,QY,QZ);
  WRITELN;
  WRITELN(' GIVE THE MINIMAXI FOR NQ FACTOR (h = H + Q*NQ) : ');
  READLN(NQN,NQM);
  IF NQM < NQN THEN
  BEGIN  BNQZ := TRUE; HC := NQM; NQM := NQN; NQN := HC  END
    ELSE BNQZ := FALSE;
  WRITELN;
  WRITELN(' GIVE THE N*(=1/D) UPPER LIMIT : '); READLN(DISTMAX);
  WRITELN;
  WRITELN(' GIVE THE WAVELENGTH (ANGSTROM) [OR 0.0] : '); READLN(LAMBDA);
  (* SI LES ANGLES SONT DONNEES EN DEGREES PREND LE COSINUS *)
  IF AL > 1.0 THEN AL := COS(INRD * AL);
  IF BE > 1.0 THEN BE := COS(INRD * BE);
  IF GA > 1.0 THEN GA := COS(INRD * GA);
  (* CALCUL LE VOLUME DE LA MAILLE *)
  SAL := SQR(AL); SBE := SQR(BE); SGA := SQR(GA);
  VOL := A*B*C*SQRT(1.0+2.0*AL*BE*GA-SAL-SBE-SGA);
  (* CALCUL DU TENSEUR METRIC *)
  SAL := SQRT(1.0 - SAL); SBE := SQRT(1.0 - SBE); SGA := SQRT(1.0 - SGA);
  RAL := (BE*GA - AL)/(SBE*SGA);
  RBE := (GA*AL - BE)/(SGA*SAL);
  RGA := (AL*BE - GA)/(SAL*SBE);
  RA := B*C*SAL/VOL; RB := C*A*SBE/VOL; RC := A*B*SGA/VOL;
  (* CALCUL DES INDICES MAXIMUMS ET MINIMUM (CHOIX OPTIMAL) *)
  CELLSIZE(HM,KM,LM,DISTMAX,RA,RB,RC,RAL,RBE,RGA);
  WRITELN(' HM = ',HM:3,', KM = ',KM:3,', LM = ',LM:3);
  G := NIL; (* INITIALISE L'ARBRE DE TRI A NIL *)
  NREF := 0;
  FOR HC := HM DOWNTO -HM DO
  FOR KC := KM DOWNTO -KM DO
  FOR LC := LM DOWNTO -LM DO
  FOR NQ := NQN TO NQM DO
  IF NOT BNQZ OR (NQ <> 0) THEN
  BEGIN
    (* ILAT ORDER IS 'PABCIRF' *)
    CASE ILAT OF
      1: BOK := TRUE; (* P *)
      2: BOK := ((KC+LC) MOD 2 = 0);
      3: BOK := ((LC+HC) MOD 2 = 0);
      4: BOK := ((HC+KC) MOD 2 = 0);
      5: BOK := ((HC+KC+LC) MOD 2 = 0);
      6: BOK := ((-HC+KC+LC) MOD 3 = 0);
      7: BOK := ((HC + KC) MOD 2 = 0) AND ((KC + LC) MOD 2 = 0)
    END;
    IF BOK THEN
    BEGIN
      DC := DIST(HC,KC,LC,NQ); (* CALCUL LE 1/2D == MODULE DE H  *)
      BOK := (DC <= DISTMAX) AND (DC >= DISTMIN)
    END;
    IF BOK THEN
    BEGIN
      (* CONSTRUCTION DU GRAPHE *)
      P1 := G; (* PART DU SOMMET DU GRAPHE - QUI EST UN ARBRE *)
      P2 := NIL;
      WHILE (P1 <> NIL) AND BOK DO
      BEGIN
        IF ABS(DC - P1^.DIST) < DIST_TOL THEN
        BEGIN (* CAN BE AN EQUIVALENT REFLEXION *)
          PE1 := P1^.EQHDE;
          { MOTHER REFLEXION CANNOT BE TESTED }
          WHILE (PE1 <> NIL) AND BOK DO
          BEGIN
            WITH PE1^ DO
              BOK := (ABS(HH-SH) > 1E-5) OR
                     (ABS(KK-SK) > 1E-5) OR (ABS(LL-SL) > 1E-5);
            IF BOK THEN PE1 := PE1^.LNK ELSE PE1 := NIL
          END
        END;
        IF BOK THEN { NOT EQUIVALENT REFLEXION }
        BEGIN
          ICMP := ORD(DC <> P1^.DIST);
          P2 := P1;
          IF ICMP <> 0 THEN
	    IF DC < P1^.DIST THEN ICMP := -1;
          IF ICMP < 0 THEN P1 := P1^.LP ELSE P1 := P1^.RP
        END
      END (* WHILE *);
      IF BOK THEN
      BEGIN
        NREF := NREF + 1;
        NEW(P); (* CREE UN NOUVEAU TRIPLET POINTE PAR P *)
        WITH P^ DO (* AVEC LE NOUVEL OBJET DE TYPE TRIPLET FAIRE *)
        BEGIN
          LP := NIL; RP := NIL; (* INITIALISE LES POINTEURS DE GRAPHE *)
          H := HC; K := KC; L := LC; NQC := NQ; (* MET LES INDICES *)
          MULT := MULTIPLICITY( HC, KC, LC, NQC, EQHDE );
          DIST := DC
        END;
        IF P2 = NIL THEN G := P
        ELSE
          IF ICMP < 0 THEN P2^.LP := P ELSE P2^.RP := P
      END
    END (* IF BOK THEN... *);
  END (* FOR H,K,L ... DO *);
  IF G <> NIL THEN
    OUTTRIPLET(G); (* SORT TOUT LES TRIPLETS DANS L'ORDRE CROISSANT *)
  CLOSE( OUT );
  WRITELN;
  WRITELN(' THERE ARE ',NREF,' SORTED REFLEXIONS.');
  WRITELN;
END.
