/* environment file for Pascal-To-C (CPAS) Run-Time Support */

#include <stdlib.h>
#include <math.h>
#include <string.h>
#include <setjmp.h>

#ifdef BASIC_IO
#  ifdef VMS
#    include <processes.h>
#    include <unixio.h>
#    include <unixlib.h>
#    include <file.h>
#    define _Fork         vfork
#  else
#    include <fcntl.h>
#    include <unistd.h>
#    if (defined( _WIN32 )||defined( __CYGWIN__ )||defined(__CYGWIN32__))
#      include <io.h>
#      ifdef __GNUC__
#        include <dirent.h>
#      else
#        include <direct.h>
#      endif
#      include <stdio.h>
#      include <process.h>
/*
#    else
#      include <unistd.h> */
#    endif
#    define _Fork         fork
#  endif
#endif

#define  max_lex  32  /* maximum lex level (for 32 procedure nesting) */


#ifdef CC_CHAR_UNS
  typedef          char        C;
  typedef          char       UB;
  typedef   signed char       SB;
#else
  typedef unsigned char        C;
  typedef unsigned char       UB;
  typedef          char       SB;
#endif

typedef            CC_TYPE_SW SW;
typedef   unsigned CC_TYPE_SW UW;
typedef            CC_TYPE_SL SL;
typedef   unsigned CC_TYPE_SL UL;

#ifdef CC_TYPE_SQ
  typedef          CC_TYPE_SQ SQ;
  typedef unsigned CC_TYPE_SQ UQ;
#endif

typedef            float       F;
typedef            double      G;

typedef            C           S;
typedef            C    *      V;


typedef union BLK_blk { C  *c;
                        UB *ub;
                        SB *sb;
                        UW *uw;
                        SW *sw;
                        UL *ul;
                        SL *sl;
                        F  *f;
                        G  *g;
            union BLK_blk  *p;
                        V  *v;
                        S  *s;
                      } P;


#define  S_C   sizeof( C  )
#define  S_B   sizeof( SB )
#define  S_W   sizeof( SW )
#define  S_L   sizeof( SL )
#define  S_F   sizeof( F  )
#define  S_G   sizeof( G  )
#define  S_P   sizeof( P  )


/* Memory Location block definitions */

#define Blk( Ident, Size )   union { UB ub[ Size/S_B ]; \
                                     SB sb[ Size/S_B ]; \
                                     C  c [ Size/S_C ]; \
                                     UW uw[ Size/S_W ]; \
                                     SW sw[ Size/S_W ]; \
                                     UL ul[ Size/S_L ]; \
                                     SL sl[ Size/S_L ]; \
                                     F  f [ Size/S_F ]; \
                                     G  g [ Size/S_G ]; \
                                     P  p [ Size/S_P ]; \
                                     V  v [ Size/S_P ]; \
                                     S  s [ Size/S_B ]; \
                                   } Ident




#ifndef PAS_RTL
  extern V PAS__curr_iptr;
  extern V PAS__curr_optr;
  extern V PAS__curr_cntx;


#define PAS__CHECK_VPARM( p )  (p!=NULL) /* Define check var parameter */
#define PAS__ADDRESS_VPARM( p ) (p)

  int  PAS__RANGE( SL, SL, SL );

  V    PAS__NEW( SL );
  void PAS__DISPOSE( V* );

  SL   PAS__SETENV( V, V, SL );
  SL   PAS__GETENV( V, V );
  UB   PAS__SET_FILESPC( V, V, UL );
  V    PAS__GET_DEF_DIR( V );
  UB   PAS__CHANGE_DIR( V, UL );
  UB   PAS__SET_FILEDEF( V );
  SL   PAS__GETPHYSIC( V, V );

  UB   PAS__SYSTEM( V );

  SL   PAS__IIPOWER( SL, SL );
  F    PAS__IFPOWER( F, SL );
  G    PAS__IGPOWER( G, SL );

  void PAS__CHA_TO_STR( V, C );
  void PAS__CHT_TO_CHT( V, SL, V, SL );
  void PAS__CHT_TO_STR( V, V, SL );
  void PAS__STR_TO_STR( V, V );

  V    PAS__CON_CHA_CHA( V, C, C );
  V    PAS__CON_STR_CHA( V, V, C );
  V    PAS__CON_CHT_CHA( V, V, SL, C );
  V    PAS__CON_CHA_STR( V, C, V );
  V    PAS__CON_CHA_CHT( V, C, V, SL );
  V    PAS__CON_STR_STR( V, V, V );
  V    PAS__CON_STR_CHT( V, V, V, SL );
  V    PAS__CON_CHT_STR( V, V, SL, V );
  V    PAS__CON_CHT_CHT( V, V, SL, V, SL );

  V    PAS__SUBSTR_STR( V, V, SL, SL );
  V    PAS__SUBSTR_CHT( V, V, SL, SL, SL );

  UB   PAS__LT_STR( V, V );
  UB   PAS__LE_STR( V, V );
  UB   PAS__GE_STR( V, V );
  UB   PAS__GT_STR( V, V );
  UB   PAS__EQ_STR( V, V );
  UB   PAS__NE_STR( V, V );

  UB   PAS__LT_CHT( V, SL, V, SL );
  UB   PAS__LE_CHT( V, SL, V, SL );
  UB   PAS__GE_CHT( V, SL, V, SL );
  UB   PAS__GT_CHT( V, SL, V, SL );
  UB   PAS__EQ_CHT( V, SL, V, SL );
  UB   PAS__NE_CHT( V, SL, V, SL );

  SL   PAS__INDEX_STR(  V, SL, V, SL );
  SL   PAS__INDEX_CHA(  V, SL, C );

  SL   PAS__NINDEX_STR(  V, SL, V, SL, SL, SL, UB );
  SL   PAS__NINDEX_CHA(  V, SL, C, SL, SL, UB );

  SL   PAS__LENGTH_STR( V );

  SL   PAS__MATCH_STR( V, V );
  SL   PAS__MATCH_CHT( V, SL, SL, V, SL, SL );

  void PAS__STR_LSEP( V, SL, V, SL, V, SL, SL* );

  void PAS__OPEN( V *, SL, V fspc, UL, SL, SL );
  void PAS__OPEN_PIPE( V *, SL, V, UL, SL );

  void PAS__OPESTR( V, UL );

  UB   PAS__RUN_PROC_1( V, V, SL, V );
  UB   PAS__RUN_PROC_2( V, V, SL, SL, V );

  SL   PAS__CREATE_PROC_1( V, V, SL, V );
  SL   PAS__CREATE_PROC_2( V, V, SL, SL, V );

  SL   PAS__WAIT_PROCESS( SL*, SL* );

  void PAS__CREATE_PIPE( V, SL, UB );

  void PAS__CLOSE ( V*, UL );
  void PAS__SEEK  ( V, SL );
  UB   PAS__EOF   ( V );
  UB   PAS__EOF_INP();
  UB   PAS__UFB   ( V );
  UB   PAS__UFB_INP();
  UB   PAS__EOLN  ( V );
  UB   PAS__EOLN_INP();
  UB   PAS__TTY_FILE( V );
  UB   PAS__TTY_CLREOF( V );
  UL   PAS__FILE_STATE( V );
  V    PAS__FILE_SPC( V, V );

  UB   PAS__CURR_EOF();
  UB   PAS__CURR_EOLN();

  void PAS__GET( V );
  void PAS__PUT( V );

  void PAS__PAGE( V );

#define PAS__SELECT_INP( fi ) PAS__curr_iptr = fi;
#define PAS__SELECT_OUT( fi ) PAS__curr_optr = fi;

  void PAS__VREAD_INIT( V, SL, SL* );

  void PAS__VWRITE_INIT( V, UB );

  void PAS__READ_CHAR( C* );
  void PAS__WRITE_CHAR( C );
  void PAS__READ_EOLN();
  void PAS__WRITE_EOLN();

  void PAS__READ_STR(  V, SL, UB );
  void PAS__READ_CHT(  V, SL, SL, UB );

  void PAS__WRITE_MCHAR( C, SL );
  void PAS__WRITE_STR( V, SL, SL, C );
  void PAS__WRITE_CHT( V, SL, SL, SL, C );
  void PAS__WRITE_FCHAR( C, SL, SL, SL, C );

  void PAS__READ_SL( SL*, SL );
  void PAS__READ_UL( UL*, SL );
  void PAS__READ_SW( SW*, SL );
  void PAS__READ_UW( UW*, SL );
  void PAS__READ_SB( SB*, SL );
  void PAS__READ_UB( UB*, SL );

  void PAS__READ_ENM( V, SL, V, SL );

  void PAS__WRITE_INT( SL, SL, SL );

  void PAS__WRITE_ENM( UL, V, SL, SL, C );

  void PAS__READ_SNGL( F*, SL );
  void PAS__WRITE_SNGL( F, SL, SL, SL );

  void PAS__READ_DBLE(  G*, SL );
  void PAS__WRITE_DBLE( G, SL, SL, SL );

  void PAS__READ_BIN( V ); 
  void PAS__WRITE_BIN( V ); 

  void PAS__OPEN_DIR( V*, V, UL );
  void PAS__CLOSE_DIR( V*);
  void PAS__READ_DIR( V, V, SL* );
  SL   PAS__FILE_KIND( SL );

  void PAS__MAKE_DIR( V, UL, SL );
  void PAS__REMOVE_DIR( V, UL );

  V    PAS__SET_GENERATOR( V, SL, SL );
  void PAS__ASSIGN_LSET(   V, SL, V, SL );
  V    PAS__BIS_LSET(  V, V, SL, V, SL );
  V    PAS__BAND_LSET( V, V, SL, V, SL );
  V    PAS__COM_LSET(  V, V, SL );
  V    PAS__BIC_LSET(  V, V, SL, V, SL );
  UB   PAS__RINCL_LSET(V, SL, V, SL );
  UB   PAS__INCL_LSET( V, SL, V, SL );
  UB   PAS__NEQ_LSET(  V, SL, V, SL );
  UB   PAS__EQU_LSET(  V, SL, V, SL );
  UB   PAS__INOP_LSET( SL, V, SL );

  F    PAS__RANDOM( SL* );

  F    PAS__SHF( F );
  F    PAS__CHF( F );
  F    PAS__THF( F );
  F    PAS__ASHF( F );
  F    PAS__ACHF( F );
  F    PAS__ATHF( F );

  G    PAS__SHG( G );
  G    PAS__CHG( G );
  G    PAS__THG( G );
  G    PAS__ASHG( G );
  G    PAS__ACHG( G );
  G    PAS__ATHG( G );

  G    PAS__CLOCK();
  void PAS__N_TIME( V, SL, UB );

  void PAS__TIME_STR( V );
  void PAS__TIME_CHT( V, SL );

  void PAS__DATE_STR( V );
  void PAS__DATE_CHT( V, SL );

  SL   PAS__GF_INFO( V, V, SL, UB, UB, UL );
  SL   PAS__READLINK( V, V );
  UB   PAS__FILE_ACCESS( V, SL, UL );
  UB   PAS__FILE_RENAME( V, V, UL, UL );
  UB   PAS__FILE_REMOVE( V, UL );

  SL   PAS__USER_UID();
  SL   PAS__USER_GID();

  SL   PAS__SET_TIMER( F, F );
  F    PAS__WAIT_TIMER();
  F    PAS__DELAY( F );
  SL   PAS__SLEEP( SL );

  void PAS__ESTABLISH( int (* phdl) (int) );
  void PAS__REVERT();
  void PAS__GET_RTLMSG( SL, V );

  void PAS__EXE_IOPRO( V, V );

  S Adr__Ptr( V    p, V   v );
  S Adr__cha( C      *c, C      v );
  S Adr__wrd( short  *w, short  v );
  S Adr__int( SL     *i, SL    v );
  S Adr__sng( F      *f, F      v );
  S Adr__dbl( G      *d, G      v );

static C  * PAS__Ptrc ( C  * p, C  v ) { *p = v; return p; }
static UB * PAS__Ptrub( UB * p, UB v ) { *p = v; return p; }
static SB * PAS__Ptrsb( SB * p, SB v ) { *p = v; return p; }
static UW * PAS__Ptruw( UW * p, UW v ) { *p = v; return p; }
static SW * PAS__Ptrsw( SW * p, SW v ) { *p = v; return p; }
static UL * PAS__Ptrul( UL * p, UL v ) { *p = v; return p; }
static SL * PAS__Ptrsl( SL * p, SL v ) { *p = v; return p; }
static V  * PAS__Ptrv ( V  * p, V  v ) { *p = v; return p; }
static F  * PAS__Ptrf ( F  * p, F  v ) { *p = v; return p; }
static G  * PAS__Ptrg ( G  * p, G  v ) { *p = v; return p; }

  UB     PAS__SET_LE( UL, UL );
  SL     PAS__I_SQR( SL );
  SL     PAS__I_MOD( SL, SL );
  float  PAS__F_SQR( float );
  double PAS__G_SQR( double );
  SL     PAS__F_ROUND( float );
  SL     PAS__G_ROUND( double );

#ifndef BASIC_IO
  void PAS__INIT( SL parc, C * parv[] );
#endif

  void PAS__DEBUG_CHECK( SL );
  void PAS__EXIT( SL );

#endif
