{
///////////////////////////////////////////////////////////////////////////////
//                                                                           //
//                                                                           //
//                     Global Public Licence (GPL)                           //
//                                                                           //
//                                                                           //
//    This license described in this file overrides all other licenses       //
//    that might be specified in other files for this software.              //
//                                                                           //
//    This program is free software; you can redistribute it and/or          //
//    modify it under the terms of the GNU Lesser General Public             //
//    License as published by the Free Software Foundation; either           //
//    version 2.1 of the License, or (at your option) any later version.     //
//                                                                           //
//    This software is distributed in the hope that it will be useful,       //
//    but WITHOUT ANY WARRANTY; without even the implied warranty of         //
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      //
//    Library General Public License for more details.                       //
//                                                                           //
//    You should have received a copy of the GNU Lesser General Public       //
//    License along with this library (see COPYING.LIB); if not, write to    //
//    the Free Software Foundation :                                         //
//                         Inc., 675 Mass Ave, Cambridge, MA 02139, USA.     //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////
}

{************     CPAS  version    *************}

{
        *** Modification(s) from major version ***


                  ----

                 NOTHING

                  ----

}

module SATELLITE_LIB;
{ Small Routines library to manage intelligente inputs
  from the terminal or an file.

  Source file for the Satellite_Lib Module.

}

%include               'satellite_env';         { Get our specific environment }

const
  max_lnsz      =                  255;         { Maximum possible for a line = max. of string capacity }


[static]
var
  cur_line:  string( max_lnsz ) :=  '';         { The current input line }
  cur_lidx,                                     { The current input line index }
  cur_lnbr:             integer :=   0;         { The current input line number }

[global]
var
  inp_string_flg,                               { Input in a string flag }
  inp_file_req,                                 { Input mode false/true for open requested cmd_file }
  inp_file_flg:       boolean := false;         { Input mode false/true for cmd_line/file }

  inp_ch:                  char := ' ';         { Last input char }
  inp_symb:       symb_type := sy_eoln;         { Type of Last symbol }
  inp_ident:                  ide_name;         { Last input symbol }
  inp_code:                    integer;         { The current identifier command code }
  inp_string,                                   { The current input string }
  inp_str:                      string;         { Last input string }
  inp_real:                       real;         { Last input floatting number }
  inp_string_idx,                               { Index for string input }
  inp_int:                     integer;         { Last input integer }

  inp_csmbtb:        cmd_stbptr := nil;         { Current symbol table pointer }

  inp_rsstr,                                    { Flag for restrictive wild string input mode }
  inp_mdstr,                                    { Flag for wild string input mode }
  inp_mdlin:          boolean := false;         { Flag for wild line string input mode }

  inp_prompt,                                   { The Main input Prompt }
  inp_prompt2:        string  :=    '';         { The Specified Input Prompt }

  inp_file:                       text;         { Input file when used }



procedure OUT_INP_LINE;
begin
  if cur_lnbr > 0 then
  begin
    WRITELN( ' *** at line # ', cur_lnbr:0 );
    if cur_line.length > 0 then
    begin
      WRITELN( ' ', cur_line );
      WRITE( ' ' );
      for ii := 1 to cur_lidx - 2 do WRITE( '-' );
      WRITELN( '^' );
      WRITELN
    end
  end
end OUT_INP_LINE;



[global 'ERROR1']
procedure ERROR( in_var mdnam, msg: string; in_var parm: [optional] ide_name );
begin
  WRITELN;
  WRITE( ' *** Gen_Approx Error (', mdnam, ') : ', msg );
  if parm"address = nil then WRITELN( '. ***' )
                        else WRITELN( ' "', parm.str:parm.len, '".' );
  OUT_INP_LINE;
  PASCAL_EXIT( 2 )
end ERROR;



[global 'ERROR2']
procedure ERROR( in_var mdnam, msg: string; in_var parm: [optional] string );
begin
  WRITELN;
  WRITE( ' *** Gen_Approx Error (', mdnam, ') : ', msg );
  if parm"address = nil then WRITELN( '. ***' )
                        else WRITELN( ' "', parm, '".' );
  OUT_INP_LINE;
  PASCAL_EXIT( 2 )
end ERROR;


[global]
procedure WARNING( in_var mdnam, msg: string; in_var parm: [optional] string );
begin
  WRITELN;
  WRITE( ' *** Gen_Approx Warning (', mdnam, ') : ', msg );
  if parm"address = nil then WRITELN( '. ***' )
                        else WRITELN( ' "', parm, '".' );
  OUT_INP_LINE
end WARNING;



[global]
procedure SEARCH_FILE( in_var  path,                                    { Path to use can be string or array of char }
                              fname:                       string;      { Name of file to search }
                                acc:                      integer;      { Access required }
                       var       re:                       string;      { Returned complete file specification if found (fnd = true) }
                       var      fnd:                      boolean );    { Returned flag (true when found, false otherwise) }
{ Routine to search a file from a short PATH list (Path in a string - not an array).
}

var
  ip, ie, nb:  integer;

begin
  fnd := FILE_ACCESS_CHECK( fname, acc );                       { Before search on the local directory }
  if fnd then re := fname
  else
  begin
    ip  :=     1; nb  :=     1;
    while (ip <= path.length) and not fnd do                    { Loop on all PATH entry }
    begin
      ie  := INDEX( path, ',', nb );
      if ie = 0 then ie := path.length + 1;
      re  := SUBSTR( path, ip, ie - ip )||fname;
      ip  := ie + 1; nb := nb + 1;
      fnd := FILE_ACCESS_CHECK( re, acc );
    end;
    if not fnd then re.length := 0
  end
end SEARCH_FILE;



[global]
function IDE_MATCH( in_var id1, id2: ide_name ): boolean;
var
  i: integer;

begin
  if id1.len = id2.len then
  begin
    i := 1;
    while (i <= id1.len) and (id1.str[i] = id2.str[i]) do i := i + 1;
    IDE_MATCH := (i > id1.len)
  end
  else IDE_MATCH := false
end IDE_MATCH;



[global 'IDE_SEARCH1']
function IDE_SEARCH( in_var idetab: cmd_smbtb;
                     in_var ide: ide_name ): integer;
var
  i: integer;

begin
  i := 1;
  while (i <= idetab.sz) and not IDE_MATCH( idetab[i], ide ) do
    i := i + 1;
  if i > idetab.sz then IDE_SEARCH := -1
                   else IDE_SEARCH := idetab[i].cod
end IDE_SEARCH;



[global 'IDE_SEARCH2']
function IDE_SEARCH( in_var idetab: cmd_smbtb;
                     in_var id: string ): integer;
var
  ide: ide_name;
  i: integer;

begin
  i := id.length;
  if i > max_lid then i := max_lid;
  while id[i] <= ' ' do i := i - 1;
  for j := 1 to i do  ide.str[j] := id[j];
  if i > 0 then
  begin
    ide.len := i;
    IDE_SEARCH := IDE_SEARCH( idetab, ide )
  end
  else IDE_SEARCH := -1
end IDE_SEARCH;



[global]
procedure CHANGE_CASE( var s: string; bmaj: boolean := false; ibg, ind: integer := 0 );
{ Use to change the case of a string or a part of a string }
const
  shch = ORD( 'A' ) - ORD( 'a' );

var
  ch: char;

begin
  if (ind <= 0) or (ind > s.length) then ind := s.length;
  if ibg <= 0 then ibg := 1;
  for i := ibg to ind do
  begin
    ch := s[i];
    if bmaj then
    begin
      if (ch >= 'a') and (ch <= 'z') then s[i] := CHR( ORD( ch ) + shch )
    end
    else
      if (ch >= 'A') and (ch <= 'Z') then s[i] := CHR( ORD( ch ) - shch )
  end
end CHANGE_CASE;



[global]
procedure NO_STRING_SPACE( var s: string );
var
  i, j:        integer;
  ch:             char;

begin
  i := 0;
  j := 0;
  while i < s.length do
  begin
    i := i + 1; ch := s[i];
    if ch > ' ' then
    begin
      j := j + 1;
      if j < i then s[j] := s[i]
    end
  end;
  s.length := j
end NO_STRING_SPACE;



[global]
procedure INSYMBOL;
const
  TAB = CHR( 7 );

type
  ch_type = ( eos, eol, ctl,                          {  EOF, EOLN, <all control character }
              oth, dig, let, quo,                     { other char, digit, letter and assim., "'"  '"' }
              dif, lpa, rpa, lbr, rbr,                { '#', '(', ')', '[', ']', }
              lac, rac,                               (* '{', '}' *)
              oor, oan, oad, osu, omu, odi, opw,      { '!' or '|', '&', '+', '-', '*', '/', '^' }
              oeq, olt, ogt,                          { '=', '<', '>' }
              scm, spe, s2p, ssc, sas                 { ',', '.', ':', ';', '\' }
            );

  ch_tab_ty  = array[CHR(0)..CHR(127)] of ch_type;


var
  ch_tab: [static] ch_tab_ty := (
         { 0    1    2    3    4    5    6    7 }     {  Meaning with XON=DC1, XOFF=DC3, SP=' '  }
  { 000 } eos, eol, ctl, ctl, ctl, ctl, ctl, ctl,     {  NUL, SOH, STX, ETX, EOT, ENQ, ACK, BEL  } 
  { 010 } ctl, ctl, ctl, ctl, ctl, ctl, ctl, ctl,     {   BS,  HT,  LF,  VT,  FF,  CR,  SO,  SI  } 
  { 020 } ctl, ctl, ctl, ctl, ctl, ctl, ctl, ctl,     {  DLE, DC1, DC2, DC3, DC4, NAK, SYN, ETB  } 
  { 030 } ctl, ctl, ctl, ctl, ctl, ctl, ctl, ctl,     {  CAN,  EM, SUB, ESC,  FS,  GS,  RS,  US  } 
  { 040 } oth, oor, quo, dif, let, let, oan, quo,     {  ' ', '!', '"', '#', '$', '%', '&', "'"  } 
  { 050 } lpa, rpa, omu, oad, scm, osu, spe, odi,     {  '(', ')', '*', '+', ',', '-', '.', '/'  } 
  { 060 } dig, dig, dig, dig, dig, dig, dig, dig,     {  '0', '1', '2', '3', '4', '5', '6', '7'  }
  { 070 } dig, dig, s2p, ssc, olt, oeq, ogt, oth,     {  '8', '9', ':', ';', '<', '=', '>', '?'  }
  { 100 } let, let, let, let, let, let, let, let,     {  '@', 'A', 'B', 'C', 'D', 'E', 'F', 'G'  }
  { 110 } let, let, let, let, let, let, let, let,     {  'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O'  }
  { 120 } let, let, let, let, let, let, let, let,     {  'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W'  }
  { 130 } let, let, let, lbr, sas, rbr, opw, let,     {  'X', 'Y', 'Z', '[', '\', ']', '^', '_'  }
  { 140 } oth, let, let, let, let, let, let, let,     {  '`', 'a', 'b', 'c', 'd', 'e', 'f', 'g'  }
  { 150 } let, let, let, let, let, let, let, let,     {  'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o'  }
  { 160 } let, let, let, let, let, let, let, let,     {  'p', 'q', 'r', 's', 't', 'u', 'v', 'w'  }
  { 170 } let, let, let, lac, oor, rac, oth, ctl);    (* 'x', 'y', 'z', '{', '|', '}', '~', DEL *)

var
  iv, id, nd: integer;
  rd, rf, rv: double;
  bok,  bnc:  boolean;

  quot, cmin: [static] char;
  chcat:      [static] ch_type;


  procedure INP_GET_SRC_LINE( var f: text );
  { Get one line from the source file }
  begin
    cur_line.length := 1;
    if inp_string_flg then
      cur_line := inp_string
    else
      if EOF( f ) then cur_line[1] := CHR( 0 )
      else if EOLN( f ) then begin  cur_line[1] := CHR( 1 ); GET( f )  end
      else
      begin
        cur_lnbr := cur_lnbr + 1;
        while not (EOF( f ) or EOLN( f ) or (cur_line.length >= max_lnsz)) do
        begin
          cur_line[cur_line.length] := f^; GET( f );
          cur_line.length := cur_line.length + 1;
        end;
        if EOF( f ) then cur_line[cur_line.length] := CHR( 0 )
        else if EOLN( f ) then cur_line[cur_line.length] := CHR( 1 )
      end;
(*
WRITE( cur_lnbr:4, ' ' );
if cur_line.length > 1 then WRITE( cur_line:cur_line.length-1 );
case ORD( cur_line[cur_line.length] ) of
0: WRITELN( ' <EOF>' );
1: WRITELN( ' <EOLN>' );
otherwise
  WRITELN( '<???>' );
end;
*)
    inp_ch := cur_line[1];
    cur_lidx := 1
  end INP_GET_SRC_LINE;



  procedure INP_GETCH;
  { Procedure to get One character from the input stream }
  begin
    if (inp_ch <= CHR( 1 ) or (cur_lidx >= cur_line.length)) then
      if inp_file_flg then
        INP_GET_SRC_LINE( inp_file )      { Get the first character of line of EOLN/EOF Mark }
      else
      begin
        if UFB( input ) then
          if inp_prompt2.length > 0 then WRITE( output, inp_prompt2 )
                                    else WRITE( output, inp_prompt );
        INP_GET_SRC_LINE( input )
      end
    else
    begin
      cur_lidx := cur_lidx + 1;
      inp_ch := cur_line[cur_lidx]
    end;
    if ORD( inp_ch ) <= 127 then chcat := ch_tab[inp_ch]
                            else chcat := oth;
    if (inp_ch >= 'A') and (inp_ch <= 'Z') then
      cmin := CHR( ORD( inp_ch ) + (ORD( 'a' ) - ORD( 'A' )) )
    else
      cmin := inp_ch
  end INP_GETCH;


(*
  procedure INP_GETCH_IN_FILE( var f: text );
  { Procedure to get One character from the input stream }
  begin
    if inp_string_flg then
      if inp_string_idx <= inp_string.length then
      begin
        inp_ch := inp_string[inp_string_idx];
        inp_string_idx := inp_string_idx + 1
      end
      else inp_ch := CHR( 0 )
    else
      if EOF( f ) then inp_ch := CHR( 0 )
      else
        if EOLN( f ) then
        begin  GET( f ); chcat := eol; inp_ch := CHR( 1 )  end
        else
        begin
          inp_ch := f^; GET( f );
          if inp_ch <= ' ' then inp_ch := ' '
        end
  end INP_GETCH_IN_FILE;



  procedure INP_GETCH;
  begin
    if inp_file_flg then
      INP_GETCH_IN_FILE( inp_file )
    else
    begin
      if UFB( input ) then
        if inp_prompt2.length > 0 then WRITE( output, inp_prompt2 )
                                  else WRITE( output, inp_prompt );
      INP_GETCH_IN_FILE( input )
    end;
    chcat := ch_tab[inp_ch];
    if (inp_ch >= 'A') and (inp_ch <= 'Z') then
      cmin := CHR( ORD( inp_ch ) + (ORD( 'a' ) - ORD( 'A' )) )
    else
      cmin := inp_ch
  end INP_GETCH;
*)


  procedure GET_INP_STRING;
  var
    bstp:  boolean;

  begin
    bstp := false;
    inp_str.length := 1;                      { Init the string variable with the first chracter }
    inp_str[inp_str.length] := inp_ch;
    loop
      INP_GETCH;
      if inp_mdlin then
        bstp := (chcat = eos) or (chcat = eol)
      else
        case chcat of
          oth: if not inp_mdlin then
                 if (inp_ch = ' ') or (inp_ch = TAB) then bstp := true;
          let, dig, oor,        { Lettre, Figure, '!' and '|' }
          oan, oad, osu,        { '&', '+', '-' }
          omu, odi, opw,        { '*', '/', '^' }
          oeq, olt, ogt,        { '=', '<', '>' }
          spe: ;                { '.' }

          scm, s2p:             { ',', ':' }
            if inp_rsstr then bstp := true;

        otherwise
          bstp := true
        end;
    exit if bstp;
      if inp_str.length < inp_str.capacity then
        inp_str.length := inp_str.length + 1; { Check for string overflow }
      inp_str[inp_str.length] := inp_ch       { When OK, append the current character }
    end;
    inp_symb  := sy_str;                      { We have found a string }
    bnc := false                              { The next character is already got }
  end GET_INP_STRING;


begin { INSYMBOL }
  bnc := true;                                { Assume: we must read the next character }
  while inp_ch = ' ' do INP_GETCH;            { Skip any space character }
  repeat
    bok := true;                              { Assume stop to read (important for comments) }
    case chcat of
      dif: { # : End of line as a Comment }
        begin
          while (chcat <> eos) and (chcat <> eol) do INP_GETCH;
          if chcat <> eos then
          repeat
            INP_GETCH; { Skip to next not spacing character }
          until inp_ch <> ' ';
          bok := false
        end;

      lac: (* "{ ... }" Comment in text can be on many lines *)
        begin
          while (chcat <> eos) and (chcat <> rac) do INP_GETCH;
          if chcat <> eos then
          repeat
            INP_GETCH; { Skip to next not spaing character }
          until inp_ch <> ' ';
          bok := false
        end;

      quo: { String Quote }
        begin
          inp_str.length := 0;                { Clear the string variable }
          quot := inp_ch;                     { Keep the memory of quote character }
          loop
            INP_GETCH;
          exit if chcat = eos;                { Stop on end of file }
            if chcat = eol then
              INP_GETCH;                      { Ignore any eoln }
            if inp_ch = quot then             { On a Quote character }
            begin
              INP_GETCH;                      { Get the next one }
          exit if inp_ch <> quot              { Unique Quote => End of String }
              { Double quote => Insert one quote in string }
            end;
            if inp_str.length < inp_str.capacity then
              inp_str.length := inp_str.length + 1;   { Check for string overflow }
            inp_str[inp_str.length] := inp_ch
          end;
          inp_symb := sy_str;                 { We have found a string }
          bnc := false                        { The next character is already got }
        end;

      let: { Alpha character => Identifier }
        if inp_mdstr or inp_mdlin or inp_rsstr then GET_INP_STRING
        else
        with inp_ident do
        begin
          len := 0;                           { Clear the current identifier name }
          inp_str.length := 0;                { Clear the string variable }
          repeat
            if len < max_lid then             { Check for string overflow }
              len := len + 1;
            str[len] := cmin;
            if inp_str.length < inp_str.capacity then
              inp_str.length := inp_str.length + 1;   { Check for string overflow }
            inp_str[inp_str.length] := inp_ch;
            INP_GETCH;                        { Get the next character }
          until ((chcat <> let) and (chcat <> dig)) or (len >= max_lid);
          inp_symb := sy_ident;
          bnc := false;                       { The next character is already got }
          if inp_csmbtb <> nil then
            inp_code := IDE_SEARCH( inp_csmbtb^, inp_ident )
          else
            inp_code := 0
        end;

      dig, spe: { Figures character }
        if inp_mdstr or inp_mdlin or inp_rsstr then GET_INP_STRING
        else
        begin
          rv := 0.0; rf := 1.0; nd := 0;
          inp_symb := sy_int;                 { Assume to be an integer }
          while chcat = dig do
          begin
            id := ORD( inp_ch ) - ORD( '0' ); { Get the figure value }
            if id = 0 then nd := nd + 1       { Count of zero at left of decimal period }
                      else nd := 0;           { ... to allow to use the integer exponentiel form }
            rv := rv*10.0 + id;               { Form the integer part of the number }
            INP_GETCH                         { Get the next character }
          end;
          if chcat = spe then
          begin
            nd := 0;                          { Eliminate the integer kind of number }
            INP_GETCH;
            inp_symb := sy_real;              { Set to be a real (floatting number) }
            while chcat = dig do
            begin
              id := ORD( inp_ch )-ORD( '0' ); { Get the figure value }
              rf := rf*0.1;
              rv := rv + id*rf;               { Form the decimal part of the number }
              INP_GETCH                       { Get the next character }
            end
          end;
          if cmin = 'e' then
          begin
            INP_GETCH;                        { Gobble up the Exponant character }
            iv := 0;                          { Prepare the exponant read }
            rd := 10.0;
            if (inp_ch = '+') or (inp_ch = '-') then
            begin                             { Manage the exponant signe }
              if inp_ch = '-' then rd := 0.1;
              INP_GETCH
            end;
            while chcat = dig do
            begin
              id := ORD( inp_ch )-ORD( '0' ); { Get the figure value }
              iv := iv*10 + id;               { Form the exponant value }
              INP_GETCH                       { Get the next character }
            end;
            rf := 1.0;
            while iv <> 0 do                  { Form rf = rd**iv }
              if ODD( iv ) then
              begin  iv := iv - 1; rf := rf*rd  end
              else
              begin  iv := iv div 2; rd := SQR( rd )  end;
            { Set as impossible value for integer when exponent is < -nd }
            if nd - iv < 0 then inp_symb := sy_real;
            rv := rv*rf                       { Finish to form the Real Number }
          end;
          { Set the integer value when it is possible }
          if (rv <= double( integer"last )) and
             (rv >= double( integer"first )) then iv := ROUND( rv )
          else begin  iv := 0; inp_symb := sy_real  end;
          inp_real := rv; inp_int := iv;
          bnc := false                        { The next character is already got }
        end;

      oor: inp_symb := sy_or_op;
      oan: inp_symb := sy_and_op;
      oad: inp_symb := sy_add_op;
      osu: inp_symb := sy_sub_op;
      omu: begin
             INP_GETCH;
             if chcat = omu then inp_symb := sy_power_op
                            else begin  inp_symb := sy_mul_op; bnc := false  end
           end;
      odi: inp_symb := sy_div_op;
      opw: inp_symb := sy_power_op;
      oeq: inp_symb := sy_eq_op;
      olt: begin
             INP_GETCH;
             if chcat = ogt then inp_symb := sy_ne_op
             else if chcat = oeq then inp_symb := sy_le_op
                                 else begin  inp_symb := sy_lt_op; bnc := false  end
           end;
      ogt: begin
             INP_GETCH;
             if chcat = oeq then inp_symb := sy_ge_op
                            else begin  inp_symb := sy_gt_op; bnc := false  end
           end;
      lbr: inp_symb := sy_lbra;
      rbr: inp_symb := sy_rbra;
      lpa: inp_symb := sy_lpar;
      rpa: inp_symb := sy_rpar;

      scm: inp_symb := sy_comma;
      s2p: inp_symb := sy_colon;
      ssc: inp_symb := sy_semicolon;
      sas: inp_symb := sy_antislash;

      eol: begin
             inp_ch := ' '; cmin := ' '; bnc := false; 
             inp_symb := sy_eoln
           end;

      eos: begin
             if TTY_CLR_EOF( input ) and UFB( input ) then
             begin
               inp_ch := CHR( 1 ); chcat := eol;
               cmin   := CHR( 1 );   bnc := false
             end;
             inp_symb := sy_eof
           end;

    otherwise
      WRITELN( ' ERROR *** Illegal Input char : ''', inp_ch, ''' in input.' );
      INP_GETCH;
      inp_symb := sy_illegal
    end
  until bok;
  inp_rsstr := false;
  inp_mdstr := false;
  inp_mdlin := false;
  if bnc then INP_GETCH                       { Get the next character when required }
end INSYMBOL;



[global]
procedure SKIP_SYMBOL( ts: symb_type );
var
  ps: symb_type := sy_illegal;

begin
  while (inp_symb <> sy_eof) and (inp_symb <> ts) do
  begin
    case ts of
      sy_lpar:      SKIP_SYMBOL( sy_rpar );
      sy_lbra:      SKIP_SYMBOL( sy_rbra );
      sy_eoln:      if ts = sy_semicolon then EXIT;
      sy_semicolon: if (ts = sy_rpar) or (ts = sy_rbra) then EXIT;
    otherwise
    end;
    ps := ts;
    INSYMBOL;
    if ps = sy_comma and inp_symb = sy_eoln then INSYMBOL { Ignore EOLN just after comma }
  end
end SKIP_SYMBOL;



[global]
procedure INP_INQUIRE( in_var name: string );
begin
  while inp_symb = sy_eoln do
  begin
    inp_prompt2 := name;
    INSYMBOL;
    inp_prompt2.length := 0
  end
end INP_INQUIRE;



[global]
procedure INP_R_VALUE( in_var name: string; var rv: real );
var
  num: integer;
  rvl: real;
  bdo, bng, bin: boolean;

begin
  bdo := false;
  bng := false;
  bin := true;
  INP_INQUIRE( name );
  repeat
    case inp_symb of
      sy_add_op: ;

      sy_sub_op: bng := not bng;

      sy_int:    begin { Integer or Fraction }
                   num := inp_int;
                   INSYMBOL;
                   if inp_symb = sy_div_op then
                   begin { It is a fraction }
                     INSYMBOL;
                     if inp_symb <> sy_int then
                       ERROR( 'RVAL', 'Illegal fraction : Expected form <int>/<int>' );
                     rvl := num/inp_int;
                     bdo := true
                   end
                   else 
                   begin { it is not a fraction }
                     rvl := num; bdo := true;
                     bin := false
                   end;
                   if bng then rv := - rvl
                          else rv :=   rvl
                 end; 

      sy_real: begin
                 bdo := true;
                 if bng then rv := - inp_real
                        else rv :=   inp_real
               end;

      sy_colon, sy_comma, sy_semicolon, sy_eoln:
               begin
                 bin := false;                { Never skip the separator }
                 bdo := true                  { We keep the initial rv value }
               end;
    otherwise
      ERROR( 'RVAL', 'Illegal separator.' )
    end;
    if bin then INSYMBOL
  until bdo or (inp_symb = sy_eof)
end INP_R_VALUE;



[global]
procedure INP_I_VALUE( in_var name: string; var iv: integer );
var
  rvl: real;
  bdo, bng, bin: boolean;

begin
  bdo := false;
  bng := false;
  bin := true;
  INP_INQUIRE( name );
  repeat
    case inp_symb of
      sy_add_op: ;

      sy_sub_op: bng := not bng;

      sy_int:    begin { Integer or Real }
                   if bng then iv := - inp_int
                          else iv :=   inp_int;
                   bdo := true
                 end;

      sy_real:   if (inp_real <= integer"last) or
                    (inp_real >= integer"first) then
                 begin
                   if bng then iv := - inp_real
                          else iv :=   inp_real;
                   WARNING( 'IVAL', 'Round of Floatting Value to Integer.' );
                   bdo := true
                 end
                 else
                   ERROR( 'IVAL', 'Floatting Magnitude to Large for Integer Conversion.' );

      sy_colon, sy_comma, sy_semicolon, sy_eoln:
               begin
                 bin := false;                { Never skip the separator }
                 bdo := true                  { We keep the initial rv value }
               end;
    otherwise
      ERROR( 'IVAL', 'Illegal separator.' )
    end;
    if bin then INSYMBOL
  until bdo or (inp_symb = sy_eof)
end INP_I_VALUE;



[global]
procedure INP_S_VALUE( in_var name: string; var str: string );
var
  bdo, bin: boolean;

begin
  bdo := false;
  bin := true;
  INP_INQUIRE( name );
  repeat
    case inp_symb of
      sy_str:  begin
                 if inp_str.length > str.capacity then
                   str.length := str.capacity
                 else
                   str.length := inp_str.length;
                 for i := 1 to str.length do
                   str[i] := inp_str[i];
                 bdo := true
               end;

      sy_colon, sy_comma, sy_semicolon, sy_eoln:
               begin
                 bin := false;                { Never skip the separator }
                 bdo := true                  { We keep the initial str value }
               end;
    otherwise
      ERROR( 'SVAL', 'Illegal string.' )
    end;
    if bin then INSYMBOL
  until bdo or (inp_symb = sy_eof)
end INP_S_VALUE;



[global]
function INP_SEPAR( sep: symb_type ): boolean;
begin
  if inp_symb = sep then
  begin  INSYMBOL; INP_SEPAR := true  end
  else INP_SEPAR := false
end INP_SEPAR;



[global]
procedure INP_EXPRESSION( var fac, cte: real; var str: string );
const
  mdnam = 'EXPR';

var
  val: expr_rec;

  procedure EXP_DO_OPER( op: symb_type; var v1, v2: expr_rec );
  begin
    if ABS( v2.expr_fac ) > 1.0E-5 then
      if ABS( v1.expr_fac ) > 1.0E-5 then
      begin
        if ((op <> sy_add_op) and (op <> sy_sub_op)) or
            not IDE_MATCH( v1.expr_ide, v2.expr_ide ) then
          ERROR( mdnam, 'Illegal multi-symbol expression.', v2.expr_ide )
      end
      else
        v1.expr_ide := v2.expr_ide;

    case op of
      sy_add_op:
        begin
          v1.expr_cte := v1.expr_cte + v2.expr_cte;
          v1.expr_fac := v1.expr_fac + v2.expr_fac
        end;

      sy_sub_op:
        begin
          v1.expr_cte := v1.expr_cte - v2.expr_cte;
          v1.expr_fac := v1.expr_fac - v2.expr_fac
        end;

      sy_mul_op:
        begin
          v1.expr_cte := v1.expr_cte * v2.expr_cte;
          v1.expr_fac := v1.expr_fac * v2.expr_cte
        end;

      sy_div_op:
        if v2.expr_fac > 1.0E-5 then
          ERROR( mdnam, 'Illegal Division by the symbol', v2.expr_ide )
        else
          if ABS( v2.expr_cte ) < 1.0E-5 then
            ERROR( mdnam, 'Illegal Divide by a number close of 0.0' )
          else
          begin
            v1.expr_cte := v1.expr_cte/v2.expr_cte;
            v1.expr_fac := v1.expr_fac/v2.expr_cte
          end;

    otherwise
    end
  end EXP_DO_OPER;



  function EXP_ADDSUB: expr_rec;
  var
    v1, v2: expr_rec;
    op: symb_type;


    function EXP_MULDIV: expr_rec;
    var
      v1, v2: expr_rec;
      op: symb_type;

      function EXP_UNAOPE: expr_rec;
      var
        v: expr_rec := [ 0.0, 0.0, [0, 0, ' '] ];
        bn: boolean := false;

      begin { EXP_UNAOPE }
        while (inp_symb = sy_add_op) or (inp_symb = sy_sub_op) do
        begin
          if inp_symb = sy_sub_op then bn := not bn;
          INSYMBOL
        end;
        case inp_symb of
          sy_int,
          sy_real:
            begin  v.expr_cte := inp_real; INSYMBOL  end;
          sy_ident:
            begin  v.expr_fac := 1.0; v.expr_ide := inp_ident; INSYMBOL  end;
          sy_lpar:
            begin
              INSYMBOL;
              v := EXP_ADDSUB;
              if inp_symb = sy_rpar then INSYMBOL
              else
                ERROR( mdnam, 'Right parenthesys was expected.' )
            end;
        otherwise
          ERROR( mdnam, 'Illegal Expression operator or term.' )
        end;
        if bn then
        begin
          v.expr_cte := - v.expr_cte;
          v.expr_fac := - v.expr_fac  
        end;
        EXP_UNAOPE := v
      end EXP_UNAOPE;

    begin { EXP_MULDIV }
      v1 := EXP_UNAOPE;
      while (inp_symb = sy_mul_op) or (inp_symb = sy_div_op) do
      begin
        op := inp_symb; INSYMBOL;
        v2 := EXP_UNAOPE;
        EXP_DO_OPER( op, v1, v2 )
      end;
      EXP_MULDIV := v1
    end EXP_MULDIV;

  begin { EXP_ADDSUB }
    v1 := EXP_MULDIV;
    while (inp_symb = sy_add_op) or (inp_symb = sy_sub_op) do
    begin
      op := inp_symb; INSYMBOL;
      v2 := EXP_MULDIV;
      EXP_DO_OPER( op, v1, v2 )
    end;
    EXP_ADDSUB := v1
  end EXP_ADDSUB;

begin { INP_EXPRESSION }
  val := EXP_ADDSUB;
  with val do
  begin
    fac := expr_fac;
    cte := expr_cte;
    str := SUBSTR( expr_ide.str, 1, expr_ide.len )
  end
end INP_EXPRESSION;



[global]
function INP_LOOKSEMICOLON: boolean;
begin
  INP_LOOKSEMICOLON := (inp_symb = sy_semicolon) or (inp_symb = sy_eoln);
  if inp_symb = sy_semicolon then INSYMBOL
end INP_LOOKSEMICOLON;



end SATELLITE_LIB.
