{
///////////////////////////////////////////////////////////////////////////////
//                                                                           //
//                                                                           //
//                     Global Public Licence (GPL)                           //
//                                                                           //
//                                                                           //
//    This license described in this file overrides all other licenses       //
//    that might be specified in other files for this software.              //
//                                                                           //
//    This program is free software; you can redistribute it and/or          //
//    modify it under the terms of the GNU Lesser General Public             //
//    License as published by the Free Software Foundation; either           //
//    version 2.1 of the License, or (at your option) any later version.     //
//                                                                           //
//    This software is distributed in the hope that it will be useful,       //
//    but WITHOUT ANY WARRANTY; without even the implied warranty of         //
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      //
//    Library General Public License for more details.                       //
//                                                                           //
//    You should have received a copy of the GNU Lesser General Public       //
//    License along with this library (see COPYING.LIB); if not, write to    //
//    the Free Software Foundation :                                         //
//                         Inc., 675 Mass Ave, Cambridge, MA 02139, USA.     //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////
}

{************     CPAS  version    *************}

{
        *** Modification(s) from major version ***


                  ----

                 NOTHING

                  ----

}

{ Small Routines library to manage intelligente inputs
  from the terminal or an file.

  Source file environment to use the Satellite_Lib Module.

}

const

  max_lid       =                   15;         { Maximum size of an identifier }

type
  real          =               double;         { Use double precision }

  ide_name  = record                            { The Local Identifier string definition }
                cod:           integer;         { The User code to identify the symbol }
                len:              byte;         { The length and the characters of ident. }
                str: packed array[1..max_lid] of char
              end;


  symb_type = ( sy_eof, sy_eoln,                { Type of Last symbol : EOF, EOLN Reached }
                sy_ident,                       { Identifier }
                sy_str, sy_int, sy_real,        { String, Integer, Real }
                sy_add_op, sy_sub_op,           { + - }
                sy_mul_op, sy_div_op,           { * / }
                sy_power_op,                    { ^ }
                sy_eq_op, sy_ne_op,             { = <> }
                sy_lt_op, sy_le_op,             { < <= }
                sy_ge_op, sy_gt_op,             { >= > }
                sy_or_op, sy_and_op,            { or (| or !), and (&) }
                sy_lpar, sy_rpar,               { ( ) }
                sy_lbra, sy_rbra,               { [ ] }
                sy_comma, sy_colon,             { , : } 
                sy_semicolon, sy_antislash,     { ; \ }
                sy_illegal );                   { Illegal }

  expr_rec = record
                expr_cte,                       { Constant to add }
                expr_fac: real;                 { Factor of identifier }
                expr_ide: ide_name              { Identifier (when used) }
             end;

  { Define an identifier table }
  cmd_smbtb( sz: integer ) = array[1..sz] of ide_name;

  cmd_stbptr    =           ^cmd_smbtb;         { Symbol table pointer }


[external]
var
  inp_string_flg,                               { Input in a string flag }
  inp_file_req,                                 { Input mode false/true for open requested cmd_file }
  inp_file_flg:                boolean;         { Input mode false/true for cmd_line/file }

  inp_ch:                         char;         { Last input char }
  inp_symb:                  symb_type;         { Type of Last symbol }
  inp_ident:                  ide_name;         { Last input symbol }
  inp_code:                    integer;         { The current identifier command code }
  inp_string,                                   { The current input string }
  inp_str:                      string;         { Last input string }
  inp_real:                       real;         { Last input floatting number }
  inp_string_idx,                               { Index for string input }
  inp_int:                     integer;         { Last input integer }

  inp_csmbtb:               cmd_stbptr;         { Current symbol table pointer }

  inp_rsstr,                                    { Flag for restrictive wild string input mode }
  inp_mdstr,                                    { Flag for wild string input mode }
  inp_mdlin:                   boolean;         { Flag for wild line string input mode }

  inp_prompt,                                   { The Main input Prompt }
  inp_prompt2:                  string;         { The Specified Input Prompt }

  inp_file:                       text;         { Input file when used }



procedure ERROR( in_var mdnam, msg: string; in_var parm: [optional] ide_name );
external 'ERROR1';

procedure ERROR( in_var mdnam, msg: string; in_var parm: [optional] string );
external 'ERROR2';

procedure WARNING( in_var mdnam, msg: string; in_var parm: [optional] string );
external;

procedure SEARCH_FILE( in_var  path,                                    { Path to use can be string or array of char }
                              fname:                       string;      { Name of file to search }
                                acc:                      integer;      { Access required }
                       var       re:                       string;      { Returned complete file specification if found (fnd = true) }
                       var      fnd:                      boolean );    { Returned flag (true when found, false otherwise) }
external;

function IDE_MATCH( in_var id1, id2: ide_name ): boolean;
external;

function IDE_SEARCH( in_var idetab: cmd_smbtb;
                     in_var ide: ide_name ): integer;
external 'IDE_SEARCH1';

function IDE_SEARCH( in_var idetab: cmd_smbtb;
                     in_var id: string ): integer;
external 'IDE_SEARCH2';

procedure CHANGE_CASE( var s: string; bmaj: boolean := false; ibg, ind: integer := 0 );
external;

procedure NO_STRING_SPACE( var s: string );
external;

procedure INSYMBOL;
external;

procedure SKIP_SYMBOL( ts: symb_type );
external;

procedure INP_INQUIRE( in_var name: string );
external;

procedure INP_R_VALUE( in_var name: string; var rv: real );
external;

procedure INP_I_VALUE( in_var name: string; var iv: integer );
external;

procedure INP_S_VALUE( in_var name: string; var str: string );
external;

function INP_SEPAR( sep: symb_type ): boolean;
external;

procedure INP_EXPRESSION( var fac, cte: real; var str: string );
external;

function INP_LOOKSEMICOLON: boolean;
external;

{ ********************** end of satellite definitions  ********************** }
