#
#       Makefile for GEN_APPROX program on UNIX Like systems
#
#

CC	=	gcc
PAS	=	pcmp

oDir	=	.
Bin	=	.
Src	=	.

LIB	=	-L/usr/local/lib -lcpas -lm

C_FLAGS = -O -c

P_FLAGS = -t1 -r

L_FLAGS =

SRCP =\
	$(Src)/gen_approx.pas \
	$(Src)/satellite_lib.pas

SRCS =\
	$(Src)/gen_approx.c \
	$(Src)/satellite_lib.c

Obj =\
	$(oDir)/gen_approx.o \
	$(oDir)/satellite_lib.o

#
all:    $(Bin)/gen_approx
#

$(Bin)/gen_approx: $(Obj)
	$(CC) $(L_FLAGS) $(Obj) $(LIB) $(LIBS) -o $(Bin)/gen_approx
#
$(oDir)/gen_approx.o: $(Src)/gen_approx.pas $(Src)/satellite_env.pas
	$(PAS) $(P_FLAGS) $(Src)/gen_approx
	$(CC) $(C_FLAGS) $(INC) $(Src)/gen_approx.c -o $(oDir)/gen_approx.o
#
$(oDir)/satellite_lib.o: $(Src)/satellite_lib.pas $(Src)/satellite_env.pas
	$(PAS) $(P_FLAGS) $(Src)/satellite_lib
	$(CC) $(C_FLAGS) $(INC) $(Src)/satellite_lib.c -o $(oDir)/satellite_lib.o
#
#
#
clean:
	-rm $(SRCS) $(Obj) $(Bin)/gen_approx
#
end:
