{
        *****   GDATA  Specific Const/Types Definitions   *******

*************************************************************************
*                                                                       *
*                                                                       *
*                                                                       *
*               G D A T A   (Get DATA for Diffraction)                  *
*                   using the CPAS SHELL Environment                    *
*                       ( Main Source File )                            *
*                                                                       *
*                                                                       *
*                 Version  1.4-B  - - 15-Jun-2012                       *
*                                                                       *
*                                by                                     *
*                                                                       *
*                  Pierre Wolfers, Institut Neel                        *
*                                                                       *
*            CNRS GRENOBLE,  25 Avenue des Martyrs, B.P. 166            *
*                                                                       *
*                       F 38042 GRENOBLE CEDEX 9                        *
*                                                                       *
*                             F R A N C E                               *
*                                                                       *
*                                                                       *
*                                                                       *
*************************************************************************

/////////////////////////////////////////////////////////////////////////
//                                                                     //
//                                                                     //
//                Global Public License (GPL)                          //
//                                                                     //
//                                                                     //
// This license described in this file overrides all other licenses    //
// that might be specified in other files for this library.            //
//                                                                     //
// This library is free software; you can redistribute it and/or       //
// modify it under the terms of the GNU Lesser General Public          //
// License as published by the Free Software Foundation; either        //
// version 2.1 of the License, or (at your option) any later version.  //
//                                                                     //
// This library is distributed in the hope that it will be useful,     //
// but WITHOUT ANY WARRANTY; without even the implied warranty of      //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU   //
// Library General Public License for more details.                    //
//                                                                     //
// You should have received a copy of the GNU Lesser General Public    //
// License along with this library (see COPYING.LIB); if not, write to //
// the Free Software Foundation :                                      //
//                      Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  //
//                                                                     //
/////////////////////////////////////////////////////////////////////////
        
}


{ Program to get ILL Powder Data form ILLDATA device,
  Output it on D1B or XYDATA Format,
  or generate an ASCII or Binary DATA LIBRARY
}


{ We load the Cpas Shell Base Source file environment with external variables }
%include 'PASSRC:cpas_shell_base_env.pas';              { Get the Common Cpas Shell Type Definitions }


const
  cpsh_name   = ' GDATA';                               { Program Name to use for internal error messages }
  cpsh_heading= 'GDATA V1.4-B of the 15-JUN-2012';      { Define the Listing Heading of Page }
  cpsh_deflst = 'NL:';                                  { Define the default listing file }
  cpsh_errfile= 'GDTLIB:gdata.err';                     {         Define the source error message file }
  cpsh_prompt = ' Gdata>';                              { Define the Gdata prompt }

  cpsh_defsrc = 'gdata_env.std';

  cpsh_wind_path = 'GDTLIB:;/C/cygwin/usr/local/gdata/;.';
  cpsh_unix_path = 'GDTLIB:;.';
  cpsh_ovms_path = 'GDTLIB:;/usr/local/gdata/;.';



{*********************************************************************}
{*****  G E N E R A L   D A T A   B A S E   D E F I N I T I O N  *****}
{*********************************************************************}

type
  gdreal = shreal;                                      { Define a real equivalence for gdata }


  { Define global pointer record }
  ref_ptr = record case integer of
    0:( ip: ide_ptr );        
    1:( ss: ^pstring );
    2:( si: ^integer );
    3:( sf: ^gdreal );
    4:( ts: ^ide_arrstr );
    5:( ti: ^ide_arrint );
    6:( tf: ^ide_arrflt )
  end;

  gdb_key_flags = ( gdbkf_notinp,                       { Not an Input key }
                    gdbkf_notout,                       { Not an Output key }
                    gdbkf_flg2,                         { Actually unused flags }
                    gdbkf_flg3,
                    gdbkf_flg4,
                    gdbkf_flg5,
                    gdbkf_flg6,
                    gdbkf_flg7 );

  gdb_kflg = set of gdb_key_flags;                      {         Define the set of Key Flags }

  gdbp_ptr = ^gdbp_rec;                                 { Pointer to a (Work space) parameter pointer }

  gdbe_ptr = ^gdbe_rec;                                 { Pointer to a Work space data base pointer }

  gdb_ptr  = ^gdb_data;                                 { Pointer to as data base definition }

  gdbe_ty  = ( gdbe_info,                               { Normal informative parameter }
               gdbe_dbkey,                              { Database key }
               gdbe_monitor,                            { Monitor parm }
               gdbe_timer,                              { Timer parm }
               gdbe_flag,                               { Flag for data point validity (integer array) }
               gdbe_xyz,                                { Coordinate data (integer or float array) }
               gdbe_adata,                              { Data measure (integer or float array) }
               gdbe_sigma,                              { Data measure sigma (integer or float array) }
               gdbe_rsigma,                             { Data repartition sigma (integer or float array) }
               gdbe_invalid                             { Invalid Mode }
             );        

  gdbk_ktb = record                                     { * Define the record key table }
               keyp: gdbp_ptr;                          { Key pointer }
               keyf: gdb_kflg                           { Key's flags }
             end;


  gdbp_rec = record
    gdbp_next:    gdbp_ptr;                             { Link to the next parameter for the same entry }
    gdbp_kind:   exp_kinds;                             { Parameter kind }
    gdbp_addr:     ref_ptr;                             { Parameter address location }
    gdbp_offs,                                          { For array: Offset, }
    gdbp_size:     integer                              { ... and size }
  end;

  gdbe_rec = record
    gdbe_next:    gdbe_ptr;                             { Link to next data base entry }
    gdbe_name:     pstring;                             { Pointer of attached string name }
    gdbe_rele:    gdbe_ptr;                             { Related entry link }
    gdbe_plist:   gdbp_ptr;                             { Link to parameter list }
    gdbe_type:     gdbe_ty;                             { Type of data use }
    gdbe_kflg:    gdb_kflg                              { Related flag (Used for Key Symbols) }
  end;


  gdb_data( gdb_nkey: integer ) = record
    gdb_coef:       shreal;                             { Set the normalization coefficient }
    gdb_mon,                                            { Pointer to monitor entry }
    gdb_tim,                                            { Pointer to time entry }
    gdb_ehde,                                           { First parameter pointer }
    gdb_elst:     gdbe_ptr;                             { Last parameter pointer }
    gdb_dhde,                                           { First data array pointer }
    gdb_dlst:     gdbe_ptr;                             { Last data array pointer }
    gdb_knb,                                            { Used number of key }
    gdb_dim,                                            { Number of coordinates in the measures }
    gdb_ncol:      integer;                             { Number of column in the data array }
    gdb_nrme,                                           { Flag for normalisation enable/disable }
    gdb_nrmt:      boolean;                             { Flag for normalisation by monitor }
    gdb_keytab: array[1..gdb_nkey] of gdbk_ktb          { Key's flags table }
  end;


const

  gdbf_size    =      4096;                             { Size of a Binary Data base file record }
  gdbf_intsz   = gdbf_size div integer"size;
  gdbf_fltsz   = gdbf_size div  gdreal"size;


type

  gdbf_rec = array[1..gdbf_size] of byte; { Record data }






{ ********************************************************************* }
{ ***********     Types to get and parse a GDATA command   ************ }
{ ********************************************************************* }

        


{ ******************************************************************** }
{ **********  GDAT Specific predefined identifier pointers  ********** }
{ ******************************************************************** }
        
[external] var

  gd_errcd,                                             { Gdata Sequence Error code to return }
  gd_sub_dir,                                           { Gdata Sub-directory string }
  gd_rq_numor,                                          { Gdata User Requested Numor (integer) }
  gd_ndat,                                              { Gdata Number of Numor to get for one request }
  gd_rsig: ide_ptr;                                     { Gdata Repartition Sigma Count }




{ ******************************************************************** }
{ ********  Routines to get and parse the command Language  ********** }
{ ******************************************************************** }


procedure GDATA_SHOW;      external;                    { Use to display the Current GDATA state }

procedure GDATA_SETTING;   external;                    { Use to SET the Current GDATA State }

procedure ILLDATA_FORMAT;  external;                    { Use to set/define the ILL DATA base }

procedure DATABASE_FORMAT; external;                    { Use to set/define the ILL DATA base }

procedure GET_NUMOR_OPE;   external;                    { Use to work (get numor operator) }

procedure SUMMARY;         external;                    { Use to terminate all operation }

procedure DRAW_PARM_SETUP( procedure DEF_ENTRY( in_var  nam:          string;
                                                        knd:       ide_kinds;
                                                        fnc:          wennum;
                                                        npa1:        integer;
                                                        npa2:  integer := -1 ) );
external; { Procedure to setup/initialize the Draw Environment }

function  DRAW_PLOT_SETTING: integer; external;         { Manager for all plot setting }

function  DRAW_PLOT_2D:      integer; external;         { Use for 2D Pattern drawing }

function  DRAW_PLOT_3D:      integer; external;         { Use for 3D Pattern drawing }





{*********************************************************************************************}
