#
#       Makefile for gdata on WINDOWS 95/NT and UNIX systems
#
#
#include $(PAS_DIR)/system.make

CC	=	gcc

PAS	=	/usr/local/bin/pcmp

oDir	=	.
Bin	=	.
Src	=	.
Penv	=	../cpascal_src

libDirs = -L/usr/local/lib
incDirs = -I/usr/local/include

LIBS	=	-ldraw -lcpas -lm
#LIBS	=       -lcpas -lm

C_FLAGS = -O -c

P_FLAGS = -t1

L_FLAGS = -L/usr/local/lib 

SRCP =\
	$(Src)/gdata.pas \
	$(Src)/gdata_global_env.pas \
	$(Src)/gdata_type_env.pas \
	$(Src)/gdata_util.pas \
#	$(Src)/gdata_draw.pas \
	$(Penv)/cpas_shell_base_env.pas \
	$(Penv)/cpas_shell_base.pas
	

SRCS =\
	$(Src)/gdata.c \
	$(Src)/gdata_util.c
#	$(Src)/gdata_draw.c

Obj =\
	$(oDir)/gdata.o \
	$(oDir)/gdata_util.o
#	$(oDir)/gdata_draw.o

#
all:    $(Bin)/gdata
#
#$(Bin)/gdata: $(oDir)/gdata.o $(oDir)/gdata_util.o $(oDir)/gdata_draw.o
#	$(CC) $(L_FLAGS) $(oDir)/gdata.o $(oDir)/gdata_util.o $(oDir)/gdata_draw.o $(libDirs) $(LIBS) -o $(Bin)/gdata
$(Bin)/gdata: $(oDir)/gdata.o $(oDir)/gdata_util.o
	$(CC) $(L_FLAGS) $(oDir)/gdata.o $(oDir)/gdata_util.o $(libDirs) $(LIBS) -o $(Bin)/gdata
#
gdata.o: $(Src)/gdata.pas $(Src)/gdata_global_env.pas $(Src)/gdata_type_env.pas \
	$(Penv)/cpas_shell_base_env.pas $(Penv)/cpas_shell_base.pas
	$(PAS) $(P_FLAGS) $(Src)/gdata
	$(CC) $(C_FLAGS) $(incDirs) $(Src)/gdata.c -o $(oDir)/gdata.o
#
gdata_util.o: $(Src)/gdata_util.pas $(Src)/gdata_type_env.pas $(Penv)/cpas_shell_base_env.pas
	$(PAS) $(P_FLAGS) $(Src)/gdata_util
	$(CC) $(C_FLAGS) $(incDirs) $(Src)/gdata_util.c -o $(oDir)/gdata_util.o
#
#gdata_draw.o: $(Src)/gdata_draw.pas $(Src)/gdata_type_env.pas $(Penv)/cpas_shell_base_env.pas
#	$(PAS) $(P_FLAGS) $(Src)/gdata_draw
#	$(CC) $(C_FLAGS) $(incDirs) $(Src)/gdata_draw -o $(oDir)/gdata_draw.o
#
#
clean:
	-rm gdata*.c gdata*.o gdata
#
end:
