%pragma trace 1;
{
                      *****  GDATA   *******

*************************************************************************
*                                                                       *
*                                                                       *
*                                                                       *
*               G D A T A   (Get DATA for Diffraction)                  *
*                   using the CPAS SHELL Environment                    *
*                       ( Main Source File )                            *
*                                                                       *
*                 Version  1.4-B  - - 15-Jun-2012                       *
*                                                                       *
*                                by                                     *
*                                                                       *
*                  Pierre Wolfers, Institut Neel                        *
*                                                                       *
*            CNRS GRENOBLE,  25 Avenue des Martyrs, B.P. 166            *
*                                                                       *
*                       F 38042 GRENOBLE CEDEX 9                        *
*                                                                       *
*                             F R A N C E                               *
*                                                                       *
*                                                                       *
*                                                                       *
*************************************************************************

/////////////////////////////////////////////////////////////////////////
//                                                                     //
//                                                                     //
//                Global Public License (GPL)                          //
//                                                                     //
//                                                                     //
// This license described in this file overrides all other licenses    //
// that might be specified in other files for this library.            //
//                                                                     //
// This library is free software; you can redistribute it and/or       //
// modify it under the terms of the GNU Lesser General Public          //
// License as published by the Free Software Foundation; either        //
// version 2.1 of the License, or (at your option) any later version.  //
//                                                                     //
// This library is distributed in the hope that it will be useful,     //
// but WITHOUT ANY WARRANTY; without even the implied warranty of      //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU   //
// Library General Public License for more details.                    //
//                                                                     //
// You should have received a copy of the GNU Lesser General Public    //
// License along with this library (see COPYING.LIB); if not, write to //
// the Free Software Foundation :                                      //
//                      Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  //
//                                                                     //
/////////////////////////////////////////////////////////////////////////

}

program GDATA;
{ Program to get ILL Powder Data form ILLDATA device,
  Output it on D1B or XYDATA Format,
  or generate an ASCII or Binary DATA LIBRARY
}


{ We load the Cpas Shell Base Source file environment }
{ %include 'PASSRC:cpas_shell_base_env.pas'; Get the common shell definitions }


{ We load the Source file environment }
%include 'GDASRC:gdata_global_env.pas';     { Get the Special GDATA Environment }
{ This last included file include also the file "PASSRC:cpas_shell_base_env.pas",
  the Cpas Shell Base Source file environment. }





{ ******************************************************************** }
{ **********     Types to get and parse a GDATA command   ************ }
{ ******************************************************************** }

type
  gdata_symbol = (   gdatashosy,            { Show Data Base Information }
                     gdatasetsy,            { Set Data Base information }
                      illdatasy,            { Define ILL/Numor Data Base Organisation }
                    gdatabasesy,            { Define ... }
                      onnumorsy             { Proceed an ILL/Numor DataBase action }
                 );

  gdata_funct  = ( summary_sfnc,            { Summary Builtin Function }
                  plot_set_sfnc,            { To perform any plot setting }
                    plot2d_sfnc,            { To get a PLOT 2D or 3D of a diffraction Pattern }
                    plot3d_sfnc,
                   unother_sfnc             { Temporary - Not Used }
                 );





{ ******************************************************************** }
{ ********  Routines to get and parse the Specific Commands ********** }
{ ******************************************************************** }



procedure SET_SPECIFIC_SYMBOL( procedure SET_KWD( in_var kname: string;
                                                           skw: symbol;
                                                          opkw: wennum;
                                                           ske: symbol := nothing ) );
begin { To Define all specific Key-Words }
  SET_KWD(    'show_data', specificsy,  gdatashosy );
  SET_KWD(     'set_data', specificsy,  gdatasetsy, endsy );
  SET_KWD(  'illdata_spc', specificsy,   illdatasy, endsy );
  SET_KWD( 'database_spc', specificsy, gdatabasesy, endsy );
  SET_KWD(      'proceed', specificsy,   onnumorsy  )
end SET_SPECIFIC_SYMBOL;



procedure DEFINE_SPECIFIC_ENTRY( procedure DEF_ENTRY( in_var  nam: string;
                                                              knd: ide_kinds;
                                                              fnc: wennum;
                                                             npa1: integer;
                                                             npa2: integer := -1 ) );

begin { To Define all specific built_in entries }

  { Define the summary function }
  DEF_ENTRY( 'data_summary', ide_functsp, summary_sfnc, 0 );    { Function without parameter }
(*
  DEF_ENTRY( 'plot_set', ide_functsp, plot_set_sfnc, 2 );       { Plot setting function }
  DEF_ENTRY(  'plot_2d', ide_functsp,   plot2d_sfnc, 2, 4 );    { Function with 2 to 6 parameters }
  DEF_ENTRY(  'plot_3d', ide_functsp,   plot3d_sfnc, 2, 4 );    { Function with 2 to 6 parameters }
*)

  { Define the GDATA SET count variable }
  DEF_ENTRY(  '$data_count', ide_parint,     blt_noop,  0 );
  gd_ndat     := sy_idenew;
  sy_idenew^.ide_int := 0;

  { Define the GDATA SET count variable }
  DEF_ENTRY( '$data_rsigma', ide_parint,     blt_noop,  0 );
  gd_rsig     := sy_idenew;
  sy_idenew^.ide_int := 0;

  { Define the GDATA SET get error variable }
  DEF_ENTRY(  '$data_seq_error', ide_parint, blt_noop,  0 );
  gd_errcd    := sy_idenew;
  sy_idenew^.ide_int := 0;

  { Define the GDATA SET sigma flag variable }
  DEF_ENTRY(  '$requested_numor', ide_parint, blt_noop,  0 );
  gd_rq_numor := sy_idenew;
  sy_idenew^.ide_int := 0;

  DEF_ENTRY(  '$user_subdirectory', ide_parstr, blt_noop,  0 );
  gd_sub_dir := sy_idenew;
  sy_idenew^.ide_str := nil;

 (* DRAW_PARM_SETUP( DEF_ENTRY )    *)     { Set all GDATA_DRAW Environment definitions }
end DEFINE_SPECIFIC_ENTRY;




procedure MANAGE_SPECIFIC_SYMBOL( spc_sym: wennum );
begin { To manage the specific statement }
  { *** Empty Procedure, There are No specific statement for cpsh *** }
  case spc_sym of
    gdatashosy:       GDATA_SHOW;
    gdatasetsy:    GDATA_SETTING;
    illdatasy:    ILLDATA_FORMAT;
    gdatabasesy: DATABASE_FORMAT;
    onnumorsy:     GET_NUMOR_OPE
  end
end MANAGE_SPECIFIC_SYMBOL;



procedure EXECUTE_SPECIFIC_ENTRY( npa: integer; fnc: wennum );
{ npa = number of effective parameter(s), fnc = the function specification }
var
 rv: integer;

begin
  { *****   Specific GDATA Function Dispatcher   ***** }

  case fnc of
    summary_sfnc: begin
      SUMMARY;                                                  { Call the gdata_util global function }
      EXP_PUTINT( 0 )                                           { Set an integer value 0 as result to the stack }
    end;
(*
    plot_set_sfnc: EXP_PUTINT( DRAW_PLOT_SETTING );             { Set an integer value 0 as result to the stack }
    plot2d_sfnc:   EXP_PUTINT( DRAW_PLOT_2D );                  { Call the Gdata plot 2D function }
    plot3d_sfnc:   EXP_PUTINT( DRAW_PLOT_3D );                  { Call the Gdata plot 3D function }
*)
  otherwise
  end
end EXECUTE_SPECIFIC_ENTRY;


{*********************************************************************************************}



%chaine 'PASSRC:cpas_shell_base.pas';                           { Chaine to the common interpreter code }


{*********************************************************************************************}
