#
#       Makefile for gdata on WINDOWS 95/NT/XP and UNIX systems
#
#                   For GDATA Version 1.4B
#
#               P. WOLFERS - 11-May-2012 Meylan
#
#
include $(PAS_DIR)/system.make

PAS	=	$(PAS_BIN)/pcmp

oDir	=	.
Bin	=	.
Src	=	.

LIBS	=	-ldraw

C_FLAGS = -O -c

P_FLAGS =

L_FLAGS =

SRCP =\
	$(Src)/gdata.pas \
	$(Src)/gdata_global_env.pas \
	$(Src)/gdata_type_env.pas \
	$(Src)/gdata_util.pas \
#	$(Src)/gdata_draw.pas \
	$(Src)/cpas_shell_base_env.pas \
	$(Src)/cpas_shell_base.pas \
	$(Src)/plot_pattern.pas

SRCS =\
	$(Src)/gdata.c \
	$(Src)/gdata_util.c \
#	$(Src)/gdata_draw.c \
	$(Src)/plot_pattern.c

Obj =\
	$(oDir)/gdata.o \
	$(oDir)/gdata_util.o \
#	$(oDir)/gdata_draw.o \
	$(oDit)/plot_pattern.o

#
all:    $(Bin)/gdata $(Bin)/plot_pattern
#
$(Bin)/gdata: $(oDir)/gdata.o $(oDir)/gdata_util.o
	$(CC) $(L_FLAGS) $(oDir)/gdata.o $(oDir)/gdata_util.o $(LIB) $(LIBS) -o $(Bin)/gdata
#
gdata.o: $(Src)/gdata.pas $(Src)/gdata_global_env.pas $(Src)/gdata_type_env.pas \
	$(Src)/cpas_shell_base_env.pas $(Src)/cpas_shell_base.pas
	$(PAS) $(P_FLAGS) $(Src)/gdata
	$(CC) $(C_FLAGS) $(INC) $(Src)/gdata.c -o $(oDir)/gdata.o
#
gdata_util.o: $(Src)/gdata_util.pas $(Src)/gdata_type_env.pas $(Src)/cpas_shell_base_env.pas
	$(PAS) $(P_FLAGS) $(Src)/gdata_util
	$(CC) $(C_FLAGS) $(INC) $(Src)/gdata_util.c -o $(oDir)/gdata_util.o
#
#gdata_draw.o: $(Src)/gdata_draw.pas $(Src)/gdata_type_env.pas $(Src)/cpas_shell_base_env.pas
#	$(PAS) $(P_FLAGS) $(Src)/gdata_draw
#	$(CC) $(C_FLAGS) $(INC) $(Src)/gdata_draw.c -o $(oDir)/gdata_draw.o
#

$(Bin)/plot_pattern: $(oDir)/plot_pattern.o
	$(CC) $(L_FLAGS) $(oDir)/plot_pattern.o $(LIB) $(LIBS) -o $(Bin)/plot_pattern
#
plot_pattern.o: $(Src)/plot_pattern.pas
	$(PAS) $(P_FLAGS) $(Src)/plot_pattern
	$(CC) $(C_FLAGS) $(INC) $(Src)/plot_pattern.c -o $(oDir)/plot_pattern.o
#
#
#
clean:
	-rm $(Src)/gdata*.c $(oDir)/gdata*.o $(Bin)/gdata
	-rm $(Src)/plot_pattern.c $(oDir)/plot_pattern.o $(Bin)/plot_pattern
#
end:
