;(pragma "R-")
;(pragma "L:4")
;   ************************************************************
;   *                                                          *
;   *                                                          *
;   *   D P U  - - - Version 1.0  Wolfers Pierre - C N R S     *
;   *                                                          *
;   *                                                          *
;   ************************************************************
;
;  *** Main Module ***
;
;  ****  Load the DPU componantes  ****
;
(INCLUDE "DPULIB:dpu_init.lisp_part")     ; Initialization module.
(INCLUDE "DPULIB:dpu_cpr.lisp_part")      ; Small routines module.
;
(INCLUDE "DPULIB:dpu_src_base.lisp_part") ; Source Read Base module.
(INCLUDE "DPULIB:dpu_src_main.lisp_part") ; Source Read Main module.
(INCLUDE "DPULIB:dpu_src_lsq.lisp_part")  ; Source Read LSQ routines.
;
;
;



;
; *** Routine to compile a block ***
;
(DE compiler_block (endlist)
  ; *** Loop on all statements until EOF or stop symbol ***
  (UNTIL (OR (EOF) (MEMQ *symb endlist))
    (IF (EQ *symb semicolon)              ; The single semicolon are skipped.
      (insymbol)
      (IF (SETQ  *stat (GETPROP *symb '*stat)) ; When it a legal statement ...
        (EVAL *stat)                      ; ... execute the statement compilation,
        (SYS_CALL 0 "CBLK" -50 2)         ; ... else error in this block and ...
        (skip_to_elem semicolon)          ; bypass the error item.
      )
    )
  )
)



;
; ****  Startup Parameter Setup ****
;
(SETQ dpu$p1  ()
      dpu$p2  ()
      dpu$p3  ()
      dpu$p4  ()
      dpu$p5  ()
      dpu$p6  ()
      dpu$p7  ()
      dpu$p8  ()
      tmp     '(dpu$p1 dpu$p2 dpu$p3 dpu$p4 dpu$p5 dpu$p6 dpu$p7 dpu$p8)
      dpu$opt "L-"
)
(SETQ SYS$_PARML SYS$_PARM)
(WHILE (SETQ cur_parm (NEXTL SYS$_PARML))
  (PRINT cur_parm)
  (COND
    ((EQ (INDEX cur_parm "-L" () () T) 1)
      (SETQ dpu$opt (SUBSTR cur_parm 2))
    )
    (T (WHEN tmp (SET (NEXTL tmp) cur_parm)))
  )
)
(SETQ dpu$job           dpu$p1
      dpu$input         dpu$p1
      dpu$listing       dpu$p2
      lsq$save_var_file dpu$p3
)
(UNLESS (INDEX dpu$input "." -1)
)
(FSPC_PARSE )

(WHEN dpu$listing (PRINT " LISTING = " dpu$listing ))
;
; ****  DPU main routine  ****
;
(PROGN
  (init_compiler)
  (WHEN dpu$listing
    (LISTING dpu$listing                ; select the listing.
           ()                           ; New version to create.
           ()                           ; No automatic print.
           ()                           ; No append mode.
           60                           ; 60 lines per page.
          132                           ; 132 Character by line.
    )
  )
  (LIST_HEAD ()                         ; Apply to standard output listing.
     "P. WOLFERS/Lab. Cristallographie Grenoble CNRS Software, DPU V1.2"
             T                          ; No Title.
             T                          ; No Sub Title.
  )
  (UNLESS dpu$job     (SETQ dpu$job     "TT:"))
  (OPEN 'term_inp |R|)
  (OPEN 'term_out |W|)
  (INPUT term_inp T |P|)
  (INPUT)
  (CHAINE "DPULIB:dpu_env.std")      ; Get initial source specification.
  ;
  ; *** Error Management ***
  ;
  (ON_ERROR
    (
      (err_code sys$_error)          ; Save the error code.
      (err_sev  (PLIST 'sys$_error)) ; Save the error severity.
      (err_point (PLIST 'sys$_error_point)); Save the error point.
    )
    (PRINT "*** Error Detect On " err_point)
    (IF (AND (> err_code 0) (<> 207 err_code)
        )                            ; For the Lisp detected error ...
      (IF (<= err_sev 0) T           ; Standard for warning.
        (SYS_CALL 2 "")              ; Set standard message error file ...
        (SYS_CALL 1 "LISP" err_code err_sev)
        (EXIT " End of DPU on ERROR.")
      )
                                     ; Else for DPU detected error ...
      (SYS_CALL 0 "DPU " (ABS err_code) err_sev) ; output our error message.
      (skip_to_elem semicolon)       ; skip until semicolon is reached.
      ()                             ; force continue execution.
    )
                                     ; return Lisp pointer for restart.
  )                                  ;

  (SETQ *stop ())
  (INPUT () "DPU_0>" "P")            ; Set the prompt and the Pascal comments.
  (insymbol)                         ; Read the first syntax unit.
  (UNLESS (EOF) (compiler_block '(end)))  ; Run until end or eof.
  (OUTPUT term_out)
  (EXIT "Normal end of DPU.")
)

;
; ******** End of Main D P U module *********
;
