(setq current_lex 1      ; pur les essais.
      reserved_lex 0)

;
; get a syntax unit routine.
;
(de insymbol ()
  (setq symb (read))
)

;
; identifier creation routine.
;
(de decl_ident (lex)
  ; set the current lex as unique.
  (sys_call 11 lex lex lex reserved_lex)
  (insymbol)
  (when (<> sys$_readk 1)
    (sys_call 0 "NWID" 1053 2))   ;;; An identifier was expected.
  (when (null sys$_undef)
    (sys_call 0 "NWID" 1052 2))   ;;; Identifier declared twice
                                  ;;; or was a reserved keyword.
  ; set the normal lex handling.
  (sys_call 11 current_lex 0 current_lex reserved_lex)
)

;
; create a record type.
;
(dma (implodech "record")
  (
    (rec_lex (1+ current_lex))
    (rec_typ)
    (rec_def)
    (rec_curr)
    (rec_ftype)
    (rec_size 0)
    (rec_save1 (typech "(" '(() "(")))   ; disable "("
    (rec_save2 (typech ")" '(() ")")))   ; and ")", the list macro char.
  )
  ; set current lex for creation of new type.
  (sys_call 10 rec_typ)                  ; creates the record attached lex.
  (1+ current_lex)
  ; set current lex for creation of field identifiers.

  (sys_call 11 current_lex current_lex current_lex reserved_lex)
  (setq rec_def (read))
  (1- current_lex)
  ; set current lex for operation.
  (sys_call 12)                          ; deactivates the record lex.
  (sys_call 11 current_lex 0 current_lex reserved_lex)
  (setplist rec_typ rec_def)
  (setq rec_curr rec_def)
  (while rec_curr
    (setq rec_ftype (cdr (nextl rec_curr)))
    (rplacd rec_ftype (cons rec_size (cdr rec_ftype)))
    (setq rec_size (+ rec_size (m_size (car rec_ftype))))
  )
  (rplaca rec_def (cons '*size* rec_size))
  'rec_def
)
  
;
; macro to create a new record from a defined type.
;
(dma new_record
  ( (rec_obj (read))
    (rec_spc (read))
    (rec_curr ())
    (rec_field ())
  )
  (setplist rec_obj (plist (nextl rec_spc)))
  (set rec_obj (m_allocb (getprop rec_obj '*size*)))
  (setq rec_curr (cdr (plist rec_obj)))
  (while (and rec_curr rec_spc)
    (setq rec_field (nextl rec_curr))
    (m_put (m_offset rec_obj (cadr rec_field)) (caddr rec_curr) (nextl rec_spc))
  )
)


;
;  Create a MXD Variable Record.
;
record (variable
  (curval M_FL 8 4)       ; current value.
  (cursig M_FL 8 4)       ; current sigma.
  (v_name "12345678901234567") : variable name.
  (inflim M_FL 6 2)       ; inf value.
  (suplim M_FL 6 2)       ; sup value.
  (matind M_UW 6))        ; matrix index.

(plist 'variable)


