;
; macro to create a record type.
;
(dma 'record
  (
    (rec_blk (read))
    (rec_curr ())
    (rec_ftype ())
    (rec_size 0))
  (setq rec_curr (cdr rec_blk))
  (setplist (car rec_blk) rec_blk)
  (while rec_curr
    (setq rec_ftype (cdr (nextl rec_curr)))
    (rplacd rec_ftype (cons rec_size (cdr rec_ftype)))
    (setq rec_size (+ rec_size (m_size (car rec_ftype))))
  )
  (rplaca rec_blk (cons '*size* rec_size))
  'rec_blk
)

;
; macro to create a new record from a defined type.
;
(dma new_record
  ( (rec_obj (read))
    (rec_spc (read))
    (rec_curr ())
    (rec_field ())
  )
  (setplist rec_obj (plist (nextl rec_spc)))
  (set rec_obj (m_allocb (getprop rec_obj '*size*)))
  (setq rec_curr (cdr (plist rec_obj)))
  (while (and rec_curr rec_spc)
    (setq rec_field (nextl rec_curr))
    (m_put (m_offset rec_obj (cadr rec_field)) (caddr rec_curr) (nextl rec_spc))
  )
)


;
;  Create a MXD Variable Record.
;
record (variable
  (curval M_FL 8 4)       ; current value.
  (cursig M_FL 8 4)       ; current sigma.
  (v_name "12345678901234567") : variable name.
  (inflim M_FL 6 2)       ; inf value.
  (suplim M_FL 6 2)       ; sup value.
  (matind M_UW 6))        ; matrix index.

(plist 'variable)


