;
; *** procedure to build a column menu ***
;
(DE blt_off_menu (nc)
  (IF (<= nc ncol)
    (CONS (CONCAT "Col_" (STRING nc 2)) (blt_off_menu (1+ nc)))
    ()
  )
)


(DE read_data ()
; renvoit dans les atomes suivants :
; curve -> la liste des enregistrements memoires.
; nrec leur nombres.
; ncol le nombre de colonnes.
;
;
  ;***************************** DIALOGUE ********************************
  (LET
    ( (currpt ())
      (srec    0)
      (fname  "")
      (ch     ())
    )

    ; *** ouverture du fichier des donnees ***

    (SETQ  cm_flg ())
    (UNTIL cm_flg
      (SETQ fname
        (SYS_CALL 224 "File Name" "curve")); prend le nom du fichier.
      (IF (EQ 0 (OPEN 'file "I" fname))    ; si le fichier est accessible...
        (SETQ cm_flg T)                    ; indique open O.k.
        (SYS_CALL 230 " Inaccessible or inexistant file. " )
      )
    )

    ; *** Lecture du nombre de colonnes ***

    (UNTIL (NUMBERP (SETQ ncol
                      (SYS_CALL 220 "Nb of Col." '(
                            " 1" " 2" " 3" " 4" " 5" " 6" " 7" " 8"
                            " 9" "10" "11" "12" "13" "14" "15" "16" )
                      )
                    )
           )
      (SYS_CALL 230 " The number of column of the data file was expected. ")
    )
    (SETQ col_menu (blt_off_menu 1)
          ; *** get x axis unit name ***
          untx     (SYS_CALL 224 " X unit name " "X")
          ; *** get y axis unit name ***
          unty     (SYS_CALL 224 " Y unit name " "Y")
    )

    ; *** Define the record type. ***
    (R_DEFINE rec (tb ncol . M_FL))
    ; *** Create one record identifier. ***
    (rec rec_curr)

    ; *** Mode des axes en centimetre oui/non ? ***
    (SETQ cm_flg (SYS_CALL 221 " Axis in cm ? " ) )


    ;***************** LECTURE DU FICHIER ********************

    (SETQ nrec  0
          curve (LIST ())
    )
    (INPUT 'file "Entrer un point S.V.P. ") ; selection du fichier en entree.
    (SETQ x (READ))                ; read the first value.
    (UNTIL (EOF)                   ; jusqu'a la fin du fichier faire...
      (INCR nrec)                  ; incremente le conteur d'enregistrement.

      (SETQ cblk  (M_ALLOCB srec)  ; alloue un bloc de la bonne dimension.
            index 2
      )
      (R_NEW rec_curr x)           ; Create the record and set the first val.
      (WHILE (<= index  ncol)      ; pour chaque colonne, charge la valeur lue
        (R_STORE rec_curr tb index
                (IF SYS$_READ_EOLN ; when eoln reached
                  0.0              ; padds with 0.0 ...
                  (READ)           ; else read a number.
                )
        )
        (INCR index)               ; Increases the memory offset of 4.
      )

      (ZAPLINE)                    ; go to the end of line (or eof).
      (UNLESS EOF (SETQ x (READ))) ; read the first column of next line.
      (QUEUE_PUT curve rec_curr)
    )	                           ; fin du until.

    (INPUT)                        ; Re select tty.
    (CLOSE 'file)                  ; fermeture du fichier de donnees.
  )                                ; fin du Let.
)                                  ; fin de la function read_data.
