(pragma "R-")
(INCLUDE "DPULIB:lisp_lib.lisp_lib")

;
;
;
(INCLUDE "DPULIB:dpu_rtl.lisp_part")  ; load the run time library routines.
(INCLUDE "DPULIB:dpu_lsq.lisp_part")  ; load the least-squares routines.
(INCLUDE "DPULIB:dpu_expr.lisp_part") ; load the expression routines.
;
;
;

;
; Pragma statement (call done by dma atome or by include/chaine)
; pragma <opt_str> [, ...] ;
;
(DE pragma_list ()
  (LET ( (lopt (list () )) ; allocate a new option list.
         (flg  T )
       )
    (WHILE flg
      (QUEUE_PUT lopt (get_const_string ())) ; append each option.
      (SETQ flg (skip_separ |,|))
    )
    (STACK_GET lopt)
    lopt
  )
)


(DE pragma_state ()
  (LET ((lopt (pragma_list)))
    (APPLY 'PRAGMA lopt)
    (look_separ |;| ())
    (LIST_DEL lopt)
  )
)




;
; Include/Chaine statements.
; { include | chaine } <file_spc> [, <opt_str> [, ...] ;
;
(DE include_state (flg)
  (LET ((fn (get_const_string ()))
        (st ())
       )
    (SYS_CALL 3)  ; end line in listing mode.
    (WHEN fn
      (WHEN (skip_separ |,|)
        (SETQ st (pragma_list)))
      (STACK_PUT st fn)
      (STACK_PUT st (IF flg 'INCLUDE 'CHAINE))
      (EVAL st)
      (LIST_DEL st)
      (INPUT () (CONCAT "DPU_" (STRING sys$_incl_deep 1) |>| ))
    )
  )
)




;
; Listing statement (call done by dma atome or by include/chaine)
; listing [<file_spc>, <unk_flg>, <pri_flg>, <app_flg>, <page_sz>, <line_sz>];
;
(DE listing_state ()
  (LET ( (parl (LIST () ))
       )
    (SYS_CALL 3)  ; end line in listing mode.
    (QUEUE_PUT parl (get_const_string ()))
    (WHILE (skip_separ |,|)
      (QUEUE_PUT parl (get_const_integer ()))
    )
    (EVAL (RPLACA parl 'LISTING))
    (LIST_DEL parl)
    (look_separ |;| ())
  )
)




;
; Routine to create a new identifier.
; *///* scope are not handled *///*
;
(DE create_new_ident (spc_type spc_class)
  (SETQ *symb (SYS_CALL 14 T)
        *kind sys$_readk
  )
  (IF (<> *kind 1)
    (SYS_CALL 0 "NWID" 61 3)      ; an identifier was expected.
    (IF sys$_undef
      (PUTPROP *symb '*type  spc_type
                     '*class spc_class)
      (SYS_CALL 0 "NWID" 63 3)    ; twice declared identifier.
    )
  )
)




;
; Create a new identifier list.
; the reader must be set before the first identifier to get.
; typefunc is a routine to get the type specification.
; setfunc is a routine to set type/class info.
; the routine must have the call form (routine ident type info).
;
(DE create_new_identifier ()
  (SETQ *symb (SYS_CALL 14 ()))      ; create the identifier (perform the read).
  (get_symbol_info)                  ; complet the insymbol.
  *symb
)

(DE create_new_ident_list (typefunc setfunc class)
  (create_new_identifier)            ; get the identifier.
  (WHEN (AND (EQ *kind 1) *undef)    ; only for a new identifier
    (LET ( (lid (LIST ()))           ; enter in a local work space.
           (typspc ())
           (sbclass ())
           (curr ())
         )
      (WHILE (EQ *kind 1)            ; if it is an identifier then ...
        (IF *undef                   ; when it is not already defined then ...
          (QUEUE_PUT lid *symb)      ; put it in the identifier queue,
          (SYS_CALL 0 "NWID" 63 3)   ; else, twice declared identifier error.
        )
        (create_new_identifier)      ; get the separator (or identifier).
        (IF (test_separ |,|)         ; skip a comma separator ...
          (create_new_identifier)
          (WHEN (EQ *kind 1)
            (SYS_CALL 0 "NWID" 64 3) ; ... comma or colon expected
          )
        )
      )
      (WHEN typefunc                 ; when a type setting function is given.
        (look_separ |:| T)           ; gobble up the separator.
        (SETQ typspc (FUNCALL typefunc)) ; get the type of the list elements.
      )
      (WHEN (SETQ sbclass (CDR (ASSQ '*class typspc)))
        (UNLESS (MEMQ (EVAL class) (CDR sbclass))
          (SYS_CALL 0 "NWID" 73 3)
        )
        (SET class sbclass)
      )
      (RPLACA lid typspc)            ; set the type in the begining of the list.
      (SETQ curr (CDR lid))          ; init the current setting loop.
      (WHILE curr                    ; for each identifier of the list.
        (FUNCALL setfunc (NEXTL curr) ; set each identifier specification.
                         typspc
                         class )
      )
      lid                            ; and return the list.
    )
  )
)




;
; record field declaration setting routine.
;
(DE f_setting (ident type class)     ; field setting routine.
  (PUTPROP ident '*type  type        ; set the field type.
                 '*class class       ; set the field class
                 '*owner *owner)     ; set the field owner type.
  (QUEUE_PUT *owner_list ident)      ; append field to the record list.
  ; set the lisp reference info (lisp-type offset).
  (SET ident (LIST (CDR (ASSQ '*lisp type)) *offset))
  ; add to current offset the sixe of the object.
  (SETQ *offset (+ *offset (CDR (ASSQ '*size type))))
)




;
; local variable declaration setting routine.
;
(DE v_setting (ident type class)     ; field setting routine.
  (PUTPROP ident '*type  type        ; set the variable type,
                 '*class class       ; set the object class.
  )               
)


;
; Compile a type definition block.
;
(DF dcl_type ()
  (SETQ *symb |;|
        *kind 23
  )
  (WHILE (test_separ |;|)              ; loop until no semicolon.
    (create_new_identifier)            ; create the type identifier.
    (WHEN (AND (EQ *kind 1) *undef)
      (LET ( (*owner *symb)
           )
        (insymbol)                   ; gobble up the type identifier.
        (UNLESS (test_terminator is T)
          (SYS_CALL 0 "DCLT" 57 2)
        )
        (PUTPROP *owner '*type (get_type_reference)
                        '*class '*type
        )

(PRINT " *** NEW TYPE IDENTIFIER " *owner)
(PRINT " *** WITH THE PROPERTIES : " (PLIST *owner))

      )
      (UNLESS (test_separ |;|)
        (SYS_CALL 0 "DCLT" 67 3)
        (SETQ *symb |;|
              *kind 23
        )
      )
    ) ; end of a type block declaration.
  )
)



;
; Compile a variable or record declaration block.
;
(DF dcl_varbl_block (class fsetting)
  (LET ( (lid ())
         (typ ())
         (va  ())
         (*va ())
         (ctf (EQ class '*const))
       )
    (SETQ *symb |;|
          *kind 23
    )
    (WHILE (test_separ |;|)            ; loop until no semicolon.
      (SETQ lid (create_new_ident_list 'get_type_reference fsetting class))
      (WHEN lid                        ; when not the end of declaration part.
        (IF (MEMQ class '(*field))     ; for a class without init.
          (SETQ lid (LIST_DEL lid))    ; free the specification list.
          ; else performs the variable init(s).
          (SETQ typ (STACK_GET lid)
                va  (IF (test_operator := T)
                      (get_expression) ; get the initial value.
                      (LIST '*const typ (CDR (ASSQ '*defvalue typ)))
                    )
          )
          (UNLESS (MEMQ (CAR va) in_line_class) ; if it is not constante.
            (SYS_CALL 0 "DCLV" 68 3)   ; then error.
          )
          ; *** loop to assign the initial value at each variable.
          (WHILE lid
            (SETQ *va (STACK_GET lid))
            (WHEN (ASSQ '*alloc typ) ; for the variable with allocation...
              (SET *va (M_ALLOCB (CDR (ASSQ '*size typ))))
            )

            (STACK_PUT opstk (LIST (IF ctf '*cmpv class) typ *va))
            (STACK_PUT opstk (append va)) ; add a copy of the value in the stack.
            (expr_gencall 2 ':=)       ; execute the affectation.

(PRINT " *** VALUE " (EVAL *va) " ASSIGNED TO " *va)
(PRINT " *** IDENTIFIER PROPERTIES : " (PLIST *va))
          )
          (SETQ va (LIST_DEL va))      ; free the unused initial value ref.
        )
        (UNLESS (test_separ |;|)
          (SYS_CALL 0 "DCLV" 67 3)
          (SETQ *symb |;|
                *kind 23
          )
        )
      )
    ) ; end of a variable block declaration.
  )
)




;
; *** routines to generate each standard type structure ***
;
(DE bldty_ennum ()
)

(DE bldty_range ()
)

(DE bldty_record ()
  (LET ( (ref (SYS_CALL 10 *owner)) ; create a new lex for the fields.
         (*offset 0)                ; initiatize the offset.
         (*owner_list (LIST ()))    ; create a new field list.
       )

    ; get all the field description.
    (dcl_varbl_block *field f_setting)
    (SYS_CALL 12)                  ; deselect the record field identifiers.
    (UNLESS (test_terminator end T)
      (SYS_CALL 0 "RECT" 69 3)
    )
    (NEXTL *owner_list)
    ; generate the type A-list.
    (LIST (CONS '*record ref)      ; set the record field lex spc.
          (CONS '*size  *offset)   ; set the total record size.
          (CONS '*alloc T)         ; set allocation mode.
          (CONS '*flist *owner_list); set the field list.
    )

  )
)

(DE bldty_array ()
)

(DE bldty_pointer ()
)




;
; Get a type reference and build any type descriptor.
;
(DE get_type_reference ()
  CASE *kind (
    (1 2 3)
         (LET ( (cla (GETPROP *symb '*class))
                (typ *symb)
              )
           (insymbol)                    ; gobble up the type identifier.
           (COND
             ((EQ cla '*type)            ; if it is a type identifier
               (GETPROP typ '*type))     ; return the type.
             ((MEMQ cla '(*const *cmpv)) ; for constant identifier
               (bldty_range))            ; try to define a range type.
             (T (SYS_CALL 0 "TYPR" 72 3) ; error and return wild type.
               '*wild)
           )
         )
    (6)   (bldty_range)                  ; try to build a range type.
    (23)  (bldty_ennum)                  ; ennumerated type definition.
    (22)  (FUNCALL *symb) ; for type keyword, activate the particular action.
 
    otherwise
      (PROGN
        (SYS_CALL 0 "TYPR" 78 3)
        '*wild
      )
  )
)




;
; Variable statement.
; variable <ident> [= <value> [:<sigma> : <inf> : <sup> ]];
;
(DE dcl_lsqvarbl ()
  (LET ( (flg   T)
         (val   0.0)
         (sig   0.0)
         (lim   ())
         (ident ())
       )
    (WHILE flg
      (IF (create_new_ident '*float)
        (PROGN
          (SETQ ident *symb)
          (insymbol)
          (IF (test_operator := T)
            (PROGN
              (SETQ val (get_const_float 0.0))
              (WHEN (test_separ |:|)
                (insymbol)
                (SETQ sig (get_const_float 0.0))
              )
              (WHEN (test_separ |:|)
                (insymbol)
                (SETQ lim (get_typed_const_value '*limits ()))
              )
            )
            (SETQ val 0.0 sig 0.0)
            (UNLESS (OR (test_separ |,|) (test_separ |;|))
              (SYS_CALL 0 "DCLV" 96 3)
              (skip_to_separ |,|)
            )
          )
          ; Create the least-squares variable.
          (PUTPROP ident '*varbl '*lsq_varbl        ; set the varbl class.
                         '*assign '(var_and_lim_assignement))
          (SET ident (SYS_CALL 311 ident val sig))  ; create lsq structure.
        )
        (skip_to_separ |,|)
      )
      (SETQ flg (test_separ |,|))
    )
  )
  (look_separ |;| ())
)




;
; Variable limits statement.
;
(DE dcl_limits ()
  (LET ( (flg   T)
         (min   -1.0E+10)
         (max    1.0E+10)
         (ident ())
       )
    (WHILE flg
      (IF (create_new_ident '*limits)
        (PROGN
          (SETQ ident *symb)
          (insymbol)
          (UNLESS (test_terminator 'is T)
            (SYS_CALL 0 "DCLL" 94 3)
          )
          (PROGN
            (SETQ min (get_const_float -1.0E+10))
            (IF (test_separ |:|)
              (insymbol)
              (SETQ max (get_const_float 1.0E+10))
            )
            (SETQ max 1.0E+10)
          )
          ; Create the least-squares variable.
          (PUTPROP ident '*class '*lsq_limits  ; create the limits class.
                         '*assign '(var_and_lim_assignement))
          (SET ident (SYS_CALL 313 min max))   ; create the lsq structure.
        )
        (skip_to_separ |,|)
      )
      (SETQ flg (test_separ |,|))
    )
  )
  (look_separ |;| ())
)




;
; Variable Parameter statement.
; param <ident> [= <value> [:<sigma> : <inf> : <sup> ]];
;
(DE dcl_lsqparm ()
  (LET ( (flg       T)
         (ident     ())
         (formula   ())
         (sumflg    ())
         (derflg    ())
         (sigflg    ())
         (cacheflg  ())
       )
    (WHILE flg
      (IF (create_new_ident type_spc)
        (PROGN
          (SETQ ident *symb)
          (insymbol)
          (IF (OR (test_terminator 'is T) (test_operator = T))
            (PROGN
              (SETQ sumflg
                (WHEN (test_terminator 'SUMM T)
                  (insymbol)
                  (UNLESS (test_terminator 'of T)
                    (SYS_CALL 0 "DCLP" 95 2) 
                  )
                  T
                )
              )
              (SETQ formula (get_typed_expression '*float 1.0))
              (IF (CONSP formula)
                (SETQ derflg T)  ; default id derivable when it is a formula.
                (SETQ derflg ()) ; and not derivable when it is a cte.
              )
            )
            (UNLESS (OR (test_separ |,|) (test_separ |;|))
              (SYS_CALL 0 "DCLP" 96 3)
              (skip_to_separ |,|)
            )
          )
          (SYS_CALL 312 ident formula sumflg derflg sigflg cacheflg)
        )
        (skip_to_separ |,|)
      )
      (SETQ flg (test_separ |,|))
    )
  )
  (look_separ |;| ())
)




;
; Item declaration statement.
;
(DE dcl_record ()
  (LET ( (flg    T)
         (item  ())
         (ident ())
       )
    (create_new_ident '*item_definition) ; create the item identifier.
    (SETQ item *symb)                    ; keep the item identifier.
    (UNLESS (test_terminator 'is T)      ; gobble up "is" or signal error.
      (SYS_CALL 0 "DITM" 88 2)
    )
    (WHILE flg            ; loop on all field declaration.

      (IF (create_new_ident '*item_type)
        (PROGN
          (SETQ ident *symb)
          (insymbol)
          (IF (test_terminator 'is T)
            (SET ident (FUNCALL type_fnc type_def)) ; := found.
            (SET ident type_def)                    ; := not found.
            (UNLESS (OR (test_separ |,|) (test_separ |;|))
              (SYS_CALL 0 "DCLF" 96 3)
              (skip_to_separ |,|)
            )
          )
        )
        (skip_to_separ |,|)
      )
      (SETQ flg (test_separ |,|))
    )
  )
  (look_separ |;| ())
)




;
; List declaration statement.
;
(DE dcl_list ()
)




;
; data_collection declaration statement.
;
(DE dcl_collect ()
)




;
; Assignement statement.
;
(DE assignement_state ()
  (expr_expression)         ; get the target of the assignement.
  (IF (test_operator := T)
    (UNLESS (EVAL (GETPROP *curr_symb '*assign))
      (expr_expression)
      (expr_gencall 2 ':=)
    )
    (SYS_CALL 0 "ASSN" 97 3)
    (skip_to_sep |;|)
  )
)




;
; Particular variable and limit assignement routine.
;
(DE var_and_lim_assignement ()
  (LET ( (val (get_const_float 0.0))
         (sig 0.0)
       )
    (WHEN (test_separ |:|)
      (insymbol)
      (SETQ sig (get_const_float 0.0))
    )
    (SYS_CALL 344 *curr_symb val sig)
    (LIST_DEL (STACK_GET opstk))
  )
  T ; to lock the assignement.
)




;
; Call procedure statement.
;
(DE call_state (proc)
  (LET ( (res (call_generic proc))
       )
    (insymbol)
    res
  )
)





(DE display_state ()
  (LET ( (flg T)
         (object ())
         (type   ())
         (outspc ())
       )
    (WHILE flg
      (SETQ object (get_const_expr ())
            defl   '(16 5 2 0 0)
            outspc (LIST ())
            type   (STACK_GET object)
            object (STACK_GET object)
      )

      (WHILE (AND defl (test_separ |:|))  ; build the format list .
        (insymbol)
        (QUEUE_PUT outspc (get_const_integer (NEXTL defl)))
      )
      (STACK_GET outspc) ; free the queue head.
      (IF outspc
        (PROGN ; formatted case.
          CASE (lisp_kind object) (
            (6 7)   ; Integer and float.
                  (O_FIXED outspc object)

            (8 9) ; String.
                  (O_STRING outpsc object)
          otherwise
            (PROGN
              (SYS_CALL 0 "DISP" 96 2)
              (skip_to_sep |;|)
            )
          )
         (LIST_DEL outspc)
          (SETQ outspc ()) ; to cancel ref. to free doublet.
        )
        (PRIN object)
      )
      (SETQ flg (skip_separ |,|))
    )
  )
  (look_separ |;| ())
  (PRINT)
)



;
; *** routine to compile a block body ***
;
(DE compiler_block_body (term_list exec_flag)
  (SETQ   *stop ()
  )
  ; *** Loop on all statements ***
  (UNTIL (or (EOF) *stop)
    (SETQ *stats *symb)
    CASE *kind (
      (1 2 3) ; Atom  => (assignement statement.)
         (IF *undef
           (PROGN
             (SYS_CALL 0 "STAT" 51 3)
             (insymbol)
           )
           (IF (GETPROP *symb '*generic)
             (call_state *symb)
             (assignement_state)
           )
         )

      (20 25); Reserved keyword.
        (PROGN
          (insymbol)            ; get the next syntax unit.
          (EVAL *stats)         ; activate the related function.
        )

      (22)   ; reserved word separator
        (PROGN
          (UNLESS (MEMQ *symb term_list)
            (SYS_CALL 0 "STAT" 66 3)
            (insymbol)
          )
          (SETQ *stop T)
        )

      (23)   ; Separator.
        (PROGN
          (UNLESS (EQ *stats |;|) (SYS_CALL 0 "STAT" 66 3))
          (insymbol)
        )


      OTHERWISE
        (PROGN
          (SYS_CALL 0 "STAT" 66 3)
          (insymbol)
        )
    )
  )
)


;
; *** routine to compile a block ***
;
(DF compiler_block (exec_flag)
  (SETQ   *stop ()
          *owner_list (LIST ())
  )
  ; *** Loop on all statements ***
  (UNTIL (OR (EOF) *stop)
    (SETQ *stats *symb)
    CASE *kind (
      (25)   ; Reserved keyword for macro function.
        (PROGN
          (insymbol)            ; get the next syntax unit.
          (EVAL *stats)         ; activate the related function.
        )

      (21)   ; declaration keyword (const type var ...).
        (EVAL *stats)           ; activate the related function.

      (22)   ; reserved word separators (only begin & end allowed).
        (PROGN
          (UNLESS (MEMQ *symb '(end begin))
            (SYS_CALL 0 "STAT" 66 3)
            (insymbol)
          )
          (SETQ *stop T)
        )

      (23)   ; Separators (only semicolon allowed).
        (PROGN
          (UNLESS (EQ *stats |;|) (SYS_CALL 0 "STAT" 66 3))
          (insymbol)
        )


      OTHERWISE ; always an error.
        (PROGN
          (SYS_CALL 0 "STAT" 66 3)
          (insymbol)
        )
    )
  )
  (WHEN (EQ *symb 'begin)
    (insymbol)                  ; gobble up the begin.
    (compiler_block_body '(end) exec_flag) ; compile the statement block.
  )
)




;
; ****  DPU main routine  ****
;
(DE dpu_main ()
  (init_compiler)
(PRAGMA "C+")
  (SETQ dpu$input (SYS_CALL 101 "DPU$SOURCE"))
  (UNLESS dpu$input (SETQ dpu$input "TT:"))
  (CHAINE dpu$input)                 ; get initial source specification.
  ;
  ; *** Error management ***
  ;
 '(ON_ERROR
    (
      (err_code sys$_error)                  ; save the error code.
      (err_sev  (PLIST 'sys$_error))         ; save the error severity.
      (err_point (PLIST 'sys$_error_point))  ; save the error point.
    )
;   (IF (> err_code 0)
;     T          ;                   ; return T to force standard action.
      (SYS_CALL 0 "DPU " (NEG err_code) err_sev)   ; output our error message.
      ()                             ; force continue execution.
;   )
                                     ; return Lisp pointer for restart.
  )

  (SETQ *stop ())
  (INPUT () "DPU_1>" "P")            ; Set the prompt and the Pascal comments.
  (insymbol)                         ; read the first syntax unit.
  (UNLESS (EOF) (compiler_block T))  ; run until end or eof.
  (EXIT "Normal end of DPU FIT.")
)




;
; set initialization of compiler.
;
(INCLUDE "DPULIB:dpu_init.lisp_part") ; load the init compiler routine.




;
; start the compiler.
;
(WHEN (SETQ dpu_listing (SYS_CALL 101 "DPU$LISTING"))
  (LISTING dpu_listing)
)

(dpu_main)  ; Go to compiler run.

