(pragma "R-" "C-" "T-")
(include "[appl]macro_loop.lisp" "L-")
(setq
  *power* '(*pow* **)
  *mulop* '(*mul* *)
  *divop* '(*mul* /)
  *addop* '(*add* +)
  *subop* '(*add* -)
  *conca* '(*add* s_concat)
  *eq*    '(*rel* =)
  *ne*    '(*rel* <>)
  *lt*    '(*rel* <)
  *le*    '(*rel* <=)
  *ge*    '(*rel* >=)
  *gt*    '(*rel* >)
  *notop* '(*not* null)
  *andop* '(*and* &)
  *iorop* '(*ior* !)
)
;
; source error procedure.
;
(de ERROR (cd sv md)
  (syscall 0 cd sv md)                    ; basic system error call.
)
;
;  insymbol procedure.
;
(de INSYMBOL ()
  (setq symb (read))
)
;
;;
;;  operator definitions.
;;
;
; unary evaluation operator function
;
(de EVL_UNA (ope obj)
  (print "EVL_UNA : " ope ":" obj)        ;*Debug print.
  (if (eq "L" (car (cddr obj)))           ; if literal value then.
    (setq EVL_UNA (apply ope (car obj)))  ; apply this operator.
    (setq EVL_UNA (list ope obj))         ; else create the operative list.
    (rplaca (cddr EVL_UNA) "V"))          ; flag with the variable attribut.
  EVL_UNA
)
;
; binary evaluation operator function.
;
(de EVL_BIN (ope obj1 obj2)
  (print "EVL_BIN : " ope ":" obj1 ", " obj2)
  (if (and (eq "L" (car (cddr obj1)))     ; if two literal values then.
           (eq "L" (car (cddr obj2))))
    (setq EVL_BIN (apply ope (car obj1) (car obj2))); apply this operator.
    (setq EVL_BIN (list ope obj1 obj2))   ; else create the operative list.
    (rplaca (cddr EVL_BIN) "V"))          ; flag for variable attr.
  EVL_BIN
)
;
;  expression identifier procedure.
;
(de EXP_IDENT ()
  (cond
    ((eq 0 sys$_readk)                    ; nil for empty string.
      (setq exp_obj '(() "S" 0 "L")))     ; set null string attribute.

    ((eq 1 sys$_readk)                    ; atom case.
      (if sys$_undef                      ; if undeclared identifier.
        (progn (ERROR 51 3 ())            ; then error ...
          (setq exp_obj '(() "U" 0 "L"))) ; and set default declaration.
        (setq exp_obj symb)))             ; else, get identifier information.

    ((eq 4 sys$_readk)                    ; Integer const.
      (setq exp_obj (cons symb '("I" 4 "L"))))

    ((eq 5 sys$readk)                     ; Floatting constant.
      (setq exp_obj (cons symb '("F" 4 "L"))))

    ((eq 6 sys$_readk)                    ; Character constant.
      (setq exp_obj (cons symb '("C" 1 "L"))))

    ((eq 7 sys$readk)                     ; String constant.
      (setq exp_obj (cons symb '("S" 0 "L"))))

    (T (ERROR 53 3 ())
      (setq exp_obj '(() "U" 0 "L")))     ; otherwise error.
  )
  (INSYMBOL)                              ; get the next symbol.
)
;
; Unary operator procedure.
;
(de EXP_UNA ()
  (setq exp_neg ())                       ; set none negative flag.
  (while (or (eq symb '*addop*)           ; while positif or negative
             (eq symb '*subop*))          ; sign loop.
         (when (eq symb '*sub*)           ; if negative signe then
           (setq exp_neg (null exp_neg))) ; then reverse the negative flag.
         (INSYMBOL))                      ; ... read the next syntax unit.
  (if (eq symb '*lpar*)                   ; if "(" then ...
    (progn (INSYMBOL)                     ; gobble up,
      (EXPRESSION)                        ; get the expression, and
      (if (eq symb '*rpar*) (INSYMBOL)    ; if ")" then  gobble up,
        (ERROR 60 3 ())))                 ; else error...
                                          ; no "( exp )" case
    (EXP_IDENT)                           ; get the expression symbol.
    (setq exp_more T)                     ; set the continue flag.
    (while exp_more                       ; loop until end of specifier...
      (cond
        ((eq symb '.) (INSYMBOL)          ; record field case.
          (EXP_FIELD))
        ((eq symb '*bra*) (INSYMBOL)      ; array element ref. case.
          (EXP_INDEX))
        (T (setq exp_more ()))            ; otherwise => stop the while loop.
      )))
  (when exp_neg                           ; when negative flag applied it.
    (setq exp_obj  (EVL_UNA 'neg exp_obj)))  ;
  exp_obj                                 ; set the EXP_UNA result.
)
;
; power function.
;
(de EXP_POW ()
  (setq EXP_POW (EXP_UNA))                    ; get the main term.
  (when (eq (car (setq exp_op symb)) '*power*); if it is a power operator then
    (INSYMBOL)
    (setq EXP_POW (EVL_BIN (cdr exp_op) EXP_POW (EXP_UNA)))) ; perform the operation.
  EXP_POW
)
;
; mul and div function.
;
(de EXP_MUL ()
  (setq EXP_MUL (EXP_POW))                    ; get the term.
  (when (eq (car (setq exp_op symb)) '*mul*)  ; if it is a power operator then
    (INSYMBO

     (setq EXP_MUL (EVL_BIN (cdr exp_op) EXP_MUL (EXP_POW)))) ; perform the operation.
  EXP_MUL
)
;
; add sub function.
;
(de EXP_ADD ()
  (setq EXP_ADD (EXP_MUL))                    ; get the factor.
  (when (eq (car (setq exp_op symb)) '*add*)  ; if it is a power operator then
    (INSYMBOL)
    (setq EXP_ADD (EVL_BIN (cdr exp_op) EXP_ADD (EXP_MUL)))) ; perform the operation.
  EXP_ADD
)
;
; relation function.
;
(de EXP_REL ()
  (setq EXP_REL (EXP_ADD))                    ; get the factor.
  (when (eq (car (setq exp_op symb)) '*rel*)  ; if it is a relation then
    (INSYMBOL)
    (setq EXP_REL (EVL_BIN (cdr exp_op) EXP_REL (EXP_ADD)))) ; perform the operation.
  EXP_REL
)
;
; not class function.
;
(de EXP_NOT ()
  (setq EXP_NOT (EXP_REL))                    ; get the factor.
  (when (eq (car (setq exp_op symb)) '*not*)  ; if it is a relation then
    (INSYMBOL)
    (setq EXP_NOT (EVL_UNA (cdr exp_op) EXP_NOT))) ; perform the operation.
  EXP_NOT
)
;
; and class function.
;
(de EXP_AND ()
  (setq EXP_AND (EXP_NOT))                    ; get the factor.
  (when (eq (car (setq exp_op symb)) '*and*)  ; if it is a relation then
    (INSYMBOL)
    (setq EXP_AND (EVL_BIN (cdr exp_op) EXP_AND (EXP_NOT)))) ; perform the operation.
  EXP_AND
)
;
; or class function function. // it is the basic expression function ///.
;
(de EXPRESSION ()
  (setq EXPRESSION (EXP_AND))                 ; get the factor.
  (when (eq (car (setq exp_op symb)) '*ior*)  ; if it is a relation then
    (INSYMBOL)
    (setq EXPRESSION (EVL_BIN (cdr exp_op) EXPRESSION (EXP_AND)))) ; perform the operation.
  (setq exp_obj (EXPRESSION))
)
;
;   ERROR procedure.
;
(de ERROR (modul subject cod)
  (print " FIT-ERROR " modul """" subject """ for reason " (abs cod) " .")
;  (sys_call 0) 
  (unless (>= 0 cod) (exit " Stop FIT."))
)
;
;   get a cte value procedure.
;
(de RC_EXPR ()
()
)
;
;   get a cte string procedure.
;
(de ST_EXPR ()
()
)
;
;   get a physical value procedure.
;
(de PH_EXPR ()
()
)
;
; object declaration procedure.
;
(de NEW_IDE (val kind sz attr lide)
; (sys_call top_lex 2 top_lex 2)        ; set default declaration lex to top.
  (INSYMBOL)                             ; Get the next field.
  (when (eq SYS$_READK 4)                ; if it is an integer const.
    (setq symb (+ 2 symb))               ; lex translated in lisp lex.
    (when (< symb 3) (setq symb 3))      ; limit in range 3..top_lex.
    (when (> symb top_lex) (setq symb top_lex))
    (lex_level symb 2 symb)              ; set the allocation lex.
    (INSYMBOL))                          ; read the id name.
  (when (<> SYS$_READK 1)                ; if it is not an atom
      (error 32 3 ()))                   ; error: expected an atom name.
  (when (null SYS$_UNDEF)                ; if already exist
    (if (null symb)                      ; reserved word ?
      (error 99 3 ())                    ; error: illegal reserved word.
      (error 33 3 ())))                  ; error: declared twice.
  (lex_level top_lex 2 top_lex)          ; restore the normal lex mode.
)
;
;
;
;
;  statement procedure.
;
(de STATEMENT ()                             ; no parameters.
  (print "stat =" (setq stat (read)))        ; read a syntax unit.
  (cond
    ((eq stat 'variable)
    )
    ((eq stat 'param)
    )
    (T (error 99 3 ()))
  )
)



;
;   FIT main program.
;
(setq lst_file "FIT.LIST")
(setq src_file "FITSRC")
(progn                                       ; we must read all in one time.
  (include "MXD$INIT.LISP" "L+:2")           ; initalize the read system.

  (setq err (open 'lst "N" lst_file 55))     ; open the source file (55l/pg.).
  (unless (= 0 err)                          ; signal open error.
    (print "Cannot open listing file """ lst_file """ for reason " err " .")
    (exit " Stop FIT."))
  (setq err (open 'src "R" src_file 1))      ; set src as source line.
  (unless (= 0 err)                          ; signal open error.
    (print "Cannot open source file """ src_file """ for reason " err " .")
    (exit " Stop FIT."))

  (output 'lst )                             ; selection of listing file.
;             ()     ;                       ; no line size specified.
;             55     ;                       ; 55 lines by page.
;             ()     ;                       ; no print at close time.
;             )      ;                       ; and no margin.

  (list_head 'lst " MXD_V4.0 Compiler - P. WOLFERS Software 15-SEPT-1990.")

  (input 'src "LISP_FIT>" "P")               ; select src file set the prompt
                                             ; and the PASCAL comment mode.
  (pragma "L+")                              ; set the source listing .

  (FIT_INIT)                                 ; initialize the fit process.



  ; ********** main read loop  **********

  { E_EXIT                                   ; loop label exit.
    (brkwh (eq sys$_eof (STATEMENT))  E_EXIT)     ; loop exit condition.
  }                                          ; end of main loop.
  (typech """" (typech "'" save_quote))      ; restore quot and ".
  (typech "(" save_lparen)
  (typech ")" save_rparen)
  (typech "[" save_lbra)
  (typech "]" save_rbra)
  (typech "`" save_backq)

  (input)                                    ; return to lisp mode.
  (close 'src)                               ; and close source file.
)
