;*************************************************************************
;**************     Least-Squares Objects Definitions    *****************
;*************************************************************************
;*                                                                       *
;*                                                                       *
;*    For all least-squares objects :                                    *
;*                                                                       *
;* Address offset   Field         Lisp          comments                 *
;*    for Lisp      name       Descriptor                                *
;*                                                                       *
;*                                                                       *
;*                                                                       *
;* diagonal block structure :                                            *
;* --------------------------                                            *
;*                                                                       *
;*   ->   0 /     blk_dmp         M_AD   -Static dampening factor value  *
;*        4 /     blk_dyn         M_OB   -Dynamic dampening factor def.  *
;*        8 /     blk_name        M_OB   -Diagonale block atome name ptr.*
;*       12 /     blk_link        M_AD   -Link to next diagonal block.   *
;*       16 /     blk_varbl       M_AD   -Link to first variable of block*
;*       20 /     blk_size        M_LI   -Diagonal block size.           *
;*                                ( size = 24 )                          *
;*                                                                       *
;*                                                                       *
;* variable struture :                                                   *
;* -------------------                                                   *
;*                                                                       *
;*   ->   0 /     var_value       M_FL   -Current variable value.        *
;*        4 /     var_sigma       M_FL   -Last variable sigma.           * 
;*        8 /     var_lower       M_FL   -Lower limit.                   *
;*       12 /     var_upper       M_FL   -Upper limit.                   *
;*       16 /     var_index       M_SW   -Variable matrix index.         *
;*       18 /     var_flag        M_UW   -Variable flag.                 *
;*       20 /     var_name        M_OB   -Variable name (atom pointer).  *
;*       24 /     var_link        M_AD   -Variable link.                 *
;*                                ( size = 28 )                          *
;*                                                                       *
;*                                                                       *
;* parameter struture :                                                  *
;* --------------------                                                  *
;*                                                                       *
;*   ->   0 /     par_value       M_FL   -Last value.                    *
;*        4 /     par_sigma       M_FL   -Last sigma.                    *
;*        8 /     par_definition  M_OB   -Parameter definition.          *
;*       12 /     par_lstder      M_AD   -List of parameter derivate blk.*
;*       16 /     par_name        M_OB   -Parameter name (atom pointer). *
;*       20 /     par_link        M_AD   -Parameter link.                *
;*                                ( size = 24 )                          *
;*                                                                       *
;* derivate block :                                                      *
;* ----------------                                                      *
;*                                                                       *
;*   ->   0 /     der_link        M_AD   -pointer to the next der. block *
;*        4 /     der_varbl       M_AD   -pointer to the related variable*
;*        8 /     der_value       M_FL   -last derivate value            *
;*       12 /     der_kind        M_LI   -kind of variable for derivate. *
;*                                                                       *
;*                                                                       *
;*                                                                       *
;* list definition block :                                               *
;* -----------------------                                               *
;*                                                                       *
;*   ->   0 /     lis_current     M_AD   -pointer to current element.    *
;*        4 /     lis_first       M_AD   -pointer to the first elem.     *
;*        8 /     lis_last        M_AD   -pointer to the last elem.      *
;*       12 /     lis_param       M_AD   -pointer to the attached parm.  *
;*       16 /     lis_descr       M_OB   -pointer to the lisp descriptor.*
;*                                                                       *
;*                                                                       *
;*                                                                       *
;*                                                                       *
;*************************************************************************
;
(dma 'record                 ; define the record constructor.
  ; local definitions/assignations.
  ((rec_size 0)
   (type_name (read))
   (field_name ())
   (field_type ())
  )
  ; dma (LET like) body.
  (lex_level type_name)
  { record_def_loop
    (setq field_name (read))
    (brkwh (eq field_name 'end) record_def_loop)
    (setq field_type (read))
    ()
  }
)
