(pragma "r-" "l-")
;
;  *** Verification procedure for module LISP$_LSQ ***
;

(setq var_info '(1 2 3 4 5 6)   ; List of variable info : name, old value,
                                ; old sigma (unused), Matrix index,
                                ; Related diagonal block and limits block.
      lim_info '(1 2)           ; Limit info inf and sup.
      par_info '(1 2 3)         ; List of parameter info : name, value
                                ; and sigma.
      blk_info '(1 2 3 4 5 6 7) ; List of diagonal block info :
                                ; name, effectives marqward and dampening fac.,
                                ; x and b vector, and matrix,
                                ; first variable.
      lis_info '(1 2 3 4)       ; List of list info :
                                ; name, Current, first element,
                                ; and first parameter.
      col_info '(1 2 3)         ; List of collect info :
                                ; Related list, Reject factor and statistic
                                ; block.
      sta_info '(1 2 3 4 5 6 7  ; statistic info : obs_count
                 8 9 10 11 12 ) ; user and standard chi2,
                                ; sum ( sqr(delta/sigma) ),
                                ; sum ( sqr(delta*weight)),
                                ; sum ( sqr(delta)),
                                ; sum ( abs(delta*weight)),
                                ; sum ( abs(delta)),
                                ; sum ( sqr(obser*weight)),
                                ; sum ( sqr(obser)),
                                ; sum ( abs(obser*weight)),
                                ; sum ( abs(obser)).

)


; *** Change variable procedure ***
(de change_varbl (varbl newval sig shift lim_flg beg_flg end_flg)
  (setq vinfo (sys_call 372 varbl var_info))
  (when beg_flg                       ; for the begin of a diagonal block.
    (setq binfo (sys_call 372 (caddr (cddr var_info)) blk_info))
    (print)
    (print " Diagonal block """ (nextl binfo) """ with Mlc = " (nextl binfo)
           " and Dmp = " (car binfo)
    )

  )
  (prin (nextl vinfo) " = "
        newval ":"
        sig
  )
  (unless end_flg
        (prin ", " (car vinfo)
              ", " shift
          (cond
            ((eq lim_flg 1)  "  *LR*")
            ((eq lim_flg -1) " *MOD*")
            (T               "      ")
          )
 	       ))
  (print)
)

; ***  Singularity Notification Procedure ***
(de signal_sing (varbl nfail ovf_flg)
  (print)
  (prin " *** Singularity on the Variable """
        (car (sys_call 372 varbl varbl_info)) """")
  (print " => Variable is locked. ")
  (when ovf_flg (sys_call 1 "SING" 14 4))
)

; *** user procedure de/df call entry ***
(de usr_p_call (idx param)
  ()
)



; *** user function de/df call entry ***
(de usr_f_call (idx param) (print idx))

; *** user function to cycle begin notification ***
(de usr_beg_cycl (c_nb c_end)
  (print) (print)
  (if c_end
    (progn
      (print "  *** Least-Squares Final Cycle ***")
      (print "  ---------------------------------"))
    (prin  "  *** Least-Squares Cycle #" )
    (o_fixed (4) c_nb) (print " .")
    (print "  -------------------------------"))
  (print)
)

; *** user function to cycle solve notification ***
(de usr_res_cycl (c_nb)
  (print) 
  (usr_end_coll () )
  (print)
  (print)
  (print "     Result of the Least-Squares Cycle #" c_nb " .")
  (print)
)

; *** user function to cycle end notification ***
(de usr_end_cycl (c_nb)
  (print)
  (print "***********************************************************")
  (print)
)

; *** user function to data collection begin notification ***
(de usr_beg_coll (coll)
  (setq curr (sys_call 372 (car (sys_call 372 coll col_info)) lis_info))
  (print)
  (print "    Data Collection """ (car curr) """ ." )
  (print)
  (print)
  (print "   #     X       Y-OBS      YTH      DELTA     SIGMA    WEIGHT    DEL/SIG")
  (print)
)

; *** user function to data collection end notification ***
(de usr_end_coll (coll)
  (setq curr (sys_call 373 coll sta_info))
  (print)
  (if coll
    (progn
      (sys_call 202 the_attr)            ; set computed draw attributs
      (setq seg_curve (sys_call 254 seg_curve curve_liste the_spc)) ; plot the theoric curve.
      (print "     The particular statistic :" )
    )
    (print "     The   Global  statistic  :" ))
  (print "     --------------------------" )
  (print)
  (prin "     Number of used observation         = ")
  (o_fixed (6) (nextl curr)) (print)
  (prin "     User goodness of fit (Chi squared) = ")
  (o_fixed (6 4 1) (nextl curr)) (print)
  (prin "     Standard goodness of fit           = ")
  (o_fixed (6 4 1) (nextl curr)) (print)
  (print)
)

; *** user packet computing function ***
(de usr_pack_cmp (coll nobs obs calc delta sigma weight delssig regflg)
  (o_fixed (4) nobs)
  (o_fixed (10 4 2)  (cadr (sys_call 372 $X par_info))
                     obs calc delta sigma weight delssig)
  (when regflg (prin " *R*"))
  (print)
)

; *** user list element computing function ***
(de usr_listelem_cmp (lis) ()
)

;
;****************************************************
;*                                                  *
;*       Initialize the Least-Squares Loader.       *
;*                                                  *
;****************************************************
;
(sys_call 301
  ; assign the change variable notification entry.
  '(change_varbl varbl newval sig shgift lim_flg beg_flg end_flg)
  '(signal_sing varbl nfail ovf_flg) ; assign the signal singularity entry.
  '(usr_f_call idx param)       ; assign the user call function entry.
  '(usr_p_call idx param)       ; assign the user call procedure entry.
  '(usr_beg_cycl c_nb c_end)
  '(usr_res_cycl c_nb)
  '(usr_end_cycl c_nb)
  '(usr_beg_coll coll)
  '(usr_end_coll coll)
  '(usr_pack_cmp coll nobs obs calc delta sigma weight delssig regflg)
  ()
)

;
;****************************************************
;*                                                  *
;*    Build the Least-Squares Control Structure.    *
;*                                                  *
;****************************************************
;

(sys_call 314
         '*BLK_MAIN*     ; Create the Least-Squares matrix Block ".BLK_MAIN.".
         1.0             ; Dampening factor expression.
         1.0             ; Marqward factor expression.
)
; ".BLK_MAIN." is now open to get the next following variable.
              
(sys_call 311 'coef_a 0)      ; Create the a coefficient Least-Squares variable.

(sys_call 311 'coef_b 0)      ; Create the b coefficient Least-Squares variable.

(sys_call 311 'coef_c 0)      ; Create the c coefficient Least-Squares variable.


; Now we define the list of data.

(sys_call 315 'DATA_LIST ; Create the data list named "DATA_LIST".
  '(
     (312 '$X  '(DATA_LIST M_FL  4))  ; Define the current x parameter.
     (312 '$Y  '(DATA_LIST M_FL  8))  ; Define the current y parameter.
     (312 '$SG '(DATA_LIST M_FL 12))  ; Define the current sigma parameter.
     (312 'YLIN '(+ (* coef_a $X) coef_b) () T T)
     (312 'YTH                        ; define the computed y parameter,
          '(+ (* YLIN $X) coef_c)
                                      ; as a*x^2 + b*x + c,
          ()                          ; It is not a summation parameter,
          T                           ; Derivable parameter,
          T                           ; With computed sigma,
          ()                          ; and no cache use.
     )
     (310 YTH)                        ; push the YTH value to
     (325 DATA_LIST M_FL 20)          ; Store it at 20 offset of current el.

     (310 0)                          ; Push stop scan end condition.
     (310 1)                          ; Push Eligibility condition expression.
   )                                  ; end of list sequence.
  0                      ; without cache.
) 


; Now we define the data collection to fit.

(sys_call 316 DATA_LIST               ; the Data collection use the DATA_LIST
                                      ; list to scan the experimental data.
  '(                                  ; Begin of packet directives.

                                      ; End of directive sequence.
    (310 '(/ 1.0 $SG))                ; Weight to use,
    (310 '$SG)                        ; Related Y sigma,
    (310 '$Y)                         ; Value to use as experimental Y,
    (310 'YTH)                        ; Parameter to use as computed value,
    (310 1)                           ; Push sentinel.
  )
  ()                                  ; No cycle directive list.
  1E10                                ; Rejection to use.
)


;
;****************************************************
;*                                                  *
;*    Define the fit related basic directives       *
;*                                                  *
;****************************************************
;

(setq G_STATIS (sys_call 319
  '(                                 ; Define By cycle directive.
     (326 1 '(null T))
   )
  '(                                 ; Define Final directive.
     (312 'AMULB '(* coef_a coef_b) () T T)
   )
))

;
;****************************************************
;*                                                  *
;*    Initialize the Least-Squares processor.       *
;*      And create the running structures.          *
;*                                                  *
;****************************************************
;

(sys_call 302
                 1            ; First cycle #.
                 1            ; Maximum number of tolerate singularities.
                ()            ; Minimal value for a pivot (defaulted).
                ()            ; Normal matrix computing (T => computed at first cycle only).
                ()            ; Final cycle required (T => suppressed).
                 T            ; Correlation matrix required after final cycle.
)

;
;****************************************************
;*                                                  *
;*    Read the Least-Squares Experimental Data.     *
;*                                                  *
;****************************************************
;

(progn
  (setq curve_liste () curr_pt ())
  (print " Open_result = " (open 'f "i" "curve"))
  (input 'f "entree un point s.v.p. ")
  (setq xx (read))                      ; read the first x.
  (until EOF
    (setq yy (read) sgsg (read))        ; read obs. y and sigma.
    (until sys$_read_eoln (read))       ; ignore all trailing data.
    (setq cblk (m_allocb 24))           ; allocate the memory block.
    (m_put (m_offset cblk  4) m_fl xx)  ; set the x value.
    (m_put (m_offset cblk  8) m_fl yy)  ; set the y value.
    (m_put (m_offset cblk 12) m_fl sgsg); set the sg value.
    (if (null curve_liste)              ; if it is the first curve point.
      (setq curve_liste (cons cblk ())  ; then set first curve element.
            curr_pt     curve_liste)    ; else
      (rplacd curr_pt (cons cblk ()))   ;   append the new point
      (nextl curr_pt)                   ;   and set it as last point.
    )
    (setq xx (read))
  )                                     ; end of until.

  (close 'f)

;  (print curve_liste)

; *** plot de la courbe experimentale ***

(sys_call 201 18 15 "Essai de Fit" T)        ; Init du graphic.

(setq exp_spc '( 4   8  ()  () () 12)        ; Set offsets and seg id for exp. curve.
      the_spc '( 4  20  ()  2))              ; Set offsets and seg id for th. curve.
(setq exp_attr '(2  3  4 1.0)                ; Set Attributs (marker,blue,circle,size) for exp.
      sig_attr '(1  1  1 1.0)                ; Set Attributs (line,black,continue,size) for sig.
      the_attr '(1  2  1 2.0))               ; Set Attributs (line,red,continue,size) for th.
(setq minimaxi (sys_call 250 curve_liste exp_spc)) ; comput min-maxi.
(sys_call 251 minimaxi 14 10 2 2 "X" "Y" T)  ; Create the box.

(sys_call 208 1)                             ; define the experimental segment.

(sys_call 202 exp_attr)                      ; set exp. attributs.
(sys_call 254 () curve_liste exp_spc)        ; Plot the experimental curve.

(sys_call 202 sig_attr)                      ; set sigma attributs.
(sys_call 258 () curve_liste exp_spc)        ; Plot the experimental sigma.

(sys_call 238)                               ; start in time of fly mode.


(when (zerop (sys_call 221 "start" )) (exit "stop"))

(setq seg_curve -1)                          ; the first cycle is flaged by no computed
                                             ; curve segment #.


  (eval (list 'sys_call '331 'DATA_LIST 'curve_liste ) )

; (setq curr_pt curve_liste)
; (until (null curr_pt)
;   (setq cblk (nextl curr_pt))
;   (setq
;     xxx    (m_get (m_offset cblk  4) m_fl)
;     yyy    (m_get (m_offset cblk  8) m_fl)
;     sgsgsg (m_get (m_offset cblk 12) m_fl)
;   )
;    (print "block = " cblk ", x = " xxx ", y = " yyy ", Sigma = " sgsgsg ".") 
; )

;
;****************************************************
;*                                                  *
;*    Run the Least-Squares Processor for 2 Cycles. *
;*                                                  *
;****************************************************
;

  (sys_call 303 2)

;
;****************************************************
;*                                                  *
;*    Free the Least-Squares running Structures.    *
;*                                                  *
;****************************************************
;

  (sys_call 304)

;
;     Stop before close GKS by a call of dialog.
;
  (sys_call 240)

  (sys_call 200)
(print "end of fit.")
)
