;(pragma "l-")
(include "loop.lisp")
(setq code
  '(progn
    (print "group.")
    {et0
      (prin "> ")
      (setq res (eval (read)))   ; Lisp interpretor.
      (print " result = " res)
      (brkwh (eq sys$_eof res) et0)
    }
  res)
)
(on_error
  (
    (err_code sys$_error)                  ; save the error code.
    (err_sev  (plist 'sys$_error))         ; save the error severity.
    (err_point (plist 'sys$_error_point))  ; save the error point.
  )
  (open 'sys$error "W" "sys$error")
  (output 'sys$error)
  (print " error detected during execution of : ")
  (print err_point)
  (close 'sys$error)
  (sys_call 1 "IT--" err_code err_sev)       ; Output our error message.     
  (cond
    ((> err_code 50) (input) T)              ; for error > 50 standard action.
    ((and (>= err_code 21) (<= err_code 24)) ; for comput error.
      et0)                                   ; goto reprise.
    (T (setq sys$_error_point -1) ()))       ; if other case continue.
  ;   the return value must be :
  ;                        () or NIL to continue execution.
  ;                        T to take the standard action.
  ;                        or a pointer to a restart point.
)
(progn
  (open 'sys$input "I" "sys$input")
  (input 'sys$input " ")
  {main_loop
    (output)
    (brkwh (eq sys$_eof (eval code)) main_loop)
  }
  (print "***fin***")
  (close 'sys$input)
)
