(pragma "r-")
;
;  *** Verification procedure for module LISP$_LSQ ***
;

(setq var_info '(1 2 3 4 5 6)   ; List of variable info : name, old value,
                                ; old sigma (unused), Matrix index,
                                ; Related diagonal block and limits block.
      lim_info '(1 2)           ; Limit info inf and sup.
      par_info '(1 2 3)         ; List of parameter info : name, value
                                ; and sigma.
      blk_info '(1 2 3 4 5 6 7) ; List of diagonal block info :
                                ; name, effectives marqward and dampening fac.,
                                ; x and b vector, and matrix,
                                ; first variable.
      lis_info '(1 2 3 4)       ; List of list info :
                                ; name, Current, first element,
                                ; and first parameter.
      col_info '(1 2 3)         ; List of collect info :
                                ; Related list, Reject factor and statistic
                                ; block.
      sta_info '(1 2 3 4 5 6 7  ; statistic info : obs_count
                 8 9 10 11 12 ) ; user and standard chi2,
                                ; sum ( sqr(delta/sigma) ),
                                ; sum ( sqr(delta*weight)),
                                ; sum ( sqr(delta)),
                                ; sum ( abs(delta*weight)),
                                ; sum ( abs(delta)),
                                ; sum ( sqr(obser*weight)),
                                ; sum ( sqr(obser)),
                                ; sum ( abs(obser*weight)),
                                ; sum ( abs(obser)).

)


; *** Change variable procedure ***
(de change_varbl (varbl newval sig shift lim_flg beg_flg end_flg)
  (setq vinfo (sys_call 372 varbl var_info))
  (when beg_flg                       ; for the begin of a diagonal block.
    (setq binfo (sys_call 372 (caddr (cddr var_info)) blk_info))
    (sys_call 23)
    (print " Diagonal block """ (nextl binfo) """ with Mlc = " (nextl binfo)
           " and Dmp = " (car binfo)
    )
    (print)

  )
  (prin (nextl vinfo) " = "
        newval ":"
        sig
  )
  (unless end_flg
        (prin ", " (car vinfo)
              ", " shift
          (cond
            ((eq lim_flg 1)  "  *LR*")
            ((eq lim_flg -1) " *MOD*")
            (T               "      ")
          )
 	       ))
  (print)
)

; *** Output Correlation Matrix Procedure ***
(de output_correlation (block dim)
  (setq binfo (sys_call 372 block blk_info))
  (sys_call 23)
  (print " *** Diagonal block """ (car blk_info) """ ***" )
  (print)
  (format_out '((|A|)(|F| 6 3)) " Correlation factors greater than "
                                correl_min
                                " .")
  (print)
  (setq correl_blk (nextl correl_currl)) ; get the corr. entry list.
  (sys_call 375 block correl_min correl_blk)
  (while (and correl_blk (car (setq correl_ent (nextl correl_blk))))
    (format_out '((|A|)(|F| 10 4 2)) " ---- " (nextl correl_ent)
                '((|A|)) " between the variables """
                         (car (sys_call 372 (nextl correl_ent) var_info))
                         """ and """
                         (car (sys_call 372 (car correl_ent) var_info))
                         """."
    )
  )
)

; ***  Singularity Notification Procedure ***
(de signal_sing (varbl nfail ovf_flg)
  (sys_call 23)
  (prin " *** Singularity on the Variable """
        (car (sys_call 372 varbl var_info)) """")
  (print " => Variable is locked. ")
  (when ovf_flg (sys_call 1 "SING" 14 4))
)

; *** user function to cycle begin notification ***
(de usr_beg_cycl (c_nb c_end)
  (prin "  ")
  (setq eff_flg_list (if c_end (> flg_list 0) (> flg_list 1) )
        title_list (if eff_flg_list
                     "*** Least-Squares Final cycle result ***"
                     (concat "*** Least-Squares Cycle #" (string c_nb 4) " ***")
                   )
  )
  (list_head () () title_list) ; Set the page title.
  (unless (sys_call 23 12 4) ; start paragraphe, when => no new page then
    (prin "    ") (sys_call 25 title_list)
  )
)

; *** user function to cycle solve notification ***
(de usr_res_cycl (c_nb)
  (when (> data_coll_nb 1) (usr_end_coll () ))
  (sys_call 23 9 3)
  (print "     Result of the Least-Squares Cycle #" c_nb " .")
  (sys_call 22 2)
)

; *** user function to cycle end notification ***
(de usr_end_cycl (c_nb)
  (print "***********************************************************")
)

; *** user function to data collection begin notification ***
(de usr_beg_coll (coll)
  (when eff_flg_list
    (setq curr (sys_call 372 (car (sys_call 372 coll col_info)) lis_info))
    (sys_call 23 15 3)       ; set a new paragraphe.
    (prin "      ")
    (sys_call 25 "Data Collection """ (car curr) """ ." )
    (sys_call 22 2)
    (list_head () () ()
      (print "   #     X       Y-OBS      YTH      DELTA     SIGMA    WEIGHT    DEL/SIG")
    ) ; set and write the sub-title.
    (print)
  )
)

; *** user function to data collection end notification ***
(de usr_end_coll (coll)
  (setq curr (sys_call 373 coll sta_info))
  (list_head () () () T) ; Delete the sub-title.
  (sys_call 23 12 3)
  (prin "     ") 
  (if coll
    (progn
      (if (> data_coll_nb 1)
        (sys_call 25 "The current particular statistics :" )
        (sys_call 25 "The current statistics :" )
      )
    )
    (sys_call 25 "The current global statistics  :" )
  )
  (format_out '((|L|)(|C| 5)(|A|)(|C| 40)(|A| 2)(|I| 6))
               "Number of used observation"
               |=| (nextl curr)
              '((|C| 5)(|A|)(|C| 40)(|A| 2)(|F| 6 4 1))
               "User goodness of fit (Chi squared)"
               |=| (nextl curr)
               "Standard goodness of fit"
               |=| (nextl curr)
  )
)

; *** user packet computing function ***
(de usr_pack_cmp (coll nobs obs calc delta sigma weight delssig regflg)
  (when eff_flg_list
    (format_out '((|$|)(|I| 4)) nobs
                '((|F| 10 4 2)) (cadr (sys_call 372 $X par_info))
                                obs calc delta sigma weight delssig
    )
    (when regflg (prin " *R*"))
    (print)
  )
)

; *** user list element computing function ***
(de usr_liste_next (lis cnt)
  (when eff_flg_list
    ()
  )
)

;
;****************************************************
;*                                                  *
;*       Initialize the Least-Squares Loader.       *
;*                                                  *
;****************************************************
;
(sys_call 301
  ; assign the change variable notification entry.
  '(change_varbl varbl newval sig shift lim_flg beg_flg end_flg)
  '(output_correlation block dim)    ; assign the user correlation entry.
  '(signal_sing varbl nfail ovf_flg) ; assign the signal singularity entry.
  '(usr_beg_cycl c_nb c_end)    ; assign the begin cycle notification fonction.
  '(usr_res_cycl c_nb)          ; assign the results cycle notification fonction.
  '(usr_end_cycl c_nb)          ; assign the end cycle notification fonction.
  '(usr_beg_coll coll)          ; assign the begin data coll. scan notification fonction.
  '(usr_end_coll coll)          ; assign the summary data coll. scan notification fonction.
  ; assign the packet data collection scan notification fonction.
  '(usr_pack_cmp coll nobs obs calc delta sigma weight delssig regflg)
  ; assign the list data collection scan notification fonction.
  '(usr_liste_next lis cnt)
)

;
;****************************************************
;*                                                  *
;*    Build the Least-Squares Control Structure.    *
;*                                                  *
;****************************************************
;
(setq PI     (* 4 (atan 1))
      G_COEF (sqrt (/  PI (ln 2) ))
      G_LIST (list ())
)

(r_define GAUSS_TYPE (G_HIGH  .m_pt) ; Gaussian High expr.
                     (G_HWID  .m_pt) ; Gaussian Half Width expr.
                     (G_POS   .m_pt) ; Gaussian Position expr.
                     (G_INT   .m_pt) ; Gauusian Intensity expr.
)

(r_define POINT_TYPE                 ; experimental point type.
                     (DAT_X   .m_fl) ; x,
                     (DAT_Y   .m_fl) ; y,
                     (DAT_SG  .m_fl) ; sigma,
                     (DAT_YTH .m_fl) ; Computed y.
)


(GAUSS_TYPE CURR_G)                  ; Declare a current gaussian record ptr.
(POINT_TYPE CURR_PT)                 ; Declare a current experimental point.


(de CREATE_GAUSSIAN (H L P INT)
  (SYS_CALL 312 3 INT '(* H (* G_COEF L)) ) ; Derivable (1) + sigma (2).
  (r_new CURR_G H L P (eval INT))
  (queue_put G_LIST CURR_G)
)


(dma 'GAUSSIAN_M ((X (read)) (W (read)))
  (list '** 2 (list 'neg (list '** (list '/ X W) 2)))
)


(de GAUSSIAN (X W)
  (** 2 (neg (** (/ X W) 2)))
)




(sys_call 314
         '*BLK1*         ; Create the Least-Squares matrix Block ".BLK_MAIN.".
         1.0             ; Dampening factor expression.
         0.2             ; Marqward factor expression.
)

(sys_call 314
         '*BLK_MAIN*     ; Create the Least-Squares matrix Block ".BLK_MAIN.".
         0.3             ; Dampening factor expression.
         0.3             ; Marqward factor expression.
)
; Build the 10 major correlation block list link in the correl_list
; for each diagonal block.
(setq CORREL_LIST (list_buildq 2 (list_buildq 10 (list () () ())) ))

; ".BLK_MAIN." is now open to get the next following variable.
              



; 1ere gaussian.

(sys_call 311 'R1_COEF_A 300)    ; Create the a coefficient Least-Squares variable.

(sys_call 311 'R1_COEF_X 10)     ; Create the b coefficient Least-Squares variable.

(sys_call 311 'R1_COEF_W 2)      ; Create the c coefficient Least-Squares variable.

(CREATE_GAUSSIAN R1_COEF_A R1_COEF_W R1_COEF_X 'R1_INT)


; 2eme gaussian.

(sys_call 311 'R2_COEF_A 30)     ; Create the a coefficient Least-Squares variable.

(sys_call 311 'R2_COEF_X 12)     ; Create the b coefficient Least-Squares variable.

(sys_call 311 'R2_COEF_W 2)      ; Create the c coefficient Least-Squares variable.

(CREATE_GAUSSIAN R2_COEF_A R2_COEF_W R2_COEF_X 'R2_INT)


(sys_call 315 'GAUSSIAN_LIST GAUSS_TYPE
  '(
     (312 1 '$H '(GAUSSIAN_LIST G_HIGH))
     (312 1 '$W '(GAUSSIAN_LIST G_HWID))
     (312 1 '$P '(GAUSSIAN_LIST G_POS))
     (310 0)                     ; Push stop scan end condition.
     (310 1)                     ; Push Eligibility condition expression.
   )
  0                              ; No cache use.
)

(de SHO_INTENSITY (PAR)
  (print PAR)
  (setq PC_INFO (sys_call 372 PAR PAR_INFO))
  (print (car PC_INFO) " = " (cadr PC_INFO) ":" (caddr PC_INFO) ";")
)


(sys_call 331 GAUSSIAN_LIST G_LIST)   ; Link the gaussian definition in the list.


; Now we define the list of data.

(sys_call 315 'DATA_LIST POINT_TYPE   ; Create the data list named "DATA_LIST".
  '(
     (312 0 '$X  '(DATA_LIST DAT_X))  ; Define the current x parameter.
     (312 0 '$Y  '(DATA_LIST DAT_Y))  ; Define the current y parameter.
     (312 0 '$SG '(DATA_LIST DAT_SG)) ; Define the current sigma parameter.
     (321 GAUSSIAN_LIST 0             ; complete scan of the gaussian list,
       '(                             ; packet related directive.
          (312 11 '$YTH               ; Computed y definition.
            '(* $H GAUSSIAN_M (- $X $P) $W )
                                      ; It is a summation parameter (8),
                                      ; Derivable parameter (1),
                                      ; With computed sigma (2),
                                      ; and no cache use (4).
          )
        )                             ; end of scan packet directives.
        ()                            ; no scan end related exec seq.
     )                                ; end of scan.
     (310 $YTH)                       ; push the YTH value to
     (325 DATA_LIST DAT_YTH)          ; Store it at 16 offset of current el.

     (310 0)                          ; Push stop scan end condition.
     (310 1)                          ; Push Eligibility condition expression.
   )                                  ; end of list sequence.
  0                      ; without cache.
) 


; Now we define the data collection to fit.

(sys_call 316 'DATA_COLL DATA_LIST    ; the Data collection use the DATA_LIST
                                      ; list to scan the experimental data.
  '(                                  ; Begin of packet directives.
;   (310 '(/ 1.0 (sqrt $YTH)))        ;; Weight to use, (maximum of likehood).
    (310 '(/ 1.0 $SG))                ; Weight to use, (standard least-squares).
    (310 $SG)                         ; Related Y sigma,
    (310 $Y)                          ; Value to use as experimental Y,
    (310 $YTH)                        ; Parameter to use as computed value,
    (310 1)                           ; Push sentinel.
  )
  ()                                  ; No cycle directive list.
  1E10                                ; Rejection to use.
)
(setq DATA_COLL_NB 1)

;
;****************************************************
;*                                                  *
;*    Define the fit related basic directives       *
;*                                                  *
;****************************************************
;

(setq G_STATIS (sys_call 319
  '(                                 ; Define By cycle directive.
     (326 '(print 1) '(sqrt 2))
   )

  '(                                 ; Define Final directive.
     (321 GAUSSIAN_LIST 0            ; complete scan of the gaussian list,
       '(                            ; packet related directive.
          (312 11 '$INT_SUM          ; Computed y definition.
            '(GAUSSIAN_LIST G_INT)   ; sum of all intensities.
                                     ; It is a summation parameter (8),
                                     ; Derivable parameter (1),
                                     ; With computed sigma (2),
                                     ; and no cache use (4).
          )
          (326 '(SHO_INTENSITY 1) '(GAUSSIAN_LIST G_INT))
        )                            ; end of scan packet directives.
                                     ; no scan end related exec seq.
     )                               ; end of scan.
     (326 '(SHO_INTENSITY 1) '$INT_SUM)
   )
))

;
;****************************************************
;*                                                  *
;*    FIX or UNFIX some least-squares variable      *
;*                                                  *
;****************************************************
;

;(sys_call 342 R2_COEF_A R2_COEF_W); ; block the r2_coef_a to w variables
                                     ; to fixed block (default).

;(sys_call 342 R2_COEF_A R2_COEF_W *BLK1*) ; ; block the r2_coef_b variables
                                     ; to main diagonal block.



(sys_call 341 *BLK_MAIN*)            ; Open the Main diagonal block.

;
;****************************************************
;*                                                  *
;*    Initialize the Least-Squares processor.       *
;*      And create the running structures.          *
;*                                                  *
;****************************************************
;

(sys_call 302)

;
;****************************************************
;*                                                  *
;*    Read the Least-Squares Experimental Data.     *
;*                                                  *
;****************************************************
;

(progn
  ;
  ; *** Initialize the i/o system ***
  ;
  (setq CURVE_LISTE ()
        CURR_PT     ()
        OPEN_RESULT (open 'F "I" "curve"))
  (unless (zerop OPEN_RESULT) (exit " Fit --- Cannot open the input file."))
  (input 'F "entree un point s.v.p. ")
  (listing "FIT$OUTPUT"                 ; Listing file name,
           ()                           ; New version to create.
           ()                           ; No automatic print.
           ()                           ; No append mode.
           58                           ; 58 lines per page.
           132)                         ; 132 character per line.
  (list_head ()                         ; file to apply.
       "P.WOLFERS Software, E-Lisp Fitting prototype program." ; Page Heading.
             T                          ; No title.
             T)                         ; No Sub title.

  (setq CURVE_LISTE '(()) )             ; initialize the record liste.

  (setq XX (read))                      ; read the first x.
  (until (EOF)
    (setq YY (read))
;   (print " x = " XX ", y = " YY)
    (setq SGSG (sqrt YY))               ; read obs. y and sigma.
    
    (zapline)                           ; ignore all trailing data.

    (r_new CURR_PT XX YY SGSG 0.0)      ; Create and init the record.
    (queue_put CURVE_LISTE CURR_PT)     ; put the record in the list.

    (setq xx (read))
  )                                     ; end of until.

  (close 'F)
  (chaine)                              ; enable terminal i/o mode.

; (print (cdr CURVE_LISTE))

  (sys_call 331 DATA_LIST CURVE_LISTE )

  (setq CURR_POINT (cdr CURVE_LISTE))
  (until (null CURR_POINT)
    (setq CURR_PT (nextl CURR_POINT))
    (print "  x = "     (CURR_PT DAT_X)
           ", y = "     (CURR_PT DAT_Y)
           ", Sigma = " (CURR_PT DAT_SG) ".") 
  )

;
;****************************************************
;*                                                  *
;*    Run the Least-Squares Processor for 2 Cycles. *
;*                                                  *
;****************************************************
;

  (setq FLG_LIST     1     ; option(listhkl) = yes
        CORREL_MIN   0.0)  ; option(mxcorrel) = 0.0

  (setq CONT_FLG     T)
  (while CONT_FLG
    (setq CORREL_CURRL CORREL_LIST)
    (sys_call 303 10
                -1            ; First cycle # (not forced).
                10            ; Maximum number of tolerate singularities.
                ()            ; Minimal value for a pivot (defaulted).
                ()            ; Normal matrix computing (T => computed at first cycle only).
                 T            ; Final cycle required (T => suppressed).
                 T            ; Correlation matrix required after final cycle.
    )
    (setq CONT_FLG (eq 1 (progn (prin "Other Cycles ?") (read))))
  )

;
;************************************************
;*                                              *
;*    Perform the final least-squares cycle.    *
;*                                              *
;************************************************
;

; (sys_call 304)


; (sys_call 342 R2_COEF_A R2_COEF_W *BLK_MAIN*) ; ; all variables ...
                                   ; to main diagonal block.

; (sys_call 302)


  (sys_call 303  0     ; number of cycle to perform.
                 0     ; First cycle #.
                10     ; Maximum number of tolerate singularities.
                ()     ; Minimal value for a pivot (defaulted).
                ()     ; Normal matrix computing (T => computed at first cycle only).
                ()     ; Final cycle required (T => suppressed).
                 T     ; Correlation matrix required after final cycle.
  )

;
;****************************************************
;*                                                  *
;*    Free the Least-Squares running Structures.    *
;*                                                  *
;****************************************************
;


  (sys_call 304)

  (exit " *** end of fit list ***")
)
