(PRAGMA "r-" "l-")
;
;  Menu action routine.
;
(DE menu_action (menu_titre menu_list action_list) 
  (LET (
         (choix (SYS_CALL 220 menu_titre menu_list))  
       )
    (IF (NUMBERP choix)
      (EVAL (NTH (1- choix) action_list))
      ()
    )
  )
)

(DE get_f_value (title tab def)
  (LET ((val (SYS_CALL 220 title tab def)))
    (UNLESS (FIXP val) (SETQ val def))
    (IN_FLOAT (NTH (1- val ) tab))
  )
)

(DE get_i_value (title tab def)
  (LET ((val (SYS_CALL 220 title tab def)))
    (UNLESS (FIXP val) (SETQ val def))
    (IN_FIX (NTH (1- val ) tab))
  )
)

;
;  *** Verification procedure for module LISP$_LSQ ***
;

(SETQ var_info '(1 2 3 4 5 6)   ; List of variable info : name, old value,
                                ; old sigma (unused), Matrix index,
                                ; Related diagonal block and limits block.
      lim_info '(1 2)           ; Limit info inf and sup.
      par_info '(1 2 3)         ; List of parameter info : name, value
                                ; and sigma.
      blk_info '(1 2 3 4 5 6 7) ; List of diagonal block info :
                                ; name, effectives marqward and dampening fac.,
                                ; x and b vector, and matrix,
                                ; first variable.
      lis_info '(1 2 3 4)       ; List of list info :
                                ; name, Current, first element,
                                ; and first parameter.
      col_info '(1 2 3)         ; List of collect info :
                                ; Related list, Reject factor and statistic
                                ; block.
      sta_info '(1 2 3 4 5 6 7  ; statistic info : obs_count
                 8 9 10 11 12 ) ; user and standard chi2,
                                ; sum ( sqr(delta/sigma) ),
                                ; sum ( sqr(delta*weight)),
                                ; sum ( sqr(delta)),
                                ; sum ( abs(delta*weight)),
                                ; sum ( abs(delta)),
                                ; sum ( sqr(obser*weight)),
                                ; sum ( sqr(obser)),
                                ; sum ( abs(obser*weight)),
                                ; sum ( abs(obser)).

)


; *** Change variable procedure ***
(DE change_varbl (varbl newval sig shift lim_flg beg_flg end_flg)
  (SETQ vinfo (SYS_CALL 372 varbl var_info))
  (WHEN beg_flg                       ; for the begin of a diagonal block.
    (SETQ binfo (SYS_CALL 372 (CADDR (CDDR var_info)) blk_info))
    (SYS_CALL 23)
    (PRINT " Diagonal block """ (NEXTL binfo) """ with Mlc = " (NEXTL binfo)
           " and Dmp = " (CAR binfo)
    )
    (PRINT)

  )
  (PRIN (NEXTL vinfo) " = "
        newval ":"
        sig
  )
  (UNLESS end_flg
        (PRIN ", " (CAR vinfo)
              ", " shift
          (COND
            ((EQ lim_flg 1)  "  *LR*")
            ((EQ lim_flg -1) " *MOD*")
            (T               "      ")
          )
 	       ))
  (PRINT)
)

; *** Output Correlation Matrix Procedure ***
(DE output_correlation (block dim)
  (SETQ binfo (SYS_CALL 372 block blk_info))
  (SYS_CALL 23)
  (PRINT " *** Diagonal block """ (CAR blk_info) """ ***" )
  (PRINT)
  (FORMAT_OUT '((|A|) (|F| 6 3) (|A|))
              " Correlation factors greater than "
              correl_min " ." )
  (SETQ correl_blk (NEXTL correl_currl)) ; get the corr. entry list.
  (SYS_CALL 375 block correl_min correl_blk)
  (WHILE (AND correl_blk (CAR (SETQ correl_ent (NEXTL correl_blk))))
    (PRIN " ---- " )
    (FORMAT_OUT '((|F| 10 4 2)) (nextl correl_ent))
    (PRINT " between the variables """
           (CAR (SYS_CALL 372 (NEXTL correl_ent) var_info))
           """ and """
           (CAR (SYS_CALL 372 (CAR correl_ent) var_info))
           """."
    )
  )
)

; ***  Singularity Notification Procedure ***
(DE signal_sing (varbl nfail ovf_flg)
  (SYS_CALL 23)
  (PRIN " *** Singularity on the Variable """
        (CAR (SYS_CALL 372 varbl var_info)) """")
  (PRINT " => Variable is locked. ")
  (WHEN ovf_flg (SYS_CALL 1 "SING" 14 4))
)

; *** user function to cycle begin notification ***
(DE usr_beg_cycl (c_nb c_end)
  (PRIN "  ")
  (SETQ eff_flg_list (IF c_end (> flg_list 0) (> flg_list 1) )
        title_list (IF eff_flg_list
                     "*** Least-Squares Final cycle result ***"
                     (CONCAT "*** Least-Squares Cycle #" (STRING c_nb 4) " ***")
                   )
  )
  (LIST_HEAD () () title_list) ; Set the page title.
  (UNLESS (SYS_CALL 23 12 4) ; start paragraphe, when => no new page then
    (PRIN "    ") (SYS_CALL 25 title_list)
  )
)

; *** user function to cycle solve notification ***
(DE usr_res_cycl (c_nb)
  (WHEN (> data_coll_nb 1) (usr_end_coll () ))
  (SYS_CALL 23 9 3)
  (PRINT "     Result of the Least-Squares Cycle #" c_nb " .")
  (SYS_CALL 22 2)
)

; *** user function to cycle end notification ***
(DE usr_end_cycl (c_nb)
  (PRINT "***********************************************************")
)

; *** user function to data collection begin notification ***
(DE usr_beg_coll (coll)
  (WHEN eff_flg_list
    (SETQ curr (SYS_CALL 372 (CAR (SYS_CALL 372 coll col_info)) lis_info))
    (SYS_CALL 23 15 3)       ; set a new paragraphe.
    (PRIN "      ")
    (SYS_CALL 25 "Data Collection """ (CAR curr) """ ." )
    (SYS_CALL 22 2)
    (LIST_HEAD () () ()
      (PRINT "   #     X       Y-OBS      YTH      DELTA     SIGMA    WEIGHT    DEL/SIG")
    ) ; set and write the sub-title.
    (PRINT)
  )
)

; *** user function to data collection end notification ***
(DE usr_end_coll (coll)
  (SETQ curr (SYS_CALL 373 coll sta_info))
  (LIST_HEAD () () () T) ; Delete the sub-title.
  (SYS_CALL 23 12 3)
  (PRIN "     ") 
  (IF coll
    (PROGN
      (SYS_CALL 202 the_attr)            ; set computed draw attributs
      (SETQ seg_curve (SYS_CALL 254 seg_curve curve_liste the_spc)) ; plot the theoric curve.
      (IF (> data_coll_nb 1)
        (SYS_CALL 25 "The current particular statistics :" )
        (SYS_CALL 25 "The current statistics :" )
      )
    )
    (sys_call 25 "The current global statistics  :" )
  )
  (PRINT)
  (PRIN "     Number of used observation         = ")
  (FORMAT_OUT '((|I| 6)) (NEXTL curr))
  (PRIN "     User goodness of fit (Chi squared) = ")
  (FORMAT_OUT '((|F| 6 4 1)) (NEXTL curr))
  (PRIN "     Standard goodness of fit           = ")
  (FORMAT_OUT '((|F| 6 4 1)) (NEXTL curr))
)

; *** user packet computing function ***
(DE usr_pack_cmp (coll nobs obs calc delta sigma weight delssig regflg)
  (WHEN eff_flg_list
    (FORMAT_OUT '((|$|) (|I| 4)) nobs
                '((|F| 10 4 2))  (CADR (SYS_CALL 372 $X par_info))
                                 obs calc delta sigma weight delssig)
    (WHEN regflg (PRIN " *R*"))
    (PRINT)
  )
)

; *** user list element computing function ***
(DE usr_liste_next (lis cnt)
  (WHEN eff_flg_list
    ()
  )
)

;
;****************************************************
;*                                                  *
;*       Initialize the Least-Squares Loader.       *
;*                                                  *
;****************************************************
;
(SYS_CALL 301
  ; assign the change variable notification entry.
  '(change_varbl varbl newval sig shgift lim_flg beg_flg end_flg)
  '(output_correlation block dim)    ; assign the user correlation entry.
  '(signal_sing varbl nfail ovf_flg) ; assign the signal singularity entry.
  '(usr_beg_cycl c_nb c_end)    ; assign the begin cycle notification fonction.
  '(usr_res_cycl c_nb)          ; assign the results cycle notification fonction.
  '(usr_end_cycl c_nb)          ; assign the end cycle notification fonction.
  '(usr_beg_coll coll)          ; assign the begin data coll. scan notification fonction.
  '(usr_end_coll coll)          ; assign the summary data coll. scan notification fonction.
  ; assign the packet data collection scan notification fonction.
  '(usr_pack_cmp coll nobs obs calc delta sigma weight delssig regflg)
  ; assign the list get element notification fonction.
  '(usr_liste_next lis cnt)
)

;
;****************************************************
;*                                                  *
;*    Build the Least-Squares Control Structure.    *
;*                                                  *
;****************************************************
;
(DMA 'Gaussian_m ((x (READ)) (w (READ)))
  (LIST '** 2 (LIST 'NEG (LIST '** (LIST '/ x w) 2)))
)
(SETQ G_coef (SQRT (/  3.14159275 (ln 2) )))

(DE Gaussian (x w)
  (** 2 (NEG (** (/ x w) 2)))
)

(SETQ gausslist (LIST ()))

(DE create_gaussian (h l p int)
  (LET ((blk (M_ALLOCB 16)))
    (SYS_CALL 312 int '(* h (* G_coef l)) () T T)
    (M_STORE (M_REFER blk  0 . M_AD) h)
    (M_STORE (M_REFER blk  4 . M_AD) l)
    (M_STORE (M_REFER blk  8 . M_AD) p)
    (M_STORE (M_REFER blk 12 . M_AD) (EVAL int))
    (QUEUE_PUT gausslist blk)
  )
)


(SYS_CALL 314
         '*BLK_MAIN*     ; Create the Least-Squares matrix Block ".BLK_MAIN.".
         '((blkdmpf))    ; Dampening factor expression.
         '((blkmlf ))    ; Marqward factor expression.
)

; Build the 10 major correlation block list link in the correl_list
; for each diagonal block.
(SETQ correl_list (LIST (list_buildq 10 (LIST () () ())) ))

; ".BLK_MAIN." is now open to get the next following variable.
              



; 1ere gaussian.

(SYS_CALL 311 'r1_coef_a 300)    ; Create the a coefficient Least-Squares variable.

(SYS_CALL 311 'r1_coef_x 10)     ; Create the b coefficient Least-Squares variable.

(SYS_CALL 311 'r1_coef_w 2)      ; Create the c coefficient Least-Squares variable.

(create_gaussian r1_coef_a r1_coef_w r1_coef_x 'r1_int)


; 2eme gaussian.

(SYS_CALL 311 'r2_coef_a 30)     ; Create the a coefficient Least-Squares variable.

(SYS_CALL 311 'r2_coef_x 12)     ; Create the b coefficient Least-Squares variable.

(SYS_CALL 311 'r2_coef_w 2)      ; Create the c coefficient Least-Squares variable.

(create_gaussian r2_coef_a r2_coef_w r2_coef_x 'r2_int)


; Now we define the list of gaussians.

; Now we define the list of gaussians.

(SETQ $$h '(gaussian_list 0)
      $$w '(gaussian_list 4)
      $$p '(gaussian_list 8)
)

(SYS_CALL 315 'GAUSSIAN_LIST
  '(
     (312 '$H   '(GAUSSIAN_LIST  0) () T T) ; get current gaussian H.
     (312 '$W   '(GAUSSIAN_LIST  4) () T T) ; get current gaussian W.
     (312 '$P   '(GAUSSIAN_LIST  8) () T T) ; get current gaussian P.
     (312 '$INT '(GAUSSIAN_LIST 12) () T T) ; get current intensity $INT.
     (310 0)                          ; Push stop scan end condition.
     (310 1)                          ; Push Eligibility condition expression.
   )
  0                                   ; No cache use.
)


(SYS_CALL 331 GAUSSIAN_LIST gausslist) ; Link the gaussian definition in the list.


; Now we define the list of data.

(SYS_CALL 315 'DATA_LIST ; Create the data list named "DATA_LIST".
  '(
     (312 '$X  '(DATA_LIST 0 . M_FL))  ; Define the current x parameter.
     (312 '$Y  '(DATA_LIST 4 . M_FL))  ; Define the current y parameter.
     (312 '$SG '(DATA_LIST 8 . M_FL))  ; Define the current sigma parameter.
     (321 GAUSSIAN_LIST 0              ; complete scan of the gaussian list,
       '(                             ; packet related directive.
          (312 '$YTH                  ; Computed y definition.
            '(* $$h Gaussian_m (- $X $$p) $$w )
            T                         ; It is a summation parameter,
            T                         ; Derivable parameter,
            T                         ; With computed sigma,
            ()                        ; and no cache use.
          )
        )                             ; end of scan packet directives.
        ()                            ; no scan end related exec seq.
     )                                ; end of scan.
     (310 $YTH)                       ; push the YTH value to
     (325 DATA_LIST 16 . M_FL)        ; Store it at 16 offset of current el.

     (310 0)                          ; Push stop scan end condition.
     (310 1)                          ; Push Eligibility condition expression.
   )                                  ; end of list sequence.
  0                      ; without cache.
) 


; Now we define the data collection to fit.

(SYS_CALL 316 'DATA_COLL DATA_LIST    ; the Data collection use the DATA_LIST
                                      ; list to scan the experimental data.
  '(                                  ; Begin of packet directives.
    (310 '(/ 1.0 (SQRT $YTH)))        ; Weight to use, (maximum of likehood).
;   (310 '(/ 1.0 $SG))               ; ; Weight to use, (standard least-squares).
    (310 $SG)                         ; Related Y sigma,
    (310 $Y)                          ; Value to use as experimental Y,
    (310 $YTH)                        ; Parameter to use as computed value,
    (310 1)                           ; Push sentinel.
  )
  ()                                  ; No cycle directive list.
  1E10                                ; Rejection to use.
)
(SETQ data_coll_nb 1)

;
;****************************************************
;*                                                  *
;*    Define the fit related basic directives       *
;*                                                  *
;****************************************************
;

(SETQ G_STATIS (SYS_CALL 319
  '(                                 ; Define By cycle directive.
     (326 '(NULL T))
   )
  '()                                ; Define Final directive.
))

;
;****************************************************
;*                                                  *
;*    Initialize the Least-Squares processor.       *
;*      And create the running structures.          *
;*                                                  *
;****************************************************
;

(SYS_CALL 302)

;
;****************************************************
;*                                                  *
;*    Read the Least-Squares Experimental Data.     *
;*                                                  *
;****************************************************
;

(PROGN
  ;
  ; *** Initialize the i/o system ***
  ;
  (SETQ curve_liste (LIST ())
        Open_result (OPEN 'f "i" "curve")
  )
  (UNLESS (ZEROP Open_result) (EXIT " Fit --- Cannot open the input file."))
  (INPUT 'f "entree un point s.v.p. ")
  (LISTING "FIT$OUTPUT"                 ; Listing file name,
           ()                           ; New version to create.
           ()                           ; No automatic PRINT.
           ()                           ; No append mode.
           58                           ; 58 lines per page.
           132)                         ; 132 character per line.
  (LIST_HEAD ()                         ; file to apply.
       "P.WOLFERS Software, E-Lisp Fitting prototype program." ; Page Heading.
             T                          ; No title.
             T)                         ; No Sub title.

  (SETQ xx (READ))                      ; read the first x.
  (UNTIL (EOF)
    (SETQ yy (READ) sgsg (SQRT yy))     ; read obs. y and sigma.
    (UNTIL SYS$_READ_EOLN (READ))       ; ignore all trailing data.
    (SETQ cblk (M_ALLOCB 20))           ; allocate the memory block.
    (M_STORE (M_REFER cblk 0 . M_FL) xx)    ; set the x value.
    (M_STORE (M_REFER cblk 4 . M_FL) yy)    ; set the x value.
    (M_STORE (M_REFER cblk 8 . M_FL) sgsg)  ; set the x value.
    (QUEUE_PUT curve_liste cblk)
    (SETQ xx (READ))
  )                                     ; end of until.

  (CLOSE 'f)


; *** plot de la courbe experimentale ***

  (SYS_CALL 201 18 15 "Essai de Fit" T) ; Init du graphic.

  (SETQ exp_spc '( 0   4  ()  () ()  8) ; Set offsets and seg id for exp. curve.
        the_spc '( 0  16  ()  2)        ; Set offsets and seg id for th. curve.
        exp_attr '(2  3  4 1.0)         ; Set Attributs (marker,blue,circle,size) for exp.
        sig_attr '(1  1  1 1.0)         ; Set Attributs (line,black,continue,size) for sig.
        the_attr '(1  2  1 2.0)         ; Set Attributs (line,red,continue,size) for th.
        minimaxi (SYS_CALL 51 curve_liste exp_spc) ; comput min-maxi.
  )
  (SYS_CALL 251 minimaxi 14 10 2 2 "X" "Y" T)  ; Create the box.

  (SYS_CALL 208 1)                             ; define the experimental segment.

  (SYS_CALL 202 exp_attr)                      ; set exp. attributs.
  (SYS_CALL 254 () curve_liste exp_spc)        ; Plot the experimental curve.

  (SYS_CALL 202 sig_attr)                      ; set sigma attributs.
  (SYS_CALL 258 () curve_liste exp_spc)        ; Plot the experimental sigma.

  (SYS_CALL 238)                               ; start in time of fly mode.


  (SETQ seg_curve -1)                          ; the first cycle is flaged by no computed
                                               ; curve segment #.


  (EVAL (LIST 'SYS_CALL '331 'DATA_LIST 'curve_liste ) )

; (SETQ curr_pt curve_liste)
; (UNTIL (NULL curr_pt)
;   (SETQ cblk (NEXTL curr_pt))
;   (SETQ
;     xxx    (M_REFER cblk  4 . M_FL)
;     yyy    (M_REFER cblk  8 . M_FL)
;     sgsgsg (M_REFER cblk 12 . M_FL)
;   )
;    (PRINT "block = " cblk ", x = " xxx ", y = " yyy ", Sigma = " sgsgsg ".") 
; )

;
;*********************************************************
;*                                                       *
;*    Run the Least-Squares Processor on user control    *
;*                                                       *
;*********************************************************
;

  (SETQ flg_list     1     ; option(listhkl) = yes
        correl_min   0.1   ; option(mxcorrel) = 0.1
        ncycle       1
        blkmlf       1.0
        blkdmpf      1.0
        i_factab   '( "     1     "
                      "     2     "
                      "     3     "
                      "     4     "
                      "     5     "
                      "     6     "
                      "     7     "
                      "     8     "
                      "     9     "
                      "    10     "
                    )
        f_factab   '("   1.0     "
                     "   0.9     "
                     "   0.8     "
                     "   0.7     "
                     "   0.6     "
                     "   0.5     "
                     "   0.4     "
                     "   0.3     "
                     "   0.2     "
                     "   0.1     "
                    )
  )

  (SETQ cont_flg     T)
  (WHILE cont_flg
    (SETQ correl_currl correl_list)
    (menu_action "Fit Main Menu"
      '( "     Fit    "
         "nb. of Cycle"
         "dampening f."
         " Marqward f."
         "  Draw Menu "
         "    Exit    "
       )
      '( (SYS_CALL 303 ncycle ; number of cycle to perform.
                -1            ; First cycle # (not forced).
                10            ; Maximum number of tolerate singularities.
                ()            ; Minimal value for a pivot (defaulted).
                ()            ; Normal matrix computing (T => computed at first cycle only).
                 T            ; Final cycle required (T => suppressed).
                 T            ; Correlation matrix required after final cycle.
         )
         (SETQ ncycle  (get_i_value "nb of cycle?"    i_factab ncycle))
         (SETQ blkdmpf (get_f_value "Dampening f."    f_factab
                                    (IN_FIX (* 10.0 (- 1.1 blkdmpf)))
                       ))
         (SETQ blkmlf  (get_f_value "Marqward factor" f_factab
                                    (IN_FIX (* 10.0 (- 1.1 blkmlf)))
                       ))
         (SYS_CALL 240)
         (SETQ cont_flg ())
       )
    )
  )

;
;************************************************
;*                                              *
;*    Perform the final least-squares cycle.    *
;*                                              *
;************************************************
;


  (SYS_CALL 303  0     ; number of cycle to perform.
                 0     ; First cycle #.
                10     ; Maximum number of tolerate singularities.
                ()     ; Minimal value for a pivot (defaulted).
                ()     ; Normal matrix computing (T => computed at first cycle only).
                ()     ; Final cycle required (T => suppressed).
                 T     ; Correlation matrix required after final cycle.
  )

;
;****************************************************
;*                                                  *
;*    Free the Least-Squares running Structures.    *
;*                                                  *
;****************************************************
;

  (SYS_CALL 304)

;
;     Stop before close GKS by a call of dialog.
;
  (SYS_CALL 200)
  (PRINT " *** end of fit list ***")
)

