(pragma "r-" "l-")
;
;  Menu action routine.
;
(de menu_action (menu_titre menu_list action_list) 
  (let (
         (choix (sys_call 220 menu_titre menu_list))  
       )
    (if (numberp choix)
      (eval (nth (1- choix) action_list))
      ()
    )
  )
)

(de get_f_value (title tab def)
  (let ((val (sys_call 220 title tab def)))
    (unless (fixp val) (setq val def))
    (in_float (nth (1- val ) tab))
  )
)

(de get_i_value (title tab def)
  (let ((val (sys_call 220 title tab def)))
    (unless (fixp val) (setq val def))
    (in_fix (nth (1- val ) tab))
  )
)


(setq blk_queue '(())
      var_queue '(()))
      max_menu  (list_build 10 ())
)

(de get_block_ref ()
  (let ( (blkl_len (length (car blk_queue)))
         (cur_blk  (car blk_queue))
         (cur_str  '(()))
         (nb 1)
       )
    (until (> nb blkl_len)  ; build the menu.
      (queue_put cur_str (car (sys_call 372 (nextl cur_blk) blk_info)))
      (incr nb)
    )
    (setq nb (sys_call 220 "In the block" (car cur_str))) ; do the choice.
    (while (car cur_str) (queue_get cur_str))  ; free the menu.
    (nth (1- nb) (car blk_queue)) ; Return the block reference.
  )
)


(de get_varbl ref (blk)
  (let ( (binfo (sys_call 372 blk blk_info))
         (cur_str '(()))
         (vnb 0)
         (nb 0)
       )
    (setq vnb (nth 3 binfo))           ; get the size of the block.
    (if (< vnb 1)
      ()                               ; nil when no variable found in block.
      (setq v_lst (list_build vnb ())) ; build the variable list.
      (sys_call 377 blk v_lst)
      (until (> nb vnb)                ; for each variable

        (incr nb)
      )
    )
  )
)

(de fix_unfix_varbl (flg)
  (let ( (var_menu ())
         (cur_var  ())
       )
    (sys_call 304)              ; free all depend structures.

    (sys_call 302)              ; rebuild variable depend structures.
  )
)






;
;  *** Verification procedure for module LISP$_LSQ ***
;

(setq var_info '(1 2 3 4 5 6)   ; List of variable info : name, old value,
                                ; old sigma (unused), Matrix index,
                                ; Related diagonal block and limits block.
      lim_info '(1 2)           ; Limit info inf and sup.
      par_info '(1 2 3)         ; List of parameter info : name, value
                                ; and sigma.
      blk_info '(1               ; List of diagonal block info : name,
                 2 3            ; effectives marqward and dampening fac.,
                 4 5 6 7        ; dimension, x and b vector, and matrix,
                 8)             ; first variable.
      lis_info '(1 2 3 4)       ; List of list info :
                                ; name, Current, first element,
                                ; and first parameter.
      col_info '(1 2 3)         ; List of collect info :
                                ; Related list, Reject factor and statistic
                                ; block.
      sta_info '(1 2 3 4 5 6 7  ; statistic info : obs_count
                 8 9 10 11 12 ) ; user and standard chi2,
                                ; sum ( sqr(delta/sigma) ),
                                ; sum ( sqr(delta*weight)),
                                ; sum ( sqr(delta)),
                                ; sum ( abs(delta*weight)),
                                ; sum ( abs(delta)),
                                ; sum ( sqr(obser*weight)),
                                ; sum ( sqr(obser)),
                                ; sum ( abs(obser*weight)),
                                ; sum ( abs(obser)).
      gbl_info '(1 2 3          ; global info : ncycle, nvarbl, maxsing,
                 4 5 6 7 8      ; mindiag, fixedblk, limfrs, limlas, varfrs,
                 9 10 11)       ; parfrs, listfrs, collfrs.

)


; *** Change variable procedure ***
(de change_varbl (varbl newval sig shift lim_flg beg_flg end_flg)
  (setq vinfo (sys_call 372 varbl var_info))
  (when beg_flg                       ; for the begin of a diagonal block.
    (setq binfo (sys_call 372 (nth 4 var_info) blk_info))
    (sys_call 22)
    (print " Diagonal block """ (nextl binfo) """ with Mlc = " (nextl binfo)
           " and Dmp = " (car binfo)
    )
    (print)
;   (list_head () () ()
;     (print " name   new_value sigma old_value  change"))
;   (print)
  )
  (prin (nextl vinfo) " = "
        newval ":"
        sig
  )
  (unless end_flg
        (prin ", " (car vinfo)
              ", " shift
          (cond
            ((eq lim_flg 1)  "  *LR*")
            ((eq lim_flg -1) " *MOD*")
            (T               "      ")
          )
 	       ))
  (print)
)

; *** Output Correlation Matrix Procedure ***
(de output_correlation (block dim)
  (setq binfo (sys_call 372 block blk_info))
  (sys_call 22)
  (print " *** Diagonal block """ (car blk_info) """ ***" )
  (print)
  (prin " Correlation factors greater than " )  
  (o_fixed (6 3) correl_min)
  (print " .")
  (print)
  (setq correl_blk (nextl correl_currl)) ; get the corr. entry list.
  (sys_call 375 block correl_min correl_blk)
  (while (and correl_blk (car (setq correl_ent (nextl correl_blk))))
    (prin " ---- " )
    (o_fixed (10 4 2) (nextl correl_ent))
    (print " between the variables """
           (car (sys_call 372 (nextl correl_ent) var_info))
           """ and """
           (car (sys_call 372 (car correl_ent) var_info))
           """."
    )
  )
)

; ***  Singularity Notification Procedure ***
(de signal_sing (varbl nfail ovf_flg)
  (sys_call 22)
  (prin " *** Singularity on the Variable """
        (car (sys_call 372 varbl var_info)) """")
  (print " => Variable is locked. ")
  (when ovf_flg (sys_call 1 "SING" 14 4))
)

; *** user function to cycle begin notification ***
(de usr_beg_cycl (c_nb c_end)
  (prin "  ")
  (setq eff_flg_list (if c_end (> flg_list 0) (> flg_list 1) )
        title_list (if eff_flg_list
                     "*** Least-Squares Final cycle result ***"
                     (concat "*** Least-Squares Cycle #" (string c_nb 4) " ***")
                   )
  )
  (list_head () () title_list) ; Set the page title.
  (unless (sys_call 22 12 4) ; start paragraphe, when => no new page then
    (prin "    ") (sys_call 24 title_list)
  )
)

; *** user function to cycle solve notification ***
(de usr_res_cycl (c_nb)
  (when (> data_coll_nb 1) (usr_end_coll () ))
  (sys_call 22 9 3)
  (print "     Result of the Least-Squares Cycle #" c_nb " .")
  (sys_call 21 2)
)

; *** user function to cycle end notification ***
(de usr_end_cycl (c_nb)
  (print "***********************************************************")
)

; *** user function to data collection begin notification ***
(de usr_beg_coll (coll)
  (when eff_flg_list
    (setq curr (sys_call 372 (car (sys_call 372 coll col_info)) lis_info))
    (sys_call 22 15 3)       ; set a new paragraphe.
    (prin "      ")
    (sys_call 24 "Data Collection """ (car curr) """ ." )
    (sys_call 21 2)
    (list_head () () ()
      (print "   #     X       Y-OBS      YTH      DELTA     SIGMA    WEIGHT    DEL/SIG")
    ) ; set and write the sub-title.
    (print)
  )
)

; *** user function to data collection end notification ***
(de usr_end_coll (coll)
  (setq curr (sys_call 373 coll sta_info))
  (list_head () () () T) ; Delete the sub-title.
  (sys_call 22 12 3)
  (prin "     ") 
  (if coll
    (progn
      (sys_call 202 the_attr)            ; set computed draw attributs
      (setq seg_curve (sys_call 254 seg_curve curve_liste the_spc)) ; plot the theoric curve.
      (if (> data_coll_nb 1)
        (sys_call 24 "The current particular statistics :" )
        (sys_call 24 "The current statistics :" )
      )
    )
    (sys_call 24 "The current global statistics  :" )
  )
  (print)
  (prin "     Number of used observation         = ")
  (o_fixed (6) (nextl curr)) (print)
  (prin "     User goodness of fit (Chi squared) = ")
  (o_fixed (6 4 1) (nextl curr)) (print)
  (prin "     Standard goodness of fit           = ")
  (o_fixed (6 4 1) (nextl curr)) (print)
)

; *** user packet computing function ***
(de usr_pack_cmp (coll nobs obs calc delta sigma weight delssig regflg)
  (when eff_flg_list
    (o_fixed (4) nobs)
    (o_fixed (10 4 2)  (cadr (sys_call 372 $X par_info))
                       obs calc delta sigma weight delssig)
    (when regflg (prin " *R*"))
    (print)
  )
)

; *** user list element computing function ***
(de usr_liste_next (lis cnt)
  (when eff_flg_list
    ()
  )
)

;
;****************************************************
;*                                                  *
;*       Initialize the Least-Squares Loader.       *
;*                                                  *
;****************************************************
;
(sys_call 301
  ; assign the change variable notification entry.
  '(change_varbl varbl newval sig shgift lim_flg beg_flg end_flg)
  '(output_correlation block dim)    ; assign the user correlation entry.
  '(signal_sing varbl nfail ovf_flg) ; assign the signal singularity entry.
  '(usr_beg_cycl c_nb c_end)    ; assign the begin cycle notification fonction.
  '(usr_res_cycl c_nb)          ; assign the results cycle notification fonction.
  '(usr_end_cycl c_nb)          ; assign the end cycle notification fonction.
  '(usr_beg_coll coll)          ; assign the begin data coll. scan notification fonction.
  '(usr_end_coll coll)          ; assign the summary data coll. scan notification fonction.
  ; assign the packet data collection scan notification fonction.
  '(usr_pack_cmp coll nobs obs calc delta sigma weight delssig regflg)
  ; assign the list get element notification fonction.
  '(usr_liste_next lis cnt)
)

;
;****************************************************
;*                                                  *
;*    Build the Least-Squares Control Structure.    *
;*                                                  *
;****************************************************
;
(dma 'Gaussian_m ((x (read)) (w (read)))
  (list '** 2 (list 'neg (list '** (list '/ x w) 2)))
)
(setq G_coef (sqrt (/  3.14159275 (ln 2) )))

(de Gaussian (x w)
  (** 2 (neg (** (/ x w) 2)))
)

(setq cgauss ()
      gausslist ())

(de create_gaussian (h l p int)
  (let ((blk (m_allocb 20)))
    (sys_call 312 int '(* h (* G_coef l)) () T T)
    (m_put (m_offset blk  4) M_AD h)
    (m_put (m_offset blk  8) M_AD l)
    (m_put (m_offset blk 12) M_AD p)
    (m_put (m_offset blk 16) M_AD (eval int))
    (setq blk (cons blk ()))
    (if (null gausslist)
      (setq gausslist blk
            cgauss    blk)
      (rplacd cgauss blk)
      (nextl cgauss)
    )
  )
)


(setq x_lim (sys_call 313 0 20)    ; Create a limit block for the positions.
      h_lim (sys_call 313 0 1000)  ; Create a limit block for the highs.
      w_lim (sys_call 313 0.01 10) ; Create a limit block for the widths.
)


(queue_put blk_que       ; put diagonal block in the block queue.
  (sys_call 314
         '*BLK_MAIN*     ; Create the Least-Squares matrix Block ".BLK_MAIN.".
         '((blkdmpf))    ; Dampening factor expression.
         '((blkmlf ))    ; Marqward factor expression.
  )
)

; Build the 10 major correlation block list link in the correl_list
; for each diagonal block.
(setq correl_list (list (list_buildq 10 '(list () () ()) )))

; ".BLK_MAIN." is now open to get the next following variable.
              



; 1ere gaussian.

(sys_call 311 'r1_coef_a 300 () h_lim) ; Create the a coefficient Least-Squares variable.

(sys_call 311 'r1_coef_x  10 () x_lim) ; Create the b coefficient Least-Squares variable.

(sys_call 311 'r1_coef_w   2 () w_lim) ; Create the c coefficient Least-Squares variable.

(create_gaussian r1_coef_a r1_coef_w r1_coef_x 'r1_int)


; 2eme gaussian.

(sys_call 311 'r2_coef_a  30 () h_lim) ; Create the a coefficient Least-Squares variable.

(sys_call 311 'r2_coef_x  12 () x_lim) ; Create the b coefficient Least-Squares variable.

(sys_call 311 'r2_coef_w   2 () w_lim) ; Create the c coefficient Least-Squares variable.

(create_gaussian r2_coef_a r2_coef_w r2_coef_x 'r2_int)


; Now we define the list of gaussians.

; Now we define the list of gaussians.

(setq $$h '(gaussian_list ()  4)
      $$w '(gaussian_list ()  8)
      $$p '(gaussian_list () 12)
)

(sys_call 315 'GAUSSIAN_LIST
  '(
     (312 '$H   '(GAUSSIAN_LIST ()  4) () T T) ; get current gaussian H.
     (312 '$W   '(GAUSSIAN_LIST ()  8) () T T) ; get current gaussian W.
     (312 '$P   '(GAUSSIAN_LIST () 12) () T T) ; get current gaussian P.
     (312 '$INT '(GAUSSIAN_LIST () 16) () T T) ; get current intensity $INT.
     (310 0)                          ; Push stop scan end condition.
     (310 1)                          ; Push Eligibility condition expression.
   )
  0                                   ; No cache use.
)


(sys_call 331 GAUSSIAN_LIST gausslist) ; Link the gaussian definition in the list.


; Now we define the list of data.

(sys_call 315 'DATA_LIST ; Create the data list named "DATA_LIST".
  '(
     (312 '$X  '(DATA_LIST M_FL  4))  ; Define the current x parameter.
     (312 '$Y  '(DATA_LIST M_FL  8))  ; Define the current y parameter.
     (312 '$SG '(DATA_LIST M_FL 12))  ; Define the current sigma parameter.
     (321 GAUSSIAN_LIST 0             ; complete scan of the gaussian list,
       '(                             ; packet related directive.
          (312 '$YTH                  ; Computed y definition.
            '(* $$h Gaussian_m (- $X $$p) $$w )
            T                         ; It is a summation parameter,
            T                         ; Derivable parameter,
            T                         ; With computed sigma,
            ()                        ; and no cache use.
          )
        )                             ; end of scan packet directives.
        ()                            ; no scan end related exec seq.
     )                                ; end of scan.
     (310 $YTH)                       ; push the YTH value to
     (325 DATA_LIST M_FL 20)          ; Store it at 20 offset of current el.

     (310 0)                          ; Push stop scan end condition.
     (310 1)                          ; Push Eligibility condition expression.
   )                                  ; end of list sequence.
  0                      ; without cache.
) 


; Now we define the data collection to fit.

(sys_call 316 DATA_LIST               ; the Data collection use the DATA_LIST
                                      ; list to scan the experimental data.
  '(                                  ; Begin of packet directives.
    (310 '(/ 1.0 (sqrt $YTH)))        ; Weight to use, (maximum of likehood).
;   (310 '(/ 1.0 $SG))               ; ; Weight to use, (standard least-squares).
    (310 $SG)                         ; Related Y sigma,
    (310 $Y)                          ; Value to use as experimental Y,
    (310 $YTH)                        ; Parameter to use as computed value,
    (310 1)                           ; Push sentinel.
  )
  ()                                  ; No cycle directive list.
  1E10                                ; Rejection to use.
)
(setq data_coll_nb 1)

;
;****************************************************
;*                                                  *
;*    Define the fit related basic directives       *
;*                                                  *
;****************************************************
;

(setq G_STATIS (sys_call 319
  '(                                 ; Define By cycle directive.
     (326 '(null T))
   )
  '()                                ; Define Final directive.
))

;
;****************************************************
;*                                                  *
;*    Initialize the Least-Squares processor.       *
;*      And create the running structures.          *
;*                                                  *
;****************************************************
;

(sys_call 302)

;
;****************************************************
;*                                                  *
;*    Read the Least-Squares Experimental Data.     *
;*                                                  *
;****************************************************
;

(progn
  ;
  ; *** Initialize the i/o system ***
  ;
  (setq curve_liste ()
        curr_pt     ()
        Open_result (open 'f "i" "curve"))
  (unless (zerop Open_result) (exit " Fit --- Cannot open the input file."))
  (input 'f "entree un point s.v.p. ")
  (listing "FIT$OUTPUT"                 ; Listing file name,
           ()                           ; New version to create.
           ()                           ; No automatic print.
           ()                           ; No append mode.
           58                           ; 58 lines per page.
           132)                         ; 132 character per line.
  (list_head ()                         ; file to apply.
       "P.WOLFERS Software, E-Lisp Fitting prototype program." ; Page Heading.
             T                          ; No title.
             T)                         ; No Sub title.

  (setq xx (read))                      ; read the first x.
  (until EOF
    (setq yy (read) sgsg (sqrt yy))     ; read obs. y and sigma.
    (until sys$_read_eoln (read))       ; ignore all trailing data.
    (setq cblk (m_allocb 24))           ; allocate the memory block.
    (m_put (m_offset cblk  4) m_fl xx)  ; set the x value.
    (m_put (m_offset cblk  8) m_fl yy)  ; set the y value.
    (m_put (m_offset cblk 12) m_fl sgsg); set the sg value.
    (if (null curve_liste)              ; if it is the first curve point.
      (setq curve_liste (cons cblk ())  ; then set first curve element.
            curr_pt     curve_liste)    ; else
      (rplacd curr_pt (cons cblk ()))   ;   append the new point
      (nextl curr_pt)                   ;   and set it as last point.
    )
    (setq xx (read))
  )                                     ; end of until.

  (close 'f)

;  (print curve_liste)

; *** plot de la courbe experimentale ***

  (sys_call 201 18 15 "Essai de Fit" T)        ; Init du graphic.

  (setq exp_spc '( 4   8  ()  () () 12)        ; Set offsets and seg id for exp. curve.
        the_spc '( 4  20  ()  2))              ; Set offsets and seg id for th. curve.
  (setq exp_attr '(2  3  4 1.0)                ; Set Attributs (marker,blue,circle,size) for exp.
        sig_attr '(1  1  1 1.0)                ; Set Attributs (line,black,continue,size) for sig.
        the_attr '(1  2  1 2.0))               ; Set Attributs (line,red,continue,size) for th.
  (setq minimaxi (sys_call 250 curve_liste exp_spc)) ; comput min-maxi.
  (sys_call 251 minimaxi 14 10 2 2 "X" "Y" T)  ; Create the box.

  (sys_call 208 1)                             ; define the experimental segment.

  (sys_call 202 exp_attr)                      ; set exp. attributs.
  (sys_call 254 () curve_liste exp_spc)        ; Plot the experimental curve.

  (sys_call 202 sig_attr)                      ; set sigma attributs.
  (sys_call 258 () curve_liste exp_spc)        ; Plot the experimental sigma.

  (sys_call 238)                               ; start in time of fly mode.


  (setq seg_curve -1)                          ; the first cycle is flaged by no computed
                                               ; curve segment #.


  (eval (list 'sys_call '331 'DATA_LIST 'curve_liste ) )

; (setq curr_pt curve_liste)
; (until (null curr_pt)
;   (setq cblk (nextl curr_pt))
;   (setq
;     xxx    (m_get (m_offset cblk  4) m_fl)
;     yyy    (m_get (m_offset cblk  8) m_fl)
;     sgsgsg (m_get (m_offset cblk 12) m_fl)
;   )
;    (print "block = " cblk ", x = " xxx ", y = " yyy ", Sigma = " sgsgsg ".") 
; )

;
;*********************************************************
;*                                                       *
;*    Run the Least-Squares Processor on user control    *
;*                                                       *
;*********************************************************
;


  (setq flg_list     1     ; option(listhkl) = yes
        correl_min   0.1   ; option(mxcorrel) = 0.1
        ncycle       1
        blkmlf       1.0
        blkdmpf      1.0
        i_factab   '( "     1     "
                      "     2     "
                      "     3     "
                      "     4     "
                      "     5     "
                      "     6     "
                      "     7     "
                      "     8     "
                      "     9     "
                      "    10     "
                    )
        f_factab   '( "   1.0     "
                      "   0.9     "
                      "   0.8     "
                      "   0.7     "
                      "   0.6     "
                      "   0.5     "
                      "   0.4     "
                      "   0.3     "
                      "   0.2     "
                      "   0.1     "
                    )
  )

  (setq cont_flg     T)
  (while cont_flg
    (setq correl_currl correl_list)
    (menu_action "Fit Main Menu"
      '( "     Fit    "
         "nb. of Cycle"
         "dampening f."
         " Marqward f."
         " Fix a var. "
         "Unfix a var."
         "  Draw Menu "
         "    Exit    "
       )
      '( (sys_call 303 ncycle ; number of cycle to perform.
                -1            ; First cycle # (not forced).
                10            ; Maximum number of tolerate singularities.
                ()            ; Minimal value for a pivot (defaulted).
                ()            ; Normal matrix computing (T => computed at first cycle only).
                 T            ; Final cycle required (T => suppressed).
                 T            ; Correlation matrix required after final cycle.
         )
         (setq ncycle  (get_i_value "nb of cycle?"    i_factab ncycle))
         (setq blkdmpf (get_f_value "Dampening f."    f_factab
                                    (in_fix (* 10.0 (- 1.1 blkdmpf)))
                       ))
         (setq blkmlf  (get_f_value "Marqward factor" f_factab
                                    (in_fix (* 10.0 (- 1.1 blkmlf)))
                       ))
         (fix_unfix_varbl T)
         (fix_unfix_varbl ())
         (sys_call 240)
         (setq cont_flg ())
       )
    )
  )

;
;************************************************
;*                                              *
;*    Perform the final least-squares cycle.    *
;*                                              *
;************************************************
;


  (sys_call 303 ncycle ; number of cycle to perform.
                 0     ; First cycle #.
                10     ; Maximum number of tolerate singularities.
                ()     ; Minimal value for a pivot (defaulted).
                ()     ; Normal matrix computing (T => computed at first cycle only).
                ()     ; Final cycle required (T => suppressed).
                 T     ; Correlation matrix required after final cycle.
  )

;
;****************************************************
;*                                                  *
;*    Free the Least-Squares running Structures.    *
;*                                                  *
;****************************************************
;

  (sys_call 304)

;
;     Stop before close GKS by a call of dialog.
;
  (sys_call 200)
  (print " *** end of fit list ***")
)

