(PRAGMA "R-" "L-")

;
; Include all library files.
;

(INCLUDE "lisplib:lisp_lib.lisp_lib") ; set case and loop statement.
(INCLUDE "dpu_data.lisp_part")        ; include data read statement.
(INCLUDE "dpu_curve_lsq.lisp_part")   ; include least-squares definitions.

;
;  Menu action routine.
;
(DE menu_action (menu_titre menu_list action_list) 
  (LET (
         (choix (sys_call 220 menu_titre menu_list))  
       )
    (IF (NUMBERP choix)
      (EVAL (NTH (1- choix) action_list))
      ()
    )
  )
)

(DE get_f_value (title tab def)
  (LET ((val (SYS_CALL 220 title tab def)))
    (UNLESS (FIXP val) (SETQ val def))
    (IN_FLOAT (NTH (1- val ) tab))
  )
)

(DE get_i_value (title tab def)
  (LET ((val (SYS_CALL 220 title tab def)))
    (UNLESS (FIXP val) (SETQ val def))
    (IN_FIX (NTH (1- val ) tab))
  )
)

;
;****************************************************
;*                                                  *
;*    Build the Least-Squares Control Structure.    *
;*                                                  *
;****************************************************
;
; Build the 10 major correlation block list link in the correl_list
; for each diagonal block.
(SETQ correl_list (LIST (LIST_BUILDQ 10 (list () () ())) ))

; ".BLK_MAIN." is opened to get the next following variable.


;
; *** Define the unit cell variables ***
;
; 5.54*sqrt(2)/2, 15.5
;

(DE create_unit_cell_ref lcell
  (LET ( (p_name (NEXTL lcell) ; get the phase name.
         (system (NEXTL lcell) ; get the system name.
         (aa ())
         (bb ())
         (cc ())
         (al ())
         (be ())
         (ga ())
       )
    (COND
      ((EQ system 'cubic)
        (aa (NEXTL lcell))
        (SYS_CALL 311 '$TA (** (/ 1 aa)))
        (SYS_CALL 312 '$TB '$TA () T T)
        (SYS_CALL 312 '$TC '$TA () T T)
        (SYS_CALL 312 '$TD 0)
        (SYS_CALL 312 '$TE 0)
        (SYS_CALL 312 '$TF 0)
      )
      ((EQ system 'hexagonal)
        (aa (NEXTL lcell)) (NEXTL lcell)
        (cc (NEXTL lcell))
        (SYS_CALL 311 '$TA (** (/ 1 aa)))
        (SYS_CALL 311 '$TC (** (/ 1 cc)))
        (SYS_CALL 312 '$TB '$TA () T T)
        (SYS_CALL 312 '$TD 0)
        (SYS_CALL 312 '$TE 0)
        (SYS_CALL 312 '$TF '$TA () T T)
      )
      ((EQ system 'quadratic)
        (aa (NEXTL lcell)) (NEXTL lcell)
        (cc (NEXTL lcell))
        (SYS_CALL 311 '$TA (** (/ 1 aa)))
        (SYS_CALL 311 '$TC (** (/ 1 cc)))
        (SYS_CALL 312 '$TB '$TA () T T)
        (SYS_CALL 312 '$TD 0)
        (SYS_CALL 312 '$TE 0)
        (SYS_CALL 312 '$TF 0)
      )
      ((EQ system 'orthorhombic)
        (aa (NEXTL lcell))
        (bb (NEXTL lcell))
        (cc (NEXTL lcell))
        (SYS_CALL 311 '$TA (** (/ 1 aa)))
        (SYS_CALL 311 '$TB (** (/ 1 bb)))
        (SYS_CALL 311 '$TC (** (/ 1 cc)))
        (SYS_CALL 312 '$TB '$TA () T T)
        (SYS_CALL 312 '$TD 0)
        (SYS_CALL 312 '$TE 0)
        (SYS_CALL 312 '$TF 0)
      )
      (T ; default to triclinic.
        (aa (NEXTL lcell))
        (bb (NEXTL lcell))
        (cc (NEXTL lcell))
        (al (NEXTL lcell)) (WHEN (> (ABS al) 1) (SETQ al (COSD al))
        (be (NEXTL lcell)) (WHEN (> (ABS be) 1) (SETQ be (COSD be))
        (ga (NEXTL lcell)) (WHEN (> (ABS ga) 1) (SETQ ga (COSD ga))

      )
    )
  )
)






(DMA 'Gaussian_m ((x (READ)) (w (READ)))
  (LIST '** 2 (LIST 'NEG (LIST '** (LIST '/ x w) 2)))
)

(SETQ g_coef (SQRT (/  3.14159275 (LN 2) )))

(DE Gaussian (x w)
  (** 2 (NEG (** (/ x w) 2)))
)

(SETQ gausslist (LIST ())
)


(DE create_reflexion (h k l m nq)
  (LET ( (s_hkl (CONCAT (STRING h -3) (STRING k -3) (STRING l -3)))
         (h_id ())
         (blk (m_allocb 12))
       )
    (SETQ h_id (IMPLODECH (CONCAT "HIGH_" s_hkl)))
    )
    (M_PUT (M_OFFSET blk  4) M_SB h)
    (M_PUT (M_OFFSET blk  5) M_SB k)
    (M_PUT (M_OFFSET blk  6) M_SB l)
    (M_PUT (M_OFFSET blk  7) M_SB nq)
    (M_PUT (M_OFFSET blk  8) M_UB m)
    (SYS_CALL 311 h_id 1)     ; create the reflexion high variable.
    (M_PUT (M_OFFSET blk 10) M_AD (EVAL h_id))
    (QUEUE_PUT lisp_hlk_list blk)
  )
)


(SETQ lisp_hkl_list (LIST ()) )

(sys_call 315 'l_HKL
  '(
     ; define sin(theta)/lambda.
     (312 '$SITHSL '(SQRT (+ (+ (+ $TA (** (L_HKL M_SB 4) 2)
                                   $TB (** (L_HKL M_SB 5) 2) )
                                   $TC (** (L_HKL M_SB 6) 2)   )
                             (+ (+ $TD (* (L_HKL M_SB 5) (L_HKL M_SB 6))
                                   $TE (* (L_HKL M_SB 6) (L_HKL M_SB 4)) )
                                   $TF (* (L_HKL M_SB 4) (L_HKL M_SB 5))   ))
                    ) () T)
     ; define theta.
     (312 '$THETA  '(ASIND (* $LAMBDA $SITHSL)) () T)
     ; define tan(theta).
     (312 '$TANTH  '(TAND  $THETA))
     ; define the reflexion width.
     (312 '$WIDTH  '(+ $WA (+ (* $WB $TANTH) (* $WC (** $TANTH 2)))) () T)
     ; define the lorentz coefficient.
     (312 '$LZ     '(/ 1 (* (SIND $THETA) (SIND (* 2 $THETA)))) () T)
     ; define the reflexion contribution.
     (312 'REFL    '(* (* $LZ (L_HKL M_UB 7)) (L_HKL () 8)) () T)

     (310 0)                          ; Push stop scan end condition.
     (310 1)                          ; Push Eligibility condition expression.
   )
  10                                  ; Use a cache of ten reflexions.
)








(sys_call 331 GAUSSIAN_LIST gausslist) ; Link the gaussian definition in the list.


; Now we define the list of data.

(sys_call 315 'DATA_LIST ; Create the data list named "DATA_LIST".
  '(
     (312 '$X  '(DATA_LIST M_FL  4))  ; Define the current x parameter.
     (312 '$Y  '(DATA_LIST M_FL  8))  ; Define the current y parameter.
     (312 '$SG '(DATA_LIST M_FL 12))  ; Define the current sigma parameter.
     (321 GAUSSIAN_LIST 0             ; complete scan of the gaussian list,
       '(                             ; packet related directive.
          (312 '$YTH                  ; Computed y definition.
            '(* $$h Gaussian_m (- $X $$p) $$w )
            T                         ; It is a summation parameter,
            T                         ; Derivable parameter,
            T                         ; With computed sigma,
            ()                        ; and no cache use.
          )
        )                             ; end of scan packet directives.
        ()                            ; no scan end related exec seq.
     )                                ; end of scan.
     (310 $YTH)                       ; push the YTH value to
     (325 DATA_LIST M_FL 20)          ; Store it at 20 offset of current el.

     (310 0)                          ; Push stop scan end condition.
     (310 1)                          ; Push Eligibility condition expression.
   )                                  ; end of list sequence.
  0                      ; without cache.
) 


; Now we define the data collection to fit.

(sys_call 316 DATA_LIST               ; the Data collection use the DATA_LIST
                                      ; list to scan the experimental data.
  '(                                  ; Begin of packet directives.
    (310 '(/ 1.0 (sqrt $YTH)))        ; Weight to use, (maximum of likehood).
;   (310 '(/ 1.0 $SG))               ; ; Weight to use, (standard least-squares).
    (310 $SG)                         ; Related Y sigma,
    (310 $Y)                          ; Value to use as experimental Y,
    (310 $YTH)                        ; Parameter to use as computed value,
    (310 1)                           ; Push sentinel.
  )
  ()                                  ; No cycle directive list.
  1E10                                ; Rejection to use.
)
(setq data_coll_nb 1)

;
;****************************************************
;*                                                  *
;*    Define the fit related basic directives       *
;*                                                  *
;****************************************************
;

(setq G_STATIS (sys_call 319
  '(                                 ; Define By cycle directive.
     (326 '(null T))
   )
  '()                                ; Define Final directive.
))

;
;****************************************************
;*                                                  *
;*    Initialize the Least-Squares processor.       *
;*      And create the running structures.          *
;*                                                  *
;****************************************************
;

(sys_call 302)

;
;****************************************************
;*                                                  *
;*    Read the Least-Squares Experimental Data.     *
;*                                                  *
;****************************************************
;

(progn
  ;
  ; *** Initialize the i/o system ***
  ;
  (setq curve_liste ()
        curr_pt     ()
        Open_result (open 'f "i" "curve"))
  (unless (zerop Open_result) (exit " Fit --- Cannot open the input file."))
  (input 'f "entree un point s.v.p. ")
  (listing "FIT$OUTPUT"                 ; Listing file name,
           ()                           ; New version to create.
           ()                           ; No automatic print.
           ()                           ; No append mode.
           58                           ; 58 lines per page.
           132)                         ; 132 character per line.
  (list_head ()                         ; file to apply.
       "P.WOLFERS Software, E-Lisp Fitting prototype program." ; Page Heading.
             T                          ; No title.
             T)                         ; No Sub title.

  (setq xx (read))                      ; read the first x.
  (until EOF
    (setq yy (read) sgsg (sqrt yy))     ; read obs. y and sigma.
    (until sys$_read_eoln (read))       ; ignore all trailing data.
    (setq cblk (m_allocb 24))           ; allocate the memory block.
    (m_put (m_offset cblk  4) m_fl xx)  ; set the x value.
    (m_put (m_offset cblk  8) m_fl yy)  ; set the y value.
    (m_put (m_offset cblk 12) m_fl sgsg); set the sg value.
    (if (null curve_liste)              ; if it is the first curve point.
      (setq curve_liste (cons cblk ())  ; then set first curve element.
            curr_pt     curve_liste)    ; else
      (rplacd curr_pt (cons cblk ()))   ;   append the new point
      (nextl curr_pt)                   ;   and set it as last point.
    )
    (setq xx (read))
  )                                     ; end of until.

  (close 'f)

;  (print curve_liste)

; *** plot de la courbe experimentale ***

  (sys_call 201 18 15 "Essai de Fit" T)        ; Init du graphic.

  (setq exp_spc '( 4   8  ()  () () 12)        ; Set offsets and seg id for exp. curve.
        the_spc '( 4  20  ()  2))              ; Set offsets and seg id for th. curve.
  (setq exp_attr '(2  3  4 1.0)                ; Set Attributs (marker,blue,circle,size) for exp.
        sig_attr '(1  1  1 1.0)                ; Set Attributs (line,black,continue,size) for sig.
        the_attr '(1  2  1 2.0))               ; Set Attributs (line,red,continue,size) for th.
  (setq minimaxi (sys_call 250 curve_liste exp_spc)) ; comput min-maxi.
  (sys_call 251 minimaxi 14 10 2 2 "X" "Y" T)  ; Create the box.

  (sys_call 208 1)                             ; define the experimental segment.

  (sys_call 202 exp_attr)                      ; set exp. attributs.
  (sys_call 254 () curve_liste exp_spc)        ; Plot the experimental curve.

  (sys_call 202 sig_attr)                      ; set sigma attributs.
  (sys_call 258 () curve_liste exp_spc)        ; Plot the experimental sigma.

  (sys_call 238)                               ; start in time of fly mode.


  (setq seg_curve -1)                          ; the first cycle is flaged by no computed
                                               ; curve segment #.


  (eval (list 'sys_call '331 'DATA_LIST 'curve_liste ) )

; (setq curr_pt curve_liste)
; (until (null curr_pt)
;   (setq cblk (nextl curr_pt))
;   (setq
;     xxx    (m_get (m_offset cblk  4) m_fl)
;     yyy    (m_get (m_offset cblk  8) m_fl)
;     sgsgsg (m_get (m_offset cblk 12) m_fl)
;   )
;    (print "block = " cblk ", x = " xxx ", y = " yyy ", Sigma = " sgsgsg ".") 
; )

;
;*********************************************************
;*                                                       *
;*    Run the Least-Squares Processor on user control    *
;*                                                       *
;*********************************************************
;

  (setq flg_list     1     ; option(listhkl) = yes
        correl_min   0.1   ; option(mxcorrel) = 0.1
        ncycle       1
        blkmlf       1.0
        blkdmpf      1.0
        i_factab   '( "     1     "
                      "     2     "
                      "     3     "
                      "     4     "
                      "     5     "
                      "     6     "
                      "     7     "
                      "     8     "
                      "     9     "
                      "    10     "
                    )
        f_factab   '("   1.0     "
                     "   0.9     "
                     "   0.8     "
                     "   0.7     "
                     "   0.6     "
                     "   0.5     "
                     "   0.4     "
                     "   0.3     "
                     "   0.2     "
                     "   0.1     "
                    )
  )

  (setq cont_flg     T)
  (while cont_flg
    (setq correl_currl correl_list)
    (menu_action "Fit Main Menu"
      '( "     Fit    "
         "nb. of Cycle"
         "dampening f."
         " Marqward f."
         "  Draw Menu "
         "    Exit    "
       )
      '( (sys_call 303 ncycle ; number of cycle to perform.
                -1            ; First cycle # (not forced).
                10            ; Maximum number of tolerate singularities.
                ()            ; Minimal value for a pivot (defaulted).
                ()            ; Normal matrix computing (T => computed at first cycle only).
                 T            ; Final cycle required (T => suppressed).
                 T            ; Correlation matrix required after final cycle.
         )
         (setq ncycle  (get_i_value "nb of cycle?"    i_factab ncycle))
         (setq blkdmpf (get_f_value "Dampening f."    f_factab
                                    (in_fix (* 10.0 (- 1.1 blkdmpf)))
                       ))
         (setq blkmlf  (get_f_value "Marqward factor" f_factab
                                    (in_fix (* 10.0 (- 1.1 blkmlf)))
                       ))
         (sys_call 240)
         (setq cont_flg ())
       )
    )
  )

;
;************************************************
;*                                              *
;*    Perform the final least-squares cycle.    *
;*                                              *
;************************************************
;


  (sys_call 303 ncycle ; number of cycle to perform.
                 0     ; First cycle #.
                10     ; Maximum number of tolerate singularities.
                ()     ; Minimal value for a pivot (defaulted).
                ()     ; Normal matrix computing (T => computed at first cycle only).
                ()     ; Final cycle required (T => suppressed).
                 T     ; Correlation matrix required after final cycle.
  )

;
;****************************************************
;*                                                  *
;*    Free the Least-Squares running Structures.    *
;*                                                  *
;****************************************************
;

  (sys_call 304)

;
;     Stop before close GKS by a call of dialog.
;
  (sys_call 200)
  (print " *** end of fit list ***")
)

