;
; A general Curve Fitting program.
;
(pragma "R-")                    ; Turn off the result Lisp flag.

;
; Get the Expression manager definitions.
;

(include "lisp_lib.lisp_lib")    ; Include the Case and Loop macros.
(include "lisp_expr.lisp_lib")   ; Include the expression manager.


;
; Define all standard objects.
;

; *** Define some user function ***

(de ord (boolean)
  (if boolean
    1
    0
  )
)


; *** Define a cte parameter ***

(setq pi 3.14159275)
(setq e (exp 1))


; *** Define a varbl ***

(setq v1 (m_allocb 24))
(putprop 'v1 '*type 1.0)




; *********************************
; *                               *
; *   Fit Data Compiler Routine   *
; *                               *
; *********************************

; * Define the Include and Chaine actions *.
(de include_state (incl_flag)
  (let ( (str (cte_str_expr "sys$command")) ; get the filename.
       )
    (unless (eq (cadr *symb) ";")
      (sys_call 0 "INCL" 91 2))
    (if incl_flag
      (progn
        (include str)
        (incr *nincl)
      )
      (chaine str)
    )
    (input () "FIT_V4>" "P")
  )
)

(de eof_state ()
  (unless (<= *nincl 0)         ; For a not final eof ...
    (decr *nincl))
)

(de variable_state ()

)

(de assignement_state (*ide *typ)
  (insymbol)                           ; gobble up the identifier.
  (unless (eq caddr *symb "=")         ; assignement not present ?
    (sys_call 0 "ASSG" 83 2))          ; then error.
  (if (m_block (symeval *ide))         ; if it is a variable/param ?
    (
       
    )
    (set *ide (cte_expression *typ))   ; assign the new value.
  )
)


; *** Routine to handle a statement. ***

(de statement ()
  case *kind (
    (0) ; *** List => Operator, Separator or Keyword ***
      (if (null (nextl *symb))          ; if it is a separator or a keyword
        (if (stringp (car *symb))       ; it is a separator ?
          (progn                        ;
            (unless (eq (car *symb) ";"); if it is not a semicolon then
              (sys_call 0 "STAT" 64 2)) ; send error message.
            (insymbol)                  ; gobble up the separator.
          )
          ; *** No, it is a keyword ***
          (let
            ( (*stat (cdr *symb))       ; Get the statement code.
            )
            (insymbol)                  ; Gobble up the keyword.
            (eval *stat)                ; and perform the statement.
          )
        (sys_call 0 "STAT" 65 3)        ; Illegal construction.
      )

    (1) ; *** User symbol assignement. ***
      (progn
        (when *undef
          (sys_call 0 "STAT" 51 2))     ; Undeclared identifier.
        ; perform an assignement statement.
        (assignement_state *symb (getprop *symb '*type))
      )

    otherwise
      (if eof
        (eof_state)                     ; eof statement.
        (sys_call 0 "STAT" 66 3))       ; Unknown expression.

  )
)   ; *** End of statement routine. ***




; *************************
; *                       *
; *   Fit Data Compiler   *
; *                       *
; *************************

(progn
  (typech "'" (typech """"))             ; Set string delimitor.

  ; *** Define the Keywords ***
  (dma 'include  () '(() include  T ))   ; Include statement.
  (dma 'chaine   () '(() chaine   ()))   ; Chaine statement.
  (dma 'end      () '(() end        ))   ; end keyword.
  (dma 'variable () '(() variable   ))   ; Variable statement.
  (dma 'fixed    () '(() fixed      ))   ; Fixed statement.
  (dma 'unfixed  () '(() unfixed    ))   ; Unfixed statement.
  (dma 'lsqblock () '(() lsqblock   ))   ; Least-squares diagonal block.
  (dma 'param    () '(() param      ))   ; param    statement.
  (dma 'list     () '(() list       ))   ; list     statement.
  (dma 'data     () '(() data       ))   ; data     statement.
  (dma 'load     () '(() load       ))   ; load     statement.
  (dma 'fit      () '(() fit        ))   ; fit      statement.

  ; *** Define the separators ***
  (sys_call 20 "(" (() "("))             ; Open parenthesis.
  (sys_call 20 ")" (() ")"))             ; Close parenthesis.
  (sys_call 20 "," (() ","))             ; Comma.
  (sys_call 20 ";" (() ";"))             ; Semicolon.
  (sys_call 20 ":" (() ":")              ; Colon.
               "=" (() "="))             ; Assignement.

  ; *** Define the operators ***
  (sys_call 20 "^" ((2 7 2 () () **)))   ; x ^ y.
  (sys_call 20 "*" ((2 5 2 () ()  *))    ; x Multiply y.
               "*" ((2 7 2 () () **)))   ; x ^ y.
  (sys_call 20 "-" ((1 8 1 () () neg)    ; - x.
                    (2 4 2 () ()  -)))   ; x - y.
  (sys_call 20 "/" ((2 5 2 () 1.0 /)))   ; x / y.
  (sys_call 20 "+" ((2 4 2 () ()  +)))   ; x + y.

  (sys_call 20 "=" ((2 3 2 () T   =)))   ; x = y.
  (sys_call 20 "<" ((2 3 2 () T   <))    ; x < y.
               "=" ((2 3 2 () T  <=))    ; x <= y.
               ">" ((2 3 2 () T  <>)))   ; x <> y.
  (sys_call 20 ">" ((2 3 2 () T   >))    ; x > y.
               "=" ((2 3 2 () T  >=)))   ; x >= y.

  (sys_call 20 "&" ((2 2 2 () T and)))   ; x & y.
  (sys_call 20 "!" ((2 1 2 () T  or)))   ; x ! y.

  (dma 'div () '((2 5 2 () 1 div)))      ; x div y.
  (dma 'rem () '((2 5 2 () 1 div)))      ; x rem y.
  (dma 'and () '((2 2 2 () T and)))      ; x and y.
  (dma 'or  () '((2 1 2 () T  or)))      ; x or y.
  (dma 'not () '((1 3 1 () T null)))     ; not x.

  ; ******************************
  ; *                            *
  ; *   Fit Data Compiler Main   *
  ; *                            *
  ; ******************************

  (setq
    *nincl 0                             ; set the include count.
    eof ()                               ; Turn off the eof flag.
  )

  (chaine "fit$input")                   ; Open the Fit Source.
  (input () "FIT_V4>" "P")               ; set prompt and pascal comment mode.
  (insymbol)                             ; get the first syntax unit.
  (until (and (zerop incl) eof)          ; Until the final end of file
    (statement)                          ; perform a statement.
  )
  (exit "Fit Exit")                     ; Exit (End Of Run ).
)
