;
;   ****  Algebraical Expression Manager  ****
;



; get the macro and loop macro definition.
(include "lisp_lib.lisp_lib")

;
;

(de insymbol ()
  (setq symb_val (read)
        symb_kind sys$_readk
        symb_flag sys$_undef
  )
)

;
; Procedure to set expression classe type and value.
;
(de expr_set (l class type val)
  (rplaca l class)
  (nextl l)
  (rplaca l type)
  (nextl l)
  (rplaca val)
)
(setq expr_attr '(1 2 3))

(de expr_set_class (class)
  (rplaca expr_attr class)
)

(de expr_class (l) (car l))

(de expr_set_type (type)
  (rplaca (cdr expr_attr) type)
)

(de expr_type (l) (cadr l))

(de expr_set_value (value)
  (rplaca (cddr expr_attr) value)
)

(de expr_value (l) (caddr l))


;
; definitions table of least-squares object types.
;
(setq expr_types
  (v_create 6 '(variable param list collect diablk limits)
               'unknown))



;
; procedure to set a default value on incompatible operator error.
;
(de expr_correct (op res)
  (setq op (cddr op))
  (rplaca res (cadr op))
  (rplaca (cddr res) 'const)
)

;
; Procedure to apply an unary operator.
;
; The operator is specified as :
;   (<lisp operator> <lisp_funct_test> <modelp1> <modelres>)
;
; The parameter is specified as :
;   (<value> <model> <class>)
;
(de unary_eval (op p1)
  (if (funcall (cadr op) (cadr p1))
    (if (eq caddr p1) 'const)
      (rplaca p1 (funcall (car op) (car p1))   ; constant case => compute.
      (rplaca p1 (cons (car op) (car p1))      ; otherwise built lisp expr.
      (rplaca (caddr p1) 'expression)          ; and set expression mode.
    )                                          ; else
    (sys_call 0 "EXPR" 121 3)                  ; send src error message,
    (expr_correct op p1)                       ; and set model for default.
  )
)

;
; Procedure to apply a binary operator.
;
; The operator is specified as :
;   (<funct_testp1> <funct_testp2> <lisp_operator> <Modelres>)
;
; The parameters are specified as :
;   (<value> <model> <class>)
;
(de binary_eval (op p1 p2)
  (if (and (funcall (nextl op) (cadr p1))
           (funcall (nextl op) (cadr p2))
    (if (eq caddr p1) 'const)
      ; constant case => compute.
      (rplaca p1 (funcall (car op) (car p1) (car p2))
      ; otherwise built lisp expr.
      (rplaca p1 (cons (car op) (car p1))      
      (rplaca (caddr p1) 'expression)          ; and set expression mode.
    )                                          ; else
    (sys_call 0 "EXPR" 121 3)                  ; send src error message,
    (expr_correct op p1)                       ; and set model for default.
  )
)

;
;  Routine to get an expression element.
;
(de expr_object ()
  case symb_kind (
    ( 1 )                                ; * atom case => identifier.
        (if symb_flag
          (sys_call 0 "EXPR" 102 3)      ; ** Undeclared identifier.
          (setq expr_class  (getprop symb_val 'ident_class)
                expr_type   (getprop symb_val 'ident_type)
                expr_value  (eval symb_val)
          )
        )

    ( 4 )                                ; * integer constant.
        (setq expr_class 'const
              expr_type  'integer
              expr_value symb_val)
    ( 5 )                                ; * floatting constant.
        (setq expr_class 'const
              expr_type  'float
              expr_value symb_val)
    ( 0 6 7 )                            ; * nil or character or string.
        (setq expr_class 'const
              expr_type  'string
              expr_value symb_val)        

    otherwise
      (sys_call 0 "EXPR" 101 3)          ; illegal object.
  )
  (expr_set expr_attr expr_class expr_type expr_value)
  (insymbol)
)

;
;  Routine to handle the negate operator.
;
(de expr_negate ()
  (let ( (expr_negated ()))
    (if (eq symb_val '+)
      (insymbol)                                 ; skip + unary operator.
                                                 ; and handle negate operator.
      (when (eq symb_val '-) (setq expr_negated T) (insymbol))
    )
    (if (null (eq symb_val '*lpar*))
      (expr_object)                              ; simple object case.
      (insymbol)                                 ; gobble up the "("
      (expression)                               ; get the expression.
      (if (eq symb_val '*rpar*)                  ; if end by ")"
        (insymbol)                               ; then gobble up it,
        (sys_call 0 "EXPR" 102 2)                ; else send error message.
      )
    )
    (when expr_negated
      (if (eq (expr_class) 'const)
        (expr_set_value (neg (expr_value)))      ; for constant expr. evaluate.
        (expr_set_class 'expression)             ; turn on expression mode.
              expr_value (cons 'neg expr_value)) ; built lisp expression.
      )
      )
  ) ; let end. 
) ; end of expr_negate.


;
;  Routine to handle the power operator.
;
(de expr_power ()
  (let ((expr_first (
  )
)

;
; Expression routine.
;
(de expression ()

)

(progn
  (dmc "(" () '*lpar*)
  (dmc ")" () '*rpar*)
  (dmc "^" () '^)
  (dmc "*" () (if (null (eq (peekch) "*")) '* (readch) '^))
  (dmc "/" () '/)
  (dmc "+" () '+)
  (dmc "-" () '-)
)

