(pragma "R-")
(include "lisp_lib.lisp_lib")


(de insymbol ()
  (setq *symb (read) *kind sys$_readk *undef sys$_undef)
  (if (consp *symb)                 ; List => Operator.
    (setq *operator (cadr *symb) *symb (car *symb))
    (setq *operator ())             ; Not a list => No operator.
  )
)


(de expr_ident ()
  case *kind (
    (1)                             ; atom => identifier.
      (if *undef                    ; when undeclared ...
        (progn
          (sys_call 0 "EXPR" 601 3) ; undeclared identifier error.
          (setq *expr_value *symb
                *expr_type  (())    ; un usable type.
                *expr_attr  '*const)    
        )
        (setq   *expr_attr (getprop *symb '*class) ; get the class.
                *expr_type (getprop *symb '*type)  ; get the type.
                *expr_value (eval *symb)) ; and the value.
      )
    (4)                           ; integer.
      (setq *expr_value *symb
            *expr_type  1
            *expr_attr  '*const)    
    (5)                           ; float.
      (setq *expr_value *symb
            *expr_type  1.0
            *expr_attr  '*const)    
    (0 6 7)                       ; Nil or char or string.
      (setq *expr_value *symb
            *expr_type  "c"
            *expr_attr  '*const)    
    otherwise
     (sys_call 0 "EXPR" 600 4) ; unexpected error.
  )
  (insymbol)
)


(de exp_apply_una (oper p1)            ; Apply an operator function.
   (if (consp p1)                      ; if parameter is a list (expr.)
     (cons oper p1)                    ; create an executable Lisp list.
     (if (m_block p1)                  ; if it is a MXD object ...
       (cons oper p1)                  ; create a list also ...
       (funcall oper p1)               ; else execute it.
     )
   )
)

(de expr_gen_una lope
  (setq oper (nextl lope) npar (nextl lope))
    (if (eq expr_attr '*const)
      (setq expr_value (apply oper exp_value)
            expr_type  (value
      )
    )
  )
)



(de exp_una ()
  (let ( (neg_flg ())
         (expr ())
       )
  (while (memq *operator '(+ -))       ; when unary + or -.
    (when (eq *operator '-)            ; if negate operator then ...
      (setq neg_flg (null neg_flg))    ; switch the negate flag.
    )
    (insymbol)                         ; gobble up the unary operator.
  )
  (if (eq *symb '*lpar*)               ; "(" was seen ?
    (progn
      (setq expr (expression))         ; get the expression.
      (if (eq *symb '*rpar*)
        (insymbol)                     ; Gobble up ")"
        (sys_call 0 "EXPR" 604 2)      ; else error.
      )
    )                             
    (setq expr (exp_ident))            ; get identifier.
  )
  (if neg_flg                          ; if negate ...
    (exp_apply_una 'neg expr () ())    ; ... apply it, else ...
    expr                               ; ... return this expression.
  )
)                                      ; end of exp_una.

(progn
  (sys_call 20 "(" *lpar*)
  (sys_call 20 ")" *rpar*)
  (sys_call 20 ":" *colon*
               "=" *assign*)
  (sys_call 20 ";" *semicolon*)
  (sys_call 20 "," *comma*)

  (sys_call 20 "^" (** **))
  (sys_call 20 "*" (* *) "*" (** **))
  (sys_call 20 "/" (/ *))
  (sys_call 20 "+" (+ +))
  (sys_call 20 "-" (- -))
  (sys_call 20 "<" (< =) "=" (<= =) ">" (<> =))
  (sys_call 20 ">" (> = ) "=" (>= =))
  (sys_call 20 "\" (null null) "=" (<> =))
  (sys_call 20 "&" (and and))
  (sys_call 20 "!" (or or) "!" (concat +))

  (dma 'div () '(div *))
  (dma 'rem () '(rem *))
  (dma 'and () '(and and))
  (dma 'or  () '(or or) )


  (chaine "mxdini")             ; Open the MXD initial file.
  (input () "MXD_V4" "P")       ; set MXD prompt with Pascal comment.

  (insymbol)                    ; Read the first syntax unit.
  (until eof                    ; Until end of file ...

    (statement)                 ; execute/compile statements.

  )

)
sys$_eof ; logical end of file.


  ;     operator    npar  op    res   p1    p2.
  (setq    -      '((1    neg   1     1)
                    (1    neg   1.0   1.0)
                    (2    -     1     1     1)
                    (2    -     1.0   1.0   1.0))
           **     '((2    **    1     1     1)
                    (2    **    1.0   1.0   1.0))
           *      '((2    *     1     1     1)
                    (2    *     1.0   1.0   1.0))
           /      '((2    /     1.0   1.0   1.0))
           +      '((1    ()    1     1)
                    (1    ()    1.0   1.0)
                    (2    +     1     1     1)
                    (2    +     1.0   1.0   1.0))
           <      '((2    <     T     1     1)
                    (2    <     T     1.0   1.0)
                    (2    <     T     "c"   "c"))
           <=     '((2    <=    T     1     1)
                    (2    <=    T     1.0   1.0)
                    (2    <=    T     "c"   "c"))
           <>     '((2    <>    T     1     1)
                    (2    <>    T     1.0   1.0)
                    (2    <>    T     "c"   "c"))
           =      '((2    =     T     1     1)
                    (2    =     T     1.0   1.0)
                    (2    =     T     "c"   "c")))
           >      '((2    >     T     1     1)
                    (2    >     T     1.0   1.0)
                    (2    >     T     "c"   "c"))
           >=     '((2    >=    T     1     1)
                    (2    >=    T     1.0   1.0)
                    (2    >=    T     "c"   "c"))
           null   '((1    null  T     T))
           and    '((2    and   T     T     T))
           or     '((2    or    T     T     T))
           concat '((2   concat "c"   "c"   "c"))
)
                       

  (typech "'" (typech """"))    ; Set quote for string as MXD.


  (dma 'include () (include (read))
  )

  (dma 'chaine () (chaine (read))
  )





  (chaine)
  (input () "DPU>" "P")      ; Set the pascal comment mode.
  (pragma "L+")

  (setq eof ())              ; remove the eof mark.
  (until eof
    (insymbol)
    (print " == " *symb ", " *kind ", " *undef )
  )

)
