(pragma "R-")

(de create_cursor (x y name min max val ifi)
  (let ( (seg (sys_call 208 10))             ; create a segment.
         (pos 1)
         (vinc (round (/ (- val min)
                         (/ (- max min) 10))))
       )
    (sys_call 203 x y)                       ; draw a rectangle.
    (sys_call 204  14  0  T)
    (sys_call 204   0  4  T)
    (sys_call 204 -14  0  T)
    (sys_call 203   x  y  T)
    (sys_call 204   7  3)
    (sys_call 206 () '(3 2))                 ; set centered mode.
    (sys_call 207 () () 0 0.4 name)          ; plot the name.
    (sys_call 203 x y)
    (sys_call 204 1 2)                       ; set to axis begin.
    (sys_call 207 () () 0 0.2 (string min ifi)) ; plot the start value.
    (sys_call 203 x y)
    (sys_call 211 pos)                       ; set pick id for min ticks.
    (sys_call 204 1    1.5)
    (sys_call 204 0   -0.5 T)
    (sys_call 204 0.5  0   T)
    (sys_call 204 0    0)                    ; set pen up.
    (until (> pos 10)
      (sys_call 211 (incr pos))              ; set pick id.
      (sys_call 204 0.5 0    T)              ; step of one increment.
      (sys_call 204 0   0.25 T)              ; plot the ticks.
      (when (= vinc pos)
        (sys_call 204 0  1)                  ; plot the value.
        (sys_call 207 () () 0 0.2 (string val ifi))
        (sys_call 204 0 -1)
      )
      (sys_call 204 0  -0.25 T)
      (sys_call 204 0.5 0    T)
      (sys_call 204 0 0)                     ; set pen up.
    )
    (sys_call 211 (incr pos))
    (sys_call 204 0.5  0    T)
    (sys_call 204 0    0.25 T)
    (sys_call 204 0    0)
    (sys_call 207 () () 0 0.2 (string max ifi))
    (sys_call 206 () '(1 1))                 ; reset normal string mode.
    (sys_call 210 seg)                       ; set as detectable seg.
    seg
  )
)

(de ask_rvb (color)
  (setplist 'color (sys_call 232 color))
  (let ( (r (car   (plist 'color)))
         (v (cadr  (plist 'color)))
         (b (caddr (plist 'color))))    
  (let ( (sr (create_cursor 2  2 "red"   0.0 1.0 r 4))
         (sv (create_cursor 2  6 "green" 0.0 1.0 v 4))
         (sb (create_cursor 2 10 "blue"  0.0 1.0 b 4))
         (sflag (sys_call 208))
         (rep 1)
       )
    (sys_call 202 '(3 color 2))    ; set fill mode.
    (sys_call 216 '(0 0 1 0 1 5 0 5)) ; plot the color flag.
    (sys_call 202 '(1 1 1))
    (while (eq 1 rep)
      (while (setq rep (sys_call 226)) ; until no answerd.
        (cond
          ((= (car rep) sr)         ; red modify.
            (sys_call 209 sr)
            (setq r (* (- (cadr rep) 2) 0.1)
                 sr (create_cursor 2  2 "red"   0.0 1.0 r 4)))
          ((= (car rep) sv)         ; green modify.
            (sys_call 209 sv)
            (setq v (* (- (cadr rep) 2) 0.1)
                 sv (create_cursor 2  6 "green" 0.0 1.0 v 4)))
          ((= (car rep) sb)         ; blue modify.
            (sys_call 209 sb)
            (setq b (* (- (cadr rep) 2) 0.1)
                 sb (create_cursor 2 10 "blue"  0.0 1.0 b 4)))
          (T ())
        )
        (sys_call 231 color r v b)  ; set the new color.
      )
      (setq rep (sys_call 221 "finished?"))
    )
    (sys_call 209 sr)
    (sys_call 209 sv)
    (sys_call 209 sb)
    (sys_call 209 sflag)
  ))
)



(de menu_action (menu_titre menu_list action_list)
  (let (  ; Local object choix.
         (choix (sys_call 220 menu_titre menu_list))
       )
    (if (numberp choix)
      (eval (nth (1- choix) action_list))
      ()
    )
  )
)


(sys_call 201 24 18 "essai")
(sys_call 238)
(ask_rvb 0)
(ask_rvb 1)
(ask_rvb 2)
(ask_rvb 3)

(setq
  actlist '(
    (exit "au revoir")
    (print (sys_call 222))
    (print (sys_call 224 "input a string" "default string"))
    (print (sys_call 225 "value" 0 9 5))
    (while (menu_action "choix bis" submenu subaction))
  )
  submenu '(
    "quit" "dialogue" "answerd" "line" "plot" "string"
  )
  subaction '(
    ; *** quit ***
    ()
    ; *** dialogue ***
    (progn
      (sys_call 240)
      T
    )
    ; *** answerd ***
    (progn
      (if (eq (sys_call 221 "satisfait?") 2)
        (sys_call 230 " merci")
        (sys_call 230 " tant pis!")
      )
      T
    )
    ; *** line input ***
    (let ( (list_point (sys_call 227))
         )
      (sys_call 216 list_point)
    )
    ; *** plot input ***
    (let ( (continue ())
           (lexec '(sys_call 203 0.0 0.0 ()))  ; plot x y pen.
           (lcoord ())
           (lpen ())
         )
      (setq lcoord (cddr lexec)
            lpen   (cddr lcoord))
      (while (sys_call 222 (car lcoord) (cadr lcoord) lcoord) ; get x and y.
        (eval lexec)           ; go to the wanted point.
        (rplaca lpen T)        ; set pen down for next point.
      )
      (rplaca lpen ())
      (eval lexec)             ; set pen up on the last point.
      T
    )
    ; *** string input ***
    (let ( (lexec '(sys_call 207 0.0 0.0 0.0 1.0 ""))
           (lcur ())
         )
       (setq lcur (cddr lexec))
       (when (sys_call 222 0 0 lcur)    ; string coordinates.
         (setq lcur (cddr lcur))
         (rplaca lcur (or (sys_call 225 "Angle" 0 360 0) 0)) ; angle.
         (nextl lcur)     
         (rplaca lcur (or (sys_call 225 "High" 0.1 5.1 1.0) 1.0)) ; character size.
         (nextl lcur)     
         (rplaca lcur (sys_call 224 "string to plot"))
         (when (car lcur)
            (eval lexec)
         )
       )
       T
    )
  )
)

(while T ; Infinite loop.
  (print "res = "
    (menu_action "essai menu"
                 '("quit" "position" "e string" "e value" "menu")
                 actlist)
  )
)
