(PRAGMA "R-")
(INCLUDE "lisplib:lisp_lib.lisp_lib")
(INCLUDE "read_diagr.lisp_part")


(SETQ graphic_enable (SYS_CALL 101 "G_DATA$DRAW" ))

(IF graphic_enable                   ; when the graphic is enabled.
  (PROGN
    (SETQ                            ; init draw sub-system.
          graphic_scale (SYS_CALL 201 25 18 "G_DATA DRAW" T)
    )
    (SYS_CALL 238)                   ; set the time of fly mode.
  )
  (OPEN 'f_stdin  |I| "SYS$INPUT")   ; open the user input file.
  (OPEN 'f_stdout |N| "SYS$OUTPUT")  ; open the user output file.
)


(SETQ diagramm (load_data_in_list))

(IF graphic_enable
  (PROGN
    (SETQ curve_spc  '( 8 12 () 1 () 16)
          minimaxi    (SYS_CALL 250 diagramm  curve_spc)
    )
    (SYS_CALL 251 minimaxi 20 15 2 2 "Theta degres." "Coups" T)

    ; dessin de la courbe.
    (SETQ curve_seg -1               ; no segment allocated.
          sigma_seg -1
          curve_seg (SYS_CALL 254  curve_seg diagramm curve_spc)
    )
    (IF (EQ 1 (SYS_CALL 221 "Barres d'erreur ?"))
      ; dessin des barres d'erreur.
      (SYS_CALL 258  sigma_seg diagramm curve_spc)
      ()
    )
    (PRINT (SYS_CALL 270))
    (SYS_CALL 240) ; call dialog DRAW routine.
  )
  ;  cas sans graphic.
)

(exit "G_DATA")
