;
; *** Essai de LAG_TO_LISP ***
;

(DMA 'atm () (EVAL (READ)))
(SETQ numbertyp '(*int *float))

(SETQ  lpar      (IMPLODECH |(|)
       rpar      (IMPLODECH |)|)
       semicolon (IMPLODECH |;|)
       period    (IMPLODECH |.|)
)

(DF test_log2 (f p1 p2)
  (WHEN (AND (MEMQ p1 numbertyp) (MEMQ p2 numbertyp)) '*int)
)


(SETQ wint    '(*string *int)
      wnumber '(*string *int *float)
)

(SETQ add_gene '( ( ((wint))              ()  *int)
                  ( ((wnumber))           ()  *float)
                  ( ((wint)    (wint))    +   *int)
                  ( ((wnumber) (wnumber)) +   *float)
                )
      sub_gene '( ( ((*int))              NEG *int)
                  ( ((wnumber))           NEG *float)
                  ( ((*int)    (*int))    -   *int)
                  ( ((wnumber) (wnumber)) -   *float)
                )
      mul_gene '( ( ((*int)    (*int))    *   *int)
                  ( ((wnumber) (wnumber)) *   *float)
                )
      pow_gene '( ( ((*int)    (*int))    **  *int)
                  ( ((wnumber) (wnumber)) **  *float)
                )
)

(ALG_INIT '( |(|    (0 |(| )       |)|   (0 |)| )
             |,|    (0 |,| )       |;|   (0 |;| ) ; define separators.

             |.|    (0 |.| 1 (field_access_mac 1))    ; field access separator.

             or     (2 1 () OR  (test_log2 0 1 2))
             and    (2 2 () AND (test_log2 0 1 2))

             =      (2 3 () =)     <>    (2 3 () <>)
             >      (2 3 () >)     <     (2 3 () <)
             >=     (2 3 () >=)    <=    (2 3 () <=)

             +      (3 (7 T atm add_gene)     4 () atm add_gene)
             -      (3 (7 T atm sub_gene)     4 () atm sub_gene)

             *      (2 5 () atm mul_gene)
             /      (2 5 () /   () *float)
             div    (2 5 () DIV () *int)
             rem    (2 5 () REM () *int)

             **     (2 6 T  atm pow_gene)
             not    (1 7 T  NULL *int)

             SIN    (4 1 SIN   () *float) COS    (4 1 COS    () *float) TAN   (4 1 TAN   () *float)
             SIND   (4 1 SIND  () *float) COSD   (4 1 COSD   () *float) TAND  (4 1 TAND  () *float)
             ASIN   (4 1 ASIN  () *float) ACOS   (4 1 ACOS   () *float) ATAN  (4 1 ATAN  () *float)
             ASIND  (4 1 ASIND () *float) ACOSD  (4 1 ACOSD  () *float) ATAND (4 1 ATAND () *float)
             PHASE  (4 2 PHASE () *float) PHASED (4 2 PHASED () *float)
             EXP    (4 1 EXP   () *float) LN     (4 1 LN     () *float) TANH  (4 1 TANH  () *float)
           )

        '( 6 *int 7 *float 8 *string 9 *string )

)



(DE ALG ()
  (SETQ  savlpar (TYPECH |(| (LIST lpar))
         savrpar (TYPECH |)| (LIST rpar))
         nexp 0
  )
  (DMC |;| atm semicolon)
  (PRINT (TYPECH |(|))
  (PRINT (TYPECH |)|))
  (PRINT (TYPECH |;|))
  (DMC |,| ,)
  (DMC |+| +)
  (DMC |-| -)
  (DMC |*| (** |*| *))
  (DMC |^| **)
  (DMC |/| /)
  (DMC |=| =)
  (DMC |<| (<= |=| <> |>| <))
  (DMC |>| (>= |=| >))

  (SETQ pi (* 4 (ATAN 1)))

  (PUTPROP 'lisp_coef () '(5 1 (LIST 1 )))
  (PUTPROP 'v1        () '(5))
  (PUTPROP 'v2        () '(5))
  (PUTPROP 'v3        () '(5))

  ; allocate a lex to the point record.
  (PUTPROP 'point     ;             () '(5)
                      '*lex  (SYS_CALL 11 'point))

  (PUTPROP (IMPLODECH "XP") '*off '(00 . M_FL)
                            '*type '*float
                            ()    '(5 1 (field_acc_with_mac 1))
  )
  (PUTPROP (IMPLODECH "YP") '*off '(04 . M_FL)
                            '*type '*float
                            ()    '(5 1 (field_acc_with_mac 1))   
  )
  (PUTPROP (IMPLODECH "SP") '*off '(08 . M_FL)
                            '*type '*float
                            ()    '(5 1 (field_acc_with_mac 1))
  )
  (PUTPROP (IMPLODECH "IS") '*off '(12 . M_SB)
                            '*type '*int
                            ()    '(5 1 (field_acc_with_mac 1))
  )
  (SYS_CALL 13) ; disable the point lex.


  (DF field_access_mac (r)
    (LET ( (f (SYS_CALL 15 T (GETPROP r '*lex)))  ; Get the record field identifier.
         )
      (IF SYS$_UNDEF (SYS_CALL 1 "FLDA" 888 2)
        (SETQ SYS$_ALG_KIND 2                     ; Field variable ref.
              SYS$_ALG_TYPE (GETPROP f '*type)
        )
        (CONS r (GETPROP f '*off))                ; generate the reference statement.
      )
    )
  )

  (DF field_acc_with_mac (f)
    (CONS (???) (GETPROP f '*off))                ; Get the related record ref to build the field ref.
  )





  (SETQ point (M_ALLOCB 13))
  (SET (IMPLODECH "xp")  0)
  (SET (IMPLODECH "yp") -1)

  (SETQ *cnt_stk (LIST () ) )


  (SETQ GEN_DIRREF '(5)                   ; for direct reference.
        GEN_ACCESS '(5 1 (GEN_ACCESS 1 )) ; for LISP reference.
  )

  (DF GEN_ACCESS (V) (CONS V ()))         ; LSQ Lisp reference.

  (DF FIELD_ACCESS (record field)         ; LSQ record reference.
    (CONS record (EVAL field))
  )

  (PUTPROP 'COEF GEN_ACCESS)              ; COEF => (COEF).


  (SETQ HH '(04 . M_SW)                   ; Declaration of record.
        KK '(06 . M_SW)
        LL '(08 . M_SW)
        MU '(10 . M_SW)
        F2 '(12)
        FIELD_ACCESS '(5 2 (FIELD_ACCESS data_list T ))
                                          ; Define its access function.
  )
  (PUTPROP 'HH () FIELD_ACCESS)
  (PUTPROP 'KK () FIELD_ACCESS)
  (PUTPROP 'LL () FIELD_ACCESS)
  (PUTPROP 'MU () FIELD_ACCESS)
  (PUTPROP 'F2 () FIELD_ACCESS)

  (CHAINE)
  (INPUT () "ALG> " |P| )
  (ALG_INPUT T '*symb)
  (UNTIL (EOF)
    (PRINT " Expression # " (INCR nexp))
;   (SETQ expr (GET_EXPR))
;   (PRINT (ALG_TO_LISP expr K))
;   (PRINT "Result_kind = " K)
;   (PRINT " Expression # " (INCR nexp))
;    (SETQ *symb ())
;    (PRINT (ALG_TO_LISP *symb))
    (PRINT (ALG_TO_LISP))
    (PRINT "Terminator = "  *symb ", Result_kind = " SYS$_ALG_KIND )
    (PRINT "Result_type = " SYS$_ALG_TYPE " .")
  )
  (TYPECH |(| savlpar)
  (TYPECH |)| savrpar)
  (INPUT () "LISP>" |L|)
)


(DE GET_EXPR ()
  (LET ( (exp (LIST ()))
         (elem ())
       )

    (UNTIL (OR (EQ elem semicolon) (EOF))
      (SETQ elem (READ))
      (WHEN (NEQ sep semicolon) (QUEUE_PUT exp elem))
    )
    (STACK_GET exp)
    exp
  )
)

(PRAGMA "C+" "T+")
(ALG)

