(pragma "l-" "r-")
(include "filtre.lisp")

; base de donnees pour ELIZA.
(setq el_data '(
  ( (au revoir)        " bientt." )
  ( ( non )            '("vous tes bien ngatif") )
  ( (&- lisp &-)       '("Comment, vous connaissez ce language!") )
  ( (&- ans &-)        '("remontez plus loin dans vos souvenirs") )
  ( (&- annees &-)     '("cela fait bien longtemps") )
  ( ($-)               '("c'est un peu court") )
  ( (&- je ne suis pas &l) 
               [ "qu'est-ce qui vous fait pensez que vous n'tes pas " l ] )
  ( (&- je ne &-)      '("vous tes sr ?") )
  ( (&- non &-)        '("vous tes bien ngatif") )
  ( (&- suis &l)       [ "pourquoi pensez vous que vous tes " l ] )
  ( (&- vous &-) 
               '("concentrez vous sur votre problme, s'il vous plat") )
  ( (&- moi &-)        '("dites m'en plus sur votre famille") )
  ( (&- je &-)         '("comment cela se manifeste-t-il ?") )
  ( (j quote ai $xx)   [ "il ne faut pas trop avoir " xx ] )
  ( (j quote ai $xx &yy)
                       [ "il est dangereux d'avoir " xx " " yy ] )
  ( (&- j quote ai &-)
                       '("depuis combien de temps ?") )
  ( (&- combien &-)    '("ce n'est point la quantit qui compte") )
  ( ($- $- $-)         '("Hummm") )
  ( (&-)               '("je ne vous suis pas trs bien") )
))

(de ECRIT (L)
   (if (consp L) (mapcar L 'ECRIT) (prin " " L)))

(dmc !.! () !.!)
; procedure de lecture.
(de READ_LIST ()
  (let ((OBJ (read)))
    (if (consp OBJ) OBJ (cons OBJ ()))
  )
)

(de LIT ()
  (let ((REP (READ_LIST)))
       (until (or (eq 1 (ch_order (peekch)))
                  (eq 0 (ch_order (peekch)))) ; until eol or eof ...
              (nconc REP (READ_LIST)))
       (if (eq 0 (ch_order (peekch))) (exit "Oh! Alors adieux."))
       REP
  )
)

; le programme.
(de ELIZA ()
  (open 'inp "I" "SYS$INPUT")  ; open the term file as VMS SYS$INPUT.
  (input 'inp "eliza> ")  ; select terminal input with no prompt.
  (output () 79 0)  ; line width set at 79 char. and no page managment.

  (print "bonjour, quel est votre problme ?")
  (while (nequal '(au revoir) (setq USR (LIT)))
         (setq REGLE EL_DATA)
         (until (setq SELECTION (MATCH (car (setq R (nextl REGLE))) USR)) ())
         (setq RES (REFLECHIT (cadr SELECTION) (cadr R)))
         (prin " -> ") (ECRIT RES) (print)
  )
  (print " Au revoir,  bientt.")
  (close 'inp)
)

(de REFLECHIT (ENV MODELE)
	(eval `(LETALL ENV ,MODELE)))

(eliza)   ; start the program.
