(pragma "r-" "l-")
(include "EXP_LISP.LISP_LIB")

;
;  *** Verification procedure for module LISP$_LSQ ***
;

(setq var_info '(1 2 3 4 5 6)   ; List of variable info : name, old value,
                                ; old sigma (unused), Matrix index,
                                ; Related diagonal block and limits block.
      lim_info '(1 2)           ; Limit info inf and sup.
      par_info '(1 2 3)         ; List of parameter info : name, value
                                ; and sigma.
      blk_info '(1 2 3 4 5 6 7) ; List of diagonal block info :
                                ; name, effectives marqward and dampening fac.,
                                ; x and b vector, and matrix,
                                ; first variable.
      lis_info '(1 2 3 4)       ; List of list info :
                                ; name, Current, first element,
                                ; and first parameter.
      col_info '(1 2 3)         ; List of collect info :
                                ; Related list, Reject factor and statistic
                                ; block.
      sta_info '(1 2 3 4 5 6 7  ; statistic info : obs_count
                 8 9 10 11 12 ) ; user and standard chi2,
                                ; sum ( sqr(delta/sigma) ),
                                ; sum ( sqr(delta*weight)),
                                ; sum ( sqr(delta)),
                                ; sum ( abs(delta*weight)),
                                ; sum ( abs(delta)),
                                ; sum ( sqr(obser*weight)),
                                ; sum ( sqr(obser)),
                                ; sum ( abs(obser*weight)),
                                ; sum ( abs(obser)).

)


; *** Change variable procedure ***
(de change_varbl (varbl newval sig shift lim_flg beg_flg end_flg)
  (setq vinfo (sys_call 372 varbl var_info))
  (when beg_flg                       ; for the begin of a diagonal block.
    (setq binfo (sys_call 372 (caddr (cddr var_info)) blk_info))
    (print)
    (print " Diagonal block """ (nextl binfo) """ with Mlc = " (nextl binfo)
           " and Dmp = " (car binfo)
    )

  )
  (prin (nextl vinfo) " = "
        newval ":"
        sig
  )
  (unless end_flg
        (prin ", " (car vinfo)
              ", " shift
          (cond
            ((eq lim_flg 1)  "  *LR*")
            ((eq lim_flg -1) " *MOD*")
            (T               "      ")
          )
 	       ))
  (print)
)

; ***  Singularity Notification Procedure ***
(de signal_sing (varbl nfail ovf_flg)
  (print)
  (prin " *** Singularity on the Variable """
        (car (sys_call 372 varbl var_info)) """")
  (print " => Variable is locked. ")
  (when ovf_flg (sys_call 1 "SING" 14 4))
)

; *** user procedure de/df call entry ***
(de usr_p_call (idx parm)
  ()
)



; *** user function de/df call entry ***
(de usr_f_call (idx parm) (print idx))

; *** user function to cycle begin notification ***
(de usr_beg_cycl (c_nb c_end)
  (print) (print)
  (if c_end
    (progn
      (print "  *** Least-Squares Final Cycle ***")
      (print "  ---------------------------------"))
    (prin  "  *** Least-Squares Cycle #" )
    (o_fixed (4) c_nb) (print " .")
    (print "  -------------------------------"))
  (print)
)

; *** user function to cycle solve notification ***
(de usr_res_cycl (c_nb)
  (print) 
  (usr_end_coll () )
  (print)
  (print)
  (print "     Result of the Least-Squares Cycle #" c_nb " .")
  (print)
)

; *** user function to cycle end notification ***
(de usr_end_cycl (c_nb)
  (print)
  (print "***********************************************************")
  (print)
)

; *** user function to data collection begin notification ***
(de usr_beg_coll (coll)
  (setq curr (sys_call 372 (car (sys_call 372 coll col_info)) lis_info))
  (print)
  (print "    Data Collection """ (car curr) """ ." )
  (print)
  (print)
  (print "   #     X       Y-OBS      YTH      DELTA     SIGMA    WEIGHT    DEL/SIG")
  (print)
)

; *** user function to data collection end notification ***
(de usr_end_coll (coll)
  (setq curr (sys_call 373 coll sta_info))
  (print)
  (if coll
    (progn
      (print "     The particular statistic :" )
    )
    (print "     The   Global  statistic  :" ))
  (print "     --------------------------" )
  (print)
  (prin "     Number of used observation         = ")
  (o_fixed (6) (nextl curr)) (print)
  (prin "     User goodness of fit (Chi squared) = ")
  (o_fixed (6 4 1) (nextl curr)) (print)
  (prin "     Standard goodness of fit           = ")
  (o_fixed (6 4 1) (nextl curr)) (print)
  (print)
)

; *** user packet computing function ***
(de usr_pack_cmp (coll nobs obs calc delta sigma weight delssig regflg)
  (o_fixed (4) nobs)
  (o_fixed (10 4 2)  (cadr (sys_call 372 $X par_info))
                     obs calc delta sigma weight delssig)
  (when regflg (prin " *R*"))
  (print)
)

; *** user list element computing function ***
(de usr_listelem_cmp (lis) ()
)



;
;***********************************************
;*                                             *
;*      Define the user language Compiler      *
;*                                             *
;***********************************************
;

(de compile (opl_list)
  (let ( (incllvl 0)     ; Initialize include nest level.
       )
  )
  ; Until the end of file on the same include level compile.
  (until incllvl
    (insymbol)           ; read a syntaxe unit.
    case *kind (         ; case on the nature of object.
      (0)                ; *** List => Reserved keyword or error ***
        (if (eq (nextl *symb) T)
          (apply *symb opt_list) ; compile this statement.
          (sys_call 0 "STAT" 41 3)       ; else error.
          (skip_to_separator ";")        ; end look for statement terminator.
        )

      (1)                ; *** Atom => Variable/parameter ***
        (progn
          (when *undef
            (sys_call 0 "STAT" 51 3))   ; Undeclared identifier.
          (if (m_block (eval *symb))    ; if/ it is a not lisp object
            (assign_v_state *symb)      ; proceed a special assign
            (set *symb (cte_expression (getprop *symb '*type))) ; set new value.
          )
        )

      (2)                ; *** User Macro function ***
        (
        )

      (otherwise)        ; Eof or error.
        (if eof
          (eof_state)
          (sys_call 0 "STAT" 44 3)
          (skip_to_separator ";")        ; end look for statement terminator.
        )
    )
  )
)



;**********************************
;*                                *
;*      Main  program  Body       *
;*                                *
;**********************************

(progn
  (enable_expression)        ; define all user expression syntax.

  ;
  ;****************************************************
  ;*                                                  *
  ;*       Initialize the Least-Squares Loader.       *
  ;*                                                  *
  ;****************************************************
  ;

  (sys_call 301
    ; assign the change variable notification entry.
    '(change_varbl varbl newval sig shgift lim_flg beg_flg end_flg)
    '(signal_sing varbl nfail ovf_flg)      ; assign the signal singularity entry.
    '(usr_f_call idx parm)          ; assign the user call function entry.
    '(usr_p_call idx parm)          ; assign the user call procedure entry.
    '(usr_beg_cycl c_nb c_end)
    '(usr_res_cycl c_nb)
    '(usr_end_cycl c_nb)
    '(usr_beg_coll coll)
    '(usr_end_coll coll)
    '(usr_pack_cmp coll nobs obs calc delta sigma weight delssig regflg)
    ()
  )

  ;
  ;************************************************************
  ;*                                                          *
  ;*    Build the Minimum Least-Squares Control Structure.    *
  ;*                                                          *
  ;************************************************************
  ;

  (sys_call 314
           '*BLK_MAIN*  ; Create the Least-Squares matrix Block ".BLK_MAIN.".
           1.0          ; Dampening factor expression.
           1.0          ; Marqward factor expression.
  )

  ;
  ; ".BLK_MAIN." is now open to get the next following variable.
  ;

  (open 'fctl "I" "sys$input")

  (input 'fctl "Fit_Curve> " "A")

  (setq var_list () var_curr () par_list () par_curr ())

  (setq cycle_nb 1)

  (until eof (read))    ; read all param and varbl statement.
  (close 'fctl)

  (eval var_list)       ; create all user defined variables.


  (unless weight_expr (setq weight_expr '(/ 1.0 $SG) )


  ; Now we define the list of data.


  (setq data_dir_list
   '(
       (312 '$X  '(DATA_LIST M_FL  4))  ; Define the current x parameter.
       (312 '$Y  '(DATA_LIST M_FL  8))  ; Define the current y parameter.
       (312 '$SG '(DATA_LIST M_FL 12))  ; Define the current sigma parameter.
    )
        data_dir_end_part
   '(
       (310 $YTH)       ; push the YTH value to
       (325 DATA_LIST M_FL 20)      ; Store it at 20 offset of current el.
  
       (310 0)          ; Push stop scan end condition.
       (310 1)          ; Push Eligibility condition expression.
    )
  )

  (print "data dir list == " data_dir_list)
  (print "parameter == " par_list)
  (print "end == " data_dir_end_part)

  (nconc data_dir_list par_list data_dir_end_part)

  (print "final data list == "  data_dir_list)

  (sys_call 315 'DATA_LIST      ; Create the data list named "DATA_LIST".
                 data_dir_list  ; data directive list.
                 0              ; without cache.
  ) 


  ; Now we define the data collection to fit.

  (sys_call 316 DATA_LIST       ; the Data collection use the DATA_LIST
                                ; list to scan the experimental data.
    '(                          ; Begin of packet directives.

                                ; End of directive sequence.
      (310 weight_expr )        ; Weight to use,
      (310 '$SG)                ; Related Y sigma,
      (310 '$Y)                 ; Value to use as experimental Y,
      (310 '$YTH)               ; Parameter to use as computed value,
      (310 1)                   ; Push sentinel.
    )
    ()                          ; No cycle directive list.
    1E10                        ; Rejection to use.
  )


  ;
  ;****************************************************
  ;*                                                  *
  ;*    Define the fit related basic directives       *
  ;*                                                  *
  ;****************************************************
  ;

  (setq G_STATIS (sys_call 319
    '(                          ; Define By cycle directive.
       (326 1 '(null T))
     )
    '(                          ; Define Final directive.
       (312 'AMULB '(* coef_a coef_b) () T T)
     )
  ))

  ;
  ;****************************************************
  ;*                                                  *
  ;*    Initialize the Least-Squares processor.       *
  ;*      And create the running structures.          *
  ;*                                                  *
  ;****************************************************
  ;

  (sys_call 302
                   1    ; First cycle #.
                   1    ; Maximum number of tolerate singularities.
                  ()    ; Minimal value for a pivot (defaulted).
                  ()    ; Normal matrix computing (T => computed at first cycle only).
                  ()    ; Final cycle required (T => suppressed).
                   T    ; Correlation matrix required after final cycle.
  )

  ;
  ;****************************************************
  ;*                                                  *
  ;*    Read the Least-Squares Experimental Data.     *
  ;*                                                  *
  ;****************************************************
  ;

  (setq curve_liste () curr_pt ())
  (print " Open_result = " (open 'f "i" "curve"))
  (input 'f "entree un point s.v.p. ")
  (setq xx (read))               ; read the first x.
  (until EOF
    (setq yy (read) sgsg (read))        ; read obs. y and sigma.
    (zapline)                           ; ignore all trailing data.
    (setq cblk (m_allocb 24))           ; allocate the memory block.
    (m_put (m_offset cblk  4) m_fl xx)  ; set the x value.
    (m_put (m_offset cblk  8) m_fl yy)  ; set the y value.
    (m_put (m_offset cblk 12) m_fl sgsg); set the sg value.
    (if (null curve_liste)              ; if it is the first curve point.
      (setq curve_liste (cons cblk ())  ; then set first curve element.
            curr_pt     curve_liste)    ; else
      (rplacd curr_pt (cons cblk ()))   ;   append the new point
      (nextl curr_pt)                   ;   and set it as last point.
    )
    (setq xx (read))
    )                           ; end of until.

    (close 'f)

;  (print curve_liste)



    (eval (list 'sys_call '331 'DATA_LIST 'curve_liste ) )

  ;
  ;****************************************************
  ;*                                                  *
  ;*    Run the Least-Squares Processor for 2 Cycles. *
  ;*                                                  *
  ;****************************************************
  ;
    (until (zerop cycle_nb)
      (sys_call 303 cycle_nb)
      (setq cycle_nb 0)
    )  ; Until end.

  ;
  ;****************************************************
  ;*                                                  *
  ;*    Free the Least-Squares running Structures.    *
  ;*                                                  *
  ;****************************************************
  ;

    (sys_call 304)              ; Free the derivate LSQ structures.

    (when graphic_enable        ; when the graphic mode is enable.
      (sys_call 200)            ; Close the graphic mode.
    )
  )  

  (exit " *** Normal Fit End *** " )   ; Normal Fit End.
) ; * * * * *   End of progn  * * * * *
