(pragma "R-")

(INCLUDE "lispsrc:lisp_lib.lisp_lib")

(DE insymbol ()
  (SETQ *symb (read)
        *undef sys$_undef
        *kind  sys$_readk
        *class ()
  )
  (IF (ZEROP *kind) ; For the list...
    CASE (NEXTL *symb) (
        (0)         ; separator.
           (SETQ *kind 23)
        (1)         ; operator.
           (SETQ *kind 24 *class (nextl *symb))
        (2)         ; function activation keyword.
           (SETQ *kind 20)
        (3)         ; declaration activation keyword.
           (SETQ *kind 21)
        (4)         ; separator keyword.
           (SETQ *kind 22)
      otherwise
        ()
    )
  )
  *symb ; for debug.
)

(DF test_terminator (at flg)
  (IF (AND (EQ *kind 22) (EQ at *symb))
    (PROGN
      (WHEN flg (insymbol))
      T
    )
    ()
  )
)

(DF test_operator (op flg)
  (IF (AND (EQ *kind 24) (EQ op *symb))
    (PROGN
      (WHEN flg (insymbol))
      op
    )
    ()
  )
)

(DF look_separ (ch flg)
  (IF (AND (EQ *kind 23) (EQ ch *symb))
    (WHEN flg (insymbol))
    (SYS_CALL 0 "SEPA" -99 3)
  )
)

(DF test_separ (sep)
  (AND (EQ *kind 23) (EQ *symb sep))
)

(DF skip_separ (sep)
  (IF (AND (EQ *kind 23) (EQ *symb sep))
    (PROGN (insymbol) T)
    ()
  )
)

(DF skip_to_separ (sep)
  (UNTIL (OR EOF (AND (EQ *kind 23)
                      (OR (EQ *symb sep)
                          (EQ *symb |;|))))
    (insymbol)
  )
)



;
; compatible access test function.
;
; Result : The appropriate model type if ok,
;          () otherwise.
;
(DE access_match (type model)

)


;
; compatible type test function.
;
; Result : The appropriate model type if ok,
;          () otherwise.
;
(DE type_match (type model)
  (IF (EQ type model)
    model
    (WHEN (CONSP (SETQ model (EVAL model)))
      (IF (EQ model '(()))
        type
        (CAR (MEMQ type model))
      )
    )
  )
)


;
; Generic search function.
;
; generic_list is a list of entry,
; np              the number of effective parameter
; lparm           the list of effective parameters.
;
; The entry format is :
;   (<nf> 
;    <class_1>  <typ_1>  <val1>
;    <class_2>  <typ_2>  <val_2>
;      ...
;    <class_bf> <typ_nf> <val_nf>
;    <Result_type> <lisp_fnc_to_use>)
;
;   where nf is the number of formal parameters
;
(DE generic_search (generic_list lparm np)
  (LET ( (fnd ())
         (nc   0)
         (nf   0)
         (lpar ())
         (cpar ())
         (fpar ())
         (fcla ())
         (cform ())
         (entry ())
       )
    ; skip the queue head of the generic list.
    (SETQ generic_list (CDR generic_list))

    ; loop on all function in the generic definition.
    (UNTIL (OR fnd (NULL generic_list))
      (SETQ entry (NEXTL generic_list)
            nf    (NEXTL entry)
      )
      ; when an enough large number of formal exist ...
      (WHEN (>= nf np)
        (SETQ fnd   T
              nc    nf
              lpar  lparm
              cform entry
        )
        ; continue the check for this procedure/function.
        ; loop on all parameters :      effective    formal .
        (WHILE (AND (> nc 0) fnd)
          (SETQ cpar (IF lpar (NEXTL lpar) '(*empty () () () ) )
                fpar (NEXTL cform)
                fnd  (AND (MEMQ (NEXTL cpar) (EVAL (NEXTL fpar))); class check.
                          (MEMQ (NEXTL cpar) (EVAL (NEXTL fpar))); access check.
                          (type_match (CAR cpar) (CADR fpar))    ; type check.
                     )
          )
          (DECR nc)
        )
      )
    )
    (IF fnd
      (PROGN
        (SETQ fnd   ()                      ; assume cte. expr.
              cform (LIST () )              ; configure cform as a queue.
              nc 0
        )
        ; build the call Lisp list.
        (WHILE lparm
          (SETQ lpar  (STACK_GET lparm)     ; get an effective parm ...
                cpar  (CAR lpar)            ; and it's class.
                fcla  (CAAR entry)          ; get the formal class.
                fpar  (CADDR (NEXTL entry)) ; get the default value.
          )

          ; set flg when not cte. parameter is found.
          (WHEN (AND cpar (AND (NEQ cpar '*const))
                               (OR (NEQ fcla '*out) 
                          )
            (SETQ fnd T)
          )
          (QUEUE_PUT cform (IF cpar
                             (CADDR lpar)
                             fpar
                           )
          )
          (INCR nc)
        )
        ; add the implicite default trailing parameter.s
        (WHILE (< nc nf)
          (QUEUE_PUT cform (CADDR (NEXTL entry)))
          (INCR nc)
        )
        ; set the function to call.
        (RPLACA cform (CADR entry))
        (IF (AND fnd (GETPROP (CADR entry) '*NKHANDLER))
          (SETQ lpar (LIST '*expr  (CAR entry) cform))
          (SETQ lpar (LIST '*const (CAR entry) (EVAL cform)))
          (LIST_DEL cform)
        )
        lpar
      )
      ; can not found generic entry.
      (SYS_CALL 0 "GENS" 84 3)   ; illegal generic function/procedure use.
      (LIST '*const '*r '*wild ())  ; give the nil result on not found generic.
    )
  )
)


;
; Procedure to put proceed a reference or an operator.
;
; It use the operational stack opstk.
;
(DE expr_gencall (np generic)
  (LET
    ( (parm   ()) )    ; initialize each local

    ; ***  Copy the effective parameters to the temporary list ***
    (LISTE_EXCH opstk parm np)

    ; ***  locate the appropriate function and generate the call ***
    (generic_search (EVAL generic) ; - generic list -
                    parm           ; - effective parameter list -
                    np  )          ; - number of eff. parms -
  )
) ; *** End of EXPR_GENCALL function ***


;
; Generate the reference of objects and function call.
;
(DE expr_ident ()
  (STACK_PUT opstk
    CASE *kind (
      (1) ; *** Atom => Variable or Parameter ***
        (LET ( (class (GETPROP *symb '*class))
               (acc   (GETPROP *symb '*access))
               (type  (GETPROP *symb '*type))
             )
          (IF (NULL *undef)
            ; if it is a lisp object ...
            (LIST class acc type *symb)
            (SYS_CALL 0 "EXPR" -51 3))   ; Undeclared identifier.
            (LIST '*empty () () ())
          )
        )

      (2 3) ; *** User or Standard Function ***
        (LET ( (np     0)
               (symbv  *symb)
             )
          (insymbol)                     ; Gobble up the function name.
          (WHEN (test_separ |(|)
            (SETQ *symb |,|)             ; simulate a previous comma.
            (WHILE (test_separ |,|)
              (insymbol)                 ; Gobble up the separator.
              (expr_expression)          ; push each parameter in opstk.
              (INCR np)
            )
            (UNLESS (test_separ |)|)
              (SYS_CALL 0 "EXPR" -81 2)  ; else error << |)| expected. >>.
            )
          )
          (expr_gencall np symbv)
        )

      (4  ; *** Nil (false) value ***
       5) ; *** True value ***
        (LIST '*const '*r '*boolean *symb)

      (6) ; *** Integer cte ***
        (LIST '*const '*r '*integer *symb)

      (7) ; *** Float cte ***
        (LIST '*const '*r '*float   *symb)

      (8  ; *** Character ***
       9) ; *** String ***
        (LIST '*const '*r '*string  *symb)

      otherwise
        (LIST '*empty () () ())
    ) ; /end case/
  )   ; /end stack_put/
  (insymbol)
  (CADR opstk) ; for debug.
)


;
; Generate a single expression element reference with
; unary sign "+" or "-" management.
;
(DE expr_term (lvl)
  (IF (test_separ |(|)           ; for open parenthesis ...
    (PROGN
      (insymbol)                 ; gobble up the open parenthesys.
      (expr_expression)          ; Get a the sub-expression.
      (IF (test_separ |)|)       ; if close parenthesis ...
        (insymbol)               ; gobble up it, else ...
        (SYS_CALL 0 "EXPR" -81 2) ; ")" was expected error.
      )
    )
    (expr_ident)                 ; handle a single reference.
  )
)


;
; Generate the prefix unary boolean operators.
;
(DE expr_bool (lvl)
  (LET ( (fla    ())
         (oper   (NEXTL lvl))
         (noop   (NEXTL lvl))
         (upf    (NEXTL lvl))
       )
    (WHILE (OR (EQ *symb oper) (EQ *symb noop))
      (WHEN (EQ *symb oper) (SETQ fla (NULL fla)))
      (insymbol)
    )
    (FUNCALL upf lvl)
    (WHEN fla (STACK_PUT opstk (expr_gencall 1 oper)) )
  )
  (CAR opstk) ; for debug.
)

;
; Generate the prefix unary operators.
;
(DE expr_unary (lvl)
  (LET ( (cla    (NEXTL lvl))
         (upf    (NEXTL lvl))
         (parsta (CAR opstk))
       )
    (WHILE  (EQ *class cla)
      (STACK_PUT ope *symb)
      (insymbol)
    )
    (FUNCALL upf lvl)
    (WHILE ope (STACK_PUT opstk (expr_gencall 1 (STACK_GET ope))))
  )
  (CAR opstk) ; for debug.
)


;
; Generate the binary operators.
;
(DE expr_binary (lvl)
  (LET ( (cla    (NEXTL lvl))
         (upf    (NEXTL lvl))
         (ope    ())
       )
    (FUNCALL upf lvl)
    (WHILE  (EQ *class cla)
      (SETQ ope *symb)
      (insymbol)
      (FUNCALL upf lvl)
      (STACK_PUT opstk (expr_gencall 2 ope))
    )
  )
  (CAR opstk) ; for debug.
)

;
; Generate an expression.
;
(DE expr_expression ()
  (FUNCALL (CAR opetable) (CDR opetable))
)

;
; Get an expression.
;
(DE get_expression ()
  (expr_expression)
  (STACK_GET opstk)
)

;
; Get an expression and return () for no expression or no a cte expr,
; and the list "(type value)" when an expression was getting.
;
(DE get_const_expr ()
  (LET ((res (get_expression)))        ; get the expression.
    (IF (AND (MEMQ (STACK_GET res) cmp_cte_class) ; ... else if constant like
             (MEMQ '*r (STACK_GET res))) ; with read access ...
      res                              ; ... get the list (type value) ...
      (SYS_CALL 0 "GCTE" -89 3)        ; ... else error.
      ()
    )
  )
)

(DE get_typed_const (type def)
  (LET  ((res (get_const_expr)))
    (IF (type_match (CAR res) type)
      res
      (UNLESS res (SYS_CALL 0 "GTCT" 99 3))
      (LIST type def)
    )
  )
)

(DE get_const_string (def)
  (CADR (get_typed_const '*wild_string def))
)

(DE get_const_integer (def)
  (CADR (get_typed_const '*wild_ints def))
)

(DE get_const_float (def)
  (CADR (get_typed_const '*wild_floats def))
)


(DE get_letter (def)
  (LET ((res (CADR (get_typed_const '*string def))))
    (SUBSTR res 1 0)
  )
)


(DE i_assign (id iv)
  (SET id (FIXED iv))
)


(DE f_assign (id fv)
  (SET id (FLOAT fv))
)


(DE s_assign (id sv)
  (SET id (STRING sv))
)



(DE build_proc_parm_list (ent)
  (LET ( (np 0)
         (n1 0)
         (cla ())
         (ll (LIST ()) )
       )
    (WHILE ent
      ; count all formal parameters of a unique type.
      (UNTIL (OR (EQ ': (NEXTL ent))
                 (NULL ent))
        (INCR n1)
        (INCR np)
      )
      ; build the class, type and default value descriptor.
      (SETQ cla (IF (MEMQ (CAR ent) formal_class_table)
                  (NEXTL ent)
                  '*in
                )
            spc (LIST cla (NEXTL ent) (WHEN (MEMQ cla formal_class_defval)
                                             (NEXTL ent))
                )
      )
      ; build each formal entry of the same type.
      (WHILE (> n1 0)
        (QUEUE_PUT ll spc)
        (DECR n1)
      )
    )
    (RPLACA ll np) ; set the number of formal.
  )
)


(DE build_procedure_entry (pname parml typ fnc)
  (SETQ parml (build_proc_parm_list parml))
  (UNLESS (EVAL pname) (SET pname (LIST ())))
  (QUEUE_PUT (EVAL pname) (NCONC parml (LIST typ fnc)))
)


(DF dcl_fnc list_ent
  (LET ((name (NEXTL list_ent)))
    (WHILE list_ent
      (build_procedure_entry  name              ; name
                              (NEXTL list_ent)  ; parm list.
                              (NEXTL list_ent)  ; type
                              (NEXTL list_ent)) ; fnc
    )
  )
)


;
; Pragma statement (call done by dma atome or by include/chaine)
; pragma <opt_str> [, ...] ;
;
(DE pragma_list ()
  (LET ( (lopt (list () )) ; allocate a new option list.
         (flg  T )
       )
    (WHILE flg
      (QUEUE_PUT lopt (get_const_string ())) ; append each option.
      (SETQ flg (skip_separ |,|))
    )
    (STACK_GET lopt)
    lopt
  )
)


(DE pragma_state ()
  (LET ((lopt (pragma_list)))
    (APPLY 'PRAGMA lopt)
    (look_separ |;| ())
    (LIST_DEL lopt)
  )
)

;
; Include/Chaine statements.
; { include | chaine } <file_spc> [, <opt_str> [, ...] ;
;
(DE include_state (flg)
  (LET ((fn (get_const_string ()))
        (st ())
       )
    (SYS_CALL 3)  ; end line in listing mode.
    (WHEN fn
      (WHEN (skip_separ |,|)
        (SETQ st (pragma_list)))
      (STACK_PUT st fn)
      (STACK_PUT st (IF flg 'INCLUDE 'CHAINE))
      (EVAL st)
      (LIST_DEL st)
      (INPUT () (CONCAT "DPU_" (STRING sys$_incl_deep 1) |>| ))
    )
  )
)

;
; Listing statement (call done by dma atome or by include/chaine)
; listing [<file_spc>, <unk_flg>, <pri_flg>, <app_flg>, <page_sz>, <line_sz>];
;
(DE listing_state ()
  (LET ( (parl (LIST () ))
       )
    (SYS_CALL 3)  ; end line in listing mode.
    (QUEUE_PUT parl (get_const_string ()))
    (WHILE (skip_separ |,|)
      (QUEUE_PUT parl (get_const_integer ()))
    )
    (EVAL (RPLACA parl 'LISTING))
    (LIST_DEL parl)
    (look_separ |;| ())
  )
)


;
; Routine to create a new identifier.
; *///* scope are not handled *///*
;
(DE create_new_ident (spc_type cmpv_flg)
  (insymbol)
  (IF *undef
    (PROGN
      (PUTPROP *symb '*type spc_type)
      (WHEN cmpv_flg
        (PUTPROP *symb '*cmp_assign T)
      )
    )
    (SYS_CALL 0 "NWID" -52 3) ()
  )
)

;
; fixed parameter statement.
; <keyword_type> <ident> [= <value>] [, ... ];
;
(DF dcl_fixed_param (type_fnc type_spc type_def)
  (LET ((flg T) (ident ()))
    (WHILE flg
      (IF (create_new_ident type_spc T)
        (PROGN
          (SETQ ident *symb)
          (insymbol)
          (IF (OR (test_operator = T) (test_operator := T))
            (SET ident (FUNCALL type_fnc type_def)) ; := found.
            (SET ident type_def)                    ; := not found.
          )
        )
        (skip_to_separ |,|)
      )
      (SETQ flg (test_separ |,|))
    )
  )
  (look_separ |;| ())
)


;
; Variable statement.
; variable <ident> [= <value> [:<sigma> : <inf> : <sup> ]];
;
(DE dcl_variable ()
)


(DE assignement_state ()
  (SETQ *cmp_assign T)
  (LET ( (targe(target (get_expression)))
    (IF (OR (test_operator = T) (test_operator := T))
  (SETQ *cmp_assign T)

      (PROGN
        (expr_expression)
        (expr_gencall 2 ':=)
      )
      (SYS_CALL 0 "ASSN" 77 3)
      (skip_to_sep |;|)
    )
  )
  (SETQ *cmp_assign ())
)


(DE call_state ()
)




(DE display_state ()
  (LET ( (flg T)
         (object ())
         (type   ())
         (outspc ())
       )
    (WHILE flg
      (SETQ object (get_const_expr)
            defl   '(16 5 2 0 0)
            outspc (LIST ())
            type   (STACK_GET object)
            object (STACK_GET object)
      )

      (WHILE (AND defl (test_separ |:|))  ; build the format list .
        (insymbol)
        (QUEUE_PUT outspc (get_const_integer (NEXTL defl)))
      )
      (STACK_GET outspc) ; free the queue head.
      (IF outspc
        (PROGN ; formatted case.
          CASE (lisp_kind object) (
            (6 7)   ; Integer and float.
                  (O_FIXED outspc object)

            (8 9) ; String.
                  (O_STRING outpsc object)
          otherwise
            (SYS_CALL 0 "DISP" -98 2)
            (skip_to_sep |;|)
          )
          (LIST_DEL outspc)
        )
        (PRIN object)
      )
      (SETQ flg (skip_separ |,|))
    )
  )
  (look_separ |;| ())
  (PRINT)
)


(DF compiler_block (term_list)
  (SETQ   EOF   ()
          *stop ()
  )
  ; *** Loop on all statements ***
  (UNTIL (or eof *stop)
    (SETQ *stats *symb)
    CASE *kind (
      (1)    ; Atom  => (assignement statement.)
         (assignement_state)

      (2 3)  ; procedure call.
         (call_state)

      (20)   ; Reserved keyword.
        (PROGN
          (insymbol)            ; get the next syntax unit.
          (EVAL *stats)         ; activate the related function.
        )

      (21)   ; declaration keyword.
        (EVAL *stats)           ; activate the related function.

      (22)   ; reserved word separator
        (PROGN
          (UNLESS (MEMQ *symb term_list)
            (SYS_CALL 0 "STAT" -66 3)
          )
          (SETQ *stop T)
        )

      (23)   ; Separator.
        (PROGN
          (UNLESS (EQ *stats |;|) (SYS_CALL 0 "STAT" -79 3))
          (insymbol)
        )


      OTHERWISE
        (SYS_CALL 0 "STAT" -66 3)
        (insymbol)
    )
  )
)

;
;
;
(include "init_compiler.lisp_part")  ; load the init compiler routine.
;
;
;


(DE compiler_main ()
  (init_compiler)
  (CHAINE "DPUINI")                  ; get initial source specification.
  ;
  ; *** Error management ***
  ;
  '(ON_ERROR
    (
      (err_code sys$_error)                  ; save the error code.
      (err_sev  (PLIST 'sys$_error))         ; save the error severity.
      (err_point (PLIST 'sys$_error_point))  ; save the error point.
    )
    (IF (> err_code 0)
      T                              ; return T to force standard action.
      (SYS_CALL 0 "DPU " (NEG err_code) err_sev)   ; output our error message.
      ()                             ; force continue execution.
    )
                                     ; return Lisp pointer for restart.
  )

  (SETQ EOF ()                       ; Clear any trailing eof flag.
        *stop ()
        sys$_read_eof ())
  (INPUT () "DPU_1>" "P")            ; Set the prompt and the Pascal comments.
  (insymbol)                         ; read the first syntax unit.
  (UNLESS EOF (compiler_block (end))); run until end or eof.
  (EXIT "Normal end of DPU FIT.")
)



(compiler_main)  ; Go to compiler run.

