(pragma "R-")
(include "lisp_lib.lisp_lib")


(de insymbol ()
  (setq *symb (read)
        *undef sys$_undef
        *kind  sys$_readk)
)

; identifier is an atom :
;
;   val is the value (for cte Lisp param)
;       or the address (for user objects).
;
;   plist is the related type (int, float, string, other)
;
;   the function body must be () except for function.
;

;
; Procedure to put proceed a reference or an operator.
;
; It use the operational stack opstk.
;
(de putitem (expr)
  (let
    ( (np     (cadr expr))                ; get parameter number.
      (fnc    (nth 4 expr))               ; get function code.
      (parm   ())                         ; initialize each local
      (erflg  ())                         ; ... variables.
      (cmpflg ())                         ;
      (typlst ())                         ;
      (varflg ())                         ;
      (lcall  ())                         ;
    )
    (if (null np)                         ; when it is a reference,
      (setq opstk (cons expr opstk))      ; push it in operational stack,
                                          ; else generate a function call.
      (if (null fnc)                      ; if noop function
        (setq opstk (nthcdr (1- np) opstk));clean the parameters...
        ; *********   else, true function. ****************
        (setq typlst (eval fnc)           ; get the formal type list.
              cmpflg (or (null (plist fnc))  ; and set the kandler byte
                               (getprop fnc '*khandler)))
        (while (>= (decr np) 0)           ; loop on each parameter.
          (setq parm (cddr (nextl opstk))); get the effective parameter.
          (when typlst                    ; if a formal list is defined ...
            ; if the effective type is compatible with the formal ...
            (if (memq (lisp_kind (cadr parm)) (setq varflg (nextl typelst)))
              (setq varflg (car varflg))  ; ... get var as cte flag setting.
              (sys_call 0 "EXPR" 84 3)    ; else Error, incompatible arg.
              (setq erflg T)
            )
          )
          (setq lcall (cons               ; build the parameter list.
            (cond
              ((eq (car parm) '*varbl)    ; variable ref. :
                (unless varflg (setq cmpflg ())) ; flag=>to handle var as cte.
                (caddr parm)              ; return the variable identifier.
              )
              ((eq (car parm) '*expr)     ; expression parameter :
                (setq cmpflg ())          ; clear on line computing flag,
                (caddr parm)              ; and return the Lisp expression.
              )
              (T (cadr parm))             ; constante value : return the value.
            )
            lcall)
          )
        ) ; end of parameter loop.
        ; ******* Proceed the function *************
        (setq opstk (cons
          (if cmpflg                      ; if the function is a cte handler ...
            (list 9 () '*const (apply fnc lcall)) ; comput the result.
            (list 9 () '*expr (nth 3 expr) (cons fnc lcall)); generate Lisp expr.
          )
             opstk)
        )
      )
    )
  )
) ; *** End of PUTITEM function ***




(de getitem ()
  (let
    ((res     '(-1 ())))
    case *kind (
      (0) ; *** List => Operator or Separator ***
        (if (car *symb)                   ; if it is an operator.
          (if bunit                       ; if unary context.
            (unless (setq res (cdr (assq 1 *symb))); get unary op. definition,
              (sys_call 0 "EXPR" 58 3)    ; if not found error,
                                          ; ... unary op. expected.
            )
            (unless (setq res (cdr (assq 2 *symb)); get binary op. definition,
                          bunit T)        ; and set the unary flag.
              (sys_call 0 "EXPR" 58 3)    ; if not found error,
                                          ; ... binary op. expected.
            )
          )
          ; ***** Separator case *****
          (if (eq (cdr *symb) |(|)       ; for open parenthesis ...
            (progn                       ; ... then ...
              (insymbol)                 ; Gobble up |(|
              (setq res (expression)     ; Get a the sub-expression.
                    bunit ())            ; Disable unary op. flag.
              (unless (eq (cdr *symb) |)|); if not close parenthesis ...
                (sys_call 0 "EXPR" 81 2) ; |)| was expected error.
              )
            )
            (setq bstp T)                ; stop expression processing.
          )
        )

      (1) ; *** Atom => Variable or Parameter ***
        (progn
          (when *undef
            (sys_call 0 "EXPR" 51 3))   ; Undeclared identifier.
          (setq res
            (if (m_block (eval *symb))  ; if it is not a lisp object ...
              (list 9 () '*varbl (getprop *symb '*type) *symb)
              (list 9 () '*const (eval *symb))
            )
                bunit ()                ; disable unary operator.
          )
        )

      (2 3) ; *** User or Standard Function ***
        (let
          ( (np 0)
            (sep  |,|)
            (fnc  *symb)
          )
          (insymbol)                    ; Gobble up the function name.
          (when (eq (cdr *symb) |(|)
            (while (eq sep |,|)
              (insymbol)                ; Gobble up the separator.
              (putitem (expression))    ; push each parameter in opstk.
              (incr np)
              (setq sep (cdr *symb))
            )
            (unless (eq (cdr *symb) |)|)
              (sys_call 0 "EXPR" 81 2)  ; else error << |)| expected. >>.
            )
          )
          (setq res (list 9 np '*funct (getprop fnc '*type) fnc)
                bunit ())               ; binary op possible.
        )

      (4  ; *** Nil (or nul string) ***
       5  ; *** True value ***
       6  ; *** Integer cte ***
       7  ; *** Float cte ***
       8  ; *** Character ***
       9) ; *** String ***
        (setq res (list 9 () '*const *symb)
              bunit ())               ; binary op possible.

      otherwise
        ()
    )
    (unless bstp (insymbol))
    res
  )
) ; *** End of Getitem ***



(de expression ()
  (let ((stk   ())
        (opstk ())
        (bunit  T)
        (bstp   ())
        (gtitm  ())
       )
    (setq gtitm (getitem))
    (until (or (and (null stk) bstp) fatalerr)
      (if (and stk
               (or (< (car gtitm) (caar stk))
                   (and (= (car gtitm) (caar stk))
                        (<> (car gtitm) 7)
                   )
               )
          )
        (putitem (nextl stk))          ; pop item from the current.
        (setq stk   (cons gtitm stk)
              gtitm (getitem)
        )
      )
    )
    (when (> (length opstk) 1)
      (sys_call 0 "EXPR" 55 4)         ; operator stack error.
      (setq fataerr T)
    )
    (car opstk) ; send the expression result.
  )
)

(setq fatalerr ())



(progn
  ; *** Define the separators ***
  (dma '%include () '(() )
  (dma '%chaine  () '(() )
  (dma 'end      () '(() end))    ; set the end keyword function.

  (sys_call  51              ; Initialize the compiler context.
    'MXD_V4_CMP              ; Owner Atome for the compiler.
    '(cmp_err md nb sv)      ; Set the error message function call list.
    '(                       ; and the separator/operator list.
       ( |(| '( |(| ))       ; Open parenthesys.
       ( |)| '( |)| ))       ; Close parenthesys.
       ( |,| '( |,| ))       ; Comma.
       ( |;| '( |;| ))       ; Semicolon. 
       ( |:| '( |:| )        ; Colon separator.
         |=| '( () (8 2 () () *assign))); Binary assignement operator.
       ( |^| '( () (6 2 () () **  )))   ; x ^ y.
       ( |*| '( () (5 2 () ()  *  ))    ; x Multiply y.
         |*| '( () (6 2 () () **  )))   ; x ^ y.
       ( |+| '( T  (7 1 () () ()  )     ; + x.
                () (4 2 () ()  +  )))   ; x + y.
       ( |-| '( T  (7 1 () () neg )     ; - x.
                () (4 2 () ()  -  )))   ; x - y.
       ( |/| '( () (5 2 () 1.0 /  )))   ; x / y.
       ( |=| '( () (3 2 () T   =  )))   ; x = y.
       ( |<| '( () (3 2 () T   <  ))    ; x < y.
         |=| '( () (3 2 () T  <=  ))    ; x <= y.
         |>| '( () (3 2 () T  <>  )))   ; x <> y.
       ( |>| '( () (3 2 () T   >  ))    ; x > y.
         |=| '( () (3 2 () T  >=  )))   ; x >= y.
       ( |&| '( () (2 2 () T  and )))   ; x & y.
       ( |!| '( () (1 2 () T  or  )))   ; x ! y.
     )
    '(                       ; *** Language keyword definitions ***
       %include              ; include, chaine, pragma and eof atom must be
       %chaine               ; always in this first and in this order.
       %pragma               ;
       %eof                  ;

       begin                 ; The other atom are user defined.
       end
     )
  )

  ; Define the identifier used as operators.
  (dma 'div () '((2 5 2 () 1 div)))  ; x div y.
  (dma 'rem () '((2 5 2 () 1 div)))  ; x rem y.
  (dma 'and () '((2 2 2 () T and)))  ; x and y.
  (dma 'or  () '((2 1 2 () T  or)))  ; x or y.
  (dma 'not () '((1 3 1 () T null))) ; not x.


  ; *** Define some user function ***

  (de ord (boolean)
    (if boolean
      1
      0
    )
  )


  ; *** Define a cte parameter ***

  (setq pi 3.14159275)
  (setq e (exp 1))


  ; *** Define a varbl ***

  (setq v1 (m_allocb 24))
  (putprop 'v1 '*type 1.0)




  ; *** use expression ***


  (setq eof ())                      ; Clear any trailing eof flag.
  (chaine)                           ; set TTY as current input.
  (input () "EXPR>" |P|)             ; Set the prompt and the Pascal comments.

  (setq reserved (sys_call 10 reserved)) ; create the reserved lex.
  (sys_call 2 keyword_list )         ; set the keyword list.
  (sys_call 3 builtin_list )         ; set the builtin list.

  (sys_call 3 T )                    ; valid the alternate macro character mode.

  (insymbol)
  (until eof
    (setq res (expression))
    (print " = " res ";;")
    (insymbol)
  )
)
