;(PRAGMA "R-" "L+")

(SETQ file_type 1)


;
; *** Procedure to build a column menu ***
;
(DE blt_off_menu (nc)
  (IF (<= nc ncol)
    (CONS (CONCAT "Col_" (STRING nc 2)) (blt_off_menu (1+ nc)))
    ()
  )
)


(DE read_data ()
; Renvoit dans les atomes suivants :
;   curve -> la liste des enregistrements memoires.
;   nrec leur nombres.
;   ncol le nombre de colonnes.
;
;
  ;***************************** DIALOGUE ********************************
  (LET
    ( (currpt ())
      (srec    0)
      (lsel   (LIST "" 1))
      (rsel      0)
      (fname  "")
      (ch     ())
    )

    ; *** Ouverture du fichier des donnees ***

    (SETQ  cm_flg ())
    (UNTIL cm_flg
      (SETQ rsel (SYS_CALL 262 "Input File Name"      ; Get an Input File Specification.
                    '("*.dat" "*.txt" "*") ; Specify a file-type selection list.
                    "curve.dat"            ; Default File Specification.
                    file_type              ; Default File type to use.
                    ()                     ; Input Mode => The File must to be existing.
                    lsel                   ; The Result list.
      ))
      (WHEN (CONSP rsel)                   ; When the Result is a valid File spc.
        (SETQ fname     (CAR rsel)         ; Get the File Name.
              file_type (CADR rsel))       ; keep the last selected filter number.
      )
      (IF (EQ 0 (print " open return " (OPEN 'file "I" fname)))    ; si le fichier est accessible...
        (SETQ cm_flg T)                    ; indique open O.k.
        (SYS_CALL 260 " Inaccessible or inexistant file. " )
      )
    )

    ; *** Lecture du nombre de colonnes ***

    (UNTIL (NUMBERP (SETQ ncol
                      (SYS_CALL 261 "Nb of Col." '(
                            " 1" " 2" " 3" " 4" " 5" " 6" " 7" " 8"
                            " 9" "10" "11" "12" "13" "14" "15" "16" )
                      )
                    )
           )
      (SYS_CALL 260 " The number of column of the data file was expected. ")
    )
    (SETQ col_menu (blt_off_menu 1)
          untx     (SYS_CALL 265 " X unit name " "X") ; *** Get x axis unit name ***
          unty     (SYS_CALL 265 " Y unit name " "Y") ; *** Get y axis unit name ***
          plot_label (SYS_CALL 265 "Your Plot" "My Plot")   ; *** Get the Plot Label ***
    )

    ; *** Define the record type. ***
    (R_DEFINE rec (tb ncol . M_FL))
    ; *** Create one record identifier. ***
    (rec rec_curr)


    ;***************** LECTURE DU FICHIER ********************

    (SETQ nrec  0
          curve (LIST ())
    )
    (INPUT 'file "Entrer un point S.V.P. ") ; selection du fichier en entree.
    (SETQ x (READ))                ; read the first value.
    (UNTIL (EOF)                   ; Until the end of File, do...
      (INCR nrec)                  ; Increment the count of record_array.
      (R_NEW rec_curr x)           ; Create the record and set the first val.
      (SETQ index 2)               ; Fill the record_Array from the second cell.
      (WHILE (<= index  ncol)      ; For each column, load the value.
        (R_STORE rec_curr tb index
                (IF SYS$_READ_EOLN ; when eoln reached
                  0.0              ; padds with 0.0 ...
                  (READ)           ; else read a number.
                )
        )
        (INCR index)               ; Increment the reord_array index.
      )

      (ZAPLINE)                    ; Go to the end of line (or eof).
      (UNLESS EOF (SETQ x (READ))) ; Read the first column of next line.
      (QUEUE_PUT curve rec_curr)
    )	                             ; End of until.

    (INPUT)                        ; Return to tty input.
    (CLOSE 'file)                  ; Close the Data File.
  )                                ; End of Let.
)                                  ; End of (De read_data ...).

;
;
;*******************************************************************************
;
;


; *** Function to Generate a Draw menu user interraction ***

(DE menu_action (menu_titre menu_list action_list) 
  (LET (
         (choix (SYS_CALL 261 menu_titre menu_list))  
       )
    (IF (NUMBERP choix)
      (EVAL (NTH (1- choix) action_list))
      ()
    )
  )
)

;
; *** Procedure to delete an entry from a curve entry list ***
;
(DF cv_sup (ncv liste)      ; ncv is the curve segment number.
  (LET ((ll (EVAL liste)))
    (SET liste (DELETE (ASSQ (EVAL ncv) ll) ll))
  )
)

 
;
; *** Procedures to set a new curve specification ***
;
(DE get_offset (title)
  (LET ( (rep (SYS_CALL 261 title col_menu))
       )
    (IF (NUMBERP rep) rep ())
  )
)

(DE get_curve_spc ()
  (LET ( (x   (get_offset "Col. X"))
         (y   ())
         (sg  ())
         (nsg ())
         (spc ())
       )
    (WHEN (AND (NUMBERP x)         ; When the x offset is defined ...
               (NUMBERP (SETQ y (get_offset "Col. Y"))) ; ... y offset also ...
          )
      (SETQ sg ()) ; (get_offset "Col. Sigma"))
      (SETQ spc (LIST 'rec 'tb x () 'tb y () ())) ; build the basic curve specification.
      ; For the first curve, we must evaluate the minimaxi ...
      ; and create the axis boxe.
      (UNLESS cv_spc
        (SETQ minimaxi (SYS_CALL 51 curve spc)
              box_seg  (SYS_CALL 230 1000)
        )
        (SYS_CALL 231)
        (SETQ box_id (SYS_CALL 282 minimaxi orgx orgy xsz ysz untx unty 0))
        (SYS_CALL 211 4    3 4 1 1.0)   ; Set String Attributes.
        (SYS_CALL 221 (+ orgx (/ xsz 2)) (- orgy 2) 0.0 0.5 plot_label)
        (SYS_CALL 211 4    1 1 1 1.0)
      )
      (SETQ nsg     (SYS_CALL 230)      ; Get a new segment number for the curve.
            spc     (CONS nsg spc)      ; Complet the specification.
            cv_spc  (CONS spc cv_spc)   ; Add the new curve specification.
            cv_attr (CONS (LIST nsg 1 1 1 1.0) cv_attr) ; Define default attr.
      )
      nsg                               ; Return the segment Number.
    )
  )
)




;
; Procedure to get a mouse selected curve.
;
(DE get_curve_number ()
  (LET ( (rep (SYS_CALL 268 ncv 1 '(1 1)))
       )
    (IF rep
      (CAR rep)
      ()
    )
  )
)


;
; Get color procedure
;
(DE get_color ()
  (LET ((res 1))
    (IF (NUMBERP (SETQ res (SYS_CALL 261 "Color"
                                '("white" "black"  "red"  "blue"
                                  "green" "yellow" "cyan" "magenta")))
        )
      (1- res)
      ()
    )
  )
)


;
; Modify the curve attribute.
;
(DE set_curve_attr (ncv)
  (LET ( (org_attr (ASSQ ncv cv_attr))
         (attr     ())
         (c_color  ())
         (c_type   ())
         (c_kind   ())
         (c_size   ())
         (res      ())
       )
    (SETQ attr (CDR org_attr)           ; Skip the segment number.
          c_color (NEXTL attr)          ; Get actual color attribute,
          c_type  (NEXTL attr)          ; Get actual type attribute,
          c_kind  (NEXTL attr)          ; Get actual kind attribute,
          c_size  (CAR attr)            ; ... and get size parameter.
    )
    (WHILE (menu_action "attribute"
            '( "quit "
               "save "
               "color"
               "type "
               "size "
             )
            '(
               (PROGN  ; *** Quit process ***
                 (IF (EQ 1 (SYS_CALL 263 " No attr change? "))
                   ()
                   T
                 )
               )

               (PROGN  ; *** Save new attributes and quit. ***
                 (RPLACA (MEMQ org_attr cv_attr)
                         (LIST ncv c_color c_type c_kind c_size))
                 ()
               )

               ; *** Set color ***
               (WHEN (SETQ res (get_color))
                 (SETQ c_color res)
                 T
               )

               ; *** Set type of output ***
               (PROGN
                 (menu_action " Curve Type "
                  '( "no_change"
                     "  Line  "
                     " Marker "
                   )
                  '(
                     ; ** No change **
                     ()

                     ; ** Set type to line mode and set kind of line **
                     (WHEN (SETQ res (menu_action " Kind of line "
                                      '( "    Solid    "
                                         "    Dashed   "
                                         "    Dotted   "
                                         "Dashed_Dotted"
                                         " Triple Dot  "
                                         " Double Dot  "
                                         " Spaced Dot  "
                                         " Spaced Dash "
                                         "Long Short - "
                                         "  Long Dash  "
                                         " Dash 3 Dot  "
                                         " Dash 2 Dot  "
                                       )
                                      '(1 2 3 4 5 6 7 8 9 10 11 12)
                                     )
                           )
                       (SETQ c_type   1
                             c_kind res)
                     )

                     ; ** Set type to marker mode and set kind of marker **
                     (WHEN (SETQ res (menu_action " Kind of marker "
                                        '( "  single dot  "
                                           "    + sign    "
                                           "   asterisk   "
                                           " small circle "
                                           "diagonal Cross"
                                           " solid diamond"
                                           "    diamond   "
                                           " solid hglass "
                                           "  hourglass   "
                                           " solid bowtie "
                                           "    bovtie    "
                                           " solid square "
                                           "    square    "
                                           "solid tri down"
                                           " triangle down"
                                           " solid tri up "
                                           "  triangle up "
                                           " solid circle "
                                         )
                                        '(1 2 3 4 5 -13 -12 -11 -10 -9
                                          -8 -7 -6 -5 -4 -3 -2 -1)
                                     )
                           )
                       (SETQ c_type   2
                             c_kind res)
                     )

                   )   ; End of action (set type ... )
                 )     ; End of menu_action (set type ... )
                 T
               )       ; *** end of type handling ***


               ; *** Set size parameter ***
               (PROGN
                 (SETQ c_size (SYS_CALL 264 " Size " 0 10 c_size))
                 T
               )

           
             )         ; End of attribute menu action list.
           )           ; End of menu action call.

    )       ; End of while ...
  )         ; End of let.
)  ; End of routine.


(DE plot_curve (ncv)
  (LET ( (spc  (CDR (ASSQ ncv cv_spc))) ; Get curve specification.
         (attr (CDR (ASSQ ncv cv_attr))); Get curve attribute.
       )
    (UNLESS ope_box                     ; When the Box is not Plotted...
      (SYS_CALL 230 box_seg)            ; Select the box segment.
      (SYS_CALL 288 box_id)
      (SETQ ope_box T)
    )
    (SYS_CALL 230 ncv)
    (SYS_CALL 212 attr)                 ; Set all attributes.
    (SYS_CALL 289 box_id)               ; Open The Box.
    (SYS_CALL 299 1 0 curve () spc)     ; Plot the curve.
    (SYS_CALL 290)                      ; Close the Box.
    (SYS_CALL 231)                      ; End of segment.
    (SYS_CALL 211 9 ncv 2 1 2)          ; Set the segment As detectable, Not HighLight, Visible.
  )
)




(DE Drw_Open_file ()
  (read_data)                           ; Lit les donnees.
)


(DE Drw_Close_file ()
)


(DE Drw_Add_a_curve ()                  ; *** Add a curve to graphic ***
  (SETQ ncv (get_curve_spc))            ; Add the curve specification.
  (WHEN ncv
    (set_curve_attr ncv)                ; Set initial attributes.
    (plot_curve ncv)                    ; Plot it.
  )
)


(DE Drw_Modif_a_curve ()                ; *** Modify a curve attribute ***
  (SETQ ncv (get_curve_number))         ; Get a curve number.
  (WHEN ncv
    (set_curve_attr ncv)                ; Modify the attributes.
    (plot_curve ncv)                    ; ... and update the plot.
  )
)


(DE Drw_Del_a_curve ()                  ; *** Supress a curve ***
  (SETQ ncv (get_curve_number))         ; Get a curve number.
  (WHEN ncv
    (SYS_CALL 232 ncv)                  ; Delete the related segment.
    (cv_sup ncv cv_spc)                 ; ... and suppress the related ...
    (cv_sup ncv cv_attr)                ; ... informations.
  )
)


(SETQ DRAW_MENUS '(                     ; *** Define a menu insertion List ***
                    (T                  ; Open the File Menu.
                      "Open"              (Drw_Open_file)
                      "Close"             (Drw_Close_File)
                      |-|               ; Insert a Separator Line.
                    )                   ; Close the File menu.
                    ("   Edit  "        ; Create the Menu Edit.
                      "Add Curve"         (Drw_Add_a_curve)
                      "Modify a Curve"    (Drw_Modif_a_curve)
                      "Delete a Curve"    (Drw_Del_a_curve)
                    )                   ; Close the Edit Menu.
                  )                     ; Close the Main Barre Menu.
)



;
;  *************** Main Program *****************
;
(PROGN
  ; Init and allocate the plot picture.
  (SETQ sca (SYS_CALL 201          ; *** Initiatize the Drawing System ***
                    25 18          ; Specify a 2D picture size.
                    "* DRAW *"     ; Specify a Picture Label.
                    T              ; Set the Scaled Mode When possible.
                    ()             ; List to receive the ServER characteristics.
                    "Draw/E-Lisp"  ; Task Label.
                    0              ; Set the Default Server Flags Word.
                    DRAW_MENUS     ; Specify a menu insertion List.
            ))
  (WHEN (NUMBERP sca)
    (EXIT " *** Graphic Interface not implemented in this E-LISP Interpretor ***")
  )
(PRINT " 201 OK")
  (SYS_CALL 202 1 T)               ; Initialise le mode graphique "Time of fly".

  (SETQ cv_spc  ()                 ; initialise la liste des specifications.
        cv_attr ()                 ; initialise la liste des attributs.
        orgx     2                 ; x axis origine.
        orgy     3                 ; y axis origine.
        xsz     20                 ; set x axis size (cm).
        ysz     15                 ; set y axis size (cm).
        ope_box ()                 ; Init to Closed Box status.
        nnd      T
  )

  (WHILE nnd
    (SETQ drw_dir (SYS_CALL 205 1)); Get an expression result from dialog.
    (IF (CONSP drw_dir) (EVAL drw_dir)
       (WHEN (< drw_dir 0)
         (SYS_CALL 200)
         (EXIT " End of Draw/E-Lisp")
       )
  )
) ; **************   End of main program. ********************
