;
;  make a case in lisp program.
;
; syntaxe :
;
;  
;    (case <expression> (
;      (<label_liste> <statement_list>)   ;; <label_list must be integer values.
;       .....
;     [ (otherwise  <statement_list>) ]   ;; optional otherwise.
;     ))
;  
;
;
; executable function part.
;
(df case_proceed (case_expr case_min case_max case_table case_other)

  ()
)
(dma 'case
  ( (otherwise ())                        ; save old otherwise handling.
    (case_expr (read))                    ; get case expression.
    (case_block  (read))                  ; get case body.
    (case_def ())
    (case_entry ())
    (case_label ())
    (case_min ())
    (case_max ())
    (case_dim 0)
    (case_curr 0)
    (case_tabl ())                        ; to allocate a temporary table.
  )
  ;
  ; begin of first scan.
  ;
  (setq case_def case_block)
  {case_scan_1
  (brkunl case_def case_scan_1)

    (setq case_entry (nextl case_def))    ; get a case entry.
    (setq case_label (nextl case_entry))  ; get first label in this entry.

  (brkwh (eq case_label 'otherwise) case_scan_1)

    ; normal case entry.
    (while case_label
      ; get the value of this label and replace it.
      (setq case_curr (car (rplaca case_label (eval (car case_label)))))
      (nextl case_label)                  ; skip to next label.
      (if (null case_min)
        (setq case_max case_curr
              case_min case_curr)         ; set initial min and max.
        (if (> case_curr case_max)        ; update min and max.
          (setq case_max case_curr)
          (when (< case_min case_curr)
            (setq case_min case_curr))
        ))
      (when ( > (- case_max case_min) 255); on table overflow
        (sys_call 0 "case" 1002 4))       ; generate fatal error.
    )
  }
  ; otherwise entry management.
  (when (or case_label case_def)
    (if (eq case_label 'otherwise)
      (setq otherwise case_entry)         ; save otherwise statements.
      (sys_call 0 "case" 1001 3))         ; generate a severe error.
  )  
  ;
  ; end first scan.
  ;
  (setq case_dim (1+ (- case_max case_min))) ; compute the case size.
  (setq case_table (m_allocb (* 4 case_dim))); allocate the space for the table.
  ; initialize the case table.
  (setq case_entry case_table
        case_curr case_min)
  (until (> case_curr case_max)
    (m_put case_entry M_OB otherwise)
    (setq case_entry (m_offset case_entry 4))
    (1+ case_curr))
  ;
  ; begin of second scan.
  ;
  {case_scan_2
  (brkunl case_block case_scan_2)

    (setq case_entry (nextl case_block))  ; get a case entry.
    (setq case_label (nextl case_entry))  ; get first label in this entry.
    ; here case_entry -> entry body.
  (brkwh (eq case_label 'otherwise))      ; skip otherwise.

    (while case_label
      ; get the value of this label.
      (setq case_curr (m_index case_table 0
                               (- (nextl case_label) case_min))
                               4)         ; get table element pointer.
      (if (eq (m_get case_curr M_OB) otherwise)
        (m_put case_curr M_OB case_entry) ; if label already used,
        (sys_call 0 "case" 1003 3))       ; then severe error.
    )
  }
  ;
  ; generates the scan statement :
  ;   (eval (m_get (m_index <table> 0 4 (- <min> <expr>)) M_OB))
  ;
  (
)
