{
*************************************************************************
*                                                                       *
*                                                                       *
*                                                                       *
*                                                                       *
*       * *  L E A S T - S Q U A R E S   P R O C E S S O R  * *         *
*                                                                       *
*                                                                       *
*                                                                       *
*           ---  TYPES DEFINITIONS PASCAL FILE MODULE   ---             *
*                                                                       *
*                                                                       *
*           by :                                                        *
*                                                                       *
*               P. Wolfers                                              *
*                   c.n.r.s.                                            *
*                   Laboratoire de Cristallographie                     *
*                   B.P.  166 X   38042  Grenoble Cedex                 *
*                                           FRANCE.                     *
*                                                                       *
*************************************************************************


/////////////////////////////////////////////////////////////////////////
//                                                                     //
//                                                                     //
//                  Global Public Licence (GPL)                        //
//                                                                     //
//                                                                     //
// This license described in this file overrides all other licenses    //
// that might be specified in other files for this library.            //
//                                                                     //
// This library is free software; you can redistribute it and/or       //
// modify it under the terms of the GNU Lesser General Public          //
// License as published by the Free Software Foundation; either        //
// version 2.1 of the License, or (at your option) any later version.  //
//                                                                     //
// This library is distributed in the hope that it will be useful,     //
// but WITHOUT ANY WARRANTY; without even the implied warranty of      //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU   //
// Library General Public License for more details.                    //
//                                                                     //
// You should have received a copy of the GNU Lesser General Public    //
// License along with this library (see COPYING.LIB); if not, write to //
// the Free Software Foundation :                                      //
//                      Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  //
//                                                                     //
/////////////////////////////////////////////////////////////////////////
}




{  Version 1.2-B (or Upper)  of  L S Q  System  }
{************    CPAS  Version   ***************}



const

  { This numbers are fixed for 1000 (one thousand) fit variables }
  { to change, applied the next formula, where nv denots the maximum
    number of variable : lsq_maxmat = (nv+1)*nv/2 + 2*nv }

  lsq_maxmat    = 502500;     { The maximum size of matrix space }
  lsq_maxnvarbl = 1000;       { Maximum number of variable }

  lsq_maxcase   = 1024;       { Maximum size for a case }

  stack_max     = 1024;       { Maximum of stack }
  define_max    = 64;         { Maximum of nested context }

  maxreject     = 1E10;       { Maximum for rejection }


{-----------------------------------------------------------------------------------}



type

  {********************************}
  {****  Basic location types  ****}
  {********************************}


  lsq_real = double;          { Choice of real }




  {*******************************************}
  {**** Least Squares Pointer Definitions ****}
  {*******************************************}


  lsq_ptr    = ^lsq_rec;      { Pointer to a Least-Squares Object }
  ddp_ptr    = ^ddp_tab;      { Pointer to a DDP (Der. Directive Proc. Table) }
  drt_ptr    = ^drt_tab;      { Pointer to a DRT (Derivate Reference Table) }
  vec_ptr    = ^vec_tab;      { Pointer to a Least-Squares Vector }
  cache_ptr  = ^cache_rec;    { Pointer to a Cache Element }
  entry_ptr  = ^entry_rec;    { Pointer to a Cache Entry }
  statis_ptr = ^statis_rec;   { Pointer to a Statistic Record }



  {****************************************}
  {****  Memory Allocation Definitions ****}
  {****************************************}

  { Record for Equivalence Conversions }
  eqv_type = record case integer of
    0:( rec: rec_ptr    );
    1:( lsq: lsq_ptr    );
    2:( ddp: ddp_ptr    );
    3:( drt: drt_ptr    );
    4:( vec: vec_ptr    );
    5:( sta: statis_ptr );
    6:( int: integer    );
    7:( flt: lsq_real   )
  end;



  lsq_obj = record            { Object user Least-Squares Referesnce }
    case typ: integer of
      0,                      { Null or Wild Least-Squares Pointer }
      1,                      { Least-Squares Pointer to a Variable }
      2:(lp: lsq_ptr);        { Least-Squares Pointer to a Parameter }
      3:(fv: lsq_real);       { Least-Squares Float }
      4:(iv: integer )        { Least-Squares Integer }
  end;


  {***********************************************}
  {**** Least-Squares kind of Functional Node ****}
  {***********************************************}

  lsq_nodetypes = (
      nd_add,                 { Basic Operators }
      nd_sub,
      nd_mul,
      nd_div,
      nd_pow,
      nd_ipw,
      nd_neg,

      nd_round,               { Operations Without Derivation }
      nd_trunc,
      nd_mod,
      nd_rem,
      nd_eq,
      nd_ne,
      nd_lt,
      nd_le,
      nd_ge,
      nd_gt,

      nd_not,
      nd_and,
      nd_or,

      nd_abs,                 { Some Basic Functions }
      nd_sqrt,
      nd_log,
      nd_exp,

      nd_sinh,                { Normal Hyperbolic Functions }
      nd_cosh,
      nd_tanh,
      nd_asinh,
      nd_acosh,
      nd_atanh,

      nd_sin,                 { Normal Trigonometric Functions }
      nd_cos,                 { ... with angle in Radian }
      nd_tan,
      nd_asin,
      nd_acos,
      nd_atan,
      nd_phase,

      nd_dsin,                { Trigonometric Functions }
      nd_dcos,                { ... with degrees angles }
      nd_dtan,
      nd_adsin,
      nd_adcos,
      nd_adtan,
      nd_dphase,

      nd_bess1,               { Bessel J function }
      nd_gamma,               { Gamma function }


                              { * List Item Reference Operators }
      nd_ub_listref,          { for constant UBYTE field }
      nd_sb_listref,          { for constant SBYTE field }
      nd_uw_listref,          { for constant UWORD field }
      nd_sw_listref,          { for constant SWORD field }
      nd_li_listref,          { for constant INTEGER field }
      nd_fl_listref,          { for constant SINGLE float field }
      nd_db_listref,          { for constant DOUBLE float field }
      nd_listref,             { for least-square expression }

                              { * Single Item Reference Operators }
      nd_ub_refer,            { for constant UBYTE field }
      nd_sb_refer,            { for constant SBYTE field }
      nd_uw_refer,            { for constant UWORD field }
      nd_sw_refer,            { for constant SWORD field }
      nd_li_refer,            { for constant INTEGER field }
      nd_fl_refer,            { for constant SINGLE float field }
      nd_db_refer,            { for constant DOUBLE float field }
      nd_refer,               { for least-square expression }

      nd_summ_loop,           { Loop Summation Operator }
      nd_integr_loop,         { Integration Operator }
      nd_interpol,            { Interpolation Operator }


      { *** Special Operator for Derivates *** }

      nd_mul_d,               { Basic Operators with derv. }
      nd_div_d,
      nd_pow_d,
      nd_ipw_d,

      nd_abs_d,               { Some Basic Functions with derv. }
      nd_sqrt_d,
      nd_log_d,
      nd_exp_d,
      nd_sinh_d,
      nd_cosh_d,
      nd_tanh_d,
      nd_asinh_d,
      nd_acosh_d,
      nd_atanh_d,


      nd_sin_d,               { Normal Trig. Functions with derv.}
      nd_cos_d,               { and angles in Radian }
      nd_tan_d,
      nd_asin_d,
      nd_acos_d,
      nd_atan_d,
      nd_phase_d,

      nd_dsin_d,              { Trigonometric Functions with derv. }
      nd_dcos_d,              { ... with degrees angles }
      nd_dtan_d,
      nd_adsin_d,
      nd_adcos_d,
      nd_adtan_d,
      nd_dphase_d,

      nd_bess1_d,             { Bessel J function }
      nd_gamma_d,             { Gamma function }

      nd_integr_loop_d,       { Loop Integration Operator }
      nd_summ_loop_d,         { Loop Summation Operator }

      nd_interpol_d,          { Interpolation Operator }



      { *** Other Node  *** }

      nd_konst,               { Constant Expression }
      nd_index,               { Loop Index Value }
      nd_varbl,               { Variable Reference }
      nd_parm,                { Parameter Reference }

      nd_list,                { List Header Block }
      nd_limits,              { Limits Block }
      nd_diablk,              { Diagonal Block Header }
      nd_collect,             { Fit Header Block }

      nd_scandir,             { Scan List Directive }
      nd_initlist,            { Init List Directive }
      nd_storedir,            { Store Directive }
      nd_ifdir,               { If Directive }
      nd_casedir,             { Case Directive }

      nd_user_call,           { User Call Procedure/Function }
      nd_lsq_funct,           { Least-Squares Function Node }
      nd_lsqfnc_call,         { Least-Squares Function Call }
      nd_lsq_formal           { Least-Squares Function Formal Reference }

    );




  {******************************************}
  {**** Least-Squares Status Definitions ****}
  {******************************************}

  lsq_statusty = (
    lsq_success,              { Success of Operation }
    lsq_init,                 { Success with Init Setting }
    lsq_cacheovf,             { Cache Overflow in Windowing Scan }
    lsq_stop,                 { Stop Condition Reached }
    lsq_eof                   { EOF Reached in a Scan List }
  );



  {*********************************************}
  {**** Least-Squares Scan Flag Definitions ****}
  {*********************************************}

  scaf_types = (
    scaf_complete,            { Standard List Scan }
    scaf_partial,             { Partial Scan Drived by Sentinel }
    scaf_window               { Scan in Windowing Mode }
  );




  {**************************************************}
  {**** Least-Squares Parameter Flag Definitions ****}
  {**************************************************}


  par_flagty = (              { * Definitions of Parameters Flags }
      parf_evalsigma,         { Flag for sigma evaluation }
      parf_derivate,          { Flag for derivation comp. enable }
      parf_refer,             { Flag for reference (used parm) }
      parf_depend,            { Flag for individual reference }
      parf_summ,              { Flag for summation parameter }
      parf_mutant,            { Flag for mutant parameter }
      parf_cached,            { Flag for cached parameter }
      parf_dertab             { Flag for dependance done }
    );

  lsq_flgty = set of par_flagty;      { * Flag Word Definition }





{**************************************************************}
{***********    Least-Squares Node Structure   ****************}
{**************************************************************}


  lsq_rec = record
    case lsq_ndty: lsq_nodetypes of

      nd_not,
      nd_neg, nd_round, nd_trunc,
      nd_abs,   nd_sqrt,
      nd_log,   nd_exp,
      nd_sinh,  nd_cosh,  nd_tanh,
      nd_sin,   nd_cos,   nd_tan,
      nd_asin,  nd_acos,  nd_atan,
      nd_dsin,  nd_dcos,  nd_dtan,
      nd_adsin, nd_adcos, nd_adtan,
      nd_gamma:(                      { * Unary Operators }
          suna:            lsq_ptr    { The Parameter Pointer }
        );

      nd_abs_d,   nd_sqrt_d,
      nd_log_d,   nd_exp_d,
      nd_sinh_d,  nd_cosh_d,  nd_tanh_d,
      nd_sin_d,   nd_cos_d,   nd_tan_d,
      nd_asin_d,  nd_acos_d,  nd_atan_d,
      nd_dsin_d,  nd_dcos_d,  nd_dtan_d,
      nd_adsin_d, nd_adcos_d, nd_adtan_d,
      nd_gamma_d:(                    { * Unary Operator for Derv. }
          cuna:            lsq_ptr;   { The Parameter Pointer }
          vuna:            lsq_real   { The Last Related Value for Derivation }
        );

      nd_ipw, nd_bess1:(              { * More Complex Functions }
          spuna:           lsq_ptr;   { The Expression Parameter }
          sindex:          integer    { The Additional Integer }
        );

      nd_ipw_d, nd_bess1_d:(          { * More Complex Functions for Derv. }
          xpuna:           lsq_ptr;   { The Expression Parameter }
          xvuna:           lsq_real;  { The Additinal Value }
          xindex:          integer    { The Additional Integer }
        );


      nd_and, nd_or,
      nd_add, nd_sub,
      nd_mul, nd_div, nd_pow,
      nd_phase, nd_dphase,
      nd_eq, nd_ne, nd_lt,  nd_le,  nd_ge, nd_gt,
      nd_rem,
      nd_mod:(                        { * Binary Operators }
          sbin1, sbin2:    lsq_ptr    { The Two Parameter Pointers }
        );

      nd_mul_d, nd_div_d, nd_pow_d,
      nd_phase_d, nd_dphase_d:(       { * Binary Operators for Derv. }
          cbin1, cbin2:    lsq_ptr;   { The Two Parameter Pointers }
          vbin1, vbin2:    lsq_real   { The Two Value for Derivations }
        );

                                      { * Item Selection Operators }
      nd_ub_listref,                  { For constant M_UB field }
      nd_sb_listref,                  { For constant M_SB field }
      nd_uw_listref,                  { For constant M_UW field }
      nd_sw_listref,                  { For constant M_SW field }
      nd_li_listref,                  { For constant M_LI field }
      nd_fl_listref,                  { For constant M_FL field }
      nd_listref:(                    { For Least-Square expression }
          lref_list:       lsq_ptr;   { Constant Select List or Item }
          lref_offset:     integer    { Related Offset }
        );

      nd_ub_refer,                    { For constant M_UB field }
      nd_sb_refer,                    { For constant M_SB field }
      nd_uw_refer,                    { For constant M_UW field }
      nd_sw_refer,                    { For constant M_SW field }
      nd_li_refer,                    { For constant M_LI field }
      nd_fl_refer,                    { For constant M_FL field }
      nd_refer:(                      { For Least-Squares expressions }
          ref_pointer:     rec_ptr;   { Direct Memory Pointer }
          ref_offset:      integer    { Related Offset }
        );

      nd_lsq_funct:(                  { * Least-Squares Function Body }
          lsqfnc_expr:     lsq_ptr;   { Function Expression }
          lsqfnc_formal:   rec_ptr    { Pointer to Formal Link }
        );

      nd_lsqfnc_call:(                { * Least-Squares Function Call }
          lsqcall_fnc:     lsq_ptr;   { Function to Call }
          lsqcall_parms:   rec_ptr    { Pointer to Effective Parameters }
        );

      nd_lsq_formal:(                 { * Least-Squares Function Formal Reference }
          lsqform_fnc:     lsq_ptr;   { Function Reference }
          lsqform_idx:     integer    { Formal Index }
        );

      nd_integr_loop,                 { * Integrator Operator }
      nd_integr_loop_d:(              { * Integrator Operator for Derv. }
          intgr_index:     lsq_ptr;   { Integration Variable }
          intgr_tabsz:     integer;   { Integration Table Size }
          intgr_coef:      rec_ptr;   { Integration Coefficient Table }
          intgr_expr:      lsq_ptr    { Expression to Summ }
        );
      nd_summ_loop,                   { * Loop Summation Operator }
      nd_summ_loop_d:(                { * Loop Summation Operator for Derv. }
          summ_begin,                 { Begin ... }
          summ_end,                   { ... End and ... }
          summ_step,                  { ... Step Value of Summ Function }
          summ_index,                 { Summation Control Index }
          summ_expr:       lsq_ptr;   { Expression to Summ }
        );

      nd_interpol,                    { * Interpolation Operator }
      nd_interpol_d:(                 { * Interpolation Operator for Derv. }
          inter_der:       lsq_real;  { Last Interpolation Partiel Derivate }
          inter_tbsz:      integer;   { Interpolation Table Size }
          inter_tab:       rec_ptr;   { Interpolation Table }
          inter_expr:      lsq_ptr    { Expression of x Value }
        );


      nd_konst:(                      { * Real Constant Value }
          cteval:          lsq_real   { The Real Value }
        );

      nd_index:(                      { * Summation Index }
          idx_next:        lsq_ptr;   { Link to Next Index }
          idx_ident:       integer;   { Index Identifier }
          idx_value:       lsq_real   { Index Current Value }
        );

      nd_varbl:(                      { * Least-Squares Variable }
          var_next,                   { Link to Next Variable }
          var_nxtbl:       lsq_ptr;   { Link to next var. in the Diag. block }
          var_name:        rec_ptr;   { Current Variable Identification }
          var_limits,                 { Variable Limits Pointer }
          var_diablk:      lsq_ptr;   { Link to the Related Diagonal Block }
          var_value,                  { Current Value }
          var_sigma:       lsq_real;  { Current Sigma }
          var_defblk,                 { Previous Diagonal Block Identifier (no Fixed) }
          var_vident,                 { Variable Identifier (integer) }
          var_matind:      integer;   { Matrix Index }
        );


      nd_limits:(                     { * Limits Block }
          lim_next:        lsq_ptr;   { Link to Next }
          lim_low,                    { Low Limit }
          lim_up:          lsq_real;  { Up Limit }
          lim_id,                     { Limit Identifier }
          lim_ct:          integer    { Limit use count }
        );


      nd_diablk:(                     { * Least-Squares Diagonal Block }
          blk_next:        lsq_ptr;   { Link to Next Diagonal Block }
          blk_name:        rec_ptr;   { Pointer to Related Identifier }
          blk_marqwc,                 { Marqward-Levenberg Coefficient Expression }
          blk_dmp,                    { Damping Factor Expression }
          blk_frsvar,                 { Pointer to the First Variable of Block }
          blk_lstvar:      lsq_ptr;   { Pointer to the Last Variable of the Block }
          blk_vect_b,                 { Constant Vector Pointer }
          blk_vect_x,                 { Shift Vector Pointer }
          blk_matrix:      vec_ptr;   { Diagonal Block Pointer }
          blk_vindex,                 { Variable Count Start Index }
          blk_bident:      integer;   { Identifier of This Diagonal Block }
          blk_effmarq,                { Last Value of the Marward-Levenberg Factor }
          blk_effdmp:      lsq_real   { Last Value of the Damping Factor }
        );



      nd_list:(                       { * Least-Squares List }
          lis_current,                { Current Element Pointer }
          lis_descriptor:  rec_ptr;   { External List Descriptor Pointer }
          lis_next:        lsq_ptr;   { Link to Next Defined List }
          lis_name:        rec_ptr;   { General Identificator Link }
          lis_count,                  { List Element Count }
          lis_lident,                 { Identifier of this List }
          lis_ident,                  { Offset of the Identifier Field }
          lis_cachesize:   integer;   { Size of the Related Cache }
          lis_cachefirst,             { List Header of Cache Block (first ... }
          lis_cachelast:   cache_ptr; { ... and last pointer }
          lis_stpcond,                { Stop List Scan Condition }
          lis_condit,                 { Select Element Condition Expression }
          lis_parlist,                { List of all Related Parameters }
          lis_dirlist:     lsq_ptr;   { List of Directives and
                                        Attached Parameters to Comput
                                        When the Current Element is Selected }
          lis_endflg:      boolean    { End List Scan Flag }
        );


      nd_collect:(                    { * Least-Squares Data Descriptor }
          coll_next:       lsq_ptr;   { Link to Next Selected Data }
          coll_name:       rec_ptr;   { Data Collection/Constaint Identifier }
          coll_list,                  { List Head of Collected List }
          coll_condit,                { Sentinel Expression }
          coll_computed,              { Computed Value List }
          coll_observed,              { Value }
          coll_sigma,                 { Sigma }
          coll_weight:     lsq_ptr;   { Static Weight }
          coll_statis:     statis_ptr;{ Statistic Block }
          coll_pckparm,               { List of Data Element Related Directives }
          coll_cyclparm,              { List of Cycle Related Directives }
          coll_pckdir,                { List of Data Element Related Directives }
          coll_cycldir:    lsq_ptr;   { List of Cycle Related Directives }
          coll_reject:     lsq_real;  { Limit Value to Reject an Observation }
          coll_enable:     boolean    { Flag to Enable/Disable the Data Coll. }
        );


            { *** All Node Usable as Directive *** }

      nd_parm:(                       { * Least-Squares Parameter }
                                      { *** warning not called par_next *** }
          lsq_next:        lsq_ptr;   { General Link }

          par_definition,             { Parameter Definition }
          par_next,                   { Link to Next Parameter }
          par_lsum:        lsq_ptr;   { Link to Next Parameter }
          par_value,                  { Current Value }
          par_sigma:       lsq_real;  { Current Sigma }
          par_name:        rec_ptr;   { Current Parameter Identifier }
          par_derddp:      ddp_ptr;   { Pointer to the DDP (or nil) }
          par_derlst:      drt_ptr;   { Pointer to the Related DRT (or nil) }
          par_dervec:      vec_ptr;   { Partial Derivate Vector Pointer }
          par_attlist:     lsq_ptr;   { Attached List when Defined }
          par_pident:      integer;   { Parameter Identifier }
          par_flags:       lsq_flgty  { Parameter Flags }
        );


      nd_scandir:(                    { * Scan a List Directive }
          sca_next,                   { General use of lsq_next at same place }
          sca_list,                   { List to Scan }
          sca_owner,                  { Parameter Owner List Pointer }
          sca_condit,                 { Condition to Continue the Scan }
          sca_endlist,                { Link to Next On the End of List }
          sca_dir:         lsq_ptr;   { List of the Directives }
          sca_invalid:     cache_ptr; { Pointer to the First Invalid in Window }
          sca_windowvalid,            { Number of Valid Elements }
          sca_windowuse:   integer;   { Used Size of Cache }
          sca_type:        scaf_types { Scan Kind }
        );

      nd_initlist:(                   { * Init a list scan Directive }
          init_next,                  { Next Pointer Place (name not used) }
          initlist_list:   lsq_ptr    { Pointer to the List to Initialize }
        );

      nd_storedir:(                   { * Store in Element Record Directive }
          sto_next,                   { Next pointer place (name not used) }
          sto_expr:        lsq_ptr;   { Expression to Store }
          case sto_subdir: lsq_nodetypes of { Sub-Directive Code }
            nd_ub_listref,            { set UBYTE field }
            nd_sb_listref,            { set SBYTE field }
            nd_uw_listref,            { set UWORD field }
            nd_sw_listref,            { set SWORD field }
            nd_li_listref,            { set INTEGER field }
            nd_fl_listref,            { set SINGLE float field }
            nd_db_listref:(           { set DOUBLE float field }
              sto_l_list:    lsq_ptr; { Constant Select List or Item }
              sto_l_offset:  integer  { Related Offset }
              );

            nd_ub_refer,              { set UBYTE field }
            nd_sb_refer,              { set SBYTE field }
            nd_uw_refer,              { set UWORD field }
            nd_sw_refer,              { set SWORD field }
            nd_li_refer,              { set INTEGER field }
            nd_fl_refer,              { set SINGLE float field }
            nd_db_refer:(             { set DOUBLE float field }
              sto_r_pointer: rec_ptr; { Direct Memory Pointer }
              sto_r_offset:  integer  { Related Offset }
              )
        );


      nd_ifdir:(                      { * IF <cond> Directive }
          if_next:         lsq_ptr;   { Next Pointer Place (name not used) }
          if_expr,                    { Condition Expression Pointer }
          if_truenext,                { Continue if True }
          if_falsenext:    lsq_ptr;   { Continue if False }
          if_vflag:        boolean    { Last IF Condition State }
        );


      nd_casedir:(                    { * Case Directive }
          case_next,                  { Next Pointer Place (name not used) }
          case_cursel,                { Current Selection }
          case_selector,              { Selector Expression }
          case_other:      lsq_ptr;   { Work to Perform if Otherwise }
          case_table:      drt_ptr;   { Table Pointer of Choices }
          case_min:        integer    { Selector Table Limits }
        );

      nd_user_call:(                  { * User Procedure call }
          user_next:       lsq_ptr;   { Next pointer place (name not used) }
          usercall_id:     integer;   { User Call Function Identifier }
          usercall_parm:   rec_ptr    { User Call Parameter }
        )                      

  end;





  {*********************************************}
  {**** Least-Squares Statistic Definitions ****}
  {*********************************************}


  statis_rec = record                 { * Statistic Record }
    stat_usrchi2,                     { User defined Squared Goodness of Fit }
    stat_stdchi2,                     { Standard Squared Goodness of Fit }
    stat_sumstd,                      { Sum ( sqr(delta/sigma ) }
    stat_surwsqr,                     { Sum ( sqr(delta*weight)) }
    stat_sursqr,                      { Sum ( sqr(delta)) }
    stat_surwabs,                     { Sum ( abs(delta*weight)) }
    stat_surabs,                      { Sum ( abs(delta)) }
    stat_suowsqr,                     { Sum ( sqr(obser*weight)) }
    stat_suosqr,                      { Sum ( sqr(obser)) }
    stat_suowabs,                     { Sum ( abs(obser*weight)) }
    stat_suoabs:           lsq_real;  { Sum ( abs(obser)) }
    stat_obsnb:            integer    { Partial Count of Really Used Obs. }
  end;

  


  {*******************************************}
  {**** Least-Squares Vectors Definitions ****}
  {*******************************************}

  vec_tab( v_size: integer ) = array[1..v_size] of lsq_real; { Define a Matrix Vector }



  {**************************************************}
  {**** Partial Derivate Block definitions (PDB) ****}
  {**************************************************}

  ddp_kinds = (                       { * Definition of Derivate Kinds }
      ddp_direct,                     { To flag a Pure Direct Derivation }
      ddp_mixte                       { To flag a Mixte Directive }
    );

  ddp_entry = record                  { * Derivate Directory Process entry }
    case ddp_kind: ddp_kinds of       { direct/Indirect Flag }
      ddp_direct:( ddp_drt: integer); { For Direct Derivate Index in the DRT }
      ddp_mixte: ( ddp_sbp: lsq_ptr)  { For Sub-Parameter Derivation }
  end;

  ddp_tab( ddp_size: integer ) =      { * Derivate Directory Process table }
    array[1..ddp_size] of ddp_entry;

  drt_tab( drt_size: integer ) =      { * Derivate Reference Table }
    array[1..drt_size] of lsq_ptr;



  {*******************************************}
  {****  Least-Squares Cache Definitions  ****}
  {*******************************************}

  cache_rec = record                  { * Cache Record }
    cache_previous,                   { Link to previous Cache Record }
    cache_next:            cache_ptr; { Link to Next Cache Record }
    cache_ident:           integer;   { Identifier for Cache Selection }
    cache_entry:           entry_ptr  { List Head for Cache Entry }
  end;

  entry_rec = record                  { * Cache Entry (one for each vparm) }
    entry_par:             lsq_ptr;   { The Parameter Pointer }
    entry_val:             lsq_real;  { The Parameter Value }
    entry_table:           vec_ptr;   { Pointer to the Related Derivate Vector }
    entry_next:            entry_ptr  { Link to Next Parameter Entry }
  end;





  {************************************}
  {**** Loader Object Definitions  ****}
  {************************************}



  stkp_typ = 0..stack_max;            { Stack Pointer Index Type }


  define_rec = record                 { Exec Definition Stack Element }
    owner_obj,                        { Owner of Directive List }
    first_par,                        { First and Last Parameter Pointer ... }
    first_dir,                        { First Directive }
    last_dir:              lsq_ptr;   { Last Directive }
    cachepcnt,                        { List caching count }
    condition:             integer;   { Condition Value }
    cacheflag:             boolean    { Flag for Cache Support Enable }
  end;

{-----------------------------------------------------------------------------------}




           {****************************************}
           { *** User supply function/procedure *** }
           {****************************************}


procedure LSQUSR_ERROR(       err_nb,
                              sev: integer;
                              ptr: lsq_ptr );
external;


procedure LSQUSR_REFER_ID(    ptr: lsq_ptr );
external;


procedure LSQUSR_SINGULARITY( cvar:        lsq_ptr;
                              nfail:       integer;
                              singovf_flg: boolean );
external;


function LSQUSR_FUNCTION(     ident:       integer;
                              parm:        rec_ptr   ): lsq_real; external;


procedure LSQUSR_PROCEDURE(   ident:       integer;
                              parm:        rec_ptr   ); external;


procedure LSQUSR_VARIABLE(    cvar:        lsq_ptr;
                              newval,
                              sig,
                              shift:       lsq_real;
                              lflg:        integer;
                              begin_flg,
                              final_flg:   boolean );
external;

procedure LSQUSR_CORRELATION( pblk:        lsq_ptr;
                              dim:         integer );
external;

procedure LSQUSR_CYCL_START(  ncycl:       integer;
                              final_flg:   boolean );
external;

procedure LSQUSR_CYCL_RES(    ncycl:       integer );
external;

procedure LSQUSR_CYCL_END(    ncycl:       integer );
external;

procedure LSQUSR_COLL_START(  coll:        lsq_ptr );
external;

procedure LSQUSR_COLL_END(    coll:        lsq_ptr );
external;

procedure LSQUSR_COLL_CONTRIBUTION
                            ( coll:        lsq_ptr;
                              ncontr,
                              nobs:        integer;
                              cndflg:      boolean );
external;


procedure LSQUSR_COLL_PACKET( coll:        lsq_ptr;
                              nobs:        integer;
                              obs,
                              calc,
                              delta,
                              sigma,
                              weight,
                              delssig:     lsq_real;
                              regflg:      boolean );
external;



procedure LSQUSR_CONSTRAINT(  coll:        lsq_ptr;
                              obs,
                              calc,
                              delta,
                              sigma,
                              weight,
                              delssig:     lsq_real;
                              regflg:      boolean );
external;



procedure LSQUSR_END_FIT;
external;




function LSQUSR_LIST_OPEN(    lis:         lsq_ptr ): boolean;
external;


function LSQUSR_LIST_NEXT(    lis:         lsq_ptr ): boolean;
external;


procedure LSQUSR_LIST_CLOSE(  lis:         lsq_ptr );
external;



           {******************************}
           { *** Our global functions *** }
           {******************************}




procedure LSQ_ALLOCATE_DDP( var pddp: ddp_ptr; dim: integer );
external;


procedure LSQ_ALLOCATE_DRT( var pdrt: drt_ptr; dim: integer );
external;


procedure LSQ_ALLOCATE_VEC( var pvec: vec_ptr; dim: integer );
external;


function LSQ_GETREF( p: lsq_ptr ): lsq_obj;
external;


function LSQ_VALUE( p: lsq_ptr ): lsq_real;
external;

procedure LSQ_CONSTRAINT( lf: lsq_ptr );
external;

procedure LSQ_COLLECT( lf: lsq_ptr );
external;

procedure LSQ_CYCLE( final_flg: boolean );
external;

procedure LSQ_FIT( n_cycle,          { Number of cycle to perform }
                   cycle_id,         { First cycle number }
                   maxsing: integer; { Maximum of singularity/cycle }
                   mindiag: lsq_real;{ Minimum of matrix pivot }
                   ls_bmatrix,       { Flag to suppress matrix comp.}
                   ls_noendcycle,    { Flag to disable final cycle }
                   ls_correl,        { Flag for correlation comp.}
                   ls_vchi2: boolean { Flag for no varbl number depend goodness of fit }
                 );
external;

procedure LSQ_INIT_STRUCTURE;
external;


procedure LSQ_FREE_STRUCTURE;
external;




{**********************************************************}
{************   Loader Procedures and functions ***********}
{**********************************************************}


procedure LSQ_PUSH( obj: eqv_type );
external;

procedure LSQ_LSPUSH( p: lsq_ptr );
external;

procedure LSQ_RECPUSH( p: rec_ptr );
external;

procedure LSQ_NULL_PUSH;
external;

procedure LSQ_IPUSH( int: integer );
external;

procedure LSQ_RPUSH( v: lsq_real );
external;

procedure LSQ_C_KONST( v: lsq_real );
external;

function LSQ_POP: lsq_ptr;
external;

procedure LSQ_ELSE;
external;

procedure LSQ_ENDIF;
external;

procedure LSQ_WHEN;
external;

procedure LSQ_ENDCASE;
external;

function LSQ_C_CASETABLE( min, max: integer; oth: lsq_ptr ): lsq_ptr;
external;

procedure LSQ_OPER( ndty: lsq_nodetypes );
external;

procedure LSQ_FREE_EXPR( p: lsq_ptr );
external;

function LSQ_S_LINDEX( id: integer ): lsq_ptr;
external;

function LSQ_S_LIMITS( id: integer ): lsq_ptr;
external;

function LSQ_S_DIABLK( id: integer ): lsq_ptr;
external;

function LSQ_S_VARBL( id: integer ): lsq_ptr;
external;

function LSQ_S_PARM( id: integer ): lsq_ptr;
external;

function LSQ_S_LIST( id: integer ): lsq_ptr;
external;

procedure LSQ_RF_LINDEX( id: integer );
external;

procedure LSQ_RF_VARBL( id: integer );
external;

procedure LSQ_RF_PARM( id: integer );
external;

procedure LSQ_RF_LIST( id: integer );
external;

procedure LSQ_C_DIABLK( nam: rec_ptr; id: integer );
external;

procedure LSQ_OP_DIABLK( id: integer );
external;

procedure LSQ_C_LIMITS( id: integer; inf, sup: lsq_real );
external;

procedure LSQ_C_LINDEX( id: integer );
external;

procedure LSQ_C_VARBL( nam: rec_ptr; val, sig: lsq_real; id, lim: integer );
external;

procedure LSQ_CH_DIABLK( pv, pb: lsq_ptr );
external;

procedure LSQ_FIX_VARBL( pv: lsq_ptr );
external;


procedure LSQ_UNFIX_VARBL( pv: lsq_ptr );
external;


procedure NEW_CONTEXT( owner: lsq_ptr );
external;

procedure LSQ_C_PARM( nam: rec_ptr; id: integer;
                      sum_flg, der_flg, sig_flg, cach_flg: boolean );
{ To create a variable parameter }
external;

procedure LSQ_S_PARMFLAGS( pa: lsq_ptr;
                           sum_flg, der_flg, sig_flg: boolean );
external;

procedure LSQ_C_LIST( nam: rec_ptr; id, cache_size, idoff: integer );
{ Create a fit list descriptor and open the related parameter list }
external;

procedure LSQ_C_COLLECT( nam: rec_ptr; pli: lsq_ptr );
{ Create a Data Collection Descriptor Specified Lsq List pli. }
external;

procedure LSQ_IF;
external;

procedure LSQ_CASE;
external;

function LSQ_END( prv_flg: boolean ): boolean;
external;

procedure LSQ_EXEC_DIR( ndty: lsq_nodetypes );
{ To create some ordinary directives (if/case/print/plot/store/usercall) }
external;


procedure LSQ_SCANDIR( pli: lsq_ptr; mode: scaf_types );
{ To create a scan list directive }
external;

procedure LSQ_INIT_LSQ;
{ To initialize the LSQ Loader }
external;

{  * * * * End Of Constant, Type and global procedures definition file  * * * *  }
