{
******************************************************************
*                                                                *
*                                                                *
*                                                                *
*                                                                *
*    * *  L E A S T - S Q U A R E S   P R O C E S S O R  * *     *
*                                                                *
*                                                                *
*                                                                *
*        ---  TYPES DEFINITIONS PASCAL FILE MODULE   ---         *
*                                                                *
*                                                                *
*       by :                                                     *
*                                                                *
*           P. Wolfers                                           *
*               c.n.r.s.                                         *
*               Laboratoire de Cristallographie                  *
*               B.P.  166 X   38042  Grenoble Cedex              *
*                                       FRANCE.                  *
*                                                                *
******************************************************************
}


{  Version 1.2-B (or Upper)  of  L S Q  System  }
{************    CPAS  Version   ***************}
{
        *** modification(s) from major version ***


			----

		       nothing

			----

}
module LSQ_LOADER;

%include 'pasenv:cpas_b__lst_env';    { We load the LST Environment File }
%include 'lispsrc:lisp_block_env';    { We load the mem. rec. Env. File }
%include 'lispsrc:lsq_global_def';    { We load the LSQ Environment File }


var
  frs_intgr_sum,                      { First and Last Queue for Integr/summ ... }
  lst_intgr_sum: [static] lsq_ptr := nil; { Special parameter list }



procedure LSQ_DSPLTREE( p: lsq_ptr );
external;


function NEW_STATIS_BLK: statis_ptr;
{ To Create a Statistic Block }
var
 p: statis_ptr;

begin
  NEW( p );
  with p^ do
  begin
    stat_usrchi2  := 0.0;
    stat_stdchi2  := 0.0;
    stat_sumstd   := 0.0;
    stat_surwsqr  := 0.0;
    stat_sursqr   := 0.0;
    stat_surwabs  := 0.0;
    stat_surabs   := 0.0;
    stat_suowsqr  := 0.0;
    stat_suosqr   := 0.0;
    stat_suowabs  := 0.0;
    stat_suoabs   := 0.0;
    stat_obsnb    := 0
  end;
  NEW_STATIS_BLK := p
end NEW_STATIS_BLK;



[global]
procedure NEW_CONTEXT( owner: lsq_ptr );
{ To Create a New LSQ Context }
begin
  if define_current < define_max then
  begin
    define_current := define_current + 1;
    with define_scope[define_current] do
    begin
      cacheflag := false;     { By default, no cache }
      cachepcnt := 0;         { Set to no caching parameter }
      condition := 0;         { Set at normal condition mode }
      owner_obj := owner;     { Set owner link }
      first_par := nil;       { First and Last Parameter Pointer ... }
      first_dir := nil;       { ... set the List of Directive to ... }
      last_dir  := nil        { ... the Empty State }
    end
  end
  else
    LSQUSR_ERROR( 11, 4, nil )
end NEW_CONTEXT;



[global]
procedure LSQ_PUSH( obj: eqv_type );
{ To Push a LSQ object in the LSQ Loader Stack }
begin
  if stkp > stack_max then
    LSQUSR_ERROR( 15, 4, nil )
  else
  begin
    stkp := stkp + 1; stk[stkp] := obj
  end
end LSQ_PUSH;



[global]
procedure LSQ_LSPUSH( p: lsq_ptr );
{ To Push a LSQ node in the LSQ Loader Stack }
var
  eq: eqv_type;

begin
  eq.lsq := p;
  LSQ_PUSH( eq )
end LSQ_LSPUSH;



[global]
procedure LSQ_RECPUSH( p: rec_ptr );
{ To Push a Record in the LSQ Loader Stack }
var
  eq: eqv_type;

begin
  eq.rec := p;
  LSQ_PUSH( eq )
end LSQ_RECPUSH;



[global]
procedure LSQ_NULL_PUSH;
{ To Push a Null Node in the LSQ Loader Stack }
var
  eq: eqv_type;

begin
  eq.lsq := nil;
  LSQ_PUSH( eq )
end LSQ_NULL_PUSH;



[global]
procedure LSQ_IPUSH( int: integer );
{ To Push an Integer Value in the LSQ Loader Stack }
var
  eq: eqv_type;

begin
  eq.int := int;
  LSQ_PUSH( eq )
end LSQ_IPUSH;



[global]
procedure LSQ_RPUSH( v: lsq_real );
{ To Push a real value the LSQ Loader Stack }
var
  eq: eqv_type;

begin
  eq.flt := v;
  LSQ_PUSH( eq )
end LSQ_RPUSH;



[global]
procedure LSQ_C_KONST( v: lsq_real );
{ To Push a LSQ Constant Node in the LSQ Loader Stack }
begin
  NEW( tree.lsq, nd_konst );
  with tree.lsq^ do
  begin
    lsq_ndty := nd_konst;
    cteval := v
  end;
  LSQ_PUSH( tree )
end LSQ_C_KONST;



function MSTACK: eqv_type;
{ To get the LSQ Stack Top object }
begin
  if stkp < 1 then LSQUSR_ERROR( 16, 4, nil )
              else MSTACK := stk[stkp]
end MSTACK;



function STACK: lsq_ptr;
{ To Get the LSQ Top Stack Object }
var
  eq: eqv_type;

begin
  eq := MSTACK;
  STACK := eq.lsq
end STACK;



function MPOP: eqv_type;
{ To Get and remove (= POP) an Object from the top of LSQ Stack }
begin
  if stkp < 1 then
    LSQUSR_ERROR( 16, 4, nil )
  else
  begin
    MPOP := stk[stkp];
    stkp := stkp - 1
  end
end MPOP;



[global]
function LSQ_POP: lsq_ptr;
{ To POP a LSQ Node Reference }
var
  eq: eqv_type;

begin
  eq := MPOP;
  LSQ_POP := eq.lsq
end LSQ_POP;



function REC_POP: rec_ptr;
{ To POP a Record Reference }
var
  eq: eqv_type;

begin
  eq := MPOP;
  REC_POP := eq.rec
end REC_POP;



function IPOP: integer;
{ To POP an integer Value }
var
  eq: eqv_type;

begin
  eq := MPOP;
  IPOP := eq.int
end IPOP;



function RPOP: lsq_real;
{ To POP a Real Value }
var
  eq: eqv_type;

begin
  eq := MPOP;
  RPOP := eq.flt
end RPOP;



[global]
procedure LSQ_BEGIN_SEQ( dir: lsq_ptr );
{ To Push the Current Context in the LSQ Stack }
begin
  with define_scope[define_current] do
  begin
    LSQ_LSPUSH( first_dir );
    LSQ_LSPUSH( last_dir );
    LSQ_LSPUSH( dir );
    first_dir := nil;
    last_dir  := nil
  end
end LSQ_BEGIN_SEQ;



procedure APPEND_EXEC( p: lsq_ptr );
{ To append an LSQ EXEC Directive to the Current Context }
begin
  with define_scope[ define_current ] do
  begin
    if last_dir = nil then first_dir := p
                      else last_dir^.lsq_next := p;
    last_dir := p;
    p^.lsq_next := nil
  end
end APPEND_EXEC;



function LSQ_IF_PROCESS( dir_flg: boolean ): lsq_ptr;
{ Build a LSQ IF Node/Directive }
{ Use as :
  1/ For Expression :
     < logical_expr>
     <true_expr>
     <false_expr>
     LSQ_OPER( nd_ifdir );

  2/ For Directive :
     < logical_expr>
     LSQ_IF;
     < sequence for true case >
       [ LSQ_ELSE;
         < sequence for false case > ]
     LSQ_ENDIF;

}
var
  p: lsq_ptr;

begin
  NEW( p, nd_ifdir );
  with p^ do
  begin
    lsq_ndty := nd_ifdir;
    lsq_next := nil;
    if_vflag := true;
    if dir_flg then
    begin
      if_truenext  := nil;
      if_falsenext := nil
    end
    else
    begin
      if_falsenext := LSQ_POP;
     if_truenext   := LSQ_POP
    end;
    if_expr  := LSQ_POP
  end;
  if dir_flg then LSQ_BEGIN_SEQ( p ); { Start a new Directive Sequence }
  LSQ_IF_PROCESS := p
end LSQ_IF_PROCESS;



[global]
procedure LSQ_ELSE;
{ To generate an LSQ IF related ELSE part Node/Directive }
var
  p: lsq_ptr;

begin
  p := STACK;
  with p^, define_scope[define_current] do
  begin
    if_truenext := first_dir;
    if_vflag    := false;
    first_dir   := nil;
    last_dir    := nil
  end
end LSQ_ELSE;



[global]
procedure LSQ_ENDIF;
{ To generate an LSQ IF related END_IF part Node/Directive }
var
  p: lsq_ptr;

begin
  p := LSQ_POP;
  with p^, define_scope[define_current] do
  begin
    if if_vflag then if_truenext := first_dir
                else if_falsenext := first_dir;
    last_dir  := LSQ_POP;
    first_dir := LSQ_POP
  end;
  APPEND_EXEC( p )
end LSQ_ENDIF;



procedure LSQ_CASE_PROCESS( dir_flg: boolean );
{ To Generate a LSQ Case Node/Directive in the Current Context }
{ Use as:
  < selector_expr >
  for directive : LSQ_CASE_DIR / for expression : LSQ_OPER( nd_casedir );

  and for each alternate sequence/expression :

  LSQ_IPUSH( lab1 ); ... LSQ_IPUSH( lab_n );
  <sequence/expression>
  LSQ_WHEN;

  [<otherwise (sequence/expression)>]
  LSQ_ENDCASE;
}
var
  p:  lsq_ptr;
  i:  integer;

begin
  NEW( p, nd_casedir );
  with p^ do
  begin
    lsq_ndty       := nd_casedir;
    lsq_next       := nil;
    case_selector  := LSQ_POP;        { Get the selector expression }
    case_cursel    := nil;
    if dir_flg then case_cursel  := p
               else case_cursel  := nil;  { Mark the directive/fnc mode }
    case_other     := nil;
    { Create and Erase a Temporary case table }
    NEW( case_table, 2 * lsq_maxcase );
    for i := 1 to case_table^.drt_size do  case_table^[i] := nil
  end;
  LSQ_IPUSH( top_case );              { Push the old top case index }
  if dir_flg then LSQ_BEGIN_SEQ( p )  { Start a new directive sequence }
             else LSQ_LSPUSH( p );    { else push the case node only }
  LSQ_IPUSH( 0 );                     { Set the Initiale Case Table Size }
  top_case := stkp                    { Set the new top case index }
end LSQ_CASE_PROCESS;




[global]
procedure LSQ_WHEN;
{ WHEN LSQ CASE Sub-Node/Sub-Directive }
{
  Use as :
  LSQ_IPUSH( lab1 );
  .................
  LSQ_IPUSH( labn );
  < sequence / expression >
  LSQ_WHEN;
}
var
  eq:       eqv_type;
  seq, p:   lsq_ptr;
  iv, jv:   integer;
  dir_flg:  boolean;

begin
  if (top_case < 3) or (stkp <= top_case) then
    LSQUSR_ERROR( 17, 4, nil )
  else
  begin
    p := stk[top_case - 1].lsq;
    with p^ do
    begin
      if case_cursel <> nil then      { Directive mode }
        with define_scope[define_current] do
        begin
          seq := first_dir;           { Get the alternate sequence ... }
          { ... and release the directive context }
          first_dir := nil;
          last_dir  := nil
        end
      else                            { Expression mode }
        seq := LSQ_POP;               { Get the alternate expression }
      { Scan on all labels }
      while stkp > top_case do
      begin
        iv := IPOP;                   { Get a label value }
        if stk[top_case].int = 0 then { First label of this case }
        begin
          case_min   := iv;           { Initialize case_min }
          jv         := iv;           { ... and the maximum value }
          stk[top_case].int := 1;     { ... and the case table size to 1 }
                                      { First value at the Middle of Temporary table }
          eq.int     := 1 + lsq_maxcase - iv;
          case_other := eq.lsq        { Save shift value }
        end
        else
        begin
          jv := stk[top_case].int + case_min - 1;
          if iv < case_min then case_min := iv
                           else if iv > jv then jv := iv;
          stk[top_case].int := jv - case_min + 1  { Size the new size of the case table}
        end;
        eq.lsq      := case_other;    { Get the shift value }
        iv          := iv + eq.int;   { Compute the sequence address }
        if (iv < 1) or (iv > 2 * lsq_maxcase) then
          LSQUSR_ERROR( 21, 4, nil )  { Too large selector range error }
        else
        begin
          if case_table^[iv] <> nil then  { Already present label error }
            LSQUSR_ERROR( 22, 4, nil )
          else
            case_table^[iv] := seq    { Set the sequence in place }
        end
      end
    end
  end
end LSQ_WHEN;




[global]
procedure LSQ_ENDCASE;
{ END_CASE LSQ CASE Sub-Node/Sub-Directive }
var
  eq:         eqv_type;
  seq, p:     lsq_ptr;
  p1:         drt_ptr;
  i, j, k, l: integer;

begin
  if (top_case < 3) or (stkp < top_case) then
    LSQUSR_ERROR( 17, 4, nil )
  else
  begin
    l := stk[top_case].int;           { Get the Case Table Size to Build }
    p := stk[top_case - 1].lsq;       { Get the Case Node Pointer }
    with p^ do
    begin
      if case_cursel <> nil then      { Directive Mode }
        with define_scope[define_current] do
        begin { Get the otherwise sequence }
          seq  := define_scope[define_current].first_dir;
          stkp := top_case - 2;       { Remove the case node reference }
          last_dir  := LSQ_POP;       { Restore the original context }
          first_dir := LSQ_POP;
          { For the Case Directive the Case Node Must be Append in the Dir. List }
          APPEND_EXEC( p )
        end
      else
      begin                           { Operator Node Mode }
        seq   := LSQ_POP;             { Get the otherwise expression ... }
        stkp  := top_case - 2;        { Remove the case node reference }
        tree.lsq := p;                { Keep the node pointer to build the tree }
        LSQ_PUSH( tree )
      end;
      top_case := IPOP;               { Restore the Previous Case Context Pointer }

      { Now, we set (for use ) the Case node and Related New Case Table }
      p1 := case_table;               { Get the temporary case table address }
      NEW( case_table, l );           { Allocate the final case table }
      eq.lsq := case_other;           { Get the temporary table shift }
      j := eq.int + case_min;         { Compute the base of tmp table }
      for k := 1 to l do
      begin
        if p1^[j] = nil then          { When the element is nil ... }
          case_table^[k] := seq       { ... then set the related function }
        else
          case_table^[k] := p1^[j];   { ... else the otherwise one }
        j := j + 1
      end;
      DISPOSE( p1 );                  { Free the Temporary Case Table }
      case_min := case_min - 1;       { Adjust min for start array index at 1 }
      case_other  := seq;             { Set the Otherwise Sequence }
      case_cursel := seq              { Set Default Way to Otherwise }
    end
  end
end LSQ_ENDCASE;



[global]
function LSQ_C_CASETABLE( min, max: integer; oth: lsq_ptr ): lsq_ptr;
{ Create a Case Table and Fill it With the Other Pointer }
var
  i:  integer;
  p:  lsq_ptr;
  eq: eqv_type;

begin
  if max < min then max := min;
  NEW( p, nd_casedir );
  with p^ do
  begin
    lsq_ndty      := nd_casedir;      { Set the record field }
    lsq_next      := nil;             { Set the next statement field }
    case_min      := min - 1;         { Set the min value }
    case_other    := oth;             { Set the otherwise alternate }
    case_selector := LSQ_POP;         { Get the selector expression }
    { create the case table }
    NEW( case_table, max - min + 1 );
    for i := 1 to max - min + 1 do
      case_table^[i] := oth
  end;
  tree.lsq := p;
  LSQ_PUSH( tree );
  LSQ_C_CASETABLE := p
end LSQ_C_CASETABLE;



function USERCALL_PROCESS: lsq_ptr;
{ Create a USERCALL Directive }
var
  p: lsq_ptr;
{ Use as :
     LSQ_IPUSH( fnc_index );
     <parameter_area>
     LSQ_OPER( nd_user_call ) / LSQ_EXEC_DIR( nd_user_call )

}

begin
  NEW( p, nd_user_call );
  with p^ do
  begin
    lsq_ndty := nd_user_call;
    lsq_next := nil;
    usercall_parm := REC_POP;
    usercall_id := IPOP
  end;
  USERCALL_PROCESS := p
end USERCALL_PROCESS;



function LSQ_C_SPC_PARM( own: lsq_ptr ): lsq_ptr;
var
  p, p1: lsq_ptr;

begin
  NEW( p, nd_parm );                  { Create the Special Sub Parameter }
  { Link it in the parameter list }
  if fit_parfirst = nil then fit_parfirst := p
                        else fit_parlast^.par_next := p;
  fit_parlast := p;
  { Link to Special Integration/Summation list }
  if frs_intgr_sum = nil then frs_intgr_sum := p
                         else lst_intgr_sum^.par_next := p;
  lst_intgr_sum := p;

  { Init the Parameter structure }
  with p^ do
  begin
    lsq_ndty       := nd_parm;
    par_name       :=     nil;
    par_next       :=     nil;
    par_lsum       :=     nil;
    par_value      :=     0.0;
    par_sigma      :=     0.0;
    par_definition := LSQ_POP;        { Get the expression to summ }
    par_derddp     :=     nil;
    par_derlst     :=     nil;
    par_dervec     :=     nil;
    par_attlist    :=     own;        { The summ/integr node is the owner }
    par_pident     :=      -1;
    par_flags      := [parf_derivate,parf_summ]
  end;

  LSQ_C_SPC_PARM := p
end LSQ_C_SPC_PARM;



[global]
procedure LSQ_OPER( ndty: lsq_nodetypes );
{ Create an Operating Node }
var
  p: lsq_ptr;

begin
  case ndty of

    nd_not,
    nd_neg,     nd_round,   nd_trunc,   nd_abs,     nd_sqrt,
    nd_log,     nd_exp,
    nd_sinh,    nd_cosh,    nd_tanh,    nd_asinh,   nd_acosh,   nd_atanh,
    nd_sin,     nd_cos,     nd_tan,     nd_asin,    nd_acos,    nd_atan,
    nd_dsin,    nd_dcos,    nd_dtan,    nd_adsin,   nd_adcos,   nd_adtan:
      begin { * Unary Operators }
        NEW( p, nd_neg );
        with p^ do
        begin
          lsq_ndty := ndty;
          suna     := LSQ_POP
        end
      end;

    nd_abs_d,   nd_sqrt_d,
    nd_log_d,   nd_exp_d,
    nd_sinh_d,  nd_cosh_d,  nd_tanh_d,  nd_asinh_d, nd_acosh_d, nd_atanh_d,
    nd_sin_d,   nd_cos_d,   nd_tan_d,   nd_asin_d,  nd_acos_d,  nd_atan_d,
    nd_dsin_d,  nd_dcos_d,  nd_dtan_d,  nd_adsin_d, nd_adcos_d, nd_adtan_d:
      begin { * Unary Operators with derv. }
        NEW( p, nd_abs_d );
        with p^ do
        begin
          lsq_ndty := ndty;
          cuna     := LSQ_POP;
          vuna     := 0.0
        end
      end;

    nd_ipw,     nd_bess1:
      begin
        NEW( p, nd_ipw );
        with p^ do
        begin
          lsq_ndty := ndty;
          sindex   := IPOP;
          spuna    := LSQ_POP
        end
      end;

    nd_ipw_d,   nd_bess1_d:
      begin
        NEW( p, nd_ipw_d );
        with p^ do
        begin
          lsq_ndty := ndty;
          xindex   := IPOP;
          xpuna    := LSQ_POP;
          xvuna    := 0.0
        end
      end;

    nd_and,     nd_or,
    nd_add,     nd_sub,     nd_mul,     nd_div,     nd_pow,     nd_phase,
    nd_dphase,  nd_eq,      nd_ne,      nd_lt,      nd_le,      nd_ge,
    nd_gt,      nd_mod,     nd_rem:
      begin { * Binary Operators }
        NEW( p, nd_add );
        with p^ do
        begin
          lsq_ndty := ndty;
          sbin2    := LSQ_POP;
          sbin1    := LSQ_POP
        end
      end;

    nd_mul_d,   nd_div_d,   nd_pow_d,   nd_phase_d, nd_dphase_d:
      begin { * Binary Operators with Drev. }
        NEW( p, nd_mul_d );
        with p^ do
        begin
          lsq_ndty := ndty;
          cbin2 := LSQ_POP;
          cbin1 := LSQ_POP;
          vbin1 := 0.0;
          vbin2 := 0.0
        end
      end;

    nd_ub_listref,          nd_sb_listref,          nd_uw_listref,
    nd_sw_listref,          nd_li_listref,          nd_fl_listref,
    nd_listref:
      begin { * List ref. Operators }
        NEW( p, nd_ub_listref );
        with p^ do
        begin
          lsq_ndty    := ndty;
          lref_offset := IPOP;
          lref_list   := LSQ_POP
        end
      end;

    nd_ub_refer,            nd_sb_refer,            nd_uw_refer,
    nd_sw_refer,            nd_li_refer,            nd_fl_refer,
    nd_refer:
      begin { * List ref. Operators }
        NEW( p, nd_ub_refer );
        with p^ do
        begin
          lsq_ndty    := ndty;
          ref_offset  := IPOP;
          ref_pointer := REC_POP
        end
      end;

    nd_integr_loop:                   { * Integration Operator }
      begin
        NEW( p, nd_integr_loop );
        with p^ do
        begin
          intgr_expr  := LSQ_POP;     { Get the expression to summ }
          intgr_coef  := REC_POP;     { Get the gauss coefficient table }
          intgr_tabsz := IPOP;        { Get the integration table size }
          intgr_index := LSQ_POP      { Get the index reference }
        end
      end;

    nd_integr_loop_d:                 { * Derivable Integration Operator }
      begin
        NEW( p, nd_integr_loop_d );
        with p^ do
        begin
          lsq_ndty    := ndty;
          intgr_expr  := LSQ_C_SPC_PARM( p );
          intgr_coef  := REC_POP;     { Get the gauss coefficient table }
          intgr_tabsz := IPOP;        { Get the integration table size }
          intgr_index := LSQ_POP      { Get the index reference }
        end
      end;

    nd_summ_loop:                     { * Loop Summation Operator }
      begin
        NEW( p, nd_summ_loop );
        with p^ do
        begin
          lsq_ndty   := ndty;
          summ_expr  := LSQ_POP;      { Get the expression }
          summ_step  := LSQ_POP;      { Get the step expression value }
          summ_end   := LSQ_POP;      { Get the end expression value }
          summ_begin := LSQ_POP;      { Get the start expression value }
          summ_index := LSQ_POP       { Get the index reference }
        end
      end;

    nd_summ_loop_d:                   { * Loop Summation Operator for Derv. }
      begin
        NEW( p, nd_summ_loop_d );
        with p^ do
        begin
          lsq_ndty    := ndty;
          intgr_expr  := LSQ_C_SPC_PARM( p );
          summ_step   := LSQ_POP;     { Get the step expression value }
          summ_end    := LSQ_POP;     { Get the end expression value }
          summ_begin  := LSQ_POP;     { Get the start expression value }
          summ_index  := LSQ_POP      { Get the index reference }
        end
      end;

    nd_interpol,                      { * Interpolation Operator }
    nd_interpol_d:                    { * Interpolation Operator for Derv. }
      begin
        NEW( p, nd_interpol_d );
        with p^ do
        begin
          lsq_ndty    := ndty;
          inter_expr  := LSQ_POP;     { Get the x expression }
          inter_tab   := REC_POP;     { Get the interpolation table }
          inter_tbsz  := IPOP;        { Get the table size }
          inter_der   := 0.0          { Init the interpolation derivation }
        end
      end;

    nd_konst:                         { * Real Constant Value }
      begin { Constant value }
        NEW( p, nd_konst );
        with p^ do
        begin
          lsq_ndty := ndty;
          cteval   := RPOP
        end
      end;


    nd_ifdir:     p := LSQ_IF_PROCESS( false );

    nd_casedir:   LSQ_CASE_PROCESS( false );

    nd_user_call: p := USERCALL_PROCESS;

  otherwise
    LSQUSR_ERROR( 23, 4, nil )
  end;
  { Do not the PUSH for a case because it is performed by LSQ_ENDCASE }
  if ndty <> nd_casedir then
  begin
    tree.lsq := p;
    LSQ_PUSH( tree )
  end
end LSQ_OPER;



[global]
procedure LSQ_FREE_EXPR( p: lsq_ptr );
{ Free the node(s) of a given expression }
begin
  if p <> nil then
  with p^ do
  case lsq_ndty of

    nd_not,
    nd_neg,     nd_round,   nd_trunc,   nd_abs,     nd_sqrt,
    nd_log,     nd_exp,
    nd_sinh,    nd_cosh,    nd_tanh,    nd_asinh,   nd_acosh,   nd_atanh,
    nd_sin,     nd_cos,     nd_tan,     nd_asin,    nd_acos,    nd_atan,
    nd_dsin,    nd_dcos,    nd_dtan,    nd_adsin,   nd_adcos,   nd_adtan: 
      begin { * Unary Operators }
        LSQ_FREE_EXPR( suna );
        DISPOSE( p )
      end;

    nd_abs_d,   nd_sqrt_d,
    nd_log_d,   nd_exp_d,
    nd_sinh_d,  nd_cosh_d,  nd_tanh_d,  nd_asinh_d, nd_acosh_d, nd_atanh_d,
    nd_sin_d,   nd_cos_d,   nd_tan_d,   nd_asin_d,  nd_acos_d,  nd_atan_d,
    nd_dsin_d,  nd_dcos_d,  nd_dtan_d,  nd_adsin_d, nd_adcos_d, nd_adtan_d:
      begin { * Unary Operators for Derv. }
        LSQ_FREE_EXPR( cuna );
        DISPOSE( p )
      end;

    nd_ipw,     nd_bess1:
      begin
        LSQ_FREE_EXPR( spuna );
        DISPOSE( p )
      end;

    nd_ipw_d,   nd_bess1_d:
      begin
        LSQ_FREE_EXPR( xpuna );
        DISPOSE( p )
      end;

    nd_and,     nd_or,
    nd_add,     nd_sub,     nd_mul,     nd_div,     nd_pow,     nd_phase,
    nd_dphase,  nd_eq,      nd_ne,      nd_lt,      nd_le,      nd_ge,
    nd_gt,      nd_mod,     nd_rem:
      begin { * Binary Operators }
        LSQ_FREE_EXPR( sbin1 ); LSQ_FREE_EXPR( sbin2 );
        DISPOSE( p )
      end;

    nd_mul_d,   nd_div_d,   nd_pow_d,   nd_phase_d, nd_dphase_d:
      begin { * Binary Operators for Derv. }
        LSQ_FREE_EXPR( cbin1 ); LSQ_FREE_EXPR( cbin2 );
        DISPOSE( p )
      end;

    nd_ub_listref,          nd_sb_listref,          nd_uw_listref,
    nd_sw_listref,          nd_li_listref,          nd_fl_listref,
    nd_listref: { * List ref. Operators }
        DISPOSE( p );

    nd_ub_refer,            nd_sb_refer,            nd_uw_refer,
    nd_sw_refer,            nd_li_refer,            nd_fl_refer,
    nd_refer: { * List ref. Operators }
        DISPOSE( p );

    nd_integr_loop,                   { * Integration operator }
    nd_integr_loop_d,                 { * Derivable integration operator }
    nd_summ_loop,                     { * Loop summation operator }
    nd_summ_loop_d:                   { * Loop summation operator for derv. }
        DISPOSE( p );

    nd_interpol,                      { * Interpolation Operator }
    nd_interpol_d:                    { * Interpolation Operator for Derv. }
        DISPOSE( p );

    nd_konst: DISPOSE( p );           { * Real Constant Value }

    nd_ifdir:
      begin
        LSQ_FREE_EXPR( if_expr );
        LSQ_FREE_EXPR( if_truenext );
        LSQ_FREE_EXPR( if_falsenext );
        DISPOSE( p )
      end;

    nd_user_call: DISPOSE( p );

  otherwise
    { Nothing to do for all other operators }
  end
end LSQ_FREE_EXPR;




{**********************************************************************}
{***  Functions To Locate a LSQ Object from its Integer Identifier  ***}
{**********************************************************************}


[global]
function LSQ_S_LINDEX( id: integer ): lsq_ptr;
{ Locate a Loop Index Block by id number }
var
  fnd: boolean;
  p:   lsq_ptr;

begin
  fnd := false;
  p   := fit_idxfirst;
  while (p <> nil) and not fnd do
    with p^ do
      if idx_ident = id then fnd := true
                        else p   := idx_next;
  LSQ_S_LINDEX := p
end LSQ_S_LINDEX;



[global]
function LSQ_S_LIMITS( id: integer ): lsq_ptr;
{ Locate a Limits Block with the id number }
var
  fnd: boolean;
  p:   lsq_ptr;

begin
  fnd := false;
  p := fit_limfirst;
  while (p <> nil) and not fnd do
    with p^ do
      if lim_id = id then fnd := true
                     else p := lim_next;
  LSQ_S_LIMITS := p
end LSQ_S_LIMITS;



[global]
function LSQ_S_DIABLK( id: integer ): lsq_ptr;
{ Locate a Diagonal Block }
var
  fnd: boolean;
  p:   lsq_ptr;

begin
  { Locate a Diagonal Block and set the last (previous) variable }
  p := fit_fixedvarblblk;
  fnd := false;
  if id >= 0 then
  repeat
    with p^ do
      if blk_bident = id then fnd := true
                         else p := blk_next;
  until fnd or (p = nil);
  LSQ_S_DIABLK := p
end LSQ_S_DIABLK;



[global]
function LSQ_S_VARBL( id: integer ): lsq_ptr;
{ Locate a LSQ Variable }
var
  fnd: boolean;
  p:   lsq_ptr;

begin
  fnd := false;
  p := fit_varfirst;
  while (p <> nil) and not fnd do
    if p^.var_vident = id then fnd := true
                          else p := p^.var_next;
  LSQ_S_VARBL := p
end LSQ_S_VARBL;



[global]
function LSQ_S_PARM( id: integer ): lsq_ptr;
{ Locate a LSQ Parameter }
var
  fnd: boolean;
  p:   lsq_ptr;

begin
  fnd := false;
  p   := fit_parfirst;
  while (p <> nil) and not fnd do
    if p^.par_pident = id then
      fnd := true
    else
      p := p^.par_next;
  LSQ_S_PARM := p
end LSQ_S_PARM;



[global]
function LSQ_S_LIST( id: integer ): lsq_ptr;
{ Locate a LSQ List }
var
  fnd: boolean;
  p:   lsq_ptr;

begin
  p := fit_listfirst;
  fnd := false;
  while (p <> nil) and not fnd do
    if p^.lis_lident = id then fnd := true
                          else p := p^.lis_next;
  LSQ_S_LIST := p
end LSQ_S_LIST;



{********************************************************************}
{***  Functions To Push a LSQ Object from its Integer Identifier  ***}
{********************************************************************}


[global]
procedure LSQ_RF_LINDEX( id: integer );
{ Loop Index Push }
var
  p: lsq_ptr;

begin
  p := LSQ_S_LINDEX( id );
  if p = nil then LSQUSR_ERROR( 24, 3, nil );
  tree.lsq := p;
  LSQ_PUSH( tree )
end LSQ_RF_LINDEX;



[global]
procedure LSQ_RF_VARBL( id: integer );
{ Variable Push }
var
  p: lsq_ptr;

begin
  p := LSQ_S_VARBL( id );
  if p = nil then LSQUSR_ERROR( 25, 3, nil );
  tree.lsq := p;
  LSQ_PUSH( tree )
end LSQ_RF_VARBL;



[global]
procedure LSQ_RF_PARM( id: integer );
{ Parameter Push }
var
  p: lsq_ptr;

begin
  p := LSQ_S_PARM( id );
  if p = nil then LSQUSR_ERROR( 26, 3, nil );
  tree.lsq := p;
  LSQ_PUSH( tree )
end LSQ_RF_PARM;



[global]
procedure LSQ_RF_LIST( id: integer );
{ LSQ List Push }
var
  p: lsq_ptr;

begin
  p := LSQ_S_LIST( id );
  if p = nil then LSQUSR_ERROR( 27, 3, nil );
  tree.lsq := p;
  LSQ_PUSH( tree )
end LSQ_RF_LIST;




{*********************************************}
{***  Functions To Manage the LSQ Objects  ***}
{*********************************************}



function ALLOC_DIABLK( name: rec_ptr; id: integer ): lsq_ptr;
var
  p: lsq_ptr;

begin
  NEW( p, nd_diablk );                { Create the Diagonal Block }
  with p^ do                          { Initialize the Variable List }
  begin
    lsq_ndty    := nd_diablk;
    blk_name    := name;
    blk_marqwc  := LSQ_POP;           { Set the Marqward-Levenberg expr. }
    blk_dmp     := LSQ_POP;           { Set the Damping factor expr. }
    blk_frsvar  := nil;               { Set the variable list to Empty }
    blk_lstvar  := nil;
    blk_vindex  := 0;                 { Init the Variable Index }
    blk_bident  := id;                { Set the Diagonal Block Identifier }
    blk_effmarq := 0.0;
    blk_effdmp  := 0.0;
    blk_vect_b  := nil;               { Set vectors and matrix to the ... }
    blk_vect_x  := nil;               { ... no allocated state. }
    blk_matrix  := nil;
    blk_next    := nil
  end;
  opened_diablk := p;                 { Open the new Diagonal Block }
  ALLOC_DIABLK := p
end ALLOC_DIABLK;



[global]
procedure LSQ_C_DIABLK( nam: rec_ptr; id: integer );
{ Create a Diagonal Block }
var
  p: lsq_ptr;

begin
  p := LSQ_S_DIABLK( id );            { Check for Unique id }
  if p = nil then
  begin
    p := ALLOC_DIABLK( nam, id );
    if fit_blkfirst = nil then        { Link in the Defined Variable List }
      fit_blkfirst := p;
    fit_blklast^.blk_next := p;       { Link from the previous block or ... }
    fit_blklast    := p;              { ... from the fixed variable block }
    opened_diablk  := p               { Set this Diagonal block as the oppened block }
  end
  else { Diagonal Block was already existing }
    LSQUSR_ERROR( 28, 4, p )
end LSQ_C_DIABLK;



[global]
procedure LSQ_OP_DIABLK( id: integer );
{ Set the Specified Diagonal Block as the Current Opened Block }
begin
  if id <= 0 then opened_diablk := nil
             else opened_diablk := LSQ_S_DIABLK( id )
end LSQ_OP_DIABLK;



[global]
procedure LSQ_C_LINDEX( id: integer );
{ Create a Loop Index }
var
  p: lsq_ptr;

begin
  p := LSQ_S_LINDEX( id );            { Check for Unique id }
  if p = nil then
  begin
    NEW( p, nd_index );               { Allocate an index block }
    if fit_idxlast = nil then fit_idxfirst := p  { Link it in the list }
                         else fit_idxlast^.idx_next := p;
    fit_idxlast := p;
    with p^ do
    begin                             { Initialize the index block }
      lsq_ndty  := nd_index;
      idx_next  := nil;
      idx_ident := id;                { Set the limits block id }
      idx_value := 0.0
    end
  end
  else
    LSQUSR_ERROR( 29, 4, nil )
end LSQ_C_LINDEX;



[global]
procedure LSQ_C_LIMITS( id: integer; inf, sup: lsq_real );
{ Create a limits block }
var
  p: lsq_ptr;

begin
  if LSQ_S_LIMITS( id ) = nil then    { Check for Unique id }
  begin
    NEW( p, nd_limits );              { Allocate a limits block }
    if fit_limlast = nil then         { Link it in the list }
      fit_limfirst := p
    else
      fit_limlast^.lim_next := p;
    fit_limlast := p;
    with p^ do
    begin                             { Initialize the limits block }
      lsq_ndty := nd_limits;
      lim_next := nil;
      lim_id   := id;                 { Set the limits block id }
      lim_ct   := 0;                  { Set the limits block use count }
      lim_low  := inf;                { Set the variable limits }
      lim_up   := sup
    end
  end
  else
    LSQUSR_ERROR( 30, 4, nil )
end LSQ_C_LIMITS;



procedure REMOVE_V_OF_BLK( pva: lsq_ptr );
{ Procedure to remove a variable from its diagonal block }
var
  pv0, pv1: lsq_ptr;

begin
  if pva <> nil then
    if (pva^.var_diablk <> nil) then
    with pva^.var_diablk^ do
    begin
      pv0 := nil;
      pv1 := blk_frsvar;
      while (pv1 <> nil) and (pv1 <> pva) do
      begin  pv0 := pv1; pv1 := pv1^.var_nxtbl  end;
      if pv1 <> nil then
      begin
        pva^.var_defblk := blk_bident;
        pva^.var_diablk := nil;
        if pv0 = nil then blk_frsvar := pva^.var_nxtbl
                     else pv0^.var_nxtbl := pva^.var_nxtbl;
        pva^.var_nxtbl  := nil
      end
    end
end REMOVE_V_OF_BLK;



procedure INSERT_V_IN_BLK( pva, pvb: lsq_ptr );
{ Procedure to insert a variable in a diagonal block }
{ If the diagonal block is not specified (pvb = nil),
    when the variable with a previous diag. block is always existing,
          => insert in this diagonal block.
    otherwise insert in the fixedvariable block
}
var
  pv0, pv1: lsq_ptr;

begin
  if pva <> nil then
  begin { Existing variable }
    if pvb = nil then pvb := opened_diablk;     { When No specified diagonal block }
                                                { ... we try to use an opened block }
    if pvb = nil then
    begin
      pvb := LSQ_S_DIABLK( pva^.var_defblk );   { Try to use the previous block }
      if pvb = nil then pvb := fit_fixedvarblblk  { Last Default to fixed }
    end;

    if pva^.var_diablk = nil then
    begin { The variable was not assigned to a diagonal block }
      { Link variable to the diagonal block }
      if pvb^.blk_lstvar = nil then pvb^.blk_frsvar := pva
                               else pvb^.blk_lstvar^.var_nxtbl := pva;
      pvb^.blk_lstvar := pva;
      pva^.var_nxtbl  := nil; { Set the variable as the last of block }
      pva^.var_diablk := pvb  { Set the diagonal block attachement }
    end
  end  
end INSERT_V_IN_BLK;



[global]
procedure LSQ_C_VARBL( nam: rec_ptr; val, sig: lsq_real; id, lim: integer );
{ Create a (Fitted) Variable }
var
  p: lsq_ptr;

begin
  p := LSQ_S_VARBL( id );             { Check for Unique id }
  if p = nil then
  begin
    NEW( p, nd_varbl );               { Create the variable block }
    with p^ do                        { Initialize the variable }
    begin
      lsq_ndty    := nd_varbl;
      var_name    := nam;
      var_value   := val;
      var_sigma   := sig;
      var_vident  :=  id;
      var_matind  :=   0;
      if lim <> 0 then var_limits := LSQ_S_LIMITS( lim )
                  else var_limits := nil;
      var_defblk  :=  -1;
      var_diablk  := nil;
      var_next    := nil;
      var_nxtbl   := nil
    end;
    { Include the New Variable in the Global list of variable }
    if fit_varlast = nil then fit_varfirst := p
                         else fit_varlast^.var_next := p;
    fit_varlast := p;
    { Insert this variable in the current opened diagonal block or Fixed Block }
    INSERT_V_IN_BLK( p, nil )
  end
  else { Variable is already existing }
    LSQUSR_ERROR( 42, 4, p )
end LSQ_C_VARBL;



[global]
procedure LSQ_CH_DIABLK( pv, pb: lsq_ptr );
{ Procedure to change diagonal block attachement one variable }

begin
  if pv <> nil then
    if pv^.var_diablk <> pb then
    begin
      REMOVE_V_OF_BLK( pv );
      INSERT_V_IN_BLK( pv, pb )
    end
end LSQ_CH_DIABLK;



[global]
procedure LSQ_FIX_VARBL( pv: lsq_ptr );
{ Procedure to FIX a LSQ Variable }
begin
  LSQ_CH_DIABLK( pv, fit_fixedvarblblk )
end LSQ_FIX_VARBL;



[global]
procedure LSQ_UNFIX_VARBL( pv: lsq_ptr );
{ Procedure to UNFIX a LSQ Variable }
begin
  LSQ_CH_DIABLK( pv, nil )
end LSQ_UNFIX_VARBL;



[global]
procedure LSQ_S_PARMFLAGS( pa: lsq_ptr; sum_flg, der_flg, sig_flg: boolean );
{ Procedure to Set the Parameter Flags of a specified LSQ Parameter }
begin
  with pa^ do
  begin
    if sum_flg then par_flags := [parf_summ]
               else par_flags := [];
    if sig_flg then der_flg   := true;
    if der_flg then par_flags := par_flags + [parf_derivate];
    if sig_flg then par_flags := par_flags + [parf_evalsigma];
  end
end LSQ_S_PARMFLAGS;



[global]
procedure LSQ_C_PARM( nam: rec_ptr; id: integer;
                      sum_flg, der_flg, sig_flg, cach_flg: boolean );
{ Create a LSQ Parameter }
var
  p, attlist: lsq_ptr;

begin
  p := LSQ_S_PARM( id );              { Check id as Unique identifier }
  if p = nil then
  begin
    NEW( p, nd_parm );                { Create the Parameter Block }
    APPEND_EXEC( p );                 { Link it in the Directive List }

    with define_scope[ define_current ] do
    begin
      if first_par = nil then         { Link in the Defined Parameter List }
        first_par := p;
      if fit_parfirst = nil then fit_parfirst := p
                            else fit_parlast^.par_next := p;
      fit_parlast := p;
      { Get the Parameter attached List when it is existing }
      { Assume no attached list until showed otherwise }
      attlist := nil;
      if owner_obj <> nil then
      case owner_obj^.lsq_ndty of
        nd_collect: { Owner is a Data collection }
                    { Owner is set only for Scan, not for final exec-seq. }
                    if condition = 0 then attlist := owner_obj;

        nd_scandir: { Owner is a Scan of a List }
                    if (condition = 0) or (owner_obj^.sca_owner <> nil) then
                      attlist := owner_obj;

        nd_list:    { Owner is a List }
                    attlist := owner_obj;

      otherwise
      end;

      with p^ do                      { Initialize the Parameter Descriptor }
      begin
        lsq_ndty    := nd_parm;
        par_name    := nam;
        par_value   := 0.0;
        par_sigma   := 0.0;
        par_definition := LSQ_POP;    { Get the parameter definition }
        par_derddp  := nil;
        par_derlst  := nil;
        par_dervec  := nil;
        par_attlist := attlist;
        par_pident  := id;
        if sum_flg then par_flags := [parf_summ]
                   else par_flags := [];
        if sig_flg then der_flg := true;
        if der_flg then par_flags := par_flags + [parf_derivate];
        if sig_flg then par_flags := par_flags + [parf_evalsigma];

        if cach_flg and cacheflag and (attlist <> nil) then
        begin
          par_flags := par_flags + [parf_cached];
          cachepcnt := cachepcnt + 1
        end;
        par_lsum    := frs_intgr_sum;
        par_next    := nil
      end;
      frs_intgr_sum := nil;
      lst_intgr_sum := nil
    end
  end
  else
    LSQUSR_ERROR( 43, 4, p )
end LSQ_C_PARM;





{****************************************************************************}
{*****  Procedures to manage the Directive and Directive List Structure *****}
{****************************************************************************}

[global]
procedure LSQ_C_LIST( nam: rec_ptr; id, cache_size, idoff: integer );
{ Create a Fit List Descriptor and Open the Related Parameter List }
var
  p:   lsq_ptr;
  pca: cache_ptr;

begin
  p := LSQ_S_LIST( id );              { Check for Unique List id }
  if p = nil then
  begin
    NEW( p, nd_list );                { Create the List Descriptor ... }
    if fit_listlast = nil then        { ... and link it in the defined ... }
      fit_listfirst := p              { ... variable list }
    else
      fit_listlast^.lis_next := p;
    fit_listlast := p;

    with p^ do                        { Initialize the descriptor }
    begin
      lsq_ndty          := nd_list;   { Set the identification fields }
      lis_name          := nam;
      lis_lident        :=  id;

      lis_current       := nil;       { Set the list state to empty }
      lis_descriptor    := nil;

      lis_endflg        := true;

      lis_cachesize     := cache_size;{ Set the wanted cache size ... }
      lis_cachefirst    := nil;       { ... and init to to null cache }
      lis_cachelast     := nil;
      lis_ident         := idoff;     { ... with the specified cache id. offset }
      lis_parlist       := nil;       { ... and set to empty parameter ... }
      lis_dirlist       := nil;       { ... and directive lists }
      lis_stpcond       := nil;       { No stop scan condition }
      lis_condit        := nil;       { ... and no elective expression }

      NEW_CONTEXT( p );               { Create the Associated Context }

      if cache_size > 0 then          { Enable the cache allocator }
        define_scope[define_current].cacheflag := true;

      lis_next    := nil              { Assume no successor }
    end
  end
  else
    LSQUSR_ERROR( 44, 4, p )
end LSQ_C_LIST;



[global]
procedure LSQ_C_COLLECT( nam: rec_ptr; pli: lsq_ptr );
{ Create a Data Collection Descriptor Specified Lsq List pli. }
var
  pcol: lsq_ptr;

begin
  if pli = nil then
    LSQUSR_ERROR( 45, 4, nil )
  else
  begin
    NEW( pcol, nd_collect );          { Create the Data Collection Descriptor }
    if fit_colllast = nil then        { ... and link it in the collect list }
      fit_collfirst := pcol
    else
      fit_colllast^.coll_next := pcol;
    fit_colllast := pcol;
    with pcol^ do
    begin
      lsq_ndty := nd_collect;         { Set the Data Collection type }
      coll_next := nil;               { Assume no successor }
      coll_name := nam;               { Set the identifier link }
      coll_list := pli;               { Set the link to the related list}

      coll_enable := true;            { Set Data Collection Enabled }

      coll_condit := nil;             { No Sentinel Expr., }
      coll_computed := nil;           { no Computed Reference, }
      coll_observed := nil;           { no Observed Reference, }
      coll_sigma    := nil;           { no Sigma Reference ... }
      coll_weight   := nil;           { ... and no weight reference }

      coll_reject   := maxreject;     { No rejection }

      if pli <> nil then              { For true Data Collection }
        coll_statis   := NEW_STATIS_BLK;  { Create a New Statistic Block }

      coll_pckparm  := nil;
      coll_pckdir   := nil;

      coll_cyclparm := nil;
      coll_cycldir  := nil;

      NEW_CONTEXT( pcol );            { Set the Data Collect Context }

    end
  end
end LSQ_C_COLLECT;



function BUILD_CACHE_ENTRY( parlist: lsq_ptr; nb_par: integer ): entry_ptr;
{ Build a Cache Entry List for all Cached Parameter in the Parlist List }
var
  pf, pl, pc: entry_ptr;

begin
  pf := nil;
  repeat
    with parlist^ do
    begin
      if parf_cached in par_flags then
      begin
        NEW( pc );                    { Create the cache entry }
        if pf = nil then pf := pc     { Link it with the previous ... }
                                      { ... cache entry }
                    else pl^.entry_next := pc;
        pl := pc;
        with pc^ do
        begin
          entry_par   := parlist;     { Attache the current Parameter, }
          entry_val   := 0.0;         { initialize the value }
          entry_table := nil;         { ... and derivate table pointer }
          entry_next  := nil
        end;
        nb_par := nb_par - 1
      end;
      parlist := par_next
    end
  until (nb_par = 0) or (parlist = nil);
  BUILD_CACHE_ENTRY := pf
end BUILD_CACHE_ENTRY;



procedure APPEND_CACHE_COUNT;
var
  cacnt:      integer;
  fpar, lpar: lsq_ptr;

begin
  if define_current < 2 then
    LSQUSR_ERROR( 12, 4, nil )
  else
    with define_scope[define_current - 1] do
      cachepcnt := cachepcnt + define_scope[define_current - 1].cachepcnt 
end APPEND_CACHE_COUNT;



[global]
procedure LSQ_IF;
{ To generate a LSQ IF Directive }
var
  p: lsq_ptr;

begin
  p := LSQ_IF_PROCESS( true )
end LSQ_IF;



[global]
procedure LSQ_CASE;
{ To generate a LSQ Case Directive }
begin
  LSQ_CASE_PROCESS( true )
end LSQ_CASE;



[global]
function LSQ_END( prv_flg: boolean ): boolean;
{ Generale End Of Context Procedure }
var
  prv: boolean;
  i:   integer;
  pca: cache_ptr;

begin
  if define_current < 1 then
    LSQUSR_ERROR( 13, 4, nil )
  else
  begin
    with define_scope[define_current] do
    begin
      if owner_obj = nil then
      begin
        prv := false;                 { Decreasing Context if possible }
        { FIT external context }
        if define_current = 1 then
        begin
          if fit_cyclstdir = nil then
          begin
            fit_cyclstparm := first_par;
            fit_cyclstdir  := first_dir
          end;
          prv := true
        end
        else { End of Cycle and End of Fit sequences }
          if condition = 0 then
          begin { End cycle computing }
            fit_cyclvparm := first_par;
            fit_cycldir   := first_dir;
            prv_flg       := false;   { Set for end fit work sequence }
            condition     := 1
          end
          else
          begin { End of Fit Computing }
            fit_fitvparm := first_par;
            fit_fitdir   := first_dir
          end
      end
      else
        with owner_obj^ do
        begin
          prv := true;
          case lsq_ndty of

            nd_list:
              begin
                { Attach the specified parameter list }
                lis_parlist := first_par;
                { ... and the specified directive list }
                lis_dirlist := first_dir;

                lis_condit  := LSQ_POP; { Set the eligiblity condition }
                lis_stpcond := LSQ_POP; { ... and the absolute stop scan condition }

                if cachepcnt > 0 then
                begin  { A cache is used for this list }
                  i := lis_cachesize;
                  repeat
                    NEW( pca );       { Allocate a cache address }
                    { Link with the previous cache address }
                    if lis_cachelast = nil then lis_cachefirst := pca
                                           else lis_cachelast^.cache_next := pca;
                    with pca^ do
                    begin
                      cache_next := nil;      { Set the next and previous link }
                      cache_previous := lis_cachelast;
                      cache_ident := maxint;  { Set as no initialized }
                      cache_entry := BUILD_CACHE_ENTRY( lis_parlist, cachepcnt )
                    end;
                    lis_cachelast := pca;
                    i := i - 1
                  until i = 0
                end
                else
                  lis_cachesize := 0
              end;

            nd_collect:
              { Fit Data Collection Managmenent }
              if condition = 0 then
              begin { Set the packed related parameter/directive list }
                { Disable the end of context to ... }
                { ... flip to the cycle context }
                prv := false;         { Data Collection can have some cycle parm. }
                coll_pckparm := first_par;  { Set the packet/observ. parm. }
                coll_pckdir  := first_dir;  { Set the packet/observ. dir. }

                coll_condit  := LSQ_POP;    { Set the sentinel expression }
                coll_computed := LSQ_POP;   { set the computed reference expression }
                if coll_computed^.lsq_ndty <> nd_parm then
                  LSQUSR_ERROR( 48, 4, coll_list );
                coll_observed:= LSQ_POP;    { Set the observed, sigma and weight ... }
                coll_sigma   := LSQ_POP;
                coll_weight  := LSQ_POP;

                coll_reject  := RPOP; { Set the reject value }

                condition := 1
              end
              else
              begin { Set the cycle related parameter/directive list }
                coll_cyclparm := first_par; { Set the cycle related ... }
                coll_cycldir  := first_dir  { ... parameters and directives }
              end;

            nd_scandir:
                if condition = 0 then
                begin                 { Set the scan parameters/directives }
                  APPEND_CACHE_COUNT;
                  sca_dir := first_dir;
                  sca_condit := LSQ_POP;  { Get the condition expression }
                  condition := 1;
                  prv := false;       { Scan must have Stop Directive }
                  prv_flg := false
                end
                else
                begin
                  APPEND_CACHE_COUNT;
                  sca_endlist := first_dir
                end;


          otherwise
          end
        end
    end;
    if prv or prv_flg then            { Decrease Current Context of 1 }
    begin
      define_current := define_current - 1;
      if define_current = 0 then NEW_CONTEXT( nil ) { Erase old basic Context }
    end
    else
    with define_scope[define_current] do
    if define_current > 1 then
    begin
      { Do not change the owner }
      first_par := nil;               { Set the list of related parameters ... }
                                      { ... to the empty state, and ... }
      first_dir := nil;               { ... the list of directive to ... }
      last_dir  := nil                { ... the empty state }
    end
  end;
  LSQ_END := prv_flg
end LSQ_END;



[global]
procedure LSQ_EXEC_DIR( ndty: lsq_nodetypes );
{ Procedure to generate the specifiefd (node) directive }
var
  i: integer;
  p: lsq_ptr;

begin
  case ndty of
    nd_initlist:
      begin
        NEW( p, nd_initlist );
        with p^ do
        begin
          lsq_ndty := nd_initlist;
          initlist_list := LSQ_POP
        end
      end;

    nd_ub_listref,
    nd_sb_listref,
    nd_uw_listref,
    nd_sw_listref,
    nd_li_listref,
    nd_fl_listref,
    nd_ub_refer,
    nd_sb_refer,
    nd_uw_refer,
    nd_sw_refer,
    nd_li_refer,
    nd_fl_refer:
      begin
        NEW( p, nd_storedir );
        with p^ do
        begin
          lsq_ndty := nd_storedir;
          sto_subdir := ndty;
          if ndty <= nd_fl_listref then { List Record Store }
          begin
            sto_l_offset  := IPOP;    { Set the offset }
            sto_l_list    := LSQ_POP  { Set the list reference }
          end
          else { Memory Block Store }
          begin
            sto_r_offset  := IPOP;    { Add. the offset }
            sto_r_pointer := REC_POP  { Set the block address }
          end;
          sto_expr := LSQ_POP
        end
      end;

    nd_user_call: p := USERCALL_PROCESS;

  otherwise
  end;
  APPEND_EXEC( p )
end LSQ_EXEC_DIR;



[global]
procedure LSQ_SCANDIR( pli: lsq_ptr; mode: scaf_types );
{ Create a Scan Descriptor for a Directive List.
}
var
  psca: lsq_ptr;

begin
  if pli <> nil then
  begin
    NEW( psca, nd_scandir );          { Create the scan descriptor }
    APPEND_EXEC( psca );              { Link it in the directive list }
    with psca^ do
    begin
      lsq_ndty := nd_scandir;         { Set the record type }
      sca_list := pli;                { Set the list to scan link }

      { *** Initialize some Record Fields *** }
      sca_owner   := define_scope[ define_current ].owner_obj;
      sca_condit  := nil;             { The validity condition }
      sca_endlist := nil;             { The End Scan Directive List }
      sca_dir     := nil;             { The running scan directive }
      sca_invalid := nil;             { The invalid cache pointer }
      sca_windowvalid := 0;           { The window valid count }
      sca_windowuse := 0;             { The window use count }

      sca_type := mode                { Set the scan type }
    end;
    NEW_CONTEXT( psca );              { Set a local context }

    { Set the Cache Mode as for the More External Context }
    if define_current > 1 then
      define_scope[define_current].cacheflag :=
        define_scope[define_current - 1].cacheflag


  end
  else
    LSQUSR_ERROR( 49, 4, nil )
end LSQ_SCANDIR;



[global]
procedure LSQ_INIT_LSQ;
{ First Routine to call to Init the Least-Squares Loader System }
begin
  fit_statis    := NEW_STATIS_BLK;    { Create the Global Statistic Block }

  { *** Create the Fixed Variable Diagonal Block *** }
  LSQ_NULL_PUSH;
  LSQ_NULL_PUSH;
  fit_fixedvarblblk := ALLOC_DIABLK( nil, 0 );
  fit_blklast   := fit_fixedvarblblk; { Set the last block as the fixed... }
  opened_diablk := fit_fixedvarblblk; { ... and open it. }

  { *** Create the Default Context *** }
  define_current :=  0;
  NEW_CONTEXT( nil );                 { No Owner for the FIT structure }
  stkp     := 0;                      { Init the Operational Stack }
  top_case := 0;
  fit_varfirst := nil;                { Init the current variable list }
  fit_varlast  := nil
end LSQ_INIT_LSQ;



end.
