%pragma trace 1;
{
******************************************************************
*                                                                *
*                                                                *
*                                                                *
*                                                                *
*    * *  L E A S T - S Q U A R E S   P R O C E S S O R  * *     *
*                                                                *
*                                                                *
*                                                                *
*        ---  TYPES DEFINITIONS PASCAL FILE MODULE   ---         *
*                                                                *
*                                                                *
*     by :                                                       *
*                                                                *
*           P. Wolfers                                           *
*               c.n.r.s.                                         *
*               Laboratoire de Cristallographie                  *
*               B.P.  166 X   38042  Grenoble Cedex              *
*                                       FRANCE.                  *
*                                                                *
******************************************************************
}


{  Version 1.2-B (or Upper)  of  L S Q  System  }
{************    CPAS  Version   ***************}
{
        *** modification(s) from major version ***


			----

		       nothing

			----

}
module LSQ_COMPUT( input, output );

%include 'pasenv:cpas_b__lst_env';    { We load the LST Environment File }
%include 'lispsrc:lisp_block_env';    { We load the mem. rec. Env. File }
%include 'lispsrc:lsq_global_ref';    { We load the LSQ Environment File }


const

  { Degrees <-> Radian Conversion Coef. }
  pi   = 4*ARCTAN( 1.0 );      { <Pi_Number> }
  inrd = pi/180.0;             { <Pi_number>/180.0 }

  debug = false;               { Flag for debuging }
  sdbug = false;               { To display the parameters definitions }



var
  effnvarbl,                   { Effective variable number for the  ... }
                               { ... squared goodness of fit}

  tmppcnt,                     { Temporary count for referenced parameters }
  tmpnpar,
  tmpnvar: integer;            { Counts of referenced object by a parameter }

  mutant_gen_flg,              { Flag to signal the look up of a mutant parm. }
  mutant_dep_flg: boolean;     { Flag to signal a mutant depend parameter }

  tmvddp,
  tmpddp: ddp_ptr := nil;      { Pointer to temporary reference process tables }

  tmvdrt,
  tmpdrt: drt_ptr := nil;      { Pointer to temporary reference object tables }

  sav_chi2: lsq_real;          { Internal direct access chi2 }

  final_eval_flg,              { Final evaluation flag }
  last_cycle_flg: boolean;     { Flag for the last cycle }






    {*******************************************************}
    { ****************** Debug Functions ****************** }
    {*******************************************************}
    
(*

procedure PUT_PTR( p: $wild_pointer );
var
  eq: record case boolean of
    false:( iv: integer);
    true: ( p:  $wild_pointer )
  end;

begin
  eq.p := p;
  LST_PUT_INT( eq.iv, 18, 16 )
end PUT_PTR;


procedure PUT_NDTY( nd: lsq_nodetypes );
var
  s: string( 22 );

begin
  WRITEV( s, nd );
  LST_PUT_STRING( s )
end PUT_NDTY;

[global]
procedure LSQ_DSPLTREE( p: lsq_ptr );
var
  eq: eqv_type;
  lv: [static] integer := 0;
  
begin
  if p <> nil then
  with p^ do
  begin
    lv := lv + 1;
    LST_PUT_INT( lv, 5, 10 ); PUT_PTR( p ); LST_PUT_STRING( ' LSQ_Node ' ); PUT_NDTY( lsq_ndty ); LST_PUT_MCHAR( ' ', 2 );
    case lsq_ndty of
      nd_not,       nd_neg,       nd_round,     nd_trunc,
      nd_abs,       nd_sqrt,      nd_log,       nd_exp,
      nd_sinh,      nd_cosh,      nd_tanh,      nd_asinh,
      nd_acosh,     nd_atanh,     nd_sin,       nd_cos,
      nd_tan,       nd_asin,      nd_acos,      nd_atan,
      nd_dsin,      nd_dcos,      nd_dtan,      nd_adsin,
      nd_adcos,     nd_adtan:
        begin  LST_EOLN; LSQ_DSPLTREE( suna )  end;

      nd_ipw:
        begin  LST_PUT_STRING( ' ^' );  LST_PUT_INT( sindex, 4 ); LST_EOLN; LSQ_DSPLTREE( spuna )  end;
      nd_bess1: ;

      nd_and,       nd_or,        nd_add,       nd_sub,
      nd_eq,        nd_ne,        nd_lt,        nd_le,
      nd_ge,        nd_gt,        nd_mod,       nd_rem:
        begin  LST_EOLN; LSQ_DSPLTREE( sbin1 ); LSQ_DSPLTREE( sbin2 )  end;

      nd_mul,       nd_div,       nd_pow,       nd_phase,
      nd_dphase:
        begin  LST_EOLN; LSQ_DSPLTREE( cbin1 ); LSQ_DSPLTREE( cbin2 )  end;


                                      { * Item Selection Operators }
      nd_ub_listref,                    { for UBYTE field }
      nd_sb_listref,                    { for SBYTE field }
      nd_uw_listref,                    { for UWORD field }
      nd_sw_listref,                    { for SWORD field }
      nd_li_listref,                    { for INTEGER field }
      nd_fl_listref,                    { for SINGLE float field }
      nd_db_listref,                    { for DOUBLE float field }
      nd_listref: begin  LST_PUT_STRING( ' offset ' ); LST_PUT_INT( lref_offset, 6 ); LST_EOLN  end;

      nd_ub_refer,                      { for UBYTE field }
      nd_sb_refer,                      { for SBYTE field }
      nd_uw_refer,                      { for UWORD field }
      nd_sw_refer,                      { for SWORD field }
      nd_li_refer,                      { for INTGER field }
      nd_fl_refer,                      { for SINGLE float field }
      nd_db_refer,                      { for DOUBLE float field }
      nd_refer:   begin  LST_PUT_STRING( ' offset ' ); LST_PUT_INT( ref_offset, 6 ); LST_EOLN  end;


      { *** Function with Special Derivate Fields *** }

{     0123456789012 0123456789012 0123456789012 0123456789012 }
      nd_abs_d,     nd_sqrt_d,    nd_log_d,     nd_exp_d,
      nd_sinh_d,    nd_cosh_d,    nd_tanh_d,    nd_asinh_d,
      nd_acosh_d,   nd_atanh_d,   nd_sin_d,     nd_cos_d,
      nd_tan_d,     nd_asin_d,    nd_acos_d,    nd_atan_d,
      nd_dsin_d,    nd_dcos_d,    nd_dtan_d,    nd_adsin_d,
      nd_adcos_d,   nd_adtan_d:
        begin  LST_EOLN; LSQ_DSPLTREE( cuna )  end;

      nd_ipw_d:
        begin  LST_PUT_STRING( ' ^' ); LST_PUT_INT( xindex, 4 ); LST_EOLN; LSQ_DSPLTREE( xpuna )  end;

      nd_bess1_d: ;

      nd_mul_d,     nd_div_d,     nd_pow_d,     nd_phase_d,
      nd_dphase_d:
        begin LST_EOLN; LSQ_DSPLTREE( cbin1 ); LSQ_DSPLTREE( cbin2 )  end;
    
      nd_integr_loop,
      nd_integr_loop_d:
        begin
          LST_PUT_STRING( 'Integration Table of ' ); LST_PUT_INT( intgr_tabsz, 0 ); LST_PUT_STRING( ' elements.' ); LST_EOLN;
          LSQ_DSPLTREE( intgr_expr )
        end;

      nd_summ_loop,
      nd_summ_loop_d:
        begin
          LST_EOLN;
          LSQ_DSPLTREE( summ_begin ); LSQ_DSPLTREE( summ_end );
          LSQ_DSPLTREE( summ_step );  LSQ_DSPLTREE( summ_expr )
        end;

      nd_interpol,
      nd_interpol_d: { * Interpolation Operator }
        begin
          LST_PUT_STRING( 'Table of ' );  LST_PUT_INT( inter_tbsz, 0 ); LST_PUT_STRING( ' points.' ); LST_EOLN;
          LSQ_DSPLTREE( inter_expr )
        end;

      { *** All Special Function Nodes *** }

      nd_konst:  begin  LST_PUT_FIXED( cteval, 20, 6, 3 ); LST_EOLN  end;

      nd_index:  LST_EOLN;

      nd_varbl, nd_parm:
        begin  LSQUSR_REFER_ID( p ); LST_EOLN  end;

      nd_ifdir: begin
                  LST_PUT_STRING( 'If' ); LST_EOLN; LSQ_DSPLTREE( if_expr );
                  LST_PUT_MCHAR( ' ', 15 ); LST_PUT_STRING( 'Then' ); LST_EOLN; LSQ_DSPLTREE( if_truenext );
                  LST_PUT_MCHAR( ' ', 15 ); LST_PUT_STRING( 'Else' ); LST_EOLN; LSQ_DSPLTREE( if_falsenext )
                end;

      nd_casedir:begin
                   LST_PUT_MCHAR( ' ', 15 ); LST_PUT_STRING( 'min ' ); LST_PUT_INT( case_min, 6 );
                                             LST_PUT_STRING( ' sz = ' ); LST_PUT_INT( case_table^.drt_size, 6 );
                   LST_EOLN;
                   LSQ_DSPLTREE( case_selector );
                   for ii := 0 to case_table^.drt_size -1 do
                   begin
                     LST_PUT_MCHAR( ' ', 15 ); LST_PUT_INT(  ii - case_min, 6 ); LST_PUT_CHAR( ':' ); LST_EOLN;
                     LSQ_DSPLTREE( case_table^[ii] )
                   end;
                   LST_PUT_MCHAR( ' ', 15 ); LST_PUT_STRING( 'Otherwise:' );  LST_EOLN;
                   LSQ_DSPLTREE( case_other );
                 end;

      nd_user_call: LST_EOLN;

    otherwise
      LST_EOLN
    end;
    lv := lv - 1
  end
  else LST_EOLN;
end LSQ_DSPLTREE;

*)



    {*******************************************************}
    { *************** Mathematical Functions ************** }
    {*******************************************************}









function LSQ_INTERPOL( pn: lsq_ptr ): lsq_real; forward;

function LSQ_SUMLOOP( pn, pv: lsq_ptr; df: boolean ): lsq_real; forward;

function LSQ_INTEGR( pn, pv: lsq_ptr; df: boolean ): lsq_real; forward;



[global]
function LSQ_VALUE( p: lsq_ptr ): lsq_real;
var
  eq: eqv_type;

begin
(*
  if p <> nil then
  begin
    LST_PUT_STRING( ' LSQ_VALUE of ' ); PUT_PTR( p ); LST_PUT_CHAR( '/' ); PUT_NDTY( p^.lsq_ndty ); LST_EOLN;
  end;
*)
  if p <> nil then
  with p^ do
  case lsq_ndty of

    nd_not:   LSQ_VALUE := ORD( LSQ_VALUE( suna ) < 0.5 );

    nd_neg:   LSQ_VALUE := - LSQ_VALUE( suna );
    nd_round: LSQ_VALUE := ROUND( LSQ_VALUE( suna ) );
    nd_trunc: LSQ_VALUE := TRUNC( LSQ_VALUE( suna ) );

    nd_abs:   LSQ_VALUE := ABS( LSQ_VALUE( suna ) );
    nd_sqrt:  LSQ_VALUE := SQRT( LSQ_VALUE( suna ) );
    nd_log:   LSQ_VALUE := LN( LSQ_VALUE( suna ) );
    nd_exp:   LSQ_VALUE := EXP( LSQ_VALUE( suna ) );
    nd_sinh:  LSQ_VALUE := SINH( LSQ_VALUE( suna ) );
    nd_cosh:  LSQ_VALUE := COSH( LSQ_VALUE( suna ) );
    nd_tanh:  LSQ_VALUE := TANH( LSQ_VALUE( suna ) );
    nd_asinh: LSQ_VALUE := ARGSINH( LSQ_VALUE( suna ) );
    nd_acosh: LSQ_VALUE := ARGCOSH( LSQ_VALUE( suna ) );
    nd_atanh: LSQ_VALUE := ARGTANH( LSQ_VALUE( suna ) );
    nd_sin:   LSQ_VALUE := SIN( LSQ_VALUE( suna ) );
    nd_cos:   LSQ_VALUE := COS( LSQ_VALUE( suna ) );
    nd_tan:   LSQ_VALUE := TAN( LSQ_VALUE( suna ) );
    nd_asin:  LSQ_VALUE := ARCSIN( LSQ_VALUE( suna ) );
    nd_acos:  LSQ_VALUE := ARCCOS( LSQ_VALUE( suna ) );
    nd_atan:  LSQ_VALUE := ARCTAN( LSQ_VALUE( suna ) );
    nd_dsin:  LSQ_VALUE := SIN( inrd*LSQ_VALUE( suna ) );
    nd_dcos:  LSQ_VALUE := COS( inrd*LSQ_VALUE( suna ) );
    nd_dtan:  LSQ_VALUE := TAN( inrd*LSQ_VALUE( suna ) );
    nd_adsin: LSQ_VALUE := ARCSIN( LSQ_VALUE( suna ) )/inrd;
    nd_adcos: LSQ_VALUE := ARCCOS( LSQ_VALUE( suna ) )/inrd;
    nd_adtan: LSQ_VALUE := ARCTAN( LSQ_VALUE( suna ) )/inrd;

    nd_ipw:   LSQ_VALUE := LSQ_VALUE( spuna )**sindex;
    nd_bess1: begin
                LSQ_VALUE := 0.0
              end;

    nd_and:   LSQ_VALUE := ORD( (LSQ_VALUE( sbin1 ) >= 0.5) and
                                (LSQ_VALUE( sbin2 ) >= 0.5) );

    nd_or:    LSQ_VALUE := ORD( (LSQ_VALUE( sbin1 ) >= 0.5) or
                                (LSQ_VALUE( sbin2 ) >= 0.5) );

    nd_add:   LSQ_VALUE := LSQ_VALUE( sbin1 ) + LSQ_VALUE( sbin2 );
    nd_sub:   LSQ_VALUE := LSQ_VALUE( sbin1 ) - LSQ_VALUE( sbin2 );

    nd_eq, nd_ne, nd_lt, nd_le, nd_ge, nd_gt:
      begin
        eq.flt := LSQ_VALUE( sbin1 ) - LSQ_VALUE( sbin2 );
        case lsq_ndty of
          nd_eq: LSQ_VALUE := ORD( eq.flt  = 0.0);
          nd_ne: LSQ_VALUE := ORD( eq.flt <> 0.0);
          nd_lt: LSQ_VALUE := ORD( eq.flt  < 0.0);
          nd_le: LSQ_VALUE := ORD( eq.flt <= 0.0);
          nd_ge: LSQ_VALUE := ORD( eq.flt >= 0.0);
          nd_gt: LSQ_VALUE := ORD( eq.flt  > 0.0)
        end
      end;

    nd_mod: LSQ_VALUE := ROUND( LSQ_VALUE( sbin1 ) ) mod ROUND( LSQ_VALUE( sbin2 ) );
    nd_rem: LSQ_VALUE := ROUND( LSQ_VALUE( sbin1 ) ) rem ROUND( LSQ_VALUE( sbin2 ) );

    nd_mul: LSQ_VALUE := LSQ_VALUE( cbin1 ) * LSQ_VALUE( cbin2 );
    nd_div: LSQ_VALUE := LSQ_VALUE( cbin1 ) / LSQ_VALUE( cbin2 );
    nd_pow: LSQ_VALUE := EXP( LSQ_VALUE( cbin2 )*LN( LSQ_VALUE( cbin2 ) ) );
    nd_phase:   LSQ_VALUE := ARCTAN( LSQ_VALUE( cbin1 ), LSQ_VALUE( cbin2 ) );
    nd_dphase:  LSQ_VALUE := ARCTAN( LSQ_VALUE( cbin1 ), LSQ_VALUE( cbin2 ) )/inrd;

                                      { * Item Selection Operators }
    nd_ub_listref:                    { for UBYTE field }
      LSQ_VALUE := BLK_UB( lref_list^.lis_current, lref_offset );
    nd_sb_listref:                    { for SBYTE field }
      LSQ_VALUE := BLK_SB( lref_list^.lis_current, lref_offset );
    nd_uw_listref:                    { for UWORD field }
      LSQ_VALUE := BLK_UW( lref_list^.lis_current, lref_offset );
    nd_sw_listref:                    { for SWORD field }
      LSQ_VALUE := BLK_SW( lref_list^.lis_current, lref_offset );
    nd_li_listref:                    { for INTEGER field }
      LSQ_VALUE := BLK_LI( lref_list^.lis_current, lref_offset );
    nd_fl_listref:                    { for SINGLE float field }
      LSQ_VALUE := BLK_FL( lref_list^.lis_current, lref_offset );
    nd_db_listref:                    { for DOUBLE float field }
      LSQ_VALUE := BLK_DB( lref_list^.lis_current, lref_offset );
    nd_listref:                       { for Least-Square Expression }
      begin
        eq.rec := BLK_PT( lref_list^.lis_current, lref_offset );
        LSQ_VALUE := LSQ_VALUE( eq.lsq )
      end;

    nd_ub_refer:                      { for UBYTE field }
      LSQ_VALUE := BLK_UB( ref_pointer, ref_offset );
    nd_sb_refer:                      { for SBYTE field }
      LSQ_VALUE := BLK_SB( ref_pointer, ref_offset );
    nd_uw_refer:                      { for UWORD field }
      LSQ_VALUE := BLK_UW( ref_pointer, ref_offset );
    nd_sw_refer:                      { for SWORD field }
      LSQ_VALUE := BLK_SW( ref_pointer, ref_offset );
    nd_li_refer:                      { for INTGER field }
      LSQ_VALUE := BLK_LI( ref_pointer, ref_offset );
    nd_fl_refer:                      { for SINGLE float field }
      LSQ_VALUE := BLK_FL( ref_pointer, ref_offset );
    nd_db_refer:                      { for DOUBLE float field }
      LSQ_VALUE := BLK_DB( ref_pointer, ref_offset );
    nd_refer:                         { for least-square expression }
      begin
        eq.rec := BLK_PT( ref_pointer, ref_offset );
        LSQ_VALUE := LSQ_VALUE( eq.lsq )
      end;


    { *** Function with Special Derivate Fields *** }

    nd_abs_d:   begin vuna := ABS( LSQ_VALUE( cuna ) );  LSQ_VALUE := vuna   end;
    nd_sqrt_d:  begin vuna := SQRT( LSQ_VALUE( cuna ) ); LSQ_VALUE := vuna   end;
    nd_log_d:   begin vuna := LSQ_VALUE( cuna );     LSQ_VALUE := LN( vuna ) end;
    nd_exp_d:   begin vuna := EXP( LSQ_VALUE( cuna ) );  LSQ_VALUE := vuna   end;
    nd_sinh_d:  begin vuna := LSQ_VALUE( cuna ); LSQ_VALUE := SINH( vuna )  end;
    nd_cosh_d:  begin vuna := LSQ_VALUE( cuna ); LSQ_VALUE := COSH( vuna )  end;
    nd_tanh_d:  begin vuna := TANH( LSQ_VALUE( cuna ) ); LSQ_VALUE := vuna   end;
    nd_asinh_d: begin vuna := LSQ_VALUE( cuna ); LSQ_VALUE := ARGSINH( vuna )  end;
    nd_acosh_d: begin vuna := LSQ_VALUE( cuna ); LSQ_VALUE := ARGCOSH( vuna )  end;
    nd_atanh_d: begin vuna := LSQ_VALUE( cuna ); LSQ_VALUE := ARGTANH( vuna )  end;
    nd_sin_d:   begin vuna := LSQ_VALUE( cuna ); LSQ_VALUE := SIN( vuna )    end;
    nd_cos_d:   begin vuna := LSQ_VALUE( cuna ); LSQ_VALUE := COS( vuna )    end;
    nd_tan_d:   begin vuna := TAN( LSQ_VALUE( cuna ) ); LSQ_VALUE := vuna    end;
    nd_asin_d:  begin vuna := LSQ_VALUE( cuna ); LSQ_VALUE := ARCSIN( vuna ) end;
    nd_acos_d:  begin vuna := LSQ_VALUE( cuna ); LSQ_VALUE := ARCCOS( vuna ) end;
    nd_atan_d:  begin vuna := LSQ_VALUE( cuna ); LSQ_VALUE := ARCTAN( vuna ) end;
    nd_dsin_d:  begin
                vuna := inrd*LSQ_VALUE( cuna ); LSQ_VALUE := SIN( vuna )
              end;
    nd_dcos_d:  begin
                vuna := inrd*LSQ_VALUE( cuna ); LSQ_VALUE := COS( vuna )
              end;
    nd_dtan_d:  begin
                vuna := TAN( inrd*LSQ_VALUE( cuna ) ); LSQ_VALUE := vuna
              end;
    nd_adsin_d: begin
                vuna := LSQ_VALUE( cuna ); LSQ_VALUE := ARCSIN( vuna )/inrd
              end;
    nd_adcos_d: begin
                vuna := LSQ_VALUE( cuna ); LSQ_VALUE := ARCCOS( vuna )/inrd
              end;
    nd_adtan_d: begin
                vuna := LSQ_VALUE( cuna ); LSQ_VALUE := ARCTAN( vuna )/inrd
              end;

    nd_ipw_d: begin
                xvuna := LSQ_VALUE( xpuna );
                LSQ_VALUE := xvuna**xindex
              end;

    nd_bess1_d: begin
                LSQ_VALUE := 0.0
              end;

    nd_mul_d: begin
                vbin1 := LSQ_VALUE( cbin1 ); vbin2 := LSQ_VALUE( cbin2 );
                LSQ_VALUE := vbin1 * vbin2
              end;
    nd_div_d: begin
                vbin1 := LSQ_VALUE( cbin1 ); vbin2 := LSQ_VALUE( cbin2 );
                LSQ_VALUE := vbin1 / vbin2
              end;
    nd_pow_d: begin
                vbin1 := LSQ_VALUE( cbin1 ); vbin2 := LSQ_VALUE( cbin2 );
                LSQ_VALUE := EXP( vbin2 * LN( vbin1 ) )
              end;
    nd_phase_d:begin
                vbin1 := LSQ_VALUE( cbin1 ); vbin2 := LSQ_VALUE( cbin2 );
                LSQ_VALUE := ARCTAN( vbin1, vbin2 )
              end;
    nd_dphase_d:begin
                vbin1 := LSQ_VALUE( cbin1 ); vbin2 := LSQ_VALUE( cbin2 );
                LSQ_VALUE := ARCTAN( vbin1, vbin2 )/inrd
              end;

    nd_integr_loop: LSQ_VALUE := LSQ_INTEGR( p, nil, false );
    nd_integr_loop_d:
                    LSQ_VALUE := LSQ_INTEGR( p, nil, true  );

    nd_summ_loop:   LSQ_VALUE := LSQ_SUMLOOP( p, nil, false );
    nd_summ_loop_d: LSQ_VALUE := LSQ_SUMLOOP( p, nil, true  );

    nd_interpol,
    nd_interpol_d:  LSQ_VALUE := LSQ_INTERPOL( p ); { * Interpolation Operator }

    { *** All Special Function Nodes *** }

    nd_konst:   LSQ_VALUE := cteval;

    nd_index:   LSQ_VALUE := idx_value;

    nd_varbl:   LSQ_VALUE := var_value;

    nd_parm:    LSQ_VALUE := par_value;

    nd_ifdir: begin
                if_vflag:= (LSQ_VALUE( if_expr ) >= 0.5);
                if if_vflag then LSQ_VALUE := LSQ_VALUE( if_truenext )
                            else LSQ_VALUE := LSQ_VALUE( if_falsenext )
              end;

    nd_casedir:begin
                eq.int := ROUND( LSQ_VALUE( case_selector ) ) - case_min;
                if (eq.int >= 1) and (eq.int <= case_table^.drt_size) then
                  case_cursel := case_table^[eq.int]
                else
                  case_cursel := case_other;
                LSQ_VALUE := LSQ_VALUE( case_cursel )
              end;

    nd_user_call: LSQ_VALUE := LSQUSR_FUNCTION( usercall_id, usercall_parm );

  otherwise
    LSQ_VALUE := 0.0
  end
  else LSQ_VALUE := 0.0
end LSQ_VALUE;



[global]
function LSQ_GETREF( p: lsq_ptr ): lsq_obj;
{ Function to Return the Kind of an Expression Value }
var
  eq:  eqv_type;
  res: lsq_obj;

begin
  with res do
  begin
    typ := 0;
    lp  := nil;
    if p <> nil then
    with p^ do
    case lsq_ndty of

      nd_ub_listref, nd_sb_listref, nd_uw_listref, nd_sw_listref,
      nd_li_listref,
      nd_ub_refer,   nd_sb_refer,   nd_uw_refer,   nd_sw_refer,
      nd_li_refer,
      nd_round, nd_trunc, nd_mod, nd_rem,
      nd_not, nd_and, nd_or,
      nd_eq, nd_ne, nd_lt, nd_le, nd_ge, nd_gt:
        begin  { Give an Integer Value }
          typ := 4;                   { Set Integer Result }
          iv := ROUND( LSQ_VALUE( p ) )
        end;

                                      { * Item Selection Operators }
    nd_listref:                       { for Least-Square Expression }
      begin
        eq.rec := BLK_PT( lref_list^.lis_current, lref_offset );
        res    := LSQ_GETREF( eq.lsq )
      end;

    nd_refer:
      begin
        eq.rec := BLK_PT( ref_pointer, ref_offset );
        res    := LSQ_GETREF( eq.lsq )
      end;


    { *** All Special Function Nodes *** }

    nd_varbl:   begin  typ := 1; lp := p  end;
    nd_parm:    begin  typ := 2; lp := p  end;

    nd_ifdir: begin
                if_vflag:= (LSQ_VALUE( if_expr ) >= 0.5);
                if if_vflag then res := LSQ_GETREF( if_truenext )
                            else res := LSQ_GETREF( if_falsenext )
              end;

    nd_casedir:begin
                eq.int := ROUND( LSQ_VALUE( case_selector ) ) - case_min;
                if (eq.int >= 1) and (eq.int <= case_table^.drt_size) then
                  case_cursel := case_table^[eq.int]
                else
                  case_cursel := case_other;
                res := LSQ_GETREF( case_cursel )
              end;

    otherwise
      typ := 3;
      fv  := LSQ_VALUE( p )
    end
  end;
  LSQ_GETREF := res
end LSQ_GETREF;


function LSQ_DERIV( p, q: lsq_ptr ): lsq_real;
var
  eq: eqv_type;

begin
  if p <> nil then
  if p = q then LSQ_DERIV := 1.0
  else
  with p^ do
  case lsq_ndty of

    nd_neg:   LSQ_DERIV := - LSQ_DERIV( suna, q );

    nd_abs_d: if vuna >= 0.0 then LSQ_DERIV :=   LSQ_DERIV( cuna, q )
                             else LSQ_DERIV := - LSQ_DERIV( cuna, q );

    nd_sqrt_d:LSQ_DERIV :=   LSQ_DERIV( cuna, q )/ (2.0*vuna);
    nd_log_d: LSQ_DERIV :=   LSQ_DERIV( cuna, q )/vuna;
    nd_exp_d: LSQ_DERIV :=   LSQ_DERIV( cuna, q )*vuna;
    nd_sinh_d:LSQ_DERIV :=   LSQ_DERIV( cuna, q )*COSH( vuna );
    nd_cosh_d:LSQ_DERIV :=   LSQ_DERIV( cuna, q )*SINH( vuna );
    nd_tanh_d:LSQ_DERIV :=   LSQ_DERIV( cuna, q )*(1.0 - SQR( vuna ));
    nd_asinh_d:
              LSQ_DERIV :=   LSQ_DERIV( cuna, q )/SQRT( SQR( vuna ) + 1.0 );
    nd_acosh_d:
              LSQ_DERIV :=   LSQ_DERIV( cuna, q )/SQRT( SQR( vuna ) - 1.0 );
    nd_atanh_d:
              LSQ_DERIV :=   LSQ_DERIV( cuna, q )/(1.0 - SQR( vuna ));
    nd_sin_d: LSQ_DERIV :=   LSQ_DERIV( cuna, q )*COS( vuna );
    nd_cos_d: LSQ_DERIV := - LSQ_DERIV( cuna, q )*SIN( vuna );
    nd_tan_d: LSQ_DERIV :=   LSQ_DERIV( cuna, q )*( 1.0 + SQR( vuna ) );
    nd_asin_d:LSQ_DERIV :=   LSQ_DERIV( cuna, q )/SQRT( 1.0 - SQR( vuna ) );
    nd_acos_d:LSQ_DERIV := - LSQ_DERIV( cuna, q )/SQRT( 1.0 - SQR( vuna ) );
    nd_atan_d:LSQ_DERIV :=   LSQ_DERIV( cuna, q )/( 1.0 + SQR( vuna ) );
    nd_dsin_d:LSQ_DERIV :=   inrd*LSQ_DERIV( cuna, q )*COS( vuna );
    nd_dcos_d:LSQ_DERIV := - inrd*LSQ_DERIV( cuna, q )*SIN( vuna );
    nd_dtan_d:LSQ_DERIV :=   inrd*LSQ_DERIV( cuna, q )*( 1.0 + SQR( vuna ) );
    nd_adsin_d:
              LSQ_DERIV :=   LSQ_DERIV( cuna, q )/(inrd*SQRT(1.0 - SQR( vuna )));
    nd_adcos_d:
              LSQ_DERIV := - LSQ_DERIV( cuna, q )/(inrd*SQRT(1.0 - SQR( vuna )));
    nd_adtan_d:
              LSQ_DERIV :=   LSQ_DERIV( cuna, q )/(inrd*(1.0 + SQR( vuna )));

    nd_ipw_d: LSQ_DERIV :=   xindex * LSQ_DERIV( xpuna, q ) * xvuna**(xindex - 1);

    nd_bess1_d: begin
                LSQ_DERIV := 0.0
              end;

    nd_add:   LSQ_DERIV := LSQ_DERIV( sbin1, q ) + LSQ_DERIV( sbin2, q );
    nd_sub:   LSQ_DERIV := LSQ_DERIV( sbin1, q ) - LSQ_DERIV( sbin2, q );

    nd_mul_d: LSQ_DERIV := LSQ_DERIV( cbin1, q )*vbin2
                         + LSQ_DERIV( cbin2, q )*vbin1;
    nd_div_d: LSQ_DERIV :=
                ( (LSQ_DERIV( cbin1, q )*vbin2 - vbin1*LSQ_DERIV( cbin2, q ) ) )
                /SQR( vbin2 );
    nd_pow_d: begin
                eq.flt := LN( vbin1 );
                LSQ_DERIV :=
                  EXP( eq.flt*vbin2 )*( LSQ_DERIV( cbin2, q )*eq.flt +
                                   vbin2*LSQ_DERIV( cbin1, q )/vbin1 )
              end;
    nd_phase_d: begin
                eq.flt := SQR( vbin1 ) + SQR( vbin2 );
                if eq.flt <= 1.0E-6 then LSQ_DERIV := 0.0 else
                  LSQ_DERIV := (  LSQ_DERIV( cbin1, q )*vbin2
                                - vbin1*LSQ_DERIV( cbin2, q ) )/eq.flt
              end;
    nd_dphase_d:begin
                eq.flt := SQR( vbin1 ) + SQR( vbin2 );
                if eq.flt <= 1.0E-6 then LSQ_DERIV := 0.0 else
                  LSQ_DERIV := inrd*( LSQ_DERIV( cbin1, q )*vbin2
                                    - vbin1*LSQ_DERIV(  cbin2, q ) )/eq.flt
              end;

    nd_integr_loop_d: LSQ_DERIV := LSQ_INTEGR( p, q, true );

    nd_summ_loop_d:   LSQ_DERIV := LSQ_SUMLOOP( p, q, true );

    { * Interpolation Operator }
    nd_interpol_d:    LSQ_DERIV := inter_der*LSQ_DERIV( inter_expr, q );


    nd_listref:                       { For Least-Squares Expressions }
      begin
        eq.rec    := BLK_PT( lref_list^.lis_current, lref_offset );
        LSQ_DERIV := LSQ_DERIV( eq.lsq, q )
      end;

    nd_refer:
      begin
        eq.rec    := BLK_PT( ref_pointer, ref_offset );
        LSQ_DERIV := LSQ_DERIV( eq.lsq, q )
      end;


    nd_ifdir: if if_vflag then
                LSQ_DERIV := LSQ_DERIV( if_truenext, q )
              else
                LSQ_DERIV := LSQ_DERIV( if_falsenext, q );

    nd_casedir: LSQ_DERIV := LSQ_DERIV( case_cursel, q );

  otherwise
    LSQ_DERIV := 0.0
  end
  else LSQ_DERIV := 0.0
end LSQ_DERIV;



procedure LSQ_INITIALIZE_PDER_VAL;
{ To Initialize blk_vect_x Vector for Each Diagonal Block }
var
  pblk: lsq_ptr;
  i:    integer;

begin
  pblk := fit_blkfirst;
  while pblk <> nil do
  with pblk^ do
  begin
    if blk_vect_x <> nil then
      for i := 1 to blk_vect_x^.v_size do  blk_vect_x^[i] := 0.0;
    pblk := blk_next
  end
end LSQ_INITIALIZE_PDER_VAL;


procedure LSQ_SET_PDER_VAL( pa: lsq_ptr; coef: lsq_real );
{ Recursive Procedure to Evaluate all Partial Derivate of a Parameter.
  The resulting derivate vector are loaded in the blk_vect_x vector
  of each diagonal block.
}
var
  i, id: integer;
  pp:    lsq_ptr;
  pv:    vec_ptr;

begin
  with pa^ do
    if par_derlst <> nil then
    begin
      pv := par_dervec;
      for i := 1 to par_derlst^.drt_size do
      begin
        pp := par_derlst^[i];
        if pp^.lsq_ndty = nd_varbl then
        begin { Variable Partial Derivate }
          id := pp^.var_matind;
          with pp^.var_diablk^ do
            blk_vect_x^[id] := blk_vect_x^[id] + pv^[i]*coef
        end  
        else { Sub-Parameter Partial Derivate }
          LSQ_SET_PDER_VAL( pp, coef*pv^[i] )
      end
    end
end LSQ_SET_PDER_VAL;



procedure LSQ_PARM_SIGMA( pa: lsq_ptr );
{ Procedure to Compute the Final Sigma of pa^ Parameter.
  This function must be called only after a call of LSQ_CORRELATION. 
}
var
  sig, sigv:      lsq_real;
  pv1, pv2, pblk: lsq_ptr;
  dim, i, j, k:   integer;

begin
  LSQ_INITIALIZE_PDER_VAL;              { Initialize the blk_vect_x vectors }
  LSQ_SET_PDER_VAL( pa, 1.0 );          { Compute the Final Derivates }
  { now use the partial derivates }
  pblk := fit_blkfirst;
  sig := 0.0;                           { Initialize the Sigma }
  while pblk <> nil do
  with pblk^ do
  begin
    if blk_vect_x <> nil then
    begin
      dim := blk_vect_b^.v_size;        { Get the block size }
      pv1 := blk_frsvar;                { Scan the variable of this block }
      k := 1;                           { Set the matrix scan index }
      for i := 1 to dim do              { Loop on the matrix lines }
      begin
        with pv1^ do
        begin
          sigv := var_sigma;            { Get Sigma_ii }
          pv1  := var_nxtbl             { Skip to next variable of the block }
        end;
        if blk_vect_x <> nil then
        begin
          sigv := sigv * blk_vect_x^[i];{ Comput the Sigma_ii Term }
          sig  := sig + SQR( sigv );    { Add the diagonal term contribution }
          pv2  := pv1;
          if blk_matrix <> nil then
          for j := i + 1 to dim do      { Loop on All Correlations }
          begin
            k := k + 1;             { skip to next correlation matrix elem }
            sig := sig + 2.0*blk_matrix^[k] * blk_vect_x^[j]*pv2^.var_sigma*sigv;
            pv2 := pv2^.var_nxtbl
          end
        end
      end
    end;
    pblk := blk_next
  end;
  if sig < 0.0 then pa^.par_sigma := -1.0
               else pa^.par_sigma := SQRT( sig )
end LSQ_PARM_SIGMA;



procedure PARM_EVAL( pa: lsq_ptr; fsum: boolean );
var
  i, j, k: integer;
  der:     lsq_real;
  spv:     lsq_ptr;
  pddp:    ddp_ptr;
  pdrt:    drt_ptr;
  pvec:    vec_ptr;

begin

  if debug then
  begin
    LST_EOLN;
    LST_PUT_STRING( ' Eval parm : ' );
    LSQUSR_REFER_ID( pa );
    LST_EOLN;
(*
    if sdbug then
    begin
      LSQ_DSPLTREE( pa^.par_definition );
      LST_PUT_STRING( ' --- end parm def ---' ); LST_EOLN
    end
*)
  end;

  with pa^ do
  begin
    fsum := (parf_summ in par_flags) and fsum;
    if not fsum then par_value := 0.0;
    par_value := par_value + LSQ_VALUE( par_definition );

    if (parf_derivate in par_flags) and (par_dervec <> nil) then
    begin
      pdrt := par_derlst; pvec := par_dervec; pddp := par_derddp;
      if pddp <> nil then
      begin { Complex Parameter (With Volatile Sub-Parameter Dependance) }
        if not fsum then
          for i := 1 to pvec^.v_size do pvec^[i] := 0.0;

        if debug then
        begin
          LST_PUT_STRING( ' With a ddp table of ' ); LST_PUT_INT( pddp^.ddp_size, 5 );
          LST_PUT_STRING( ' Entries.' ); LST_EOLN 
        end;

        for i := 1 to pddp^.ddp_size do
        with pddp^[i] do
          if ddp_kind = ddp_direct then
          begin
            j := ddp_drt;
            if debug then
            begin
              LST_PUT_INT( i, 5 ); LST_PUT_STRING( ' ddp Direct : ' );
              LSQUSR_REFER_ID( pdrt^[j] ); LST_EOLN
            end;
            pvec^[j] := pvec^[j] + LSQ_DERIV( par_definition, pdrt^[j] )
          end
          else
          begin { Get the Sub-Parameter Partial Derivate }
            if debug then
            begin
              LST_PUT_INT( i, 5 ); LST_PUT_STRING( ' ddp Sub parameter : ' );
              LSQUSR_REFER_ID( ddp_sbp ); LST_EOLN
            end;
            der := LSQ_DERIV( par_definition, ddp_sbp );
            { Locate the Sub-Derivates from the Natives Variables/Parameters }
            k := 1;
            with ddp_sbp^ do
              if par_dervec <> nil then
                for j := 1 to par_dervec^.v_size do
                begin
                  spv := par_derlst^[j];
                  if debug then
                  begin
                    LST_PUT_INT( j, 8 );
                    LST_PUT_STRING( ' ddp Sub der from : ' );
                    LSQUSR_REFER_ID( spv ); LST_EOLN
                  end;
                  while pdrt^[k] <> spv do k := k + 1; { Look for with varbl }
                    pvec^[k] := pvec^[k] + der*par_dervec^[j]
                end
          end
      end
      else
        { Single Parameter (Without Volatile Sub-Parameter Dependance) }
        if pdrt <> nil then
        begin
          if debug then
          begin
            LST_PUT_STRING( ' With a drt table of ' ); LST_PUT_INT( pdrt^.drt_size, 5 );
            LST_PUT_STRING( ' Entries.' ); LST_EOLN 
          end;

          if fsum then
            for i := 1 to pdrt^.drt_size do
              pvec^[i] := pvec^[i] + LSQ_DERIV( par_definition, pdrt^[i] )
          else
            for i := 1 to pdrt^.drt_size do
              pvec^[i] := LSQ_DERIV( par_definition, pdrt^[i] )
        end;

      if final_eval_flg then 
        if (parf_evalsigma in par_flags) and fit_correl_set then
          LSQ_PARM_SIGMA( pa )
    end
  end
end PARM_EVAL;



function LSQ_INTEGR; { ( pn, pv: lsq_ptr; df: boolean ): lsq_real; was forward }
var
  fsum:               boolean;
  i, ii, ip, j, k, n: integer;
  idsv, der, vl, w:   lsq_real; { Saved Value of More External Summation }
  spv:                lsq_ptr;
  bl:                 rec_ptr;  { Gauss coefficient array }
  pddp:               ddp_ptr;
  pdrt:               drt_ptr;
  pvec:               vec_ptr;

begin
  with pn^ do
  begin
    if pv = nil then
    begin
      idsv := intgr_index^.idx_value; { Saved for Recursive Loop }
      bl   := intgr_coef;             { Get the coefficient table }
      n    := intgr_tabsz;            { Get the integration table size }
      ip   := 0;
      if df then { Derivate Mode (use an hidden lsq_parm) }
      begin
        for ii := 1 to n do
        begin { Summation Loop }
          w := bl^.gt[ip];            { Get the point weight }
          ip := ip + 1;
          intgr_index^.idx_value := bl^.gt[ip]; { Set the index value }
          ip := ip + 1;
          with intgr_expr^ do
          begin
            { Lines copied from PARM_EVAL Flagged by (*PE*) }
            fsum := (parf_summ in par_flags) and (ii > 1);                    (*PE*)
            if not fsum then par_value := 0.0;                                (*PE*)
            par_value := par_value + w*LSQ_VALUE( par_definition );
            if (parf_derivate in par_flags) and (par_dervec <> nil) then      (*PE*)
            begin                                                             (*PE*)
              pdrt := par_derlst; pvec := par_dervec; pddp := par_derddp;     (*PE*)
              if pddp <> nil then                                             (*PE*)
              begin { Complex Parameter (with Volatil Sub-Parm. Dependance) } (*PE*)
                if not fsum then                                              (*PE*)
                  for i := 1 to pvec^.v_size do pvec^[i] := 0.0;              (*PE*)

                for i := 1 to pddp^.ddp_size do                               (*PE*)
                with pddp^[i] do                                              (*PE*)
                  if ddp_kind = ddp_direct then                               (*PE*)
                  begin                                                       (*PE*)
                    j := ddp_drt;                                             (*PE*)
                    pvec^[j] := pvec^[j] + w*LSQ_DERIV( par_definition, pdrt^[j] )
                  end                                                         (*PE*)
                  else                                                        (*PE*)
                  begin { Get the Sub-Parameter Partial Derivate }            (*PE*)
                    der := w*LSQ_DERIV( par_definition, ddp_sbp );
                    { Locate the Sub-Derivates from the Natives Variables/Parameters }
                    k := 1;                                                   (*PE*)
                    with ddp_sbp^ do                                          (*PE*)
                      if par_dervec <> nil then                               (*PE*)
                        for j := 1 to par_dervec^.v_size do                   (*PE*)
                        begin                                                 (*PE*)
                          spv := par_derlst^[j];                              (*PE*)
                          while pdrt^[k] <> spv do k := k + 1;                (*PE*)
                            pvec^[k] := pvec^[k] + der*par_dervec^[j]         (*PE*)
                        end                                                   (*PE*)
                  end                                                         (*PE*)
              end                                                             (*PE*)
              else                                                            (*PE*)
                { Single Parameter (Without Volatile Sub-Parm. Dependance) }  (*PE*)
                if pdrt <> nil then                                           (*PE*)
                  if fsum then                                                (*PE*)
                    for i := 1 to pdrt^.drt_size do                           (*PE*)
                      pvec^[i] := pvec^[i] +
                                 w*LSQ_DERIV( par_definition, pdrt^[i] )
                  else                                                        (*PE*)
                    for i := 1 to pdrt^.drt_size do                           (*PE*)
                      pvec^[i] := w*LSQ_DERIV( par_definition, pdrt^[i] );    (*PE*)
            end;
            vl := par_value
          end
        end
      end
      else
      begin
        vl   := 0.0;
        for i := 1 to n do
        begin { Summation Loop }
          w := bl^.gt[ip];            { Get the point weight }
          ip := ip + 1;
          intgr_index^.idx_value := bl^.gt[ip]; { Set the index value }
          ip := ip + 1;
          vl := vl + w*LSQ_VALUE( intgr_expr )
        end
      end;
      intgr_index^.idx_value := idsv  { Restore for Recursive Loop }
    end
    else
      if pv = intgr_expr then vl := 1.0
                         else vl := 0.0
  end;
  LSQ_INTEGR := vl
end LSQ_INTEGR;



function LSQ_SUMLOOP; { ( pn, pv: lsq_ptr; df: boolean ): lsq_real; was forward }
var
  indstart,                           { Index start value }
  indend,                             { Index End Value (exclude) }
  indstep,                            { Index Step }
  vl,
  idxsav:     lsq_real;               { Saved Value of More External Summation }
  ict,                                { Current Summation Index Count }
  iloop:      integer;                { Number of computing of expression }

begin
  with pn^ do
  begin
    if pv = nil then
    begin
      idxsav   := summ_index^.idx_value;   { Saved for recursive loop }
      indstart := LSQ_VALUE( summ_begin ); { Compute the start index value }
      indend   := LSQ_VALUE( summ_end );   { Compute the end index value }
      indstep  := LSQ_VALUE( summ_step );  { Compute the step index value }
      iloop    := ROUND( (indend - indstart) / indstep );

      vl := 0.0;
      if df then { Derivate Mode (use an hidden lsq_parm) }
      begin
        for ict := 0 to iloop do
        begin { Summation Loop }
          summ_index^.idx_value := indstart + ict * indstep; { Set the Index Value }
          PARM_EVAL( summ_expr, (ict > 0) )
        end;
        vl := summ_expr^.par_value
      end
      else
      begin
        for ict := 0 to iloop do
        begin { Summation Loop }
          summ_index^.idx_value := indstart + ict * indstep; { Set the Index Value }
          vl := vl + LSQ_VALUE( summ_expr )
        end
      end;
      summ_index^.idx_value := idxsav { Restore for recursive loop }
    end
    else
      if pv = summ_expr then vl := 1.0
                        else vl := 0.0
  end;
  LSQ_SUMLOOP := vl
end LSQ_SUMLOOP;


function LSQ_INTERPOL; { ( pn: lsq_ptr ): lsq_real; was forward }
var
  bl:                                 rec_ptr;
  xf, c1, c2, c3, r1, r2,
  x1, x2, x3, x4, y1, y2, y3, y4, re: lsq_real;
  ip, n, ns: integer;

begin
  with pn^ do
  begin { A new interpolation is required }
    n  := inter_tbsz*2;               { Get the interpolation table size }
    bl := inter_tab;                  { Get the interpolation table address }
    xf := LSQ_VALUE( inter_expr );    { Get the value where interpolate }
    if bl <> nil then
    begin
      if n >= 8 then
      begin
        x1 := bl^.gt[0]; y1 := bl^.gt[1];
        x2 := bl^.gt[2]; y2 := bl^.gt[3];
        x3 := bl^.gt[4]; y3 := bl^.gt[5];
        x4 := bl^.gt[6]; y4 := bl^.gt[7];
        ip := 8;
        while (ip < n) and (xf > x3) do
        begin
          x1 := x2; y1 := y2; x2 := x3; y2 := y3; x3 := x4; y3 := y4;
          x4 := bl^.gt[ip];   ip := ip + 1;
          y4 := bl^.gt[ip];   ip := ip + 1
        end;
        { Four points interpolation }
        r1 := (y1 - y2)/(x1 - x2);
        r2 := (r1 - (y1 - y3)/(x1 - x3))/(x2 - x3);
        c3 := (r2 - (r1 - (y1 - y4)/(x1 - x4))/(x2 - x4))/(x3 - x4);
        c2 := r2 - (x1 + x2 + x3)*c3;
        c1 := r1 - (x1 + x2)*c2 - (x1*x1 + x1*x2 + x2*x2)*c3;
        re := y1 - x1*(c1 + x1*(c2 + x1*c3)) + xf*(c1 + xf*(c2 + xf*c3));
        inter_der := c1 + xf*(2*c2 + 3*xf*c3)
      end
      else
      case n of
        3: begin { Parabolic Form }
             x1 := bl^.gt[0]; y1 := bl^.gt[1];
             x2 := bl^.gt[2]; y2 := bl^.gt[3];
             x3 := bl^.gt[4]; y3 := bl^.gt[5];
             r1 := (y1 - y2)/(x1 - x2);
             c2 := (r1 - (y1 - y3)/(x1 - x3))/(x2 - x3);
             c1 := r1 - (x1 + x2)*c2;
             re := y1 - x1*(c1 + x1*c2) + xf*(c1 + xf*c2);
             inter_der := c1 + 2*xf*c2
           end;

        2: begin { Linear Form }
             x1 := bl^.gt[0]; y1 := bl^.gt[1];
             c1 := (y1 - bl^.gt[3])/(x1 - bl^.gt[2]);
             re := y1 + c1*(xf - x1);
             inter_der := c1
           end;

        1: begin  re := bl^.gt[1]; inter_der := 0.0  end;
      otherwise
        re := 0.0; inter_der := 0.0
      end
    end
    else
    begin  re := 0.0; inter_der := 0.0  end
  end;
  LSQ_INTERPOL := re
end LSQ_INTERPOL;



procedure LSQ_EXEC_EVAL( lpar: lsq_ptr; binit: boolean ); forward;



procedure CACHE_CONNECT( pca: cache_ptr );
var
  ent: entry_ptr;

begin
  { Set the Selected Cache Parameter Derivate Vector and Value }
  ent := pca^.cache_entry;            { Get the first entry address }
  repeat
    with ent^, entry_par^ do
    begin
      par_value := entry_val;         { Select the old value }
      par_dervec := entry_table;      { Select the old derivate table }
      ent := entry_next
    end
  until ent = nil;
end CACHE_CONNECT;


procedure CACHE_SAVE( pca: cache_ptr );
var
  ent: entry_ptr;

begin
  ent := pca^.cache_entry;            { Get the First Entry Address }
  repeat
    with ent^ do
    begin
      entry_val := entry_par^.par_value;  { Save the old value }
      ent := entry_next
    end
  until ent = nil;
end CACHE_SAVE;



function LIST_NEXT( lis: lsq_ptr ): lsq_statusty;
var
  pca, pcf:   cache_ptr;
  ent:        entry_ptr;
  curr_ident: integer;
  status:     lsq_statusty;
  bfnd, bstp: boolean;

begin { LIST_NEXT }
  status := lsq_success;
  with lis^ do
  if lis_endflg then
    status := lsq_eof
  else
  begin
    bstp := false;
    repeat
      { *** Progress to Next List Element or Set the EOF Flag *** }
      if LSQUSR_LIST_NEXT( lis ) then { Read O.K. }
      begin
        if lis_count = 0 then status := lsq_init;
        { Handle the Stop Condition for All List }
        if (lis_stpcond <> nil) and (LSQ_VALUE( lis_stpcond ) >= 0.5) then
        begin
          LSQUSR_LIST_CLOSE( lis );   { Close the list }
          bstp := true;               { Stop the Scan }
          lis_endflg := true;         { Simulate a End Of List }
          status := lsq_stop          { Set the Return State }
        end
        else
        { Handle the Eligibility Condition }
        if (lis_condit <> nil) and (LSQ_VALUE( lis_condit ) >= 0.5) then
          bstp := true
      end
      else
      begin { End Of List Reached }
        LSQUSR_LIST_CLOSE( lis );     { Close the List }
        bstp := true;                 { Stop the List Scan }
        lis_endflg := true;           { Flag the End Of List }
        status := lsq_eof             { Set the Return State }
      end

    until bstp;

    { When the Next Element is Available }
    if status <= lsq_init then
    begin { Cache Management if a Cache is Defined }
      if lis_cachefirst <> nil then
      begin  { A cache is existing }
        pcf := nil;
        { Get the cache identifier of this element }
        if lis_ident >= 0 then
          curr_ident := BLK_LI( lis_current, lis_ident )
        else
          curr_ident := -maxint;      { Set as invalid cache identifier }
        { On Init Time we must erase all the cache }
        if status = lsq_init then     { On init time ... }
        begin                         { We Must Clear the Cache }
          pca := lis_cachefirst;
          while pca <> nil do         { We Must Erase the Cache }
            with pca^ do
            begin                     { ... to the invalid state }
              cache_ident := maxint;
              pca := cache_next
            end;
          pca := lis_cachefirst       { ... and Set the First Cache Entry }
        end
        else                          { The Cache is not Empty }
          if curr_ident = -maxint then { If the Cache Identifier is Invalid }
            pca := lis_cachelast      { ... we set in the End Of Cache }
          else
          begin                       { We must Search it in the Cache }
            pca := lis_cachefirst;    { Start search from begin of cache }
            bstp := false;
            repeat
              with pca^ do
                if cache_ident = curr_ident then
                  bfnd := true
                else
                  if (cache_ident = maxint) or (cache_next = nil) then
                    bstp := true
                  else
                  begin
                    pcf := pca;
                    pca := cache_next
                  end
            until bstp or bfnd;
          end;
        { Now Set the Selected Cache (pca^) as the Most Recently Used }
        { pcf is the Previous Cache Record or nil when pca^ is the First One }
        with pca^ do
        begin
          if pcf <> nil then { Nothing to Change, when the Record is the First }
          begin { We must save the parameter values in the entry_val fields }
            CACHE_SAVE( pcf );
            pcf^.cache_next := cache_next; { Link previous to next }
            { If the cache record is not the last }
            if cache_next <> nil then { ... link next with previous }
              cache_next^.cache_previous := pcf;
            cache_previous := nil;    { No previous rec. for the new first }
            cache_next := lis_cachefirst; { Old first rec. become the second }
            { Change the Last Pointer when the New First was the Last }
            if pca = lis_cachelast then lis_cachelast := pcf;
            lis_cachefirst := pca     { Set the rec. as the first }
          end;
          if not bfnd then cache_ident := curr_ident
        end;
        CACHE_CONNECT( pca );
      end
      else bfnd := false;             { No cache }
      { When the Element was not Present in a Cache, it must be Computed }
      if not bfnd then LSQ_EXEC_EVAL( lis_dirlist, status = lsq_init )
    end { New Element (status <= lsq_init) }
  end;
  LIST_NEXT := status
end LIST_NEXT;



function LSQ_LIST_INIT( lis: lsq_ptr ): lsq_statusty;
begin
  with lis^ do
  if lis_descriptor <> nil then
    if LSQUSR_LIST_OPEN( lis ) then { Try to open the associated file }
    begin
      lis_endflg := false;
      lis_count := 0;
      LSQ_LIST_INIT := lsq_success
    end
    else
    begin
      lis_endflg := true;
      LSQ_LIST_INIT := lsq_eof
    end
  else
  begin
    lis_endflg := true;
    lis_count := -1;
    LSQ_LIST_INIT := lsq_eof
  end
end LSQ_LIST_INIT;



function FILL_WINDOW( sca: lsq_ptr; condit: lsq_ptr ): lsq_statusty;
var
  pli:          lsq_ptr;
  pca:          cache_ptr;
  nvalid, nuse: integer;
  status:       lsq_statusty;
  bstp:         boolean;

begin
  with sca^ do
  begin
    pli := sca_list;
    if pli^.lis_current = nil then
    begin { Initialize Window Operation }
      { Search for Condition OK. }
      repeat
        status := LIST_NEXT( pli )
      until (status >= lsq_stop) or (LSQ_VALUE( condit ) >= 0.5);
      if status < lsq_stop then
      begin { We fill must the Window up to the Full State }
        sca_invalid := nil;
        nuse        := 1;
        nvalid      := 1
      end
    end
    else
    begin { Continue Window Operation }
      pca := pli^.lis_cachelast;
      CACHE_CONNECT( pca );
      nvalid := sca_windowvalid;
      nuse   := sca_windowuse;
      { *** Elliminates all Old Selected Element *** }
      while (LSQ_VALUE( condit ) < 0.5) and (pca <> nil) do
      begin
        nuse := nuse - 1;
        if nvalid > 0 then nvalid := nvalid - 1;
        pca  := pca^.cache_previous;
        CACHE_CONNECT( pca )
      end;
      { *** Examines the validity of the Invalids Present in the Window *** }
      if sca_invalid <> nil then
      begin
        CACHE_CONNECT( sca_invalid );
        while (LSQ_VALUE( condit ) >= 0.5) and (pca <> nil) do
        begin
          nvalid      := nvalid + 1;
          sca_invalid := sca_invalid^.cache_previous;
          CACHE_CONNECT( sca_invalid )
        end
      end
    end;

    { *** Common Part *** }

    { *** Try to Complet the Window *** }
    if not lis_endflg then
    begin
      repeat
        status := LIST_NEXT( pli );
        nuse   := nuse + 1;
        if LSQ_VALUE( condit ) >= 0.5 then
          nvalid := nvalid + 1
        else
          sca_invalid := pli^.lis_cachefirst
      until (status >= lsq_stop) or (nuse >= pli^.lis_cachesize);
      { set the invalid cache ptr to the first invalid found }
      if nuse >= pli^.lis_cachesize then
      begin
        sca_invalid := nil;
        status      := lsq_cacheovf
      end
      else
        status := lsq_success
    end
    else
      if nvalid > 0 then status := lsq_success
      else status := lsq_eof;
    sca_windowvalid := nvalid;
    sca_windowuse   := nuse
  end;
  FILL_WINDOW := status
end FILL_WINDOW;



function LSQ_SCAN( sca: lsq_ptr ): lsq_statusty;
var
  win:           cache_ptr;
  nct:           integer;
  status:        lsq_statusty;
  condit, binit: boolean;

begin
  with sca^ do
  begin
    case sca_type of

      scaf_complete: begin
          status := LSQ_LIST_INIT( sca_list );  { Initialise the List }
          if status = lsq_success then
          begin
            status := LIST_NEXT( sca_list );
            binit  := true;
            while status <= lsq_stop do
            begin
              LSQ_EXEC_EVAL( sca_dir, binit );
              binit  := false;
              status := LIST_NEXT( sca_list )
            end
          end;
          status := lsq_success
        end;

      scaf_partial:
        { The LSQ_LIST_INIT must be Executed Before }
        if sca_list^.lis_endflg then
          status := lsq_eof
        else
        begin
          binit := true;
          repeat
            status := LIST_NEXT( sca_list );
            condit := (LSQ_VALUE( sca_condit ) >= 0.5 );
            if status < lsq_stop then LSQ_EXEC_EVAL( sca_dir, binit );
            binit  := false
          until (status >= lsq_stop) or condit
        end;

      scaf_window:
        { The LSQ_LIST_INIT must be Executed Before }
        if sca_list^.lis_endflg then
          status := lsq_eof
        else
        begin
          status := FILL_WINDOW( sca, sca_condit );
          if status = lsq_cacheovf then LSQUSR_ERROR( 1, 2, sca_list );
          if status < lsq_stop then
          begin
            win   := sca_list^.lis_cachelast;
            binit := true;
            nct   := sca_windowvalid;
            while nct > 0 do
            begin
              CACHE_CONNECT( win );
              LSQ_EXEC_EVAL( sca_dir, binit );
              win   := win^.cache_previous;
              binit := false;
              nct   := nct - 1
            end
          end
        end
    end { case ... }
  end;
  LSQ_SCAN := status
end LSQ_SCAN;



procedure LSQ_EXEC_EVAL { ( lpar: lsq_ptr; binit: boolean ) was forward };
var
  eq: eqv_type;
  i:  integer;
  r:  lsq_real;

begin
  while lpar <> nil do
  with lpar^ do
  begin
    case lsq_ndty of
      nd_parm: PARM_EVAL( lpar, not binit );

      nd_scandir: if LSQ_SCAN( lpar ) = lsq_eof then
                    LSQ_EXEC_EVAL( sca_endlist, binit );

      nd_initlist: LSQ_LIST_INIT( initlist_list );

      nd_storedir:
        begin
          r := LSQ_VALUE( sto_expr );
          case sto_subdir of
            nd_ub_listref:
              sto_l_list^.lis_current^.ubt[sto_l_offset] := ROUND( r );
            nd_sb_listref:
              sto_l_list^.lis_current^.sbt[sto_l_offset] := ROUND( r );
            nd_uw_listref:
              sto_l_list^.lis_current^.uwt[sto_l_offset] := ROUND( r );
            nd_sw_listref:
              sto_l_list^.lis_current^.swt[sto_l_offset] := ROUND( r );
            nd_li_listref:
              sto_l_list^.lis_current^.it[sto_l_offset]  := ROUND( r );
            nd_fl_listref:
              sto_l_list^.lis_current^.ft[sto_l_offset]  := r;
            nd_db_listref:
              sto_l_list^.lis_current^.gt[sto_l_offset]  := r;


            nd_ub_refer:
              sto_r_pointer^.ubt[sto_r_offset] := ROUND( r );
            nd_sb_refer:
              sto_r_pointer^.sbt[sto_r_offset] := ROUND( r );
            nd_uw_refer:
              sto_r_pointer^.uwt[sto_r_offset] := ROUND( r );
            nd_sw_refer:
              sto_r_pointer^.swt[sto_r_offset] := ROUND( r );
            nd_li_refer:
              sto_r_pointer^.it[sto_r_offset]  := ROUND( r );
            nd_fl_refer:
              sto_r_pointer^.ft[sto_r_offset]  := r;
            nd_db_refer:
              sto_r_pointer^.gt[sto_r_offset]  := r;
          otherwise
          end
        end;

      nd_ifdir:
        begin
          if_vflag := (LSQ_VALUE( if_expr ) >= 0.5);
          if if_vflag then LSQ_EXEC_EVAL( if_truenext, binit )
                      else LSQ_EXEC_EVAL( if_falsenext, binit )
        end;

      nd_casedir:
        begin
          eq.int := ROUND( LSQ_VALUE( case_selector ) ) - case_min;
          if (eq.int >= 1) and (eq.int <= case_table^.drt_size) then
              case_cursel := case_table^[eq.int]
            else
              case_cursel := case_other;
          LSQ_EXEC_EVAL( case_cursel, binit )
        end;

      nd_user_call: LSQUSR_PROCEDURE( usercall_id, usercall_parm );

    otherwise { Ignore Illegal Directive }
    end;
    lpar := lsq_next
  end
end LSQ_EXEC_EVAL;



[global]
procedure LSQ_CONSTRAINT( lf: lsq_ptr );
var
  regflg:       boolean;
  dim, i, j, k: integer;
  cmpval, obsval, sigma, weight, delta, delw, r1, derv_i, derw2: lsq_real;
  pblk:         lsq_ptr;
  pb, pm, pv:   vec_ptr;

begin
  with lf^ do
  begin
    LSQ_EXEC_EVAL( coll_pckdir, true );

    { *** Get the Observation Information *** }
    cmpval  := coll_computed^.par_value;

    obsval  := LSQ_VALUE( coll_observed );
    sigma   := LSQ_VALUE( coll_sigma );
    weight  := LSQ_VALUE( coll_weight );
    delta   := obsval - cmpval;
    delw    := delta*weight;

    regflg  := (delw >= coll_reject);

    LSQUSR_CONSTRAINT( lf, obsval, cmpval, delta, sigma, weight, delw, regflg );

    if not regflg then   { Rejection Condition Handling }
    begin
      { *** Summation for Squared Goodness of Fit *** }
      with fit_statis^ do
      begin
        if sigma > 0.0 then
          stat_sumstd := stat_sumstd + SQR( delta / sigma );
        r1       := delta * weight;
        stat_surwsqr := stat_surwsqr + SQR( r1 );
        stat_sursqr  := stat_sursqr  + SQR( delta );
        stat_surwabs := stat_surwabs + ABS( r1 );
        stat_surabs  := stat_surabs  + ABS( delta );
        r1       := obsval * weight;
        stat_suowsqr := stat_suowsqr + SQR( r1 );
        stat_suowabs := stat_suowabs + ABS( r1 );
        stat_suosqr  := stat_suosqr  + SQR( obsval );
        stat_suoabs  := stat_suoabs  + ABS( obsval );
      end;

      { *** Build Summation on Derivate and Matrix *** }

      LSQ_INITIALIZE_PDER_VAL;  { initialize the blk_vect_x vectors }

      { Compute the Final Derivates }
      LSQ_SET_PDER_VAL( coll_computed, 1.0 );

      { Built the Least-Squares Matrixs }

      pblk     := fit_blkfirst;
      while pblk <> nil do
        with pblk^ do
        begin
          pv := blk_vect_x;
          pb := blk_vect_b;
          pm := blk_matrix;
          if pv <> nil then
          begin
            dim  := pb^.v_size;
            k    := 0;
            for i := 1 to dim do
            begin
              derv_i := pv^[i]*weight;
              derw2  := derv_i*weight*blk_effmarq;
              pb^[i] := pb^[i] + delw*derv_i;
              if fit_bmatrix and (pm <> nil) then
              begin { Proceed when Matrix Computing is Enable}
                k := k + 1;
                pm^[k] := pm^[k] + SQR( derv_i );
                for j := i + 1 to dim do
                begin
                  k := k + 1;
                  pm^[k] := pm^[k] + derw2*pv^[j]
                end
              end
            end
          end;
          pblk := blk_next
        end

    end { If delw <= coll_reject then ... }
  end
end LSQ_CONSTRAINT;




[global]
procedure LSQ_COLLECT( lf: lsq_ptr );
var
  pblk:                                  lsq_ptr;
  r1,       derv_i,   delta,
  delw,     derw2,    sumstd,
  sumrwsqr, sumrwabs, sumrsqr, sumrabs,
  sumowsqr, sumowabs, sumosqr, sumoabs,
  cmpval,   obsval,   sigma,   weight:   lsq_real;
  dim,      i, j, k,  obsnb,   nobs,     ncontr,       nvar:     integer;
  status:                                lsq_statusty;
  regflg,   condit,   fitinit, pckinit:  boolean;
  pb,       pm,       pv:                vec_ptr;

begin { LSQ_COLLECT }
  with lf^ do
  begin
    LSQUSR_COLL_START( lf );

    status := LSQ_LIST_INIT( coll_list );
    if status = lsq_success then
    begin
      { *** Initialization for the Data Collection *** }
      obsnb    := 0;   ncontr   := 0;
      sumstd   := 0.0;
      sumrwsqr := 0.0; sumrwabs := 0.0;
      sumrsqr  := 0.0; sumrabs  := 0.0;
      sumowsqr := 0.0; sumowabs := 0.0;
      sumosqr  := 0.0; sumoabs  := 0.0;

      { *** Loop on all Observations *** }
      fitinit  := true;               { Init Global Summation }
      repeat
        nobs := obsnb + 1;
        { *** loop on one packet *** }
        pckinit := true;              { Init Packet Summation }
        repeat
          ncontr := ncontr + 1;
          status := LIST_NEXT( coll_list ); { Get a Packet Element }
          if status < lsq_stop then
          begin                       { If no end of list }
            LSQ_EXEC_EVAL( coll_pckdir, pckinit );
            pckinit := false;         { ... summation mode for next }
            condit  := (LSQ_VALUE( coll_condit ) > 0.5);
            LSQUSR_COLL_CONTRIBUTION( lf, ncontr, nobs, condit )
          end
        until (status >= lsq_stop) or condit;

        if status < lsq_stop then
        begin
          { *** Get the Observation Information *** }
          cmpval  := coll_computed^.par_value;

          obsval  := LSQ_VALUE( coll_observed );
          sigma   := LSQ_VALUE( coll_sigma );
          weight  := LSQ_VALUE( coll_weight );
          delta   := obsval - cmpval;
          delw    := delta*weight;

          regflg  := (delw >= coll_reject);

          LSQUSR_COLL_PACKET( lf, nobs,
                              obsval, cmpval, delta, sigma,
                              weight, delw, regflg );


          if not regflg then   { Rejection Condition Handling }
          begin
            { *** Summation for Squared Goodness of Fit *** }
            obsnb := nobs;

            if sigma > 0.0 then sumstd := sumstd + SQR( delta / sigma );
            r1       := delta * weight;
            sumrwsqr := sumrwsqr + SQR( r1 );
            sumrwabs := sumrwabs + ABS( r1 );
            sumrsqr  := sumrsqr  + SQR( delta );
            sumrabs  := sumrabs  + ABS( delta );
            r1       := obsval * weight;
            sumowsqr := sumowsqr + SQR( r1 );
            sumowabs := sumowabs + ABS( r1 );
            sumosqr  := sumosqr  + SQR( obsval );
            sumoabs  := sumoabs  + ABS( obsval );

            { *** build summation on derivate and matrix *** }

            LSQ_INITIALIZE_PDER_VAL;  { Initialize the blk_vect_x vectors }
            { Compute the Final Derivates }
            LSQ_SET_PDER_VAL( coll_computed, 1.0 );

            { Built the Least-Squares Matrixs }
            pblk     := fit_blkfirst;
            while pblk <> nil do
            with pblk^ do
            begin
              pv := blk_vect_x;
              pb := blk_vect_b;
              pm := blk_matrix;
              if pv <> nil then
              begin
                dim  := pb^.v_size;
                k    := 0;
                for i := 1 to dim do
                begin
                  derv_i := pv^[i]*weight;
                  derw2  := derv_i*weight*blk_effmarq;
                  pb^[i] := pb^[i] + delw*derv_i;
                  if fit_bmatrix and (pm <> nil) then
                  begin { Proceed when Matrix Computing is Enable }
                    k := k + 1;
                    pm^[k] := pm^[k] + SQR( derv_i );
                    for j := i + 1 to dim do
                    begin
                      k := k + 1;
                      pm^[k] := pm^[k] + derw2*pv^[j]
                    end
                  end
                end
              end;
              pblk := blk_next
            end
          end { if delw <= coll_reject then ... }
        end { if status < lsq_stop }
      until status >= lsq_stop;       { Stop On End Of Data Collection }

      { *** Set the Local Test Numbers *** }
      with coll_statis^ do
      begin
        if effnvarbl >= obsnb then nvar := obsnb
                              else nvar := obsnb - effnvarbl;
        stat_usrchi2 := sumrwsqr / nvar;
        stat_stdchi2 := sumstd   / nvar;
        stat_sumstd  := sumstd;
        stat_surwsqr := sumrwsqr;         
        stat_surwabs := sumrwabs;
        stat_sursqr  := sumrsqr;
        stat_surabs  := sumrabs;
        stat_suowsqr := sumowsqr;         
        stat_suowabs := sumowabs;
        stat_suosqr  := sumosqr;
        stat_suoabs  := sumoabs;
        stat_obsnb   := obsnb
      end;
      LSQ_EXEC_EVAL( coll_cycldir, true )
    end
  end;

  LSQUSR_COLL_END( lf )

end LSQ_COLLECT;



procedure LSQ_MATINV( var matrix, vector: vec_tab;
                      var nfail: integer; var psing: lsq_ptr );
{ Inversion of a Symetric Matrix in One Dimensional Compressed Form }
var
  suma, term, denom:                             lsq_real;
  i, j, k, l, m, kli, kmi, i1, ii, kdm, imax, n: integer;
  berr: boolean;

begin
  n    := vector.v_size;
  berr := false ;
  { Matrix Triangularization }
  k := 1 ;
  m := 1 ;
  { loop on m }
  repeat
    imax := m - 1 ;
    l := m ;
    { loop on l }
    repeat
      suma := 0.0 ;
      kli := l;
      kmi := m;
      if imax > 0 then
	{ sum over i = 1,m-1 a(l,i)*a(m,i) }
	for i := 1 to imax do
	begin
	  suma := suma + matrix[kli] * matrix[kmi] ;
	  j := n - i ;
	  kli := kli + j ;
	  kmi := kmi + j
	end;
      { term = c(l,m) - sum }
      term := matrix[k] - suma ;
      if l <= m then
      begin
	{ a(m,m) = SQRT( term ) }
	if term > fit_mindiag then
	begin
	  denom := SQRT( term ) ;
	  matrix[k] := denom
	end
	else
	begin                         { Singularity detected }
	  denom := 1.0;
          matrix[k] := denom;         { Set denom to 1.0 and set 0.0 for
			                non diagonal corresponding terms }
	  for i := k + 1 to k + n - m do
            matrix[i] := 0.0;
	  kmi := m;
	  for i := 1 to imax do
	  begin
	    matrix[kmi] := 0.0;
            kmi := kmi + n - i
	  end;
	  vector[m] := 0.0;             { Clear the constant vector }
	  { Signal Error }
          nfail := nfail + 1;
          LSQUSR_SINGULARITY( psing, nfail, fit_maxsing < nfail );
	  if nfail > fit_maxsing then berr := true
	end
      end
      { a(l,m) = term/a(m,m) }
      else matrix[k] := term / denom;
      k := k + 1 ;
      l := l + 1
    until (l > n) or berr;
    { end of l Loop }
    m := m + 1;
    psing := psing^.var_nxtbl         { Scan to next variable in the diagonal block }
  until (m > n) or berr;
  { end of m Loop }
  if not berr then
  begin { Matrix Inversion }
    matrix[1] := 1.0 / matrix[1] ;
    kdm := 1;
    { Step l of b(l,m) }
    for l := 2 to n do
    begin
      kdm := kdm + n - l + 2 ;
      { Reciprocal of Diagonal Term }
      term := 1.0 / matrix[kdm] ;
      matrix[kdm] := term ;
      kmi := 0;
      kli := l;
      imax := l - 1 ;
      { Step m of b(l,m) }
      for m := 1 to imax do
      begin
	k := kli ;
	{ Sum Terms }
	suma := 0.0 ;
	for i := m to imax do
	begin
	  ii := kmi + i ;
	  suma := suma - matrix[kli]*matrix[ii] ;
	  kli := kli + n - i
	end ;
	{ Mult sum * recip diagonal }
	matrix[k] := suma * term ;
	j := n - m ;
	kli := k + j ;
	kmi := kmi + j
      end
    end ;
    { Premultiply Lower Triangle by Transpose }
    k := 1;
    for m := 1 to n do
    begin
      kli := k ;
      for l := m to n do
      begin
	kmi := k ;
	imax := n - l + 1 ;
	suma := 0.0 ;
	for i := 1 to imax do
	begin
	  suma := suma + matrix[kli] * matrix[kmi] ;
	  kli := kli + 1 ;
	  kmi := kmi + 1
	end ;
	matrix[k] := suma ;
	k := k + 1
      end
    end
  end
end LSQ_MATINV;


procedure LSQ_RESOLV( var matrix, vector_b, vector_x: vec_tab );
{ Resolution of System after Matinv Execution for
  symetric matrix in one dimensional compressed form }
var
  pdi:              lsq_real;
  i, j, ijd, ij, n: integer;

begin
  n := vector_b.v_size;
  for i := 1 to n do
  begin
    pdi := 0.0 ;
    ij := i;
    ijd := n - 1 ;
    for j := 1 to n do
    begin
      pdi := pdi + matrix[ij] * vector_b[j] ;
      if j < i then
      begin
	ij := ij + ijd ;
	ijd := ijd - 1
      end
      else
	ij := ij + 1
    end ;
    vector_x[i] := pdi
  end
end LSQ_RESOLV;



procedure LSQ_UPDATE_VARBL( pblk: lsq_ptr; final_flg: boolean );

var
  cvar:                                 lsq_ptr;
  dmp, cnv, shift, oldval, newval, sig: lsq_real;
  i, k, l, lflg:                        integer;

begin
  with pblk^ do
  begin
    k    := 1;
    l    := blk_vect_x^.v_size;
    dmp  := blk_effdmp;
    cvar := blk_frsvar
  end;

  for i := 1 to l do
  begin
    with cvar^ do
    begin
      oldval    := var_value;
      sig       := SQRT( ABS( pblk^.blk_matrix^[k]*sav_chi2 ) );
      lflg      := 0;                 { Assume no limit reach }

      if final_flg then
      begin                           { for Final Cycle }
        newval  := oldval;
        shift   := 0.0
      end
      else
      begin                           { for Normal Cycle }
        shift   := pblk^.blk_vect_x^[i]*dmp;
        newval  := shift + oldval;    { Deduce the new variable value }
        if var_limits <> nil then
        with var_limits^ do
        begin
          if lim_low < lim_up then    { Normal Limit Mode }
            if newval < lim_low then  { Low limit reached }
            begin
              lflg := 1;
              newval := lim_low
            end
            else
            begin
              if newval > lim_up then { Hight limit reached }
              begin
                lflg := 1;
                newval := lim_up
              end
            end
          else                        { Modulo Mode }
          begin
            cnv := (newval - lim_up)/lim_low;
            if cnv > 1.0 then
            begin
              lflg := -1;
              newval := newval - TRUNC( cnv )*lim_low
            end
            else
              if cnv < 0.0001 then
              begin
                lflg := -1;
                newval := newval + (TRUNC( ABS( cnv ) ) + 1)*lim_low
              end
          end;
          shift := newval - oldval
        end
      end;

      LSQUSR_VARIABLE( cvar, newval, sig, shift, lflg, i = 1, final_flg );

      with cvar^ do
      begin
        if not final_flg then
          var_value := newval;        { Set the new value }
        var_sigma := sig;             { Set the new sigma }
        cvar := var_nxtbl             { Continue to next variable }
      end;
      
      k := k + l; l := l - 1          { Skip to next diagonal term }
    end                               { End of Variable Loop }
  end
end LSQ_UPDATE_VARBL;



[global]
procedure LSQ_CYCLE( final_flg: boolean );
var
  pblk, cvar, coll: lsq_ptr;
  nfail, i, nvar:   integer;

begin { LSQ_CYCLE }
  { *** Initialize the Least-Square Cycle *** }
  nfail := 0;
  with fit_statis^ do
  begin
    stat_sumstd  := 0.0;      { Sum ( sqr(delta/sigma ) }
    stat_surwsqr := 0.0;      { Sum ( sqr(delta*weight)) }
    stat_sursqr  := 0.0;      { Sum ( sqr(delta)) }
    stat_surwabs := 0.0;      { Sum ( abs(delta*weight)) }
    stat_surabs  := 0.0;      { Sum ( abs(delta)) }
    stat_suowsqr := 0.0;      { Sum ( sqr(obser*weight)) }
    stat_suosqr  := 0.0;      { Sum ( sqr(obser)) }
    stat_suowabs := 0.0;      { Sum ( abs(obser*weight)) }
    stat_suoabs  := 0.0;      { Sum ( abs(obser)) }
    stat_obsnb   := 0         { Partial count of really used obs. }
  end;

  { *** Comput all Init Cycle Least-Square Parameters ***}
  LSQ_EXEC_EVAL( fit_cyclstdir, false );

  pblk := fit_blkfirst;
  while pblk <> nil do
  with pblk^ do
  begin
    if blk_vect_x <> nil then
    begin
      { *** Init the Constant Vector *** }
      for i := 1 to blk_vect_b^.v_size do  blk_vect_b^[i] := 0.0;
      { *** Init the matrix *** }
      if fit_bmatrix and (blk_matrix <> nil) then
      for i := 1 to blk_matrix^.v_size do  blk_matrix^[i] := 0.0;
      { *** Evaluate the Marqward-Levenberg Factor *** }
      blk_effmarq := LSQ_VALUE( blk_marqwc )
    end;
    pblk := blk_next;                 { Skip to next block or end }
  end;

  { Call Signal Start of Cycle Procedure }
  LSQUSR_CYCL_START( fit_ncycle, final_flg );

  { *** Scan on all Data Collections *** }
  coll := fit_collfirst;
  while coll <> nil do
  with coll^ do
  begin
    if coll_enable then
    begin
      if coll_list = nil then
        LSQ_CONSTRAINT( coll )        { Computing for a Soft Constraint }
        { LSQ_CONSTRAINT perform the fit_statis^ update }
      else
      begin
        LSQ_COLLECT( coll );          { Computing for this Data Collection }

        with fit_statis^ do
        begin
          stat_sumstd  := stat_sumstd   + coll_statis^.stat_sumstd;
          stat_surwsqr := stat_surwsqr  + coll_statis^.stat_surwsqr;
          stat_sursqr  := stat_sursqr   + coll_statis^.stat_sursqr;
          stat_surwabs := stat_surwabs  + coll_statis^.stat_surwabs;
          stat_surabs  := stat_surabs   + coll_statis^.stat_surabs;
          stat_suowsqr := stat_suowsqr  + coll_statis^.stat_suowsqr;
          stat_suosqr  := stat_suosqr   + coll_statis^.stat_suosqr;
          stat_suowabs := stat_suowabs  + coll_statis^.stat_suowabs;
          stat_suoabs  := stat_suoabs   + coll_statis^.stat_suoabs;
          stat_obsnb   := stat_obsnb    + coll_statis^.stat_obsnb;
          if stat_obsnb <= effnvarbl then nvar := stat_obsnb
                                     else nvar := stat_obsnb - effnvarbl;
          stat_usrchi2 := stat_surwsqr  / nvar;
          stat_stdchi2 := stat_sumstd   / nvar;
          sav_chi2     := stat_usrchi2
        end
      end
    end;

    coll := coll_next
  end;

  { *** Solve the Least-Squares System(s) *** }

  LSQUSR_CYCL_RES( fit_ncycle );

  pblk := fit_blkfirst;
  while pblk <> nil do

  with pblk^ do
  begin
    if blk_matrix <> nil then
    begin
      { Get the first variable of diagonal block }
      cvar       := blk_frsvar;
      blk_effdmp := LSQ_VALUE( blk_dmp ); { Evaluate the dampening factor }
      { Matrix Invertion }
      if fit_bmatrix then
        LSQ_MATINV( blk_matrix^, blk_vect_b^, nfail, cvar );
      if nfail <= fit_maxsing then      { OK. for Inversion }
      begin
        { System Solve }
        LSQ_RESOLV( blk_matrix^, blk_vect_b^, blk_vect_x^ );

        { *** Evaluate the Damping Factor *** }
        blk_effdmp := LSQ_VALUE( blk_dmp );
        { *** to update the Least-Squares Variables *** }
        { Scan all fit variables of this diagonal block }
        LSQ_UPDATE_VARBL( pblk, final_flg )
      end
      else fit_stop := true
    end;
    pblk := blk_next
  end;

  if not fit_stop then
  begin
    LSQUSR_CYCL_END( fit_ncycle );

    { *** Comput all Cycle Dependant Least-Square Parameters ***}
    LSQ_EXEC_EVAL( fit_cycldir, false );

  end
end LSQ_CYCLE;




procedure LSQ_CORRELATION;
{ Procedure to compute the Correlation Matrixs }
var
  pvar, pblk:                       lsq_ptr;
  elem_ii, vmij, vmiijj:            lsq_real;
  dim, ijp, iip, jjp, li, lj, i, j: integer;
  pm:                               vec_ptr;

begin
  pblk := fit_blkfirst;
  while pblk <> nil do
  with pblk^ do
  begin
    if blk_vect_x <> nil then
    begin
      pvar := blk_frsvar;             { Get the first variable pointer }
      dim  := blk_vect_b^.v_size;     { Get the matrix dimension }
      pm := blk_matrix;
      if pm <> nil then
      begin
        ijp := 1;                     { Start from elem_11 }
        li  := dim;                   { Length of the first matrix line }
        for i := 1 to dim - 1 do      { Loop on i }
        begin
          elem_ii   := SQRT( ABS( pm^[ijp] ) ); { Get elem_ii }
          pm^[ijp] := pvar^.var_sigma;  { Set the diagonal element as }
                                      { The related variable sigma }
          pvar := pvar^.var_nxtbl;    { Skip to next variable }
          jjp  := ijp + li;           { jjp -> start of next line }
          ijp  := ijp + 1;            { Skip to next line element }
          li   := li  -  1;           { The next line is shortest from one element }
          lj   := li;                 { Set the j line length }
          for j := i + 1 to dim do
          begin
            vmiijj := elem_ii*SQRT( ABS( pm^[jjp] ) );
            vmij   := pm^[ijp];
            if vmij*1E-20 < vmiijj then pm^[ijp] := vmij/vmiijj
                                   else pm^[ijp] := 10.0;
            ijp := ijp + 1;           { Skip to next line element }
            jjp := jjp + lj;          { jjp -> start of next line }
            lj  := lj - 1             { Set the next j line length }
          end
        end;
        pm^[ijp] := pvar^.var_sigma   { Do also for the last variable }
      end;
      LSQUSR_CORRELATION( pblk, dim )
    end;
    pblk := blk_next
  end;
  fit_correl_set := true
end LSQ_CORRELATION;



[global]
procedure LSQ_FIT( n_cycle,          { Number of Cycle to Perform }
                   cycle_id,         { First Cycle Number }
                   maxsing: integer; { Maximum of Singularity/Cycle }
                   mindiag: lsq_real;{ Minimum of Matrix Pivot }
                   ls_bmatrix,       { Flag to suppress matrix comp.}
                   ls_noendcycle,    { Flag to disable final cycle }
                   ls_correl,        { Flag for correlation comp.}
                   ls_vchi2: boolean { Flag for no varbl number depend goodness of fit }
                 );

begin
  { Performs the General Initialization }
  if cycle_id >= 1 then fit_ncycle := cycle_id;
  if ls_vchi2 then effnvarbl := 0
              else effnvarbl := fit_nvarbl;
  fit_maxsing     := maxsing;
  fit_mindiag     := mindiag;
  fit_setbmatrix  := ls_bmatrix;
  fit_noendcycle  := ls_noendcycle;
  fit_correlation := ls_correl;

  fit_correl_set  := false;           { Disable the possible correlation mode }
  fit_stop        := false;           { Erase any trailing stop condition }
  fit_bmatrix     := true;            { Set matrix computing flag }

  final_eval_flg  := false;           { Disable any parameter sigma evaluation }

  repeat
    if n_cycle > 0 then fit_ncycle := fit_ncycle + 1;

    LSQ_CYCLE( n_cycle = 0 );         { Perform one fit cycle }

    if fit_setbmatrix then fit_bmatrix := false;

    n_cycle := n_cycle - 1;
  until (n_cycle < 0) or ((n_cycle = 0) and fit_noendcycle) or fit_stop;

  if not (fit_stop or fit_noendcycle) then
  begin
    if fit_correlation then LSQ_CORRELATION;
    { Evaluate the Final Parameters }
    final_eval_flg := true;

    { *** Re-Comput all Init Cycle Least-Square Parameters ***}
    LSQ_EXEC_EVAL( fit_cyclstdir, false );

    LSQ_EXEC_EVAL( fit_cycldir,   false );

    LSQ_EXEC_EVAL( fit_fitdir,    false );
    LSQUSR_END_FIT
  end

end LSQ_FIT;



procedure ADD_VARIABLE_REFERENCE( va: lsq_ptr; imode: integer );
var
  i: integer;

begin
  with va^ do
    if var_matind > 0 then     { Not a fixed variable }
    begin
      { Set the object reference }
      i := var_matind + var_diablk^.blk_vindex;
      if i < lsq_maxnvarbl then
      begin { When no dependance table overflow }
        if tmpnvar < i then    { The table must be extended }
        repeat
          tmpnvar := tmpnvar + 1;
          tmvdrt^[tmpnvar] := nil
        until tmpnvar = i;
        if tmvdrt^[i] = nil then
        begin { New variable added }
          tmvdrt^[i] := va;    { Set the variable derivation setting }
          with tmvddp^[i] do
          begin { ... and a derivate dependance parameter table }
            ddp_kind := ddp_direct;    { To win ddp_drt access }
            ddp_drt  := imode          { Set the direct (1) indirect (0) flag }
          end
        end
        else
        with tmvddp^[i] do { New reference to a variable already present }
          { When the mode are not the sames }
          if imode <> ddp_drt then ddp_drt := 2 { Force the mixte mode }
      end
      else
        LSQUSR_ERROR( 5, 4, nil )
    end
end ADD_VARIABLE_REFERENCE;



procedure ADD_PARAM_REFERENCE( pa: lsq_ptr; imode: integer );
var
  i: integer;

begin
  with pa^ do
  if par_derlst <> nil then
  begin
    i := ROUND( par_sigma );   { Get the parameter index }
    if i < lsq_maxnvarbl then
    begin { When no dependance table overflow }
      if tmpnpar < i then      { The table must be extended }
      repeat
        tmpnpar := tmpnpar + 1;
        tmpdrt^[tmpnpar] := nil
      until tmpnpar = i;
      if tmpdrt^[i] = nil then
      begin { New parameter added }
        tmpdrt^[i] := pa;      { Set the parameter derivation setting }
        with tmpddp^[i] do
        begin
          ddp_kind := ddp_direct;      { To win access of ddp_drt }
          ddp_drt  := imode    { to set 0/1 => indirect/direct access }
        end
      end
      else
        with tmpddp^[i] do
        begin { Already referenced parameter }
          ddp_kind := ddp_direct;      { To win access of ddp_drt }
          if ddp_drt <> imode then ddp_drt := 2  { Set the mixed mode }
        end
    end
    else
      LSQUSR_ERROR( 5, 4, nil )
  end
end ADD_PARAM_REFERENCE;


procedure MUTANT_EXPAND( pa: lsq_ptr );
var
  i:    integer;
  pdrt: drt_ptr;

begin
  pdrt := pa^.par_derlst;
  { Expand the dependance table to each dependance of the Sub-Parameter }
  if pdrt <> nil then
  begin
    mutant_dep_flg := true;
    for i := 1 to pdrt^.drt_size do
      if pdrt^[i]^.lsq_ndty = nd_varbl then
        ADD_VARIABLE_REFERENCE( pdrt^[i], 0 )
      else
        ADD_PARAM_REFERENCE( pdrt^[i], 0 )
  end
end MUTANT_EXPAND;



procedure LOOK_DEPEND( formula: lsq_ptr );
var
  eq: eqv_type;
  i:  integer;
  fl: boolean;

begin { LOOK_DEPEND }
  if formula <> nil then
  with formula^ do
  case lsq_ndty of

    nd_neg,     nd_abs_d,   nd_sqrt_d,
    nd_log_d,   nd_exp_d,
    nd_sinh_d,  nd_cosh_d,  nd_tanh_d,
    nd_sin_d,   nd_cos_d,   nd_tan_d,
    nd_asin_d,  nd_acos_d,  nd_atan_d,
    nd_dsin_d,  nd_dcos_d,  nd_dtan_d,
    nd_adsin_d, nd_adcos_d, nd_adtan_d:  LOOK_DEPEND( cuna );

    nd_ipw_d,
    nd_bess1_d: LOOK_DEPEND( xpuna );

    nd_add,
    nd_sub: begin
              LOOK_DEPEND( sbin1 );
              LOOK_DEPEND( sbin2 )
            end;

    nd_mul_d,   nd_div_d,   nd_pow_d,
    nd_phase_d, nd_dphase_d:
            begin
              LOOK_DEPEND( cbin1 );
              LOOK_DEPEND( cbin2 )
            end;

    nd_integr_loop_d:  { * Integration Operator }
            begin
              LOOK_DEPEND( intgr_expr );
            end;

    nd_summ_loop_d:    { * Loop Summation Operator }
            begin
              LOOK_DEPEND( summ_expr );
            end;

    nd_interpol_d:     { * Interpolation Operator }
            begin
              LOOK_DEPEND( inter_expr );
            end;

    nd_refer:
            begin
              eq.rec := BLK_PT( ref_pointer, ref_offset );
              LOOK_DEPEND( eq.lsq )
            end;

    nd_listref: 
            begin
              fl := LSQUSR_LIST_OPEN( lref_list );
              while LSQUSR_LIST_NEXT( lref_list ) do
              begin
                eq.rec := BLK_PT( lref_list^.lis_current, lref_offset );
                LOOK_DEPEND( eq.lsq )
              end;
              LSQUSR_LIST_CLOSE( lref_list )
            end;

    nd_parm: { Sub-Parameter Depend }
            if parf_derivate in par_flags then
            begin { For new reference only }
              { The Sub-Parameter expanssion is required }
              { ... only for a mutant sub-parameter }
              if parf_mutant in par_flags then MUTANT_EXPAND( formula );
              ADD_PARAM_REFERENCE( formula, 1 )
            end;

    nd_varbl: ADD_VARIABLE_REFERENCE( formula, 1 );

    nd_ifdir:
            begin
              LOOK_DEPEND( if_truenext );
              LOOK_DEPEND( if_falsenext )
            end;

    nd_casedir:
            begin
              LOOK_DEPEND( case_other );
              for i := 1 to case_table^.drt_size do
                LOOK_DEPEND( case_table^[i] )
            end;

  otherwise
  end
end LOOK_DEPEND;



procedure SET_PARM_DEPEND( pa: lsq_ptr );
var
  obj, attlist: lsq_ptr;
  pca:          cache_ptr;
  pce:          entry_ptr;
  i, j, k:      integer;

begin
  if debug then
  begin
    LST_EOLN;
    LST_PUT_STRING( ' Show Dependance of parm : ' );
    LSQUSR_REFER_ID( pa );
    LST_EOLN;
(*
    if sdbug then
    begin
      LSQ_DSPLTREE( pa^.par_definition );
      LST_PUT_STRING( ' --- end parm def.' ); LST_EOLN
    end
*)
  end;

  with pa^ do
  if not (parf_dertab in par_flags) then
  begin
    tmpnpar := 0;            { Clear the Sub-Parameter dependance table }
    tmpnvar := 0;            { Clear the variable dependance table }
    attlist := nil;
    mutant_dep_flg := false;

    { Set a parameter index }
    tmppcnt := tmppcnt + 1;  { Allocate a parameter index }
    par_sigma := tmppcnt;    { Store the parameter index in the sigma place }

    { Assume not mutant parameter until showed otherwise }
    par_flags := par_flags - [parf_mutant];
    if parf_evalsigma in par_flags then
      par_flags := par_flags + [parf_derivate];

    { Look for mutant parameter and cached list available conditions }
    if par_attlist <> nil then
      case par_attlist^.lsq_ndty of
        nd_list:
          begin
            if not (parf_summ in par_flags) then
              par_flags := par_flags + [parf_mutant];
            attlist := par_attlist
          end;

        nd_scandir:
          if not (parf_summ in par_flags) then
            par_flags := par_flags + [parf_mutant]
          else
            { Only possible when a summation is required }
            if par_attlist^.sca_type <> scaf_complete then
              { For incomplete scan it is always mutant }
              par_flags := par_flags + [parf_mutant]
            else { For all complete scan }
              if par_attlist^.sca_owner <> nil then
                { A scan owner is defined }
                case par_attlist^.sca_owner^.lsq_ndty of
                  nd_list, nd_collect:
                    begin
                      par_flags := par_flags + [parf_mutant];
                      attlist   := par_attlist^.sca_owner
                    end;

                  nd_scandir: par_flags := par_flags + [parf_mutant];

                otherwise { Other scan Owner }
                  par_flags := par_flags + [parf_mutant]
                end;

        nd_collect: par_flags := par_flags + [parf_mutant];

        nd_integr_loop_d,
        nd_summ_loop_d: par_flags := par_flags + [parf_mutant];


      otherwise
      end;

    if attlist <> nil then
      pca := attlist^.lis_cachefirst
    else
    begin
      par_flags := par_flags - [parf_cached];
      pca := nil
    end;

    mutant_gen_flg := (parf_mutant in par_flags);

    LOOK_DEPEND( par_definition ); { Built the Temporary Dependence Tables }
    { Now : 
      The drttmp table is fill as this :
        from     1   to tmpnvar        by variable references (direct or not)
                                       with hole at nil,
        from tmpnpar to lsq_maxnvarbl  by the sub parameter references.

      the ddptmp table is fill :
        from     1   to tmpnvar        by the indexes with some hole :
                                         0 for indirect (sub-parm resulting),
                                         1 for direct reference,
                                     and 2 for mixte reference.
      The flag mutant_dep_flg is set when some mutant parameter(s)
      are referenced.
    }

    { Scan to count the reference objects and compact the table }
    if debug then
    begin { *** Debugging code to output the look_depend info. *** }
      LST_EOLN;
      LST_PUT_STRING( ' Parm Depend partial for ' ); LSQUSR_REFER_ID( pa );
      if parf_mutant in par_flags then LST_PUT_STRING( ' is Mutant.' );
      LST_EOLN;
      for i := 1 to tmpnvar do
        if tmvdrt^[i] <> nil then
        begin
          LST_PUT_INT( i, 5 ); LST_PUT_STRING( '/ ' );
          LSQUSR_REFER_ID( tmvdrt^[i] ); LST_PUT_CHAR( ' ' );
          LST_PUT_INT( tmvddp^[i].ddp_drt, 3 ); LST_EOLN
        end;
      for i := 1 to tmpnpar do
        if tmpdrt^[i] <> nil then
        begin
          LST_PUT_INT( i, 5 ); LST_PUT_STRING( '/ ' );
          LSQUSR_REFER_ID( tmpdrt^[i] ); LST_PUT_CHAR( ' ' );
          LST_PUT_INT( tmpddp^[i].ddp_drt, 3 ); LST_EOLN
        end
    end;
    

    { For the variable references - sorted in increasing ordering }
    { Suppress all empty space in the variable dependance table. }
    j := 0; k := 0;
    for i := 1 to tmpnvar do
      if tmvdrt^[i] <> nil then
      begin { Get a compact drt_tab }
        j := j + 1; tmvdrt^[j] := tmvdrt^[i];
        if mutant_dep_flg then
          { When a mutant dependance was detected by LOOK_DEPEND }
          { Not for pure indirect reference }
          if tmvddp^[i].ddp_drt > 0 then
          begin { Direct Variable Ref. }
            k := k + 1;
            tmvddp^[k].ddp_kind := ddp_direct; { Force the direct mode }
            tmvddp^[k].ddp_drt  := j { Set the correct link to direct ref. }
          end
          { The indirect variable reference do not use the ddp ref. }
      end;

    { For the parameter references - sorted in increasing ordering }
    { Suppress all empty space in the parameter dependance table ... }
    { ... that append at the variable dependance table. }

    { For Sub-Parameter Reference }
    for i := 1 to tmpnpar do
      if tmpdrt^[i] <> nil then
      begin { Get a Compact drt_tab }
        if mutant_dep_flg then
        begin { When some mutant parameters are referenced }
              { We must build the ddp reference for each Sub-Parameters }
          if parf_mutant in tmpdrt^[i]^.par_flags then
          begin { A direct mutant parameter reference => ddp_tab only }
            k := k + 1;
            with tmvddp^[k] do
            begin { Put it in derivation directive table only }
              ddp_kind := ddp_mixte;       { Set the complex mode }
              ddp_sbp  := tmpdrt^[i]       { With the sub_parameter ref. }
            end
          end
          else
          begin { Not mutant parameter reference (can be direct or indirect }
            j := j + 1; { A drt_tab reference is always required }
            tmvdrt^[j] := tmpdrt^[i];
            if tmpddp^[i].ddp_drt > 0 then { Direct or mixte reference }
            begin
              k := k + 1;
              with tmvddp^[k] do           { Set the directive for derivation }
              begin
                ddp_kind := ddp_direct;    { Set the direct mode }
                ddp_drt  := j              { Set the drt index }
              end
            end
          end
        end
        else
        begin { When the parameter is not mutant dependant }
          j := j + 1;
          tmvdrt^[j] := tmpdrt^[i] { Append Direct Parm }
        end
      end;

    if k > 0 then
    begin
      NEW( par_derddp, k );                { Allocate the DDP table }
      for i := 1 to k do  par_derddp^[i] := tmvddp^[i]
    end;

    if j > 0 then
    begin
      NEW( par_derlst, j );                { Allocate the DRT table }
      for i := 1 to j do  par_derlst^[i] := tmvdrt^[i];

      { Allocate the derivate table(s) }
      if (parf_cached in par_flags) and (pca <> nil) then { Cached Parameter }
      begin
        par_dervec := nil;
        repeat
          { Allocate a derivate table for this parameter in each cache entry }
          with pca^ do
          begin
            pce := cache_entry;
            while pce <> nil do
              with pce^ do
                if entry_par = pa then
                begin { Alloc. the der. vect. }
                  NEW( entry_table, j );
                  if par_dervec = nil then par_dervec := entry_table;
                  entry_par := pa;
                  pce := nil
                end
                else pce := entry_next;
            pca := cache_next
          end
        until pca = nil
      end
      else
        NEW( par_dervec, j );

      for i := 1 to j do  par_dervec^[i] := 0.0
    end;

    par_flags := par_flags + [parf_dertab];

    if debug then
    begin
      LST_EOLN;
      LST_PUT_STRING( ' Results :' );
      LST_EOLN;
      if par_derddp <> nil then
      begin
        for i := 1 to par_derddp^.ddp_size do
        with par_derddp^[i] do
          if ddp_kind = ddp_direct then
          begin
            LST_PUT_STRING( '---Direct ' ); LST_PUT_INT( ddp_drt, 5 ); LST_EOLN
          end
          else
          begin
            LST_PUT_STRING( '---Mixte ' ); LSQUSR_REFER_ID( ddp_sbp ); LST_EOLN
          end;
        LST_EOLN
      end;
      if par_derlst <> nil then
      begin
        for i := 1 to par_derlst^.drt_size do
        begin
          LST_PUT_STRING( ' # ' ); LST_PUT_INT( i, 5 ); LST_PUT_STRING( ' :' );
          LSQUSR_REFER_ID( par_derlst^[i] ); LST_EOLN
        end
      end;
      LST_EOLN
    end
  end
end SET_PARM_DEPEND;



procedure SET_EXEC_PARM_DEP( pfrs: lsq_ptr );
var
  i, j:    integer;
  pcur: lsq_ptr;

begin
  j := 0;
  pcur := pfrs;
  while pcur <> nil do
  with pcur^ do
  begin
    case lsq_ndty of
      nd_parm:
        begin
          if par_lsum <> nil then SET_EXEC_PARM_DEP( par_lsum );
          SET_PARM_DEPEND( pcur )
        end;

      nd_scandir:
        begin
          SET_EXEC_PARM_DEP( sca_list^.lis_dirlist );
          SET_EXEC_PARM_DEP( sca_dir );
          SET_EXEC_PARM_DEP( sca_endlist )
        end;

      nd_ifdir:
        begin
          SET_EXEC_PARM_DEP( if_truenext );
          SET_EXEC_PARM_DEP( if_falsenext )
        end;

      nd_casedir:
        begin
          for i := 1 to case_table^.drt_size do
            SET_EXEC_PARM_DEP( case_table^[i] );
          SET_EXEC_PARM_DEP( case_cursel )
        end;

    otherwise
    end;
    pcur := lsq_next
  end
end SET_EXEC_PARM_DEP;



[global]
procedure LSQ_INIT_STRUCTURE;
var
  pcur,                               { Pointer to Block/List }
  pobj, plast:         lsq_ptr;       { Pointer to Variable/Parameter }
  i, j, k, dim, oldim: integer;
  bcont:               boolean;

begin
  fit_nvarbl := 0;
  if fit_statis = nil then
  begin
    fit_ncycle := 0;
    NEW( fit_statis )
  end;

(*
  { Test output }
  pobj := fit_varfirst;
  LST_PUT_STRING( ' List of variable :' ); LST_EOLN;
  while pobj <> nil do
    with pobj^ do
    begin
      LST_PUT_STRING( ' -- ' ); LSQUSR_REFER_ID( pobj ); LST_PUT_STRING( ' with index ' );
      LST_PUT_INT( var_matind, 4 ); LST_EOLN;
      if var_diablk <> nil then
      begin
        LST_PUT_STRING( ' in the block ' ); LSQUSR_REFER_ID( var_diablk )
      end;
      plast := LSQ_S_DIABLK( var_defblk );
      if plast <> nil then
      begin
        LST_PUT_STRING( ' where the previous block is ' ); LSQUSR_REFER_ID( plast )
      end;
      LST_EOLN;
      pobj := var_next
    end;
*)
(*
  with fit_fixedvarblblk^ do
  begin
    LST_PUT_STRING( ' * * * In the Fixed Block ' );
    LST_EOLN;
    pobj := blk_frsvar;
    while pobj <> nil do
    with pobj^ do
    begin
      LST_PUT_STRING( ' -------- Find the variable ' ); LSQUSR_REFER_ID( pobj );
      LST_EOLN;
    exit if pobj = blk_lstvar;
      pobj := var_nxtbl
    end
  end;
*)

  { Now Allocate the Matrix Structures }
  i := 0;
  bcont := true;
  pcur  := fit_blkfirst;
  while pcur <> nil do
  begin
     dim := 0;
     with pcur^ do
     begin { Evaluate the diagonal block size }
(*
LST_PUT_STRING( ' * * * In the Block ' ); LSQUSR_REFER_ID( pcur );
LST_EOLN;
*)
       pobj  := blk_frsvar;
       plast := blk_lstvar;
       while (pobj <> nil) and bcont do
       with pobj^ do
       begin
(*
LST_PUT_STRING( ' -------- Find the variable ' ); LSQUSR_REFER_ID( pobj );
LST_EOLN;
*)
         fit_nvarbl := fit_nvarbl + 1;
         if fit_nvarbl > lsq_maxnvarbl then
         begin
           LSQUSR_ERROR( 2, 3, nil );
           bcont := false
         end
         else
         begin
           dim        := dim + 1;
           var_matind := dim
         end;
       exit if pobj = plast;
         pobj := var_nxtbl
       end;
       blk_vindex := i;               { Set the variable index base }
       i          := i + dim;         { Update block the dimension summation }
       if dim > 0 then
       begin
         { Allocate the Constant and Shift Vectors }
         NEW( blk_vect_b, dim );
         NEW( blk_vect_x, dim );
         { Allocate the Least-Square Matrix }
         NEW( blk_matrix, ((dim + 1) * dim) div 2 )
       end
     end;
     pcur := pcur^.blk_next
  end;

  { Now Create Variable Parameters Dependance Links,
    and Allocate the Related Cache Entry when Required. }

  NEW( tmvddp, lsq_maxnvarbl );       { Allocate a temp. Var. DDP table }
  NEW( tmpddp, lsq_maxnvarbl );       { Allocate a temp. Par. DDP table }
  NEW( tmvdrt, lsq_maxnvarbl );       { Allocate a temp. Var. DRT table }
  NEW( tmpdrt, lsq_maxnvarbl );       { Allocate a temp. Par. DRT table }

  tmppcnt := 0;               { Initialize the Parameter Identification Count}
  SET_EXEC_PARM_DEP( fit_cyclstdir ); { Set der. for start Cycle Parm. }

  pcur := fit_listfirst;
  while pcur <> nil do
  with pcur^ do
  begin { For each list }
    SET_EXEC_PARM_DEP( lis_dirlist ); { Set der. for list parm. }
    pcur := lis_next
  end;

  pcur := fit_collfirst;
  while pcur <> nil do
  with pcur^ do
  begin { For each list }
    SET_EXEC_PARM_DEP( coll_pckdir ); { Set der. for data packet parm. }
    SET_EXEC_PARM_DEP( coll_cycldir );{ Set der. for data onend parm. }
    pcur := coll_next
  end;

  SET_EXEC_PARM_DEP( fit_cycldir );   { Set der. for end cycle parm. }
  SET_EXEC_PARM_DEP( fit_fitdir );    { Set der. for end fit parm. }   

  DISPOSE( tmvdrt );                  { Free the temporary drt var. tables }
  DISPOSE( tmpdrt );                  { Free the temporary drt par. tables }
  DISPOSE( tmvddp );                  { Free the temporary ddp var. tables }
  DISPOSE( tmpddp )                   { Free the temporary ddp par. tables }
end LSQ_INIT_STRUCTURE;



procedure CLR_PARM_DEPEND( pa: lsq_ptr; pca: cache_ptr );
var
  i:   integer;
  obj: lsq_ptr;
  pce: entry_ptr;

begin
  with pa^ do
  begin
    { Suppress the Mutant and Derivation Set Flags }
    par_flags := par_flags - [parf_mutant,parf_dertab];
    DISPOSE( par_derddp );     { Free the DDP table when it is existing }
    DISPOSE( par_derlst );     { Free the DRT table }

    { Free the Partial Derivate Table }
    if (parf_cached in par_flags) and (pca <> nil) then { Cached Parameter }
      repeat
        with pca^ do
        begin
          pce := cache_entry;
          while pce <> nil do
          with pce^ do
            if entry_par = pa then
            begin
              DISPOSE( entry_table );  { Free the der. vect. }
              pce := nil
            end
            else pce := entry_next;
          pca := cache_next
        end
      until pca = nil
    else
      DISPOSE( par_dervec )
  end
end CLR_PARM_DEPEND;



[global]
procedure LSQ_FREE_STRUCTURE;
var
  pcur, pvar, plst: lsq_ptr;
  pli:              cache_ptr;

begin
  { Free the Matrix Structures }
  pcur := fit_blkfirst;
  while pcur <> nil do
  begin
     with pcur^ do
     begin
       { The diagonal block size }
       pvar := blk_frsvar;
       plst := blk_lstvar;
       if pvar <> nil then
       begin
         DISPOSE( blk_vect_b );        { Free the Constant Vector }
         DISPOSE( blk_vect_x );        { Free the shift vector }
         DISPOSE( blk_matrix )         { Free the Least-Square Matrix }
       end;
       while pvar <> nil do
       with pvar^ do
       begin  { Reset all Variables to the Null Index state }
         var_matind := 0;
         if pvar = plst then pvar := nil
                        else pvar := var_next
       end
     end;
     pcur := pcur^.blk_next
  end;


  { Now Suppress all Parameters Dependance Links,
    and Related Cache Entry when Required. }
  pcur := fit_parfirst;
  while pcur <> nil do
  with pcur^ do
  begin { The Cache and Entry Records are Already Freeing
          but not the Derivate Vectors }
    if par_attlist = nil then pli := nil
                         else pli := par_attlist^.lis_cachefirst;
    CLR_PARM_DEPEND( pcur, pli );
    pcur := par_next
  end;
  fit_nvarbl := 0
end LSQ_FREE_STRUCTURE;


end LSQ_COMPUT.
