{
*************************************************************************
*                                                                       *
*                                                                       *
*                                                                       *
*                                                                       *
*          * * *    L I S P    I n t e r p r e t e r    * * *           *
*                                                                       *
*                                                                       *
*            ***  TYPES DEFINITIONS PASCAL FILE MODULE   ***            *
*                                                                       *
*       by :                                                            *
*                                                                       *
*           P. Wolfers                                                  *
*               c.n.r.s.,                                               *
*               Laboratoire de Cristallographie,                        *
*               B.P.  166 X   38042  Grenoble Cedex,                    *
*                                              FRANCE.                  *
*                                                                       *
*                                                                       *
*                                                                       *
*                                                                       *
*************************************************************************


/////////////////////////////////////////////////////////////////////////
//                                                                     //
//                                                                     //
//                  Global Public Licence (GPL)                        //
//                                                                     //
//                                                                     //
// This license described in this file overrides all other licenses    //
// that might be specified in other files for this library.            //
//                                                                     //
// This library is free software; you can redistribute it and/or       //
// modify it under the terms of the GNU Lesser General Public          //
// License as published by the Free Software Foundation; either        //
// version 2.1 of the License, or (at your option) any later version.  //
//                                                                     //
// This library is distributed in the hope that it will be useful,     //
// but WITHOUT ANY WARRANTY; without even the implied warranty of      //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU   //
// Library General Public License for more details.                    //
//                                                                     //
// You should have received a copy of the GNU Lesser General Public    //
// License along with this library (see COPYING.LIB); if not, write to //
// the Free Software Foundation :                                      //
//                      Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  //
//                                                                     //
/////////////////////////////////////////////////////////////////////////
}

{  Version 1.2-B (or Upper)  of  E - L I S P     System  }
{***********    CPAS  Version   **************}


%include 'PASENV:cpas_b__src_env';             { We load the source file environment }
%include 'LISPSRC:lisp_block_env';             { We load the mem. rec. Env. File }


const
  eos = CHR( 0 );                              { End Of File reached signal character }
  eol = CHR( 1 );                              { End Of Line reached signal character ( if enabled ) }

  { Default Prompt Message String }

  lisp_page_head = 'E-LISP-CNRS  V1.2-A by P. WOLFERS of the 15-MAY-2008';

  lisp_prompt = ' LISP>';

  pi   = 4.0*ARCTAN( 1.0 );                    { Define pi_number }
  inrd = pi/180;                               { Set pi_number/180.0 }

  def_title = ' The Current Source File is "';


  { System Dependant Strings }

  terminal        =      'TT:';                { Terminal file specification }

  lisp_deflst     =         '';                { Default listing to standard output }
  lisp_errfilespc = 'elisp_cmp.err';           { Error message specification file }
  lisp_defstd     = 'elisp_env.std';           { Define the Initial Script file }

  { Path to search the LISPLIB directory (and the std. init file) }
  lisp_search_path = './,HOME:/.lisp/,LISPLIB:,/usr/local/etc/lisp/';


  { Garbage Collector Specifications }

  { A doublet uses 2 obj_ref and an atom uses 4 obj_ref so :
    pckdbl must be 2 * pckatm to optimize the memory use }

  pckdbl = 4000;                               { Size of block in doublet }
  pckatm = 2000;                               { Size of block in atom }


  max_rectb = 32;                              { Maximum number of sys_call record access }


  max_strstk = 4;                              { Maximum string stack size }
  max_strlen = word_unsigned"last;             { Maximum current string for LISP }





                {********************************}
                { *** LISP types definitions *** }
                {********************************}


type

  lisp_real = double;              { Force Double Precision Mode }


  { *** Pointer Definitions *** }

  ident_ptr   = ^ident_rec;        { Pointer to a identifier entry }

  doublet_ptr = ^doublet_rec;      { Pointer to a doublet }

  atome_ptr   = ^atome_rec;        { Pointer to an atom }

  lex_ptr     = ^lex_display;      { Pointer to a lex level display structure }

  mem_ptr     = ^memory_rec;       { Pointer to a special memory record }

  vect_ptr    = ^vector_rec;       { Pointer to a vector of lisp object }

  lfile_ptr   = ^lisp_file_rec;    { Pointer to a lisp file descriptor }

  mrd_ptr     = ^mrdescr_rec;      { Pointer to a memory record descriptor }

  rfd_ptr     = ^rfdescr_rec;      { Pointer to a record field descriptor }

  lisp_s_ptr  = ^lisp_s_rec;       { Pointer to a large ident/string record }

  body_s_ptr  = ^lisp_s_body;      { Pointer to a array of char (for string) }


  { *** Object Flags and Functions Kind Definitions *** }

  obj_flag_names = (
    invalid_flg,                   { Invalid mark for READ }
    refered_flg,                   { Refered mark for garbage collector }
    lrefpli_flg,                   { Plist/Cdr reference flag }
    lreffnc_flg,                   { Fncref (atome only) reference flag }
    dma_fnc_flg,                   { DMA macro atom }
    breakpt_flg,                   { Break point mark }
    dp_ref_flg,                    { DP function by reference formal flag }
    flag_7_flg                     { Empty flag to complet the byte }
  );


    { All this next flag are mutuelly exclusive }

  function_kinds = (
    std_funct,                     { Standard function }
    de__funct,                     { DE function atom }
    df__funct,                     { DF function atom }
    dm__funct,                     { DM function atom }
    dty_funct,                     { Defined type atom }
    dre_funct,                     { Defined record access atom }
    dli_funct,                     { Defined record list access atom }
    dp__funct,                     { DP function atom }
    srv_define,                    { SERVICE object }
    sys_define,                    { SYSTEM object }
    drw_define,                    { DRAW object }
    lsq_define,                    { LSQ object }

    und_funct                      { No defined function atom }
  );

  obj_flags = set of obj_flag_names; { Flags of an Object }


  { *** Lisp Object Characteristics *** }

  obj_char = {packed} record
               k: function_kinds;  { Function Kinds }
               f: obj_flags        { Object Flags }
             end;


  { *** Lisp string body definition *** }

  lisp_s_body = packed array[1..max_strlen] of char;



  { *** Object Types Definitions *** }

  obj_type = (
    doublety,                      { Reference a list doublet }
    intub,                         { Unsigned byte integer }
    intsb,                         { Signed byte integer }
    intuw,                         { Unsigned word (16 bits) integer }
    intsw,                         { Signed word (16 bits) integer }
    intty,                         { Integer value }
    sflty,                         { Single Precision Real value }
    flty,                          { Standard Double Precision Real value }
    lextyp,                        { Lex level reference type }
    vectortyp,                     { Vector pointer type }
    mrecty,                        { User Record }
    areatyp,                       { Memory Area Pointer }
    areatyp1,                      { Special (not user allocated) memory area pointer }
    charty,                        { Character type }
    strty,                         { String Pointer }
    mrdty,                           { Memory Record Descriptor }
    rfdty,                           { Field Record Descriptor }
    lfilety,                         { File Descritor Pointer }

    { The next Definitions cannot be used as normal Atom with a C value }

    eof_seen,                        { Final end of source }
    eoln_seen,                       { End of line reached }

    truety,                          { Reference to T atome }
    nullty,                          { Reference the NULL atome }

    { Other Definitions }

    atomety,                         { Reference an atom (must be just before the std. op.) }

    	   { *** Begining of the Standard Operator List *** }
    { *** The corresponding atom can be use as normal LISP atom *** }

    imul_fnc,                        { Multiply }
    iadd_fnc,                        { Addition }
    isub_fnc,                        { Substract }
    idiv_fnc,                        { Integer Divide }
    imod_fnc,                        { Integer Modulo }
    irem_fnc,                        { Remeinder of a Quotient }

    ineg_fnc,                        { Negate function }
    iabs_fnc,                        { Absolute Value }
    ipow_fnc,                        { Power operator }

    succ_fnc,                        { (1+ ... ) }
    pred_fnc,                        { (1- ... ) }

    ilt_fnc,                         { < }
    ile_fnc,                         { <= }
    igt_fnc,                         { > }
    ige_fnc,                         { >= }
    ieq_fnc,                         { = }
    ine_fnc,                         { <> }

    de_fnc,                          { User function definitions ... }
    df_fnc,                          { As DE, but without parameter evaluation }
    dp_fnc,                          { User procedure }
    dm_fnc,                          { User macro definition }
    letn_fnc,                        { (LETN name ((V1 E1) ... ) body ) }
    let_fnc,                         { (LET ((V1 E1) ... ) body ) }
    dmd_fnc,                         { To take easely to use macro function dm }
    dpflg_fnc,                       { Set or clear the dp_ref_flg flag }

    addprop_fnc,                     { Add properties in an atom Plist }
    alginit_fnc,                     { Init algbrical function }
    alginput_fnc,                    { Setup of algread function }
    algread_fnc,                     { Algebrical read syntax element function }
    algtolisp_fnc,                   { Translation from algebrical to LISP }
    and_fnc,                         { Logical and operator }
    append_fnc,                      { Append a list to an other one in a new list }
    apply_fnc,                       { Apply a function at each element of a list }
    assq_fnc,                        { Find first occurance of an elem. in a AList(eq)}
    assoc_fnc,                       { As assq but with equal test }
    atom_fnc,                        { Test if atom }

    brkwh_fnc,                       { Break when }
    brkunl_fnc,                      { Break unless }

    bit_and_fnc,                     { Bit and function }
    bit_ash_fnc,                     { Bit arithmetic shift }
    bit_clear_fnc,                   { Bit clear function }
    bit_com_fnc,                     { Bit complement function }
    bit_lsh_fnc,                     { Bit logical shift }
    bit_rot_fnc,                     { Bit rotate function }
    bit_set_fnc,                     { Bit set (inclusive or) function }
    bit_test_fnc,                    { Bit test function }
    bit_xor_fnc,                     { Bit exclusive or function }

    car_fnc,                         { (CAR ...) }
    cdr_fnc,                         { (CDR ...) }
    caar_fnc,                        { (CAR (CAR ...) ) }
    cadr_fnc,                        { (CAR (CDR ...) ) }
    cdar_fnc,                        { (CDR (CAR ...) ) }
    cddr_fnc,                        { (CDR (CDR ...) ) }
    caaar_fnc,                       { (CAR (CAR (CAR ...) ) ) }
    caadr_fnc,                       { (CAR (CAR (CDR ...) ) ) }
    cadar_fnc,                       { (CAR (CDR (CAR ...) ) ) }
    caddr_fnc,                       { (CAR (CDR (CDR ...) ) ) }
    cdaar_fnc,                       { (CDR (CAR (CAR ...) ) ) }
    cdadr_fnc,                       { (CDR (CAR (CDR ...) ) ) }
    cddar_fnc,                       { (CDR (CDR (CAR ...) ) ) }
    cdddr_fnc,                       { (CDR (CDR (CDR ...) ) ) }

    chaine_fnc,                      { (CHAINE ... ) }
    chainerr_fnc,                    { (CHAINEP ... ) }
    char_fnc,                        { Character function }
    charp_fnc,                       { Character function }
    chk_flty_fnc,                    { Set a Default File type in a string }
    chord_fnc,                       { Character order function }
    close_fnc,                       { Close a file }
    cond_fnc,                        { Condition }
    cons_fnc,                        { (CONS arg list) }
    consp_fnc,                       { (CONSP arg) -> T if number }

    decr_fnc,                        { Decrement argument }
    def_lis_array_fnc,               { Define a listing array }
    delete_fnc,                      { Delete all or n of an argument of a list (equal) }
    delq_fnc,                        { Delete all or n of an argument of a list (eq) }
    displace_fnc,                    { Replace list }

    dma_fnc,                         { Macro atom definition }
    dmc_fnc,                         { Macro character definition }
    dsubst_fnc,                      { Destrutive substitute function }

    eof_fnc,                         { (EOF [file]) }
    eoln_fnc,                        { (EOLN [file]) }

    eos_fnc,                         { (EOF) }

    eq_fnc,                          { Test of same arguments (atom) }
    equal_fnc,                       { Test of same arguments (list) }
    neq_fnc,                         { Inverse of EQ }
    nequal_fnc,                      { Invers of EQUAL }

    eval_fnc,                        { Evaluate the argument }
    evenp_fnc,                       { Test if event number }
    exit_fnc,                        { Exit from LISP processor }
    explodech_fnc,                   { Form the list of character of an atom name }

    f_acos_fnc,                      { Arc Cosinus }
    f_acosd_fnc,                     { Arc Cosinus with result in degrees }
    f_asin_fnc,                      { Arc Sinus }
    f_asind_fnc,                     { Arc Sinus with result in degrees }
    f_atan_fnc,                      { Arc Tangent }
    f_atand_fnc,                     { Arc Tangent with result in degrees }
    f_cos_fnc,                       { Cosinus }
    f_cosd_fnc,                      { Cosinus with parameter in degrees }
    f_div_fnc,                       { Float divide }
    f_exp_fnc,                       { Exponentiel }
    f_float_fnc,                     { Floatting conversion }
    f_log_fnc,                       { Logarithme }
    f_phase_fnc,                     { Phase of a complex number }
    f_phased_fnc,                    { Phase in degrees of a complex number }
    f_round_fnc,                     { Round float to integer }
    f_sin_fnc,                       { Sinus }
    f_sind_fnc,                      { Sinus with parameter in degrees }
    f_sqrt_fnc,                      { Square Root}
    f_tan_fnc,                       { Tangent }
    f_tand_fnc,                      { Tangent with parameter in degrees }
    f_trunc_fnc,                     { Truncate float to integer }

    f_sinh_fnc,                      { Hyperbolic sinus (SH) function }
    f_cosh_fnc,                      { Hyperbolic cosinus (CH) function }
    f_tanh_fnc,                      { Hyperbolic tangent (TH) function }
    f_asinh_fnc,                     { Hyperbolic Argument SH function }
    f_acosh_fnc,                     { Hyperbolic Argument CH function }
    f_atanh_fnc,                     { Hyperbolic Argument TH function }

    f_bess1_fnc,                     { First Kind Bessel function }
    f_gamma_fnc,                     { Gamma function }

    f_interpol_fnc,                  { Interpolation function }
    f_summ_fnc,                      { Summation function }
    f_integr_fnc,                    { Gauss integration function }
    f_int_tab_fnc,                   { Gauss table for integration build function }

    fexit_fnc,                       { Exit from current function }
    fixp_fnc,                        { Test when fixed number }
    flambda_fnc,                     { Lambda (DF) function }
    floatp_fnc,                      { Test when float point number }
    fncbody_fnc,                     { Function body }
    format_inp_fnc,                  { Formatted input operator }
    format_out_fnc,                  { Formatted output operator }
    fspc_parse_fnc,                  { Parse file specification string }
    funcall_fnc,                     { Let self call activation }

    get_fnc,                         { Get a record from a binary file }
    getprop_fnc,                     { Get form atom p-list of properties }

    if_fnc,                          { (IF ... ) }
    implodech_fnc,                   { Built an atom from a list of char }
    include_fnc,                     { (INCLUDE ... ) }
    includerr_fnc,                   { (INCLUDEP ... ) }
    incr_fnc,                        { Increment a number }
    input_fnc,                       { Change of input file }
    in_fix_fnc,                      { To convert in integer }
    in_float_fnc,                    { To convert in float }
    i_string_fnc,                    { Read a string function }

    id_define_fnc,                   { Define an integer label }
    id_refer_fnc,                    { Refer an integer label }
    id_purge_fnc,                    { Purge all integer label }

    kind_fnc,                        { Kind of list object function }

    lambda_fnc,                      { Lambda (DE) function }
    last_fnc,                        { Get last list member }
    length_fnc,                      { Length of a list }
    list_fnc,                        { To built a list }
    listing_fnc,                     { (LISTING ...) }
    loop_fnc,                        { Loop statement }

    l_build_fnc,                     { Build list function }
    l_buildq_fnc,                    { Build list function with periodic evaluation of obj }
    l_free_fnc,                      { Free all doublet of a list }
    l_put_fnc,                       { Put an object in the specified stack/list (LIFO) }
    l_get_fnc,                       { Get an object from the specified stack/list (LIFO) }
    l_eput_fnc,                      { Put an element in the specified stack/list (LIFO) }
    l_eget_fnc,                      { Get an element from the specified stack/list (LIFO) }
    l_exch_fnc,                      { List element exchange }

    r_read_fnc,                      { Read a block of data }
    r_write_fnc,                     { Write a block of data }

    mapc_fnc,                        { Simplified MAPCAR }
    mapcar_fnc,                      { Application of a function to a list }
    mcons_fnc,                       { Suppress the last element of a list ?? }
    member_fnc,                      { Search the occurence of an element in a list }
    memq_fnc,                        { Limited to atom member form }
    mlambda_fnc,                     { Macro Lambda function }

    nconc_fnc,                       { Concatenate two lists }
    nextl_fnc,                       { Get the CAR of the arg value }
    nreverse_fnc,                    { In place reverse the list member order }
    nth_fnc,                         { Get the n-th list element }
    nthcdr_fnc,                      { Get the n-th CDR of a list }
    null_fnc,                        { Test if null arg }
    numberp_fnc,                     { Test if integer number }

    oblist_fnc,                      { Give the list of all known atom in LISP }
    oddp_fnc,                        { Test of odd integer number }
    on_error_fnc,                    { Trap error }
    open_fnc,                        { Open a file }
    or_fnc,                          { Logical or operator }
    output_fnc,                      { Change of output result file }

    p_call_fnc,                      { Call procedure statement }

    peekch_fnc,                      { Get an input character from input without adv. }
    plength_fnc,                     { Get length of the atome name }
    plist_fnc,                       { Get the atom's P-list }
    pragma_fnc,                      { Executable pragma statement }
    prin_fnc,                        { As print without buffer flush }
    princh_fnc,                      { Output a character }
    prinflush_fnc,                   { Flush the output buffer }
    prinhd_fnc,                      { Set head, title and sub-title for output file }
    print_fnc,                       { Output object to current output file }
    printerr_fnc,                    { Print error message }
    progn_fnc,                       { Execute a sequence }
    put_fnc,                         { Put a record }
    putprop_fnc,                     { Put new properties in the P-list }

    quot_fnc,                        { Quote function as (QUOTE arg) or 'arg }

    q_get_fnc,                       { Get in queue function (from the first pos.) }
    q_pop_fnc,                       { Get from the last pos. in a queue }
    q_put_fnc,                       { Put in queue function (put at the last pos.) }
    q_rem_fnc,                       { Remove from queue function }
    q_insert_fnc,                    { Insert in first position }

    r_define_fnc,                    { Define a record type function }
    r_fieldset_fnc,                  { Reset the filed list of a record }
    r_init_fnc,                      { Initialyse a record }
    r_new_fnc,                       { Create a new record }
    r_free_fnc,                      { Free a specified record }
    r_allocate_fnc,                  { Define and allocate a record }
    r_destroy_fnc,                   { Destroye a defined and allocated record }
    r_store_fnc,                     { Record store }

    read_fnc,                        { Read from the current input, a LISP expression }
    readch_fnc,                      { Read one character from current input file }
    remq_fnc,                        { Remove from a list with EQ (new list) }
    remove_fnc,                      { Remove from alist with EQUAL (new list) }
    remprop_fnc,                     { Remove a properties from the atom P-list }
    repeat_fnc,                      { Repeat loop statement }
    reverse_fnc,                     { Reverse the list member order }
    rplaca_fnc,                      { Replace the CAR of a list }
    rplacd_fnc,                      { Replace the CDR of a list }

    s_index_fnc,                     { Find a sub string in a string }
    s_length_fnc,                    { Get the string length }
    s_substr_fnc,                    { Get a substring from a string }
    s_concat_fnc,                    { Concatenate two strings }
    s_string_fnc,                    { Convert number in string }
    s_chcase_fnc,                    { Convert string in the specified case }

    set_fnc,                         { Assign a value to a variable }
    setq_fnc,                        { Assign a value to a evaluated variable }
    set_lis_array_fnc,               { Set a listing array }
    setplist_fnc,                    { Set a given plist }
    stringp_fnc,                     { Test if a string }
    subst_fnc,                       { Substitute function }
    symeval_fnc,                     { Get the value of a symbol }
    syscall_fnc,                     { Special E-LISP functions call function }
    terpri_fnc,                      { Skip arg line to output file }
    typech_fnc,                      { Type of a character }

    unless_fnc,                      { Equivalent to (IF test ()   ...  ) }
    until_fnc,                       { Until loop (UNTIL test act1 act2 ... ) }
    v_case_fnc,                      { Case operator }
    v_gcase_fnc,                     { Case vector generator }
    v_create_fnc,                    { Vector creation }
    v_index_fnc,                     { Vector index operator }
    v_store_fnc,                     { Vector index store value operator }

    when_fnc,                        { As (UNLESS (NULL test) act1 act2 ... ) }
    while_fnc,                       { While loop (WHILE test act1 act2 ... ) }

    zapline_fnc,                     { Zap the input line }
    zerop_fnc                        { Test if integer 0 }

  );


  { Name/string record definition }
  lisp_s_rec( capacity: word_unsigned ) = record
    length: word_unsigned;           { Used String Length }
    lnknxt: lisp_s_ptr;              { Link to next string/record }
    used:   boolean;                 { Used flag for the Garbage Collector }
    body: array[1..capacity] of char { String Body }
  end;


  { *** object reference definition *** }

  obj_ref = record
    flg: obj_char;                   { Byte Flags / function kind }
    case typ: obj_type of            { Type of Object }
      doublety:(db: doublet_ptr );   { Pointer to a list }
      charty:(  ch: char );          { Character value }
      intub,                         { Unsigned byte integer }
      intsb,                         { Signed byte integer }
      intuw,                         { Unsigned word (16 bits) integer }
      intsw,                         { Signed word (16 bits) integer }
      intty:(   int: integer );      { Integer value }
      sflty,                         { Real value (all describe as double) }
      flty:(    flt:  double );      { Double precision pointer }
      lfilety:( lfile: lfile_ptr );  { File descritor pointer }
      vectortyp:( vect: vect_ptr );  { Vector pointer }
      mrdty:( mrd: mrd_ptr );        { Memory record descriptor }
      rfdty:( rfd: rfd_ptr );        { Record field descriptor }
      mrecty:( rec: rec_ptr );       { User memory record }
      areatyp1,
      areatyp:( mem: mem_ptr );      { Memory area pointer }
      lextyp:( lexd: lex_ptr );      { Lex level pointer }
      strty,                         { String pointer }

    { *** Standard Operator/Atom that cannot be used as standard atome *** }
      eof_seen,                      { Final End Of Source }
      eoln_seen,                     { End Of Line reached }
      truety,                        { Reference to T atome }
      nullty:( nam: lisp_s_ptr );    { Reference to NULL/() atome }

      otherwise ( at: atome_ptr )    { All others specifications }
  end;



  { *** memory record definition *** }

  mrdescr_rec = record               { Memory record descriptor }
    mrd_nxt: mrd_ptr;                { Link between all record descriptor }
    mrd_atm: atome_ptr;              { Related record type atom }
    mrd_size,                        { Size of the record (in byte) }
    mrd_algn: integer;               { Alignement value for the record }
    mrd_rfdl: rfd_ptr                { Pointer to the field descriptor list }
  end;

  rfdescr_rec = record               { Record field descriptor }
    rfd_nxt: rfd_ptr;                { Pointer to the next record field }
    rfd_mrd: mrd_ptr;                { Pointer to the owner record }
    rfd_atm: atome_ptr;              { Related field identifier atom }
    rfd_dim,                         { Dimension of the field (in element) }
    rfd_off: integer;                { Offset of this field }
    rfd_typ: obj_ref                 { Type of the object }
  end;




  { A memory_rec must have 64 bits of size }
  memory_rec = packed record case integer of
    0:(a: mem_ptr );
    1:(c, c1, c2, c3: char );
    2:(sb, sb1, sb2, sb3: ubyte );
    3:(ub, ub1, ub2, ub3: sbyte );
    4:(sw, sw1: uword );
    5:(uw, uw1: sword );
    6:(i: integer );
    7:(f: single );
    8:(g: double );
    9:(vec: vect_ptr);
   10:(l_a: atome_ptr);
   11:(l_d: doublet_ptr);
   12:(l_n: lisp_s_ptr);
   13:(fl: char; cd: obj_type)
  end;




  { Vector Table Definition }
  vector_rec( vect_size: integer ) = record
    vect_used: boolean;              { Flag for used vector }
    vect_lnk:  vect_ptr;             { To link all allocated vector }
    vect_tab:  array[0..vect_size-1] of obj_ref
  end;



  { *** Lex Display Definition *** }

  lex_display = record
    prvlex: lex_ptr;                 { Previous Lex }
    lex: integer;                    { Integer value of the lex }
    lastid,                          { Pointer of the last identifier added }
    tree: ident_ptr;                 { Root of the tree }
    owner: obj_ref                   { Owner of this identifier tree }
  end;

  { *** Identifier Definitions *** }

  ident_rec = record
    nxt,                             { Pointer to next identifier }
    left, right: ident_ptr;          { Left and Right link Tree Pointer }
    name: lisp_s_ptr;                { Identifier Name }
    lex: integer;                    { Related Lex Level }
    atom: obj_ref                    { Related Definition }
  end;


  

  { *** Atome and Doublet element Definitions *** }

  atome_rec = record
    ats,                             { Atome type and name }
    val,                             { Atome value }
    plist,                           { Plist pointer }
    fncref: obj_ref                  { Function code }
  end;

  doublet_rec = record
    car,                             { Also used as atome name and type }
    cdr: obj_ref                     { Also used as atome value }
  end;


  { *** Lisp file definitions *** }

  lfile_types = (infiletyp,          { Input file }
                 outfiletyp,         { Output file }
                 instring,           { Input list of string }
                 outstring,          { Output list of string }
                 inbintyp,           { Binary input file }
                 outbintyp);         { Binary output file }

  lisp_file_rec = record             { Pointer to a lisp file descriptor }
    lfile_nxt,                       { Forward opened file link }
    lfile_prv: lfile_ptr;            { Backward opened file link }
    lfile_spc: obj_ref;              { File specification }  
    lfile_mode: char;                { File mode }
    case lfile_typ: lfile_types of           { Type of file }
      instring,                              { Read virtual file }
      infiletyp:(  lfile_inp: src_ptr );     { Input file context }
      outstring,                             { Create virtual file }
      outfiletyp:( lfile_out: lst_ptr );     { Output file context }
      inbintyp,
      outbintyp:(  lfile_bin: file of char );{ Binary file descriptor }
  end;



  bit_type = (b00, b01, b02, b03, b04, b05, b06, b07,
              b08, b09, b10, b11, b12, b13, b14, b15,
              b16, b17, b18, b19, b20, b21, b22, b23,
              b24, b25, b26, b27, b28, b29, b30, b31);

  bits = set of bit_type;




  {**********************************************}
  {****   Allocation for Garbage Collector   ****}
  {**********************************************}



  pck_ptr = ^alloc_packet;           { Pointer of alloc packet }


  alloc_packet =  record             { Unit to allocate for doublet }
    pck_nxt: pck_ptr;                { Pointer to next packet }
    case pck_atomflg: boolean of     { Flag for atom allocation }
      false:(
        pck_dbl: array[1..pckdbl] of doublet_rec);   { List of packet }
      true:(
        pck_atm: array[1..pckatm] of atome_rec)      { List of atom }
  end;
  

  {*******************************************}
  {****   Condition Handler Definitions   ****}
  {*******************************************}

  signal_array     = array[0..9] of integer;
  mechanism_array  = array[0..4] of integer;


{  * * * * * * *  End Of Constant and Type definition file  * * * * * *  }
