{
*************************************************************************
*                                                                       *
*                                                                       *
*                                                                       *
*                                                                       *
*          * * *    L I S P    I n t e r p r e t e r    * * *           *
*                                                                       *
*                                                                       *
*            ***    LISP  OPERATING SYSTEM  INTERFACE   ***             *
*                                                                       *
*       by :                                                            *
*                                                                       *
*           P. Wolfers                                                  *
*               c.n.r.s.,                                               *
*               Laboratoire de Cristallographie,                        *
*               B.P.  166 X   38042  Grenoble Cedex,                    *
*                                              FRANCE.                  *
*                                                                       *
*                                                                       *
*                                                                       *
*                                                                       *
*************************************************************************


/////////////////////////////////////////////////////////////////////////
//                                                                     //
//                                                                     //
//                  Global Public Licence (GPL)                        //
//                                                                     //
//                                                                     //
// This license described in this file overrides all other licenses    //
// that might be specified in other files for this library.            //
//                                                                     //
// This library is free software; you can redistribute it and/or       //
// modify it under the terms of the GNU Lesser General Public          //
// License as published by the Free Software Foundation; either        //
// version 2.1 of the License, or (at your option) any later version.  //
//                                                                     //
// This library is distributed in the hope that it will be useful,     //
// but WITHOUT ANY WARRANTY; without even the implied warranty of      //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU   //
// Library General Public License for more details.                    //
//                                                                     //
// You should have received a copy of the GNU Lesser General Public    //
// License along with this library (see COPYING.LIB); if not, write to //
// the Free Software Foundation :                                      //
//                      Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  //
//                                                                     //
/////////////////////////////////////////////////////////////////////////
}


{  Version 1.2-B (or Upper)  of  E - L I S P     System  }


{***********    CPAS  Version   **************}


{
        *** modification(s) from major version ***


			----

		       nothing

			----

}
module LISP_SYSTEM_CALL( input, output );


%include 'lispsrc:lisp_env';   { Get the LISP Environment Definitions }



function LISP$_SERVICE(  id: integer; parm_lst: obj_ref ): obj_ref;
external;


function LISP$_SYSTEM(  id: integer; parm_lst: obj_ref ): obj_ref;
external;


function LISP$_DRAW(  id: integer; parm_lst: obj_ref ): obj_ref;
external;


function LISP$_LSQ(  id: integer; parm_lst: obj_ref ): obj_ref;
external;


[global]
procedure USR_ERROR( ll: obj_ref; srcflg: boolean );
var
  st:               string( 6 );
  mdn:              error_mdnam;
  sevr:             error_sev;
  i, j, icod, isev: integer;

begin { USR_ERROR }
  GET_STRING( st, F_EVAL( NXT_PAR( ll ) ), '????' );
  icod := INTEVL( ll );
  isev := INTEVLDEF( ll, 2 );
  case isev of
    0: sevr := e_success;
    1: sevr := e_warning;
    2: sevr := e_error;
    3: sevr := e_severe;
  otherwise
    sevr := e_fatal
  end;
  with st do
  begin
    j := length;
    if j > 4 then j := 4;
    for i := 1 to j do  mdn[i] := body[i]
  end;
  usr_err_flg := (usr_err_file_spc.length > 0); { Set user flag as defined }
  if srcflg then SRC_ERROR( mdn, ABS( icod ), sevr )
            else i := ELISP_ERROR( mdn, ABS( icod ), sevr );
  usr_err_flg := false          { Restore the LISP msg file }
end USR_ERROR;


procedure USR_ERR_FILE_SET( ll: obj_ref );
begin { USR_ERR_FILE_SET }
  GET_STRING( usr_err_file_spc, F_EVAL( NXT_PAR( ll ) ), '' );
end USR_ERR_FILE_SET;



[global]
procedure REC_ACC_SET( var el: obj_ref; ipm: integer );
{ Routine to put the specified attribute list record reference
  in the rec_tbacc[1..ipm] . }
const
  mdnam = 'RACC';

var
  ind:           integer;
  mr:            mrd_ptr;
  rf:            rfd_ptr;
  attr, fa, rty: obj_ref;

begin { REC_ACC_SET }
  mr := nil;
  rec_tbidx := 0;
  attr := GET_LIST( el, true );             { Get attribute list }
  rty  := GET_ATOM( NXT_PAR( attr ), true );
  with rty.at^ do
    if fncref.typ <> mrdty then EXEC_ERROR( mdnam, 255, e_severe )
                           else mr := fncref.mrd;
  if mr^.mrd_rfdl^.rfd_atm = nil then
  begin
    rf := mr^.mrd_rfdl;
    while (attr.typ = doublety) and (rec_tbidx < ipm) do
    begin
      ind := INTEVLDEF( attr, 1 );          { Get array index }
      if (ind < 1) or (ind > rf^.rfd_dim) then ind := 0
                                          else ind := ind - 1;
      rec_tbidx := rec_tbidx + 1;
      rec_tbacc[rec_tbidx] := rf;           { Set the record access }
      rec_tbind[rec_tbidx] := ind
    end
  end
  else
    while (attr.typ = doublety) and (rec_tbidx < ipm) do
    begin
      fa  := NXT_PAR( attr );               { Get a field identifier atom }
      rf  := nil;
      ind := 0;
      if fa.typ >= atomety then
      begin
        with fa.at^ do
          if val.typ <> rfdty then EXEC_ERROR( mdnam, 254, e_severe )
                              else rf := val.rfd;
        with rf^ do
        begin
          if rfd_mrd <> mr then EXEC_ERROR( mdnam, 256, e_severe );
          if rfd_dim > 1 then
          begin
            ind := INTEVLDEF( attr, 1 );
            if (ind < 1) or (ind > rfd_dim) then ind := 0
                                            else ind := ind - 1
          end
          else ind := 0
        end
      end;
      rec_tbidx := rec_tbidx + 1;
      rec_tbacc[rec_tbidx] := rf;           { Set the record access }
      rec_tbind[rec_tbidx] := ind
    end
end REC_ACC_SET;




[global]
procedure REC_GET_ACC( id: integer; var off: integer; var ty: obj_type );
const
  mdnam = 'RGAC';

var
  fl: boolean;

begin
  if id < 0 then
  begin
    id := - id; fl := true
  end else fl := false;
  if id <= rec_tbidx then
    if rec_tbacc[id] <> nil then
      with rec_tbacc[id]^ do
      begin
        off := rfd_off + rec_tbind[id];
        ty  := rfd_typ.typ
      end
    else id := -1
  else id := -1;
  if id < 0 then
  begin
    off := -1;
    ty  := nullty;
    if not fl then EXEC_ERROR( mdnam, 260, e_error )
  end
end REC_GET_ACC;




[global]
function F_SYS_CALL( parm_lst: obj_ref ): obj_ref;
const
  mdnam = 'SYSC';

var
  icall, i, j: integer;
  res:         obj_ref;

begin { F_SYS_CALL }
  res   := obj_nil;
  icall := INTEVL( parm_lst );
  case icall div 100 of
      0: case icall of
           { *** Error message SYS_CALL *** }
           0, 1: { Send a source(0) or exec(1) error message }
                USR_ERROR( parm_lst, icall = 0 );

           2:    { Set an user error message file }
                USR_ERR_FILE_SET( parm_lst );


           { *** Debuger SYS_CALL *** }
           3:    { Install/De-install a debugger }
                exception_debug := parm_lst;

           4:    { Deposit/Clear a break point }
                begin
                  res := F_EVAL( NXT_PAR( parm_lst ) );
                  case res.typ of
                    truety:   exception_step := true; { Set the step mode }

                    doublety:
                      with res.db^.car do
                        if GET_EVLFLAG( parm_lst ) then { Set break }
                          flg.f := flg.f + [breakpt_flg]
                        else { cancel break }
                          flg.f := flg.f - [breakpt_flg];

                  otherwise
                    { Nothing to do }
                  end
                end;


           { *** Logical Management SYS_CALL *** }
           8:    { Enable or Disable the NIL/T Interpretation as Integer 0/1 }
              logint_mode := GET_EVLFLAG( parm_lst );

           { *** Macro character SYS_CALL *** }
           9:    { Enable or Disable the Alternate Macro Character Tables }
                alt_mac_tab_flag := GET_EVLFLAG( parm_lst );


           { *** Garbage Collector SYS_CALL *** }
           10:   { Activate the Garbage Collector }
               GARBAGE_COLLECTOR;


           { *** Identifier manager SYS_CALL *** }
           11: if (parm_lst.typ = nullty) then { Create or Destroy a lex level }
               begin
                  if curr_lex > 1 then FREE_LEX
               end
               else
               begin
                 res := NEW_LEX( GET_ATOM(
                                   F_EVAL( NXT_PAR( parm_lst ) ), true ) );
                 if GET_EVLFLAG( parm_lst ) then
                 begin
                   cmp_base_lexd := res.lexd;
                   cmp_base_lex  := cmp_base_lexd^.lex
                 end
               end;

           12:  F_SET_LEX( parm_lst );      { Modify the Lex View }
                 
           13:   { Activate a given Lex or Deactivate the Current Lex }
               if (parm_lst.typ = nullty) and (curr_lex > 1) then
                 DEACTIVATE_LEX
               else
                 ACTIVATE_LEX( parm_lst );

           14:   { Export a given list of identifier to the top lex }
               EXPORT_IDENTIFIER( parm_lst );

           15:   { Create a new identifier }
               { The flag parameter enable (T) the lex specification }
               res := CREATE_NEW_IDENT( parm_lst );

           16:   { Free a macro symbol }
               FREE_MACRO_SYMBOL( parm_lst );


           { *** Listing manager SYS_CALL *** }
           20:  with src_control^ do
                  if (sy_ch <> eol) and (sy_ch <> eos) then
                    SRC_END_OF_LINE;

           21:   { Listing Page Eject }
               with lst_current^ do
                 lst_lncnt := lst_pgsize + 1;

           22:   { Skip Some Lines }
               LST_SKIP_LINE( INTEVLDEF( parm_lst, 1 ) );

           23:   { Start a Paragraphe }
               with lst_current^ do
               begin
                 i := INTEVLDEF( parm_lst, 6 );
                 j := lst_lncnt;
                 LST_TEST_LINE( INTEVLDEF( parm_lst, 2 ), i  );
                 if lst_lncnt >= j then res := obj_true
               end;
  
           24:   { Absolute Positioning in the Current Line }
               with lst_current^.lst_currline^ do
               begin
                 i := length; j := INTEVL( parm_lst );
                 if j >= capacity then j := 0;
                 if i > j then
                 begin
                   LST_EOLN;
                   i := 0
                 end;
                  if j > i then LST_PUT_MCHAR( ' ', j - i )
               end;

           25:   { Print with Underline }
               with lst_current^.lst_currline^ do
               begin
                 i := length;
                 while parm_lst.typ <> nullty do
                 begin
                   res := F_EVAL( NXT_PAR( parm_lst ) );
                   OUT_OBJECT( res )
                 end;
                 j := length - i;
                 LST_EOLN;
                 if j > 0 then
                 begin
                   if i > 0 then LST_PUT_MCHAR( ' ', i );
                   LST_PUT_MCHAR( '-', j );
                   LST_EOLN
                 end;
               end;



         otherwise
           if icall >= 50 then
             res := LISP$_SERVICE( icall - 50, parm_lst )
           else
             EXEC_ERROR( mdnam, 997, e_fatal )
         end;

      1: { System Primitives }
         res := LISP$_SYSTEM( icall - 100, parm_lst );


      2: { Drawing Primitive }
         res := LISP$_DRAW( icall - 200, parm_lst );


      3: { Least Squares Primitives }
         res := LISP$_LSQ( icall - 300, parm_lst );


  otherwise
    EXEC_ERROR( mdnam, 998, e_fatal )
  end;
  F_SYS_CALL := res
end F_SYS_CALL;


end.
