%pragma listlvl:4;
{
*************************************************************************
*                                                                       *
*                                                                       *
*                                                                       *
*                                                                       *
*          * * *    L I S P    I n t e r p r e t e r    * * *           *
*                                                                       *
*                                                                       *
*                ***   LISP Main Program Module   ***                   *
*                                                                       *
*       by :                                                            *
*                                                                       *
*           P. Wolfers                                                  *
*               c.n.r.s.,                                               *
*               Laboratoire de Cristallographie,                        *
*               B.P.  166 X   38042  Grenoble Cedex,                    *
*                                              FRANCE.                  *
*                                                                       *
*                                                                       *
*                                                                       *
*                                                                       *
*************************************************************************


/////////////////////////////////////////////////////////////////////////
//                                                                     //
//                                                                     //
//                  Global Public Licence (GPL)                        //
//                                                                     //
//                                                                     //
// This license described in this file overrides all other licenses    //
// that might be specified in other files for this library.            //
//                                                                     //
// This library is free software; you can redistribute it and/or       //
// modify it under the terms of the GNU Lesser General Public          //
// License as published by the Free Software Foundation; either        //
// version 2.1 of the License, or (at your option) any later version.  //
//                                                                     //
// This library is distributed in the hope that it will be useful,     //
// but WITHOUT ANY WARRANTY; without even the implied warranty of      //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU   //
// Library General Public License for more details.                    //
//                                                                     //
// You should have received a copy of the GNU Lesser General Public    //
// License along with this library (see COPYING.LIB); if not, write to //
// the Free Software Foundation :                                      //
//                      Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  //
//                                                                     //
/////////////////////////////////////////////////////////////////////////
}


{  Version 1.2-B of  E - L I S P     System   }
{***********    CPAS  Version   **************}

{
        *** modification(s) from major version ***


			----

		       nothing

			----

}

program E_LISP( input, output );


%include 'lispsrc:lisp_type_env';    { Get the LISP Const/Type Definitions }
%include 'lispsrc:lisp_global_def';  { Get the global variable definitions }
%include 'lispsrc:lisp_extern_proc'; { Get the external proc/func. definitions}


label ERR_CONT,                      { Continue after an Error Label }
      ERR_STOP;                      { Stop after an Error Label }



[global]
procedure EXEC_ERROR( md: error_mdnam; nb: integer; sev: error_sev );
var
  i: integer;

begin
  i := 0;
  exception_point.at^.plist := curr_point;   { set the exception point }
  exception_point.at^.val.typ := intty;
  exception_point.at^.val.int := nb;         { set the exception code }
  if exception_man.typ <> nullty then
  begin { An exception handler is existing }
    with exception_status.at^ do
    begin
      val.typ := intty; val.int := nb;       { set event code }
      plist.typ := intty; plist.int := ORD( sev )  { and event severity }
    end;
    stop_reg := F_LET( exception_man, false );     { activate the handler }
    { if no true is the returned value then ... }
    if stop_reg.typ = truety then            { take the standard action }
    begin
      stop_reg := obj_nil;
      i := ELISP_ERROR( md, nb, sev )
    end
  end
  else
  begin
    i := ELISP_ERROR( md, nb, sev );
    LST_PUT_STRING( ' At the Lisp Statement :' ); LST_EOLN;
    OUT_OBJECT( curr_point );
    LST_EOLN
  end;
  if i <> 0 then goto ERR_CONT
end EXEC_ERROR;


[global]
function F_EXEC_ERROR( md: error_mdnam; nb: integer; sev: error_sev ): obj_ref;
begin
  EXEC_ERROR( md, nb, sev );
  { Sends the value exception point as result }
  F_EXEC_ERROR := exception_point.at^.val
end F_EXEC_ERROR;


function PRT_ERROR( ll: obj_ref ): obj_ref;
var
  sv1: error_sev;
  i, j: integer;
  res: obj_ref;

begin
  i := INTEVL( ll ); j := INTEVL( ll );
  if (j < 0) or (j > 4) then j := 4;
  sv1 := e_success;
  while j > 0 do
  begin
    j := j - 1; sv1 := SUCC( sv1 )
  end;
  res := obj_nil;
  res.typ := intty;
  res.int := ELISP_ERROR( 'UMAN', i, sv1 );
  PRT_ERROR := res
end PRT_ERROR;



function F_CAR( obj: obj_ref ): obj_ref;
begin
  case obj.typ of
    nullty:   F_CAR := obj;
    doublety: F_CAR := obj.db^.car;
  otherwise
    EXEC_ERROR( 'FCAR', 52, e_error )
  end
end F_CAR;


function F_CDR( obj: obj_ref ): obj_ref;
begin
  case obj.typ of
    nullty:   F_CDR := obj;
    doublety: F_CDR := obj.db^.cdr;
  otherwise
    EXEC_ERROR( 'FCDR', 52, e_error )
  end
end F_CDR;


function EXPLODCH( atm: obj_ref ): obj_ref;
var
  i: integer;
  res, obe, obd: obj_ref;

begin
  obd := obj_nil;
  i := 0;
  atm := atm.at^.ats;              { Get the atom name }
  if atm.nam <> nil then
  with atm.nam^ do                 { With this name }
  while i < length do              { For each character }
  begin
    obe := DOUBLET_ALLOC;          { Create a doublet }
    if i = 0 then                  { If it is the first character }
      res := obe                   { set the function result }
    else                           { else }
      obd.db^.cdr := obe;          { link to previous character }
    with obe.db^ do
    begin                          { Set the character }
      car.typ := charty;
      i := i + 1; car.ch := body[i]
    end;
    obd := obe
  end;
  EXPLODCH := res
end EXPLODCH;


[global]
function IMPLODCH( lch: obj_ref ): obj_ref;
var
  i:   integer;
  c:   char;
  buf: string( 255 ) := '';
  res: obj_ref;
  
begin
  case lch.typ of
    charty:
      begin
        buf.length := 1;
        if (lch.ch >= 'a') and (lch.ch <= 'z') then
          buf.body[1] := CHR( ORD( lch.ch ) - 32 ) { Set in Upper Case }
        else
          buf.body[1] := lch.ch
      end;

    strty:
      if lch.nam <> nil then
      with lch.nam^ do
      begin
        buf.length := length;
        for i := 1 to length do
        begin
          c := body[i];
          if (c >= 'a') and (c <= 'z') then
            buf.body[i] := CHR( ORD( c ) - 32 ) { Set in Upper Case }
          else
            buf.body[i] := c
        end
      end;

    doublety:
      begin
        res := lch;
        i := 0;
        while (res.typ = doublety) and (i < 255) do
        with res.db^ do
        begin
          if car.typ = charty then
          begin
            i := i + 1;
            if (car.ch >= 'a') and (car.ch <= 'z') then
              buf.body[i] := CHR( ORD( car.ch ) - 32 ) { Set in Upper Case }
            else
              buf.body[i] := car.ch;
            res := cdr
          end
          else res := obj_nil
        end;
        buf.length := i
      end;

  otherwise
  end { case };

  if buf.length > 0 then           { Do the Atom Search and Allocate }
    res := ATOM_SEARCH( buf );     { If it is Not Existing }
  IMPLODCH := res
end IMPLODCH;


[global]
function TEST_EQ( ob1, ob2: obj_ref ): boolean;
begin
  if ob1.typ = ob2.typ then
  case ob1.typ of
    strty:
      if ob1.nam = ob2.nam then TEST_EQ := true
                           else TEST_EQ := (STRING_MATCH( ob1, ob2 ) = 0);
    charty: TEST_EQ := (ob1.ch = ob2.ch);

    intub, intsb, intuw, intsw, intty: TEST_EQ := (ob1.int = ob2.int);

    sflty, flty: TEST_EQ := (ob1.flt = ob2.flt);

  otherwise
    TEST_EQ := (ob1.db = ob2.db)
  end
  else
    TEST_EQ := false
end TEST_EQ;


[global]
function TEST_EQUAL( l1, l2: obj_ref ): boolean;
var
  bt, bc: boolean;

begin
  bt := TEST_EQ( l1, l2 );      { Test for atome and same }
  if not bt and (l1.typ = doublety) and (l2.typ = doublety) then
  { two lists to compare }
  begin
    bc := true;
    bt := true;
    repeat
      if TEST_EQUAL( NXT_PAR( l1 ), NXT_PAR( l2 ) ) then
      begin
        if (l1.typ = doublety) and (l2.typ = doublety) then
        begin
          if l1.db = l2.db then bc := false
        end
        else
          if TEST_EQ( l1, l2 ) then bc := false
                               else bt := false
      end
      else bt := false
    until not (bt and bc)
  end;
  TEST_EQUAL := bt
end TEST_EQUAL;


function F_SET( sy, valu: obj_ref ): obj_ref;
{ sy is the atom, and val is the value }
begin
  if sy.typ >= atomety then sy.at^.val := valu
                       else EXEC_ERROR( 'SETQ', 59, e_error );
  F_SET := valu
end F_SET;


procedure F_SET_NOBUILTIN( var obj: obj_ref );
const
  mdnam = 'BLTD';

var
  id: ident_ptr;

begin
  if obj.typ > atomety then
  begin
    EXEC_ERROR( mdnam, 69, e_warning );
    if obj.at <> nil then
      if obj.at^.ats.nam <> nil then
      with obj.at^.ats.nam^ do
        id := IDENT_SEARCH( body, length, false );{ Search the related ide. }
    if id <> nil then              { When it is found ... }
    with id^ do
    begin
      atom.typ := atomety;         { ... it is set as a user atom identifier }
      atom.flg := flg_def
    end;
    obj.typ := atomety
  end
end F_SET_NOBUILTIN;



function F_DE( obj: obj_ref; ftyp: function_kinds ): obj_ref;
{ obj -> the list ( name  parmlist body ) }
const
  mdnam = 'D*_F';

var
  fn: obj_ref;

begin
  fn := NXT_PAR( obj );         { get function atome }
  if fn.typ > atomety then F_SET_NOBUILTIN( fn );
  if fn.typ = atomety then      { it must be an atome }
  with fn.at^ do
  begin
    fncref        := obj;       { set formal parameter list and body }
    if obj.typ <> doublety then
      fncref.flg.k := und_funct { clear function flags }
    else
      fncref.flg.k := ftyp      { set function type }
  end
  else EXEC_ERROR( mdnam, 59, e_severe );
  F_DE := fn
end F_DE;



procedure ATOME_SAVE_AND_SET( atm, nv: obj_ref );
{ to save the value of an atom and set a new value }
var
  p: obj_ref;

begin
  p := DOUBLET_ALLOC;      { creates the doublet to save the atom value }
  with p.db^ do
  begin
    car := atm.at^.val;    { save the old value }
    atm.at^.val := nv;     { set the new value }
    cdr := fnc_list_save   { link the doublet in the save stack }
  end;
  fnc_list_save := p       { update the stack pointer }
end ATOME_SAVE_AND_SET;



procedure ATOME_RESTORE( atm: obj_ref );
{ to restore the old value and plist of an atom }
var
  p: obj_ref;

begin
  p := fnc_list_save;
  with p.db^ do
  begin
    fnc_list_save := cdr;  { update the stack pointer }
    atm.at^.val := car     { restore the atom value }
  end;
  p.db^.cdr := dbl_free;   { free this doublet directly }
  dbl_free := p            { and put it in the free atom list }
end ATOME_RESTORE;


procedure PARM_RESTORE( flst: obj_ref );
begin
  if flst.typ >= atomety then
    ATOME_RESTORE( flst )
  else
    while flst.typ = doublety do
      with flst.db^ do
      begin
        ATOME_RESTORE( car );
        flst := cdr
      end
end PARM_RESTORE;


function EXEC_LIST( exlist: obj_ref ): obj_ref;
var res, cur: obj_ref;
begin
  res := obj_nil;
  cur := exlist;
  if cur.typ = doublety then
  begin
    { while we have a next doublet }
    repeat
      with cur.db^ do
      begin
        res := F_EVAL( car );
        cur := cdr
      end
    until (cur.typ <>  doublety) or (stop_reg.typ <> nullty);
    if stop_reg.typ = nullty then
    begin
      if cur.typ <> nullty then EXEC_ERROR( 'EXEL', 71, e_severe )
    end
    else
      if exlist.db = stop_reg.db then stop_reg := obj_nil
  end
  else { if we have a single value }
    if exlist.typ <> nullty then res := F_EVAL( exlist );    
  EXEC_LIST := res
end EXEC_LIST;



function SETP_LET( ll: obj_ref; var fl: obj_ref ): boolean;
{ recursive function to perform the initial setting of let parameter }
{ ll (in) if the let statement cdr, fl (in out) is the formal list head }
{ fl must be obj_nil at the external call }
var a, e, p, v: obj_ref;
begin
  if ll.typ = doublety then
  begin
    e := NXT_PAR( ll );              { get the formal definition }
    a := NXT_PAR( e );               { get the formal parameter atom }
    p := DOUBLET_ALLOC;              { creat the formal list }
    if fl.typ = nullty then          { link from }
      fl := p                        { the head if it the first }
    else
      fl.db^.cdr := p;               { else form the previous }
    p.db^.car := a;                  { link to the atome }
    if a.typ >= atomety then
    begin
      v := F_EVAL( NXT_PAR( e ) );   { evaluate the effective value }
      SETP_LET := SETP_LET( ll, p ); { continue to the other parameters }
      ATOME_SAVE_AND_SET( a, v )     { save parameter value and set new one }
    end
    else SETP_LET := true            { stop on error - not atom parameter }
  end else SETP_LET := (ll.typ <> nullty) { end of formal list or error }
end SETP_LET;



[global]
function F_LET( obj: obj_ref; namflg: boolean ): obj_ref;
{ emulate the LET/LETN LISP statements }
const
  mdnam = 'LET*';

var
  p,               { pointer to save the self atome }
  let_save,        { to save the current let_flist }
  fn: obj_ref;     { pointer to the function }
  berr: boolean;   { to flag parm. list error }

begin { F_LET }
  let_save := let_flist;          { save the present let formal list }
  let_flist := obj_nil;           { initialize the new let parameter list }
  if namflg then                  { if a name must be given }
  begin
    fn := NXT_PAR( obj );         { get the let name }
    if fn.typ > atomety then F_SET_NOBUILTIN( fn );
    if fn.typ < atomety then
      EXEC_ERROR( mdnam, 59, e_severe ) { an atom was expected }
  end else fn := self_let;        { else get take std. self atome }
  berr := SETP_LET( NXT_PAR( obj ), let_flist );
  if not berr then { legal let structure }
  begin
    p := ATOME_ALLOC;             { Do an atom copy of the self atom }
    p.at^ := fn.at^;
    with fn.at^ do                { set self function as a de function }
    begin
      fncref := DOUBLET_ALLOC;    { allocate a doublet }
      fncref.flg.k := de__funct;  { set the DE type }
      with fncref.db^ do          { to link the formal list and the body }
      begin
        car := let_flist;
        cdr := obj
      end;
      plist := obj_nil            { and set the plist to nil }
    end;
    F_LET := EXEC_LIST( obj );
    { restore the parm. list and body link doublet }
    with fn.at^ do
    begin
      fncref.db^.cdr    := dbl_free; dbl_free := fncref
    end;
    fn.at^ := p.at^;              { restore the original atom }
    with p.at^ do
    begin
      val    := atm_free;         { free this atom }
      fncref := obj_nil;
      ats    := obj_nil
    end;
    atm_free := p
  end;  
  if let_flist.typ <> nullty then
  begin
    p := let_flist; fn := obj_nil;{ prepare the foraml list freeing }
    while p.typ <> nullty do
    begin
      ATOME_RESTORE( p.db^.car ); { restore the formal }
      fn := p;                    { keep the last doublet address }
      p := p.db^.cdr              { skip to next formal }
    end;
    if fn.typ <> nullty then      { some doublet to free }
    begin
      fn.db^.cdr := dbl_free;     { free the whole of this list }
      dbl_free := let_flist
    end
  end;
  if berr then
    EXEC_ERROR( mdnam, 54, e_severe ); { if error on parameter list }
  let_flist := let_save           { restore the previous let formal list }
end F_LET;


function FN_DP_SET_PARM( f, l: obj_ref ): boolean;
{ procedure to link a formal parameter list to an effective parameter list }
var
  v: obj_ref;

begin
  if f.typ = l.typ then
    if f.typ = doublety then
      with f.db^ do
      begin
        if dp_ref_flg in car.flg.f then v := NXT_PAR( l )
                                   else v := F_EVAL( NXT_PAR( l ) );
        FN_DP_SET_PARM := FN_DP_SET_PARM( cdr, l );
        ATOME_SAVE_AND_SET( car, v )
      end
    else FN_DP_SET_PARM := false { end of parameter list }
  else FN_DP_SET_PARM := true { parameter list do not match }
end FN_DP_SET_PARM;


function FN_EVAL_PARM( f, l: obj_ref; evlflg: boolean ): boolean;
{ procedure to link a formal parameter list to an effective parameter list }
{ the evlflg flag must be true to get the parameter evaluation an false
otherwise }
var
  v: obj_ref;

begin
  if f.typ = l.typ then
    if f.typ = doublety then
      with f.db^ do
      begin
        if evlflg then
          v := F_EVAL( NXT_PAR( l ) )
        else
          v := NXT_PAR( l );
        FN_EVAL_PARM := FN_EVAL_PARM( cdr, l, evlflg );
        ATOME_SAVE_AND_SET( car, v )
      end
    else FN_EVAL_PARM := false { end of parameter list }
  else FN_EVAL_PARM := true { parameter list  do not match }
end FN_EVAL_PARM;


function PARM_SAVE_AND_LINK( flst, effl: obj_ref; evl_flg: boolean ): boolean;
{ effl is the effective list }
{ flst is the formal list }
{ evl_flg is the evaluate flag }
{ the function result is true when a match error was occured }
var
  p0, p1, p2: obj_ref;

begin
  if flst.typ >= atomety then { one parameter for all the formal list }
  begin
    { set the evaluation list if required }
    if evl_flg then  { if the evaluation is required }
    begin
      p0 := obj_nil;
      while effl.typ = doublety do
      begin
        p2 := DOUBLET_ALLOC;              { create a list of effective parm }
        if p0.db = nil then
          p0 := p2
        else
          p1.db^.cdr := p2;
        p1 := p2;
        p2.db^.car := F_EVAL( NXT_PAR( effl ) )
      end;
      ATOME_SAVE_AND_SET( flst, p0 )      { save the atom context }
    end
    else    { if no evaluation is required }
      ATOME_SAVE_AND_SET( flst, effl );   { save and set the formal C value }
    PARM_SAVE_AND_LINK := false           { no formal match error }
  end
  else { normal DE/DF/DM parameter list }
    PARM_SAVE_AND_LINK := FN_EVAL_PARM( flst, effl, evl_flg )
end PARM_SAVE_AND_LINK;



function F_DMC( obj: obj_ref ): obj_ref;
var ch: char;
begin
  ch := GET_CHAR( F_EVAL( NXT_PAR( obj ) ) );
  if (ch >= '!') and (ch <= '~') then
    if alt_mac_tab_flag then
      alt_mtb[ch] := obj
    else
      mac_tab[ch] := obj
  else
    EXEC_ERROR( 'DMC_', 73, e_severe );
  F_DMC := obj_empty
end F_DMC;


function F_DMA( obj: obj_ref ): obj_ref;
var at: obj_ref;
begin
  at := GET_ATOM( F_EVAL( NXT_PAR( obj ) ), true );
  with at.at^ do
  if obj.typ <> nullty then
    if obj.typ = doublety then
    begin
      val := obj; val.flg.f := [dma_fnc_flg]
    end
    else val := obj_nil
  else val := obj_nil;
  F_DMA := at
end F_DMA;


function F_COND( lcl: obj_ref ): obj_ref;
var
  cl, res, tst: obj_ref;

begin
  res:= obj_nil; tst := obj_nil;
  while (lcl.typ = doublety) and (tst.typ = nullty) do
  begin
    cl := NXT_PAR( lcl );         { get a case list head }
    tst := F_EVAL( NXT_PAR( cl ) ); { test this case }
    if GET_VALFLAG( tst ) then { all expr are true except nil }
      if cl.typ <> nullty then res := EXEC_LIST( cl )
      else res := tst
  end;
  F_COND := res
end F_COND;




procedure REC_SET_FIELD_TYPE( fdl: obj_ref; var fdim, faln: integer );
const
  mdnam = 'TYDF';

begin
  case fdl.typ of { Set appropriate in the type definition list }
    mrecty: begin  fdim := size_mptr; faln := algn_mptr  end;
    charty: begin  fdim := size_char; faln := algn_char  end;
    intub:  begin  fdim := size_byte; faln := algn_byte  end;
    intsb:  begin  fdim := size_byte; faln := algn_byte  end;
    intuw:  begin  fdim := size_word; faln := algn_word  end;
    intsw:  begin  fdim := size_word; faln := algn_word  end;
    intty:  begin  fdim := size_inte; faln := algn_inte  end;
    sflty:  begin  fdim := size_sing; faln := algn_sing  end;
    flty:   begin  fdim := size_doub; faln := algn_doub  end;
    strty:  begin
              faln := algn_char;
              fdim := size_char*( 1 + fdl.nam^.length )
            end;
  otherwise
    faln := 1; fdim := 0;
    if fdl.typ >= atomety then
      with fdl.at^ do
        if fncref.flg.k = dty_funct then
        begin
          fdim := fncref.mrd^.mrd_size;
          faln := fncref.mrd^.mrd_algn
        end
        else
          EXEC_ERROR( mdnam, 251, e_severe )
    else
      EXEC_ERROR( mdnam, 251, e_severe )
  end
end REC_SET_FIELD_TYPE;



function REC_DEFINE_TYPE( ll: obj_ref ): obj_ref;
{ Record type definition }
{ Call form :
  (R_DEFINE <typ_atm> <f_1> ... <f_n>)
  Or (for array) :
  (R_DEFINE <typ_atm> <dim_i> <f_typ_i> )

  With :
   <f_i> ::= ( <f_atm_i> [ <dim_i> ] <f_typ_i> )

   <typ_atm>  is the identifier atom record type to create,

  For each Record Field :

   <f_atmi>   is the identifier of the i'th record field,
   <dim_i>    is the dimension (for array) of the record field.
              <dim_i> must be > 1 else it is not an array.
   <f_typ_i>  is the record field E-LISP type :
              For this implementation it can be :
                - a string of n character as : "abcdef"
                - a LISP Character or M_CH.
                - a  8 bits integer (signed or not) as M_UB or M_SB.
                - a 16 bits integer (signed or not) as M_UW or M_SW.
                - a 32 bits integer M_LI or a LISP integer.
                - a 32 bits floating point number M_FL.
                - a 64 bits floating point number M_DB or a LISP Float.
}
{ The atom <typ_atm> is returned as value,
  the <typ_atm> atome is set as a Record allocator function for this
  record type by setting of function body. Each field identifier atom
  as is value set as a field reference (old value are lost)
}
const
  mdnam = 'TYPD';

var
  idim, offst, fdim, fdim1, faln, faln1, fad: integer;
  mrd: mrd_ptr;
  rf1, rf2: rfd_ptr;
  fdl, ff, ft: obj_ref;

begin
  rf2   := nil;
  offst := 0;
  faln1 := 0;
  ft  := GET_ATOM( NXT_PAR( ll ), true ); { get a record type atom identifier }
  NEW( mrd );                      { allocate a memory record descriptor }
  with mrd^ do
  begin
    mrd_nxt  := mrd_alloc;         { link with the previously defined descriptors }
    mrd_alloc := mrd;
    mrd_atm  := ft.at;             { set the record atom name }
    mrd_rfdl := nil;               { init the field descritor list to empty }
    while ll.typ = doublety do
    begin { scan all field description }
      fdl := NXT_PAR( ll );
      if fdl.typ = doublety then
      begin { create a field descriptor }
        ff := GET_ATOM( NXT_PAR( fdl ), true ); { get a field atom identifier }
        if fdl.typ = doublety then idim := INTEVLDEF( fdl, 1 ) { an array size is given }
                              else idim := 1;
        REC_SET_FIELD_TYPE( fdl, fdim, faln );
        { compute the offset as a subscript }
        fad := offst div faln;
        if (offst rem faln) <> 0 then fad := fad + 1;
        if idim > 1 then
        begin
          fdim1 := fdim div faln;
          if (fdim rem faln) <> 0 then fdim1 := fdim1 + 1;
          fdim := idim*fdim1*faln
        end;
        offst := fad*faln + fdim;  { allocate the space }
        NEW( rf1 );
        with rf1^ do
        begin
          rfd_nxt := nil;          { initialize the next pointer }
          rfd_mrd := mrd;          { set the record owner pointer }
          rfd_atm := ff.at;        { set the field related atome }
          rfd_dim := idim;         { set the field array dimension }
          rfd_off := fad;          { set the field offset }
          rfd_typ := fdl           { set the field type }
        end;
        { link the field descriptor to the previous one }
        if mrd_rfdl = nil then mrd_rfdl := rf1
                          else rf2^.rfd_nxt := rf1;
        rf2 := rf1
      end
      else { can be an array declaration }
      begin
        idim := INTVAL( F_EVAL( fdl ) );{ get the array dimension }
        REC_SET_FIELD_TYPE( ll, fdim, faln );
        { no start alignement constraint }
        { adjust the array element size for the right element alignement }
        fdim1 := fdim div faln;
        if (fdim rem faln) <> 0 then fdim1 := fdim1 + 1;
        fdim := idim*fdim1*faln;
        NEW( rf1 );
        with rf1^ do
        begin
          rfd_nxt := nil;          { no next field for array }
          rfd_mrd := mrd;          { set the record owner pointer }
          rfd_atm := nil;          { no related field atom }
          rfd_dim := idim;         { set the array size }
          rfd_off := 0;            { zero array offset }
          rfd_typ := ll            { set it as a virtual field }
        end;
        offst     := fdim;         { allocate the space }
        mrd_rfdl  := rf1           { link the field with the record one }
      end
    end;
    mrd_size := offst;             { set the total record size }
    mrd_algn := faln1;             { set the record alignement specification }
    rf1 := mrd_rfdl;               { now set the field atom link }
    { now, scan all record field to set the atom link }
    if rf1^.rfd_atm <> nil then    { no field scan when it is an array }
    while rf1 <> nil do
      with rf1^ do
      begin
        if rfd_atm <> nil then
        with rfd_atm^ do
        begin
          val.typ := rfdty;
          val.rfd := rf1;
        end;
        rf1 := rfd_nxt
      end
  end;
  { now set the verify field attachement }  
  with ft.at^ do
  begin
    fncref.flg.k    := dty_funct;  { set the atome as a special record alloc. fonction }
    fncref.typ      := mrdty;      { set the descriptor in the function body place }
    fncref.mrd      := mrd
  end;
  REC_DEFINE_TYPE := ft
end REC_DEFINE_TYPE;




function REC_DEFINE_REC( ft, efl: obj_ref ): obj_ref;
{ Function to define atoms as a particular record,
  without allocate any memory location }
{ Call Form : (<atm_typ> <atm_r1> [ ... <atm_rn> ] )
  The returned value is the last record atom identifier <atm_rn>
  Each specified atom is set as a record identifier atome.
}
const
  mdnam = 'RDRE';

var
  fr: obj_ref;

begin
  with ft.at^ do
    if fncref.flg.k <> dty_funct then EXEC_ERROR( mdnam, 253, e_severe );
  while efl.typ = doublety do
  begin
    fr := GET_ATOM( NXT_PAR( efl ), true ); { Get the record identifier atom }
    with fr.at^ do
    begin { set the type atom as record identifier atom }
      fncref := ft.at^.fncref;  { Attach the field list description to the atom }
      fncref.flg.k := dre_funct;{ Set this atom as a record reference function }
    end
  end;
  REC_DEFINE_REC := fr          { Return last record atom as result }
end REC_DEFINE_REC;




procedure REC_PUT_VAL( bl: rec_ptr; rd: mrd_ptr; rf: rfd_ptr; var efl: obj_ref );
{ Initialization Routine called by REC_ALLOCATE and REC_SETTING }
{ bl  is the record pointer }
{ rd  is the record descriptor }
{ rf  is a record field atom }
{ efl is the call list of value to assigne at the record field }
const
  mdnam = 'RPUT';

var
  adr, idim, i, isz, isa: integer;
  p: body_s_ptr;
  s: string( 16 );

begin
  if rd = rf^.rfd_mrd then
  with rf^ do
  begin { field and decsriptor match }
    idim := rfd_dim;               { get the field dimension }
    adr  := rfd_off;               { get the field offset }
    while (efl.typ = doublety) and (idim > 0) do
    begin
      case rfd_typ.typ of
        mrecty: bl^.at [adr] := RECEVL( efl );
        charty: bl^.cht[adr] := GET_CHAR( F_EVAL( NXT_PAR( efl ) ) );
        intub:  bl^.ubt[adr] := INTEVLDEF( efl, 0 );
        intsb:  bl^.sbt[adr] := INTEVLDEF( efl, 0 );
        intuw:  bl^.uwt[adr] := INTEVLDEF( efl, 0 );
        intsw:  bl^.swt[adr] := INTEVLDEF( efl, 0 );
        intty:  bl^.it [adr] := INTEVLDEF( efl, 0 );
        sflty:  bl^.ft [adr] := FLTEVLDEF( efl, 0.0 );
        flty:   bl^.gt [adr] := FLTEVLDEF( efl, 0.0 );
        strty:  begin
                  GET_LISP_STR_REF( p, isz, s, F_EVAL( NXT_PAR( efl ) ) );
                  isa := rfd_typ.nam^.length;
                  if isz > isa then isz := isa;
                  bl^.cht[adr] := CHR( isz );
                  for i := 1 to isz do
                    bl^.cht[adr+i] := p^[i];
                  adr := adr + isz
                end;
      otherwise
        if rfd_typ.typ >= atomety then
          with rfd_typ.at^ do
            if fncref.flg.k = dty_funct then
            begin
              { not yet implemented }
              EXEC_ERROR( mdnam, 299, e_severe )
            end
            else
              EXEC_ERROR( mdnam, 253, e_severe )
        else
          EXEC_ERROR( mdnam, 253, e_severe )
      end;
      adr  := adr  + 1;
      idim := idim - 1
    end
  end
  else EXEC_ERROR( mdnam, 256, e_severe )
end REC_PUT_VAL;




procedure REC_FIELD_SET( el: obj_ref );
{ Reset the field identifier link }
{ call form: (R_FIELD_SET <atm_typ>)
        or   (R_FIELD_SET <atm_rec>)

  The returned value is NIL.
}
const
  mdnam = 'RFSE';

var
  rf: rfd_ptr;
  fd, fr, ob: obj_ref;

begin
  ob.flg      := flg_def;
  ob.flg.k    := und_funct;
  ob.typ      := rfdty;
  fr := GET_ATOM( NXT_PAR( el ), true );      { Get the record atom }
  with fr.at^ do
  begin
    { Check for record atom or record type atom identifier }
    if fncref.typ <> mrdty then EXEC_ERROR( mdnam, 255, e_severe );
    rf := fncref.mrd^.mrd_rfdl;    { get the field descriptor list head }
  end;
  while rf <> nil do
  with rf^ do
  begin
    ob.rfd := rf;
    if rfd_atm <> nil then
      rfd_atm^.val := ob;
    rf := rfd_nxt
  end
end REC_FIELD_SET;




function REC_INITIALIZE( el: obj_ref ): obj_ref;
{ Initialyse an existing record }
{ Call form : (R_INIT <rec_atm> [ <v1> ... <vi> ... <vn> ] )
  Where :
         <rec_atm> is the record atom.
         <vi>      is a value for each record field or
                   array element of a field.

  The returned value is <rec_atm>.
}
const
  mdnam = 'RSET';

var
  bl: rec_ptr;
  rf: rfd_ptr;
  fr: obj_ref;

begin
  fr := GET_ATOM( NXT_PAR( el ), true ); { get the record atom }
  with fr.at^ do
  begin
    { Check for record memory allocation }
    if val.typ <> mrecty then EXEC_ERROR( mdnam, 257, e_severe );
    bl := val.rec;                 { get the record pointer }
    { check for record atom identifier }
    if fncref.flg.k <> dre_funct then EXEC_ERROR( mdnam, 254, e_severe );
    rf := fncref.mrd^.mrd_rfdl;    { get the field descriptor list head }
    while rf <> nil do
    begin                          { scan all field descriptor }
      REC_PUT_VAL( bl, fncref.mrd, rf, el ); { set the specified list or zero }
      rf := rf^.rfd_nxt            { skip to next field descriptor }
    end
  end;
  REC_INITIALIZE := fr
end REC_INITIALIZE;



function REC_NEW( el: obj_ref ): obj_ref;
{ Allocate memory for a specified record and initialize it.
  Call Form : (R_NEW <rec_atm> [ <v1> ... <vn> ] )
    return the memory address of the record.

  Side effects :
     The value of <rec_atm> is set to the record address
     to enable the record access accross <rec_atm>.
     Any previous atome value is supershed.
}
const
  mdnam = 'RNEW';

var
  is: integer;
  mr: mrd_ptr;
  rf: rfd_ptr;
  bl, fr: obj_ref;

begin
  fr := GET_ATOM( NXT_PAR( el ), true ); { get the record atome }
  with fr.at^ do
  begin
    { Check for record atom identifier }
    if fncref.flg.k <> dre_funct then EXEC_ERROR( mdnam, 254, e_severe );
    mr := fncref.mrd;              { Get the record descriptor addr. }
    is := mr^.mrd_size;            { Get the size to allocate (in bytes) }
    val.typ := mrecty;             { Set the record pointer type }
    val.rec := NEW_RECORD_ALLOC( is ); { Allocate the required memory }
    bl := val                      { Keep the record pointer }
  end;
  { Initialyze the record when required }
  if el.typ = doublety then
  begin
    rf := mr^.mrd_rfdl;            { Get the field descriptor list head }
    while rf <> nil do             { Loop on all record field }
    begin                          { Scan all field descriptor }
      REC_PUT_VAL( bl.rec, mr, rf, el ); { Set the specified list or zero }
      rf := rf^.rfd_nxt            { Skip to next field descriptor }
    end
  end;
  REC_NEW := bl
end REC_NEW;




procedure REC_FREE( efl: obj_ref );
{ Free memory for a specified record.
  Call Form : (R_NEW <rec_atm> )
    return NIL.

  Side effects :
     The value of <rec_atm> is set to NIL.
}
const
  mdnam = 'RFRE';

var
  is: integer;
  mr: mrd_ptr;
  bl, fr: obj_ref;

begin
  fr := GET_ATOM( NXT_PAR( efl ), true ); { get the record atome }
  with fr.at^ do
  begin
    { check for record atom identifier }
    if fncref.flg.k <> dre_funct then EXEC_ERROR( mdnam, 254, e_severe );
    { Check for memory allocation }
    if val.typ <> mrecty then EXEC_ERROR( mdnam, 257, e_error );
    FREE_RECORD_ALLOC( val.rec );   { free the record memory }
    val := obj_nil
  end
end REC_FREE;



function REC_ALLOCATE( el: obj_ref ): obj_ref;
{ Call Form: (<atm_typ> <atm_rec> [<v1> ... <vn> ] ) }
var
  is: integer;
  fr, ft, re: obj_ref;

begin
  re := el;
  ft := GET_ATOM( NXT_PAR( re ), true );
  is := ft.at^.fncref.mrd^.mrd_size; { get the record type descriptor }
  fr := GET_ATOM( NXT_PAR( re ), true ); { get the record identifier atom }
  re := obj_nil;
  if is > 0 then
  with fr.at^ do
  begin { we can do an allocation }
    re.typ := mrecty;
    re.rec := NEW_RECORD_ALLOC( is ); { allocate the required amount of bytes }
    fncref := ft.at^.fncref;       { attach the field list description to the atom }
    fncref.flg.k := dre_funct;  { set this atom as a record reference function }
    val    := re;                  { attach the allocation to the identifier atom }
    re := REC_INITIALIZE( el )     { Set initial value } 
  end;
  REC_ALLOCATE := re
end REC_ALLOCATE;




procedure REC_DESTROY( fr: obj_ref );
{ (R_DESTROY <atm_rec>) }
const
  mdnam = 'RDES';

var
  fl: boolean;
  mr: mrd_ptr;
  rf: rfd_ptr;

begin
  fr := GET_ATOM( NXT_PAR( fr ), true ); { get the record related atom }
  fl := GET_EVLFLAG( fr );         { get the free field link flag }
  with fr,at^ do
  begin
    if fncref.typ <> mrdty then EXEC_ERROR( mdnam, 254, e_severe );
    if val.typ = mrecty then FREE_RECORD_ALLOC( val.rec );  { ... free it, }
    mr := fncref.mrd;              { get the descriptor }
    val := obj_nil;
    fncref := obj_nil              { invalid the record reference atom }
  end
end REC_DESTROY;



function REC_GET_ELEM_VALUE( bl: rec_ptr; rf: rfd_ptr; idx: integer ): obj_ref;
const
  mdnam = 'RGEV';

var
  adr, i, idim, isz: integer;
  res: obj_ref;

begin
  res.flg := flg_def;              { Set the resulting default flags }
  with rf^ do
  begin
    idim := rfd_dim;               { Get the field dimension }
    adr  := rfd_off;               { Get the field offset }
    res.typ := rfd_typ.typ;        { Set the result type }
  end;
  if (idx >= 1) and (idx <= idim) then
  begin
    if res.typ <> strty then       { Adjust the offset with index }
      adr := adr + idx - 1
    else
      adr := adr + (idx - 1)*(res.nam^.length + 1);

    case res.typ of                { perform the suitable assignement }
      mrecty: res.rec := bl^.at [adr];
      charty: res.ch  := bl^.cht[adr];
      intub:  res.int := bl^.ubt[adr];
      intsb:  res.int := bl^.sbt[adr];
      intuw:  res.int := bl^.uwt[adr];
      intsw:  res.int := bl^.swt[adr];
      intty:  res.int := bl^.it [adr];
      sflty:  res.flt := bl^.ft[adr];
      flty:   res.flt := bl^.gt [adr];
      strty:  begin
                res := obj_nuls;
                isz := ORD( bl^.cht[adr] );
                res.nam := LISP_STRING_ALLOC( isz );
                res.nam^.length := isz;
                for i := 1 to isz do
                  res.nam^.body[i] := bl^.cht[adr+i]
              end;

    otherwise
      if res.typ >= atomety then
      with res.at^ do
        if fncref.flg.k = dty_funct then
        begin
          { not yet implemented }
          EXEC_ERROR( mdnam, 299, e_severe )
        end
        else
          EXEC_ERROR( mdnam, 253, e_severe )
      else
        EXEC_ERROR( mdnam, 253, e_severe )
    end
  end
  else { out of range index }
    EXEC_ERROR( mdnam, 259, e_error );
  REC_GET_ELEM_VALUE := res
end REC_GET_ELEM_VALUE;



function REC_LOAD_VAL( bl: rec_ptr; mr: mrd_ptr; var efl: obj_ref ): obj_ref;
{ bl  is the record pointer }
{ mr  is the record descriptor pointer }
{ efl is the call list of form:  ... <field_id> [ <index> ]) for record,
                           and    <index> for array }
const
  mdnam = 'RGET';

var
  idx: integer;
  rf: rfd_ptr;
  fa, res: obj_ref;

begin
  if mr^.mrd_rfdl^.rfd_atm = nil then
    { Array Reference }
    res := REC_GET_ELEM_VALUE( bl, mr^.mrd_rfdl, INTEVLDEF( efl, 1 ) )
  else
  begin { Record Reference }
    fa   := GET_ATOM( NXT_PAR( efl ), true ); { get the atom field }
    with fa.at^ do
    begin
      if val.typ <> rfdty then EXEC_ERROR( mdnam, 258, e_severe );
      rf := val.rfd;
      if rf^.rfd_mrd <> mr then EXEC_ERROR( mdnam, 256, e_severe );
    end;
    with rf^ do
    begin { field and decsriptor match }
      { get the index when required }
      if efl.typ = doublety then idx := INTEVL( efl )
                            else idx := 1;
      res := REC_GET_ELEM_VALUE( bl, rf, idx )
    end
  end;
  REC_LOAD_VAL := res
end REC_LOAD_VAL;




function REC_REFER( fr, el: obj_ref ): obj_ref;
{ directly called by the atom record }
{ (<atm_rec> <atm_field> [<index>] [<atm_field>... ] ) }
{ fr = <atm_rec> }
const
  mdnam = 'RREC';

var
  bl: rec_ptr;
  mr: mrd_ptr;
  re: obj_ref;

begin
  re := obj_nil;
  with fr.at^ do
  begin
    if val.typ <> mrecty then EXEC_ERROR( mdnam, 257, e_severe );
    bl := val.rec;               { get the record address }
    if fncref.flg.k <> dre_funct then EXEC_ERROR( mdnam, 254, e_severe );
    mr := fncref.mrd             { get the record descriptor }
  end;
  if el.typ = doublety then  re := REC_LOAD_VAL( bl, mr, el );
  REC_REFER := re
end REC_REFER;




procedure REC_PUT_ELEM_VALUE( bl: rec_ptr; rf: rfd_ptr; idx: integer; val: obj_ref );
const
  mdnam = 'RPUT';

var
  adr, i, isa, isz: integer;
  v: obj_ref;
  p: body_s_ptr;
  s: string( 16 );

begin
  with rf^ do
  begin
    adr  := rfd_off;               { get the field offset }
    if (idx >= 1) and (idx <= rfd_dim) then
    begin { O.K. for index }
      if rfd_typ.typ <> strty then { adjust the offset with index }
        adr := adr + idx - 1
      else
        adr := adr + (idx - 1)*(rfd_typ.nam^.length + 1);
      case rfd_typ.typ of          { perform the suitable assignement }
        mrecty: if (val.typ <> mrecty) and (val.typ <> areatyp) then
                  EXEC_ERROR( mdnam, 262, e_severe )
                else
                  bl^.at[adr]  := val.rec;
        charty: bl^.cht[adr] := GET_CHAR( val );
        intub:  bl^.ubt[adr] := INTVAL( val );
        intsb:  bl^.sbt[adr] := INTVAL( val );
        intuw:  bl^.uwt[adr] := INTVAL( val );
        intsw:  bl^.swt[adr] := INTVAL( val );
        intty:  bl^.it [adr] := INTVAL( val );
        sflty:  bl^.ft [adr] := FLTVAL( val );
        flty:   bl^.gt [adr] := FLTVAL( val );
        strty:  begin
                  GET_LISP_STR_REF( p, isz, s, val );
                  isa := rfd_typ.nam^.length;
                  if isz > isa then isz := isa;
                  bl^.cht[adr] := CHR( isz );
                  for i := 1 to isz do
                    bl^.cht[adr+i] := p^[i]
                end;
      otherwise
        if rfd_typ.typ >= atomety then
        with rfd_typ.at^ do
          if fncref.flg.k = dty_funct then
          begin
            { not yet implemented }
            EXEC_ERROR( mdnam, 299, e_severe )
          end
          else
            EXEC_ERROR( mdnam, 253, e_severe )
        else
          EXEC_ERROR( mdnam, 253, e_severe )
      end
    end
    else
      EXEC_ERROR( mdnam, 259, e_severe )
  end
end REC_PUT_ELEM_VALUE;




[global]
procedure REC_STORE_VAL( bl: rec_ptr; mr: mrd_ptr; var efl: obj_ref );
{ bl  is the record pointer }
{ mr  is the record descriptor pointer }
{ efl is the call list of form: ... <field_id> [ <index> ] <value_to_assigne>) }
const
  mdnam = 'RPUT';

var
  idx: integer;
  fa: obj_ref;

begin
  if mr^.mrd_rfdl^.rfd_atm = nil then
  begin { array reference }
    idx := INTEVLDEF( efl, 1 );
    REC_PUT_ELEM_VALUE( bl, mr^.mrd_rfdl, idx, F_EVAL( NXT_PAR( efl ) ) )
  end
  else
  begin
    fa := GET_ATOM( NXT_PAR( efl ), true ); { get the atom field identifier }
    with fa.at^ do
    begin
      if val.typ <> rfdty then EXEC_ERROR( mdnam, 258, e_severe );
      if val.rfd^.rfd_mrd <> mr then EXEC_ERROR( mdnam, 256, e_severe );
      if efl.typ = doublety then idx := INTEVLDEF( efl, 1 )
                            else idx := 1;
      REC_PUT_ELEM_VALUE( bl, val.rfd, idx, F_EVAL( NXT_PAR( efl ) ) )
    end
  end
end REC_STORE_VAL;




procedure REC_STORE( el: obj_ref );
{ (R_STORE <atm_rec> <atm_field> [<index>] <value> [<atm_field>... ] )
  or
  (R_STORE <atm_rec> <index> <value> [<index> <value> ...] ) }
{ fr = <atm_rec> }
const
  mdnam = 'SREC';

var
  bl: rec_ptr;
  mr: mrd_ptr;
  fr, res: obj_ref;

begin
  res := obj_nil;
  fr  := GET_ATOM( NXT_PAR( el ), true ); { get record atom }
  with fr.at^ do
  begin
    if val.typ <> mrecty then EXEC_ERROR( mdnam, 257, e_severe );
    bl := val.rec;                 { get the record address }
    if fncref.flg.k <> dre_funct then EXEC_ERROR( mdnam, 254, e_severe );
    mr := fncref.mrd               { get the record descriptor }
  end;
  while el.typ = doublety do
    REC_STORE_VAL( bl, mr, el )
end REC_STORE;




procedure FREE_A_LIST( li: obj_ref; nd: integer );
var
  o1, o2: obj_ref;

begin
  o1 := li;
  while li.typ = doublety do
  begin
    with li.db^ do
    begin
      if (car.typ = doublety) and (nd > 0) then FREE_A_LIST( car, nd - 1 );
      car := obj_nil
    end;
    o2 := li;
    li := li.db^.cdr
  end;
  o2.db^.cdr := dbl_free;
  dbl_free := o1
end FREE_A_LIST;




function GEN_VECT_CASE( pl: obj_ref ): obj_ref;
const
  mdnam = 'GCAS';
  maxcase = 512;

var
  re, o1, od, oe, se:      obj_ref;
  i, i1, ic, min, max, nw: integer;
  atb: array[0..maxcase-1] of obj_ref;
  ltb: array[1..2*maxcase-1] of integer;

begin
  nw := -1;
  for i := 1 to 2*maxcase-1 do  ltb[i] := -1;
  se := NXD_PAR( pl );          { Take off the LISP operator }
  se := NXD_PAR( pl );          { Get the selector expression }
  od := NXD_PAR( pl );          { Get the default action expression }
  { Fill the ltb and atb tables }
  repeat
    oe := NXD_PAR( pl );        { Get the label list }
    o1 := oe;                   { Save the label head list to kill it. }
    if oe.typ <> doublety then EXEC_ERROR( mdnam, 50, e_severe );
    repeat
      ic := INTEVL( oe );       { Get a label value }
      if nw < 0 then            { If first label }
      begin                     { We initialize the label and action table }
        nw  := 0;               { Set the count of action }
        min := ic; max := ic;   { Set the min and max of label }
        i1  := maxcase - ic     { Set the label table index origine }
      end
      else                      { Update the min and max }
        if min > ic then min := ic
                    else if max < ic then max := ic;
      ic := ic + i1;            { Set the ic as the ltb table index }
      if (ic <= 0) or (ic >= 2*maxcase) then
      begin  ic := 1; SRC_ERROR( mdnam, 94, e_severe )  end;
      if ltb[ic] < 0 then ltb[ic] := nw
                     else SRC_ERROR( mdnam, 93, e_error )
    until oe.typ <> doublety;
    FREE_A_LIST( o1, 1 );       { Free the label list }
    atb[nw] := NXD_PAR( pl );   { Get the related action }
    nw := nw + 1
  until pl.typ <> doublety;
  max := max - min + 1;         { Compute the size for the new vector }
  { Allocate the case vector }
  oe := VECTOR_ALLOC( max, false ); { Allocate the Vector }
  if oe.vect <> nil then
  with oe.vect^ do
    for i := 0 to max - 1 do
    begin
      ic := ltb[i+min+i1];      { Get the action number or -1 }
      if ic < 0 then vect_tab[i] := od
                else vect_tab[i] := atb[ic]
    end;

  re := F_CONS( oe, F_CONS( se, F_CONS_INT( min, F_CONS( od, obj_nil ) ) ) );
  GEN_VECT_CASE := F_CONS( case_atm, re )
end GEN_VECT_CASE;




function FNC_ACTIVATE( fn, effl: obj_ref ): obj_ref;
{ user defined function call. (DE ...), (DF ...), (DP ...), (DM ...)
                              or (SELF ...), (<r_type> ...) (<r_ref> ...) }
const
  mdnam = 'FNCA';

var
  res, body, pl, p0, p1: obj_ref;
  fty: function_kinds;

begin
  body := fn.at^.fncref;
  fty  := body.flg.k;
  { skip atome name for not macro function }
  if fty <> dm__funct then effl := effl.db^.cdr;
  recurs_nb := recurs_nb + 1;
  case fty of
    de__funct, df__funct, dm__funct, dp__funct:
      begin { LISP classical function }
        pl := NXT_PAR( body ); { get the formal list or atom }
        if fty = dp__funct then
        begin
          if FN_DP_SET_PARM( pl, effl ) then
                         EXEC_ERROR( 'CALL', 74, e_severe );
        end
        else
        begin
          if PARM_SAVE_AND_LINK( pl, effl, fty = de__funct )
             then EXEC_ERROR( 'CALL', 74, e_severe )
        end;
        fnc_result := obj_nil;    { set nil default result }
        if opt_debug then
          if opt_calltrace then F_TRACE_CALL( fn, pl, false );
        if fty = dp__funct then res := F_LET( body, false ) { execute the Let inside }
                           else res := EXEC_LIST( body );   { execute the function body }
        if stop_reg.typ = fexit_fnc then
        begin
          res := fnc_result; stop_reg := obj_nil
        end;
        if fty = dm__funct then res := F_EVAL( res );
        PARM_RESTORE( pl )
      end;

    dty_funct:
      res := REC_DEFINE_REC( fn, effl ); { Direct record definition }
  
    dre_funct:
      res := REC_REFER( fn, effl );    { direct record reference value }

  otherwise  { undefined function }
    res := obj_empty;
    EXEC_ERROR( mdnam, 57, e_error );
  end; { case "on atome function type" }

  if stop_reg.typ = atomety then
    if fn.at = stop_reg.at then stop_reg := obj_nil;

  if opt_debug then
    if opt_calltrace then F_TRACE_CALL( fn, res, true );
  recurs_nb := recurs_nb - 1;
  FNC_ACTIVATE := res
end FNC_ACTIVATE;



function F_CREATE_LAMBDA( def: obj_ref; fty: function_kinds ): obj_ref;
const
  mdnam = 'LAMB';

var
  fn, fmodel: obj_ref;

begin
  if def.typ = doublety then
  begin
    fn := ATOME_ALLOC;  { create a lambda function }
    case fty of
      de__funct: fmodel :=  lambda_atm;
      df__funct: fmodel := flambda_atm;
      dm__funct: fmodel := mlambda_atm;
    otherwise
    end;
    fn.at^ := fmodel.at^;
    with fn.at^ do
    begin
      fncref.typ := doublety;
      fncref.db  := def.db
    end
  end
  else
    EXEC_ERROR( mdnam, 72, e_severe );
  F_CREATE_LAMBDA := fn
end F_CREATE_LAMBDA;


[global]
function LOCATE_PROP( ll, indic: obj_ref ): obj_ref;
var
  fnd: boolean;

begin
  fnd := false;
  ll := ll.at^.plist;
  while (ll.typ = doublety) and not fnd do
    with ll.db^ do
    begin
      fnd := TEST_EQUAL( car.db^.car, indic );
      if not fnd then ll := cdr
    end;
  if fnd then
    LOCATE_PROP := ll.db^.car.db^.cdr
  else
    LOCATE_PROP := obj_nil
end LOCATE_PROP;


[global]
procedure NEW_PROP( atm, indic, value: obj_ref );
var
  p, l: obj_ref;
  fnd: boolean;

begin
  with atm.at^ do
  begin
    p := plist; fnd := false;
    l := obj_nil;
    while (p.typ = doublety) and not fnd do
      with p.db^ do
        if not TEST_EQUAL( car.db^.car, indic ) then
        begin
          l := p; p := cdr
        end
        else fnd := true;
    if not fnd then
    begin
      p := DOUBLET_ALLOC;
      if l.typ = nullty then plist := p
      else l.db^.cdr := p;
      with p.db^ do
      begin
        car := DOUBLET_ALLOC;
        with car.db^ do
        begin
          car := indic; cdr := value
        end
      end
    end
    else p.db^.car.db^.cdr := value
  end
end NEW_PROP;


[global]
procedure REM_PROP( atm, indic: obj_ref );
var
  p, l: obj_ref;
  fnd: boolean;

begin
  with atm.at^ do
  begin
    p := plist; fnd := false;
    l := obj_nil;
    while (p.typ = doublety) and not fnd do
      with p.db^ do
        if not TEST_EQUAL( car.db^.car, indic ) then
        begin
          l := p; p := cdr
        end
        else fnd := true;
    if fnd then
    begin
      if l.typ = nullty then
        plist := p.db^.cdr
      else
        l.db^.cdr := p.db^.cdr;
      with p.db^ do
      begin
        cdr := car;
        cdr.db^.cdr := dbl_free
      end;
      dbl_free := p
    end
  end
end REM_PROP;



function LIST_COPY( var ll: obj_ref ): obj_ref;
var cur, last: obj_ref;
begin
  if ll.typ = nullty then LIST_COPY := obj_nil
  else
  begin
    last := obj_nil;
    while ll.typ = doublety do
    begin
      cur := DOUBLET_ALLOC;
      cur.db^.car := NXT_PAR( ll );
      if last.typ = nullty then
        LIST_COPY := cur
      else
        last.db^.cdr := cur;
      last := cur
    end;
    ll := cur { to use for append }
  end
end LIST_COPY;



function LIST_REMOVE( var ll: obj_ref; objdel: obj_ref; nb: integer ): obj_ref;
var cur, last, elem, res: obj_ref;
begin
  if ll.typ = nullty then res := obj_nil
  else
  begin
    last := obj_nil;
    while ll.typ = doublety do
    begin
      elem := NXT_PAR( ll );
      if not TEST_EQUAL( elem, objdel ) then
      begin
        cur := DOUBLET_ALLOC;
        cur.db^.car := elem;
        if last.typ = nullty then
          res := cur
        else
          last.db^.cdr := cur;
        last := cur
      end
    end;
    ll := cur { to use for possible append }
  end;
  LIST_REMOVE := res
end LIST_REMOVE;



function F_MEMBER( ele, liste: obj_ref): obj_ref;
var
  fnd: boolean;
  res: obj_ref;

begin
  res := obj_nil;
  if liste.typ = doublety then
  repeat
    with liste.db^ do
    begin
      fnd := TEST_EQUAL( car, ele );
      if not fnd then
      begin
        res := F_MEMBER( ele, car );
        if res.typ = nullty then
          liste := cdr
        else fnd := true
      end else res := liste
    end
  until fnd or (liste.typ <> doublety);
  F_MEMBER := res
end F_MEMBER;



function F_BLD_LIST( ll: obj_ref ): obj_ref;
var
  ob1, ob2, res: obj_ref;

begin
  res := obj_nil;
  while ll.typ = doublety do
  begin
    ob2 := DOUBLET_ALLOC;
    ob2.db^.car := F_EVAL( NXT_PAR( ll ) );
    if res.typ = nullty then
      res := ob2
    else
      ob1.db^.cdr := ob2;
    ob1 := ob2
  end;
  F_BLD_LIST := res
end F_BLD_LIST;



function SUBSTITUTE( newo, oldo, list: obj_ref ): obj_ref;
var
  res, cdb, lst: obj_ref;

begin
  res := obj_nil;
  while list.typ = doublety do
  begin
    cdb := DOUBLET_ALLOC;
    if res.typ = nullty then
      res := cdb
    else
      lst.db^.cdr := cdb;
    lst := cdb;
    with list.db^ do
    begin
      if TEST_EQUAL( car, oldo ) then
        cdb.db^.car := newo
      else
        if car.typ = doublety then { handle any sub-list }
          cdb.db^.car := SUBSTITUTE( newo, oldo, car )
        else
          cdb.db^.car := list.db^.car;
      list := cdr
    end
  end;
  SUBSTITUTE := res
end SUBSTITUTE;



procedure DSUBSTITUTE( newo, oldo, list: obj_ref );
begin
  while list.typ = doublety do
  with list.db^ do
  begin
    if TEST_EQUAL( car, oldo ) then
      car := newo
    else
      if car.typ = doublety then DSUBSTITUTE( newo, oldo, car );
    list := cdr
  end
end DSUBSTITUTE;



procedure LSH_LWORD( var iv: integer; var carry: boolean );
begin
  if iv < 0 then
  begin
    carry := true;
    iv := iv + maxint;
    iv := (iv + 1) * 2
  end
  else
  begin
    carry := false;
    iv := iv * 2
  end
end LSH_LWORD;



procedure RSH_LWORD( var iv: integer; var carry: boolean );
begin
  carry := ODD( iv );
  iv := iv div 2;
  if iv < 0 then
  begin
    iv := iv + maxint;
    iv := iv + 1
  end
end RSH_LWORD;



function BIT_FUNCTION( fnc: obj_type; eflist: obj_ref ): obj_ref;
type
  eqv = record case integer of
    0:( s: bits );
    1:( i: integer );
    2:( u: unsigned );
  end;

var
  flg: boolean;
  w1, w2: eqv;
 res: obj_ref;

begin
  w1.i := INTEVL( eflist );
  w2.i := INTEVLDEF( eflist, 0);
  case fnc of
    bit_test_fnc,                           { bit test function }
    bit_and_fnc:   w1.s := w1.s * w2.s;     { bit and function }

    bit_ash_fnc:   if w2.i >= 0 then        { bit arithmetic shift }
                     w1.i := w1.i * (2**w2.i)
                   else
                     w1.i := w1.i div (2**(-w2.i));

    bit_clear_fnc: w1.s := w1.s - w2.s;     { bit clear function }

    bit_com_fnc:   begin
                     w2.i := -1;
                     w1.s := w2.s - w1.s;   { bit complement function }
                   end;


    bit_lsh_fnc:   if w2.i >= 0 then        { bit logical shift }
                     while w2.i > 0 do
                     begin
                       LSH_LWORD( w1.i, flg );
                       w2.i := w2.i - 1
                     end
                   else
                     while w2.i < 0 do
                     begin
                       RSH_LWORD( w1.i, flg );
                       w2.i := w2.i + 1
                     end;

    bit_rot_fnc:   if w2.i > 0 then         { bit rotate function }
                     while w2.i > 0 do
                     begin
                       LSH_LWORD( w1.i, flg );
                       if flg then w1.i := w1.i + 1;
                       w2.i := w2.i - 1
                     end
                   else
                     while w2.i < 0 do
                     begin
                       RSH_LWORD( w1.i, flg );
                       if flg then w1.i := w1.i - maxint - 1;
                       w2.i := w2.i + 1
                     end;

    bit_set_fnc:   w1.s := w1.s + w2.s;     { bit set (inclusive or) function }
    bit_xor_fnc:   w1.s :=   (w1.s + w2.s)
                           - (w1.s * w2.s); { bit exclusive or function }
  end;
  res.flg := flg_def;
  if fnc = bit_test_fnc then
    res := log_val[(w1.s <> [])]
  else
  begin
    res.typ := intty;
    res.int := w1.i
  end;
  BIT_FUNCTION := res
end BIT_FUNCTION;



[global]
function F_EVAL( obj: obj_ref ): obj_ref;
const
  mdnam = 'EVAL';

var
  i, j: integer;
  save_point,
  eflist, memo, memo1, memo2, calist: obj_ref;
  flg, step: boolean;
  cha: char;

begin { F_EVAL }
  save_point := curr_point; { save the current statement pointer }
  curr_point := obj; { keep point for possible error }
  memo := obj_nil;
  step := false;
  if opt_debug then
  begin { debuging option }
    if opt_exectrace then F_TRACE_EXEC( obj );
    if (exception_debug.typ = doublety) and
       (exception_step or (breakpt_flg in obj.flg.f)) then
      { set the exception type () => break, T => step, integer => error }
      step := ELISP_DEBUG( obj )
  end;
  case obj.typ of

    eoln_seen,               { EOLN cte code }
    eof_seen,                { EOF cte code }
    lextyp,
    vectortyp,
    truety, nullty,
    intub, intsb, intuw, intsw,
    intty, sflty, flty, strty, charty, lfilety,
    areatyp1, areatyp, mrecty, mrdty, rfdty:    memo := obj;

    doublety:
      begin
        eflist := obj.db^.cdr;  { Get the parameter list }
        calist := obj.db^.car;  { Get the function definition }
        case calist.typ of
          doublety:
            begin
              case calist.db^.car.typ of
                lambda_fnc:
                  begin
                    calist := F_CREATE_LAMBDA( calist.db^.cdr, de__funct );
                    memo   := FNC_ACTIVATE( calist, obj )
                  end;
                flambda_fnc:
                  begin
                    calist := F_CREATE_LAMBDA( calist.db^.cdr, df__funct );
                    memo   := FNC_ACTIVATE( calist, obj )
                  end;
                mlambda_fnc:
                  begin
                    calist := F_CREATE_LAMBDA( calist.db^.cdr, dm__funct );
                    memo   := FNC_ACTIVATE( calist, obj )
                  end;
              otherwise
                EXEC_ERROR( mdnam, 72, e_severe )
                { memo := calist  ??? }
                { memo := EXEC_LIST( calist ) }
              end;
              calist.at^.ats    := obj_nil;
              calist.at^.val    := atm_free;
              calist.at^.plist  := obj_nil;
              calist.at^.fncref := obj_nil
            end;

          atomety:  memo := FNC_ACTIVATE( calist, obj );

          list_fnc: memo := F_BLD_LIST( eflist );

          progn_fnc: begin
                       memo := EXEC_LIST( eflist );
                       if TEST_EQ( stop_reg, obj ) then stop_reg := obj_nil
                     end;

          quot_fnc:  memo := NXT_PAR( eflist );

          car_fnc:   memo := F_CAR(  F_EVAL( F_CAR( eflist ) ) );
          cdr_fnc:   memo := F_CDR(  F_EVAL( F_CAR( eflist ) ) );
          caar_fnc:  memo := F_CAR( F_CAR( F_EVAL( F_CAR ( eflist ) ) ) );
          cadr_fnc:  memo := F_CAR( F_CDR( F_EVAL( F_CAR( eflist ) ) ) );
          cdar_fnc:  memo := F_CDR( F_CAR( F_EVAL( F_CAR( eflist ) ) ) );
          cddr_fnc:  memo := F_CDR( F_CDR(  F_EVAL( F_CAR( eflist ) ) ) );
          caaar_fnc: memo := F_CAR( F_CAR( F_CAR(
                                        F_EVAL( F_CAR( eflist ) ) ) ) );
          caadr_fnc: memo := F_CAR( F_CAR( F_CDR(
                                        F_EVAL( F_CAR( eflist ) ) ) ) );
          cadar_fnc: memo := F_CAR( F_CDR( F_CAR(
                                        F_EVAL( F_CAR( eflist ) ) ) ) );
          caddr_fnc: memo := F_CAR( F_CDR( F_CDR(
                                        F_EVAL( F_CAR( eflist ) ) ) ) );
          cdaar_fnc: memo := F_CDR( F_CAR( F_CAR(
                                        F_EVAL( F_CAR( eflist ) ) ) ) );
          cdadr_fnc: memo := F_CDR( F_CAR( F_CDR(
                                        F_EVAL( F_CAR( eflist ) ) ) ) );
          cddar_fnc: memo := F_CDR( F_CDR( F_CAR(
                                        F_EVAL( F_CAR( eflist ) ) ) ) );
          cdddr_fnc: memo := F_CDR( F_CDR( F_CDR(
                                        F_EVAL( F_CAR( eflist ) ) ) ) );

          nth_fnc:   begin
                       calist.int := INTEVL( eflist );
                       eflist := F_EVAL( NXT_PAR( eflist ) );
                       while (calist.int > 0) and (eflist.typ = doublety) do
                       begin
                         eflist := eflist.db^.cdr;
                         calist.int := calist.int - 1
                       end;
                       memo := F_CAR( eflist )
                     end;

          nthcdr_fnc: begin
                       calist.int := INTEVL( eflist );
                       memo := F_EVAL( NXT_PAR( eflist ) );
                       while (calist.int >= 0) and (memo.typ = doublety) do
                       begin
                         memo := memo.db^.cdr;
                         calist.int := calist.int - 1
                       end
                     end;

          cons_fnc:  begin
                       memo := F_EVAL( NXT_PAR( eflist ) );
                       memo := F_CONS( memo, F_EVAL( F_CAR( eflist ) ) )
                     end;

          eval_fnc:  memo := F_EVAL( F_EVAL( F_CAR( eflist ) ) );

          apply_fnc:
                     begin
                       calist := F_EVAL( NXT_PAR( eflist ) );
                       calist := F_CONS( calist, F_EVAL( F_CAR( eflist ) ) );
                       memo := F_EVAL( calist );
                       calist.db^.cdr := dbl_free;
                       dbl_free := calist
                     end;

          funcall_fnc:
                     begin
                       calist := F_EVAL( NXT_PAR( eflist ) );
                       calist := F_CONS( calist, eflist );
                       memo := F_EVAL( calist );
                       calist.db^.cdr := dbl_free;
                       dbl_free := calist
                     end;

          mapc_fnc:  begin
                       calist := GET_LIST( eflist, false );
                       memo   := F_EVAL( F_CAR( eflist ) );
                       { built: (funct (quote ())) }
                       memo1 := DOUBLET_ALLOC;
                       memo2 := F_CONS( obj_quot, memo1 );
                       memo2 := F_CONS( memo2, obj_nil );
                       memo2 := F_CONS( memo, memo2 );
                       while calist.typ = doublety do
                       begin
                         memo1.db^.car := NXT_PAR( calist );
                         eflist := F_EVAL( memo2 )
                       end;
                       { free the doublets }
                       memo1.db^.cdr := dbl_free;
                       with memo2.db^.cdr.db^ do
                       begin
                         cdr := car; car := obj_nil
                       end;
                       dbl_free := memo2
                     end;

          mapcar_fnc: begin
                       calist := GET_LIST( eflist, false );
                       eflist := F_EVAL( F_CAR( eflist ) );
                       memo := obj_nil;
                       { built: (funct (quote ())) }
                       memo1 := DOUBLET_ALLOC;
                       memo2 := F_CONS( obj_quot, memo1 );
                       memo2 := F_CONS( memo2, obj_nil );
                       memo2 := F_CONS( eflist, memo2 );
                       while calist.typ = doublety do
                       begin
                         memo1.db^.car := NXT_PAR( calist );
                         if memo.typ = nullty then
                         begin
                           memo := F_CONS( F_EVAL( memo2 ), obj_nil );
                           eflist := memo
                         end
                         else
                         begin
                           eflist.db^.cdr := F_CONS( F_EVAL( memo2 ), obj_nil );
                           eflist := eflist.db^.cdr
                         end
                       end;
                       { Free the doublets }
                       memo1.db^.cdr := dbl_free;
                       with memo2.db^.cdr.db^ do
                       begin
                         cdr := car; car := obj_nil
                       end;
                       dbl_free := memo2
                     end;

          symeval_fnc: memo := F_EVAL( GET_ATOM(
                                   F_EVAL( F_CAR( eflist ) ), false ) );

          plist_fnc:
                     begin
                       calist := GET_ATOM( F_EVAL( NXT_PAR( eflist ) ), true );
                       memo := calist.at^.plist;
                       if eflist.typ = doublety then
                         calist.at^.plist := F_EVAL( F_CAR( eflist ) )
                     end;

          getprop_fnc:
                     begin
                       calist := GET_ATOM( F_EVAL( NXT_PAR( eflist ) ), true );
                       memo := F_EVAL( F_CAR( eflist ) );
                       memo := LOCATE_PROP( calist, memo )
                     end;

          putprop_fnc:
                     begin
                       memo := GET_ATOM( F_EVAL( NXT_PAR( eflist ) ), true );
                       repeat
                         calist := F_EVAL( NXT_PAR( eflist ) );
                         NEW_PROP( memo, calist, F_EVAL( NXT_PAR( eflist ) ) )
                       until eflist.typ <> doublety
                     end;

          remprop_fnc:
                     begin
                       memo := GET_ATOM( F_EVAL( NXT_PAR( eflist ) ), true );
                       repeat
                         REM_PROP( memo, F_EVAL( NXT_PAR( eflist ) ) )
                       until eflist.typ <> doublety
                     end;

          atom_fnc:
                     begin
                       memo1 := F_EVAL( F_CAR( eflist ) );
                       memo := log_val[ (memo1.typ <> doublety) ];
                       if GET_EVLFLAG( eflist ) then
                         memo := log_val[ (memo1.typ >= atomety) ]
                     end;

          consp_fnc:
                     begin
                       memo := F_EVAL( F_CAR( eflist ) );
                       memo := log_val[ (memo.typ = doublety) ]
                     end;

          fixp_fnc:  begin
                       memo := F_EVAL( F_CAR( eflist ) );
                       memo := log_val[ memo.typ = intty ]
                     end;

          floatp_fnc: begin
                       memo := F_EVAL( F_CAR( eflist ) );
                       memo := log_val[ memo.typ = flty ]
                     end;

          numberp_fnc:
                     begin
                       memo := F_EVAL( F_CAR( eflist ) );
                       memo := log_val[ (memo.typ = intty) or
                                        (memo.typ = flty) ]
                     end;


          charp_fnc: begin
                       memo := F_EVAL( F_CAR( eflist ) );
                       memo := log_val[ memo.typ = charty ]
                     end;

          stringp_fnc:
                     begin
                       memo := F_EVAL( F_CAR( eflist ) );
                       memo := log_val[(memo.typ = strty) or (memo.typ = charty)]
                     end;

          null_fnc:  memo := log_val[ not GET_EVLFLAG( eflist ) ];

          and_fnc:   repeat
                       memo := F_EVAL( NXT_PAR( eflist ) );
                     until    (not GET_VALFLAG( memo ))
                           or (eflist.typ <> doublety);

          or_fnc:    repeat
                       memo := F_EVAL( NXT_PAR( eflist ) );
                     until GET_VALFLAG( memo ) or (eflist.typ <> doublety);


          if_fnc:    begin
                       memo := F_EVAL( NXT_PAR( eflist ) );
                       if GET_VALFLAG( memo ) then { all expr are true except nil }
                         memo := F_EVAL( NXT_PAR( eflist ) )
                       else
                         if eflist.typ <> nullty then
                         begin
                           eflist := eflist.db^.cdr;  { to skip true condition }
                           memo := EXEC_LIST( eflist )
                         end
                     end;

          cond_fnc:  memo := F_COND( eflist );

          unless_fnc: begin
                       memo := F_EVAL( NXT_PAR( eflist ) );
                       if not GET_VALFLAG( memo ) then
                         memo := EXEC_LIST( eflist )
                     end;

          when_fnc:  begin
                       memo := F_EVAL( NXT_PAR( eflist ) );
                       if GET_VALFLAG( memo ) then
                         memo := EXEC_LIST( eflist )
                     end;

          brkwh_fnc: begin
                       memo := F_EVAL( NXT_PAR( eflist ) );
                       if GET_VALFLAG( memo ) then
                         stop_reg := F_EVAL( F_CAR( eflist ) )
                     end;

          brkunl_fnc: begin
                       memo := F_EVAL( NXT_PAR( eflist ) );
                       if not GET_VALFLAG( memo ) then
                         stop_reg := F_EVAL( F_CAR( eflist ) )
                     end;

          loop_fnc:  begin
                       i := INTEVLDEF( eflist, -1 );
                       repeat
                         if i > 0 then i := i - 1;
                         memo := EXEC_LIST( eflist )
                       until (i = 0) or (stop_reg.typ <> nullty);
                       if TEST_EQ( stop_reg, obj ) then stop_reg := obj_nil
                     end;


          while_fnc: begin
                       calist := eflist;
                       memo := F_EVAL( NXT_PAR( eflist ) );
                       while GET_VALFLAG( memo ) and
                            (stop_reg.typ = nullty) do
                       begin
                         memo := EXEC_LIST( eflist );
                         eflist := calist;
                         memo := F_EVAL( NXT_PAR( eflist ) )
                       end;
                       if TEST_EQ( stop_reg, obj ) then stop_reg := obj_nil
                     end;

         repeat_fnc: begin
                       repeat
                         memo := EXEC_LIST( eflist )
                       until (stop_reg.typ <> nullty) or GET_VALFLAG( memo );
                       if TEST_EQ( stop_reg, obj ) then stop_reg := obj_nil
                     end;

          until_fnc: begin
                       memo1 := NXT_PAR( eflist );
                       memo  := F_EVAL( memo1 );
                       while not GET_VALFLAG( memo ) and
                            (stop_reg.typ = nullty)  do
                       begin
                         memo := EXEC_LIST( eflist );
                         memo := F_EVAL( memo1 )
                       end;
                       if TEST_EQ( stop_reg, obj ) then stop_reg := obj_nil
                     end;

          de_fnc:    memo := F_DE( eflist, de__funct );
          df_fnc:    memo := F_DE( eflist, df__funct );
          dp_fnc:    memo := F_DE( eflist, dp__funct );
          dm_fnc:    memo := F_DE( eflist, dm__funct );

          dmc_fnc:   memo := F_DMC( eflist );
          dma_fnc:   memo := F_DMA( eflist );

          fncbody_fnc: begin
                       memo := GET_ATOM( F_EVAL( F_CAR( eflist ) ), true );
                       if memo.typ > atomety then memo := obj_true
                                             else memo := memo.at^.fncref
                     end;

          let_fnc,
          letn_fnc:  memo := F_LET( eflist, (calist.typ = letn_fnc) );

          lambda_fnc:  memo := F_CREATE_LAMBDA( eflist, de__funct );
          flambda_fnc: memo := F_CREATE_LAMBDA( eflist, df__funct );
          mlambda_fnc: memo := F_CREATE_LAMBDA( eflist, dm__funct );

          typech_fnc: begin
                       calist.ch := GET_CHAR( F_EVAL( NXT_PAR( eflist ) ) );
                       if (calist.ch < '!') and (calist.ch > '~') then
                         EXEC_ERROR( mdnam, 73, e_error );
                       if alt_mac_tab_flag then
                       begin
                         memo := alt_mtb[calist.ch];
                         if eflist.typ = doublety then
                           alt_mtb[calist.ch] := F_EVAL( F_CAR( eflist ) )
                       end
                       else
                       begin
                         memo := mac_tab[calist.ch];
                         if eflist.typ = doublety then
                           mac_tab[calist.ch] := F_EVAL( F_CAR( eflist ) )
                       end
                     end;

          neq_fnc:   begin
                       memo := F_EVAL( NXT_PAR( eflist ) );
                       memo := log_val[ not TEST_EQ( memo,
                                                F_EVAL( F_CAR( eflist ) ) ) ]
                     end;

          eq_fnc:    begin
                       memo := F_EVAL( NXT_PAR( eflist ) );
                       memo := log_val[ TEST_EQ( memo,
                                                 F_EVAL( F_CAR( eflist ) ) ) ]
                     end;

          equal_fnc: begin
                       memo := F_EVAL( NXT_PAR( eflist ) );
                       memo := log_val[ TEST_EQUAL( memo,
                                                 F_EVAL( F_CAR( eflist ) ) ) ]
                     end;

         nequal_fnc: begin
                       memo := F_EVAL( NXT_PAR( eflist ) );
                       memo := log_val[ not TEST_EQUAL( memo,
                                                 F_EVAL( F_CAR( eflist ) ) ) ]
                     end;

          setq_fnc:  while eflist.typ = doublety do
                     begin
                       memo := NXT_PAR( eflist );
                       memo := F_SET( memo, F_EVAL( NXT_PAR( eflist ) ) )
                     end;

          setplist_fnc:
                     repeat
                       calist := GET_ATOM( F_EVAL( NXT_PAR( eflist ) ), true );
                       memo := F_EVAL( NXT_PAR( eflist ) );
                       calist.at^.plist := memo
                     until eflist.typ <> doublety;

          set_fnc:   begin
                       memo := F_EVAL( NXT_PAR( eflist ) );
                       memo := F_SET( memo, F_EVAL( F_CAR( eflist ) ) )
                     end;

          explodech_fnc: begin
                       eflist := GET_ATOM( F_EVAL( NXT_PAR( eflist ) ), true );
                       memo := EXPLODCH( eflist )
                     end;

          implodech_fnc: memo := IMPLODCH( F_EVAL( F_CAR( eflist ) ) );

          chk_flty_fnc: begin
                       memo1 := F_EVAL( F_CAR( eflist ) );
                       memo := log_val[CHECK_FILE_SPC_TYPE( memo1 )]
                     end;
 
          fspc_parse_fnc: begin
                       memo1 := F_EVAL( NXT_PAR( eflist ) );
                       memo := PARSE_FILE_SPC( memo1, F_EVAL( F_CAR( eflist ) ) )
                     end;

          s_index_fnc: begin
                       memo1 := F_EVAL( NXT_PAR( eflist ) );
                       memo2 := F_EVAL( NXT_PAR( eflist ) );
                       i := INTEVLDEF( eflist, 0 );
                       j := INTEVLDEF( eflist, -1 );
                       if eflist.typ = doublety then
                         flg := GET_EVLFLAG( eflist )
                       else
                         flg := false;
                       memo.typ := intty;
                       memo.int := STRING_INDEX( memo1, memo2, i, j, flg )
                     end;

          s_length_fnc: begin
                       memo.typ := intty;
                       memo.int := GET_LISP_STR_LEN( F_EVAL( F_CAR( eflist ) ) )
                     end;

          s_substr_fnc: begin
                       calist := F_EVAL( NXT_PAR( eflist ) );
                       i := INTEVL( eflist );
                       j := INTEVLDEF( eflist, 0 );
                       STRING_SUBSTR( memo, calist, i, j )
                     end;

          s_concat_fnc: STRING_CONCAT( memo, eflist );

          s_string_fnc: begin
                       calist := NUMEVL( eflist );   { Get the numeric value }
                       i := INTEVLDEF( eflist, 16 ); { Get the field size }
                       j := INTEVLDEF( eflist, 10 ); { Get base or dec. spec. }
                       if calist.typ = intty then
                         STRING_CV_IS( memo, calist.int, i, j )
                       else
                       begin
                         eflist.int := INTEVLDEF( eflist, 3 );
                         STRING_CV_RS( memo, calist.flt, i, j, eflist.int  )
                       end
                     end;

          s_chcase_fnc: begin { Change the specified string case }
                       memo := GET_LISP_STR( F_EVAL( NXT_PAR( eflist ) ), '' );
                       flg  := GET_EVLFLAG( eflist );
                       if memo.typ = strty then
                         if memo.nam <> nil then
                         with memo.nam^ do
                           for ii := 1 to length do
                             if flg then { Minor to Major }
                             begin
                               if (body[ii] >= 'a') and (body[ii] <= 'z') then
                                 body[ii] := CHAR( ORD( body[ii] ) - 32 )
                             end
                             else { Major to Minor }
                             begin
                               if (body[ii] >= 'A') and (body[ii] <= 'Z') then
                                 body[ii] := CHAR( ORD( body[ii] ) + 32 )
                             end
                       else memo := obj_nil
                     end;

          in_fix_fnc: begin
                        memo.typ := intty; memo.int := INTEVL( eflist );
                        if (eflist.typ >= intub) and (eflist.typ <= intty)
                        then memo.typ := eflist.typ
                     end;

          in_float_fnc: begin
                       memo.typ := flty; memo.flt := FLTEVL( eflist )
                     end;

          remq_fnc:  begin
                       calist := F_EVAL( NXT_PAR( eflist ) );
                       memo1  := GET_LIST( eflist, true );
                       memo   := obj_nil;
                       i := INTEVLDEF( eflist, -1 );
                       while memo1.typ = doublety do
                       with memo1.db^ do
                       begin
                         if (i <> 0) and TEST_EQ( car, calist ) then
                         begin
                           if i > 0 then i := i - 1
                         end  
                         else  
                         begin
                           if memo.typ = nullty then
                           begin
                             memo := F_CONS( car, obj_nil );
                             eflist := memo
                           end
                           else
                           begin
                             eflist.db^.cdr := F_CONS( car, obj_nil );
                             eflist := eflist.db^.cdr
                           end
                         end;
                         memo1 := cdr
                       end
                     end;

          remove_fnc: begin
                       calist := F_EVAL( NXT_PAR( eflist ) );
                       memo1  := GET_LIST( eflist, true );
                       memo   := obj_nil;
                       i := INTEVLDEF( eflist, -1 );
                       while memo1.typ = doublety do
                       with memo1.db^ do
                       begin
                         if (i <> 0) and TEST_EQUAL( car, calist ) then
                         begin
                           if i > 0 then i := i - 1
                         end  
                         else  
                         begin
                           if memo.typ = nullty then
                           begin
                             memo := F_CONS( car, obj_nil );
                             eflist := memo;
                           end
                           else
                           begin
                             eflist.db^.cdr := F_CONS( car, obj_nil );
                             eflist := eflist.db^.cdr
                           end
                         end;
                         memo1 := cdr
                       end
                     end;

          delq_fnc:  begin
                       calist := F_EVAL( NXT_PAR( eflist ) );
                       memo1  := GET_LIST( eflist, true );
                       memo   := obj_nil;
                       i := INTEVLDEF( eflist, -1 );
                       while memo1.typ = doublety do
                       with memo1.db^ do
                       begin
                         if TEST_EQ( car, calist ) and (i <> 0) then
                         begin
                           memo1 := cdr;
                           if i > 0 then i := i - 1;
                           if memo.typ = doublety then
                             eflist.db^.cdr := memo1
                         end
                         else
                         begin
                           if memo.typ <> doublety then
                             memo := memo1
                           else
                             eflist.db^.cdr := memo1;
                           eflist := memo1;
                           memo1 := cdr
                         end
                       end
                     end;

          delete_fnc: begin
                       calist := F_EVAL( NXT_PAR( eflist ) );
                       memo1  := GET_LIST( eflist, true );
                       memo   := obj_nil;
                       i := INTEVLDEF( eflist, -1 );
                       while memo1.typ = doublety do
                       with memo1.db^ do
                       begin
                         if TEST_EQUAL( car, calist ) and (i <> 0) then
                         begin
                           memo1 := cdr;
                           if i > 0 then i := i - 1;
                           if memo.typ = doublety then
                             eflist.db^.cdr := memo1
                         end
                         else
                         begin
                           if memo.typ <> doublety then
                             memo := memo1
                           else
                             eflist.db^.cdr := memo1;
                           eflist := memo1;
                           memo1 := cdr
                         end
                       end
                     end;


          subst_fnc: begin
                       memo1 := F_EVAL( NXT_PAR( eflist ) );
                       memo2 := F_EVAL( NXT_PAR( eflist ) );
                       memo  := GET_LIST( eflist, false );
                       if memo.typ = doublety then
                         memo := SUBSTITUTE( memo1, memo2, memo )
                     end;

          dsubst_fnc: begin
                       memo1 := F_EVAL( NXT_PAR( eflist ) );
                       memo2 := F_EVAL( NXT_PAR( eflist ) );
                       memo  := GET_LIST( eflist, false );
                       if memo.typ = doublety then
                         DSUBSTITUTE( memo1, memo2, memo )
                     end;

          assq_fnc:  begin
                       memo1 := F_EVAL( NXT_PAR( eflist ) );
                       eflist := GET_LIST( eflist, false );
                       while eflist.typ = doublety do
                       begin
                         memo := NXT_PAR( eflist );
                         if TEST_EQ( F_CAR( memo ), memo1 ) then
                           eflist := obj_nil
                         else
                           memo := obj_nil
                       end
                     end;


          assoc_fnc: begin
                       memo1 := F_EVAL( NXT_PAR( eflist ) );
                       eflist := GET_LIST( eflist, false );
                       while eflist.typ = doublety do
                       begin
                         memo := NXT_PAR( eflist );
                         if TEST_EQUAL( F_CAR( memo ), memo1 ) then
                           eflist := obj_nil
                         else
                           memo := obj_nil
                       end
                     end;

          last_fnc:  begin
                       calist := GET_LIST( eflist, false );
                       if calist.typ = doublety then
                         repeat
                           memo := calist;
                           calist := calist.db^.cdr
                         until calist.typ = nullty
                       else memo := obj_nil
                     end;

          nreverse_fnc: begin
                       eflist := GET_LIST( eflist, false );
                       memo  := obj_nil;
                       while eflist.typ = doublety do
                       begin
                         memo1  := eflist;
                         eflist := eflist.db^.cdr;
                         memo1.db^.cdr := memo;
                         memo   := memo1
                       end
                     end;

          reverse_fnc: begin
                       eflist := F_EVAL( NXT_PAR( eflist ) );
                       memo := obj_nil;
                       while eflist.typ = doublety do
                       begin
                         calist := DOUBLET_ALLOC;
                         with calist.db^ do
                         begin
                           cdr := memo;
                           car := NXT_PAR( eflist )
                         end;
                         memo := calist
                       end
                     end;

          nconc_fnc: begin
                       repeat
                         memo := GET_LIST( eflist, false )
                       until (eflist.typ <> doublety) or (memo.typ = doublety);
                       memo1 := memo;
                       if memo.typ = doublety then
                       while eflist.typ = doublety do
                       begin
                         calist := GET_LIST( eflist, false );
                         if calist.typ = doublety then
                         begin
                           while memo1.db^.cdr.typ = doublety do
                             memo1 := memo1.db^.cdr; { look for end of list }
                           memo1.db^.cdr := calist   { concates the list }
                         end
                       end
                     end;

          append_fnc: begin
                       calist := GET_LIST( eflist, false );
                       eflist := F_EVAL( F_CAR( eflist ) );
                       if calist.typ = nullty then memo := eflist
                       else
                       begin
                         memo := LIST_COPY( calist );
                         calist.db^.cdr := eflist     { do the append }
                       end
                     end;


          length_fnc: begin
                       calist := F_EVAL( F_CAR( eflist ) );
                       memo.typ := intty; memo.int := 0;
                       while calist.typ = doublety do
                       begin
                         memo.int := memo.int + 1;
                         calist := calist.db^.cdr
                       end
                     end;

          memq_fnc:  begin
                       calist := F_EVAL( NXT_PAR( eflist ) );
                       memo := F_EVAL( F_CAR( eflist ) );
                       if memo.typ <> nullty then
                         if memo.typ = doublety then
                         repeat
                           flg := TEST_EQ( memo.db^.car, calist );
                           if not flg then memo := memo.db^.cdr
                         until flg or (memo.typ <> doublety)
                         else EXEC_ERROR( mdnam, 50, e_severe )
                     end;

          member_fnc: begin
                       calist := F_EVAL( NXT_PAR( eflist ) );
                       memo := F_MEMBER( calist, F_EVAL( F_CAR( eflist ) ) )
                     end;

          l_build_fnc: begin
                       i := INTEVL( eflist );
                       calist := F_EVAL( F_CAR( eflist ) );
                       if i < 1 then i := 1;
                       memo := obj_nil;
                       while i > 0 do
                       begin
                         memo1 := F_CONS( calist, obj_nil );
                         if memo.typ = nullty then memo := memo1
                                              else memo2.db^.cdr := memo1;
                         memo2 := memo1;
                         i := i - 1
                       end
                     end;

          l_buildq_fnc: begin
                       i := INTEVL( eflist );
                       eflist := F_CAR( eflist );
                       if i < 1 then i := 1;
                       memo := obj_nil;
                       while i > 0 do
                       begin
                         memo1 := F_CONS( F_EVAL( eflist ), obj_nil );
                         if memo.typ = nullty then memo := memo1
                                              else memo2.db^.cdr := memo1;
                         memo2 := memo1;
                         i := i - 1
                       end
                     end;

          l_free_fnc:begin { do as free all doublet of a list }
                       memo1 := GET_LIST( eflist, false );
                       i := INTEVLDEF( eflist, 1 );
                       FREE_A_LIST( memo1, i )
                     end;

          l_put_fnc: begin
                       calist := GET_ATOM( NXT_PAR( eflist ), true );
                       with calist.at^ do
                         val := F_CONS( F_EVAL( F_CAR( eflist ) ), val )
                     end;

          l_get_fnc: begin
                       calist := GET_ATOM( F_CAR( eflist ), true );
                       with calist.at^ do
                         if val.typ = doublety then
                         with val.db^ do
                         begin
                           memo  := car;     { Return the result object }
                           memo1 := val;     { Keep the doublet ref. to free it }
                           val   := cdr;     { Update the LIFO }
                           car := obj_nil;   { Supress all object reference }
                           cdr := dbl_free;  { Free the doublet }
                           dbl_free := memo1
                         end
                     end;

          l_eput_fnc: begin
                       memo  := GET_ATOM( NXT_PAR( eflist ), true );
                       memo1 := GET_LIST( eflist, false );
                       with memo.at^ do
                       begin
                         memo1.db^.cdr := val;
                         val := memo1
                       end
                     end;

          l_eget_fnc: begin
                       memo1 := GET_ATOM( F_CAR( eflist ), true );
                       with memo1.at^ do
                         if val.typ = doublety then
                         begin
                           memo := val;
                           val := memo.db^.cdr
                         end
                         else memo := obj_nil
                     end;

          l_exch_fnc: begin
                       memo1 := GET_ATOM( NXT_PAR( eflist ), true );
                       memo2 := GET_ATOM( NXT_PAR( eflist ), true );
                       i := INTEVLDEF( eflist, 1 );
                       memo := obj_nil;
                       with memo1.at^ do
                       while (val.typ = doublety) and (i > 0) do
                       begin
                         memo := val;
                         val := memo.db^.cdr;
                         memo.db^.cdr := memo2.at^.val;
                         memo2.at^.val := memo;
                         i := i - 1
                       end
                     end;

          q_get_fnc: begin
                       calist  := GET_LIST( eflist, true );
                       with calist.db^ do
                       if car.typ <> nullty then
                       begin
                         memo1 := cdr;           { Get the doublet to remove }
                         memo := memo1.db^.car;  { Return it's car }
                         cdr := cdr.db^.cdr;     { Remove doublet from the queue }
                         { Complet remove for the last element case }
                         if cdr.typ = nullty then car := obj_nil;
                         { Free the new unused doublet }
                         with memo1.db^ do
                         begin
                           car := obj_nil;
                           cdr := dbl_free
                         end;
                         dbl_free := memo1
                       end
                       else
                         memo := obj_nil
                     end;

          q_pop_fnc: begin
                       calist  := GET_LIST( eflist, true );
                       memo  := calist.db^.car;
                       if memo.typ = doublety then
                       begin
                         memo1 := obj_nil;
                         memo2 := calist.db^.cdr;
                         while (memo2.typ = doublety)
                           and (memo2.db <> memo.db) do
                         begin
                           memo1 := memo2;
                           memo2 := memo2.db^.cdr
                         end;
                         if memo2.db = memo.db then
                         begin
                           if memo1.typ = nullty then { First element to remove }
                             calist.db^.cdr := obj_nil
                           else
                             memo1.db^.cdr := obj_nil;
                           calist.db^.car := memo1; { Update the last link }
                           memo := memo2.db^.car;   { Get the object }
                           memo2.db^.car := obj_nil;
                           memo2.db^.cdr := dbl_free; { Free the doublet }
                           dbl_free := memo2
                         end
                         else memo := obj_nil
                       end
                     end;

          q_rem_fnc: begin
                       calist  := GET_LIST( eflist, true );
                       memo  := F_EVAL( F_CAR( eflist ) );
                       memo1 := obj_nil;
                       memo2 := calist.db^.cdr;
                       while (memo2.typ = doublety) and
                             not TEST_EQ( memo2.db^.car, memo ) do
                       begin
                         memo1 := memo2;
                         memo2 := memo2.db^.cdr
                       end;
                       if memo2.typ <> doublety then { End of queue reached }
                         memo := obj_nil
                       else
                       begin { The element to remove is founded }
                         if memo1.typ = nullty then { First element to remove }
                           calist.db^.cdr := memo2.db^.cdr
                         else
                           memo1.db^.cdr := memo2.db^.cdr;
                         if TEST_EQ( calist.db^.car, memo2 ) then { Last element remove }
                           calist.db^.car := memo1; { Update the last link }
                         memo2.db^.car := obj_nil;
                         memo2.db^.cdr := dbl_free; { Free the doublet }
                         dbl_free := memo2
                       end
                     end;

          q_put_fnc: begin
                       memo  := GET_LIST( eflist, true );
                       memo1 := F_EVAL( F_CAR( eflist ) );
                       with memo.db^ do
                       begin
                         memo2 := F_CONS( memo1, obj_nil );
                         { If the queue is empty }
                         if car.typ = nullty then
                           cdr := memo2  { Set the new entry as the last }
                         else            { ... else ... }
                           car.db^.cdr := memo2; { Link to the last }
                         car := memo2    { ... and set as new last }
                       end
                     end;

          q_insert_fnc: begin
                       memo  := GET_LIST( eflist, true );
                       memo1 := F_EVAL( NXT_PAR( eflist ) );
                       i     := INTEVLDEF( eflist, 0 );
                       with memo.db^ do
                         if (i <= 0) or (car.typ <> doublety) then
                         begin
                           cdr := F_CONS( memo1, cdr );
                           { If the queue is empty }
                           if car.typ <> doublety then
                             car := cdr { Set the new entry as the last }
                         end
                         else
                         begin
                           memo2 := memo;
                           while (i > 1) and (memo2.typ = doublety)
                                         and (memo2.db <> car.db) do
                           begin
                             i := i - 1; memo2 := memo2.db^.cdr
                           end;
                           memo2.db^.cdr := F_CONS( memo1, memo2.db^.cdr );
                           if TEST_EQ( memo2, car ) then car := memo2.db^.cdr
                         end
                     end;

          rplaca_fnc: begin
                       memo := GET_LIST( eflist, true );
                         memo.db^.car := F_EVAL( F_CAR( eflist ) )
                     end;

          rplacd_fnc:
                     begin
                       memo := GET_LIST( eflist, true );
                       memo.db^.cdr := F_EVAL( F_CAR( eflist ) )
                     end;

          displace_fnc:
                     begin
                       memo := GET_LIST( eflist, true );
                       calist := F_EVAL( F_CAR( eflist ) );
                       memo.db^ := calist.db^
                     end;

          nextl_fnc:
                     begin
                       calist := GET_ATOM( F_CAR( eflist ), true );
                       with calist.at^ do
                       begin
                         if val.typ <> nullty then
                           if val.typ <> doublety then
                             EXEC_ERROR( mdnam, 60, e_error )
                           else
                           begin
                             memo := val.db^.car; val := val.db^.cdr
                           end
                         else memo := obj_nil
                       end
                     end;

          incr_fnc,
          decr_fnc:  begin
                       memo1 := GET_ATOM( NXT_PAR( eflist ), true );
                       with memo1.at^ do
                       begin
                         if val.typ <> intty then
                           EXEC_ERROR( mdnam, 66, e_error );
                         if calist.typ = incr_fnc then val.int := val.int + 1
                                                  else val.int := val.int - 1;
                         memo := val
                       end
                     end;

          iadd_fnc:  { (+ ... ) }
                     begin
                       memo  := NUMEVL( eflist );
                       memo1 := NUMEVL( eflist );
                       if (memo.typ <> memo1.typ) or (memo.typ = flty) then
                       begin
                         memo.flt := FLTVAL( memo ) + FLTVAL( memo1 );
                         memo.typ := flty;
                         while eflist.typ <> nullty do
                           memo.flt := memo.flt + FLTEVL( eflist )
                       end
                       else
                       begin
                         memo.int := memo.int + memo1.int;
                         while eflist.typ <> nullty do
                           memo.int := memo.int + INTEVL( eflist )
                       end
                     end;

          isub_fnc:  { (- ... ) }
                     begin
                       memo  := NUMEVL( eflist );
                       memo1 := NUMEVL( eflist );
                       if (memo.typ <> memo1.typ) or (memo.typ = flty) then
                       begin
                         memo.flt := FLTVAL( memo ) - FLTVAL( memo1 );
                         memo.typ := flty;
                         while eflist.typ <> nullty do
                           memo.flt := memo.flt - FLTEVL( eflist )
                       end
                       else
                       begin
                         memo.int := memo.int - memo1.int;
                         while eflist.typ <> nullty do
                           memo.int := memo.int - INTEVL( eflist )
                       end
                     end;

          imul_fnc:  { (* ... ) }
                     begin         
                       memo := NUMEVL( eflist );
                       memo1 := NUMEVL( eflist );
                       if (memo.typ <> memo1.typ) or (memo.typ = flty) then
                       begin
                         memo.flt := FLTVAL( memo ) * FLTVAL( memo1 );
                         memo.typ := flty;
                         while eflist.typ <> nullty do
                           memo.flt := memo.flt * FLTEVL( eflist )
                       end
                       else
                       begin
                         memo.int := memo.int * memo1.int;
                         while eflist.typ <> nullty do
                           memo.int := memo.int * INTEVL( eflist )
                       end
                     end;


          idiv_fnc:  { (I_DIV ... ) }
                     begin
                       memo.typ := intty;
                       memo.int := INTEVL( eflist );
                       memo.int := memo.int div INTEVL( eflist )
                     end;

          irem_fnc:  { (REM ... ) }
                     begin         
                       memo.typ := intty;
                       memo.int := INTEVL( eflist );
                       memo.int := memo.int rem INTEVL( eflist )
                     end;

          imod_fnc:  { (MOD ... ) }
                     begin         
                       memo.typ := intty;
                       memo.int := INTEVL( eflist );
                       memo.int := memo.int mod INTEVL( eflist )
                     end;

          succ_fnc:  { (1+ ... ) }
                     begin
                       memo.typ := intty;
                       memo.int := INTEVL( eflist ) + 1
                     end;

          pred_fnc:  { (1- ... ) }
                     begin
                       memo.typ := intty;
                       memo.int := INTEVL( eflist ) - 1;
                     end;

          bit_and_fnc,
          bit_ash_fnc,
          bit_clear_fnc,
          bit_com_fnc,
          bit_lsh_fnc,
          bit_rot_fnc,
          bit_set_fnc,
          bit_test_fnc,
          bit_xor_fnc:   memo := BIT_FUNCTION( calist.typ, eflist );


          oddp_fnc:  memo := log_val[ ODD( INTEVL( eflist ) ) ];

          evenp_fnc: memo := log_val[ not ODD( INTEVL( eflist ) ) ];

          zerop_fnc: memo := log_val[ INTEVL( eflist ) = 0 ];

          iabs_fnc:  begin
                       memo := NUMEVL( eflist );
                       case memo.typ of
                         intty: memo.int := ABS( memo.int );
                         flty:  memo.flt := ABS( memo.flt );
                       otherwise
                         EXEC_ERROR( mdnam, 63, e_error )
                       end
                     end;

          ineg_fnc:  begin
                       memo := NUMEVL( eflist );
                       case memo.typ of
                         intty: memo.int := - memo.int ;
                         flty:  memo.flt := - memo.flt;
                       otherwise
                         EXEC_ERROR( mdnam, 63, e_error )
                       end
                     end;

          f_div_fnc: { (/ ... ) }
                     begin
                       memo.typ := flty;
                       memo.flt := FLTEVL( eflist );
                       memo.flt := memo.flt / FLTEVL( eflist );
                       while eflist.typ <> nullty do
                         memo.flt := memo.flt / FLTEVL( eflist )
                     end;

          ipow_fnc:  { (** ...) }
                     begin
                       memo := NUMEVL( eflist );
                       eflist := NUMEVL( eflist );
                       if (memo.typ = intty) and (eflist.typ = intty) then
                         memo.int := memo.int**eflist.int
                       else
                       begin
                         if memo.typ = intty then
                         begin
                           memo.flt := memo.int; memo.typ := flty
                         end;
                         if eflist.typ = intty then
                           memo.flt := memo.flt**eflist.int
                         else
                           memo.flt := EXP( eflist.flt * LN( memo.flt ) )
                       end
                     end;

          f_exp_fnc: begin
                       memo.flt := EXP( FLTEVL( eflist ) );
                       memo.typ := flty
                     end;

          f_log_fnc: begin
                       memo.flt := LN( FLTEVL( eflist ) );
                       memo.typ := flty
                     end;

          f_sqrt_fnc: begin
                       memo.flt := SQRT( FLTEVL( eflist ) );
                       memo.typ := flty
                     end;

          f_sin_fnc: begin
                       memo.flt := SIN( FLTEVL( eflist ) );
                       memo.typ := flty
                     end;

         f_sind_fnc: begin
                       memo.flt := SIN( inrd*FLTEVL( eflist ) );
                       memo.typ := flty
                     end;

          f_cos_fnc: begin
                       memo.flt := COS( FLTEVL( eflist ) );
                       memo.typ := flty
                     end;

         f_cosd_fnc: begin
                       memo.flt := COS( inrd*FLTEVL( eflist ) );
                       memo.typ := flty
                     end;

          f_tan_fnc: begin
                       memo.flt := TAN( FLTEVL( eflist ) );
                       memo.typ := flty
                     end;

         f_tand_fnc: begin
                       memo.flt := TAN( inrd*FLTEVL( eflist ) );
                       memo.typ := flty
                     end;

          f_asin_fnc: begin
                       memo.flt := ARCSIN( FLTEVL( eflist ) );
                       memo.typ := flty
                     end;

         f_asind_fnc: begin
                       memo.flt := ARCSIN( FLTEVL( eflist ) )/inrd;
                       memo.typ := flty
                     end;

          f_acos_fnc: begin
                       memo.flt := ARCCOS( FLTEVL( eflist ) );
                       memo.typ := flty
                     end;

         f_acosd_fnc: begin
                       memo.flt := ARCCOS( FLTEVL( eflist ) )/inrd;
                       memo.typ := flty
                     end;

          f_atan_fnc: begin
                       memo.flt := ARCTAN( FLTEVL( eflist ) );
                       memo.typ := flty
                     end;

         f_atand_fnc: begin
                       memo.flt := ARCTAN( FLTEVL( eflist ) )/inrd;
                       memo.typ := flty
                     end;

        f_phase_fnc: begin
                       memo.flt := FLTEVL( eflist );
                       memo.flt := ARCTAN( memo.flt, FLTEVL( eflist ) );
                       memo.typ := flty
                     end;

       f_phased_fnc: begin
                       memo.flt := FLTEVL( eflist );
                       memo.flt := ARCTAN( memo.flt, FLTEVL( eflist ) )/inrd;
                       memo.typ := flty
                     end;

         f_sinh_fnc: begin
                       memo.typ := flty;
                       memo.flt := SINH( FLTEVL( eflist ) )
                     end;

         f_cosh_fnc: begin
                       memo.typ := flty;
                       memo.flt := COSH( FLTEVL( eflist ) )
                     end;

         f_tanh_fnc: begin
                       memo.typ := flty;
                       memo.flt := TANH( FLTEVL( eflist ) )
                     end;

         f_asinh_fnc: begin
                       memo.typ := flty;
                       memo.flt := ARGSINH( FLTEVL( eflist ) )
                     end;

         f_acosh_fnc: begin
                       memo.typ := flty;
                       memo.flt := ARGCOSH( FLTEVL( eflist ) )
                     end;

         f_atanh_fnc: begin
                       memo.typ := flty;
                       memo.flt := ARGTANH( FLTEVL( eflist ) )
                     end;

        f_bess1_fnc: memo := MTH_L_BESSELJ( eflist );

        f_gamma_fnc: memo := MTH_L_GAMMA( eflist );

     f_interpol_fnc: memo := MTH_L_INTERPOL( eflist );

       f_integr_fnc: memo := MTH_L_GAUSS_INTEGR( eflist );

      f_int_tab_fnc: memo := MTH_L_GAUSS_INTEGR_BLDTAB( eflist );

         f_summ_fnc: begin
                       memo1 := GET_ATOM( NXT_PAR( eflist ), true );
                       with memo1.at^ do
                       begin
                         calist.flt := FLTEVL( eflist ); { get the start value }
                         val.typ   := flty; memo.typ := flty;
                         memo.flt  := FLTEVL( eflist ); { get the end value }
                         memo2.flt := FLTEVL( eflist ); { get the step }
                         eflist    := NXT_PAR( eflist ); { get the expression }
                         i := ROUND( (memo.flt - calist.flt)/memo2.flt );
                         memo.flt := 0.0;
                         for j := 0 to i do
                         begin
                           val.flt := calist.flt + j * memo2.flt;
                           memo.flt := memo.flt + FLTVAL( F_EVAL( eflist ) )
                         end
                       end
                     end;


        f_float_fnc: begin
                         memo.flt := FLTEVL( eflist );
                         memo.typ := flty
                     end;

        f_round_fnc: begin
                       memo.int := ROUND( FLTEVL( eflist ) );
                       memo.typ := intty
                     end;

        f_trunc_fnc: begin
                       memo.int := TRUNC( FLTEVL( eflist ) );
                       memo.typ := intty
                     end;

          ilt_fnc,
          ile_fnc,
          igt_fnc,
          ige_fnc,
          ieq_fnc,
          ine_fnc: begin
                     memo.typ := intty;
                     memo1 := F_EVAL( NXT_PAR( eflist ) );
                     memo2 := F_EVAL( NXT_PAR( eflist ) );
                     case memo1.typ of
                       nullty, truety:
                         case memo2.typ of
                           nullty: memo.int :=   ORD( memo1.typ = truety );
                           truety: memo.int := - ORD( memo1.typ = nullty );

                           intub, intsb, intuw, intsw, charty,
                           intty:
                             memo.int := INTVAL( memo1 ) - memo2.int;

                           sflty,
                           flty: memo.int := FLOAT_MATCH_VAL( memo1, memo2 )

                         otherwise
                           EXEC_ERROR( mdnam, 64, e_error )
                         end;

                       intub, intsb, intuw, intsw,
                       intty:
                         case memo2.typ of
                           nullty, truety:
                             memo.int := memo1.int - INTVAL( memo2 );

                           intub, intsb, intuw, intsw,
                           intty: memo.int := memo1.int - memo2.int;

                           sflty,
                           flty:  memo.int := FLOAT_MATCH_VAL( memo1, memo2 );

                           charty, strty:
                             memo.int := STRING_MATCH( memo1, memo2 );

                         otherwise
                           EXEC_ERROR( mdnam, 64, e_error )
                         end;

                       sflty,
                       flty:
                         case memo.typ of
                           nullty, truety, intub, intsb, intuw, intsw, intty,
                           sflty, flty:
                             memo.int := FLOAT_MATCH_VAL( memo1, memo2 );

                           charty, strty:
                             memo.int := STRING_MATCH( memo1, memo2 );

                         otherwise
                           EXEC_ERROR( mdnam, 64, e_error )
                         end;
                     
                       charty:memo.int := ORD( memo1.ch ) - ORD( memo2.ch );

                       strty: memo.int := STRING_MATCH( memo1, memo2 );

                     otherwise
                       EXEC_ERROR( mdnam, 65, e_error )
                     end;
                     case calist.typ of
                       ilt_fnc: flg := memo.int < 0;
                       ile_fnc: flg := memo.int <= 0;
                       igt_fnc: flg := memo.int > 0;
                       ige_fnc: flg := memo.int >= 0;
                       ieq_fnc: flg := memo.int = 0;
                       ine_fnc: flg := memo.int <> 0
                     end;
                     memo := log_val[flg]
                   end;

          v_case_fnc: begin
                     { Get the vector address }
                     calist := F_EVAL( NXT_PAR( eflist ) );
                     if calist.typ = vectortyp then
                     begin
                       i := INTEVL( eflist );         { Get the index }
                       i := i - INTEVL( eflist );     { Substract the min }
                       eflist := F_CAR( eflist );     { Get the otherwise }
                       if calist.vect <> nil then
                       with calist.vect^ do
                         if (i >= 0) and (i < vect_size) then
                           memo := vect_tab[i]
                         else
                           memo := eflist
                       else memo := eflist;
                       memo := F_EVAL( memo )
                     end
                     else
                       EXEC_ERROR( mdnam, 81, e_error )
                   end;

          v_create_fnc: begin
                     i := INTEVL( eflist );
                     calist := F_EVAL( NXT_PAR( eflist ) );
                     memo := VECTOR_ALLOC( i, eflist.typ <> doublety );
                     if (eflist.typ = doublety) and (memo.vect <> nil) then
                     with memo.vect^ do
                     begin
                       eflist := F_EVAL( NXT_PAR( eflist ) );
                       for j := 0 to i - 1 do
                       begin
                         vect_tab[j] := NXT_PAR( calist );
                         if vect_tab[j].typ = nullty then
                           vect_tab[j] := eflist { set default value }
                       end
                     end
                   end;

          v_gcase_fnc: memo := GEN_VECT_CASE( obj );

          v_index_fnc: begin
                     { Get the vector address }
                     calist := F_EVAL( NXT_PAR( eflist ) );
                     if calist.typ = vectortyp then
                     begin
                       i := INTEVL( eflist );         { Get the index }
                       eflist := NXT_PAR( eflist );   { Get the otherwise }
                       if calist.vect <> nil then
                       with calist.vect^ do
                         if (i >= 0) and (i < vect_size) then
                           memo := vect_tab[i]
                         else
                           memo := eflist
                       else memo := eflist
                     end
                     else
                       EXEC_ERROR( mdnam, 81, e_error )
                   end;

          v_store_fnc: begin
                     { Get the vector address }
                     calist := F_EVAL( NXT_PAR( eflist ) );
                     if calist.typ = vectortyp then
                     begin
                       i := INTEVL( eflist );         { Get the index }
                       if calist.vect <> nil then
                       with calist.vect^ do
                         if (i >= 0) and (i < vect_size) then
                         begin
                           vect_tab[i] := F_EVAL( NXT_PAR( eflist ) );
                           memo := obj_true
                         end
                         else
                           memo := obj_nil
                       else memo := obj_nil
                     end
                     else
                       EXEC_ERROR( mdnam, 81, e_error )
                   end;

          r_define_fnc:   memo := REC_DEFINE_TYPE( eflist );
          r_fieldset_fnc: REC_FIELD_SET( eflist );
          r_init_fnc:     memo := REC_INITIALIZE( eflist );
          r_new_fnc:      memo := REC_NEW( eflist );
          r_free_fnc:     REC_FREE( eflist );
          r_allocate_fnc: memo := REC_ALLOCATE( eflist );
          r_destroy_fnc:  REC_DESTROY( eflist );
          r_store_fnc:    REC_STORE( eflist );


          char_fnc: begin
                     memo.typ := charty;
                     memo.int := INTEVL( eflist );
                     if (memo.int > 255) or (memo.int < 0) then
                       EXEC_ERROR( mdnam, 67, e_error )
                     else memo.ch := CHR( memo.int )
                   end;

          chord_fnc: begin
                     memo.typ := intty;
                     memo.int := ORD( GET_CHAR( F_EVAL( F_CAR( eflist ) ) ) )
                   end;

          alginput_fnc:    memo := ALG_INP_SETUP( eflist );

          alginit_fnc:     memo := ALG_INIT( eflist );

          algread_fnc:     memo := ALG_READ;

          algtolisp_fnc:   memo := ALG_TO_LISP( eflist );


          open_fnc:   memo := F_OPEN( eflist );

          close_fnc:  memo := F_CLOSE( F_EVAL( F_CAR( eflist ) ) );

          input_fnc:  memo := F_INPUT( eflist );

          output_fnc: memo := F_OUTPUT( eflist );

          get_fnc: memo := F_GET_BIN( eflist );

          put_fnc: memo := F_PUT_BIN( eflist );


          prinhd_fnc: memo := F_SET_OUT_HEAD( eflist );

          readch_fnc,
          peekch_fnc: begin
                    memo.typ := charty; memo.ch := sy_ch;
                    if calist.typ = readch_fnc then NEXT_CH
                  end;

          kind_fnc:  memo := LISP_KIND( F_EVAL( F_CAR( eflist ) ) );

          read_fnc:  memo := F_READ;  { (READ ... ) }

          zapline_fnc: memo := F_ZAPLINE;

          princh_fnc: begin
                        memo := F_EVAL( NXT_PAR( eflist ) );
                        calist.int := INTEVLDEF( eflist, 1 );
                        memo := F_PRINTCH( memo, calist.int )
                      end;

          terpri_fnc: memo := F_TERPRI( eflist );

          prinflush_fnc,{ same that prin because flush is du to read (pascal) }

          prin_fnc:   memo := F_PRINT( eflist, false ); { (PRINFLUSH ... ) }

          print_fnc:  memo := F_PRINT( eflist, true );  { (PRINT ... ) }

          i_string_fnc: memo := F_STRING_INP( eflist );

          format_inp_fnc: memo := F_INP_FORMAT( eflist );

          format_out_fnc: memo := F_OUT_FORMAT( eflist );

          def_lis_array_fnc: memo := F_DEF_LIS_ARRAY( eflist );

          set_lis_array_fnc: memo := F_SET_LIS_ARRAY( eflist );

          r_read_fnc:   memo := F_READ_AREA( eflist );

          r_write_fnc:  F_WRITE_AREA( eflist );

          oblist_fnc:   memo := F_OBLIST( eflist );

          fexit_fnc: begin { Exit from current function }
                       fnc_result := F_EVAL( NXT_PAR( eflist ) );
                       if stop_reg.typ = nullty then
                         stop_reg.typ := fexit_fnc { Set the stop register }
                     end;

          exit_fnc:  begin { exit from user program }
                       memo := F_PRINT( eflist, true );
                       { select terminal output }
                       memo := F_OUTPUT( obj_nil );
                       recurs_nb := 0;          { Reset trace flag }
                       eval_ninc := 0;          { Reset exec trace level }
                       calist := F_EVAL( F_CAR( eflist ) );
                       if calist.typ = nullty then goto ERR_CONT
                                              else goto ERR_STOP
                     end;

          dpflg_fnc: begin
                       memo := F_EVAL( NXT_PAR( eflist ) );
                       if eflist.typ = nullty then
                         memo := log_val[dp_ref_flg in memo.flg.f]
                       else
                         if GET_EVLFLAG( eflist ) then
                           memo.flg.f := memo.flg.f + [dp_ref_flg]
                         else
                           memo.flg.f := memo.flg.f - [dp_ref_flg]
                     end;

          intty:       memo := F_SYS_CALL( obj );    { Impl. Call Application }
          syscall_fnc: memo := F_SYS_CALL( eflist ); { Call Application }

          on_error_fnc: memo := F_ON_EVENT( eflist ); { on directive }

          printerr_fnc: memo := PRT_ERROR( eflist );

          include_fnc,
          chaine_fnc: memo := F_INCLUDE( eflist, (calist.typ = include_fnc ), false );

          includerr_fnc,
          chainerr_fnc: memo := F_INCLUDE( eflist, (calist.typ = include_fnc ), true );

          listing_fnc: memo := F_LISTING( eflist );

          eof_fnc:    memo := F_EOF( eflist );

          eoln_fnc:   memo := F_EOLN( eflist );

          pragma_fnc: memo := F_PRAGMA( eflist, src_control ); { pragma setting }

          id_define_fnc: memo := F_ID_DEFINE( eflist );

          id_refer_fnc: memo := F_ID_REFER( eflist );

          id_purge_fnc: memo := F_ID_PURGE( eflist );


        otherwise
           memo := obj_empty;
           EXEC_ERROR( mdnam, 99, e_severe );
        end
      end
  otherwise
    memo := obj.at^.val
  end { case };
  if opt_debug then
  begin
    if opt_exectrace then F_TRACE_EXEC1( memo );
    if step then exception_step := true
  end;
  if stop_reg.typ = truety then
  begin { exception detected }
    stop_reg := obj_nil;  { clear exception condition flag }
    memo := F_EXEC_ERROR( 'TRAP', condition_error, condition_sev )
  end;
  curr_point := save_point; { restore the last current statement pointer }
  F_EVAL := memo
end F_EVAL;


begin { LISP main }
  ESTABLISH( CONDITION_HANDLER );  { Establish the LISP condition handler }
  LISP_INIT;                       { Init LISP }

ERR_CONT:                          { Continue on error label }
  if not emergency_stop then       { If init is ok }
  begin
    src_control^.src_insnb := 0;   { Release the nested list level }
    repeat
      main_statement := F_READ;    { Read a LISP Expression and Evaluate it }
      interp := F_EVAL( main_statement );
      if opt_result and not (invalid_flg in interp.flg.f) then
      begin
        LST_PUT_CHAR( '=' );
        nctobj := 0;               { Release the object count }
        OUT_OBJECT( interp );      { Output the result }
        LST_EOLN
      end
    until (interp.typ = eof_seen) or emergency_stop;  { ... and loop until eof or fatal error }
  end;

ERR_STOP:
  F_CLOSE_ALL;
  LST_CLOSE( lst_current, true )
end E_LISP.
{  * * * *   End of E-LISP Main Program File   * * * *  }