{
*************************************************************************
*                                                                       *
*                                                                       *
*                                                                       *
*                                                                       *
*          * * *    L I S P    I n t e r p r e t e r    * * *           *
*                                                                       *
*                                                                       *
*     * * *    L I S P    D r a w i n g   I n t e r f a c e   * * *     *
*                                                                       *
*       by :                                                            *
*                                                                       *
*           P. Wolfers                                                  *
*               c.n.r.s.,                                               *
*               Laboratoire de Cristallographie,                        *
*               B.P.  166 X   38042  Grenoble Cedex,                    *
*                                              FRANCE.                  *
*                                                                       *
*                                                                       *
*                                                                       *
*                                                                       *
*************************************************************************


/////////////////////////////////////////////////////////////////////////
//                                                                     //
//                                                                     //
//                  Global Public Licence (GPL)                        //
//                                                                     //
//                                                                     //
// This license described in this file overrides all other licenses    //
// that might be specified in other files for this library.            //
//                                                                     //
// This library is free software; you can redistribute it and/or       //
// modify it under the terms of the GNU Lesser General Public          //
// License as published by the Free Software Foundation; either        //
// version 2.1 of the License, or (at your option) any later version.  //
//                                                                     //
// This library is distributed in the hope that it will be useful,     //
// but WITHOUT ANY WARRANTY; without even the implied warranty of      //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU   //
// Library General Public License for more details.                    //
//                                                                     //
// You should have received a copy of the GNU Lesser General Public    //
// License along with this library (see COPYING.LIB); if not, write to //
// the Free Software Foundation :                                      //
//                      Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  //
//                                                                     //
/////////////////////////////////////////////////////////////////////////
}


{  Version 1.2-B (or Upper)  of  E - L I S P     System  }
{***********    CPAS  Version   **************}



{*********************************************************}
{**** small LISP routines to handle the LISP elements ****}
{*********************************************************}

module LISP_IO( Input, Output ); { Input and Output for User Terminal }


%include 'lispsrc:lisp_env';  { Get the Lisp Environment Definitions }






     {************************************}
     { Title Listing of source management }
     {************************************}




type
  cvsz = record case boolean of
    false: (siz: integer);
    true:  (sz1, sz2: char)
  end;




procedure COMPILE_SET_TITLE;
var
  st: string( 255 );

begin 
  { Create a title string - temporary }
  with lst_current^ do
  begin
    if lst_title <> nil then DISPOSE( lst_title );
    st := FILE_SPECIFICATION( src_control^.src_file );
    if st.length = 0 then st := 'TT:';
    st := def_title||st||'".';
    NEW( lst_title, st.length );
    lst_title^ := st
  end
end COMPILE_SET_TITLE;






         {******************************************}
         { *** Input procedures/functions group *** }
         {******************************************}




function FLG_EOF: boolean;
var
   src_p: src_ptr;
   b:     boolean;

begin { FLG_EOF }
  with src_control^ do
  begin
    b := true; { Assume input stream continue on another file }
    if src_previous <> nil then
    begin { Return to a previous source file }
      src_p := src_control; src_control := src_p^.src_previous;
      main_src := src_control;
      SRC_CLOSE( src_p, true );  { Close and Elliminate old src context }
      sy_ch := eol;
      COMPILE_SET_TITLE
    end
    else b := false { we must send a final end of stream }
  end;
  sys_read_deep.at^.val.int := src_control^.src_level;
  FLG_EOF := b
end FLG_EOF;



procedure LISP_BREAKOUTPUT;
{ Procedure to perform a terminal output without eoln. }
var
  lst_save: lst_ptr;

begin
  lst_save    := lst_current;
  lst_current := sy_lstbreak;
  LST_BREAKOUTPUT;
  lst_current := lst_save;
  sy_lstbreak := nil
end LISP_BREAKOUTPUT;



[global]
procedure NEXT_CH;
begin { NEXT_CH }
  if sy_lstbreak <> nil then LISP_BREAKOUTPUT;
  if sy_ch_break then
  begin
    sy_ch := src_control^.src_lastchar;
    sy_ch_break := false
  end
  else
    sy_ch := SRC_INCHAR;
  if sy_ch = eos then
  begin
    sys_eoln.at^.val := obj_eof;
    sys_eof.at^.val  := obj_eof;
    { Set the User Opened File Mode for the Files }
    if not (src_bmacroex in src_control^.src_flags) then
      { We have not a LISP management for EOF on user OPENED file }
      if FLG_EOF then sy_ch := ' ' { Ignore any intermediary eof }
  end
  else
    if sy_ch = eol then
    begin
      sys_eoln.at^.val := obj_eoln;
      sys_eof.at^.val  := obj_nil
    end
    else
    begin
      sys_eoln.at^.val := obj_nil;
      sys_eof.at^.val  := obj_nil
    end;

  sy_cmaj := sy_ch;
  if (sy_ch >= '!') and (sy_ch <= '~') then
    if alt_mac_tab_flag then
      sym := alt_mtb[sy_ch]
    else
      sym := mac_tab[sy_ch]
  else sym := obj_nil;
  if (sy_ch >= 'a') and (sy_ch <= 'z') then
    sy_cmaj := CHR( ORD( sy_ch ) - 32 );
end NEXT_CH;



[global]
function F_READCH( binch: boolean ): obj_ref;
var
  ob: obj_ref;

begin
  ob.flg := flg_def;
  ob.typ := charty;
  ob.ch  := sy_ch;
  if binch then NEXT_CH;
  F_READCH := ob
end F_READCH;



[global]
procedure SKIP_SPACE;
begin
  while sy_ch = ' ' do NEXT_CH;
  with src_control^ do  src_wchpt := src_chidx
end SKIP_SPACE;



[global]
procedure SKIP_EOLN_AND_SPACE;
begin
  if sy_ch = eol then
    while (sy_ch = eol) or (sy_ch = ' ') do  NEXT_CH
  else
    while sy_ch = ' ' do NEXT_CH;
  with src_control^ do  src_wchpt := src_chidx
end SKIP_EOLN_AND_SPACE;



procedure SKIP_TO_SEP( sep: obj_type );
begin
  while (sym.typ <> sep) and (sy_ch <> eos) do NEXT_CH
end SKIP_TO_SEP;



[global]
function F_ZAPLINE: obj_ref;
begin
  { Read Until to find the End Of Line }
  while (sy_ch <> eos) and (sy_ch <> eol) do NEXT_CH;
  F_ZAPLINE := log_val[ sy_ch = eos ]
end F_ZAPLINE;



[global]
function IN_ATOM( lim, defbase: integer; signed_flg: boolean ): obj_ref;
const
  mdnam = 'RATM';
  intmin = (- maxint) - 1; intmax = maxint;
  expmax = 308;     (*** VAX/VMS ***)

type
  ty_num = ( nb_ini, nb_dot,  nb_twdot,
             nb_ent, nb_base, nb_digit, nb_frac, nb_exp, nb_sexp,
             no_nb);

var
  st_num: ty_num;
  object:                           obj_ref;
  base, ivl, idig:                  integer;
  rfac, rval:                       lisp_real;
  expsgn, bbase, bstop, berr, bneg: boolean;

begin { IN_ATOM }
  if lim >= 0 then
  begin
    if lim = 0 then lim := -1;
    while (sy_ch = ' ') and (lim <> 0) do
    begin
      NEXT_CH;
      if lim > 0 then lim := lim - 1
    end
  end
  else lim := -1;
  if lim = 0 then
  begin
    object.typ := intty; object.int := 0
  end
  else
  with sy_string do
  begin { It is a Real Atome }
    object.flg := flg_def;
    object.typ := atomety; { until showed otherwise }
    berr := false; bstop := false;
    length := 0; base := defbase; bbase := (base <> 10);
    { Assume Positive Integer Until showed otherwise }
    bneg := false; rval := 0.0; rfac := double( 1.0 )/base; ivl := 0;
    st_num := nb_ini;
    expsgn := false;
    repeat
      { Stop on any Macro Character }
      if sym.typ <> nullty then
      begin 
        bstop := true; { Assumed Until Shown Otherwise }
        if signed_flg and ((sy_ch = '-') or (sy_ch = '+')) then bstop := false
      end;
      if not bstop then
      begin
        case sy_cmaj of

          eos,  { end of file seen }
          eol,  { end of line seen }
          ' ':  { space seen }       bstop := true;

          '#':  { base specification }
            case st_num of
              nb_ini:  begin
                         bbase := true; base := 10;
                         st_num := nb_base
                       end;
              nb_base: if (ivl > 1) and (ivl <= 16) then
                       begin { end of base specification }
                         base   := ivl;
                         ivl    := 0;
                         rfac   := double( 1.0 )/base;
                         st_num := nb_ent
                       end
                       else
                       begin { Illegal base }
                         base := defbase;
                         berr := true
                       end;
            otherwise
              base := defbase;
              if lim >= 0 then lim := -2
              else
                if (st_num = nb_digit) and (length = 1) then
                  bstop := true
                else
                  st_num := no_nb
            end;

          '0','1','2','3','4','5','6','7','8','9',
          'A','B','C','D','F':
            begin
              if sy_cmaj >= 'A' then
                idig := ORD( sy_cmaj ) - ORD( 'A' ) + 10
              else
                idig := ORD( sy_cmaj ) - ORD( '0' );
              if (idig >= base) and (st_num <> nb_base) then
                if lim >= 0 then lim := -2
                else
                  if st_num = nb_dot then
                    bstop := true
                  else
                    st_num := no_nb
              else
              case st_num of
                nb_ini:
                  begin
                    st_num := nb_ent;
                    rval := rval*base + idig
                  end;
                nb_ent:  rval := rval*base + idig;
                nb_digit, nb_frac:
                  begin
                    st_num := nb_frac;
                    rval := rval + idig*rfac;
                    rfac := rfac/base
                  end;
                nb_base, nb_exp, nb_sexp:
                  ivl := ivl*base + idig;
                nb_dot: { begin of number by "." }
                  begin
                    st_num := nb_frac;
                    rval := idig*rfac;
                    rfac := rfac/base
                  end;
              otherwise
              end
            end;

          '+','-':
            case st_num of
              nb_ini:  bneg := (sy_cmaj = '-');
              nb_exp:  begin { floatting number (sign of exponent) }
                         st_num := nb_sexp;
                         if sy_cmaj = '-' then  rfac := 1.0/base
                       end;
            otherwise
              if lim >= 0 then lim := -2
              else
                if (st_num = nb_digit) and (length = 1) then
                  bstop := true
                else
                  st_num := no_nb;
            end;

          '.':
            case st_num of
              nb_ini:
                if lim >= 0 then
                  st_num := nb_digit  { Formatted Read "." => 0. or 0 .. }
                else
                  st_num := nb_dot;   { Unformatted Read "." => Dot Atom . }
              nb_dot: st_num := nb_twdot; { Two Dot ("..") Atom }
              nb_ent: st_num := nb_digit;
              nb_digit: if length > 1 then
                begin { .. after an integer }
                  { Return of one Character beside }
                  with src_control^ do
                    src_chidx := PRED( src_chidx );
                  st_num := nb_ent;   { Reset Integer Mode }
                  bstop := true
                end
                else { Two successive period }
                  st_num := nb_twdot;
            otherwise
              bstop := true
            end;

          'E':
            if (length <> 0) or (bbase and (base >= 15))  then
              case st_num of
                nb_dot: bstop := true;
                nb_ini,
                nb_ent,
                nb_digit,
                nb_frac:
                  if bbase and (base >= 15) then
                    if st_num = nb_ent then
                      rval := rval*base + 14.0
                    else
                    begin
                      rval := rval + 14.0*rfac;
                      rfac := rfac/base
                    end
                  else
                  begin
                    st_num := nb_exp;
                    expsgn := true;
                    ivl := 0;
                    rfac := base
                  end;
              otherwise
                if lim >= 0 then lim := -2
                else
                  if (st_num = nb_digit) and (length = 1) then
                    bstop := true
                  else
                    st_num := no_nb
              end
            else
              if lim >= 0 then lim := -2
              else
                if (st_num = nb_digit) and (length = 1) then
                  bstop := true
                else
                  st_num := no_nb;


        otherwise
          if lim >= 0 then lim := -2
          else
            if ((st_num = nb_digit) or (st_num = nb_dot)) and (length = 1) then
              bstop := true
            else
              st_num := no_nb
        end;
        if lim = -2 then bstop := true;
        if not bstop then
        begin
          if length < capacity then
          begin
            length := length + 1;
            body[length] := sy_cmaj
          end else berr := true;
          NEXT_CH;
          if expsgn  then
          begin
            if (sy_cmaj = '-') or (sy_cmaj = '+') then sym := obj_nil;
            expsgn := false
          end;
          if lim > 0 then lim := lim - 1;
          bstop := (st_num = nb_twdot) or (lim = 0)
        end
      end
    until bstop;
    if berr then SRC_ERROR( mdnam, 2, e_error );

    while (lim > 0) and (sy_ch = ' ') do
    begin
      lim := lim - 1;
      NEXT_CH
    end;

    { Set the correct reference }
    if length = 1 then
      if (body[1] = '+') or (body[1] = '-') or (body[1] = '.') then
        st_num := no_nb;

    case st_num of
      nb_ent:
        begin
          if bneg then rval := - rval;
          if (rval>= intmin) and (rval <= intmax) then
          begin
            object.typ := intty; object.int := ROUND( rval )
          end
          else
          begin
            object.typ := flty; object.flt := rval
          end
        end;
      nb_digit,
      nb_frac:
        begin
          if bneg then rval := - rval;
          object.typ := flty; object.flt := rval
        end;

      nb_exp, nb_sexp:
        begin
          if ABS( ivl ) > expmax then
          begin
            ivl := 0; SRC_ERROR( mdnam, 4, e_severe )
          end;
          while ivl > 0 do
          begin
            if ODD( ivl ) then
            begin
              rval := rval * rfac; ivl := ivl - 1
            end
            else
            begin
              rfac := SQR( rfac ); ivl := ivl div 2
            end
          end;
          if bneg then rval := - rval;
          object.typ := flty; object.flt := rval
        end;

    otherwise { it is not a number, we search from known symbol }
      object := ATOM_SEARCH( sy_string )
    end { case st_num of }
  end;
  IN_ATOM := object
end IN_ATOM;



function IN_LIST( per_flg: boolean ): obj_ref;
const
  mdnam = 'INLI';

var
  prv_build_list,
  prv_build_flag,
  p, p1, p2, at: obj_ref;

begin { IN_LIST }
  prv_build_list := sys_build_list.at^.val;
  prv_build_flag := sys_build_list.at^.plist;

  p := obj_nil; { Assume NIL Object }
  p1 := p;
  with src_control^ do       { Increment the Nest Level Display }
    src_insnb := src_insnb + 1;
  SKIP_EOLN_AND_SPACE;
  if (sym.typ <> last_fnc) and (sy_ch <> eos) then
  begin
    if not per_flg then      { If period is not allowed }
      while sy_ch = '.' do
      begin
        SRC_ERROR( mdnam, 5, e_error ); NEXT_CH; { Skip it }
        SKIP_SPACE
      end;

    p := DOUBLET_ALLOC;      { Allocate the first doublet }
    sys_build_list.at^.val   := p;       { Set the building list reference }
    sys_build_list.at^.plist := obj_zero;{ Clear the building list flag }
    at := F_READ;            { Get the first atome }

    p.db^.car := at;         { Set it's car as the last read object }

    p2 := p;                 { It is the last allocated for below ... }
    SKIP_EOLN_AND_SPACE;     { ... and skip all trailing space(s) }
    while (sy_ch <> eos) and (sy_ch <> '.') and (sym.typ <> last_fnc) do
    begin
      p1 := DOUBLET_ALLOC;   { Allocate an object }
      sys_build_list.at^.val := p1;  { Set the current list reference }
      at := F_READ;          { Get the object and link it by the car }
      p2.db^.cdr := p1;      { Link the next list element by the cdr obj_ref }
      p2 := p1;              { Set the pointer of the previous list object }
      p1.db^.car := at;      { Get the object and link it by the car }
      SKIP_EOLN_AND_SPACE    { Skip any trailing space(s) }
    end;

    if sy_ch = '.' then
    begin
      NEXT_CH; { Gobble up the period }
      sys_build_list.at^.plist := obj_one; { Signal the cdr assignement }
      p2.db^.cdr := F_READ;                { Get the cdr object }
      SKIP_EOLN_AND_SPACE;                 { Skip any trailing space(s) }
      sys_build_list.at^.plist := obj_zero { Release the cdr assignement flag }
    end
    else
      if sy_ch = eos then SRC_ERROR( mdnam, 6, e_severe )
  end;
  with src_control^ do { Decrement the Nest Level Display }
    src_insnb := src_insnb - 1;
  sys_build_list.at^.val   := prv_build_list;
  sys_build_list.at^.plist := prv_build_flag;
  IN_LIST := p
end IN_LIST;



[global]
function LISP_KIND( obj: obj_ref ): obj_ref;
var
  res: obj_ref;

begin
  res := obj_zero;
  case obj.typ of
    doublety:  res.int :=  0;  { Code for list }
    atomety: if obj.at^.fncref.typ = doublety then
               res.int :=  2   { Code for atom defined as user function }
             else
               res.int :=  1;  { Code for atom }
    nullty:    res.int :=  4;  { Code for nil }
    truety:    res.int :=  5;  { Code value for true }
    intty:     res.int :=  6;  { Code for integer }
    sflty,
    flty:      res.int :=  7;  { Code for floatting number }
    charty:    res.int :=  8;  { Code for character }
    strty:     res.int :=  9;  { Code for string }
    vectortyp: res.int := 10;  { Lisp vector }
    areatyp,
    areatyp1:  res.int := 11;  { Area code }
    lextyp:    res.int := 12;  { Lex reference code }
    eoln_seen: res.int := -2;  { End of line }
    eof_seen:  res.int := -3;  { End of file }
  otherwise
    if obj.typ > atomety then  { Standard function }
      res.int := 3
    else
      res.int := -1;           { Other code }
  end;
  LISP_KIND := res
end LISP_KIND;



[global]
function F_READ: obj_ref;
const
  mdnam = 'READ';

var
  object, sav0, sav1: obj_ref;
  commod: src_comty;
  ch: char;
  i: integer;
  berr, bstop: boolean;

begin { F_READ }
  object := obj_empty;
  und_atom.at^.val := obj_nil;

  repeat
    SKIP_EOLN_AND_SPACE;
    { Stop on any macro character }
    if sym.typ <> nullty then
    begin
      case sym.typ of
        doublety:
          begin { Defined Macro Character }
            object := sym;   { To save the current sym }
            NEXT_CH;         { Gobble up the macro character }
            if object.db^.cdr.typ = doublety then
              object := F_LET( object, false )
            else
            begin
              object := object.db^.car;
              if object.typ = doublety then
              begin
                sav0 := object;
                while sav0.typ = doublety do
                begin
                  object := NXT_PAR( sav0 ); { get the value to return }
                  if sy_ch = GET_CHA( sav0, CHR( 0 ) ) then
                  begin { if second character is located }
                    NEXT_CH; { Gobble_up the character }
                    sav0   := obj_nil
                  end
                end
              end
            end
          end;

        quot_fnc: { Standard Quote Definition }
          begin { Quote function macro character handling }
            object := DOUBLET_ALLOC; { allocate a doublet }
            with object.db^ do
            begin
              car := sym;           { set the quote atome }
              NEXT_CH;              { gobble up the quote character }
              cdr := DOUBLET_ALLOC; { allocate the parameter doublet }
              sav0 := sys_build_list.at^.val;
              sav1 := sys_build_list.at^.plist;
              { set the current list reference }
              sys_build_list.at^.val   := cdr;
              sys_build_list.at^.plist := obj_zero;
              with cdr.db^ do
              begin
                car := F_READ;
                cdr := obj_nil
              end;
              sys_build_list.at^.val   := sav0;
              sys_build_list.at^.plist := sav1
            end
          end;

        dp_fnc: { Formal by reference for DP function }
          begin
            NEXT_CH;                { Gobble up the reference character }
            object := F_READ;
            object.flg.f := object.flg.f + [dp_ref_flg]
          end;

        charty: { Character atom }
          begin
            ch := sy_ch;    { Save the string macro character }
            with src_control^ do
            begin
              { comment can be a part of string }
              commod := src_commentty;
              src_commentty := src_nocomment
            end;
            NEXT_CH;        { Get the character or first ASCII digit }
            object.flg := flg_def;
            object.typ := charty;
            object.ch  := sy_ch;
            NEXT_CH;        { Get the close character or second digit }
            if sy_ch <> ch then
            begin { ASCII value entry (two digits minimum) }
              berr := false;
              i := 0;
              with object do
                if (ch >= '0') and (ch <= '9') then
                  i := ORD( ch ) - ORD( '0' )
                else berr := true;
              { Get the next digit(s) }
              while (sy_ch <> ch) and (sy_ch <> eos) do
              begin
                if (sy_ch >= '0') and (sy_ch <= '9') then
                  i := i*10 + ORD( sy_ch ) - ORD( '0' )
                else
                  berr := true;
                NEXT_CH
              end;
              if sy_ch = eos then berr := true;
              if i < 256 then
                object.ch := CHR( i )
              else berr := true;
              if berr then SRC_ERROR( mdnam, 9, e_severe )
            end;
            with src_control^ do
            { re-enables lisp comment mode }
              src_commentty := commod;
            NEXT_CH { gobble up final character }
          end;

        strty:
          with sy_string do
          begin { string atome }
            ch := sy_ch;    { save the string macro character }
            with src_control^ do
            begin
              { comment can be a part of string }
              commod := src_commentty;
              src_commentty := src_nocomment
            end;
            length := 0;
            bstop  := false;
            berr   := false;
            while not bstop do
            begin
              NEXT_CH; { skip " }
              while sy_ch = eol do NEXT_CH; { skip any end of line }
              if sy_ch = eos then bstop := true;
              if sy_ch = ch then             { found a string char. '"' }
                if sy_ch = SRC_NEXT_CHAR then{ This character is twice }
                begin
                  NEXT_CH;                   { Skip this character }
                  if length < capacity then
                  begin
                    length := length + 1;
                    body[length] := sy_ch    { Add a string char. '"' }
                  end else berr := true
                end
                else bstop := true           { Set the end of string }
              else                           { Continue to load in string }
                if length < capacity then    { When it was not full }
                begin
                  length := length + 1;
                  body[length] := sy_ch
                end else berr := true
            end { while ... };
            with src_control^ do
            { Re-enables LISP Comment Mode }
              src_commentty := commod;
            NEXT_CH;                         { Continue the Read }
            if berr then SRC_ERROR( mdnam, 7, e_error );

            { Create Always a LISP String }
            object := obj_nuls;
            object.nam := NEW_LISP_STRINGV( sy_string  )
          end;


        list_fnc:
          begin { It is a list }
            NEXT_CH; { Gobble up "(" }
            object := IN_LIST( false ); { Head . is forbiden }

            if sym.typ <> last_fnc then
              SRC_ERROR( mdnam, 8, e_error );
            NEXT_CH
          end;

      otherwise
        SRC_ERROR( mdnam, 9, e_fatal );
        NEXT_CH { Gobble up the fault character }
      end
    end
    else
    case sy_cmaj of

      eol: { End Of Line Seen }
          { The end of line is never given as a read result}
          object := obj_empty;

      eos: { End Of File Seen }
          object := obj_eof;

    otherwise { Atome Case }
      object := IN_ATOM( -1, 10, false );
      if object.typ >= atomety then
        if dma_fnc_flg in object.at^.val.flg.f then
        begin { Proceed For The Macro }
          SKIP_SPACE;
          object := F_LET( object.at^.val, false )
        end
    end
  until not (invalid_flg in object.flg.f); { Continue Until no Empty obj }
  SKIP_SPACE; { Skip to Next Syntax Unit or to Next End Of Line (eoln) }
  read_kind.at^.val    := LISP_KIND( object );
  sys_read_obj.at^.val := object;
  if object.typ = eof_seen then
    with src_control^ do { Set the End Of File as Reached for F_EOF function }
      src_flags := src_flags + [src_eofrc];
  F_READ := object
end F_READ;



[global]
function F_STRING_INP( pl: obj_ref ): obj_ref;
const
  bufsz = 255;

var
  obj, res: obj_ref;
  psp, pre: body_s_ptr;
  sz, i, lsp, lre: integer;
  fnd:  boolean;
  sre, ssp: string( 16 );
  buf:      packed array[1..bufsz] of char;

begin
  { Get the list of separator (string of char) }
  obj := F_EVAL( NXT_PAR( pl ) );
  if obj.typ = nullty then lsp := 0
                      else GET_LISP_STR_REF( psp, lsp, ssp, obj );
  if lsp > 0 then SKIP_EOLN_AND_SPACE;

  { Get a default value that can be used as a string container }
  res := F_EVAL( NXT_PAR( pl ) );

  if (res.typ <> nullty) and (res.typ <> truety) then
    { If a default value is given, use it ... }
    GET_LISP_STR_REF( pre, lre, sre, res, true )
  else
  begin { ... else use the internal buffer }
    pre := buf[1]"address;
    lre := bufsz;
    res := obj_nil { Flag for no default value neither Container }
  end;

  { Search the First Significant Character }
  sz  := 0;
  fnd := false;
  if obj.typ = truety then
  begin
    obj := obj_nil;
    SKIP_EOLN_AND_SPACE          { Skip until Significant Character }
  end
  else
  begin
    if sy_ch = eol then NEXT_CH; { Skip one Trailing End Of Line }
    SKIP_SPACE                   { Skip any Trailing Space(s) }
  end;

  { Get the string, (Character Loop) }
  repeat
    if lsp > 0 then
    begin { Search the Current Character in the Separator List }
      i := 1;
      while (i <= lsp) and (psp^[i] <> sy_ch) do  i := i + 1;
      fnd := (i <= lsp);
    end;
    if not fnd and (sy_ch <> eol) and (sy_ch <> eos) then
    begin
      sz := sz + 1; pre^[sz] := sy_ch; NEXT_CH
    end
  until (sy_ch = eol) or (sy_ch = eos) or (sz >= lre) or fnd;

  if res.typ <> strty then
  begin { No Container }
    res := obj_nuls;
    if sz > 0 then
    begin { When a Value was readden }
      res.nam := LISP_STRING_ALLOC( sz ); { Creates a new string }
      for j := 1 to sz do  res.nam^.body[j] := buf[j];
      res.nam^.length := sz
    end
  end
  else { A String Container is given }
    if sz > 0 then res.nam^.length := sz;

  sys_eof.at^.val := obj_nil;
  if sy_ch = eol then
    sys_eoln.at^.val := obj_eoln
  else
    if sy_ch = eos then
    begin
      sys_eof.at^.val  := obj_eof;
      sys_eoln.at^.val := obj_eof
    end
    else
      sys_eoln.at^.val := obj_nil;
  F_STRING_INP := res
end F_STRING_INP;



            {***********************************}
            { ***   Lisp option procedure   *** }
            {***********************************}


[global]
function F_PRAGMA( parm: obj_ref; src: src_ptr ): obj_ref;
const
  mdnam    = 'PRAG';
  max_sopt = 255;

var
  i, j, iv:   integer;
  och, ch:    char;
  at:         obj_ref;
  tbv:        array[1..4] of integer;
  onfl, sign: boolean;

begin { F_PRAGMA }
  while parm.typ = doublety do
  begin
    at := F_EVAL( NXT_PAR( parm ) );
    och := ' '; onfl := true;
    case at.typ of
      charty:
        och := at.ch; { it a single char }

      strty:  { it a string }
        if at.nam <> nil then
        with at.nam^ do
        begin
          if length >= 1 then och := body[1];
          i := 2; iv := 0;
          while i <= length do
          begin
            ch := body[i]; i := i + 1;
            if ch = ':' then
            begin
              if (iv > 0) and sign then tbv[iv] := - tbv[iv];
              if iv < 4 then iv := iv + 1;
              tbv[iv] := 0; j := 0; sign := false
            end
            else
            if (ch >= '0') and (ch <= '9') and
               (iv > 0) and (iv < 4) then
            begin { digit for a parameter value }
              if tbv[iv] > 2047 then
              begin
                tbv[iv] := 0; EXEC_ERROR( mdnam, 11, e_warning )
              end;
              tbv[iv] := tbv[iv]*10 + ORD( ch ) - ORD( '0' );
              j := j + 1
            end
            else
            if iv = 0 then { option sign ? }
            begin
              if ch = '-' then
                onfl := false { if "-" it is a disable of option }
            end
            else
            if j = 0 then { sign of an option value ? }
            begin
              if ch = '-' then sign := true
            end
            else EXEC_ERROR( mdnam, 12, e_warning )
          end
        end;

    otherwise
      EXEC_ERROR( mdnam, 13, e_warning )
    end { case };

    { Set Option Letter in Major Character }
    if (och >= 'a') and (och <='z') then och := CHR( ORD( och ) - 32 );

    with src^ do
    case och of
      'L':  begin
              if onfl then
              begin
                if src_lstmxlev < src_level then src_lstmxlev := src_level;
                src_flags := src_flags + [src_blist]
              end
              else src_flags := src_flags - [src_blist];
              if iv > 0 then src_lstmxlev := ABS( tbv[1] )
            end;

      'P': if iv > 0 then nctobj_max := ABS( tbv[1] );

      'R': opt_result := onfl; { output result option }

      'D': opt_debug  := onfl; { output result option }

      'C': begin
             opt_calltrace := onfl; { output result option }
             if onfl then opt_debug := true
           end;

      'T': begin
             opt_exectrace := onfl; { output result option }
             if onfl then opt_debug := true
           end;

      'N': if iv > 0 then
             src_insnb := tbv[1]
           else
             if onfl then src_insnb := src_insnb + 1
             else src_insnb := src_insnb - 1;

      'E': if onfl then src_flags := src_flags + [src_becho]
           else src_flags := src_flags - [src_becho];

      'F': if iv > 0 then
           begin
             i := tbv[1]; if (i < 1) or (i > 32) then i := 1;
             src_frspos := i;
             if iv > 1 then
             begin
               j := tbv[2];
               if (j < i+5) or (j > max_sopt) then j := max_sopt;
               src_lstpos := j
             end
             else src_lstpos := max_sopt
           end
           else src_frspos := 1;

    otherwise
      EXEC_ERROR( mdnam, 14, e_warning )
    end
  end { while ... };
  F_PRAGMA := obj_nil
end F_PRAGMA;





            {***************************************************}
            { ***   Lisp chaine/include/listing procedures  *** }
            {***************************************************}


[global]
function F_LISTING( ll: obj_ref ): obj_ref;
const
  mdnam = 'LIST';

var
  ob:                                 obj_ref;
  ierr, ipg, ilns:                    integer;
  flg_unknown, flg_print, flg_append: boolean;
  head, title, sbttl, fname:          string( 255 ) := '';
  tbsep:                              array[1..20] of byte;

begin { F_LISTING }
  GET_STRING( fname, F_EVAL( NXT_PAR( ll ) ), '' ); { Get Listine File Spc. }
  { Complete a name without Listing Extension }
  STRING_LOCATE_SEP( fname, ':]/\.', tbsep, ierr );
  if ierr > 1 then
    if tbsep[ierr-1] <> 5 then ierr := 0;
  if ierr = 0 then fname := fname||'.lis';  
  ierr := 0;                             { Assume Success }
  ob  := F_EVAL( NXT_PAR( ll ) );        { Get the Unknown Flag }
  flg_unknown := (ob.typ <> nullty);
  ob  := F_EVAL( NXT_PAR( ll ) );        { Get the Print Flag }
  flg_print := (ob.typ <> nullty);
  ob  := F_EVAL( NXT_PAR( ll ) );
  flg_append := (ob.typ <> nullty);      { Get the Append Flag }
  ipg := INTEVLDEF( ll, -1 );            { Get the Page size }
  ilns := INTEVLDEF( ll, -1 );           { Get the Line Size }
  with main_lst^ do
  begin
    { Flush output if some output line is begining }
    if lst_currline^.length > 0 then LST_EOLN;
    { Save Page Heading, Title and Subtitle }
    head  := lst_heading^;
    title := lst_title^;
    sbttl := lst_sbttl^;
    { ... and do not Free the Page Context in the LST_CLOSE }
    lst_heading := nil;
    lst_title   := nil;
    lst_sbttl   := nil;
    { Open the New Listing }
    LST_OPEN( main_lst, fname, head, title, sbttl,  { no title change }
              ilns, ipg, flg_unknown, flg_print, flg_append, ierr );
    if ierr <> 0 then
      EXEC_ERROR( mdnam, 15, e_fatal )
  end;
  F_LISTING := obj_nil
end F_LISTING;



[global]
function F_INCLUDE( ll: obj_ref; bincl, berr: boolean ): obj_ref;
const
  mdnam = 'INCL';

var
  src_p: src_ptr;
  fname: string( 255 );
  ierr:  integer;
  tbsep: array[1..20] of byte;
  res:   obj_ref;

begin { F_INCLUDE }
  GET_STRING( fname, F_EVAL( NXT_PAR( ll ) ), 'TT:' );
  STRING_LOCATE_SEP( fname, ':]/\.', tbsep, ierr );
  if ierr > 1 then
    if tbsep[ierr-1] <> 5 then ierr := 0;
  if ierr = 0 then fname := fname||'.lisp';
  ierr  := 0;                      { Assume Success }
  src_p := nil;                    { Force Allocation by SRC_OPEN }
  SRC_OPEN( src_p, fname, false, ierr); { Open this file }
  if ierr = 0 then
  begin { No Open Error }
    with src_p^ do
    begin
      src_previous := src_control; { Link the file to the previous src. }
      src_level    := src_control^.src_level;
      if bincl then src_level := src_level + 1;
      src_lstmxlev := src_control^.src_lstmxlev;
      src_insnb    := src_control^.src_insnb;
      src_frspos   := src_control^.src_frspos;
      src_lstpos   := src_control^.src_lstpos;
      src_flags    := src_flags +
                      src_control^.src_flags * [src_blist,src_bphys,
                         src_linemode,src_listbyline,src_becho,src_echerr];
      src_commentty := src_control^.src_commentty
    end;

    F_PRAGMA( ll, src_p );         { Look for %PRAGMA Options }

    if not bincl and (sy_ch <> eol) then SRC_END_OF_LINE;

    src_control := src_p;          { Switch to New Source File }
    main_src := src_p;             { Set as Current Source File }
    COMPILE_SET_TITLE;             { Set the Current Source File Reference }
    sy_ch := eol;                  { Init the read character }

    if not bincl then { CHAINE Statement }
    begin
      with src_control^ do
      begin
        src_p := src_previous;
        src_previous := src_p^.src_previous { Get the true previous src }
      end;
      SRC_CLOSE( src_p, true )     { Elliminate the Old Source File Context }
    end;
    if berr then res := obj_zero
            else res := obj_empty
  end
  else { Cannot Open the Specified Source File }
    if berr then
    begin
      res.typ := intty;
      res.int := ierr
    end
    else EXEC_ERROR( mdnam, 16, e_fatal );
  sys_read_deep.at^.val.int := src_control^.src_level;
  F_INCLUDE := res
end F_INCLUDE;



            {***********************************}
            { ***   Print Procedure Group   *** }
            {***********************************}



[global]
function GET_CHAR( obj: obj_ref): char;
var
  ch: char;

begin
  case obj.typ of
    nullty:  ch := CHR( 0 );
    truety:  ch := CHR( 1 );
    charty:  ch := obj.ch;
    strty:   if obj.nam <> nil then
               with obj.nam^ do
                 if length >= 1 then ch := body[1]
                   else ch := CHR( 0 )
             else ch := CHR( 0 );

    atomety: ch := obj.at^.ats.nam^.body[1];

    intty:   ch := CHR( ABS( obj.int ) mod 256 )

  otherwise
     EXEC_ERROR( 'GCHA', 56, e_warning );
     ch := ' '
  end;
  GET_CHAR := ch
end GET_CHAR;



[global]
function F_PRINTCH( cha: obj_ref; nrep: integer ): obj_ref;
{ (PRINTCH char nrep) }
{ print char nrep times }

var
  c: char;

begin
  c := GET_CHAR( cha );
  LST_PUT_MCHAR( c, nrep );
  cha.typ := charty; cha.ch := c;
  F_PRINTCH := cha;
  sy_lstbreak := lst_current
end F_PRINTCH;



[global]
function F_TERPRI( ll: obj_ref ): obj_ref;
var
   isk: integer;
   res: obj_ref;

begin
  isk := INTEVLDEF( ll, -1 );                    { Get Skip Number }
  if ll.typ = doublety then
    LST_TEST_LINE( isk, INTEVL( ll ) )           { For Paragraphe Checking }
  else
    if isk > 0 then
    begin
      sy_lstbreak := nil;
      LST_SKIP_LINE( isk )
    end;

  if isk >= 0 then
  begin
    res.typ := intty; res.int := isk;
    F_TERPRI := res
  end
  else
  F_TERPRI := obj_nil
end F_TERPRI;



function OUT_STRFLG: char;
begin
  with prin_str.at^.val do
    if typ = charty then OUT_STRFLG := ch
                    else OUT_STRFLG := CHR( 0 )
end OUT_STRFLG;



function OUT_CHAFLG: char;
begin
  with prin_cha.at^.val do
    if typ = charty then OUT_CHAFLG := ch
                    else OUT_CHAFLG := CHR( 0 )
end OUT_CHAFLG;



[global]
procedure OUT_ATOM( obj: obj_ref );
var
  i: integer;
  c: char;

begin
  if dp_ref_flg in obj.flg.f then LST_PUT_CHAR( '\' );
  case obj.typ of
    nullty: begin
              LST_PUT_CHAR( '(' ); LST_PUT_CHAR( ')' )
            end;

    charty: begin
              c := OUT_CHAFLG; { Get String Flag }
              if c <> CHR( 0 ) then
              begin
                LST_PUT_CHAR( c );
                if (obj.ch < ' ') or (obj.ch > CHR( 126 )) then
                begin { Not a Printable Character }
                  i := ORD( obj.ch );
                  LST_PUT_INT( i, -3 )
                end
                else LST_PUT_CHAR( obj.ch );
                LST_PUT_CHAR( c )
              end
              else LST_PUT_CHAR( obj.ch );
            end;

    strty:  begin { Use The String }
              c := OUT_STRFLG; { Get string flag }
              if obj.nam = nil then
              begin
                if c <> CHR( 0 ) then
                begin
                  LST_PUT_CHAR( c );
                  LST_PUT_CHAR( c );
                end
              end
              else
              with obj.nam^ do
              begin
                if c <> CHR( 0 ) then
                begin
                  LST_PUT_CHAR( c );
                  for i := 1 to length do
                    if body[i] = c then
                    begin
                      LST_PUT_CHAR( c );
                      LST_PUT_CHAR( c )
                    end
                    else LST_PUT_CHAR( body[i] );
                  LST_PUT_CHAR( c )
                end
                else
                  for i := 1 to length do
                  LST_PUT_CHAR( body[i] )
              end
            end;

    intub:  if (obj.int = 0) and (prin_int.at^.val.typ = nullty)
            then LST_PUT_STRING( 'M_UB' )
            else LST_PUT_INT( obj.int, 0 );

    intsb:  if (obj.int = 0) and (prin_int.at^.val.typ = nullty)
            then LST_PUT_STRING( 'M_SB' )
            else LST_PUT_INT( obj.int, 0 );

    intuw:  if (obj.int = 0) and (prin_int.at^.val.typ = nullty)
            then LST_PUT_STRING( 'M_UW' )
            else LST_PUT_INT( obj.int, 0 );

    intsw:  if (obj.int = 0) and (prin_int.at^.val.typ = nullty)
            then LST_PUT_STRING( 'M_SW' )
            else LST_PUT_INT( obj.int, 0 );

    intty:  LST_PUT_INT( obj.int, 0 );

    sflty:  LST_PUT_FIXED( obj.flt, 10, 6, 3 );

    flty:   LST_PUT_FIXED( obj.flt, 20, 12, 3 );

    vectortyp:
            if obj.vect <> nil then
            with obj.vect^ do
            begin
              LST_PUT_MCHAR( '{', 2 ); LST_PUT_STRING( 'VECTOR ');
              LST_PUT_INT( vect_size, 0 ); LST_PUT_CHAR( ':' );
              LST_EOLN;
              for i := 0 to vect_size-1 do
              begin
                LST_PUT_INT( i, 0 ); LST_PUT_CHAR( '/' );
                OUT_OBJECT( vect_tab[i] );
                if i < vect_size-1 then LST_PUT_STRING( ', ' )
              end;
              LST_PUT_MCHAR( '}', 2 )
            end
            else LST_PUT_CHAR( '~' );

    mrdty:  LST_PUT_STRING( '\\Record_descriptor\\' );
    rfdty:  LST_PUT_STRING( '\\Field_descriptor\\' );

    mrecty,
    areatyp1,
    areatyp:
            begin
              LST_PUT_CHAR( '[' );
              if obj.typ = areatyp1 then LST_PUT_CHAR( '.' );
              LST_PUT_INT( obj.int, 0 );
              LST_PUT_CHAR( ']' )
            end;

    lextyp: with obj.lexd^ do
            begin
              LST_PUT_MCHAR( '{', 2 ); LST_PUT_STRING( 'LEX_LEVEL :' );
              LST_PUT_INT( lex, 0 );
              LST_PUT_MCHAR( '}', 2 )
            end;

    lfilety:
            if obj.lfile <> nil then
            begin
              LST_PUT_STRING( '{ Opened File in mode "' );
              LST_PUT_CHAR( obj.lfile^.lfile_mode );
              LST_PUT_STRING( '". }' )
            end
            else LST_PUT_CHAR( '~' );

  otherwise { builtin function and T }
    if obj.typ >= atomety then
      if obj.at = nil then LST_PUT_CHAR( '~' )
      else
      begin
        obj.nam := obj.at^.ats.nam; obj.typ := strty;
        if obj.nam = nil then LST_PUT_CHAR( '~' )
                         else LST_PUT_LISP_STR( obj.nam )
      end
    else
      if obj.nam = nil then LST_PUT_CHAR( '~' )
                       else LST_PUT_LISP_STR( obj.nam )
  end
end OUT_ATOM;



[global]
procedure OUT_OBJECT( obj: obj_ref );
begin
  if nctobj <= nctobj_max then
  begin
    nctobj := nctobj + 1;
    if obj.typ = doublety then
    begin
      if obj.db <> nil then
        if (obj.db^.car.typ = quot_fnc) and (obj.db^.cdr.typ <> nullty) then
        begin { Quote Presentation }
          LST_PUT_CHAR( '''' );
          OUT_OBJECT( obj.db^.cdr.db^.car )
        end
        else
        begin { Output a List }
          LST_PUT_CHAR( '(' );
          while (obj.typ = doublety) and (nctobj <= nctobj_max) do
          with obj.db^ do
          begin
            OUT_OBJECT( car );
            if cdr.typ = doublety then LST_PUT_CHAR( ' ' );
            obj := cdr
          end;
          if obj.typ <> nullty then
          begin
            LST_PUT_CHAR( ' ' );
            LST_PUT_CHAR( '.' );
            LST_PUT_CHAR( ' ' );
            OUT_OBJECT( obj )
          end;
          LST_PUT_CHAR( ')' )
        end
      else LST_PUT_STRING( '(~)' )
    end
    else
      OUT_ATOM( obj )
  end
  else
    LST_PUT_MCHAR( '.', 3 );
  sy_lstbreak := lst_current
end OUT_OBJECT;



[global]
procedure F_TRACE_EXEC( obj: obj_ref );
begin
  eval_ninc := eval_ninc + 1;
  LST_PUT_CHAR( '>' );
  LST_PUT_INT( eval_ninc, 0 );
  LST_PUT_CHAR( '>' );
  nctobj := 0;
  OUT_OBJECT( obj );
  sy_lstbreak := nil;
  LST_EOLN
end F_TRACE_EXEC;




[global]
procedure F_TRACE_EXEC1( obj: obj_ref );
begin
  LST_PUT_CHAR( '<' );
  LST_PUT_INT( eval_ninc, 0 );
  LST_PUT_CHAR( '<' );
  nctobj := 0;
  OUT_OBJECT( obj );
  sy_lstbreak := nil;
  LST_EOLN;
  eval_ninc := eval_ninc - 1
end F_TRACE_EXEC1;




[global]
procedure F_TRACE_CALL( fn, expr: obj_ref; fend: boolean );
begin
  if fend then LST_PUT_CHAR( '<' );
  LST_PUT_MCHAR( '-', recurs_nb*2 );
  nctobj := 0;
  if not fend then  LST_PUT_CHAR( '>' );
  OUT_ATOM( fn ); LST_PUT_CHAR( ':' );
  if fend then OUT_OBJECT( expr )
          else
            if expr.typ = doublety then
            begin
              LST_PUT_CHAR( '(' );
              while expr.typ = doublety do
                with expr.db^ do
                begin
                  OUT_OBJECT( car.at^.val );
                  if cdr.typ = doublety then LST_PUT_CHAR( ' ' );
                  expr := cdr
                end;
              LST_PUT_CHAR( ')' )
            end
            else { atomety }
              if expr.at <> nil then OUT_OBJECT( expr.at^.val )
                                else LST_PUT_CHAR( '~' );
  sy_lstbreak := nil;
  LST_EOLN
end F_TRACE_CALL;




[global]
function F_PRINT( li: obj_ref; out_flg: boolean ): obj_ref;
var
  obj: obj_ref;

begin
  obj := obj_nil;
  while li.typ <> nullty do
  begin
    obj := F_EVAL( li.db^.car );
    nctobj := 0;
    OUT_OBJECT( obj );
    li := li.db^.cdr
  end;
  if out_flg then
  begin
    sy_lstbreak := nil;
    LST_EOLN
  end;
  F_PRINT := obj
end F_PRINT;



function CHECK_OPEN_FILE( fil: obj_ref; file_kind: lfile_types ): obj_ref;
const
  mdnam = 'CHKF';

var
  res: obj_ref;

begin
  res := obj_nil;
  if fil.typ <> lfilety then
  begin
    if fil.typ < atomety then EXEC_ERROR( mdnam, 47, e_severe )
                         else fil := fil.at^.val;
    if fil.typ <> lfilety then EXEC_ERROR( mdnam, 47, e_severe )
  end;
  if fil.lfile <> nil then
  with fil.lfile^ do
  begin
    if lfile_typ = file_kind then res := fil
                             { File is Opened in an Unwanted Mode }
                             else EXEC_ERROR( mdnam, 47, e_error )
  end
  else EXEC_ERROR( mdnam, 47, e_error );
  CHECK_OPEN_FILE := res
end CHECK_OPEN_FILE;




function GET_IO_LIST( var iol, stk: obj_ref ): obj_ref;
var
  obj, res: obj_ref;

begin
  while (iol.typ <> doublety) and (stk.typ = doublety) do
    iol := F_DBL_FREE( stk );
  if iol.typ = doublety then
  begin
    res := NXT_PAR( iol );
    if (res.typ = charty) and (res.ch = '@') then
    begin
      obj := GET_LIST( iol, false );
      if obj.typ = doublety then
      begin
        stk := F_CONS( iol, stk );
        iol := obj
      end;
      res := GET_IO_LIST( iol, stk )
    end
  end else res := obj_true;
  GET_IO_LIST := res
end GET_IO_LIST;



[global]
function F_INP_FORMAT( pl: obj_ref ): obj_ref;
const
  mdnam = 'IFOR';

var
  bzapline, binflag: boolean;
  fil, ob, ob1, obf, spc, spf, stk, fo, fo1, res: obj_ref;
  code, sch:   char;
  fs, iv, irp: integer;
  buffer:      string( 255 );
  src_save:    src_ptr;
  rv:          lisp_real;

begin { F_INP_FORMAT }
  fo := obj_nil; fo1 := obj_nil;   { Set the Default Format Mode }
  bzapline := true;
  src_save := nil;
  sch      := ' '; fs    := 0;
  stk      := obj_nil;
  ob       := GET_IO_LIST( pl, stk ); { Get a LISP Object }

  if ob.typ = doublety then ob := F_EVAL( ob );

  if ob.typ >= atomety then
  with ob.at^ do
    if (val.typ = lfilety) or
       (val.typ = doublety) then   { When the first object is a File }
      ob := ob.at^.val;            { We select it for INPUT }

  if ob.typ = lfilety then
  begin
    fil := CHECK_OPEN_FILE( ob, infiletyp ); { Check for ASC. INPUT mode }
    if fil.typ = lfilety then
    begin { Set this File as Input File, with Current Input Setting save }
      src_save    := src_control;
      src_control := fil.lfile^.lfile_inp;
      sy_ch_break := true;
      NEXT_CH
    end;
    ob := GET_IO_LIST( pl, stk );  { Get a LISP Object }
    if ob.typ = doublety then ob := F_EVAL( ob ) { Only list are valued }
    else
      if ob.at^.val.typ = doublety then { atome with format value }
        ob := ob.at^.val
  end;

  if sy_ch = eol then NEXT_CH;     { Call a New Line on an End Of Line }

  irp := 0;
  if (sys_eof.at^.val.typ <> eof_seen) then
  repeat { *** Loop on all format specification *** }
    res := obj_nil;
    binflag := false;
    if ob.typ = doublety then      { A doublet can be only a format }
    begin                          { for Format specification }
      fo  := ob; fo1 := fo;        { Set this object as the current format }
      irp := 0
    end
    else                           { Object to input }
    if ob.typ < atomety then
      EXEC_ERROR( mdnam, 59, e_severe )
    else
    repeat { *** Loop on the object to read *** }
      if irp > 0 then              { For a Format to Repeat ... }
        irp := irp - 1             { Decrement the Count }
      else
      begin                        { Set a New Format Specification }
        { Rescan a Terminated Format }
        if fo1.typ <> doublety then fo1 := fo;
        spf := NXT_PAR( fo1 );     { Get a format specification }
        if spf.typ = intty then    { Repeat Format Number is Given }
        begin
          irp := INTVAL( spf ) - 1;
          if irp < 0 then irp := 0;
          spf := NXT_PAR( fo1 )
        end;
        if (spf.typ <> doublety) and
           (spf.typ <> strty)    and
           (spf.typ <> nullty) then
          EXEC_ERROR( mdnam, 78, e_error )
      end;
      spc := spf;                  { Save the Format spc. Begining }
      if spc.typ = nullty then
      begin
        binflag := true;
        res := F_READ              { Default Input }
      end
      else
      begin
        res := obj_nil;
        if spc.typ = strty then
          obf := spc               { Get the Direct Holleright }
        else
          obf := NXT_PAR( spc );   { Get the Format Specification }
        if obf.typ = strty then code := 'H'
                           else code := GET_CHAR( obf );
        if (code >= 'a') and (code <= 'z') then
          code := CHR( ORD( code ) - 32 );  { Translate in Major Case }
        case code of
          '$': bzapline := false;  { Do not Zap the Line }
          'L': { Line skip }
             begin
               iv := GET_INT( spc, 1 );
               while (iv > 0) and (sys_eof.at^.val.typ <> eof_seen) do
               begin
                 F_ZAPLINE; { go to the end of line }
                 if sy_ch = eol then NEXT_CH; { go to the next line }
                 iv := iv - 1
               end
             end;

          'P': { Page skip as a single line skip } F_ZAPLINE;

          'C': { Skip to Column }
             with src_control^, src_cmdline^ do
             begin
               iv := GET_INT( spc, 1 );
               if iv < src_frspos then iv := src_frspos
               else
               if iv > src_lstpos then iv := src_lstpos;
               if iv < src_chidx then F_ZAPLINE; { line read overun }
               while (src_chidx < iv) and (sys_eoln.at^.val.typ <> nullty) do
                 NEXT_CH
             end;

          'H': { Holleright skip }
             if obf.nam <> nil then
             begin
               iv := obf.nam^.length;
               while iv > 0 do
               begin  NEXT_CH; iv := iv - 1  end
             end;

          'X': { Skip character }
             begin
               iv := GET_INT( spc, 1 );
               while iv > 0 do
               begin  NEXT_CH; iv := iv - 1  end
             end;

          'A': { String Format }
            with buffer do
            begin
              length := 0;
              fs := GET_INT( spc, 0 );
              if (fs > capacity) or (fs < 1) then fs := capacity;
              while (fs > 0) and (sy_ch <> eos) and (sy_ch <> eol) do
              begin { Get each Character of the Input String }
                fs := fs - 1;
                length := length + 1;
                body[length] := sy_ch;
                NEXT_CH
              end;
              res     := obj_nuls;
              res.nam := NEW_LISP_STRINGV( buffer );
              binflag := true
            end;

          'I', 'F', 'E', 'S': { Numeric Format }
            begin
              fs := GET_INT( spc, 0 );      { Get the Field }
              if code = 'I' then iv := GET_INT( spc, 10 )
                            else iv := 10;
              ob1 := IN_ATOM( fs, iv, true );
              if code = 'I' then
              begin
                res.typ := intty;
                res.int := INTVAL( ob1 )
              end
              else
              begin
                if code = 'S' then res.typ := sflty else res.typ := flty;
                res.flt := FLTVAL( ob1 )
              end;
              binflag := true
            end;

        otherwise { Fixed Format Specified or Default }
          EXEC_ERROR( mdnam, 86, e_error )
        end
      end;
      if ob.typ >= atomety then ob.at^.val := res
    until binflag or (sys_eof.at^.val.typ = eof_seen);

    ob := GET_IO_LIST( pl, stk );
    if ob.typ = doublety then ob := F_EVAL( ob );
  until ob.typ = truety;
  if bzapline then F_ZAPLINE;
  if src_save <> nil then
  begin
    src_control := src_save;
    sy_ch_break := true;
    NEXT_CH
  end;
  F_INP_FORMAT := res
end F_INP_FORMAT;



[global]
function F_OUT_FORMAT( pl: obj_ref ): obj_ref;
const
  mdnam = 'OFOR';

var
  bendline, outflg:          boolean;
  fil, ob, obf, spc, spf, stk, fo, fo1: obj_ref;
  code, sch:                 char;
  iv, jv, sfs, fs, dc, dcmin,
  dcsz, es, irp, lst:        integer;
  pst:                       body_s_ptr;
  lst_save:                  lst_ptr;
  scv:                       string( 16 );

begin { F_OUT_FORMAT }
  fo := obj_nil; fo1 := obj_nil;   { Set the Default Format Mode }
  lst_save := lst_current;

  { Set the Default Formats }
  sfs   :=  0; sch   := ' ';
  fs    := 12; dc    :=   4; dcmin := 3;
  dcsz  :=  4; es    :=   3;
  bendline := true;
  stk      := obj_nil;

  ob := F_EVAL( GET_IO_LIST( pl, stk ) );    { Get a LISP Object }

  if ob.typ = lfilety then         { When the first object is a File }
  begin
    fil := CHECK_OPEN_FILE( ob, outfiletyp ); { Check it for ASC. OUTPUT }
    if fil.typ = lfilety then
      { Set this File as Output File, with Current Output Setting Saved }
      lst_current := fil.lfile^.lfile_out;
    ob := F_EVAL( GET_IO_LIST( pl, stk ) )
  end;

  irp := 0;

  repeat
    outflg := false;
    if ob.typ = doublety then
    begin
      fo := ob; fo1 := fo;         { Set this Object as the Current Format }
      irp := 0
    end
    else                           { Object to Output }
    repeat
      if irp > 0 then              { For a Format to Repeat }
        irp := irp - 1
      else
      begin { set a new format specification }
        { Set the Rescan of Previous Format List on End of Format List }
        if fo1.typ <> doublety then fo1 := fo;
        spf := NXT_PAR( fo1 );     { Get a Format Specification }
        if spf.typ = intty then    { Repeat Format number Given ? }
        begin
          irp := INTVAL( spf ) - 1;
          if irp < 0 then irp := 0;
          spf := NXT_PAR( fo1 )
        end;
        if (spf.typ <> doublety) and
           (spf.typ <> strty)    and
           (spf.typ <> nullty) then
          EXEC_ERROR( mdnam, 78, e_error )
      end;
      spc := spf;
      if spc.typ = nullty then
      begin
        OUT_OBJECT( ob );          { Default Output }
        outflg := true
      end
      else
      begin
        if spc.typ = strty then
          obf := spc               { Get the Direct Holleright }
        else
          obf := NXT_PAR( spc );   { Get the Format Specification }
        if obf.typ = strty then code := 'H'
                           else code := GET_CHAR( obf );
        if (code >= 'a') and (code <= 'z') then
          code := CHR( ORD( code ) - 32 );   { Translate in Major Case }
        case code of
          'L': { Line skip }   LST_SKIP_LINE( GET_INT( spc, 1 ) );
          'P': { Page skip }   LST_PAGE;
          'C': { Column skip } LST_SET_COLUMN( GET_INT( spc, 1 ) );
          'X': { skip character }
            begin
              iv  := GET_INT( spc, 1 );
              sch := GET_CHAR( NXT_PAR( spc ) );
              if sch < ' ' then sch := ' ';
              LST_PUT_MCHAR( sch, iv )
            end;
          '$': { No end line } bendline := false;
          'H': { Holleright format }
            begin
              GET_LISP_STR_REF( pst, lst, scv, obf );
              for i := 1 to lst do  LST_PUT_CHAR( pst^[i] )
            end;
          'A': { string format }
            begin
              sfs := GET_INT( spc, 0 );
              iv  := GET_INT( spc, -1 );
              sch := GET_CHAR( NXT_PAR( spc ) );
              if sch < ' ' then sch := ' ';
              GET_LISP_STR_REF( pst, lst, scv, ob ); { Get the string ref. }
              if sfs > 0 then      { If Field OK }
              begin
                jv := lst;         { Get the String Size }
                if jv >= sfs then
                begin
                  jv := sfs;       { Limit it to sfs }
                  for i := 1 to jv do  LST_PUT_CHAR( pst^[i] )
                end
                else
                begin
                  if iv > 0 then
                  begin { Print at Right }
                    LST_PUT_MCHAR( sch, sfs - lst );
                    for i := 1 to lst do  LST_PUT_CHAR( pst^[i] )
                  end
                  else
                  if iv < 0 then
                  begin { Print at Left }
                    for i := 1 to lst do  LST_PUT_CHAR( pst^[i] );
                    LST_PUT_MCHAR( sch, sfs - lst )
                  end
                  else
                  begin { Print to Center }
                    iv := (sfs - lst) div 2;
                    LST_PUT_MCHAR( sch, iv );
                    for i := 1 to lst do  LST_PUT_CHAR( pst^[i] );
                    LST_PUT_MCHAR( sch, sfs - lst - iv )
                  end
                end
              end
              else for i := 1 to lst do  LST_PUT_CHAR( pst^[i] );
              outflg := true
            end;

          'I': { Integer Format }
            begin
              fs := GET_INT( spc, 12 );      { Get the field }
              iv := GET_INT( spc, 10 );      { Get the base }
              if ob.typ = nullty then LST_PUT_MCHAR( ' ', fs )
                                 else LST_PUT_INT( INTVAL( ob ), fs, iv );
              outflg := true
            end;

          'E': { Exponentiel Format }
            begin
              fs := GET_INT( spc, 12 );      { Get the field }
              dcsz  := GET_INT( spc,  dcsz );{ Get the wanted decimal part size }
              es    := GET_INT( spc,    es );{ Get the wanted exponent size }
              if ob.typ = nullty then LST_PUT_MCHAR( ' ', fs )
              else
                LST_PUT_FLOAT( FLTVAL( ob ), fs, dcsz, es );
              outflg := true
            end;

          'F': { Fixed Format }
            begin
              fs    := GET_INT( spc, 12 );   { get the field }
              dc    := GET_INT( spc, dc );   { get the wanted decimal number }
              dcmin := GET_INT( spc, dcmin );{ get the minimum of displayed precision }
              if ob.typ = nullty then
                LST_PUT_MCHAR( ' ', fs )
              else
                LST_PUT_FIXED( FLTVAL( ob ), fs, dc, dcmin );
              outflg := true
            end;

        otherwise { Fixed Format Specified or Default }
          EXEC_ERROR( mdnam, 87, e_error )
        end
      end
    until outflg;

    ob := F_EVAL( GET_IO_LIST( pl, stk ) );
  until ob.typ = truety;
  if bendline then LST_EOLN
              else sy_lstbreak := lst_current;
  lst_current  := lst_save;
  F_OUT_FORMAT := ob
end F_OUT_FORMAT;




[global]
function F_DEF_LIS_ARRAY( pl: obj_ref ): obj_ref;
{ Build a Listing array descriptor routine.
  Use :
    (DEF_LIST_ARRAY <frm_spc> <label> <label> ... )
    with :
      <frm_spc> = list of format limited at |$|,|C|,|X|,|A|,|I|,|F|,|E|
      <lab_spc> = list of label (string name for each column).

  Result : <sbttl_string>.

}
const
  mdnam = 'DLAR';
  max_lis_array = 255;

var
  nxf:                                       boolean;
  cod:                                       char;
  fsz, svu, isu, jsu, irp, imd, jmd:         integer;
  fo, fo1, lab, ob, obf, sbt, spc, spf, stk: obj_ref;

begin
  stk := obj_nil;
  imd := INTEVLDEF( pl, 1 );
  sbt := obj_nuls;
  fo  := obj_nil;
  sbt.nam := LISP_STRING_ALLOC( max_lis_array );
  if sbt.nam <> nil then
  with sbt.nam^ do
  begin
    ob    := F_EVAL( GET_IO_LIST( pl, stk ) );
    spf   := obj_nil;
    repeat                         { Output Object Loop }
      nxf := false;
      if ob.typ = doublety then
      begin
        fo := ob; fo1 := fo;       { Set this object as the current format }
        irp := 0
      end
      else                         { Format Specifier Loop }
      repeat                       { Main Object Loop }
        if irp > 0 then            { For a Format Repeat }
          irp := irp - 1
        else
        begin { Set a New Format Specification }
          { Set rescan the previous format list on end of format list }
          if fo1.typ <> doublety then fo1 := fo;
          spf := NXT_PAR( fo1 );   { Get a Format Specification }
          if spf.typ = intty then  { Repeat Format Number Given ? }
          begin
            irp := INTVAL( spf ) - 1;
            if irp < 0 then irp := 0;
            spf := NXT_PAR( fo1 )
          end;
          if (spf.typ <> doublety) and
             (spf.typ <> strty)    and
             (spf.typ <> nullty) then
            EXEC_ERROR( mdnam, 78, e_error )
        end;
        spc := spf;
        { A format MUST be specified }
        if spc.typ = nullty then EXEC_ERROR( mdnam, 77, e_severe );
        nxf := false;
        if spc.typ = strty then obf := spc { Get The Direct Holleright }
                           else obf := NXT_PAR( spc ); { Get the Format spc. }
        if obf.typ = strty then cod := 'H'
                           else cod := GET_CHAR( obf );
        case cod of
          '$': { No line end => O.K. } fsz := 0;
          'C': begin { Column Skip }
                 fsz := GET_INT( spc, 1 );
                 if (fsz > length) and (fsz < capacity) then
                   for i := 1 to fsz - length - 1 do
                   begin
                     length := length + 1;
                     body[length] := ' '
                   end
               end;
          'X': begin { Skip Character }
                 fsz := GET_INT( spc, 1 );
                 for i := 1 to fsz do
                 begin
                   length := length + 1;
                   body[length] := ' '
                 end
               end;
          'H': if obf.nam <> nil then
                 for i := 1 to obf.nam^.length do
                 begin
                   length := length + 1;
                   body[length] := ' '
                 end;
          'A',
          'I',
          'F',
          'E': begin { Write a String }
                 lab := GET_LISP_STR( ob, '' ); { Get the Column Label }
                 nxf := true;
                 fsz := GET_INT( spc, 12 );
                 if lab.nam = nil then
                   for i := 1 to fsz do
                   begin
                     length := length + 1;
                     body[length] := ' '
                   end
                 else
                 begin
                   svu := lab.nam^.length;
                   if svu > fsz then svu := fsz;
                   if cod = 'A' then jmd := GET_INT( spc, -1 )
                                else jmd := imd;
                   if jmd = 0 then
                   begin { Centered Mode }
                     isu := (fsz - svu) div 2;
                     jsu := fsz - svu - isu
                   end
                   else if jmd < 0 then
                   begin  { At Left }
                     isu := 0;
                     jsu := fsz - svu
                   end
                   else
                   begin { At Right }
                     isu := fsz - svu;
                     jsu := 0
                   end;
                   if isu > 0 then
                     for i := 1 to isu do
                     begin
                       length := length + 1;
                       body[length] := ' '
                     end;
                   for i := 1 to svu do
                   begin
                     length := length + 1;
                     body[length] := lab.nam^.body[i]
                   end;
                   if jsu > 0 then
                     for i := 1 to jsu do
                     begin
                       length := length + 1;
                       body[length] := ' '
                     end
                 end
               end;
        otherwise
          EXEC_ERROR( mdnam, 86, e_error )
        end;
        { Build the Format Related Doublet }
      until nxf;
      ob := F_EVAL( GET_IO_LIST( pl, stk ) );
    until ob.typ = truety;
  end;
  F_DEF_LIS_ARRAY := sbt
end F_DEF_LIS_ARRAY;



[global]
function F_SET_LIS_ARRAY( pl: obj_ref ): obj_ref;
{ Builtin E-LISP function to select/unselect a defined List array Format
  on a specified Output File. Form of call :
   (SET_LIS_ARRAY  <output_file> <List_array_string>)
}
var
  i, j, lsbt:  integer;
  fil:         obj_ref;
  psbt:        body_s_ptr;
  lstp, lsts:  lst_ptr := nil;
  scv: string( 16 );

begin
  fil := F_EVAL( NXT_PAR( pl ) ); { Get the File Specification }
  { Check mode and Select the Output File }
  lsts := lst_current;
  if fil.typ <> nullty then fil := CHECK_OPEN_FILE( fil, outfiletyp );
  if fil.typ = nullty then lstp := main_lst
                      else lstp := fil.lfile^.lfile_out;
  { Get the List Array String reference }
  GET_LISP_STR_REF( psbt, lsbt, scv, F_EVAL( NXT_PAR( pl ) ) );
  i := INTEVLDEF( pl, 6);
  with lstp^ do
  begin
    { Delete any old sub-title }
    if lst_sbttl <> nil then DISPOSE( lst_sbttl );
    if lsbt > 0 then
    begin
      { ... and set the new one }
      NEW( lst_sbttl, lsbt );
      with lst_sbttl^ do
      begin
        length := lsbt;
        for i := 1 to lsbt do  body[i] := psbt^[i]
      end;
      { Set the file as Current output file }
      lst_current := lstp;                    
      j := lst_lncnt;                         { Keep the line count }
      LST_TEST_LINE( INTEVLDEF( pl, 2 ), i ); { Set skip test }
      if lst_lncnt >= j then                  { We must print the sub title }
      begin
        LST_PUT_STRING( lst_sbttl^ );
        LST_SKIP_LINE( 2 )
      end;
      { Restore the Current Output file }
      lst_current := lsts
    end
  end;
  F_SET_LIS_ARRAY := obj_nil
end F_SET_LIS_ARRAY;





       {***************************************************}
       { ***    binary file input/output procedures    *** }
       {***************************************************}


[global]
function F_GET_BIN( lpar: obj_ref ): obj_ref;
const
  mdnam = 'FGET';

var
  fil, res: obj_ref;
  buf:      rec_ptr;
  sa, sb:   cvsz;
 
begin { F_GET_BIN }
  fil := CHECK_OPEN_FILE( F_EVAL( NXT_PAR( lpar ) ), inbintyp );
  { Get the record Address and size (in bytes) }
  REC_EVL( lpar, buf, sa.siz );
  res := obj_eof;
  if (fil.typ = lfilety) and (buf <> nil) then
  with fil.lfile^ do
    if lfile_typ = inbintyp then { For Input Binbary file Only }
    begin
      if EOF( lfile_bin ) then goto ET_STOP;
      sb.sz1 := lfile_bin^; GET( lfile_bin );
      sb.sz2 := lfile_bin^; GET( lfile_bin );
      for i := 1 to sb.siz do
      begin
        if EOF( lfile_bin ) then goto ET_STOP;
        if i <= sa.siz then buf^.bf[i] := lfile_bin^;
        GET( lfile_bin )
      end;
      res := obj_zero;
      if sb.siz <= sa.siz then res.int :=   sb.siz
                          else res.int := - sb.siz
    end;
ET_STOP:
  F_GET_BIN := res
end F_GET_BIN;



[global]
function F_PUT_BIN( lpar: obj_ref ): obj_ref;
const
  mdnam = 'FPUT';

var
  fil, res: obj_ref;
  buf:      rec_ptr;
  sa:       cvsz;

begin { F_PUT_BIN }
  fil  := CHECK_OPEN_FILE( F_EVAL( NXT_PAR( lpar ) ), outbintyp );
  REC_EVL( lpar, buf, sa.siz );
  res := obj_nil;
  if (fil.typ = lfilety) and (buf <> nil) then
  with fil.lfile^ do
    if lfile_typ = outbintyp then { For Output Binary file Only }
    begin
      lfile_bin^ := sa.sz1; PUT( lfile_bin );
      lfile_bin^ := sa.sz2; PUT( lfile_bin );
      for i := 1 to sa.siz do
      begin
        lfile_bin^ := buf^.bf[i];
        PUT( lfile_bin )
      end;
      res := obj_zero;
      res.int := sa.siz
    end;
  F_PUT_BIN := res
end F_PUT_BIN;




       {**************************************************}
       { ***    virtual file read/write procedures    *** }
       {**************************************************}


[global]
procedure VLS_NEXTSTRING;
var
  oblst,                              { Current list element }
  obfile: obj_ref;                    { Pointer of the related LISP File }

begin { VLS_NEXTSTRING }
  with lst_current^, lst_currline^ do
  begin
    oblst.flg := flg_def;
    oblst.typ := lfilety;
    oblst.nam := lst_lsthde;          { Get the related virtual file atom }
    oblst := DOUBLET_ALLOC;           { Create a new doublet }
    with oblst.db^ do
    if length = 1 then
    begin                             { Generate a Character }
      car.typ := charty; car.ch := body[1]
    end
    else
    if length > 1 then
    begin                             { Generate a String }
      car := obj_nuls;
      car.nam := NEW_LISP_STRINGV( lst_currline^ )
    end;
    length := 0;                      { Clear the String Buffer }
    with oblst.lfile^ do
    begin
      if lfile_spc.typ = atomety then { First File Line }
        lfile_spc.at^.val := oblst    { Set the head list of this file }
      else
        lfile_spc.db^.cdr := oblst;   { Append to the list of string }
      lfile_spc := oblst              { Set for the next line }
    end
  end
end VLS_NEXTSTRING;



[global]
procedure VSR_NEXTSTRING;
var
  obsrc: obj_ref;                     { pointer of the related file atom }
  i:     integer;

begin  { VSR_NEXTSTRING }
  with src_control^, src_cmdline^ do
  begin
    length := 0;                      { Clear the Current Buffer Line }
    obsrc.typ := lfilety;
    obsrc.nam := src_prompt;          { Get the related atom file pointer }
    with obsrc.lfile^ do              { Get the current string list element }
    begin
      if lfile_spc.typ = doublety then
      repeat
        if lfile_spc.typ = doublety then
        begin
          with lfile_spc.db^ do
            case car.typ of
              nullty: { skip to next internal line in the file };
              charty: begin
                        { set the unique character }
                        length:= 1; body[1] := car.ch
                      end;
              strty:  if car.nam <> nil then
                      begin
                        length := car.nam^.length; { Set the New Line }
                        for i := 1 to length do
                          body[i] := car.nam^.body[i]
                      end;
            otherwise
              lfile_spc := obj_nil    { Signal End Of File }
            end;
          lfile_spc := lfile_spc.db^.cdr { Skip to next list element }
        end
        else lfile_spc := obj_nil     { Set the Virtual End Of File }
      until (lfile_spc.typ = nullty) or (length > 0)
      else lfile_spc := obj_nil;
      if (lfile_spc.typ = nullty) and (length = 0) then { End Of File Reached }
        { Set the EOF flags in the source context state }
        src_flags := src_flags + [src_eof]
    end
  end
end VSR_NEXTSTRING;




           {******************************************}
           { ***    file open/close procedures    *** }
           {******************************************}




[global]
function F_OPEN( lpar: obj_ref ): obj_ref;
{ F_OPEN( fileat, mode, filespc, attr: obj_ref ): integer; }
{ function to open a file,
  fileat must be an atom, mode a character, name a string  }
{ mode = "I" or "R" for input,
         "T" for input with delete on close time,
         "W" for write in unknown mode,
         "N" for write in new mode,
         "A" for write in append mode,
         "S" for read a string list,
         "E" for write a string list,
         "G" for binary input file,
         "D" for binary input with close time delete,
         "P" for binary output file (new version if it was existing),
         "U" for binary output file (old version is superseded). }

{ name is the legal file specification }

const
  mdnam = 'OPEN';

var

{ F_OPEN( fileat, mode, filespc, attr: obj_ref ): integer; }
  fileat, filespc: obj_ref;

  bunknown, bprint, bappend: boolean;
  ipg, ierr:                 integer;
  md:                        char;
  f_state:                   flags_file;
  res, fileptr:              obj_ref;
  src_p:                     src_ptr := nil;
  lst_p:                     lst_ptr := nil;
  head, title, sbttl, fname: [static] string( 255 ) := '';

begin
  res := obj_zero;
  fileat := F_EVAL( NXT_PAR( lpar ) );
  if fileat.typ >= atomety then
    { An atom is used as LISP File Specifier }
    md := GET_CHAR( F_EVAL( NXT_PAR( lpar ) ) )
  else
  begin { No LISP File Specifier }
    md     := GET_CHAR( fileat );
    fileat := obj_nil
  end;
  filespc := F_EVAL( NXT_PAR( lpar ) );
  fileptr := obj_nil;
  ierr := 0;                          { Assume Success }
  if (md >= 'a') and (md <= 'z') then md := CHR( ORD( md ) - 32 );

  if md = 'E' then
  begin { Output Virtual File Open }
    { The filespc must be an true atom specifier for 'E' mode }
    if filespc.typ < atomety then EXEC_ERROR( mdnam, 42, e_severe )
  end
  else
  if md = 'S' then
  begin { Input Virtual File Open }
    if (filespc.typ <> doublety) and
       (filespc.typ <> nullty) then EXEC_ERROR( mdnam, 43, e_severe )
  end
  else { True File }
    GET_STRING( fname, filespc, 'TT:' ); { Get the file name }

  fileptr.typ := lfilety;
  NEW( fileptr.lfile ); { Create a LISP File Descriptor }
  with fileptr.lfile^ do
  begin
    lfile_spc    := obj_nil;
    lfile_mode   := md;

    case md of
      'S',
      'T',
      'R',
      'I': begin
             if md = 'S' then
             begin { Virtual Input File }
               src_p := SRC_ALLOCATE; { Allocate a source context }
               with src_p^ do
               begin
                 src_prompt := fileptr.nam;{ Establish the link to atom file }
                 src_flags := [src_macro, src_echerr, src_eoln] { Set Macro Mod }
               end
             end
             else
             begin { Real Input File }
               src_p := nil;          { To Force Allocation by SRC_OPEN }
               { Open this input file }
               SRC_OPEN( src_p, fname, (md = 'T'), ierr)
             end;
             if ierr = 0 { No Open Error } then
             begin
               with src_p^ do
               begin
                 { Link the file to the previous src }
                 src_previous := src_control;
                 src_level := INTEVLDEF( lpar, 1 );
                 src_lstmxlev := src_control^.src_lstmxlev;
                 src_insnb := src_control^.src_insnb;
                 src_frspos := src_control^.src_frspos;
                 src_lstpos := src_control^.src_lstpos;
                 src_flags := src_flags + [src_bmacroex] +
                 src_control^.src_flags * [src_bphys,src_linemode,
                                           src_listbyline,src_becho,src_echerr];
                 if GET_EVLFLAG( lpar ) and
                    (src_blist in src_control^.src_flags) then
                        src_flags := src_flags + [src_blist];
                 src_commentty := src_control^.src_commentty
               end;
               if md = 'S' then
               begin
                 lfile_spc := filespc;{ Set the list of string pointer }
                 lfile_typ := instring
               end
               else
                 lfile_typ := infiletyp;
               lfile_inp := src_p
             end
           end;

      'G',
      'D',
      'P',
      'U': begin { Binary Files }
             { set the file type }
             if (md = 'G') or (md = 'D') then
             begin
               f_state := [read_file];
               lfile_typ := inbintyp
             end
             else
             begin
               if md = 'U' then f_state := [write_file,unknown_file]
                           else f_state := [write_file];

               lfile_typ := outbintyp
             end;
             if md = 'D' then f_state := f_state + [del_file];
             OPEN( lfile_bin, fname, f_state );
             ierr := iostatus
           end;

      'E',
      'W',
      'N',
      'A': begin
             ipg := INTEVLDEF( lpar, 1 ); lst_p := nil;
             bunknown := (md = 'W');
             bappend  := (md = 'A');
             bprint   := false;
             if md = 'E' then
             begin { Virtual Output File }
               lst_p := LST_ALLOCATE;                           { Create a lst file context }
               with lst_p^ do
               begin
                 lst_flagsw := lst_flagsw + [lstf_virtual];     { Set the Virtual Mode }
                 NEW( lst_currline, 255 );
                 lst_rm := 132;                                 { Set the line size to 132 characters }
                 lst_lsthde := fileptr.nam                      { Set the link to the file atom }
               end
             end
             else
               { Real Output File }
               LST_OPEN( lst_p, fname, head, title, sbttl, 132, ipg,
                         bunknown, bprint, bappend, ierr );
             if ierr = 0 then
             begin
               if md = 'E' then
               begin
                 lfile_spc := filespc;                          { Set as atom to link this file }
                 lfile_typ := outstring
               end
               else
                 lfile_typ := outfiletyp;
               lfile_out := lst_p
             end
           end;

    otherwise
      { Illegal Mode }
      EXEC_ERROR( mdnam, 44, e_severe )
    end
  end;
  if ierr = 0 then
  begin
    with fileptr.lfile^ do
    { Set the appropriate opened file descriptor links }
    begin
      if lfile_first = nil then { For an empty opened file list set the file list }
        lfile_first := fileptr.lfile
      else { For a not empty opened file list link new file to the last one }
        lfile_last^.lfile_nxt := fileptr.lfile;
      { Set the backward pointer }
      lfile_prv    := lfile_last;
      { Init the forward pointer }
      lfile_nxt    := nil;
      { Set it as new last file }
      lfile_last   := fileptr.lfile
    end;
    if fileat.typ <> nullty then
    begin
      fileat.at^.val := fileptr;
      res.int := 0;
      res.typ := intty
    end
    else
      res := fileptr  
  end
  else
  begin
    res.typ := intty;
    res.int := ierr;
    if fileptr.lfile <> nil then DISPOSE( fileptr.lfile )
  end;
  F_OPEN := res
end F_OPEN;



[global]
function F_CLOSE( lfile: obj_ref ): obj_ref;
const
  mdnam = 'CLOS';

var
  fileptr: obj_ref;

begin
  if lfile.typ = lfilety then
    fileptr := lfile
  else
    if lfile.typ < atomety then
      EXEC_ERROR( mdnam, 45, e_severe )
    else
    begin
      fileptr := lfile.at^.val;
      lfile.at^.val := obj_nil;
      if fileptr.typ <> lfilety then EXEC_ERROR( mdnam, 45, e_error )
    end;

  with fileptr.lfile^ do
  begin
    case lfile_typ of
      infiletyp:
        begin
          if src_control = lfile_inp then { Restore the previous control line }
          begin
            src_control := main_src;

            if src_blist in src_control^.src_flags then
              { Notify the change of source file }
              COMPILE_SET_TITLE
          end;

          SRC_CLOSE( lfile_inp, true )   { Close the file and eliminate context }
        end;

      outfiletyp:
        begin
          if lst_current = lfile_out then
            { Restore the normal current output selection }
            lst_current := main_lst;
          LST_CLOSE( lfile_out, true )   { Close the listing file }
        end;

      instring:
        begin { just free the context and rest the atom }
          if src_control = lfile_inp then { Restore the previous control line }
            src_control := main_src;
          SRC_FREE( lfile_inp );
        end;

      outstring: { Just Free the Context and Remainder the Atom }
          if lst_current = lfile_out then
            { Restore the Normal Current Output Selection }
            lst_current := main_lst;

      inbintyp,
      outbintyp: CLOSE( lfile_bin );

    otherwise
      EXEC_ERROR( mdnam, 45, e_severe )
    end { case };

    { Update the Opened File List Forward Link }
    if lfile_prv <> nil then
      lfile_prv^.lfile_nxt := lfile_nxt
    else
      lfile_first := lfile_nxt;
    { Update the Opened File List Backward Link }
    if lfile_nxt <> nil then
      lfile_nxt^.lfile_prv := lfile_prv
    else
      lfile_last := lfile_prv;
    { Free the File Descriptor }
    DISPOSE( fileptr.lfile );
  end { end with ... };
  F_CLOSE := obj_nil
end F_CLOSE;



[global]
function F_EOF( fil: obj_ref ): obj_ref;
var
  lf:  lfile_ptr;
  res: boolean;

begin
  res := false;
  if fil.typ <> nullty then fil := F_EVAL( NXT_PAR( fil ) );
  if fil.typ = lfilety then
  { test for specified file }
  with fil.lfile^ do
  case lfile_typ of
    infiletyp: { Ascii input file }
      res := (src_eofrc in lfile_inp^.src_flags);

    inbintyp:  { Binary input file }
      res := EOF( lfile_bin );

  otherwise
    EXEC_ERROR( 'EOFF', 999, e_error )
  end
  else { Test for Standard Input File }
    res := (src_eofrc in src_control^.src_flags);
  F_EOF := log_val[res]
end F_EOF;



[global]
function F_EOLN( fil: obj_ref ): obj_ref;
var
  lf: lfile_ptr;
  res: boolean;

begin
  res := false;
  if fil.typ <> nullty then fil := F_EVAL( NXT_PAR( fil ) );
  if fil.typ = lfilety then
  { test for specified file }
  with fil.lfile^ do
    if lfile_typ = infiletyp then { Ascii input file }
      res := ([src_eoln,src_eofrc]*lfile_inp^.src_flags <> [])
    else EXEC_ERROR( 'EOLF', 999, e_error )
  else { Test for standard input file }
    res := ([src_eoln,src_eofrc]*src_control^.src_flags <> []);
  F_EOLN := log_val[res]    
end F_EOLN;



[global]
procedure F_CLOSE_ALL;
var
  ob: obj_ref;

begin
  ob.typ := lfilety;
  while lfile_first <> nil do
  begin
    ob.lfile := lfile_first;
    F_CLOSE( ob )
  end
end F_CLOSE_ALL;



[global]
function F_INPUT( lpar: obj_ref ): obj_ref;
const
  mdnam = 'INPU';

var
  fil: obj_ref;
  comment_md, fch, sch: char;
  nbins: integer;
  obpr, ob: obj_ref;
  inpmode: [static] obj_ref := ( ( und_funct, [] ), charty, 'I' );
  prompt: string( 64 );
  oldsrc: src_ptr;

begin
  fil  := F_EVAL( NXT_PAR( lpar ) );
  oldsrc := src_control; { Save the Current Source Pointer }
  ob     := obj_zero;
  { Get the prompt string }
  obpr := F_EVAL( NXT_PAR( lpar ) );
  comment_md := GET_CHAR( F_EVAL( NXT_PAR( lpar ) ) );
  nbins := INTEVLDEF( lpar, -1 );
  fch := GET_CHAR( F_EVAL( NXT_PAR( lpar ) ) );
  sch := GET_CHAR( F_EVAL( NXT_PAR( lpar ) ) );
  if fil.typ <> nullty then
  begin
    fil := CHECK_OPEN_FILE( fil, infiletyp );
    if fil.typ = lfilety then
    with fil.lfile^ do
    begin
      src_control := lfile_inp;         { Select this Input File }
{     If src_eoln in src_control^.src_flags then
        sy_ch := eol                    { Proceed to a read initialize }
{      else
        sy_ch := ' ' }
    end
  end else src_control := main_src;
  if oldsrc <> src_control then
  begin
    sy_ch_break := true;
    NEXT_CH
  end;

  with src_control^ do
  begin
    if not (src_macro in src_flags) then
    begin
      if obpr.typ <> nullty then
      begin
        if obpr.typ = truety then prompt.length := 0
                             else GET_STRING( prompt, obpr, '?' );
        if src_prompt <> nil then DISPOSE( src_prompt );
        NEW( src_prompt, prompt.length );
        src_prompt^ := prompt
      end;
      if (src_blist in src_flags) and
         (src_blist in oldsrc^.src_flags) and (oldsrc <> src_control) then
        COMPILE_SET_TITLE
    end;
    if comment_md > ' ' then
      case comment_md of
        'a','A': { for ADA comment }    src_commentty := src_adacomment;
        'c','C': { for C comment }      src_commentty := src_plicomment;
        'l','L': { for Lisp comment }   src_commentty := src_lispcomment;
        'n','N': { for no comment }     src_commentty := src_nocomment;
        'p','P': { for Pascal comment } src_commentty := src_pascomment
      otherwise
      end;
    if nbins <> -1 then src_insnb := nbins;
    if fch >= ' ' then src_fchcd := fch;
    if sch >= ' ' then src_schcd := sch
  end;
  F_INPUT := ob
end F_INPUT;



[global]
function F_OUTPUT( lpar: obj_ref ): obj_ref;
const
  mdnam = 'OUTP';

var
  fil: obj_ref;
  lns, pgs, plm, prm, prt: integer;
  ob: obj_ref;
  outmode: [static] obj_ref := ( ( und_funct, [] ), charty, 'N' );

begin
  fil  := F_EVAL( NXT_PAR( lpar ) );
  lns := INTEVLDEF( lpar, -1 );
  pgs := INTEVLDEF( lpar, -1 );
  prt := INTEVLDEF( lpar, -1 );
  plm := INTEVLDEF( lpar, -1 );
  prm := INTEVLDEF( lpar, -1 );
  ob  := obj_zero;
  if fil.typ <> nullty then
  begin
    fil := CHECK_OPEN_FILE( fil, outfiletyp );
    if fil.typ = lfilety then lst_current := fil.lfile^.lfile_out
  end else lst_current := main_lst;
  with lst_current^ do
  begin
    if lns <> -1 then lst_lnsize := lns;
    if pgs <> -1 then lst_pgsize := pgs;
    lst_flagsw := lst_flagsw + [lstf_print];
    if plm < 0 then plm := lst_lm;
    if prm < 0 then prm := lst_rm;
    if (plm <> lst_lm) or (prm <> lst_rm) then
      LST_SET_MARGIN( plm, prm )
  end;
  F_OUTPUT := ob
end F_OUTPUT;



[global]
function F_SET_OUT_HEAD( lpar: obj_ref ): obj_ref;
const
  mdnam = 'TITP';

var
  fil, head, title, sbttl: obj_ref;
  pts:                     body_s_ptr;
  lns:                     integer;
  lstp:                    lst_ptr := nil;
  scv:                     string( 16 );

begin
  fil   := F_EVAL( NXT_PAR( lpar ) );
  head  := F_EVAL( NXT_PAR( lpar ) );
  title := F_EVAL( NXT_PAR( lpar ) );
  sbttl := F_EVAL( NXT_PAR( lpar ) );
  if fil.typ <> nullty then fil := CHECK_OPEN_FILE( fil, outfiletyp );
  if fil.typ = nullty then
    lstp := main_lst
  else
    lstp := fil.lfile^.lfile_out;

  with lstp^ do
  begin
    if head.typ <> nullty then
    begin
      DISPOSE( lst_heading );
      if head.typ <> truety then
      begin
        GET_LISP_STR_REF( pts, lns, scv, head );
        if lns > 0 then
        begin
          NEW( lst_heading, lns );
          lst_heading^.length := lns;
          for i := 1 to lns do  lst_heading^.body[i] := pts^[i]
        end
      end
    end;
    if title.typ <> nullty then
    begin
      DISPOSE( lst_title );
      if title.typ <> truety then
      begin
        GET_LISP_STR_REF( pts, lns, scv, title );
        if lns > 0 then
        begin
          NEW( lst_title, lns );
          lst_title^.length := lns;
          for i := 1 to lns do  lst_title^.body[i] := pts^[i]
        end
      end
    end;
    if sbttl.typ <> nullty then
    begin
      DISPOSE( lst_sbttl );
      if sbttl.typ <> truety then
      begin
        GET_LISP_STR_REF( pts, lns, scv, sbttl );
        if lns > 0 then
        begin
          NEW( lst_sbttl, lns );
          lst_sbttl^.length := lns;
          for i := 1 to lns do  lst_sbttl^.body[i] := pts^[i]
        end
      end
    end
  end;
  F_SET_OUT_HEAD := obj_nil
end F_SET_OUT_HEAD;





{***************************************************}
{**************** End of IO Module *****************}
{***************************************************}


end.
